---
lang-ref: ch.10-2
lang: it
title: Apprendimento auto-supervisionato - ClusterFit e PIRL
lecturer: Ishan Misra
authors: Zhonghui Hu, Yuqing Wang, Alfred Ajay Aureate Rajakumar, Param Shah
date: 6 Apr 2020
translator: Marco Zullich
translation-date: 1 Aug 2020
---
<!-- Self-Supervised Learning - ClusterFit and PIRL -->


### [Cosa manca nei compiti di pretesto? La speranza della generalizzazione](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)

<!-- ### [What is missing from "pretext" tasks? The hope of generalization](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s) -->

I compiti di pretesto generalmente sono composti da delle fasi di pre-addestramento che sono auto-supervisionate, dopodiché abbiamo i nostri compiti di trasferimento che sono spesso o di classificazione o di riconoscimento. Si *spera* che i compiti di pre-addestramento e di trasferimento siano "allineati", ovvero la risoluzione dei compiti di pretesto aiuti sufficientemente bene nella risoluzione dei compiti di trasferimento. Di conseguenza, una buona parte della ricerca si concentra nella progettazione di compiti di pretesto e nella loro accurata implementazione.

<!-- Pretext task generally comprises of pretraining steps which is self-supervised and then we have our transfer tasks which are often classification or detection. We *hope* that the pretraining task and the transfer tasks are "aligned", meaning, solving the pretext task will help solve the transfer tasks very well. So, a lot of research goes into designing a pretext task and implementing them really well. -->

Tuttavia, è molto incerto il meccanismo con il quale l'effettuazione di un compito non-semantico dovrebbe produrre buone caratteristiche. Per esempio, per quale motivo dovremmo aspettarci di imparare qualcosa nel campo semantico mentre risolviamo qualcosa come il Puzzle (*Jigsaw*)? Oppure, per quale motivo ci si dovrebbe attendere che la "previsione degli *hashtag*" dalle immagini dovrebbe in qualche modo aiutare l'addestramento di un classificatore su compiti di trasferimento? Di conseguenza, la questione permane: come si devono progettare dei buoni compiti di pre-addestramento che siano in linea con i compiti di trasferimento?

<!-- However, it is very unclear why performing a non-semantic task should produce good features?. For example, why should we expect to learn about “semantics” while solving something like Jigsaw puzzle? Or why should “predicting hashtags” from images be expected to help in learning a classifier on transfer tasks? Therefore, the question remains. How should we design good pre-training tasks which are well aligned with the transfer tasks? -->

Si può "misurare" questo problema andando ad analizzare le rappresentazioni degli strati (si faccia riferimento alla Fig. 1). Se le rappresentazioni dell'ultimo strato non sono ben allineate con il compito di trasferimento, allora potrebbe darsi che il compito di pretesto non sia ben in linea con il compito da risolvere.

<!-- One way to evaluate this problem is by looking at representations at each layer (refer Fig. 1). If the representations from the last layer are not well aligned with the transfer task, then the pretraining task may not be the right task to solve. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>Fig. 1</b>: rappresentazioni delle caratteristiche in ogni strato
<!-- Feature representations at each layer -->
</center>

In Fig.2 è presente un grafico con la media della precisione media (*Mean Average Precision*) ad ogni strato per classificatori lineari sul dataset VOC07 utilizzando il pre-addestramento del Puzzle. È chiaro che l'ultimo strato è molto specializzato per il problema del Puzzle.

<!-- Fig. 2 plots the Mean Average Precision at each layer for Linear Classifiers on VOC07 using Jigsaw Pretraining. It is clear that the last layer is very specialized for the Jigsaw problem. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>Fig. 2</b>: performance del puzzle sulla base di ogni strato
<!-- Performance of Jigsaw based on each layer -->
</center>


### Che cosa vogliamo ottenere dalle caratteristiche pre-addestrate?

<!-- ### What we want from pre-trained features? -->

* Rappresentare come le immagini si relazionano fra di loro

  * ClusterFit: migliorare la generalizzazione delle rappresentazioni visive

* Essere robusti a "parametri di disturbo" -- Invarianza
  Ad esempio: invarianza alla posizione degli oggetti, all'illuminazione, ai colori esatti

  * PIRL: apprendimento auto-supervisionato di rappresentazioni invarianti al pretesto (PIRL, *Pre-text Invariant Representations Learning*)

<!-- * Represent how images relate to one another

  * ClusterFit: Improving Generalization of Visual Representations

* Be robust to "nuisance factors" -- Invariance

  E.g. exact location of objects, lighting, exact colour

  * PIRL: Self-supervised learning of Pre-text Invariant Representations -->

Due opzioni per apprendere le proprietà sopra descritte sono il **Clustering** e l'**Apprendimento Contrastivo**. Hanno iniziato a performare molto meglio di qualsiasi compito di pretesto progettato finora. Un metodo che appartiene al clustering è **ClusterFit**, mentre **PIRL** appartiene alla sfera delle invarianze.

<!-- Two ways to achieve the above properties are **Clustering** and **Contrastive Learning**. They have started performing much better than whatever pretext tasks that were designed so far.  One method that belongs to clustering is **ClusterFit** and another falling into invariance is **PIRL**. -->


## ClusterFit: migliorare la generalizzazione delle rappresentazioni visive

<!-- ## ClusterFit: Improving Generalization of Visual Representations -->

Partizionare lo spazio delle caratteristiche è un modo per vedere come le immagini si relazionano fra di loro.

<!-- Clustering the feature space is a way to see what images relate to one another. -->


### Il metodo

<!-- ### Method -->

ClusterFit segue due passaggi. Uno è il passaggio di partizione, l'altro è quello di previsione.

<!-- ClusterFit follows two steps.  One is the cluster step, and the other is the predict step. -->

#### *Clustering*: partizionamento delle caratteristiche

<!-- #### Cluster: Feature Clustering -->

Consideriamo una rete pre-addestrata (*Pre-trained Network*) e la usiamo per estrarre un gruppo di caratteristiche da un insieme d'immagini. Viene quindi applicato, su queste caratteristiche, un partizionamento utilizzando *K-means*, in modo tale che ogni immagine appartenga a uno e un solo *cluster*, il quale assume il ruolo di categoria (etichetta) dell'immagine stessa.

<!-- We take a pretrained network and use it to extract a bunch of features from a set of images. The network can be any kind of pretrained network. K-means clustering is then performed on these features, so each image belongs to a cluster, which becomes its label. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>Fig. 3</b>: passaggio di partizione o *clustering*
<!-- Cluster step -->
</center>


#### Previsione: predire l'assegnamento al *cluster*

<!-- #### Fit: Predict Cluster Assignment -->

Per questo passaggio, addestriamo una rete da zero ("*from scratch*"). Il suo compito è quello di prevedere la categoria di assegnazione delle immagini. Queste categorie, chiamate "pseudo-etichette" (*pseudo-labels*), sono quelle che abbiamo ottenuto nella prima fase attraverso il *clustering*.

<!-- For this step, we train a network from scratch to predict the pseudo labels of images. These pseudo labels are what we obtained in the first step through clustering. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>Fig. 4</b>: passaggio di previsione
<!-- Predict step -->
</center>

Un compito di pre-addestramento e trasferimento consiste, prima di tutto, nel pre-addestramento di una rete e nella sua successiva valutazione in un compito *downstream* (ovvero, un compito che la rete pre-addestrata non è stata addestrata a risolvere), come mostrato nella prima riga della Fig. 5. *ClusterFit* compie il pre-addestramento su un dataset $D_{cf}$ ad ottenere la rete pre-addestrata $N_{pre}$, le cui rappresentazioni vengono estrapolate per generare i *cluster*. Successivamente, s'impara una nuova rete $N_{cf}$ da zero su questi dati. Infine, utilizziamo $N_{cf}$ per tutti i compiti *downstream*.

<!-- A standard pretrain and transfer task first pretrains a network and then evaluates it in downstream tasks, as it is shown in the first row of Fig. 5. ClusterFit performs the pretraining on a dataset $D_{cf}$ to get the pretrained network $N_{pre}$. The pretrained network $N_{pre}$ are performed on dataset $D_{cf}$ to generate clusters. We then learn a new network $N_{cf}$from scratch on this data. Finally, use $N_{cf}$ for all downstream tasks. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>Fig. 5</b>: pre-addestramento "classico" VS. pre-addestramento "classico" + ClusterFit
<!-- "Standard" pretrain + transfer vs. "Standard" pretrain + ClusterFit -->
</center>


### Perche ClusterFit funziona

<!-- ### Why ClusterFit Works -->

Il motivo per cui ClusterFit funziona è che il passaggio di *clustering* cattura solo le informazioni essenziali, mentre gli artefatti sono scartati, facendo sì che la seconda rete apprenda qualcosa di leggermente più generico.

<!-- The reason why ClusterFit works is that in the clustering step only the essential information is captured, and artefacts are thrown away making the second network learn something slightly more generic. -->

Per capire questo punto, si opera un esperimento piuttosto semplice. Aggiungiamo del rumore a ImageNet-1K e addestriamo una rete sulla base di questo dataset. Dopodiché, valutiamo le rappresentazioni delle caratteristiche estratte da questa rete su un compito *downstream*, come ImageNet-9K. Come si può notare dalla Fig. 6, aggiungiamo svariati livelli di rumore ad ogni categoria (*label noise*) di ImageNet-1K e valutiamo la performance di trasferimento (*transfer*) di diversi metodi su ImageNet-9K.

<!-- To understand this point, a fairly simple experiment is performed.  We add label noise to ImageNet-1K, and train a network based on this dataset. Then, we evaluate the feature representation from this network on a downstream task on ImageNet-9K. As it is shown in Fig. 6, we add different amounts of label noise to the ImageNet-1K, and evaluate the transfer performance of different methods on ImageNet-9K. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>Fig. 6</b>: esperimento di controllo
<!-- Control Experiment -->
</center>

La linea rosa mostra la performance della rete pre-addestrata. La performance diminuisce all'aumentare del rumore. La linea blu rappresenta la distillazione (*distillation*) del modello, ovvero utilizziamo la rete iniziale e la utilizziamo per generare le etichette. La distillazione normalmente offre migliori performance rispetto alla rete pre-addestrata. La rete verde, rappresentante ClusterFit, è costantemente più alta rispetto alle altre due. Questi risultati validano la nostra ipotesi.

<!-- The pink line shows the performance of pretrained network, which decreases as the amount of label noise increases. The blue line represents model distillation where we take the initial network and use it to generate labels. Distillation generally performs better than pretrained network.  The green line, ClusterFit, is consistently better than either of these methods. This result validates our hypothesis. -->

* Domanda: perché comparare utilizzando la distillazione? Qual è la differenza fra la distillazione e ClusterFit?

<!-- * Question: Why use distillation method to compare. What's the difference between distillation and ClusterFit? -->

Nella distillazione consideriamo la rete pre-addestrata e usiamo le etichette che la rete ha predetto in una maniera più "tollerante" per generare etichette per le nostre immagini. Ad esempio, otteniamo una distribuzione su tutte le classi e usiamo questa distribuzione per addestrare la seconda rete. La distribuzione più permissiva aiuta a potenziare le classi iniziali a disposizione. In ClusterFit ignoriamo completamente lo spazio delle etichette (degli output).

<!-- In model distillation we take the pre-trained network and use the labels the network predicted in a softer fashion to generate labels for our images. For example, we get a distribution over all the classes and use this distribution to train the second network. The softer distribution helps enhance the initial classes that we have. In ClusterFit we don't care about the label space. -->


### Performance

Applichiamo questo metodo all'apprendimento auto-supervisionato. Qui dal metodo del Puzzle otteniamo la rete pre-addestrata $N_{pre}$ che poi utilizzeremo per ClusterFit. Dalla Fig. 7 vediamo che la performance di trasferimento su diversi dataset mostra un ammontare piuttosto sorprendente di guadagno in accuratezza rispetto ad altri metodi auto-supervisionati.

<!-- We apply this method to self-supervised learning. Here Jigsaw is applied to obtain the pretrained network $N_{pre}$ in ClusterFit. From Fig. 7 we see that the transfer performance on different datasets shows a surprising amount of gains, compared to other self-supervised methods. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>Fig. 7</b>: performance di trasferimento su diversi dataset
<!-- Transfer performance on different datasets -->
</center>

ClusterFit funziona su ogni rete pre-addestrata. Esempi di guadagno senza utilizzo ulteriore di dati, etichette o variazioni architettoniche possono essere visualizzati in Fig. 8. In un certo senso, potremmo pensare a ClusterFit come un metodo auto-supervisionato di affinamento (*fine-tuning*), a migliorare la qualità delle rappresentazioni.

<!-- ClusterFit works for any pre-trained network. Gains without extra data, labels or changes in architecture can be seen in Fig. 8. So in some way, we can think of the ClusterFit as a self-supervised fine-tuning step, which improves the quality of representation. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>Fig. 8</b>: guadagni in performance (*gains*) senza utilizzo di dati, etichette o variazioni architettoniche aggiuntivi
 <!-- Gains without extra data, labels or changes in architecture -->
</center>


## [Apprendimento auto-supervisionato di rappresentazioni di pretesto invarianti (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)

<!-- ## [Self-supervised Learning of Pretext Invariant Representations (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s) -->


### Apprendimento contrastivo (*Contrastive Learning*)

<!-- ### Contrastive Learning -->

In parole povere, l'apprendimento contrastivo è un *framework* generico per imparare uno spazio delle caratteristiche che possa avvicinare punti mutuamente correlati, allontanando contemporaneamente quelli che non lo sono.

<!-- Contrastive learning is basically a general framework that tries to learn a feature space that can combine together or put together points that are related and push apart points that are not related. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>Fig. 9</b>: gruppi d'immagini mutuamente correlate e non correlate
<!-- Groups of Related and Unrelated Images -->
</center>

In questo caso, s'immagini che i rettangoli della stessa tonalità siano mutuamente correlati (blu con blu, verdi con verdi, viola con viola).

<!-- In this case, imagine like the blue boxes are the related points, the greens are related, and the purples are related points. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>Fig. 10</b>: apprendimento contrastivo e funzione di perdita
<!-- Contrastive Learning and Loss Function -->
</center>

Le caratteristiche di ognuno di questi punti vengono estratte attraverso una rete condivisa (*shared network*) chiamata rete siamese (*Siamese Network*). Dopodiché, viene applicata una funzione di perdita contrastiva per provare a minimizzare la distanza fra i punti delle due categorie blu, anziché quella fra, ad esempio, una delle due categorie blu e una delle due categorie verdi. Detto in altre parole, la distanza fra le due categorie blu dovrebbe essere inferiore alla distanza fra i punti blu e i punti verdi o viola. Così facendo, lo spazio di proiezione di istanze correlate dovrebbe essere più vicino rispetto alle istanze non correlate. Questa è l'idea generale dell'apprendimento contrastivo e, naturalmente, Yann LeCun è stato uno dei primi professori a proporre questo metodo. Questa disciplina sta attraversando un periodo di rinascita nel campo dell'apprendimento auto-supervisionato, tant'è che tanti metodi allo stato dell'arte di questa categoria sono basati sull'apprendimento contrastivo.

<!-- Features for each of these data points would be extracted through a shared network, which is called Siamese Network to get a bunch of image features for each of these data points. Then a contrastive loss function is applied to try to minimize the distance between the blue points as opposed to, say, the distance between the blue point and the green point. Or the distance basically between the blue point should be less than the distance between the blue point and green point or the blue point and the purple point. So, embedding space from the related samples should be much closer than embedding space from the unrelated samples. So that's the general idea of what contrastive learning is and of course Yann was one of the first teachers to propose this method. So contrastive learning is now making a resurgence in self-supervised learning pretty much a lot of the self-supervised state of the art methods are really based on contrastive learning. -->


### Come definire la mutua correlazione?

<!-- ### How to define related or unrelated? -->

La principale questione è la definizione di mutua (non) correlazione. Nel caso di apprendimento supervisionato è chiaro che tutte le immagini, ad esempio, di cani sono correlate e qualsiasi immagine che non rappresenti un cane è incorrelata con quelle di cani. Non è tuttavia molto chiaro come definire la correlazione e la non correlazione nel caso dell'apprendimento auto-supervisionato. L'altra differenza principale rispetto ad un compito di pretesto è che l'apprendimento contrastivo ragiona in termini di grosse moli di dati passate al vaglio contemporaneamente. Se si osserva la funzione di perdita, questa coinvolge sempre più di un'immagine. Come da Fig. 10, nella prima riga considera le immagini dalle categorie blu e verdi, mentre nella seconda riga passa in consegna quelle dalle categorie blu e viola. Tuttavia, se si esamina un compito come il Puzzle o la Rotazione, si ragiona sempre al livello delle singole immagini considerate in maniera indipendente dalle altre. Questa è un'altra differenza dell'apprendimento contrastivo: quest'ultimo ragiona in termini di più dati presi in rassegna contemporaneamente.

<!-- And the main question is how to define what is related and unrelated. In the case of supervised learning that's fairly clear all of the dog images are related images, and any image that is not a dog is basically an unrelated image. But it's not so clear how to define the relatedness and unrelatedness in this case of self-supervised learning. The other main difference from something like a pretext task is that contrastive learning really reasons a lot of data at once.  If you look at the loss function, it always involves multiple images. In the first row it involves basically the blue images and the green images and in the second row it involves the blue images and the purple images. But as if you look at a task like say Jigsaw or a task like rotation, you're always reasoning about a single image independently. So that's another difference with contrastive learning: contrastive learning reasons about multiple data points at once. -->

Si potrebbero utilizzare tecniche simili rispetto a quanto discusso prima: *frame* di video o altri dati di natura sequenziale. *Frame* di un video che sono vicini dal punto di vista dell'ordine temporale si possono considerare come correlati, ad esempio, rispetto a *frame* lontani nel tempo; ciò ha posto le fondamenta di una miriade di metodi di apprendimento auto-supervisionato in quest'area. Questo metodo viene chiamato CPC (codificazione predittiva contrastiva, *Contrastive Predictive Coding*); esso si basa sulla natura sequenziale di un segnale e, sostanzialmente, assume che le istanze ravvicinate dal punto di vista sequenziale (ad esempio, spazio-temporale) siano correlate, mentre quelle distanti, secondo lo stesso criterio, siano incorrelate. Un grosso numero di lavori sfrutta quest'assunzione: si può lavorare sia nel campo audio, video, testuale, o particolari tipi d'immagine. E recentemente, abbiamo iniziato a lavorare su pezzi di video e audio considerati assieme: la traccia video e la sua traccia audio corrispondente sono istanze correlate, mentre una traccia video ed una audio provenienti da pezzi diversi sono istanze incorrelate.

<!-- Similar techniques to what was discussed earlier could be used: frames of video or sequential nature of data. Frames that are nearby in a video are related and frames, say, from a different video or which are further away in time are unrelated. And that has formed the basis of a lot of self- supervised learning methods in this area. This method is called CPC, which is contrastive predictive coding, which relies on the sequential nature of a signal and it basically says that samples that are close by, like in the time-space, are related and samples that are further apart in the time-space are unrelated. A fairly large amount of work basically exploiting this: it can either be in the speech domain, video, text, or particular images. And recently, we've also been working on video and audio so basically saying a video and its corresponding audio are related samples and video and audio from a different video are basically unrelated samples. -->


### Tracciamento di oggetti

<!-- ### Tracking Objects -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>Fig. 11</b>: tracciamento di oggetti
<!-- Tracking the Objects -->
</center>

Una parte dei lavori iniziale dell'apprendimento auto-supervisionato utilizza anch'esso le nozioni di apprendimento contrastivo. Questi lavori definiscono la nozione di istanze correlate in maniera piuttosto interessante. Si fa girare un tracciatore di oggetti su di un video: questo definisce una finestra mobile che segue determinati oggetti; si assume dunque che il contenuto iniziale di questa finestra è correlato al contenuto della finestra stessa, opportunamente mossa dal tracciatore, negli istanti successivi; si assume invece che non vi sia correlazione fra questa finestra e quelle di tracce video separate.

<!-- Some of the early work, like self-supervised learning, also uses this contrastive learning method and they really defined related examples fairly interestingly. You run a tracked object tracker over a video and that gives you a moving patch and what you say is that any patch that was tracked by the tracker is related to the original patch. Whereas, any patch from a different video is not a related patch. So that basically gives out these bunch of related and unrelated samples. In figure 11(c), you have this like distance notation. What this network tries to learn is basically that patches that are coming from the same video are related and patches that are coming from different videos are not related. In some way, it automatically learns about different poses of an object. It tries to group together a cycle, viewed from different viewing angles or different poses of a dog. -->


### Porzioni d'immagine vicine vs. lontane

<!-- ### Nearby patches *vs.* distant patches of an Image -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>Fig. 12</b>: porzioni (finestre) d'immagine vicine vs. porzioni d'immagine lontane
<!-- Nearby patches *vs.* distant patches of an Image -->
</center>

Generalmente, quando si parla d'immagini, una buona parte del lavoro viene speso nell'osservazione di porzioni (o finestre) d'immagine vicine e la contrapposizione con quelle lontane; molti metodi CPC di prima o seconda generazione di fatto sfruttano questa proprietà delle immagini. Le finestre vicine sono chiamate positive (*Positives*), mentre finestre lontane si traducono in negative (*Negatives*); l'obiettivo è minimizzare la perdita contrastiva usando queste definizioni di positività e negatività.

<!-- In general, talking about images, a lot of work is done on looking at nearby image patches versus distant patches, so most of the CPC v1 and CPC v2 methods are really exploiting this property of images. So image patches that are close are called as positives and image patches that are further apart are translated as negatives, and the goal is to minimize the contrastive loss using this definition of positives and negatives. -->


### Porzioni provenienti da un'immagine vs. provenienti da altre immagini

<!-- ### Patches of an image *vs.* patches of other images -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig13.png"
height="60%" width="60%"/><br><b>Fig. 13</b>: porzioni di un'immagine vs. porzioni di altre immagini
<!-- Patches of an Image vs. Patches of Other Images -->
</center>

Il metodo più popolare e performante di confrontare immagini diverse è considerare porzioni/finestre da un'immagine e metterle in contrasto con porzioni di un'altra immagine. Ciò forma le fondamenta di una serie di metodi popolari come discriminazione d'istanze, MoCo, PIRL, SimCLR. L'idea di base è di lavorare su quanto è mostrato nell'immagine. Andando nel dettaglio, questi metodi estraggono delle finestre casuali da un'immagine. Queste finestre possono essere sovrapposte, una contenuta dentro l'altra o completamente disgiunte; dopodiché, vi si applica qualche metodo di aumento dei dati, come variazioni o rimozione del colore, ad esempio. Dopodiché, si assume che queste due finestre siano positive. Un'altra finestra viene estratta casualmente da un'immagine differente; di nuovo, questa diviene un esempio negativo. Si estraggono molti di questi esempi e sostanzialmente si esegue un apprendimento contrastivo. Abbiamo due istanze positive, ma ce ne sono molte di negative con cui compiere l'apprendimento contrastivo.

<!-- The more popular or performant way of doing this is to look at patches coming from an image and contrast them with patches coming from a different image. This forms the basis of a lot of popular methods like instance discrimination, MoCo, PIRL, SimCLR. The idea is basically what's shown in the image. To go into more details, what these methods do is to extract completely random patches from an image. These patches can be overlapping, they can actually become contained within one another or they can be completely falling apart and then apply some data augmentation. In this case, say, a colour chattering or removing the colour or so on. And then these two patches are defined to be positive examples. Another patch is extracted from a different image. And this is again a random patch and that basically becomes your negatives. And a lot of these methods will extract a lot of negative patches and then they will basically perform contrastive learning. So there are relating two positive samples, but there are a lot of negative samples to do contrastive learning against. -->


### Principio sottostante i compiti di pretesto

<!-- ### Underlying Principle for Pretext Tasks -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>Fig. 14</b>: trasformazione di pretesto dell'immagine e apprendimento di pretesto standard
<!-- Pretext Image Transform and Standard Pretext Learning -->
</center>

Ora ci avviciniamo un po' di più a PIRL provando a comprendere qual è la differenza principale rispetto ai compiti di pretesto e come l'apprendimento contrastivo si distacca da questi ultimi. Di nuovo, i compiti di pretesto ragionano in termini di una singola immagine alla volta. L'idea è che, data un'immagine ed una precedente trasformazione di quest'ultima (in questo caso una trasformazione di tipo Puzzle), si dà in pasto questa immagine ad una rete convoluzionale e si provano a prevedere le proprietà della trasformazione (permutazione, rotazione, variazione/rimozione del colore) che è stata applicata. Il compito di pretesto ragiona sempre in termini di una singola immagine. Il secondo punto è che il compito che si sta svolgendo in questo caso deve cogliere delle proprietà della trasformazione, ovvero la vera permutazione o il tipo di rotazione applicate; ciò significa che la rappresentazione fornita dall'ultimo strato della rete (rappresentazioni che verranno fornite a PIRL) potrebbero variare parecchio al variare delle trasformazioni, e questa è una limitazione progettuale, in quanto si tratta di risolvere un compito specifico.
Sfortunatamente, ciò significa che la rappresentazione prodotta dall'ultimo strato cattura proprietà di bassissimo livello del segnale, ovvero concetti come rotazioni, laddove ciò che ci aspettiamo da queste rappresentazioni è che siano invarianti a queste proprietà, e che siano capaci di riconoscere concetti come un gatto, indipendentemente se quest'ultimo è dritto su quattro zampe, oppure piegato di 90 gradi verso un lato.
Quando invece si vuole apprendere uno specifico compito di pretesto, si sta imponendo alla rete l'esatto opposto, ovvero che essa dovrebbe essere in grado di riconoscere se un'immagine sia "dritta" o "piegata di lato". Ci sono molte eccezioni in cui si vuole che di fatto al rete sia co-variante a queste rappresentazioni di basso livello, e ciò dipende molto dal tipo di compito con cui si sta lavorando e molti compiti in 3D devono essere di tipo predittivo. Si vuole quindi predire che trasformazioni la videocamera può apportare, ad esempio, quando si sta comparando due prospettive dello stesso oggetto. Tuttavia, finché si considerano applicazioni di molti compiti di natura semantica, si vuole in realtà essere covarianti alle trasformazioni applicate all'input.

<!-- Now moving to PIRL a little bit, and that's trying to understand what the main difference of pretext tasks is and how contrastive learning is very different from the pretext tasks. Again, pretext tasks always reason about a single image at once.  So the idea is that given an image your and prior transform to that image, in this case a Jigsaw transform, and then inputting this transformed image into a ConvNet and trying to predict the property of the transform that you applied to, the permutation that you applied or the rotation that you applied or the kind of colour that you removed and so on. So the pretext tasks always reason about a single image. And the second thing is that the task that you're performing in this case really has to capture some property of the transform.
So it really needs to capture the exact permutation that are applied or the kind of rotation that are applied, which means that the last layer representations are actually going to go PIRL very a lot as the transform the changes and that is by design, because you're really trying to solve that pretext tasks. 
But unfortunately, what this means is that the last layer representations capture a very low-level property of the signal. They capture things like rotation or so on. Whereas what is designed or what is expected of these representations is that they are invariant to these things that it should be able to recognize a cat, no matter whether the cat is upright or that the cat is say,  bent towards like by 90 degrees.
Whereas when you're solving that particular pretext task you're imposing the exact opposite thing. We're saying that we should be able to recognize whether this picture is upright or whether this picture is basically turning it sideways. There are many exceptions in which you really want these low-level representations to be covariant and a lot of it really has to do with the tasks that you're performing and quite a few tasks in 3D really want to be predictive. So you want to predict what camera transforms you have: you're looking at two views of the same object or so on. But unless you have that kind of a specific application for a lot of semantic tasks, you really want to be invariant to the transforms that are used to use that input. -->


### Quanto importante è l'invarianza?

<!-- ### How important has invariance been? -->

L'importanza è stata la parola chiave dell'apprendimento di caratteristiche, come nell'esempio di SIFT, metodo "artigianale" per apprendere caratteristiche invarianti alla traslazione e alla scalatura. Le reti supervisionate, come AlexNet, sono addestrate ad essere invarianti all'aumento dei dati. Si vuole che queste reti classifichino diversi ritagli o rotazioni dell'immagine, piuttosto che predire quale specifica trasformazione vi sia stata applicata.

<!-- Invariance has been the word course for feature learning. Something like SIFT, which is a fairly popular handcrafted feature where we inserted here is transferred invariant. And supervise networks, for example, supervised Alex nets, they're trained to be invariant data augmentation. You want this network to classify different crops or different rotations of this image as a tree, rather than ask it to predict what exactly was the transformation applied for the input. -->


### PIRL

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>Fig. 15</b>: PIRL
</center>

Ciò ha ispirato PIRL. L'acronimo sta per *Pretext Invariant Representation Learning* (apprendimento delle rappresentazioni invariante al pretesto): l'idea è che si vuole che le rappresentazioni siano invarianti a trasformazioni dell'input, ovvero catturino la più piccola informazione possibile relativamente a queste trasformazioni.
Si ha un'immagine, ne si considera una trasformazione, si danno entrambe queste immagini come input di una rete convoluzionale, si ottengono due rappresentazioni e si forzano queste a essere simili. In termini più formali, l'immagine $I$ e ogni versione trasformata da compiti di pretesto $I^t$ sono istanze correlate; ogni altra immagine rappresenta un'istanza non correlata. Così facendo, si spera che le rappresentazioni ottenute tramite la rete contengano un'informazione minimale riguardo alla trasformazione $t$.
Assumiamo di utilizzare l'apprendimento contrastivo. Ciò consiste nel considerare le caratteristiche $v_I$ provenienti dall'immagine originaria $I$ e considerare le caratteristiche $v_{I^t}$ della versione trasformata: si vuole che entrambe queste rappresentazioni siano identiche. Nella precedente lezione abbiamo imparato due metodi allo stato dell'arte delle trasformazioni di pretesto, il Puzzle e il metodo di Rotazione. In un certo senso, questo è un apprendimento a più compiti (*multitask learning*), ma non stiamo cercando di predire entrambe le trasformazioni, stiamo cercando di esserne invarianti.

<!-- This is what inspired PIRL. So PIRL stands for pretext invariant representation learning, where the idea is that you want the representation to be invariant or capture as little information as possible of the input transform
.So you have the image, you have the transformed version of the image, you feed-forward both of these images through a ConvNet, you get a representation and then you basically encourage these representations to be similar. In terms of the notation referred earlier, the image $I$ and any pretext transformed version of this image $I^t$ are related samples and any other image is underrated samples. So in this way when you frame this network, representation hopefully contains very little information about this transform $t$. And assume you are using contrastive learning.
So the contrastive learning part is basically you have the saved feature $v_I$ coming from the original image $I$ and you have the feature $v_{I^t}$ coming from the transform version and you want both of these representations to be the same. And the book paper we looked at is two different states of the art of the pretext transforms, which is the jigsaw and the rotation method discussed earlier. In some way, this is like multitask learning, but just not really trying to predict both designed rotation. You're trying to be invariant of Jigsaw rotation. -->


### Utilizzo di un gran numero di negativi

<!-- ###  Using a Large Number of Negatives -->

Il concetto chiave che ha reso possibile il buon funzionamento dell'apprendimento contrastivo in passato è l'utilizzo di un grosso numero di esempi negativi. Uno dei *paper* che ha introdotto questo concetto è il *paper* sulla discriminazione delle istanze del 2018, che ha introdotto il concetto di "banco di memoria" (*memory bank*). Molti metodi allo stato dell'arte ruotano attorno all'idea del banco di memoria. Quest'ultimo rappresenta un modo carino di ottenere un grosso numero di negativi senza realmente richiedere un incremento della potenza computazionale. Si salva in memoria un vettore delle caratteristiche per immagine e si utilizza questo vettore nell'apprendimento contrastivo.

<!-- The key thing that has made contrastive learning work well in the past, taking successful attempts is using a large number of negatives. One of the good paper that introduced this was this instance discrimination paper from 2018, which introduced this concept of a memory bank. This is powered, most of the research methods which are state of the art techniques hinge on this idea for a memory bank. The memory bank is a nice way to get a large number of negatives without really increasing the sort of computing requirement. What you do is you store a feature vector per image in memory, and then you use that feature vector in your contrastive learning. -->


### Come funziona

<!-- ### How it works -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>Fig. 16</b>: come funziona il banco di memoria
<!-- How does the Memory Bank Work -->
</center>

Prima di tutto, parliamo di come si effettuerebbe il *setup* di PIRL senza l'utilizzo di un banco di memoria.
Si consideri un'immagine $I$ e un'immagine $I^t$, si diano in input entrambe alla rete ad ottenere un vettore delle caratteristiche $f(v_I)$ dall'immagine originaria $I$ e un vettore delle caratteristiche $g(v_I)$ dalla trasformata, in questo caso le porzioni d'immagine. Si vuole ottenere che le caratteristiche $f$ e $g$ siano simili, e che, al contempo, le caratteristiche di ogni altra immagine non correlata siano dissimili. In tal caso, ciò che possiamo fare è: se necessitiamo molti esempi negativi, si vuole che un numero molto alto di immagini negative venga dato contemporaneamente dato in input alla rete, con la conseguenza che la grandezza del *batch* diviene veramente molto grande, il che non è un aspetto del tutto positivo, soprattutto se la memoria della GPU è limitata.
Possiamo ovviare a ciò tramite l'utilizzo di un *c.d.* banco di memoria. Esso conserva un vettore delle caratteristiche per ogni immagine del dataset. <!-- Nota per il revisore: ho accorciato le frasi successive perché nella versione risultava molto pesante e banale -->
Quando, ad esempio, si necessita di applicare l'apprendimento contrastivo, sarà necessario semplicemente recuperare questo vettore dalla memoria, ricavando le caratteristiche delle immagini incorrelate.
Dividendo l'obiettivo in due parti, c'è un termine contrastivo per rendere l'immagine trasformata $g(v_I)$ simile alla rappresentazione che abbiamo in memoria, $m_I$. E, in maniera analoga, abbiamo una seconda rete convoluzionale contrastiva che cerca di rendere $f(v_I)$ simile alla rappresentazione in memoria. Essenzialmente, $g$ ed $f$ vengono entrambe "tirate" verso $m_I$, ovvero vengono rese simili fra di loro. La suddivisione dell'obiettivo in queste due parti, piuttosto che applicare direttamente l'apprendimento contrastivo fra $f$ e $g$, permette una stabilizzazione dell'addestramento. <!-- Nota per il revisore: ho semplificato un po' la parte finale che era un agglomerato di ripetizioni senza particolare senso. -->

<!-- 
Let's first talk about how you would do this entire PIRL setup without using a memory bank. So you have an image $I$ and you have an image $I^t$, and you feed-forward both of these images, you get a feature vector $f(v_I)$ from the original image $I$, you get a feature $g(v_{I^t})$ from the transform versions, the patches, in this case. What you want is the features $f$ and $g$ to be similar. And you want features from any other unrelated image to basically be dissimilar. In this case, what we can do now is if you want a lot of negatives, we would really want a lot of these negative images to be feed-forward at the same time, which really means that you need a very large batch size to be able to do this. Of course, a large batch size is not really good, if not possible, on a limited amount of GPU memory. The way to do that is to use something called a memory bank. 
So what this memory bank does is that it stores a feature vector for each of the images in your data set, and when you're doing contrastive learning rather than using feature vectors, say, from a different from a negative image or a different image in your batch, you can just retrieve these features from memory. You can just retrieve features of any other unrelated image from the memory and you can just substitute that to perform contrastive learning. Simply dividing the objective into two parts, there was a contrasting term to bring the feature vector from the transformed image $g(v_I)$, similar to the representation that we have in the memory so $m_I$. And similarly, we have a second contrastive ConvNet that tries to bring the feature $f(v_I)$ close to the feature representation that we have in memory. Essentially $g$ is being pulled close to $m_I$ and $f$ is being pulled close to $m_I$. By transitive, $f$ and $g$ are being pulled close to one another. And the reason for separating this outwards. It's stabilized training and we were not able to train without doing this. Basically, the training would not really converge. By separating this out into two forms, rather than doing direct contrastive learning between $f$ and $g$, we were able to stabilize training and actually get it working. -->


### Il pre-addestramento di PIRL

<!-- ### PIRL Pre-training -->

Si tratta di una configurazione standard per la valutazione del pre-addestramento. Per l'apprendimento per trasferimento, si può pre-addestrare sulle immagini senza annotazioni. Il modo classico per fare ciò è prendere una rete pre-addestrata su immagini, eliminare le annotazioni e lavorare come se si trattase di un apprendimento non-supervisionato.

<!-- The way to evaluate this is basically by standard pre-training evaluation set-up. For transfer learning, we can pretrain on images without labels. The standard way of doing this is to take an image net, throw away the labels and pretend as unsupervised. -->


### [Valutazione](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)

<!-- ### [Evaluation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s) -->

Si può quindi valutare il tutto tramite, ad esempio, un *fine-tuning* pieno oppure addestrando un classificatore lineare. Secondariamente, si testa PIRL e la sua robustezza alla distribuzione delle immagini addestrandolo ad immagini "allo stato brado": si prendono, ad esempio, 1 milione d'immagini scelte a caso da Flickr (dataset YFCC), si effettua un pre-addestramento su queste immagini e si "trapianta" su dataset diversi.

<!-- And then evaluating using, say, Full fine-tuning or using our training a linear classifier. The second thing we did was also our test PIRL and it's robustness to image distribution by training it on in-the-wild images. So we just took 1 million images randomly from Flickr, which is the YFCC data set. And then we basically performed pre-training on these images and then performed transplanting on different data sets. -->


#### Valutazione su compiti di riconoscimento di oggetti

<!-- #### Evaluating on Object Detection task -->

PIRL è stato prima di tutto valutato su compiti di riconoscimento di oggetti (un compito standard nella visione artificiale) e si è comportato meglio delle reti pre-addestramente in maniera supervisionata su ImageNet, sia sul dataset **VOC07+12** che su **VOC07**. Inoltre, PIRL ha dato migliori risultati persino nel criteri di valutazione più restrittivi, $AP^{all}$ e questo è un segnale positivo.

<!-- PIRL was first evaluated on object detection task (a standard task in vision) and it was able to outperform ImageNet supervised pre-trained networks on both **VOC07+12** and **VOC07** data sets. In fact, PIRL outperformed even in the stricter evaluation criteria, $AP^{all}$ and that's a good positive sign. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>Fig. 17</b>: performance nei compiti di riconoscimento di oggetti su diversi dataset
<!-- Object detection performance on different datasets -->
</center>


#### Valutazione su apprendimento auto-supervisionato

<!-- #### Evaluating on Semi-supervised Learning -->

PIRL è stato valutato su compiti di apprendimento auto-supervisionato. Nuovamente, si è comportato piuttosto bene, persino meglio dei compiti di pretesto come il Puzzle. La sola differenza è che PIRL è una versione invariante (rispetto a determinate trasformazioni), mentre il Puzzle ne è covariante.

<!-- PIRL was then evaluated on semi-supervised learning task. Again, PIRL performed fairly well. In fact, PIRL was better than even the pre-text task of Jigsaw. The only difference between the first row and the last row is that, PIRL is an invariant version, whereas Jigsaw is a covariant version. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>Fig. 18</b>: apprendimento auto-supervisionato su ImageNet
<!-- Semi-supervised learning on ImageNet -->
</center>


#### Valutazione su un classificatore lineare

<!-- #### Evaluating on Linear Classification -->

Quando PIRL è stato valutato su un classificatore lineare, le sue performance erano alla pari con CPCv2, quando questo è stato sviluppato. Funzionava bene anche con una serie di configurazioni dei parametri e con diverse architetture e, ovviamente, ora si possono ottenere performance decenti attraverso metodi come SimCLR o simili; infatti, l'accuratezza di SimCLR è attorno al 69-70%, mentre PIRL si attesta attorno al 63%.

<!-- Now when evaluating on Linear Classifiers, PIRL was actually on par with the CPCv2, when it came out. It also worked well on a bunch of parameter settings and a bunch of different architectures. And of course, now you can have fairly good performance by methods like SimCLR or so. In fact, the Top-1 Accuracy for SimCLR would be around 69-70, whereas for PIRL, that'd be around 63. -->


<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>Fig. 19</b>: classificazione su ImageNet con modelli lineari
<!-- ImageNet classification with linear models -->
</center>


#### Valutazione sulle immagini di YFCC

<!-- #### Evaluating on YFCC images -->

PIRL è stato valutato sulle immagini "allo stato brado" di Flickr dal dataset YFCC. È stato in grado di performare meglio del Puzzle, persino con dataset $100$ volte più piccoli. Ciò mostra la potenza di considerare l'invarianza per la rappresentazione nei compiti di pretesto, anziché prevedere semplicemente i compiti di pretesto.

<!-- PIRL was evaluated on *"In-the-wild" Flickr* images from the YFCC data set. It was able to perform better than Jigsaw, even with $100$ times smaller data set. This shows the power of taking invariance into consideration for the representation in the pre-text tasks, rather than just predicting pre-text tasks. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>Fig. 20</b>: pre-addestramento su immagini YFCC non modificate.
<!-- Pre-training on uncurated YFCC images -->
</center>


### Caratteristiche semantiche

<!-- ### Semantic Features -->

Ritornando a verificare le caratteristiche semantiche, diamo un'occhiata all'accuratezza del PIRL e del Puzzle per diversi livelli della rappresentazione, da `conv1` a `res5`. È interessante notare che l'accuratezza continua a migliorare per i diversi strati, sia per PIRL che per il Puzzle, ma, nel caso di quest'ultimo, peggiora nel quinto strato.

<!-- Now, going back to verifying the semantic features, we look at the Top-1 accuracy for PIRL and Jigsaw for different layers of representation from `conv1` to `res5`. It's interesting to note that the accuracy keeps increasing for different layers for both PIRL and Jigsaw, but drops in the 5th layer for Jigsaw. Whereas, the accuracy keeps improving for PIRL, i.e. more and more semantic. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>Fig. 21</b>: qualità della rappresentazione di PIRL, strato per strato
 <!-- Quality of PIRL representations per layer -->
</center>


### Scalabilità

<!-- ### Scalability -->

PIRL si comporta molto bene in relazione alla complessità del problema in quanto non si predice mai il numero di permutazioni, ma si utilizza quest'ultimo come input. Di conseguenza, PIRL può facilmente scalare su tutte le $362.880$ possibili permutazioni applicabili alle $9$ finestre, laddove, nel Puzzle, siccome si vogliono prevedere tali permutazioni, si è limitati dalla dimensione dello spazio di output.

<!-- PIRL is very good at handling problem complexity because you're never predicting the number of permutations, you're just using them as input. So, PIRL can easily scale to all 362,880 possible permutations in the 9 patches. Whereas in Jigsaw, since you're predicting that, you're limited by the size of your output space. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>Fig. 22</b>: conseguenza della variazione nel numero di permutazioni delle finestre (*patches*)
<!-- Effect of varying the number of patch permutations -->
</center>

Il paper *Misra & van der Maaten, 2019, PIRL*, mostra inoltre come PIRL potrebbe essere facilmente esteso ad altri compiti come il Puzzle, le rotazioni e via dicendo. In più, potrebbe persino essere esteso a combinazioni di questi compiti, come Puzzle + Rotazioni.

<!-- The paper "*Misra & van der Maaten, 2019, PIRL*" also shows how PIRL could be easily extended to other tasks like Jigsaw, Rotations  and so on. Further, it could even be extended to combinations of those tasks like Jigsaw+Rotation. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>Fig. 23</b>: utilizzo di PIRL con (combinazioni di) diversi compiti di pretesto
<!-- Using PIRL with (combinations of) different pretext tasks -->
</center>


### Invarianza vs performance

<!-- ### Invariance vs performance -->

Considerando le proprietà d'invarianza, si potrebbe, in linea di massima, dire che l'invarianza di PIRL sia maggiore rispetto a quella del Clustering, la cui invarianza è, a sua volta, maggiore rispetto ai compiti di pretesto. Analogamente, la performance di PIRL è maggiore di quella del Clustering, la cui performance è maggiore rispetto ai compiti di pretesto. Ciò suggerisce che considerare più invarianze potrebbe migliorare le performance.

<!-- In terms of invariance property, one could, in general, assert that the invariance of PIRL is more than that of the Clustering, which in turn has more invariance than that of the pretext tasks. And similarly, the performance to is higher for PIRL than Clustering, which in turn has higher performance than pretext tasks. This suggests that taking more invariance in your method could improve performance. -->


### Limitazioni

<!-- ### Shortcomings -->

1. Non è molto chiaro per quale insieme dei dati siano importanti le trasformazioni. Il Puzzle funziona, ma non è molto chiaro perché.
2. Vi è un effetto di saturazione all'aumentare della dimensione del modello o dei dati.
3. Quali invarianze sono importanti? (Si potrebbe pensare, come lavoro futuro, a quali invarianze funzionino per uno specifico compito supervisionato.)

In generale, bisognerebbe provare a predire sempre più informazione, provando al contempo ad essere più invarianti possibili.

<!-- 1. It's not very clear as to which set of data transforms matter. Although Jigsaw works, it's not very clear why it works.
1. Saturation with model size and data size.
2. What invariances matter? (One could think about what invariances work for a particular supervised task in general as future work.)

So in general, we should try to predict more and more information and try to be as invariant as possible. -->


## Chiarimenti importanti

<!-- ## Some important questions asked as doubts -->


### Apprendimento contrastivo e normalizzazione del *batch*

<!-- ### Contrastive learning and batch norms -->

1. Se si utilizza lo strato di normalizzazione del batch nell'apprendimento contrastivo, le rete non impara solamente una maniera banale di separare i positivi dai negativi (siccome l'informazione passa da un campione al successivo)?

**Risposta**: *In PIRL non è mai stato osservato un fenomeno di questo tipo, cosicché è stata utilizzata la normalizzazione del* batch *classica*.

<!-- 1. Wouldn't the network learn only a very trivial way of separating the negatives from the positives if the contrasting network uses the batch norm layer (as the information would then pass from one sample to the other)?

**Ans**: *In PIRL, no such phenomenon was observed, so just the usual batch norm was used* -->

2. È corretto quindi utilizzare la normalizzazione del *batch* in ogni rete contrastiva?

**Risposta**: *In generale, sì. In SimCLR si utilizza una variante della classica normalizzazione del* batch *per emulare grandi dimensioni del* batch. *Si potrebbe quindi pensare a qualche modifica per rendere l'addestramento più facile*.

<!-- 1. So is it fine to use batch norms for any contrasting networks?

**Ans**: *In general, yeah. In SimCLR, a variant of the usual batch norm is used to emulate a large batch size. So, batch norm with maybe some tweaking could be used to make the training easier* -->

3. La normalizzazione del *batch* funziona nel paper di PIRL solamente perché è implementata come banco di memoria, visto che tutte le rappresentazioni non vengono considerate contemporaneamente? (Visto che la normalizzazione del *batch* non è specificamente utilizzata nel paper di MoCo, per esempio).

**Risposta**: *Sì, in PIRL, lo stesso* batch *non contiene tutte le rappresentazioni e questo potrebbe spiegare perché funziona qui e non in altri compiti dove le rappresentazioni sono tutte correlate all'interno del* batch.

<!-- 1. Does the batch norm work in the PIRL paper only because it's implemented as a memory bank - as all the representations aren't taken at the same time? (As batch norms aren't specifically used in the MoCo paper for instance)

**Ans**: *Yeah. In PIRL, the same batch doesn't have all the representations and possibly why batch norm works here, which might not be the case for other tasks where the representations are all correlated within the batch* -->

4. Ci sono altre idee su come costruire altre funzioni di perdita calcolate su coppie di dati? Si deve forse utilizzare AlexNet o altre architetture che non hanno la normalizzazione del *batch*? Oppure c'è un modo di disattivare lo strato di normalizzazione del *batch*?

**Risposta**: *Generalmente i* frame *dei video sono correlati fra loro e la performance della normalizzazione del* batch *degrada quando vi sono autocorrelazioni. Inoltre, anche la più semplice implementazione di AlexNet utilizza la normalizzazione del* batch, *in quanto rende l'addestramento molto più stabile. Si potrebbe persino usare un livello di apprendimento maggiore e anche per altri compiti* downstream. *Si potrebbero utilizzare varianti della normalizzazione del* batch, *come ad esempio normalizzazione di gruppo per compiti di apprendimento video, poiché non dipendono dalla dimensione del* batch.

<!-- 1. So, other than memory bank, are there any other suggestions how to go about for n-pair loss? Should we use AlexNet or others that don't use batch norm? Or is there a way to turn off the batch norm layer? (This is for a video learning task)

**Ans**: *Generally frames are correlated in videos, and the performance of the batch norm degrades when there are correlations. Also, even the simplest implementation of AlexNet actually uses batch norm. Because, it's much more stable when trained with a batch norm. You could even use a higher learning rate and you could also use for other downstream tasks. You could use a variant of batch norm for example, group norm for video learning task, as it doesn't depend on the batch size* -->


### Funzioni di perdita di PIRL

<!-- ### Loss functions in PIRL -->

In PIRL, per quale motivo si utilizza NCE (Stimatore Contrastivo del Rumore, *Noise Contrastive Estimator*) per minimizzare la perdita e non solamente la probabilità negativa della distribuzione dei dati: $h(v_{I},v_{I^{t}})$?

**Risposta**: *Sinceramente, si potrebbero usare entrambi. Il motivo dell'utilizzo di NCE ha più a che fare col modo in cui il paper sul banco di memoria è stato configurato. Così, considerando $k+1$ negativi, si risolvono $k+1$ problemi binari. Si può anche farlo utilizzando un* softmax, *ovvero si applica il* softmax *e si minimizza la log-verosimiglianza negativa*.

<!-- 1. In PIRL, why is NCE (Noise Contrastive Estimator) used for minimizing loss and not just the negative probability of the data distribution: $h(v_{I},v_{I^{t}})$?

**Ans**: *Actually, both could be used. The reason for using NCE has more to do with how the memory bank paper was set up. So, with $k+1$ negatives, it's equivalent to solving $k+1$ binary problem. Another way of doing it is using a softmax, where you apply a softmax and minimize the negative log-likelihood* -->


### Self-supervised learning project related tips

Come si può far funzionare un semplice modello di apprendimento auto-supervisionato? Come si può iniziare con l'implementazione?

**Risposta**: *Ci sono delle classi di tecniche che sono utili per i compiti iniziali. Ad esempio, si potrebbe partire dai compiti di pretesto. La Rotazione è un compito semplice da implementare. Il numero di pezzi che si muovono è in generale un buon indicatore. Se si pianifica d'implementare un metodo esistente, bisogna guardare più attentamente i dettagli menzionati dall'autore, come l'esatto livello di apprendimento utilizato, il modo in cui le normalizzazioni del* batch *sono utilizzate, ecc. Più numerosi sono questi dettagli, più ardua è l'implementazione. La prossima cosa critica da considerare è l'aumento dei dati. Se qualcosa funziona, si continua incrementando l'aumento dei dati.*

<!-- How do we get a simple self-supervised model working? How do we begin the implementation?

**Ans**: *There are a certain class of techniques that are useful for the initial stages. For instance, you could look at the pretext tasks. Rotation is a very easy task to implement. The number of moving pieces are in general good indicator. If you're planning to implement an existing method, then you might have to take a closer look at the details mentioned by the authors, like - the exact learning rate used, the way batch norms were used, etc. The more number of these things, the harder the implementation. Next very critical thing to consider is data augmentation. If you get something working, then add more data augmentation to it.* -->


### Modelli generativi

Hai mai pensato di combinare modelli generativi con reti contrastive?

**Risposta**: *Generalmente, è una buona idea. Ma non è ancora stata implementata parzialmente perché è problematico e per niente banale addestrare questi modelli. Approcci integrativi sono più difficili da implementare, ma questa potrebbe essere una strada per il futuro.*

<!-- ### Generative models

Have you thought of combining generative models with contrasting networks?

**Ans**: *Generally, it's good idea. But, it hasn't been implemented partly because it is tricky and non-trivial to train such models. Integrative approaches are harder to implement, but perhaps the way to go in the future.* -->


### Distillazione

L'incertezza del modello non dovrebbe incrementare quando viene addestrata con delle etichette più "ricche" fornite da distribuzioni più "soffuse"?

**Risposta**: *Se si addestra il modello su annotazioni con codifiche* one-hot, *il modello tende ad essere troppo confidente. Alcuni metodi utilizzano tecniche come ammorbidimento delle annotazioni, che è una versione semplificata della distillazione in cui si prova a predire un vettore con codifica* one-hot. *Ora, anziché predire l'intero vettore, vi si estrae una massa di probabilità: anziché predire un uno e degli zeri, si predice ad esempio un $0,97$ e si aggiunge, ad esempio, $0,01$, $0,01$ e $0,01$ sulle altre componenti (in maniera uniforme). La distillazione è una maniera consapevole di fare ciò. Anziché aumentare casualmente le probabilità di un compito non correlato, si ha una rete pre-addestrata per fare ciò. Generalmente, distribuzioni più soffuse sono molto utili nei metodi di pre-addestramento. I modelli tendono ad essere troppo confidenti e le distribuzioni più soffuse sono più facili da addestrare e convergono più rapidamente. Questi benefici sono presenti nella distillazione.*


<!-- ### Distillation

Wouldn't the uncertainty of the model increase when richer targets are given by softer distributions? Also, why is it called distillation?

**Ans**: *If you train on one hot labels, your models tend to be very overconfident. Tricks like label smoothing are being used in some methods. Label smoothing is just a simple version of distillation where you are trying to predict a one hot vector. Now, rather than trying to predict the entire one-hot vector, you take some probability mass out of that, where instead of predicting a one and a bunch of zeros, you predict say $0.97$ and then you add $0.01$, $0.01$ and $0.01$ to the remaining vector (uniformly). Distillation is just a more informed way of doing this. Instead of randomly increasing the probability of an unrelated task, you have a pre-trained network to do that. In general softer distributions are very useful in pre-training methods. Models tend to be over-confident and so softer distributions are easier to train. They converge faster too. These benefits are present in distillation* -->
