---
lang-ref: ch.10-1
lang: it
title: Apprendimento auto-supervisionato - Compiti di pretesto
lecturer: Ishan Misra
authors: Aniket Bhatnagar, Dhruv Goyal, Cole Smith, Nikhil Supekar
date: 6 Apr 2020
translator: Marco Zullich
translation-date: 13 Jul 2020
---

## [Una storia di successo della supervisione: il pre-addestramento](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

<!-- ## [Success story of supervision: Pre-training](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s) -->

Nel decennio passato, una delle più grandi ricette del successo per svariati compiti di visione artificiale è stato l'apprendimento di rappresentazioni visive tramite l'esecuzione di tecniche di apprendimento supervisionato per la classificazione d'immagini del dataset ImageNet e usare queste rappresentazioni, o set di parametri già addestrati, come inizializzazione per altri compiti di visione artificiale laddove non fosse disponibile una grossa quantità di dati pre-catalogati.

<!-- In the past decade, one of the major success recipes for many different Computer Vision problems has been learning visual representations by performing supervised learning for ImageNet classification. And, using these learned representations, or learned model weights as initialization for other computer vision tasks, where a large quantum of labelled data might not be available. -->

Tuttavia, ottenere delle annotazioni per un dataset della grandezza di ImageNet è un'attività che consuma una quantità enorme di tempo. Ad esempio, l'etichettatura delle 14 milioni d'immagini di ImageNet è durata approssimativamente 22 anni.

<!-- However, getting annotations for a dataset of the magnitude of ImageNet is immensely time-consuming and expensive. Example: ImageNet labelling with 14M images took roughly 22 human years. -->

A causa di ciò. la comunità scientifica ha iniziato a cercare processi di etichettatura alternativi, come gli *hashtag* delle immagini dei *social media*, dati provenienti dai processi di geolocalizzazione GPS, oppure approcci auto-supervisionati dove l'etichetta si può immaginare come essere una proprietà intrinseca del campione di dati.

<!-- Because of this, the community started to look for alternate labelling processes, such as hashtags for social media images, GPS locations, or self-supervised approaches where the label is a property of the data sample itself. -->

Tuttavia, una domanda importante che ci si pone prima di cercare processi di catalogazione alternativi è:

<!-- But an important question that arises before looking for alternate labelling processes is: -->

**Quanti dati catalogati possiamo ottenere dopotutto?**

<!-- **How much labelled data can we get after all?** -->

- Se ricerchiamo tutte le immagini con categorie a livello dell'oggetto e con coordinate dei *bounding box* (*ndr*, rettangolo che indica la posizione dell'oggetto all'interno dell'immagine) allora ci sono circa un milione d'immagini con queste caratteristiche.
- Se il vincolo delle coordinate sui *bounding box* viene rilassato, si hanno a disposizione circa 14 milioni d'immagini.
- Tuttavia, se si considerano tutte le immagini disponibili in internet, si fa un salto di 5 ordini nella quantità di dati a disposizione.
- E, ancora, ci sono altri dati diversi dalle immagini, dati che richiedono altri input sensoriali per essere colti o compresi.

<!-- - If we search for all images with object-level category and bounding box annotations then there are roughly 1 million images.
- Now, if the constraint for bounding box coordinates is relaxed, the number of images available jumps to 14 million (approximately).
- However, if we consider all images available on the internet, there is a jump of 5 orders in the quantity of data available.
- And, then there is data apart from images, which requires other sensory input to capture or understand. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Fig. 1:</b> variazione nella complessità quantica base delle annotazioni
<!-- Variation in available data quantum basis complexity of annotation -->
</center>

Dunque, basandoci sul fatto che ad annotare le immagini del solo database di ImageNet si sono impiegati 22 anni di vita, scalare la categorizzazione a tutte le immagini disponibili in internet (o più di ciò) è un compito totalmente irrealistico.

<!-- Hence, drawing from the fact that ImageNet specific annotation alone took 22 human years worth of time, scaling labelling to all internet photos or beyond is completely infeasible. -->

**Il problema dei concetti rari** (o delle *code lunghe*)

<!-- **Problem of Rare Concepts** (*Long Tail Problem*) -->

Generalmente, il grafico che presenta la distribuzione delle annotazioni delle immagini di internet assomiglia ad una lunga coda. Ovvero, la maggior parte delle immagini è dotata di molto poche annotazioni, mentre esiste un grande numero di categorie in cui sono presenti poche immagini. Di conseguenza, ottenere campioni d'immagini annotate per le categorie alle fine della code richiede grosse quantità di dati da etichettare.

<!-- Generally, the plot presenting distribution of the labels for internet images looks like a long tail. That is, most of the images correspond to very few labels, while there exist a large number of labels for which not many images are present. Thus, getting annotated samples for categories towards the end of the tail requires huge quantities of data to be labelled [commenting out this redundant phrase]: <> (because of the nature of the distribution of categories). -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Fig. 2:</b> Variazione nella distribuzione della disponibilità in immagini annotate
<!-- Variation in distribution of available images with labels -->
</center>

**Il problema dei domini differenti**

<!-- **Problem of Different Domains** -->

Il metodo, prima descritto, consistente nell'effettuare un pre-addestramento su ImageNet per poi operare un affinamento (*fine-tuning*) sul compito d'interesse diventa ancora più oscuro quando questo compito appartiene a domini differenti, come le immagini mediche, per fare un esempio.
E, ottenere un dataset il cui ruolo di dataset "di riferimento" è analogo a quello di ImageNet, ma per domini differenti, è impossibile.

<!-- This method of ImageNet pre-training and fine-tuning on downstream task gets even murkier when the downstream task images belong to a completely different domain, such as medical imaging. And, obtaining a dataset of the quantum of ImageNet for pre-training for different domains is not possible. -->


<!-- ## What is self-supervised Learning? -->


## Che cos'è l'apprendimento auto-supervisionato?

**Due definizioni di apprendimento auto-supervisionato**

<!-- **Two ways to define self-supervised learning** -->

- **Definizione di base dell'apprendimento auto-supervisionato**, ovvero la rete è addestrata in maniera supervisionata, con le classificazioni effettuate in maniera semi-automatica, senza input umano.
- **Problema predittivo**, dove una parte dei dati è nascosta e i restanti sono visibili. Dunque, lo scopo è o di predire i dati nascosti o prevederne una determinata proprietà.


<!-- 
- **Basis supervised learning definition**, i.e. the network follows supervised learning where labels are obtained in a semi-automated manner, without human input.
- **Prediction problem**, where a part of the data is hidden, and rest visible. Hence, the aim is to either predict the hidden data or to predict some property of the hidden data. -->

**In cosa differiscono l'apprendimento auto-supervisionato e quello non supervisionato?**

<!-- **How self-supervised learning differs from supervised learning and unsupervised learning?** -->

- I compiti di apprendimento supervisionato prevedono l'esistenza di annotazioni/classificazioni predefinite (usualmente generate da umani)
- L'apprendimento non-supervisionato considera solamente le istanze dei dati senza alcuna supervisione, ovvero etichetta o indicazione sull'output corretto.
- L'apprendimento auto-supervisionato determina dette annotazioni da determinate modalità co-occorrenti nell'insieme dei dati o da parti degli stessi dati che co-occorrono all'interno del campione.

<!-- - Supervised learning tasks have pre-defined (and generally human-provided) labels,
- Unsupervised learning has just the data samples without any supervision, label or correct output.
- Self-supervised learning derives its labels from a co-occurring modality for the given data sample or from a co-occurring part of the data sample itself. -->


### Apprendimento auto-supervisionato nell'elaborazione automatica del linguaggio

<!-- ### Self-Supervised Learning in Natural Language Processing -->


#### Word2Vec

<!-- #### Word2Vec -->

- Data una frase di input, il compito consiste nel prevedere una parola mancante da tale frase. La parola è omessa con lo scopo specifico di creare un compito di pretesto.
- Dunque, l'insieme di annotazioni diviene tutte le possibili parole del vocabolario e l'annotazione corretta è la parola omessa dalla frase.
- Quindi, la rete può essere addestrata usando un classico metodo a gradiente per imparare le rappresentazioni al livello delle parole.

<!-- - Given an input sentence, the task involves predicting a missing word from that sentence, which is specifically omitted for the purpose of building a pretext task.
- Hence, the set of labels becomes all possible words in the vocabulary, and, the correct label is the word that was omitted from the sentence.
- Thus, the network can then be trained using regular gradient-based methods to learn word-level representations. -->


### Perché l'apprendimento auto-supervisionato?

<!-- ### Why self-supervised learning? -->

- L'apprendimento auto-supervisionato permette d'imparare rappresentazioni dei dati a partire dalle osservazioni su come differenti parti dei dati interagiscono fra di loro.
- Di conseguenza, viene meno il requisito di disporre di grosse quantità di dati annotati.
- In aggiunta a ciò, permette di considerare modalità multiple che potrebbero essere associate ad una singola istanza dei dati.


<!-- - Self-supervised learning enables learning representations of data by just observations of how different parts of the data interact.
- Thereby drops the requirement of huge amount of annotated data.
- Additionally, enables to leverage multiple modalities that might be associated with a single data sample. -->


### L'apprendimento auto-supervisionato nella visione artificiale

<!-- ### Self-Supervised Learning in Computer Vision -->

Usualmente, nella visione artificiale sono utilizzate delle *pipeline* che utilizzano tecniche di apprendimento auto-supervisionato. Queste tecniche sono composte in due parti: un compito di pretesto e un compito reale, denominato compito *downstream*.

- Il compito *downstream* può essere un compito qualsiasi, dalla classificazione all'individuazione di oggetti. La caratteristica è che si dispone di un numero insufficiente di dati annotati.
- Il compito di pretesto è il compito di apprendimento auto-supervisionato risolto per imparare le rappresentazioni visive, con lo scopo di applicare al compito *downstream* dette rappresentazioni (ovvero i pesi del modello) ottenute nel corso dell'addestramento.

<!-- Generally, computer vision pipelines that employ self-supervised learning involve performing two tasks, a pretext task and a real (downstream) task.

- The real (downstream) task can be anything like classification or detection task, with insufficient annotated data samples.
- The pretext task is the self-supervised learning task solved to learn visual representations, with the aim of using the learned representations or model weights obtained in the process, for the downstream task. -->


#### Lo sviluppo di compiti di pretesto

<!-- #### Developing pretext tasks -->

- I compiti di pretesto per la visione artificiale possono essere sviluppati usando immagini, video, o video con tracce audio.
- Per ogni compito di pretesto, vi è una parte visibile dei dati e una parte nascosta; il compito sta nel formulare previsioni riguardanti i gli stessi dati nascosti, oppure una proprietà di questi ultimi.

<!-- - Pretext tasks for computer vision problems can be developed using either images, video, or video and sound.
- In each pretext task, there is part visible and part hidden data, while the task is to predict either the hidden data or some property of the hidden data. -->


#### [Esempio di un compito di pretesto](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

<!-- #### [Example pretext tasks: Predicting relative position of image patches](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s) -->

- Input: 2 finestre di un'immagine, una agisce da riferimento (*anchor*), l'altra da termine d'interrogazione (*query*)
- Date le 2 finestre, la rete deve prevedere la posizione relativa della finestra di interrogazione nei confronti della posizione del riferimento
- Il problema può quindi essere modellato come una classificazione a 8 classi, essendovi 8 possibili posizioni della finestra d'interrogazione dato il riferimento.
- Le annotazioni per questo compito possono essere automaticamente generate dando in input la posizione relativa della finestra d'interrogazione rispetto al riferimento.

<!-- - Input: 2 image patches, one is the anchor image patch while the other is the query image patch.
- Given the 2 image patches, the network needs to predict the relative position of the query image patch with respect to the anchor image patch.
- Thus, this problem can be modelled as an 8-way classification problem, since there are 8 possible locations for a query image, given an anchor.
- And, the label for this task can be automatically generated by feeding the relative position of query patch with respect to the anchor. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Fig. 3:</b> Compito di posizionamento relativo
<!-- Relative Position task -->
</center>


#### Rappresentazioni visive apprese dal compito di previsione del posizionamento relativo

<!-- #### Visual representations learned by relative position prediction task -->

Possiamo valutare l'efficacia delle rappresentazioni visive apprese andando a controllare i vicini più vicini (*nearest neighbours*) di una data finestra d'immagine nello spazio delle caratteristiche apprese dalla rete. Per ottenere i vicini più vicini:

<!-- We can evaluate the effectiveness of the learned visual representations by checking nearest neighbours for a given image patch basis feature representations provided by the network. For computing nearest neighbours of a given image patch, -->

- Ottenere le caratteristiche dalla CNN per tutte le immagini del dataset: questo agirà da base per l'identificazione dei vicini.
- Ottenere le caratteristiche dalla CNN per la finestra d'immagine desiderata.
- Identificare il vicino più vicino per il vettore di caratteristiche dell'immagine richiesta, dall'insieme dei vettori di caratteristiche ottenuto, in prima battuta, dalle immagini disponibili.

<!-- - Compute the CNN features for all images in the dataset, that will act as the sample pool for retrieval.
- Compute CNN features for the required image patch.
- Identify nearest neighbours for the feature vector of the required image, from the pool of feature vectors of images available. -->

Il compito di posizionamento relativo trova finestre d'immagini che sono molto simili ad altre finestre dell'immagine di input, mantenendo al contempo invarianza a fattori come il colore degli oggetti. Di conseguenza, tale compito è in grado di imparare rappresentazioni visive, laddove finestre visivamente simili sono vicine anche nello spazio delle rappresentazioni.

<!-- Relative position task finds out image patches that are very similar to the input image patch, while maintains invariance to factors such as object colour. Thus, the relative position task is able to learn visual representations, where representations for image patches with similar visual appearance are closer in the representation space as well. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Fig. 4:</b> posizionamento relativo: vicini più vicini
<!-- Relative Position: Nearest Neighbours -->
</center>


#### Predire la rotazione d'immagini

<!-- #### Predicting Rotation of Images -->

- La previsione delle rotazioni è uno dei compiti di pretesto più popolari. Esso presenta un'architettura intuitiva e richiede un campionamento minimo.
- Applichiamo rotazioni di 0, 90, 180, 270 gradi all'immagine e diamo in input tutte queste immagini rotate alla rete per prevedere che tipo di rotazione è stata applicata all'immagine; la rete produce dunque una classificazione in 4 classi per prevedere la rotazione.
- Prevedere le rotazioni non ha alcun significato semantico, stiamo solo usando questo compito come un pretesto per apprendere alcune caratteristiche e rappresentazioni da utilizzare in un compito *downstream*.

<!-- 
- Predicting rotations is one of the most popular pretext task which has a simple and straightforward architecture and requires minimal sampling.
- We apply rotations of 0, 90, 180, 270 degrees to the image and send these rotated images to the network to predict what sort of rotation was applied to the image and the network simply performs a 4-way classification to predict the rotation.
- Predicting rotations does not make any semantic sense, we are just using this pretext task as a proxy to learn some features and representations to be used in a downstream task. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Fig. 5:</b> rotazioni di immagini
<!-- Rotations of Image -->
</center>


#### Perché le rotazioni sono d'aiuto, come funziona?

<!-- #### Why rotation helps or why it works? -->

È stato provato che questo compito funziona in maniera empirica. L'intuizione dietro esso è che, per prevedere le rotazioni, il modello necessita di comprendere i confini grezzi e le rappresentazioni di un'immagine. Ad esempio, dovrà distinguere il cielo dall'acqua o l'acqua dalla sabbia o dovrà comprendere che gli alberi crescono all'insù e così via.

<!-- It has been proven that it works empirically. The intuition behind it is that in order to predict the rotations, model needs to understand the rough boundaries and representation of an image. For example, it will have to segregate the sky from water or sand from the water or will understand that trees grow upwards and so on. -->


#### Colorazione

<!-- #### Colourisation -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Fig. 6:</b> colorazione
<!-- Colourisation -->
</center>

In questo compito di pretesto, prevediamo i colori data un'immagine in scala di grigi. Può essere formulato per un'immagine: semplicemente si rimuove il colore e si dà quest'immagine in scala di grigi alla rete per predirne i colori. Il compito è utile ad esempio nella colorazione di vecchi filmati in bianco e nero. L'intuizione dietro questo compito è che la rete deve comprendere informazioni utili come il fatto che gli alberi sono verdi, il cielo è blu e così via.

È importante notare che la mappatura dei colori non è deterministica e che vi sono diverse soluzioni possibili. Così, se per un oggetto vi sono svariati possibili colori, allora la rete lo colorerà di grigio, ovvero la media di tutte le possibili soluzioni. Vi sono stati lavori recenti che utilizzano *Autoencoder* variazionali e variabili latenti per diversi colori.

<!-- In this pretext task, we predict the colours of a grey image. It can be formulated for any image, we just remove the colour and feed this greyscale image to the network to predict its colour. This task is useful in some respects like for colourising the old greyscale films [//]: <> (we can apply this pretext task). The intuition behind this task is that the network needs to understand some meaningful information like that the trees are green, the sky is blue and so on.

It is important to note that colour mapping is not deterministic, and several possible true solutions exist. So, for an object if there are several possible colours then the network will colour it as grey which is the mean of all possible solutions. There have been recent works using Variational Auto Encoders and latent variables for diverse colourisation. -->


#### Riempire i buchi

<!-- #### Fill in the blanks -->

Si nasconde una porzione dell'immagine e si predice la parte occultata dalla restante parte d'immagine. Questo funziona perché la rete imparerà la struttura implicita dei dati; ad esempio come rappresentare il fatto che le macchine si trovano sulle strade, che gli edifici sono composti da finestre e porte e così via.

<!-- We hide a part of an image and predict the hidden part from the remaining surrounding part of the image. This works because the network will learn the implicit structure of the data like to represent that cars run on roads, buildings are composed of windows & doors and so on. -->


### Compiti di pretesto per video

<!-- ### Pretext Tasks for videos -->

I video sono composti di sequenze di *frame* e questa nozione è l'idea di fondo dell'auto-supervisione. Essa può essere utilizzata a proprio favore per alcuni compiti di pretesto come prevedere l'ordine dei *frame*, riempire i buchi e tracciamento di oggetti.

<!-- Videos are composed of sequences of frames and this notion is the idea behind self-supervision, which can be leveraged for some pretext tasks like predicting the order of frames, fill in the blanks and object tracking. -->


#### Mescola e Impara (*Shuffle & Learn*)

<!-- #### Shuffle & Learn -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Fig. 7:</b> interpolazione
<!-- Interpolation -->
</center>

Dato un insieme di *frame*, ne estraiamo casualmente tre: se sono estratti nell'ordine corretto, etichettiamo il campione come positivo; se sono mescolati, lo etichettiamo come negativo. Questo diviene un problema di classificazione binaria: prevedere se i *frame* sono in ordine corretto oppure no. Ovvero, dato un *frame* di partenza e di destinazione, verifichiamo se quello di mezzo è un'interpolazione valida dei due.

<!-- Given a bunch of frames, we extract three frames and if they are extracted in the right order we label it as positive, else if they are shuffled, label it as negative. This now becomes a binary classification problem to predict if the frames are in the right order or not. So, given a start and end point, we check if the middle is a valid interpolation of the two. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Fig. 8:</b> architettura per "Mescola e Impara"
<!-- Shuffle & Learn architecture -->
</center>

Possiamo usare un trio di reti siamesi, dove i tre *frame* sono indipendentemente dati in input alla rete; dopodiché, concateniamo le caratteristiche generate ed effettuiamo una classificazione binaria per predire se i *frame* sono mescolati oppure no.

<!-- We can use a triplet Siamese network, where the three frames are independently fed forward and then we concatenate the generated features and perform the binary classification to predict if the frames are shuffled or not. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Fig. 9:</b> rappresentazione dei vicini più vicini
<!-- Nearest Neighbours Representation -->
</center>

Nuovamente, possiamo usare l'algoritmo dei vicini più vicini per visualizzare che cosa sta imparando la nostra rete. Nella Fig. 9 qui sopra, innanzitutto abbiamo un *frame* d'interrogazione (*Query*) che diamo in input alla rete ad ottenere la rappresentazione, dopodiché guardiamo i vicini più vicini nello spazio delle rappresentazioni. Effettuando la comparazione, possiamo osservare una netta differenza fra i vicini ottenuti da ImageNet, Mescola e Impara e casualmente (*Random*).

<!-- Again, we can use the Nearest Neighbours algorithm to visualize what our networks are learning. In fig. 9 above, first we have a query frame which we feed-forward to get a feature representation and then look at the nearest neighbours in the representation space. While comparing, we can observe a stark difference between neighbours obtained from ImageNet, Shuffle & Learn and Random. -->

ImageNet funziona bene nel collassare interamente le semantiche, giacché è in grado di identificare che si tratta di una scena di una palestra per quanto riguarda il primo input. Similarmente, è in grado di riconoscere che è una scena all'aperto con erba ecc. per la seconda interrogazione. Osservando i vicini casuali (*Random*), possiamo notare che viene data molta importanza al colore dello sfondo.

<!-- ImageNet is good at collapsing the entire semantic as it could figure out that it is a gym scene for the first input. Similarly, it could figure out that it is an outdoor scene with grass etc. for the second query. Whereas, when we observe Random we can see that it gives high importance to the background colour. -->

Osservando Mescola e Impara, non è immediatamente chiaro se la rete si focalizzi sul colore o sui concetti semantici. Dopo ulteriori analisi su vari esempi, è stato osservato che si sta focalizzando sulla posa delle persone: ad esempio, nella prima immagine la persona è a testa in giù e, nella seconda, i piedi si trovano in una posizione specifica analoga al *frame* d'interrogazione; vengono ignorati la scena e il colore di sfondo. Il ragionamento sottostante è che il compito di pretesto era di prevedere se i *frame* si trovavano nell'ordine corretto oppure no, e per fare ciò la rete deve focalizzarsi su ciò che nella scena si sta muovendo: in tal caso, la persona.

<!-- On observing Shuffle & Learn, it is not immediately clear whether it is focusing on the colour or on the semantic concept. After further inspection and observing various examples, it was observed that it is looking at the pose of the person. For example, in the first image the person is upside down and in second the feet are in a particular position similar to query frame, ignoring the scene or background colour. The reasoning behind this is that our pretext task was predicting whether the frames are in the right order or not, and to do this the network needs to focus on what is moving in the scene, in this case, the person. -->

È stato verificato in maniera quantitativa, attraverso il *fine-tuning* (affinamento) della rappresentazione per il compito della stima dei punti chiave umani, dove data un'immagine umana bisogna prevedere la posizione di determinati punti chiave (come il naso, la spalla sinistra, la spalla destra, i gomiti sinistro e destro, ecc.), che questo metodo è utile per il tracciamento e la stima della posa umana. 

<!-- It was verified quantitatively by fine-tuning this representation to the task of human key-point estimation, where given a human image we predict where certain key points like nose, left shoulder, right shoulder, left elbow, right elbow, etc. are. This method is useful for tracking and pose estimation. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Fig. 10:</b> Paragone della stima dei punti chiave
<!-- Key point Estimation comparison -->
</center>

Nella Fig. 10, sono comparati i risultati, per quanto riguarda la stima dei punti chiave, di ImageNet supervisionato e di Impara e Mescola auto-supervisionato sui dataset FLIC e MPII; possiamo vedere come Impara e Mescola dia dei buoni risultati.

<!-- In figure 10, we compare the results for supervised ImageNet and Self-Supervised Shuffle & Learn on FLIC and MPII datasets and we can see that Shuffle and Learn gives good results for key point estimation. -->


### Compiti di pretesto per video con audio

<!-- ### Pretext Tasks for videos and sound -->

I video con audio sono dati multimodali, ovvero vi sono due modalità o input sensoriali, una per il video, l'altra per il suono. Si cerca di prevedere la corrispondenza di una data traccia video ad una data traccia audio.

<!-- Video and Sound are multi-modal where we have two modalities or sensory inputs one for video and one for sound. Where we try to predict whether the given video clip corresponds to the audio clip or not. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Fig. 11:</b> campionamento video e audio
<!-- Video and sound sampling -->
</center>

Data una traccia audio/video di una batteria, si campiona un *frame* video con la sua corrispondente traccia audio: si definisce che questa coppia appartiene ad un insieme positivo. Dopodiché, si prende l'audio di una batteria e lo si accoppia ad un *frame* video di una chitarra: questa coppia appartiene ad un insieme negativo. Addestriamo una rete a risolvere questo problema di classificazione binaria.

<!-- Given a video with audio of a drum, sample the video frame with corresponding audio and call it a positive set. Next, take the audio of a drum and the video frame of a guitar and tag it as a negative set. Now we can train a network to solve this as a binary classification problem. -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Fig. 12:</b> architettura
<!-- Architecture -->
</center>

**Architettura:** i *frame* video vengono passati alla sottorete della visione (*vision subnetwork*), la traccia del suono alla sottorete dell'auto (*audio subnetwork*). Entrambe le reti producono una rappresentazione 128-dimensionale. Le due rappresentazioni vengono quindi fuse assieme per risolvere il problema di classificazione binaria concernente la (non) corrispondenza fra le due tracce.

Questa rete può essere utilizzata per prevedere che cosa in quel frame sta producendo un suono. L'intuizione è che, se il suono è prodotto da una chitarra, la rete deve imparare, a grandi linee, come la chitarra è fatta; lo stesso deve valere per la batteria.

<!-- **Architecture:** Pass the video frames to the vision subnetwork and pass the audio to the audio subnetwork, which gives 128-dimensional features and embeddings, we then fuse them together and solve it as a binary classification problem predicting if they correspond with each other or not.

It can be used to predict what in the frame might be making a sound. The intuition is if it is the sound of a guitar, the network roughly needs to understand how the guitar looks and same should be true for drums. -->


## [Comprendere che cosa viene imparato dal compito di "pretesto"](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

<!-- ## [Understanding what the "pretext" task learns](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s) -->

* I compiti di pretesto dovrebbero essere **complementari**

<!-- * Pretext tasks should be **complementary** -->
  * Prendiamo come esempio i compiti di pretesto "Posizionamento relativo" e "Colorazione". Possiamo migliorarne le performance addestrando un modello ad imparare entrambi i compiti di pretesto, come mostrato di sotto:
  <!-- * Let's take for example the pretext tasks *Relative Position* and *Colourisation*. We can boost performance by training a model to learn both pretext tasks as shown below: -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Fig. 13:</b> paragone di addestramento disgiunto vs combinato per i compiti di pretesto "Posizionamento relativo" e "Colorazione". ResNet101. (Misra)
<!-- Comparison of disjoint vs combined training of Relative Position and Colourisation pretext tasks. ResNet101. (Misra) -->
</center>

* Un singolo compito di pretesto potrebbe non essere la soluzione giusta per imparare le rappresentazioni

  <!-- * A single pretext task may not be the right answer to learn SS representations -->

* Vi è molta variabilita a livello di difficoltà in ciò che i compiti di pretesto cercano di prevedere

<!-- * Pretext tasks vary greatly in what they try to predict (difficultly) -->

  * "Posizione relativa" è una semplice classificazione
  * "Riempire i buchi" è molto più difficile (vengono apprese **migliori rappresentazioni**)
  * I **metodi contrastivi** generano ancora più informazione dei compiti di pretesto

  <!-- * Relative position is easy since it's a simple classification
  * Masking and fill-in is far harder **better representation**
  * **Contrastive methods** generate even more info than pretext tasks -->

* **Domanda**: come si addestrano più compiti di pretesto contemporaneamente?

  * L'output dipende dall'input. Lo strato densamente connesso della rete può essere **scambiato** dipendentemente dal tipo del *batch*.
  * Ad esempio: un *batch* d'immagini in bianco e nero è passato ad una rete con lo scopo di produrre un'immagine a colori. Lo strato finale è cambiato in base al nuovo compito (ad esempio, prevedere la posizione relativa) <!-- nota per il revisore: ho cambiato un po' la frase perché in quella EN si capiva veramente poco il senso. -->

<!-- * **Question:** How do we train multiple pre-training tasks?

  * The pretext output will depend on the input. The final fully-connected layer of the network can be **swapped** depending on the batch type.
  * For example: A batch of black-and-white images is fed to the network in which the model is to produce a coloured image. Then, the final layer is switched, and given a batch of patches to predict relative position. -->

<!-- nota per il revisore: cosa vuol dire la frase qui sotto???? -->

<!-- *  **Question:** How much should we train on a pretext task?

  * Rule of thumb: Have a very difficult pretext task such that it improves the downstream task.
  * In practice, the pretext task is trained, and may not be re-trained. In development, it is trained as part of the entire pipeline. -->


<!-- ## Scaling Self-Supervised Learning -->

## Scalare l'addestramento auto-supervisionato


### Tecnica del Puzzle

<!-- ### Jigsaw Puzzles -->

* Si partiziona un'immagine in più caselle e si mescolano queste ultime. Il compito del modello è quello di ri-mescolare le caselle a formare la configurazione originale dell'immagine (Noorozi & Favaro, 2016).
  
  * Si prevede quale permutazione è stata applicata all'input
  * Ciò viene effettuato creando dei *batch* di caselle in modo tale che **ogni casella di un'immagine viene valutata indipendentemente**. Gli output delle reti <!-- nota per il revisore: ho sostituito convoluzioni con reti, in quanto, da fig. 14, si evince come le reti non siano fully-convolutional e quindi gli output non sono prodotto di mere convoluzioni+nonlinearità ma di una rete vera e propria --> sono quindi concatenati e la permutazione viene prevista come dalla figura sotto.

<!-- * Partition an image into multiple tiles and then shuffle these tiles. The model is then tasked with un-shuffling the tiles back to the original configuration. (Noorozi & Favaro, 2016)

  * Predict which permutation was applied to the input
  * This is done by creating batches of tiles such that **each tile of an image is evaluated independently**. The convolution output are then concatenated and the permutation is predicted as in figure below -->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Fig. 14:</b> architettura di rete siamese per un compito di pretesto del tipo Puzzle. Ogni casella è valutata indipendentemente, e le codifiche sono concatenate a prevedere una permutazione. (Misra)
<!-- Siamese network architecture for a Jigsaw pretext task. Each tile is passed through independently, with encodings concatenated to predict a permutation. (Misra) -->
</center>

  * Considerazioni:
    1. Usare un sottoinsieme di tutte le possibili permutazioni (es.: se si dispongono $9!$ permutazioni, se ne usino 100)
    2. Le reti convoluzionali a n vie utilizzano parametri condivisi
    3. La complessità del problema coincide con la dimensione del sottoinsieme, l'*ammontare d'informazione che si sta prevedendo*

<!-- * Considerations:
    1. Use a subset of permutations (i.e.: From 9!, use 100)
    2. The n-way ConvNet uses shared parameters
    3. The problem complexity is the size of the subset. The *amount of information you are predicting.* -->

* A volte, questo metodo può dare performance migliori sui compiti *downstream* rispetto ai metodi supervisionati, in quanto la rete è in grado di imparare alcuni concetti relativi alla geometria dell'input.

<!-- * Sometimes, this method can perform better on downstream tasks than supervised methods, since the network is able to learn some concepts about the geometry of its input. -->

* Difetti: apprendimento *few shot*: numero limitato di esempi di addestramento

<!-- * Shortcomings: Few Shot Learning: Limited number of training examples -->
  * **Le rappresentazioni ottenute tramite apprendimento auto-supervisionato non sono efficienti dal punto di vista del campionamento**
  <!-- * **Self-supervised representations are not as sample efficient** -->


### Valutazione: affinamento vs classificazione lineare

<!-- ### Evaluation: Fine-tuning vs Linear Classifier -->

Questa forma di valutazione è una specie di **Apprendimento per trasferimento**.

  <!-- This form of evaluation is a kind of **Transfer Learning**. -->

* **Affinamento**  (*fine-tuning*): per risolvere il compito *downstream*, si utilizza un'intera rete pre-addestrata come **inizializzazione**. Questa rete viene addestrata in toto, aggiornandone i pesi.

* **Classificazione lineare**: in cima alla rete di pretesto, si addestra un piccolo classificatore lineare per portare a fine il compito *downstream*, lasciando intatto il resto della rete.

<!-- * **Fine Tuning**: When applying to our downstream task, we use our entire network as an **initialization** for which to train a new one, updating all the weights.

* **Linear Classifier**: On top of our pretext network, we train a small linear classifier to perform our downstream task, leaving the rest of the network intact. -->

> Una buona rappresentazione dovrebbe trasferirsi con **poco apprendimento**.

<!-- > A good representation should transfer with a **little training**. -->

* È di aiuto valutare il compito di pretesto su una **moltitudine di compiti differenti**. Possiamo farlo estraendo le rappresentazioni create da diversi strati della rete, trattando queste rappresentazioni come **caratteristiche fisse** e andando a valutare la loro utilità attraverso questi compiti di diversa natura:
  * Misurazione: *Mean Average Precision* (MAP) -- La media della precisione attraverso tutti i compiti considerati.
  * Alcuni esempi di questi compiti: riconoscimento di oggetti (*object recognition*) utilizzando l'affinamento, stima della superficie (*Surface Normal Estimation* -- si veda il dataset NYU-v2).
* Che cosa viene appreso da ogni strato?
  * Generalmente, più profondo è lo strato all'interno della rete, più alta è la MAP dei compiti *downstream* portati a termine utilizzando le rappresentazioni dello stesso strato.
  * Tuttavia, sullo **strato finale** si noterà un calo notevole nella MAP a causa della **sovra-specializzazione** dello strato.
    * Questo si contrappone alle reti addestrate in maniera supervisionata, dove si nota un generale aumento della MAP all'aumentare della profondità dello strato.
    * Ciò mostra che il compito di pretesto **non è ben allineato** con il compito *downstream*.

<!-- * It is helpful to evaluate the pretext learning on a **multitude of different tasks**. We can do so by extracting the representation created by different layers in the network as **fixed features** and evaluating their usefulness across these different tasks.
  * Measurement: Mean Average Precision (mAP) --The precision averaged across all the different tasks we are considering.
  * Some examples of these tasks include: Object Detection (using fine-tuning), Surface Normal Estimation (see NYU-v2 dataset)
* What does each layer learn?
  * Generally, as the layers become deeper, the mean average precision on downstream tasks using their representations will increase.
  * However, the **final layer** will see a sharp drop in the mAP due to the layer becoming overly **specialized**.
    * This contrasts with supervised networks, in that the mAP generally always increases with depth of layer.
    * This shows that the pretext task is **not well-aligned** to the downstream task. -->
