---
lang-ref: ch.09-3
lang: it
title: Reti avversarie generative
lecturer: Alfredo Canziani
authors: William Huang, Kunal Gadkar, Gaomin Wu, Lin Ye
date: 31 Mar 2020
translation-date: 29 Jun 2020
translator: Marco Zullich
---

<!-- Generative Adversarial Networks -->

## [Introduzione alle reti generative avversarie (*Generative Adversarial Networks, GAN*)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s)

<!-- ## [Introduction to generative adversarial networks (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s) -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANArchitecture.png" height="400px" /><br>
<b>Fig. 1</b>: architettura di una GAN
<!-- GAN Architecture -->
</center>

Le _GAN_ sono un tipo di rete neurale usato per l'apprendimento automatico non supervisionato. Sono composte da due moduli avversari: una rete _generatrice_ (anche chiamata _generatore_) e una rete _del costo_. Questi moduli competono fra di loro in maniera tale che la rete _del costo_ cerchi di filtrare istanze fittizie dei dati, mentre il _generatore_ si occupi di ingannare questo filtro tramite la creazione di esempi realistici $\vect{\hat{x}}$. Grazie a questa competizione, il modello impara un generatore che crei dati realistici. Questi possono essere utilizzati in compiti come previsioni future o nella generazione di immagini dopo che la rete sia stata addestrata su un dataset specifico.

<!-- GANs are a type of neural network used for unsupervised machine learning. They are comprised of two adversarial modules: _generator_ and _cost_ networks. These modules compete with each other such that the _cost_ network tries to filter fake examples while the _generator_ tries to trick this filter by creating realistic examples $\vect{\hat{x}}$. Through this competition, the model learns a generator that creates realistic data. They can be used in tasks such as future predictions or for generating images after being trained on a particular dataset. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANMapping.png" height="400px" /><br>
<b>Fig. 2</b>: mappatura di una GAN da una variabile aleatoria
<!-- GAN Mapping from Random Variable -->
</center>

Le _GAN_ sono un esempio di modello ad energia (*Energy Based Model, EBM*). In quanto tale, la rete di costo è addestrata al fine di assegnare un costo basso per input vicini alla distribuzione reale dei dati, denotata in Fig. 2 dall'espressione $\vect{x}$ in rosa. I dati provenienti da altre distribuzioni, come il $\vect{x}$ in blu (sempre in Fig. 2), dovrebbero avere un costo più elevato. Una perdita basata sull'errore quadratico medio (*Mean Square Error, MSE*) viene tipicamente utilizzata per calcolare il costo della performance della rete. Vale la pena notare che la funzione di costo produce uno scalare positivo in un intervallo denso specifico (ad esempio, $\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). Questo al contrario di un discriminatore classico il quale classifica sulla base di un insieme discreto.

<!-- GANs are examples of energy based models (EBMs). As such, the cost network is trained to produce low costs for inputs closer to the true data distribution denoted by the pink $\vect{x}$ in Fig. 2. Data from other distributions, like the blue $\vect{\hat{x}}$ in Fig. 2, should have high cost. A mean squared error (MSE) loss is typically used to calculate the cost network's performance. It is worth noting that the cost function outputs a positive scalar value within a specified range (i.e. $\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). This is unlike a classic discriminator which uses discrete classification for its outputs. -->

Nel frattempo, la rete generatrice ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) è addestrata a migliorare la sua mappatura di una variabile aleatoria $\vect{z}$ verso dati realistici $\vect{\hat{x}}$ generati per ingannare la rete del costo. Il generatore viene addestrato nei confronti dell'output della rete di costo, in un tentativo di minimizzazione dell'energia di $\vect{\hat{x}}$. Denotiamo questa energia con $C(G(\vect{z}))$, dove $C(\cdot)$ è la rete di costo è $G(\cdot)$ è la rete generatrice.

<!-- Meanwhile, the generator network ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) is trained to improve its mapping of random variable $\vect{z}$ to realistic generated data $\vect{\hat{x}}$ to trick the cost network. The generator is trained with respect to the cost network's output, trying to minimize the energy of $\vect{\hat{x}}$. We denote this energy as $C(G(\vect{z}))$, where $C(\cdot)$ is the cost network and $G(\cdot)$ is the generator network. -->

L'addestramento della rete di costo si basa sulla minimizzazione della perdita MSE, mentre l'addestramento del generatore avviene attraverso la minimizzazione della rete di costo, usando i gradienti di $C(\vect{\hat{x}})$ su $\vect{\hat{x}}$.

<!-- The training of the cost network is based on minimizing the MSE loss, while the training of the generator network is through minimizing the cost network, using gradients of $C(\vect{\hat{x}})$ with respect to $\vect{\hat{x}}$. -->

Per assicurare che ai punti esterni alla varietà dei dati venga assegnato un costo alto, mentre ai punti interni risulti un costo basso, la funzione di perdita della rete di costo $\mathcal{L}\_{C}$ è $C(x)+[m-C(G(\vect{z}))]^+$ dato un margine positivo $m$. La minimizzazione di $\mathcal{L}\_{C}$ richiede sia che $C(\vect{x}) \rightarrow 0$ che $C(G(\vect{z})) \rightarrow m$. La perdita del generatore $\mathcal{L}\_{G}$ è semplicemente $C(G(\vect{z}))$, il che incoraggia il generatore ad assicurare che $C(G(\vect{z})) \rightarrow 0$. Tuttavia, questo crea della instabilità in quanto $0 \leftarrow C(G(\vect{z})) \rightarrow m$.

<!-- To ensure that high cost is assigned to points outside the data manifold and low cost is assigned to points within it, the loss function for the cost network $\mathcal{L}\_{C}$ is $C(x)+[m-C(G(\vect{z}))]^+$ for some positive margin $m$. Minimizing $\mathcal{L}\_{C}$ requires that $C(\vect{x}) \rightarrow 0$ and $C(G(\vect{z})) \rightarrow m$. The loss for the generator $\mathcal{L}\_{G}$ is simply $C(G(\vect{z}))$, which encourages the generator to ensure that $C(G(\vect{z})) \rightarrow 0$. However, this does create instability as $0 \leftarrow C(G(\vect{z})) \rightarrow m$. -->


## [Differenze fra _GAN_ e VAE](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s) -->

<!-- ## [Difference between GANs and VAEs](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s) -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEArchitecture.png" height="400px" /><br>
<b>Fig. 3</b>: VAE (a sinistra) vs. GAN (a destra) --- progettazione architettonica
<!-- VAE (left) vs. GAN (right) - Architectural design -->
</center>

Se comparate con gli *Autoencoder* variazionali (VAE) di cui alla Settimana 8, le _GAN_ creano dei generatori in maniera leggermente diversa. Si ricordi che i VAE mappano gli input $\vect{x}$ in uno spazio latente $\mathcal{Z}$ tramite un _codificatore_ e, tramite un _decodificatore_, mappano da $\mathcal{Z}$ di nuovo nello spazio dei dati a produrre $\vect{\hat{x}}$. Si avvalgono della perdita di ricostruzione per fare in modo tale che $\vect{x}$ e $\vect{\hat{x}}$ siano simili.
Le GAN, invece, vengono addestrate in un contesto avversario dove le reti generatrice e di costo competono come prima descritto. Queste reti sono addestrate con successo tramite la retropropagazione e i metodi basati sul gradiente. Un paragone fra le differenze architettoniche di questi modelli è presente in Fig. 3.

<!-- Compared to Variational Auto-Encoders (VAEs) from week 8, GANs create generators slightly differently. Recall, VAEs map inputs $\vect{x}$ to a latent space $\mathcal{Z}$ with an _encoder_ and then maps from $\mathcal{Z}$ back to the data space with a _decoder_ to get $\vect{\hat{x}}$. It then uses the reconstruction loss to push $\vect{x}$ and $\vect{\hat{x}}$ to be similar. GANs, on the other hand, train through an adversarial setting with the generator and cost networks competing as described above. These networks are successively trained through backpropagation through gradient based methods. Comparison of this architectural difference can be seen in Fig. 3. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEMapping.jpg" height="250px" /><br>
<b>Fig. 4</b>: VAE (a sinistra) vs. GAN (a destra) --- mappatura a partire da un campione casuale $\vect{z}$
<!-- VAE (left) vs. GAN (right) - Mapping from Random Sample $\vect{z}$ -->
</center>

Le _GAN_ differiscono dai VAE anche nel modo in cui producono e utilizzano $\vect{z}$. Le _GAN_ iniziano campionando $\vect{z}$, similarmente a quanto succede nello spazio latente di un VAE; utilizzano quindi una rete generativa per mappare $\vect{z}$ in $\vect{\hat{x}}$. Questo $\vect{\hat{x}}$ è quindi passato attraverso una rete discriminatrice/di costo per valutare quanto esso sia "reale". Una delle principali differenze rispetto ai VAE è che **non è necessario misurare una relazione diretta (come la perdita di ricostruzione) fra l'output della rete generativa $\vect{\hat{x}}$ e il dato reale $\vect{x}$**. Invece, forziamo $\vect{\hat{x}}$ a essere simile a $\vect{x}$ addestrando un generatore a produrre $\vect{\hat{x}}$ in modo tale che la rete discriminatrice/di costo produca dei punteggi che sono simili a quelli dei dati reali $\vect{x}$ o dei dati "più reali".

<!-- GANs also differ from VAEs through how they produce and use $\vect{z}$. GANs start by sampling $\vect{z}$, similar to the latent space in a VAE. They then use a generative network to map $\vect{z}$ to $\vect{\hat{x}}$. This $\vect{\hat{x}}$ is then sent through a discriminator/cost network to evaluate how "real" it is. One of the main differences from VAE and GAN is that **we do not need to measure a direct relationship (*i.e.* reconstruction loss) between the output of the generative network $\vect{\hat{x}}$ and real data $\vect{x}$.** Instead, we force $\vect{\hat{x}}$ to be similar to $\vect{x}$ by training the generator to produce $\vect{\hat{x}}$ such that the discriminator/cost network produces scores that are similar to those of real data $\vect{x}$, or more "real". -->


## Grosse limitazioni delle GAN

<!-- ## Major pitfalls in GANs -->

Le _GAN_ possono essere degli strumenti potenti per costruire dei generatori; tuttavia, hanno una serie di grosse limitazioni.

<!-- While GANs can be powerful for building generators, they have some major pitfalls. -->


### 1. Convergenza instabile

<!-- ### 1. Unstable convergence -->

Al miglioramento delle performance del generatore nel corso dell'addestramento, segue un degradamento di quelle del discriminatore in quanto quest'ultimo non riesce più a distinguere facilmente fra i dati reali e quelli sintetici. Se il generatore è perfetto, allora le varietà dei dati reali e di quelli sintetici si sovrappongono, con la conseguenza che il discriminatore compirà molte errate classificazioni.

<!-- As the generator improves with training, the discriminator performance gets worse because the discriminator can no longer easily tell the difference between real and fake data. If the generator is perfect, then the manifold of the real and fake data will lie on top of each other and the discriminator will create many misclassifications. -->

Questo pone un problema per la convergenza della _GAN_: il *feedback* ricevuto dal discriminatore diviene sempre meno significativo nel tempo. Se la _GAN_ continua l'addestramento oltre al punto in cui il discriminatore inizia a dare *feedback* completamente casuali, allora il generatore inizia ad addestrarsi su riferimenti completamente inaffidabili e la sua qualità potrebbe degradarsi. [Fare riferimento a [convergenza dell'addestramento nelle GAN](https://developers.google.com/machine-learning/gan/training)]

<!-- This poses a problem for convergence of the GAN: the discriminator feedback gets less meaningful over time. If the GAN continues training past the point when the discriminator is giving completely random feedback, then the generator starts to train on junk feedback and its quality may collapse. [Refer to [training convergence in GANs](https://developers.google.com/machine-learning/gan/training)] -->

Il risultato di questa natura avversaria fra il generatore e il discriminatore è un punto di equilibrio instabile piuttosto che un vero e proprio equilibrio.

<!-- As a result of this adversarial nature between the generator and discriminator there is an unstable equilibrium point rather than an equilibrium. -->


### 2. Scomparsa del gradiente (o "gradiente evanescente")

<!-- ###  2. Vanishing gradient -->

Proviamo a utilizzare la entropia binaria incrociata come perdita di una GAN

<!-- Let's consider using the binary cross entropy loss for a GAN: -->

$$
\mathcal{L} = \mathbb{E}_\boldsymbol{x}[\log(D(\boldsymbol{x}))] + \mathbb{E}_\boldsymbol{\hat{x}}[\log(1-D(\boldsymbol{\hat{x}}))] \text{.}
$$

Come il discriminatore diventa più "fiducioso", $D(\vect{x})$ si avvicina a $1$ e $D(\vect{\hat{x}})$ a $0$. Questa "fiducia" nella previsione fa sì che gli output della rete di costo vengano "spostati" verso regioni piatte dove il gradiente diviene più saturato. Queste regioni forniscono gradienti piccoli ed evanescenti che danneggiano l'addestramento della rete generatrice. Dunque, quando si addestra una _GAN_, ci si vuole assicurare che il costo aumenti gradualmente con il livello di certezza.

<!-- As the discriminator becomes more confident, $D(\vect{x})$ gets closer to $1$ and $D(\vect{\hat{x}})$ gets closer to $0$. This confidence moves the outputs of the cost network into flatter regions where the gradients become more saturated. These flatter regions provide small, vanishing gradients that hinder the generator network's training. Thus, when training a GAN, you want to make sure that the cost gradually increases as you become more confident. -->


### 3. Collasso della moda

<!-- ### 3. Mode collapse -->

Se un generatore mappa tutti i $\vect{z}$ del campionatore ad un **unico** $\vect{\hat{x}}$ in grado d'imbrogliare il discriminatore, allora il generatore produrrà **solamente** questo $\vect{\hat{x}}$. Alla fine, il discriminatore imparerà a distinguere *specificamente* questo input sintetico. Il risultato di ciò è che il generatore semplicemente scopre il $\vect{\hat{x}}$ più plausibile e il ciclo continua; conseguentemente, il discriminatore rimane intrappolato in minimi locali mentre passa in rassegna sempre gli stessi $\vect{\hat{x}}$ sintetici. Una possibile soluzione a questa problematica è l'applicazione di una qualche penalità al generatore così da sfavorire la produzione ripetuta dello stesso output dati input differenti fra di loro.

 <!-- If a generator maps all $\vect{z}$'s from the sampler to a **single** $\vect{\hat{x}}$ that can fool the discriminator, then the generator will produce **only** that $\vect{\hat{x}}$. Eventually, the discriminator will learn to detect *specifically* this fake input. As a result, the generator simply finds the next most plausible $\vect{\hat{x}}$ and the cycle continues. As a result, the discriminator gets trapped in local minima while cycling through fake $\vect{\hat{x}}$'s. A possible solution to this issue is to enforce some penalty to the generator for always giving the same output given different inputs. -->


## [Codice sorgente di una rete avversaria generativa profonda convoluzionale (*Deep Convolutional Generative Adversarial Network, DCGAN*)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s)

<!-- ## [Deep Convolutional Generative Adversarial Network (DCGAN) source code](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s) -->

Il codice sorgente dell'esempio è reperibile [qui](https://github.com/pytorch/examples/blob/master/dcgan/main.py).

<!-- The source code of the example can be found [here](https://github.com/pytorch/examples/blob/master/dcgan/main.py). -->


### Il generatore

<!-- ### Generator -->

1. Il generatore esegue un sovracampionamento dell'input utilizzando vari moduli `nn.ConvTranspose2d` inframmezzati da `nn.BatchNorm2d` e `nn.ReLU`.
2. Al termine della parte sequenziale, la rete utilizza `nn.Tanh()` per confinare l'output nell'intervallo $(-1; 1)$.
3. Il vettore aleatorio d'input ha dimensione $nz$. L'output ha una dimensione di $nc \times 64 \times 64$, dove $nc$ è il numero di canali.

<!-- 1. The generator upsamples the input using several `nn.ConvTranspose2d` modules separated with `nn.BatchNorm2d` and `nn.ReLU`.
2. At the end of the sequential, the network uses `nn.Tanh()` to squash outputs to $(-1,1)$.
3. The input random vector has size $nz$. The output has size $nc \times 64 \times 64$, where $nc$ is the number of channels. -->

```python
class Generator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # l'input è Z, passa attraverso una convoluzione
            nn.ConvTranspose2d(     nz, ngf * 8, 4, 1, 0, bias=False),
            nn.BatchNorm2d(ngf * 8),
            nn.ReLU(True),
            # dimensione dello stato (ngf * 8) x 4 x 4
            nn.ConvTranspose2d(ngf * 8, ngf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 4),
            nn.ReLU(True),
            # dimensione dello stato (ngf * 8) x 8 x 8
            nn.ConvTranspose2d(ngf * 4, ngf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 2),
            nn.ReLU(True),
            # dimensione dello stato (ngf * 2) x 16 x 16
            nn.ConvTranspose2d(ngf * 2,     ngf, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf),
            nn.ReLU(True),
            # dimensione dello stato (ngf * 1) x 32 x 32
            nn.ConvTranspose2d(    ngf,      nc, 4, 2, 1, bias=False),
            nn.Tanh()
            # dimensione dello stato (nc) x 64 x 64
        )

    def forward(self, input):
        output = self.main(input)
        return output
```


### Il discriminatore

<!-- ### Discriminator -->

1. È importante utilizzare `nn.LeakyReLU` come funzione di attivazione onde evitare l'azzeramento del gradiente nelle regioni negative. Senza questi gradienti, il generatore non riceverebbe aggiornamenti.
2. Alla fine della parte sequenziale, il discriminatore utilizza `nn.Sigmoid()` per classificare l'input.

<!-- 1. It is important to use `nn.LeakyReLU` as the activation function to avoid killing the gradients in negative regions. Without these gradients, the generator will not receive updates. -->
<!-- 2. At the end of the sequential, the discriminator uses `nn.Sigmoid()` to classify the input. -->

```python
class Discriminator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # l'input è (nc) x 64 x 64
            nn.Conv2d(nc, ndf, 4, 2, 1, bias=False),
            nn.LeakyReLU(0.2, inplace=True),
            # dimensione dello stato (ndf) x 32 x 32
            nn.Conv2d(ndf, ndf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 2),
            nn.LeakyReLU(0.2, inplace=True),
            # dimensione dello stato (ndf*2) x 16 x 16
            nn.Conv2d(ndf * 2, ndf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 4),
            nn.LeakyReLU(0.2, inplace=True),
            # dimensione dello stato (ndf*4) x 8 x 8
            nn.Conv2d(ndf * 4, ndf * 8, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 8),
            nn.LeakyReLU(0.2, inplace=True),
            # dimensione dello stato (ndf*8) x 4 x 4
            nn.Conv2d(ndf * 8, 1, 4, 1, 0, bias=False),
            nn.Sigmoid()
        )

    def forward(self, input):
        output = self.main(input)
        return output.view(-1, 1).squeeze(1)
```

Queste due classi sono inizializzate con i nomi di `netG` e `netD`.

<!-- These two classes are initialized as `netG` and `netD`. -->


### Funzione di perdita per la GAN

<!-- ### Loss function for GAN -->

Utilizziamo l'entropia incrociata binaria (*Binary Cross Entropy, BCE*) fra l'obiettivo e l'output.

<!-- We use Binary Cross Entropy (BCE) between target and output. -->

```python
criterion = nn.BCELoss()
```


### Preparazione

<!-- ### Setup -->

Predisponiamo un rumore fisso `fixed_noise` di dimensione `opt.batchSize` e della lunghezza del vettore aleatorio `nz`. Inoltre, creiamo delle etichette per i dati reali e quelli generati (sintetici): rispettivamente `real_label` e `fake_label`.

<!-- We set up `fixed_noise` of size `opt.batchSize` and length of random vector `nz`. We also create labels for real data and generated (fake) data called `real_label` and `fake_label`, respectively. -->

```python
fixed_noise = torch.randn(opt.batchSize, nz, 1, 1, device=device)
real_label = 1
fake_label = 0
```

Dopodiché predisponiamo gli ottimizzatori per la rete discriminatrice e generatrice.

<!-- Then we set up optimizers for discriminator and generator networks. -->

```python
optimizerD = optim.Adam(netD.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
optimizerG = optim.Adam(netG.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
```


### Addestramento

<!-- ### Training -->

Ogni epoca di addestramento è suddivisa in due passi.

<!-- Each epoch of training is divided into two steps. -->

**Il primo passo** consiste nell'aggiornamento della rete discriminatrice. Innanzitutto, le diamo come input i dati reali provenienti dai `dataloaders`, calcoliamo la perdita fra l'output e la `real_label` e accumuliamo i gradienti via retropropagazione. Dopodiché, passiamo al discriminatore i dati sintetici prodotti dal generatore utilizzando il `fixed_noise`, calcoliamo la perdita fra l'output e la `fake_label` e accumuliamo il gradiente. Infine, utilizziamo i gradienti accumulati per calcolare i parametri della rete discriminatrice.

<!-- **Step 1** is to update the discriminator network. This is done in two parts. First, we feed the discriminator real data coming from `dataloaders`, compute the loss between the output and `real_label`, and then accumulate gradients with backpropagation. Second, we feed the discriminator data generated by the generator network using the `fixed_noise`, compute the loss between the output and `fake_label`, and then accumulate the gradient. Finally, we use the accumulated gradients to update the parameters for the discriminator network. -->

Si noti che effettuiamo un *detach* ("distaccamento") dei dati fittizi per impedire la propagazione del gradiente al generatore mentre stiamo addestrando il discriminatore.

<!-- Note that we detach the fake data to stop gradients from propagating to the generator while we train the discriminator. -->

Inoltre, si noti che dobbiamo chiamare `zero_grad()` solamente una volta all'inizio per azzerare i gradienti in modo tale che i gradienti provenienti sia dai dati reali che da quelli sintetici possano essere utilizzati per l'aggiornamento. Le due chiamate `.backward()` accumulano detti gradienti. Infine, necessitiamo solo di una chiamata `optimizerD.step()` per aggiornare i parametri.

<!-- Also note that we only need to call `zero_grad()` once in the beginning to clear the gradients so the gradients from both the real and fake data can be used for the update. The two `.backward()` calls accumulate these gradients. We finally only need one call of `optimizerD.step()` to update the parameters. -->

```python
# addestramento con dati reali (real)
netD.zero_grad()
real_cpu = data[0].to(device)
batch_size = real_cpu.size(0)
label = torch.full((batch_size,), real_label, device=device)

output = netD(real_cpu)
errD_real = criterion(output, label)
errD_real.backward()
D_x = output.mean().item()

# addestramento con dati sintetici (fake)
noise = torch.randn(batch_size, nz, 1, 1, device=device)
fake = netG(noise)
label.fill_(fake_label)
output = netD(fake.detach())
errD_fake = criterion(output, label)
errD_fake.backward()
D_G_z1 = output.mean().item()
errD = errD_real + errD_fake
optimizerD.step()
```

**Il secondo passo** consiste nell'aggiornare la rete generatrice. Stavolta, diamo al discriminatore i dati fittizi, ma computiamo la perdita con la `real_label`! Lo scopo di ciò è addestrare il generatore a produrre $\vect{\hat{x}}$ realistici.

<!-- **Step 2** is to update the Generator network. This time, we feed the discriminator the fake data, but compute the loss with the `real_label`! The purpose of doing this is to train the generator to make realistic $\vect{\hat{x}}$'s. -->

```python
netG.zero_grad()
label.fill_(real_label)  # le fake_labels sono reali per la fz. di costo del generatore
output = netD(fake)
errG = criterion(output, label)
errG.backward()
D_G_z2 = output.mean().item()
optimizerG.step()
```
