---
lang-ref: ch.09-2
lang: it
title: World Model e reti avversarie generative
authors: Bofei Zhang, Andrew Hopen, Maxwell Goldstein, Zeping Zhan
date: 30 Mar 2020
translation-date: 25 Jun 2020
translator: Marco Zullich
---

<!-- World Models and Generative Adversarial Networks -->

## [Modelli della realtà (*world model*) per il controllo autonomo](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)

<!-- ## [World models for autonomous control](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s) -->

Uno degli utilizzi più importanti dell'apprendimento auto-supervisionato è imparare modelli della realtà (*world model*, letteralmente "modello del mondo") per il controllo. Quando noi umani svolgiam un compito, facciamo riferimento a un modello interiore sul funzionamento del mondo. Per esempio, costruiamo delle intuizioni sulle leggi della fisica da quando abbiamo circa 9 mesi, principalmente tramite l'osservazione. In un certo senso, ciò è simile all'apprendimento auto-supervisionato; apprendendo a predire ciò che accadrà, impariamo princìpi astratti, così come l'apprendimento auto-supervisionato apprende le caratteristiche latenti. Ma, facendo un passo ulteriore, i modelli interni ci permettono di agire sul mondo. Ad esempio, possiamo utilizzare le intuizioni sulla fisica da noi imparate e ciò che abbiamo appreso sul funzionamento dei nostri muscoli per predire --- ed eseguire -- come prendere al volo una penna che sta cadendo.

<!-- One of the most important uses of self-supervised learning is to learn world models for control. When humans perform a task, we have an internal model for how the world works. For example, we gain an intuition for physics when we're about 9 months old, mostly through observation. In some sense, this is similar to self-supervised learning; in learning to predict what will happen, we learn abstract principles, just like self-supervised models learn latent features. But taking this one step further, the internal models let us act on the world. For example, we can use our learned physics intuition and our learned understanding of how our muscles work to predict --- and execute --- how to catch a falling pen. -->


### Che cos'è un modello della realtà?

<!-- ### What is a "world model"? -->

Un sistema d'intelligenza autonomo comprende quattro moduli principali (Fig. 1). Innanzitutto, il modulo di percezione (*perception*) osserva il mondo e ne calcola una rappresentazione del suo stato. Questa rappresentazione è incompleta in quanto 1) l'agente non è in grado di osservare l'universo nella sua interezza e 2) l'accuratezza delle osservazioni è limitata. Vale anche la pena notare che nel modello *feed-forward*, il modulo di percezione è presente solo nell'istante iniziale. Dopodiché, il modulo attuativo (*actor*, anche chiamato modulo di politica) immagina di compiere un'azione sulla base dello stato del mondo o di una rappresentazione di quest'ultimo. Come terzo passo, il modulo di modellazione (*model*) predice il risultato dell'azione dato lo stato del mondo (o una sua rappresentazione) ed eventualmente delle caratteristiche lantenti. Questa previsione viene passata avanti al prossimo istante temporale come stima per il prossimo stato del mondo, assumento il ruolo del modulo di percezione di cui al primo istante temporale. La Fig. 2 fornisce una dimostrazione nel dettaglio di questo processo *feed-forward*. Infine, il modulo di critica (*critic*) trasforma questa stessa previsione in un costo dovuto all'attuazione dell'azione proposta: ad esempio, data la velocità con la quale credo la penna stia cadendo, se muovo i muscoli in un determinato modo, di quanto mancherò la presa?

<!-- An autonomous intelligence system comprises four major modules (Figure 1.). First, the perception module observes the world and computes a representation of the state of the world. This representation is incomplete because 1) the agent doesn't observe the whole universe, and 2) the accuracy of the observations is limited. It is also worth noting that in the feed-forward model, the perception module is only present for the initial time step. Second, the actor module (also called a policy module) imagines taking some action based on the (represented) state of the world. Third, the model module predicts the outcome of the action given the (represented) state of the world, and also possible given some latent features. This prediction gets passed forward to the next time step as the guess for the next state of the world, taking on the role of the perception module from the initial time step. Fig 2 gives detail demonstration of this feed-forward process. Finally, the critic module takes turns that same prediction into a cost of performing the proposed action, e.g. given the speed with which I believe the pen is falling, if I move muscles in this particular way, how badly will I miss the catch? -->

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models_arch.png" height="400px" /><br>
<b>Fig. 1</b>: dimostrazione dell'architettura di un sistema intelligente artificiale di tipo world model.
<!-- The World Models architecture of an autonomous intelligence system demonstration. -->
</center>

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models.png" height="400px" /><br>
<b>Fig. 2</b>: architettura del modello
<!-- Model architecture. -->
</center>


## La configurazione classica

<!-- ## The classical setting -->

Nel controllo ottimo classico, non vi è alcun modulo attuativo / di politica, ma vi è solo una variabile attuativa. Questa formulazione è ottimizzata da un metodo classico chiamato *Model Predictive Control* ("modello di controllo predittivo"), che è stato utilizzato dalla NASA negli anni '60 per calcolare le traiettorie del razzo al passaggio da calcolatori umani (principalmente matematiche di colore) ai computer elettronici. Possiamo pensare a questi sistemi come una rete neurale ricorrente (_recurrent neural network, RNN_) "srotolato" nel tempo, e alle azioni come variabili latenti; possiamo quindi usare la retropropagazione ed i metodi a gradiente (o eventualmente altri metodi, come la programmazione dinamica per un insieme di azioni discrete) per inferire la sequenza di azioni che minimizzi la somma dei costi per ogni istante temporale.

<!-- In classical optimal control, there is no actor/policy module, but rather just an action variable. This formulation is optimized by a classical method called Model Predictive Control, which was used by NASA in the 1960s to compute rocket trajectories when they switched from human computers (mostly Black women mathematicians) to electronic computers. We can think of this system as an unrolled RNN, and the actions as latent variables, and use backpropagation and gradient methods (or possibly other methods, such as dynamic programming for a discrete action set) to infer the sequence of actions that minimizes the sum of the time step costs. -->

*Nota*: utilizziamo il termine "inferenza" per le variabili latenti e "apprendimento" per i parametri, nonostante il processo di ottimizzazione sia fra loro generalmente simile. Una differenza importante è che una variabile latente assume un valore specifico per ogni istanza dei dati, mentre i parametri sono condivisi fra le varie istanze.

<!-- Aside: We use the word "inference" for latent variables, and "learning" for parameters, though the process of optimizing them is generally similar. One important difference is that a latent variable takes a specific value for each sample, whereas, parameters are shared between samples. -->


## Una miglioria

<!-- ## An improvement -->

Preferiremmo non passare per il processo complicato di attuazione della retropropagazione ogni volta che vogliamo ottenere un piano di previsione. Per risolvere ciò, utilizziamo lo stesso trucchetto già applicato agli *autoencoder* variazionali per migliorare la codificazione sparsa: addestriamo un *autoencoder* per predire direttamente, dalla rappresentazione del mondo,  la sequenza attuativa ottimale. Sotto questo regime, il codificatore diviene una "rete della politica".

<!-- Now, we'd prefer not to go through the complicated process of backpropagating every time we want to make a plan. To address this, we use the same trick we used for variational autoencoder to improve sparse coding: we train an encoder to directly predict the optimal action sequence from the world representations. In this regime, the encoder is called a policy network. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_policy_network.png" height="400px" /><br>
<b>Fig. 3</b>: rete della politica
<!-- Policy Network. -->
</center>

Una volta addestrata, possiamo usare le reti della politica per predire la sequenza di azioni ottimale immediatamente dopo la percezione.

<!-- Once trained, we can use the policy networks to predict the optimal action sequence immediately after perception. -->


## [Apprendimento per riforzo (_Reinforcement Learning, RL_)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)

<!-- ## [Reinforcement learning (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s) -->

Le principali differenze fra il _RL_ e quanto finora studiato sono duplici:
1. Nel _RL_, la funzione di costo è una "scatola nera" (_black box_), ovvero non ci è nota. In altre parole, l'agente non capisce le dinamiche che stanno dietro alla ricompensa.
2. Nella configurazione del _RL_, non si utilizza un modello "in avanti" (*forward*) per fare passi nell'ambiente. Invece, si interagisce con il mondo reale e s'impara il risultato delle azioni tramite l'osservazione di ciò che accade di conseguenza a esse. Nel mondo reale, la nostra stima dello stato del mondo è imperfetta, così che non è sempre possibile predire cosa accadrà nel futuro prossimo.

<!-- The main differences between RL and what we have studied up to this point are two-fold:
1. In Reinforcement learning environments the cost function is a black box. In other words, the agent does not understand the reward dynamics.
2. In the setting of RL, we don't use a forward model of the world to step the environment. Instead we interact with the real world and learn the result by observing what happens. In the real world our measure of the state of the world is imperfect so it is not always possible to predict what will happen next. -->

Il problema principale del _RL_ è che la funzione di costo non è differenziabile. Ciò significa che l'unica modalità di apprendimento è tramite tentativi ed errori (*trial and error*). La questione diviene dunque come esplorare lo spazio degli stati in maniera efficiente. Una volta risolto questo punto, il prossimo problema è il *trade-off* fondamentale fra l'esplorazione e lo sfruttamento (*explore vs. exploit*): è preferibile compiere azioni al fine di apprendere in maniera massimale l'ambiente, oppure sfruttare quanto già imparato per ottenere una ricompensa più alta possibile?

<!-- The main problem of Reinforcement learning is that the cost function is not differentiable. This means that the only way to learn is through trial and error. Then the problem becomes how to explore the state space efficiently. Once you come up with a solution to this the next issue is the fundamental question of exploration *vs.* exploitation: would you rather take actions to maximally learn about the environment or instead exploit what you have already learned to get as high a reward as possible. -->

I metodi di tipo *Actor-Critic* ("agente-critico") sono una famiglia molto diffusa di algoritmi di _RL_ che si propongono di addestrare sia un agente che un critico. Molti metodi di RL funzionano in maniera simile, addestrando un modello della funzione di costo (il critico). Nei metodi *Actor-Critic* il ruolo del critico è di apprendere il valore atteso della funzione del valore. Questo permette una retropropagazione attraverso il modulo, poiché il critico è una rete neurale. La responsabilità dell'attore è quella di proporre azioni da compiere nell'ambiente, mentre il lavoro del critico è di apprendere un modello della funzione di costo. L'attore e il critico lavorano in tandem, il che risulta in un apprendimento più efficiente rispetto al modello con solo attore. Se non si dispone di un buon modello della realtà, è molto più difficile apprendere: ad esempio, l'auto sull'orlo del burrone non saprà che cadere giù da quest'ultimo sia una idea cattiva. Il modello della realtà permette agli umani e agli animali d'imparare molto più rapidamente degli agenti di RL: disponiamo già di un modello della realtà veramente buono nella nostra testa.

<!-- Actor-Critic methods are a popular family of RL algorithms which train both an actor and a critic. Many RL methods work similarly, by training a model of the cost function (the critic). In Actor-Critic methods the role of the critic is to learn the expected value of the value function. This enables back-propagation through the module, since the critic is just a neural network. The actor's responsibility is to propose actions to take in the environment, and the critic's job is to learn a model of the cost function. The actor and the critic work in tandem that leads to more efficient learning than if no critic is used.  If you don't have a good model of the world it is much more difficult to learn: e.g. the car next to the cliff will not know that falling off a cliff is a bad idea. This enables humans and animals to learn much more quickly than RL agents: we have really good world models in our head. -->

Non possiamo sempre prevedere il futuro reale a causa di due tipi d'incertezza intrinseca: aleatoria ed epistemica. L'incertezza aleatoria è dovuta da fattori dell'ambiente che non si possono controllare od osservare. L'incertezza epistemica è dovuta ad un'assenza, nel modello, di dati di addestramento, ragion per cui il modello non riesce a prevedere il futuro.

<!-- We cannot always predict the future of the world due to inherent uncertainty: aleatory and epistemic uncertainty. Aleatoric uncertainty is due to things you cannot control or observe in the environment. Epistemic uncertainty is when you cannot predict the future of the world because your model does not have enough training data. -->

Il modello di tipo *forward* vorrebbe predire

<!-- The forward model would like to be able to predict -->

$$\hat s_{t+1} = g(s_t, a_t, z_t)$$

dove $z$ è una variabile latente di cui non conosciamo il valore. Essa rappresenta ciò che non si può conoscere del mondo, ma che comunque influenza la previsione (ovvero, l'incertezza aleatoria). È possibile regolarizzare $z$ tramite sparsità, rumore o tramite un codificatore. Si può usare il modello *forward* per imparare a pianificare. Ciò è possibile disponendo di un decodificatore che decodifichi una concatenazione della rappresentazione dello stato e dell'incertezza $z$. La miglior $z$ è quella che minimizza la differenza fra lo stato stimato $\hat s_{t+1}$ e lo stato osservato $s_{t+1}$.

<!-- where $z$ is a latent variable of which we don't know the value. $z$ represents what you cannot know about the world but which still influences the prediction (*i.e.* aleatoric uncertainty). Can regularize $z$ with sparsity, noise, or with an encoder. Can use forward models to learn to plan. The system works by ha*ving a decoder decode a concatenation of the state representation and the uncertainty $z$. The best $z$ is defined as the $z$ that minimizes the difference between $\hat s_{t+1}$ and the actual observed $s_{t+1}$. -->


## [Reti avversarie generative (*Generative Adversarial Networks, GAN*)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)

<!-- ## [Generative Adversarial Network](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s) -->

Vi sono numerose variazioni delle GAN: qui vediamo una _GAN_ come una forma di modelli ad energia con metodi contrastivi. Innalza l'energia delle istanze contrastive e la abbassa per le istanze di addestramento. Una _GAN_ base è composta di due parti: un generatore (*generator*) che produce esempi contrastivi in maniera intelligente e un discriminatore (*discriminator*, a volte chiamato critico) che essenzialmente è una funzione di costo e agisce come un modello ad energia. Entrambe le parti sono reti neurali.

<!-- There are many variations of GAN and here we think of GAN as a form of energy-based model using contrastive methods. It pushes up the energy of contrastive samples and pushes down the energy of training samples. A basic GAN consists of two parts: a generator which produces contrastive samples intelligently and a discriminator (sometimes called critic) which is essentially a cost function and acts as an energy model. Both the generator and the discriminator are neural nets. -->

I due tipi di input della _GAN_ sono rispettivamente le istanze di addestramento e le istanze contrastive. La _GAN_ fa passare le istanze di addestramento attraverso il discriminatore e abbassa l'energia di queste. Per quanto riguarda le istanze contrastive, la _GAN_ campiona le variabili latenti a partire da una data distribuzione, le passa attraverso il generatore, che produce qualcosa di simile agli esempi di addestramento; inifine, le passa attraverso il discriminatore per innalzarne l'energia. La funzione di perdita del discriminatore è la seguente:

<!-- The two kinds of input to GAN are respectively training samples and contrastive samples. For training samples, GAN passes these samples through the discriminator and makes their energy go down. For contrastive samples, GAN samples latent variables from some distribution, runs them through the generator to produce something similar to training samples, and passes them through the discriminator to make their energy go up. The loss function for discriminator is as follows: -->

$$\sum_i L_d(F(y), F(\bar{y}))$$

dove $L_d$ può essere una funzione di perdita basata su di un margine (fra valore atteso e osservato), come $F(y) + [m - F(\bar{y})]^+$ oppure $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ fintantoché renda $F(y)$ decrescente e $F(\bar{y})$ crescente. In questo contesto, $y$ è la classe di appartenenza dell'istanza, mentre $\bar{y}$ è la risposta del modello.
La funzione di perdita per il generatore invece è la seguente:

<!-- where $L_d$ can be a margin-based loss function like $F(y) + [m - F(\bar{y})]^+$ or $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ as long as it makes $F(y)$ decrease and $F(\bar{y})$ increase. In this context, $y$ is the label,  and  $\bar{y}$ is the response variable gives lowest energy except $y$ itself. -->
<!-- There is going to be a different loss function for the generator: -->

$$L_g(F(\bar{y}))  = L_g(F(G(z)))$$

dove $z$ è la variabile latente e $G$ è la rete neurale generativa. Vogliamo far sì che il generatore adatti i suoi pesi e produca $\bar{y}$ con un'energia bassa affinché possa "sbugiardare" il discriminatore.

<!-- where $z$ is the latent variable and $G$ is the generator neural net. We want to make the generator adapt its weight and produce $\bar{y}$ with low energy that can fool the discriminator. -->

Il motivo per cui questo tipo di modello è chiamato "rete avversaria generativa" è perché abbiamo due funzioni obiettivo che sono incompatibili fra di loro e dobbiamo minimizzarle contemporaneamente. Non è un problema di discesa del gradiente, in quanto l'obiettivo è trovare un equilibrio di Nash fra queste due funzioni: una discesa del gradiente non è in grado di fare ciò da sé.

<!-- The reason why this type of model is called generative adversarial network is because we have two objective functions that are incompatible with each other and we need to minimize them simultaneously. It’s not a gradient descent problem because the goal is to find a Nash equilibrium between these two functions and gradient descent is not capable of this by default. -->

Sorgeranno dei problemi quando avremo istanze che saranno vicine alla varietà reale dei dati. Immaginiamo di avere una varietà infinitamente *sottile*. Il discriminatore deve produrre una probabilità pari a $0$ fuori dalla varietà e probabilità infinita al suo interno. Siccome questo è molto difficile da ottenere, la _GAN_ utilizza una sigmoide e produce $0$ fuori dalla varietà e $1$ al suo interno. Il problema con questo tipo di configurazione è che, se addestriamo il sistema con successo, il discriminatore produce $0$ fuori dalla varietà

<!-- There will be problems when we have samples that are close to the true manifold. Assume that we have an infinitely thin manifold. The discriminator needs to produce $0$ probability outside the manifold and infinite probability on the manifold. Since this is very difficult to achieve, GAN uses sigmoid and produces $0$ outside the manifold and produces $1$ on the manifold. The problem with this is that if we train the system successfully where we get the discriminator to produce $0$ outside the manifold, the energy function is completely useless. This is because the energy function is not smooth where all energy outside the data manifold will be infinity and all energy on the data manifold will be $0$. We don’t want the energy value to go from $0$ to infinity in a very small step. Researchers have proposed many ways to fix this problem by regularizing the energy function. A good example of improved GAN is Wasserstein GAN which limits the size of discriminator weight. -->
