---
lang: it
lang-ref: ch.09-1
lecturer: Yann LeCun
title: Autoencoder discriminativi ricorrenti sparsi
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 7 April 2020
translation-date: 12 Jun 2020
translator: Marco Zullich
---
<!-- Discriminative Recurrent Sparse Auto-Encoder and Group Sparsity -->

## *Autoencoder* discriminativi ricorrenti sparsi (*Discriminative recurrent Sparse Auto-Encoder, DrSAE*)

<!-- ## Discriminative Recurrent Sparse Auto-Encoder (DrSAE) -->

L'idea dietro al _DrSAE_ consiste nel combininare la codificazione sparsa, o gli *autoencoder* sparsi, con l'addestramento discriminativo.

<!-- The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px" /><br>
<b>Fig. 1</b>: Autoencoder discriminativi ricorrenti sparsi
</center>

Il codificatore, $W_e$ è simile al codificatore del metodo LISTA. La variabile $X$ viene passata attraverso $W_e$ e attraverso delle funzioni non-lineari. Questo risultato è poi moltiplicato per un'altra matrice appresa, $S$, ed aggiunto a $W_e$. Dopodiché viene passato nuovamente attraverso delle funzioni non-lineari. Il processo può venir ripetuto più volte; ogni ripetizione identifica uno strato.

<!-- The encoder, $W_e$, is similar to the encoder in the LISTA method. The X variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, S, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer. -->

Addestriamo questa rete neurale con tre criteri differenti:
1. $L_1$: applichiamo il criterio $L_1$ al vettore delle caratteristiche $X$ al fine di renderlo sparso.
2. Ricostruzione di $X$: ciò viene svolto utilizzando una matrice di decodificazione che riproduce l'input dato l'output, il che si ottiene minimizzando l'errore quadrato, indicato da $W_d$ nella Fig. 1.
3. Aggiunta di un terzo termine: questo terzo termine, indicato da $W_c$, è un semplice classificatore lineare il quale tenta di predire una categoria.

<!-- We train this neural network with 3 different criteria:
1. $L_1$: Apply $L_1$ criterion on the feature vector X to make it sparse.
2. Reconstruct X: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.
3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category. -->

Il sistema è addestrato al fine di minimizzare contemporaneamente tutti questi 3 criteri.

<!-- The system is trained to minimize all 3 of these criteria at the same time. -->

Il vantaggio di ciò è il seguente: costringendo il sistema a trovare rappresentazioni che possono ricostruire l'input, si sta praticamente distorcendo il sistema all'estrazione di caratteristiche che contengano il massimo dell'informazione riguardo l'input. In altre parole, arricchisce le caratteristiche.

<!-- The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features. -->

**Sparsità di gruppo**

<!-- **Group Sparsity** -->

Qui l'idea è di generare caratteristiche sparse, ma non normali caratteristiche estraibili tramite convoluzione, ma caratteristiche che siano sparse dopo l'operazione di aggregazione (*pooling*).

<!-- The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling. -->
<center>
<img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px"/><br>
<b>Fig. 2</b>: Autoencoder con sparsità di gruppo
</center>

<!-- **Fig 2:** Auto-Encoder with Group Sparsity -->

La Fig. 2 mostra un esempio di *autoencoder* con sparsità di gruppo. Qui, invece di passare la variabile latente $Z$ attraverso un $L_1$, grossomodo passa attraverso un $L_2$ di gruppo. Cioè, si calcola la norma $L_2$ per ogni componente in un gruppo di $Z$, e si prende la somma di queste norme. Così ora che abbiamo ciò che viene utilizzato come regolarizzatore, possiamo ottenere della sparsità all'interno di gruppi di $Z$. Questi gruppi, o insiemi di caratteristiche, tendono a raggruppare assieme caratteristiche che sono reciprocamente simili.

<!-- Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable Z going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of Z, and take the sum of those norms. So now that is what is used as the regularizer, so we can have sparsity on groups of Z. These groups, or pools of features, tend to group together features that are similar to one another. -->


## AE con sparsità di gruppo: domande e chiarimenti

<!-- ## AE With Group Sparsity: Questions and Clarification -->

*Domanda*: si può, per i VAE, in maniera simile a quanto fatto precedentemente, utilizzare una strategia del tipo classificatore + regolarizzatore?

<!-- Q: Can a similar used in the first slide strategy with classifier and regularizer can be applied for VAE? -->

*Risposta*: aggiungere rumore e forzare della sparsità in un VAE sono due strategie per ridurre l'informazione che giunge alla variabile latente / al codice. Prevengono l'apprendimento della funzione identità.

<!-- A: Adding noise and forcing sparity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function. -->

D: Nel capitolo "AE con sparsità di gruppo", cosa è $P_j$?

<!-- Q: In slide "AE with Group Sparsity", what is $P_j$? -->

R: $p$ è un'aggregazione di caratteristiche. Per un vettore $z$, equivale ad un sottoinsieme dei valori in $z$.

<!-- A: p is a pool of features. For a vector z, it would be a subset of the values in z. -->

D: *Chiarimento sull'aggregazione di caratteristiche*

<!-- Q: *Clarification on feature pooling.* -->

R: (*Yann LeCun disegna la rappresentazione degli AE con sparsità di gruppo*) Il codificatore produce la variabile latente $z$, che viene regolarizzata usando la norma $L_2$ delle caratteristiche aggregate. Questa $z$ è usata dal decodificatore per la ricostruzione delle immagini.

<!-- A: (Yan draws representation of AE with group sparsity) Encoder produces latent variable z, which is regularized using the $L_2$ norm of pooled features. This z is used by the decoder for image reconstruction. -->

D: La regolarizzazione di gruppo aiuta nel raggruppamento di caratteristiche simili?

<!-- Q: Does group regularization help with grouping similar features. -->

R: La risposta non è chiara, di lavoro su questo tema n'è stato fatto prima che ci fossero potenza computazionale o dati a disposizione. Queste tecniche non sono state più portate in primo piano.

<!-- A: The answer is unclear, work done here was done before computational power/ data was redily availiable. Techniques have not been brought back to the forefront. -->


## Addestramento a livello d'immagine, filtri locali senza condivisione dei pesi

<!-- ## Image Level Training, local filters but no weight sharing -->

Non è chiaro se questi siano d'aiuto o meno. Le persone interessate in questo tema sono o interessate nel restauro d'immagini o un certo tipo di apprendimento auto-supervisionato. Ciò funzionerebbe bene se il dataset fosse molto piccolo. Quando si hanno dei codificatori e decodificatori che sono convoluzionali che si addestrano con sparsità di gruppo su cellule complesse, dopo che è stato fatto il pre-addestramento, si prende il decodificatore e lo si scarta, si conserva il codificatore e lo si utilizza come estrattore di caratteristiche, ad esempio come primo strato di una rete convoluzionale, a cui si aggiungono ulteriori strati convoluzionali di seguito.

<!-- The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" height="300px"/><br>
<b>Fig. 3</b>: struttura di uno strato convoluzionale ReLU con sparsità di gruppo
</center>

<!-- **Fig 3?:** Structure of Convolutional RELU with Group Sparsity -->

Come si può notare sopra, s'inizia con un'immagine, si ha a disposizione un codificatore che è sostanzialmente uno strato convoluzionale ReLU e, di seguito, una sorta di strato di riscalamento. Si addestra la rete con sparsità di gruppo. Si ha un decodificatore lineare e un criterio di raggruppamento per 1. Si considera la sparsità di gruppo come un regolarizzatore. Ciò equivale ad effettuare un'aggregazione tramite norma $L_2$ con un'architettura simile alla sparsità di gruppo.

<!-- As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regularizer. This is like L2 pooling with an architecture similar to group sparsity. -->

Si può anche addestrare un'altra istanza della medesima rete. Stavolta, si possono aggiungere più strati e avere un decodificatore con l'aggregazione $L_2$ e un criterio di sparsità, lo si addestra a ricostruire l'input con un'aggregazione alla fine. Questo creerà una rete convoluzionale pre-addestrata di due strati. Questa procedura viene anche chiamata "*autoencoder* sovrapposti". La caratteristica pricipale qui è che la rete è addestrata per produrre caratteristiche invarianti con sparsità di gruppo.

<!-- You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity. -->

D: Si dovrebbero utilizzare tutti i possibili sotto-alberi come gruppi?

<!-- Q : Should we use all possible subtrees as groups ? -->

R: Sta a voi decidere, si possono avere anche alberi multipli se lo si desidera. Si pssono addestrare alberi più grandi del necessario, e poi rimuovere i rami non utilizzati.

<!-- A : It’s upto you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" height="300px"/><br>
<b>Fig. 4</b>: addestramento a livello d'immagine, filtri locali senza condivisione dei pesi
</center>

<!-- **Fig 4:** Image Level Training, local filters but no weight sharing -->

Questi sono chiamati *pattern* a girandola. Sono una tipologia di organizzazione delle caratteristiche. L'orientamento varia in continuazione come ci si muove attorno ai punti rossi. Se prendiamo uno di questi punti rossi e ci disegnamo attorno un piccolo cerchio, noteremo che l'orientamento dell'estrattore sembra variare in continuazione come ci si muove attorno. Trend simili si sono notati anche nel cervello.

<!-- These are called pinwheel patterns. This is a kind of organisation of the features. The orientation variously continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain. -->

D: Il termine relativo alla sparsità di gruppo è addestrato affinché assuma valori piccoli?

<!-- Q : Is the group sparsity term trained to have a small value? -->

È un regolarizzatore. Il termine in sé non viene addestrato, è fisso. È la norma $L_2$ dei gruppi, e i gruppi sono predeterminati. Ma, siccome questo è un criterio, determina che cosa il codificatore e il decodificatore faranno e che tipologia di caratteristiche saranno quindi estratte.

<!-- It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criteron, it determines what the encoder and decoder will do and what sort of features will be extracted. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" height="300px"/><br>
<b>Fig. 5</b>: caratteristiche invarianti ottenute tramite inibizione laterale
</center>

<!-- **Fig 4:** Invariant Features through Lateral Inhibiton -->

Qui c'è un decodificatore lineare con errore quadratico di ricostruzione. C'è un criterio nell'energia. La matrice $S$ è determinata a mano o addestrata per massimizzare questo termine. Se i termini in $S$ sono grandi e positivi, ne consegue che il sistema non vuole che $z_i$ e $z_j$ si attivino contemporaneamente. Di conseguenza, è una specie di mutua inibizione (chiamata inibizione naturale nelle neuroscienze). Di conseguenza, si cerca di trovare un valore di $S$ più grande possibile.

<!-- Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix SSS is either determined by hand or learned so as to maximise this term. If the terms in S are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuro science). Thus, you try to find a value for S that is as large as possible. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" height="300px"/><br>
<b>Fig. 6</b>: caratteristiche invarianti ottenute tramite inibizione laterale (forma ad albero)
</center>

<!-- **Fig 5:** Invariant Features through Lateral Inhibiton (Tree Form) -->

Organizzando $S$ nei termini di un albero, le linee rappresentano i termini a zero nella matrice $S$. La mancanza di una linea corrisponde ad un termine non-nullo. Quindi, ogni caratteristica inibisce tutte le altre, ad eccezione di quelle che si trovano più in alto o più in basso nell'albero. Ciò è come la converse della sparsità di gruppo.

<!-- If you organise S in terms of a tree, the lines represent the zero terms in the S matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features expect those which are up the tree or down the tree from it. This is something like the converse of group sparsity. -->

Si nota nuovamente come i sistemi organizzano le caratteristiche in una maniera più o meno continua. Le caratteristiche lungo i rami di un albero rappresentano le stesse caratteristiche con diversi livelli di selettività. Le caratteristiche lungo la periferia variano più o meno in maniera continua perché non c'è inibizione.

<!-- You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition. -->

Per addestrare questo sistema, ad ogni iterazione si dà come input al modello una $x$ e si trova un $z$ che minimizzi la funzione di energia. Quindi si opera un passo della discesa del gradiente per aggiornare $W$. Si può anche operare un passo di ascesa del gradiente per rendere i termini di $S$ più grandi.

<!-- To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger. -->
