---
lang-ref: ch.08-3
lang: it
title: Modelli generativi - autoencoder variazionali
authors: Richard Pang, Aja Klevs, Hsin-Rung Chou, Mrinal Jain
date: 27 March 2020
translation-date: 15 May 2020
translator: Marco Zullich
---
<!-- title: Generative Models - Variational Autoencoders -->

## Introduzione agli *autoencoder* variazionali (*Variational Autoencoders, VAE*)

<!-- ## Introduction to Variational Autoencoder (VAE) -->

### [Riepilogo: *autoencoder* (AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)

<!-- ### Recap: Auto-encoder (AE) -->

Per ricapitolare a grandi linee, una forma molto semplice di AE è composta come segue:

<!-- To summarize at a high level, a very simple form of AE is as follows: -->

- Prima di tutto, l'*autoencoder* prende un input e lo mappa in uno stato nascosto tramite una trasformazione affine $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, dove $f$ è una funzione di attivazione applicata elemento per elemento.
- Dopodiché, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, dove $g$ è una funzione di attivazione. Questa è la fase di **decodifica**.

<!-- - First, the autoencoder takes in an input and maps it to a hidden state through an affine transformation $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, where $f$ is an (element-wise) activation function. This is the **encoder** stage. Note that $\boldsymbol{h}$ is also called the **code**. -->
<!-- - Next, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, where $g$ is an activation function. This is the **decoder** stage. -->

*Per una spiegazione dettagliata, fare riferimento alle note della [settimana 7]({{site.baseurl}}/en/week07/07-3/).*

<!-- *For a detailed explaination, refer to the notes of [Week 7]({{site.baseurl}}/en/week07/07-3/).* -->

### Intuizione dietro ai VAE e paragone con gli *autoencoder* classici

<!-- ### Intuition behind VAE and a comparision with classic autoencoders -->

Di seguito, introdurremo gli *autoencoder* variazionali (VAE), un tipo di modello generativo. Per quale motivo ci interessiamo ai modelli generativi? Per rispondere a ciò, i modelli discriminativi imparano ad effettuare previsioni data un'osservazione, ma i modelli generativi mirano a simulare il processo di generazione dei dati. Una consequenza è che i modelli generativi possono comprendere meglio le relazioni causali sottostanti, il che porta a una migliore generalizzazione.

<!-- Next, we introduce Variational Autoencoders (or VAE), a type of generative models. But why do we even care about generative models? To answer the question, discriminative models learn to make predictions given some observations, but generative models aim to simulate the data generation process. One effect is that generative models can better understand the underlying causal relations which leads to better generalization. -->

Si noti che, sebbene VAE abbia gli *autoencoder* (AE) nel proprio nome (data la similarità strutturale o architettonica fra i due), gli AE e i VAE hanno formulazioni molto diverse. Si veda la *Fig. 1* sotto:

<!-- Note that although VAE has "Autoencoders" (AE) in its name (because of structural or architectural similarity to auto-encoders), the formulations between VAEs and AEs are very different. See *Figure 1* below. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Fig. 1</b>: VAE vs. AE classici
<!-- VAE vs. Classic AE -->
</center>

**Qual è la differenza tra *autoencoder* variazionali (VAE) e *autoencoder* classici (AE)?**

<!-- **What's the difference between variational auto-encoder (VAE) and classic auto-encoder (AE)?** -->

I VAE:
- Prima di tutto, la fase di codificazione: passiamo l'input $\boldsymbol{x}$ al codificatore (*encoder*). Anziché generare una rappresentazione nascosta $\boldsymbol{h}$ (il codice), il codice nei VAE comprende due elementi: $\mathbb{E}(\boldsymbol{z})$ e $\mathbb{V}(\boldsymbol{z})$ dove $\boldsymbol{z}$ è la variabile aleatoria latente che si comporta secondo una distribuzione gaussiana con media $\mathbb{E}(\boldsymbol{z})$ e varianza $\mathbb{V}(\boldsymbol{z})$. Si noti che nella pratica si utilizzano distribuzioni gaussiane, ma potrebbero teoricamente esserne usate di altre.
- Il codificatore sarà una funzione da $\mathcal{X}$ toa $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (qui denotiamo con $\boldsymbol{h}$ la concatenazione di $\mathbb{E}(\boldsymbol{z})$ e $\mathbb{V}(\boldsymbol{z})$).
- Dopodiché, opereremo un campionamento di $\boldsymbol{z}$ dalla distribuzione di cui sopra, parametrizzata dal codificatore; nello specifico, $\mathbb{E}(\boldsymbol{z})$ e $\mathbb{V}(\boldsymbol{z})$ sono passate ad un **campionatore** (*sampler*) per generare la variabile latente $\boldsymbol{z}$.
- Poi, $\boldsymbol{z}$ viene passato al decodificatore (*decoder*) per generare $\hat{\boldsymbol{x}}$.
- Il decodificatore sarà una funzione da $\mathcal{Z}$ a $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.

<!-- For VAE:
- First, the encoder stage: we pass the input $\boldsymbol{x}$ to the encoder. Instead of generating a hidden representation $\boldsymbol{h}$ (the code) in AE, the code in VAE comprises two things: $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ where $\boldsymbol{z}$ is the latent random variable following a Gaussian distribution with mean $\mathbb{E}(\boldsymbol{z})$ and variance $\mathbb{V}(\boldsymbol{z})$. Note that people use Gaussian distributions as the encoded distribution in practice, but other distributions can be used as well.
- The encoder will be a function from $\mathcal{X}$ to $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (here we use $\boldsymbol{h}$ to represent the concatenation of $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$).
- Next, we will sample $\boldsymbol{z}$ from the above distribution parametrized by the encoder; specifically, $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ are passed into a **sampler** to generate the latent variable $\boldsymbol{z}$.
- Next, $\boldsymbol{z}$ is passed into the decoder to generate $\hat{\boldsymbol{x}}$.
- The decoder will be a function from $\mathcal{Z}$ to $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$. -->

Di fatto, per un *autoencoder* classico, possiamo pensare a $\boldsymbol{h}$ come il solo vettore $\E(\boldsymbol{z})$ nella formulazione del VAE. In breve, la differenza principale fra i VAE e gli AE è che i primi hanno un buon spazio latente che permette l'attuazione di processi generativi.

<!-- In fact, for classic autoencoder, we can think of $\boldsymbol{h}$ as just the vector $\E(\boldsymbol{z})$ in the VAE formulation. In short, the main difference between VAEs and AEs is that VAEs have a good latent space that enables generative process. -->

### La funzione obiettivo (perdita) dei VAE

<!-- ### The VAE objective (loss) function -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Fig. 2</b>: mappatura dallo spazio di input allo spazio latente
<!-- Mapping from input space to latent space -->
</center>

*Si osservi la Fig. 2 qui sopra. Per ora, s'ignori l'angolo in alto a destra (che è il trucco della riparametrizzazione che verrà spiegato nella sezione successiva)*.

<!-- *See Figure 2 above. For now, ignore the top-right corner (which is the reparameterization trick explained in the next section).* -->

Prima di tutto, codifichiamo dallo spazio di input (a sinistra) allo spazio latente (a destra) tramite il codificatore e del rumore. Dopodiché, decodifichiamo dallo spazio latente (a destra) allo spazio di output (a sinistra). Per passare dallo spazio latente a quello d'input (passaggio che rappresenta il processo generativo) necessitiamo o di imparare la distribuzione (del codice latente) o di vincolare una certa struttura sullo spazio latente.

<!-- First, we encode from input space (left) to latent space (right), through encoder and noise. Next, we decode from latent space (right) to output space (left). To go from the latent to input space (the generative process) we will need to either learn the distribution (of the latent code) or enforce some structure. In our case, VAE enforces some structure to the latent space. -->

Come al solito, per addestrare un VAE, minimizziamo una funzione di perdita. La funzione di perdita è composta da un termine di ricostruzione e da un termine di regolarizzazione.
- Il termine di ricostruzione si trova nello strato finale (parte sinistra della figura). Questo corrisponde a $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ nella figura.
- Il termine di regolarizzazione si trova nello spazio latente, per imporre una struttura gaussiana specifica nello spazio latente (lato destro della figura). Operiamo ciò utilizzando un termine di penalità $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. In assenza di questo termine, il VAE si comporterebbe come un AE classico, il che potrebbe portare a sovradattamento (*overfitting*) e non avremmo a disposizione le proprietà generative alle quali siamo interessati.

<!-- As usual, to train VAE, we minimize a loss function. The loss function is therefore composed of a reconstruction term as well as a regularization term.
- The reconstruction term is on the final layer (left side of the figure). This corresponds to $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ in the figure.
- The regularization term is on the latent layer, to enforce some specific Gaussian structure on the latent space (right side of the figure). We do so by using a penalty term $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. Without this term, VAE will act like a classic autoencoder, which may lead to overfitting, and we won't have the generative properties that we desire. -->

### Discussione sul campionamento di $\boldsymbol{z}$ (**trucco della riparametrizzazione** -- *reparameterization trick*)

<!-- ### Discussion on sampling $\boldsymbol{z}$ (**reparameterization trick**) -->

Come operiamo il campionamento dalla distribuzione restituita dal codificatore nei VAE? Come dalla sezione precedente, campioniamo dalla distribuzione gaussiana, al fine di ottenere $\boldsymbol{z}$. Tuttavia, ciò è problematico, perché quando operiamo la discesa del gradiente per addestrare il modello VAE, non sappiamo come fare la retropropagazione attraverso il modulo di campionamento.

<!-- How do we sample from the distribution returned by the encoder in VAE? According to above, we sample from the Gaussian distribution, in order to obtain $\boldsymbol{z}$. However, this is problematic, because when we do gradient descent to train the VAE model, we don't know how to do backpropagation through the sampling module. -->

Invece, usiamo il **trucco della riparametrizzazione** per "campionare" $\boldsymbol{z}$. Utilizziamo $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ dove $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. In questo caso, la retropropagazione durante l'addestramento è possibile. Nello specifico, il gradiente passerà attraverso la moltiplicazione elemento per elemento e all'addizione come nell'equazione qui sopra.

<!-- Instead, we use the **reparameterization trick** to "sample" $\boldsymbol{z}$. We use $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ where $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. In this case, backpropagation in training is possible. Specifically, the gradients will go through the (element-wise) multiplication and addition in the above equation. -->

## [Dissezione della funzione di perdita dei VAE](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)

<!-- ## Breaking apart the VAE Loss Function -->

### Visualizzazioni delle stime della variabile latente e dalla perdita di ricostruzione

<!-- ### Visualizing Latent Variable Estimates and Reconstruction Loss -->

Come prima citato, la funzione di perdita dei VAE è composta di due parti: un termine di ricostruzione e un termine di regolarizzazione. Possiamo scrivere ciò come

<!-- As stated above, the loss function for the VAE contains two parts: a reconstruction term and a regularization term. We can write this as -->

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = l_{reconstruction} + \beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d))
$$

Per visualizzare lo scopo di ogni termine nella funzione di perdita, possiamo pensare ad ogni valore stimato $\boldsymbol{z}$ come un cerchio nello spazio $2D$, dove il centro del cerchio è $\mathbb{E}(\boldsymbol{z})$ e l'area circostante rappresenta i possibili valori di $\boldsymbol{z}$, area determinata da $\mathbb{V}(\boldsymbol{z})$.

<!-- To visualize the purpose of each term in the loss function, we can think of each estimated $\boldsymbol{z}$ value as a circle in $2d$ space, where the center of the circle is $\mathbb{E}(\boldsymbol{z})$ and the surrounding area are the possible values of $\boldsymbol{z}$ determined by $\mathbb{V}(\boldsymbol{z}).$ -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Fig. 3</b>: visualizzazione del vettore $z$ come bolle nello spazio latente
<!-- Visualizing vector z as bubbles in the latent space -->
</center>

_Nella Fig. 3 qui sopra, ogni bolla rappresenta una regione stimata di $\boldsymbol{z}$ e le frecce rappresentano come il termine di ricostruzione "allontani" ogni valore stimato dagli altri, fenomeno di cui spieghiamo di più qui sotto_.

<!-- *In Figure 3 above, each bubble represents an estimated region of $\boldsymbol{z}$, and the arrows represent how the reconstruction term pushes each estimated value away from the others, which is explained more below.* -->

Se c'è una sovrapposizione fra qualsiasi due stime di $z$ (visivamente, se due bolle si sovrappongono) ciò causa ambiguità al processo di ricostruzione perché i punti facenti parte dell'intersezione possono essere mappati a entrambi gli input originari. Quindi la perdita di ricostruzione allontanerà tali punti.

<!-- If there is overlap between any two estimates of $z$, (visually, if two bubbles overlap) this creates ambiguity for reconstruction because the points in the overlap can be mapped to both original inputs. Therefore the reconstruction loss will push the points away from one another. -->

Ad ogni modo, se usiamo solo la perdita di ricostruzione, le stime continueranno ad essere mutuamente allontanate e il sistema potrebbe divergere. Qui il termine di penalità entra in gioco

<!-- However, if we use just the reconstruction loss, the estimates will continue to be pushed away from each other and the system could blow up. This is where the penalty term comes in. -->

**Nota:** per input binari, la perdita di ricostruzione è

<!-- **Note:** for binary inputs the reconstruction loss is -->

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = - \sum\limits_{i=1}^n [x_i \log{(\hat{x_i})} + (1 - x_i)\log{(1-\hat{x_i})}]
$$

e per input a valori reali è

<!-- and for real valued inputs the reconstruction loss is -->

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = \frac{1}{2} \Vert\boldsymbol{x} - \hat{\boldsymbol{x}} \Vert^2
$$

### Il termine di penalità

<!-- ### The Penalty Term -->

Il secondo termine è l'entropia relativa (una misura di distanza fra due distribuzioni) tra $\boldsymbol{z}$, che proviene da una gaussiana con media $\mathbb{E}(\boldsymbol{z})$ e varianza $\mathbb{V}(\boldsymbol{z})$, e la distribuzione normale standard. Se espandiamo con questo termine, la funzione di perdita diviene

<!-- The second term is the relative entropy (a measure of the distance between two distributions) between $\boldsymbol{z}$ which comes from a gaussian with mean $\mathbb{E}(\boldsymbol{z})$, variance $\mathbb{V}(\boldsymbol{z})$ and the standard normal distribution. If we expand this second term in the VAE loss function we get: -->

$$
\beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d)) = \frac{\beta}{2} \sum\limits_{i=1}^d(\mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1 + \mathbb{E}(z_i)^2)
$$

dove ogni espressione nella sommatoria ha quattro termini. Sotto trascriviamo e rendiamo in un grafico il primo di questi termini (v. *Fig. 4*)

<!-- Where each expression in the summation has four terms. Below we write out and graph the first three terms in *Figure 4*. -->

$$
v_i = \mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1
$$

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Fig. 4</b>: grafico visualizzante l'effetto dell'entropia nel forzare le bolle ad avere varianza pari a 1
<!-- Plot showing how relative entropy forces the bubbles to have variance = 1 -->
</center>

Così possiamo vedere che questa espressione è minimizzata quando $z_i$ ha varianza 1. Quindi, il nostro termine di penalità terrà la varianza della stima della variabile latente circa attorno a 1. Visivamente, ciò si traduce nel fatto che le nostre bolle di cui sopra avranno un raggio di circa 1.

<!-- So we can see that this expression is minimized when $z_i$ has variance 1. Therefore our penalty loss will keep the variance of our estimated latent variables at around 1. Visually, this means our "bubbles" from above will have a radius of around 1. -->

L'ultimo termine, $\mathbb{E}(z_i)^2$, minimizza la distanza fra $z_i$ e quindi ne previene la divergenza incoraggiata dal termine di ricostruzione.

<!-- The last term, $\mathbb{E}(z_i)^2$, minimizes the distance between the $z_i$ and therefore prevents the "exploding" encouraged by the reconstruction term. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Fig. 5</b>: interpretazione della VAE come "bolla di bolle"
<!-- The "bubble-of-bubble" interpretation of VAE -->
</center>

*La Fig. 5 qui sopra mostra come la perdita del VAE spinge le variabili latenti stimate il più vicino possibile senza sovrapposizioni, tenendo la varianza stimata di ogni punto attorno a uno.*

<!-- *Figure 5 above shows how VAE loss pushed the estimated latent variables as close together as possible without any overlap while keeping the estimated variance of each point around one.* -->

**Nota:** il $\beta$ nella funzione di perdita del VAE è un iperparametro che detta quanto peso dare al termine di ricostruzione e a quello di penalità.

<!-- **Note:** The $\beta$ in the VAE loss function is a hyperparameter that dictates how to weight the reconstruction and penalty terms. -->

## [Implementazione di un *autoencoder* variazionale](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)

<!-- ## Implementation of Variational Autoencoder (VAE) -->

Il *notebook* di Jupyter può essere reperito [qui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb).

<!-- The jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb). -->

In questo *notebook*, implementiamo un VAE e lo addestriamo sul dataset MNIST. Quindi campioniamo $\boldsymbol{z}$ da una distribuzione normale e lo diamo come input al decodificatore e compariamo il risultato. Infine, vediamo come $\boldsymbol{z}$ cambia in proiezioni bidimensionali.

<!-- In this notebook, we implement a VAE and train it on the MNIST dataset. Then we sample $\boldsymbol{z}$ from a normal distribution and feed to the decoder and compare the result. Finally, we look at how $\boldsymbol{z}$ changes in 2D projection. -->

**Nota:** nel dataset di MNIST che utilizziamo, i valori dei pixel sono stati normalizzati affinché rientrino nel range $[0, 1]$.

<!-- **Note:** In the MNIST dataset used, the pixel values have been normalized to be in range $[0, 1]$. -->

### Il codificatore e il decodificatore

<!-- ### The Encoder and the Decoder -->

1. Definiamo il codificatore (`encoder`) e il decodificatore (`decoder`) nel nostro modulo `VAE`.
2. Nell'ultimo strato lineare del codificatore, poniamo la grandezza dell'output pari a $2d$: i primi $d$ valori rappresentano le medie; i successivi $d$ sono le varianze. Campioniamo $boldsymbol{z} \in R^d$ utilizzando media e varianza come spiegato nel trucco della riparametrizzazione prima citato.
3. Per l'ultimo strato lineare nel decodificatore, usiamo la funzione di attivazione sigmoidale così che possiamo ottenere output nel range $[0, 1]$, analogamente ai dati di input.

<!-- 1. We define the encoder and decoder in our `VAE` module.
2. For the last linear layer of encoder, we define the output to be of size $2d$, of which the first $d$ values are the means and the remaining $d$ values are the variances. We sample $\boldsymbol{z} \in R^d$ using these means and variances as explained in the reparameterization trick before.
3. For the last linear layer in the decoder, we use the sigmoid activation so that we can have output in range $[0, 1]$, similar to the input data. -->

```python
class VAE(nn.Module):
def __init__(self):
super().__init__()

self.encoder = nn.Sequential(
nn.Linear(784, d ** 2),
nn.ReLU(),
nn.Linear(d ** 2, d * 2)
)

self.decoder = nn.Sequential(
nn.Linear(d, d ** 2),
nn.ReLU(),
nn.Linear(d ** 2, 784),
nn.Sigmoid(),
)
```

### La riparametrizzazione e la funzione `forward`

<!-- ### Reparameterization and the `forward` function -->

Per la funzione di riparametrizzazione `reparametrise`, se il modello è in modalità di addestramento (`train`), calcoliamo la deviazione standard (`std`) dalla varianza al logaritmo (`logvar`). Usiamo quest'ultima anziché la varianza perché vogliamo essere sicuri che la varianza non sia negativa, e prenderne il logaritmo ci assicura che abbiamo il range completo della varianza, il che si traduce in un addestramento più stabile.

<!-- For the `reparameterise` function, if the model is in training mode, we compute the standard deviation (`std`) from log variance (`logvar`). We use log variance instead of variance because we want to make sure the variance is non-negative, and taking the log of it ensures that we have the full range of the variance, which makes the training more stable. -->

Durante l'addestramento, `reparametrise` opererà il trucco della riparametrizzazione permettendoci di svolgere la retropropagazione. Connettendoci al concetto delle bolle, come spiegato nel corso della lezione, ogni volta che questa funzione viene chiamata, disegniamo un punto `eps = std.data.new(std.size()).normal_()`, così che, se lo facciamo 100 volte, otterremo 100 punti che grosso modo formano una sfera, perché stiamo campionando da una distribuzione normale; la linea di codice `eps.mul(std).add_(mu)` centrerà questa sfera in `mu` con raggio uguale a `std`.

<!-- During training, the `reparameterise` function will do the reparameterization trick so that we can do backpropagation in training. To connect to the concept of a yellow bubble, as explained in the lecture, everytime this function is called, we draw a point `eps = std.data.new(std.size()).normal_()`, so if we do 100 times, we will get 100 points which roughly forms a sphere because it's normal distribution, and the line `eps.mul(std).add_(mu)` will make this sphere centered in `mu` with radius equal to `std`. -->

Per quanto riguarda la funzione `forward`, prima computiamo `mu` (prima metà), poi la `logvar` (seconda metà) per il codificatore, dopodiché computiamo $\boldsymbol{z}$ tramite la funzione `reparametrise`. Infine, restituiamo l'output del decodificatore.

<!-- For the `forward` function, we first compute the `mu` (first half) and `logvar` (second half) from the encoder, then we compute the $\boldsymbol{z}$ via the `reparamterise` function. Finally, we return the output of the decoder. -->

```python
def reparameterise(self, mu, logvar):
if self.training:
std = logvar.mul(0.5).exp_()
eps = std.data.new(std.size()).normal_()
return eps.mul(std).add_(mu)
else:
return mu

def forward(self, x):
mu_logvar = self.encoder(x.view(-1, 784)).view(-1, 2, d)
mu = mu_logvar[:, 0, :]
logvar = mu_logvar[:, 1, :]
z = self.reparameterise(mu, logvar)
return self.decoder(z), mu, logvar
```

### Funzione di perdita per il VAE

<!-- ### Loss function for the VAE -->

Qui definiamo l'errore di ricostruzione (entropia incrociata binaria -- *binary cross-entropy*) e l'entropia relativa (penalità corrispondente alla divergenza di Kullback-Leibler).

<!-- Here we define the reconstruction loss (binary cross entropy) and the relative entropy (KL divergence penalty). -->

```python
def loss_function(x_hat, x, mu, logvar):
BCE = nn.functional.binary_cross_entropy(
x_hat, x.view(-1, 784), reduction='sum'
)
KLD = 0.5 * torch.sum(logvar.exp() - logvar - 1 + mu.pow(2))

return BCE + KLD
```

### Generazione di nuove osservazioni

<!-- ### Generating new samples -->

Dopo l'addestramento del nostro nodello, possiamo campionare un $z$ casuale dalla distribuzione normale e darlo come input al nostro decodificatore. Possiamo osservare, in *Fig. 6*, che alcuni di questi risultati non siano buoni in quanto il nostro decodificatore non ha "coperto" l'intero spazio latente. Ciò si può migliorare addestrando il modello per più epoche.

<!-- After we train our model, we can sample a random $z$ from the normal distribution and feed it to our decoder. We can observe in *Figure 6* that some of the results are not good because our decoder has not "covered" the whole latent space. This can be improved if we train the model for more epochs. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Fig. 6</b>: movimenti casuali nello spazio latente
<!-- Randomly moving in the latent space -->
</center>

Possiamo osservare come vi siano delle fusioni fra cifre, il che non sarebbe stato possibile se avessimo usato un *autoencoder*. Possiamo vedere che, percorrendo lo spazio latente, l'output del decodificatore sembri ancora autentico. La *Fig. 7* di sotto mostra la fusione della cifra $3$ nella cifra $8$.

<!-- We can look at how one digit morphs into another, which would not have been possible if we used an autoencoder. We can see that when we walk in the latent space, the output of the decoder still looks legit. *Figure 7* below shows how we morph the digit $3$ to $8$. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: fusione del 3 in 8
<!-- Morphing the digit 3 into 8 -->
</center>

### Proiezione delle medie

<!-- ### Projection of means -->

Infine, diamo un'occhiata a come lo spazio latente varia durante/dopo l'addestramento. I grafici in *Fig. 8* rappresentano la media dell'output del codificatore, proiettate nello spazio 2D, dove ogni colore rappresenta una cifra. Possiamo vedere che all'epoca 0 le classi sono sparpagliate ovunque, con poca concentrazione. Come il modello viene addestrato, lo spazio latente diviene meglio definito e le classi (le cifre) iniziano a formare dei *cluster*.

<!-- Finally, let's take a look at how the latent space changes during/after training. The following charts in *Figure 8* are the means from the output of the encoder, projected on 2D space, where each color represents a digit. We can see that from epoch 0, the classes are spreading everywhere, with only little concentration. As the model is trained, the latent space becomes more well-defined and the classes (digits) starts to form clusters. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Fig. 8</b>: proiezione in 2D delle medie $\E(\vect{z})$ nello spazio latente
<!-- 2D projection of the means $\E(\vect{z})$ in latent space -->
</center>
