---
lang-ref: ch.08-2
lang: it
lecturer: Yann LeCun
title: Modelli ad energia a variabile latente regolarizzata
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 23 Mar 2020
translation-date: 12 May 2020
translator: Marco Zullich
---
<!-- Regularized Latent Variable Energy Based Models -->

## [EBM a variabile latente regolarizzata](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

I modelli a variabile latente sono capaci di produrre una distribuzione di previsioni $\overline{y}$ condizionate a un input osservato $x$ e una *variabile latente* aggiuntiva $z$. I modelli basati sull'energia possono anche contenere variabili latenti:

<!-- ## Regularized Latent Variable EBMs

Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables: -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Fig. 1</b>: Esempio di EBM con variabile latente
<!-- Example of an EBM with a latent variable -->
</center>

Si vedano gli appunti della precedente lezione per maggiori dettagli.

<!-- See the previous lecture's notes for more details. -->

Sfortunatamente, se la variabile latente $z$ ha troppa potenza espressiva nella produzione della previsione finale $\overline{y}$, ogni output reale $y$ verrà perfettamente ricostruito a partire dall'input $x$ tramite un $z$ scelto in maniera appropriata. Ciò significa che la funzione di energia sarà 0 ovunque, poiché l'energia è ottimizzata su entrambi gli $y$ e i $z$ durante l'inferenza.

<!-- Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference. -->

Una soluzione naturale è limitare la capacità d'informazione della variabile latente $z$. Un modo per ottenere ciò è tramite regolarizzazione della variabile latente:

<!-- A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable: -->

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

Questo metodo limiterà il volume dello spazio di $z$ a valori molto piccoli; valori che, a loro volta, determineranno lo spazio di $y$ a bassa energia. Il valore di $\lambda$ controlla questo compromesso. Un esempio utile per $R$ è la norma $L_1$, la quale può essere vista come un'approssimazione quasi-ovunque differenziabile della dimensione effettiva. Aggiungendo rumore a $z$ contemporaneamente limitandone la sua norma $L_2$ può anche risultare nella limitazione del suo contenuto informativo.

<!-- This method will limit the volume of space of z which takes a small value and the value which will, in turn, controls the space of y that has low energy. The value of Lambda controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE). -->

### Codificazione sparsa (*Sparse Coding*)

<!-- ### Sparse Coding -->

La codificazione sparsa è un esempio di EBM a variabile latente regolarizzata e incondizionata: essenzialmente, il suo scopo è quello di approssimare i dati con una funzione lineare a tratti.

<!-- Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function. -->

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

Il vettore $n$-dimensionale $z$ tenderà ad avere un numero massimo di componenti non-nulle $m << n$; quindi, ogni $Wz$ sarà composto da elementi del sottospazio generato da $m$ colonne di $W$.

<!-- The $n$-dimensional vector $z$ will tend to have a maximum number of nonzero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$. -->

Dopo ogni passo di ottimizzazione, la matrice $W$ e la variabile latente $z$ vengono normalizzate dalla somma delle norme $L_2$ delle colonne di $W$. Ciò garantisce che $W$ e $z$ non divergano a infinito o a zero.

<!-- After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero. -->

### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Fig. 2</b>: grafico computazionale di FISTA
<!-- FISTA computation graph -->
</center>

FISTA (*Fast ISTA*) è un algoritmo che ottimizza la funzione di energia per codificazione sparsa $E(y,z)$ rispetto $z$ ottimizzando in maniera alternata i due termini $\Vert y - Wz\Vert^2$ e $\lambda \Vert z\Vert_{L^1}$. Inizializziamo $Z(0)$ e aggiorniamo $Z$ in maniera iterativa secondo la regola seguente:

<!-- FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule: -->

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

L'espressione interna $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ è un passo del gradiente per il termine $\Vert y - Wz\Vert^2$. La funzione di *contrazione* $\text{Shrinkage}$ trasla, dopodiché, i valori verso 0, poi ottimizza il termine $\lambda \Vert z\Vert_{L_1}$.

<!-- The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term. -->

### LISTA

FISTA è computazionalmente troppo costoso da applicare a grandi insiemi di dati con alta dimensionalità (ad esempio, le immagini). Un modo per renderlo più efficiente è invece quello di addestrare una rete per predire la variabile latente $z$ ottimale:

<!-- FISTA is too expensive to apply to large sets of high-dimensional data (e.g. images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$: -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Fig. 3</b>: EBM con codificatore della variabile latente
<!-- EBM with latent variable encoder -->
</center>

L'energia di questa architettura include un termine aggiuntivo per misurare la differenza fra la variabile latente prevista $\overline z$ e la variabile latente ottimale $z$:

<!-- The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$: -->

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

Possiamo inoltre definire

<!-- We can further define -->

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

e quindi scrivere

<!-- and then write -->

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

Questa regola di aggiornamento può essere interpretata come una rete ricorsiva, il che dà l'idea che possiamo invece apprendere i parametri $W_e$ i quali determinano iterativamente la variabile latente $z$. La rete viene fatta agire per un numero fissato di istanti temporali $K$ e i gradienti di $W_e$ sono calcolati usando la classica retropropagazione nel tempo. La rete addestrata produce quindi un buon $z$ in un numero minore d'iterazioni rispetto all'algoritmo FISTA.

<!-- This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Fig. 4</b>: LISTA visualizzata come una rete ricorrente dispiegata nel tempo.
<!-- LISTA as a recurrent net unfolded through time. -->
</center>

### Esempi di codificazione sparsa

<!-- ### Sparse Coding Examples -->

Quando un sistema di codificazione sparsa con vettore latente di 256 dimensioni viene applicato alle cifre manoscritte di MNIST, impara un insieme di 256 tratti che possono essere combinati in maniera lineare per riprodurre quasi perfettamente l'intero dataset di addestramento. Il regolarizzatore sparso assicura che essi possano essere riprodotti a partire da un piccolo numero di tratti.

<!-- When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Fig. 5</b>: codificatore sparso su MNIST. Ogni immagine è una colonna addestrata di $W$.
<!-- Sparse coding on MNIST. Each image is a learned column of W. -->
</center>

Quando un sistema di codificazione sparsa è addestrato su pezzi d'immagini naturali, le caratteristiche apprese sono filtri di Gabor, ovvero bordi orientati. Queste caratteristiche assomigliano a quelle imparate nelle prime parti dei sistemi visivi animali.

<!-- When a sparse coding system is trained on natural image patches, the learned features are gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems. -->

### [Codificazione sparsa convoluzionale](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

<!-- ### Convolutional Sparse Coding -->

Supponiamo di avere un'immagine e una mappa delle caratteristiche ($z_1z_2...z_n$) dell'immagine. Possiamo quindi operare una convoluzione ($*$) su ciascuna delle mappe delle caratteristiche con un filtro $K_i$. Conseguentemente, la ricostruzione può essere calcolata semplicemente come:

$$Y=\sum_{i}K_i*Z_i$$

<!-- Suppose, we have an image and the feature maps ($z_1z_2...z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as: -->

$$Y=\sum_{i}K_i*Z_i$$

Ciò differisce dalla codificazione sparsa originale, dove la ricostruzione era effettuata come $Y=\sum_{i}W_iZ_i$. Nella codificazione sparsa regolare, abbiamo una somma pesata di colonne dove i pesi sono i coefficienti di $Z_i$. Nella codificazione sparsa convoluzionale, è ancora un'operazione lineare, ma la matrice-dizionario ora è un insieme di mappe delle caratteristiche le quali sono convolute con ogni filtro; infine, sommiamo i risultati delle convoluzioni.

<!-- This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results. -->

#### *Autoencoder* convoluzionale sparso su immagini naturali

<!-- #### Convolutional Sparse Auto-Encoder on Natural Images -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Fig. 6</b> filtri e funzioni di base ottenute. Decodificatore convoluzionale lineare
<!-- Filters and Basis Functions obtained. Linear convolutional decoder -->
</center>

I filtri nel codificatore e nel codificatore appaiono molto simili. Il codificatore è semplicemente una convoluzione seguita da non-linearità e quindi uno strato diagonale per variare la scala. Dopodiché la sparsità è imposta dal vincolo del codice. Il decodificatore è nient'altro che un decodificatore lineare convoluzionale e la ricostruzione utilizzata è l'errore al quadrato.

<!-- The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error. -->

Di conseguenza, se imponiamo che ci sia solo un filtro, allora questo sarà del tipo *center-surround*. Con due filtri, possiamo ottenere dei filtri dalle forme bizzarre. Con quattro filtri, otteniamo bordi orientati (orizzontali e verticali); abbiamo due polarità per ogni filtro. Con otto filtri, possiamo ottenere bordi orientati in 8 orientamenti diversi. Con 16, otteniamo più orientamenti compresi i *centers-around*. All'aumentare del numero di filtri, otteniamo filtri diversi in aggiunta a quelli per i bordi orientati; ad esempio filtri per il riconoscimento di reticoli (*grating*), *centers-around*, ecc.

<!-- So, if we impose that there is only one filter then it is just a center surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centers around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centers around, etc. -->

Questo fenomeno sembra essere interessante in quanto è simile a quanto si osserva nella corteccia visiva. Questa è quindi un'indicazione che possiamo apprendere caratteristiche molto buone in una maniera completamente non-supervisionata.

<!-- This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way. -->

Come uso secondario, se prendiamo queste caratteristiche e le utilizziamo in una rete convoluzionale e le addestriamo su un qualche compito, non otteniamo necessariamente risultati migliori rispetto all'addestramento della rete da zero. Comunque, ci sono certe situazioni in cui ciò può aiutare a migliorare le performance. Ad esempio, nei casi dove il numero di istanze non è molto grande o ci sono poche categorie, addestrando in maniera completamente supervisionata, otteniamo delle caratteristiche degeneri.

<!-- As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Fig. 7 </b> codificazione convoluzionale sparsa su un'immagine a colori
<!-- Convolutional sparse encoding on color image -->
</center>

La figura qui sopra rappresenta un altro esempio su un'immagine a colori. Il filtro di decodificazione (a destra) ha dimensione 9 per 9. Questo filtro viene applicato in maniera convoluzionale sull'intera immagine. L'immagine a sinistra è del codice sparso ottenuto dal codificatore. Il vettore $Z$ è molto sparso: ci sono pochissime componenti che sono bianche o nere (non grigie).

<!-- The figure above is another example on color images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-gray). -->

### [*Autoencoder* variazionali (*Variational Autoencoder*)](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)

<!-- ### Variational Autoencoder -->

Gli *autoencoder* variazionali hanno un'architettura simile agli EBM con variabile latente regolarizzata, con l'eccezione della sparsità. Negli *autoencoder* variazionali, il contenuto informativo del codice è limitato dalla rumorosità.

<!-- Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Fig. 8</b>: architettura di un *autoencoder* variazionale
<!-- Architecture of Variational Autoencoder -->
</center>

La variabile latente $z$ non è ottenuta minimizzando la funzione di energia rispetto a $z$; invece, la funzione di energia è visualizzata tramite il campionamento casuale di $z$ secondo una distribuzione, collegata a ${\overline z}$, il cui logaritmo rappresenta il costo. La distribuzione è una gaussiana con media ${\overline z}$; ciò risulta nell'aggiunta di rumore a ${\overline z}$.

<!-- The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$. -->

I vettori della codifica con aggiunta di rumore gaussiano possono essere visualizzati come sfere sfocate, come mostrato in Fig. 9(a).

<!-- The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 8(a). -->

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) insieme originale di sfere sfocate <!--Original set of fuzzy balls--> </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) movimento delle sfere sfocate per effetto della minimizzazione di energia in assenza di regolarizzazione<!--Movement of fuzzy balls due to energy minimization without regularization--></center> |

<center><b>Fig. 9:</b> effetto della minimizzazione dell'energia sulle sfere sfocate
<!-- Effect of energy minimization on fuzzy balls -->
</center>

Il sistema cerca di rendere il vettore della codifica $\overline z}$ più grande possibile in modo da limitare al massimo l'effetto del rumore $z$. Ciò risulta in una sfera sfocata che si allontana dall'origine come mostrato in Fig. 9(b). Un'altra ragione per cui il sistema cerca di rendere il vettore della codifica grande è per prevenire la sovrapposizione delle sfere sfocate, il che creerebbe al decodificatore confusione fra le diverse istanze durante la fase di ricostruzione.

<!-- The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 8(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction. -->

Tuttavia, si vuole che le sfere sfocate si concentrino attorno una varietà dei dati, se ce n'è una. Di conseguenza, i vettori delle codifiche vengono regolarizzati in modo tale da avere una media e una varianza vicine a zero. Per fare ciò, le "colleghiamo" all'origine con una molla, come mostra la Fig. 10.

<!-- But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 9. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Fig. 10</b>: gli effetti della regolarizzazione visualizzati tramite molle.
<!-- Effects of regularization visualized with springs -->
</center>

La forza della molla determina quanto vicine le sfere sfocate sono all'origine. Se la molla è troppo debole, le sfere si allontanano troppo dall'origine, risultando in alti valori di energia. Per prevenire ciò, il sistema permette alle sfere di sovrapporsi solo se le istanze corrispondenti sono simili.

<!-- The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar. -->

Non è possibile adattare la dimensione delle sfere sfocate. Essa è limitata da una funzione di penalità (divergenza di Kullback-Leibler) che cerca di rendere la varianza vicina ad 1 così che la dimensione della sfera non sia né troppo grande né troppo piccola da collassare.

<!-- It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses. -->
