---
lang-ref: ch.08-1
lang: it
lecturer: Yann LeCun
title: Metodi contrastivi nei modelli ad energia
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
translation-date: 10 May 2020
---

## [Riassunto](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)
<!-- title: Contrastive Methods in Energy-Based Models -->

Il dr. LeCun ha passato i primi 15 min circa riassumendo i modelli ad energia (*energy based models, EBM*). Si faccia riferimento alle lezioni della settimana scorsa (Settimana 7) per queste informazioni, specialmente per i concetti riguardanti i metodi di apprendimento contrastivo.

<!-- Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods. -->

Come abbiamo appreso dall'ultima lezione, ci sono due classi principali di modelli per l'apprendimento ad energia:
1. Metodi contrastivi, che fanno decrescere l'energia dei dati di addestramento, $F(x_i, y_i)$, mentre la fanno decrescere nelle altre aree, $F(x_i, y’)$.
2. Metodi architettonici, che costruiscono la funzione di energia $F$ in modo tale da presentare poche o limitate regioni a bassa energia tramite l'applicazione di regolarizzazioni.

<!-- As we have learned from the last lecture, there are two main classes of energy-based learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function F which has minimized/limited low energy regions by applying regularization. -->

Al fine di distinguere le caratteristiche dei diversi metodi di addestramento, il dr. Yann LeCun ha inoltre sintetizzato 7 strategie di addestramento dalle categorie prima menzionate. Una di queste racchiude i metodi che sono simili al metodo di massima verosimiglianza (*Maximum Likelihood*).

<!-- To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method. -->

La massima verosimiglianza diminuisce l'energia dei punti dei dati di addestramento e la diminuisce per tutti i punti $y’\neq y_i$ in maniera probabilistica. Essa non si "interessa" dei valori assoluti di energia, ma solamente della differenza fra le energie. Siccome le distribuzioni di probabilità sono sempre normalizzate affinché sommino o integrino a 1, comparare il rapporto tra due punti è più utile rispetto a comparare valori assoluti.

<!-- Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn’t “care” about the absolute values of energies but only “cares” about the difference in energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values. -->

## [Metodi contrastivi nell'apprendimento auto-supervisionato](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!-- ## Contrastive Methods in Self-Supervised Learning -->

Nei metodi contrastivi, diminuiamo l'energia dei punti di addestramento ($x_i$, $y_i$), allo stesso momento aumentando l'energia dei punti esterni alla varietà dei dati.

<!-- In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold. -->

Nell'appredimento auto-supervisionato (*self-supervised learning, SSL*), utilizziamo una parte dell'input per predirne le parte restanti. Speriamo che il nostro modello possa produrre delle buone caratteristiche per la visione artificiale in modo tale che possano competere con quelle ottenute dai compiti supervisionati.

<!-- In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks. -->

I ricercatori hanno verificato in maniera empirica che l'applicazione dei metodi contrastivi di *incorporazione* (*embedding*) ai metodi di apprendimento auto-supervisionato può infatti portare a buone performance comparabili a quelle dei modelli supervisionati. Sotto esploreremo alcuni di questi metodi e vedremo i loro risultati.

<!-- Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below. -->

### Incorporamento contrastivo (*Contrastive Embedding*)

<!-- ### Contrastive Embedding -->

Si consideri una coppia ($x$, $y$) tale che $x$ sia un'immagine e $y$ una trasformazione di $x$ (rotazione, ingrandimento, ritaglio, *ecc.*) che ne preservi il contenuto. La denominiamo coppia **positiva**.

<!-- Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, etc). We call this a **positive** pair. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: coppia positiva
<!-- Positive Pair -->
</center>

Concettualmente, l'incorporamento contrastivo prende una rete convoluzionale a cui dà in input $x$ e $y$, ottenendo due vettori di caratteristiche: $h$ e $h'$. Siccome $x$ e $y$ hanno lo stesso contenuto (ovvero, sono una coppia positiva), vogliamo che i loro vettori di caratteristiche siano più simili possibile. Perciò, scegliamo una metrica di similarità (come il coseno di similitudine) e una funzione di perdita che massimizzi la similarità fra $h$ e $h'$. Facendo ciò, abbassiamo l'energia per le immagini facenti parte della varietà dei dati di addestramento.

<!-- Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (i.e a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: coppia negativa
<!-- Negative Pair -->
</center>

Tuttavia, dobbiamo ancora aumentare l'energia per i punti al di fuori di questa varietà. Quindi generiamo esempi **negativi** ($x_{\text{neg}}$, $y_{\text{neg}}$), ovvero immagini con diverso contenuto (ad esempio, aventi diversa categorizzazione). Le utilizziamo come input alla nostra rete di cui sopra, ottenendo i vettori di caratteristiche $h$ e $h'$, e proviamo a minimizzare la similarità fra di loro.

<!-- However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them. -->

Questo metodo ci permette di "spingere" in basso l'energia di coppie simili, "spingendo" in alto l'energia di coppie dissimili.

<!-- This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs. -->

Risultati recenti (su *ImageNet*) hanno mostrato che questo metodo può produrre caratteristiche valide per il riconoscimento di oggetti e che possono competere con quelle apprese tramite metodi supervisionati.

<!-- Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods. -->

<!-- ### Self-Supervised Results (MoCo, PIRL, SimCLR) -->

### Risultati di metodi auto-supervisionati (*MoCo*, *PIRL*, *SimCLR*)

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL e MoCo su ImageNet
<!-- PIRL and MoCo on ImageNet -->
</center>

Come vediamo dalla figura sopra, *PIRL* e *MoCo* ottengono risultati allo stato dell'arte (specialmente per modelli a bassa capacità, con un basso numero di parametri). *PIRL* sta iniziando ad avvicinarsi al livello di accuratezza di riferimento per i modelli supervisionati.

<!-- As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRl is starting to approach the top-1 linear accuracy of supervised baselines (~75%). -->

Possiamo comprendere *PIRL* un po' meglio vedendo la sua funzione obiettivo: NCE (*Noise Contrastive Estimator*, stimatore contrastivo del rumore), come di seguito.

<!-- We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows. -->

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

Qui utilizziamo il coseno di similarità come metrica di similarità fra due vettori/mappe di caratteristiche.

<!-- Here we define the similarity metric between two feature maps/vectors as the cosine similarity. -->

*PIRL* non utilizza direttamente l'output dell'estrattore convoluzionale di caratteristiche; definisce, invece, diversi "capi" $f$ e $g$, i quali possono essere concepiti come strati indipendenti da collocare al di sopra dell'estrattore convoluzionale di caratteristiche "di base".

<!-- What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor. -->

Componendo tutti i pezzi assieme, la funzione obiettivo di *PIRL*, *NCE*, funziona come di seguito. In un *mini-batch* abbiamo una coppia positiva (simile) e tante coppie negative (dissimili). Calcoliamo quindi la similarità tra il vettore di caratteristiche dell'immagine trasformate ($I^t$) e i restanti vettori delle caratteristiche del *mini-batch* (uno positivo, gli altri negativi). Dopodiché calcoliamo il punteggio di una funzione pseudo-esponenziale normalizzata (pseudo-*softmax*) sulla coppia positiva. Massimizzare il punteggio di una funzione *softmax* significa minimizzare i restanti punteggi, il che è esattamente il desiderata per i modelli basati sull'energia. La funzione di perdita finale, quindi, ci permette di costruire un modello che diminuisce l'energia per le coppie simili e l'aumenta per coppie dissimili.

<!-- Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs. -->

Il dr. LeCun menziona il fatto che, affinché ciò funzioni, è richiesto un grande numero di coppie negative. Nell'*SGD*, può essere complicato mantenere costantemente un gran numero di queste coppie nei *mini-batch*. Di conseguenza, *PIRL* utilizza anche un banco di memoria temporanea fungente da "deposito".

<!-- Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank. -->

**Domanda**: perché utilizziamo il coseno di similarità anziché la norma L2?
Risposta: con la norma L2 è molto facile rendere due vettori simili se corti (vicini al centro) o renderli dissimili se molto lunghi (lontani dal centro). Questo perché la norma L2 è una somma dei quadrati delle differenze parziali fra i due vettori. Di conseguenza, usando il coseno di similarità, si forza il sistema a trovare una buona soluzione senza "imbrogliare" rendendo i vettori corti o lunghi.

<!-- **Question**: Why do we use cosine similarity instead of L2 Norm? -->
<!-- Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to center) or make two vectors dissimilar by making them very "long" (away from the center). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long. -->

### *SimCLR*

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: risultati di SimCLR su ImageNet
<!-- SimCLR Results on ImageNet -->
</center>

*SimCLR* ha risultati migliori rispetto ai metodi precedenti. Infatti, raggiunge le performance dei metodi supervisionati su *ImageNet*. La sua tecnica utilizza un sofisticato metodo di aumento dei dati (*data augmentation*) per generare coppie simili; inoltre, viene addestrato per una quantità di tempo massiccia (con una grandezza del *mini-batch* molto elevata) sulle TPU. Il dr. LeCun crede che *SimCLR* mostri, in qualche misura, le limitazioni dei metodi contrastivi. Ci sono molte, molte regioni di uno spazio ad alta dimensionalità dove bisogna incrementare l'energia per assicurarsi che sia maggiore di quella della varietà dei dati. All'aumentare delle dimensioni della rappresentazione, si necessita di un numero sempre crescente di campioni negativi affinché ci si possa assicurare che l'energia sia più alta in quei luoghi dello spazio non appartenenti alla varietà.

<!-- SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold. -->


## [*Autoencoder* per la riduzione del rumore (*denoising autoencoder*)](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!-- ## Denoising Autoencoder -->

Nella [pratica della settimana 7](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), abbiamo discusso degli *autoencoder* per la riduzione del rumore (*denoising autoencoder*). Questo modello tende ad apprendere la rappresentazione dei dati tramite ricostruzione di un input perturbato nell'input originale. Più specificamente, addestriamo il sistema a produrre una funzione di energia che cresce in maniera quadratica all'allontanarsi dei dati perturbati dalla varietà dei dati.

<!-- In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: architettura di un autoencoder per la riduzione del rumore
<!-- Architecture of denoising autoencoder -->
</center>

### Problematiche

Tuttavia, ci sono anche numerosi problemi con gli autoencoder per la riduzione del rumore. Uno di questi è che in uno spazio continuo ad alta dimensionalità ci sono innumerevoli modi di perturbare un dato. Per cui, non ci sono garanzie che si possa dare forma alla funzione di energia semplicemente aumentandola in un gran numero di regioni dello spazio. Un altro problema con questo modello è che produce scarsi risultati con le immagini a causa della mancanza di variabili latenti. Siccome ci sono vari modi per ricostruire un'immagine, il sistema produce diverse previsioni e non impara caratteristiche particolarmente buone. Inoltre, i punti che, perturbati, rimangono all'interno della varietà, possono essere ricostruiti verso più direzioni. Questo creerà regioni piane all'interno della funzione di energia, le quali inficeranno la performance globale.

<!-- ### Issues -->
<!-- However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance. -->

## Altri metodi contrastivi

Ci sono altri metodi contrastivi come la divergenza contrastiva (*contrastive divergence*), la comparazione dei rapporti (*ratio matching*), la stima contrastiva del rumore (*noise contrastive estimation*) e il minimo flusso di probabilità (*minumum probability flow*). Daremo giusto un'infarinata riguardo l'idea base della divergenza contrastiva.

<!-- ## Other Contrastive Methods
There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence. -->

### Divergenza contrastiva (*contrastive divergence, CD*)

La divergenza contrastiva è un altro modello che apprende le rappresentazioni tramite la perturbazione "intelligente" del campione di input. In uno spazio continuo, prima di tutto consideriamo un campione di addestramento $y$ e ne abbassiamo l'energia. Per questo campione, usiamo una sorta di processo basato sul gradiente per muoverci verso il basso sulla superficie dell'energia con rumore. Se lo spazio di input è discreto, possiamo invece perturbare il campione di addestramento in maniera casuale al fine di modificarne l'energia. Se l'energia risultante è più bassa, teniamo questa perturbazione; altrimenti, la scartiamo con un certo livello di probabilità. Facendo ciò risulterà, alla fine, nell'abbassamento dell'energia di $y$. Possiamo quindi aggiornare i parametri della nostra funzione di energia comparando $y$ e il campione contrastivo $\bar y$ tramite una qualche funzione di perdita.

<!-- ### Contrastive Divergence
Contrastive divergence is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function. -->

### Divergenza contrastiva persistente

Un affinamento della divergenza contrastiva è la divergenza contrastiva persistente. Il sistema utilizza una serie di "particelle" e ne memorizza la posizione. Queste particelle sono spostate verso il basso nella superficie dell'energia, in maniera analoga alla *CD* standard. Alla fine, troveranno dei luoghi a bassa energia nella nostra superficie dell'energia e ne causeranno un incremento dell'energia. Tuttavia, la tecnica non si adatta bene all'aumentare della dimensionalità.

<!-- ### Persistent Contrastive Divergence
One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases. -->
