---
lang-ref: ch.07-3
lang: it
title: Introduzione agli autoencoder
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 27 Apr 2020
translator: Marco Zullich
---

## [Applicazione degli autoencoder (AE)](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)

### Generazione d'immagini

Puoi riconoscere quale fra i volti della Fig. 1 è falso? In effetti, entrambi sono prodotti dal generatore *StyleGan2*. Nonostante i dettagli facciali siano molto realistici, lo sfondo sembra strano (a sinistra: sfocatura, a destra: oggetti deformati). Questo accade perché la rete neurale è addestrata su campioni di visi. Lo sfondo ha una più grande variabilità. Qui la dimensione della varietà ha circa 50 dimensioni, uguale ai gradi di libertà di un'immagine di un volto.

<!--
## Application of Autoencoders
### Image generation
Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: volti generati da StyleGan2
<!-- Faces generated from StyleGan2 -->
</center>

### Differenze nell'interpolazione nello spazio dei pixel e nello spazio latente

<!--
### Difference of Interpolation in Pixel Space and Latent Space
-->

<center><img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: un cane e un uccello
<!--A dog and a bird-->
</center>

Se effettuiamo un'interpolazione lineare fra un'immagine di un cane e quella di un unccello (Fig.2) nello spazio dei pixel, otteniamo una sovrapposizione sbiadita delle due immagini, come in Fig. 3. Dall'angolo in alto a sinistra all'angolo in basso a destra, il peso dell'immagine del cane diminuisce, mentre aumenta il peso dell'immagine dell'uccello.

<!--
If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases.
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: risultati dopo l'interpolazione <!--Results after interpolation-->
</center>

Se si interpola fra due rappresentazioni nello spazio latente e si dà in input il risultato al *decoder*, si otterrà una trasformazione da cane a uccello come in Fig. 4.

<!-- If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: risultato dopo l'elaborazione del decoder <!--Results after feeding into decoder -->
</center>

Ovviamente, lo spazio latente coglie meglio la struttura di un'immagine.

<!-- Obviously, latent space is better at capturing the structure of an image. -->

### Esempi di trasformazione

<!-- ### Transformation Examples -->

<center><img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: zoom
</center>
<center><img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: traslazione <!--shift -->
</center>
<center><img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: luminosità <!--Brightness-->
</center>
<center><img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: rotazione (si noti che la rotazione potrebbe essere in 3D) <!--Rotation(Note that the rotation could be 3D)-->
</center>

### Super-risoluzione di immagini

<!-- ### Image Super-resolution -->

Questo modello punta a miglioirare la risoluzione delle immagini e ricostruire i volti originali. Da sinistra a destra, in Fig. 9, la prima colonna è l'immagine di input (risoluzione 16x16), la seconda è il risultato di una interpolazione bicubica standard, la terza è l'output generato da una rete neurale; a destra vi è l'immagine originaria (https://github.com/david-gpu/srez).

<!-- This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez) -->
<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: ricostruzione dei volti originari <!--reconstructing original faces-->
</center>

Dalle immagini di output è chiaro che vi sono delle distorsioni nei dati di addestramento, il che rende inaccurata la ricostruzione dei volti. Per esempio, l'uomo asiatico in alto a sinistra viene ricostruito, in output, con dei lineamenti europei a causa dello sbilanciamento nelle immagini di addestramento. Il viso ricostruito della donna in basso a sinistra sembra strano a causa della scarsità d'immagini, nei dati di addestramento, da quell'angolatura particolare.

<!-- From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data. -->

### Reintegrazione fotografica

<!-- ### Image Inpainting -->

<center><img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: sovraimposizione di una pezza grigia sui volti <!--Putting grey patch on faces-->
</center>

La sovraimposizione di una pezza grigia sui volti, come in Fig. 10, allontana l'immagine dalla varietà di addestramento. La ricostruzione del volto in Fig. 11 è effettuata cercando l'esempio di immagine più vicino giacente nella varietà di addestramento tramite minimizzazione di una funzione di energia.

<!-- Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization. -->
<center><img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: ricostruzione dell'immagine di cui alla <!--Reconstructed image of--><b>Fig. 10</b>
</center>

### Da didascalia a immagine

<!-- ### Caption to Image -->
<center><img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: esempio di creazione di un'immagine a partire dalla didascalia <!-- Caption to Image example -->
</center>

La traslazione da descrizione testuale a immagine della Fig. 12 è ottenuta estraendo rappresentazioni di caratteristiche testuali associate a informazioni visive salienti e decodificando queste ultime in immagini.

<!-- The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images. -->


## [Cosa sono gli *autoencoder*](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

<!-- ## What are autoencoders? -->

Gli *autoencoder* sono reti neurali artificiali addestrate in modo non supervisionato, le quali reti puntano prima di tutto a imparare rappresentazioni codificate dei nostri dati, dopodiché a generare nuovamente i dati di input (più accuratamente possibile) dalle rappresentazioni codificate. Quindi, l'output di un *autoencoder* è una sua previsione dell'input.

<!-- Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input. -->


<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: architettura di un semplice autoencoder <!--Architecture of a basic autoencoder--><br>
</center>

La Fig. 13 mostra l'architettura di un semplice *autoencoder*. Come prima, iniziamo dal basso con l'input $\boldsymbol{x}$ il quale è soggetto a un codificatore (trasformazione affine definita da $\boldsymbol{W_h}$, seguita da una "spremitura"). Questo risulta in uno strato nascosto intermedio $\boldsymbol{h}$. Questo a sua volta è soggetto a un decodificatore (un'altra trasformazione affine definita da $\boldsymbol{W_x}$ seguita da un'altra "spremitura"). Ciò produce l'output $\boldsymbol{\hat{x}}$, il quale è la previsione/ricostruzione dell'input da parte del modello. Come da nostra convenzione, poniamo che questa sia una rete neurale a 3 strati.

<!-- Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder(affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network. -->

Possiamo rappresentare la rete di cui sopra in maniera matematica utilizzando le seguenti equazioni
<!--
We can represent the above network mathematically by using the following equations: -->

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

Specifichiamo le seguenti dimensionalità:

<!-- We also specify the following dimensionalities: -->

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Nota:</b> affinché possiamo rappresentare le componenti principali (*principal component analysis*, PCA), dobbiamo porre di avere *parametri collegati*, ovvero $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$.

<!-- <b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$ -->

## Perche utilizziamo gli *autoencoder*?

<!-- ## Why are we using autoencoders? -->

A questo punto, ci si potrebbe chiedere quale sia la motivazione di prevedere l'input e quali siano le applicazioni degli *autoencoder*.

<!-- At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders.-->

L'applicazione principale di un *autoencoder* è per il rilevamento di anomalie o la riduzione di rumore (*denoising*) delle immagini. Sappiamo che il compito di un *autoencoder* è quello di essere capace di ricostruire i dati giacenti in una varietà, ovvero, data questa varietà, vogliamo che il nostro *autoencoder* sia capace di ricostruire solo l'input esistente in tale varietà. Quindi limitiamo il modello a ricostruire cose osservate durante l'addestramento, cosicché ogni variazione presente nel nuovo input verrà rimossa in quanto il modello non sarà sensibile a questo tipo di perturbazioni.

<!-- The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold i.e. given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations.-->

Un'altra applicazione di un *autoencoder* è la compressione d'immagini. Se abbiamo una dimensionalità intermedia $d$ più piccola di quella dell'input $n$, allora il codificatore può essere usato come compressore e le rappresentazioni nascoste (codificate) rappresenterebbero tutta (o quasi tutta) l'informazione dell'input specifico, ma occupando meno spazio.

<!-- Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space. -->

## Errore di ricostruzione

<!-- ## Reconstruction loss -->

Vediamo ora le funzioni di perdita basate sull'errore di ricostruzione che utilizziamo normalmente. La perdita totale per il dataset è data dalla media della perdita per singola istanza, ovvero

<!-- Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e. -->

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

Se l'input è categorico, possiamo usare la perdita basata sull'entropia incrociata (*cross-entropy*) per calcolare la perdita per istanza, che è data dalla formula

<!-- When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by -->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

E se l'input assume valori reali, potremmo voler usare la perdita basata sullo scarto quadratico medio, data dalla formula

<!-- And when the input is real-valued, we may want to use the Mean Squared Error Loss given by -->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$

## Strati intermedi sovra-/sottocompleti

<!-- ## Under-/over-complete hidden layer -->

Quando la dimensionalità dello strato nascosto $d$ è minore della dimensionalità dell'input $n$, possiamo dire che tale strato nascosto è sottocompleto. Similarmente, quando $d>n$, possiamo chiamarlo uno strato nascosto sovracompleto. La Fig. 14 mostra uno strato nascosto sottocompleto a sinistra e uno sovracompleto a destra.

<!-- When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: strati nascosti -- sottocompleto vs. sovracompleto<br>
<!-- An under-complete vs an over-complete hidden layer<br> -->
</center>

Come detto sopra, uno strato nascosto sottocompleto può essere usato per fini di compressione, giacché stiamo codificando l'informazione dell'input in meno dimensioni. D'altro canto, in uno strato sovracompleto stiamo codificando in più dimensioni dell'input. Ciò facilita l'ottimizzazione.

<!-- As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier. -->

Siccome stiamo cercando di ricostruire l'input, il modello è propenso a copiare tutte le caratteristiche dell'input nello strato nascosto, cercando di farlo passare all'output, essenzialmente comportandosi come la funzione identità. Ciò va necessariamente evitato in quanto implicherebbe che il nostro modello fallisce nell'apprendimento. Dunque, dobbiamo applicare qualche vincolo ulteriore applicando un collo di bottiglia dell'informazione. Lo facciamo per limitare le possibili configurazioni che lo strato nascosto può assumere a solo quelle configurazioni viste durante l'addestramento. Ciò permette una ricostruzione selettiva (limitata ad un sottoinsieme dello spazio d'input) e rende il modello insensibile a qualsiasi cosa non presente nella varietà.

<!-- Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction(limited to a subset of the input space) and makes the model insensitive to everything not in the manifold. -->

C'è da notare che uno strato sottocompleto non può comportarsi come la funzione identità samplicemente perché esso non ha abbastanza dimensioni per copiare l'input. Quindi, uno strato nascosto sottocompleto è meno incline a sovradattare se comparato con uno strato sovracompleto, ma potrebbe sempre farlo. Per esempio, dati un codificatore e un decodificatore potenti, il modello potrebbe semplicemente associare un numero a ogni dato e imparare la mappatura. Ci sono svariati metodi per evitare il sovradattamento come metodi di regolarizzazione, architettonici, ecc.

<!-- It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc. -->

## *Autoencoder* per la riduzione del rumore (*denoising autoencoder*)

<!-- ## Denoising autoencoder -->

La Fig. 15 mostra la varietà dell'*autoencoder* per la riduzione del rumore e l'intuizione sul suo funzionamento.

<!-- Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: autoencoder per la riduzione del rumore <br>
<!-- Denoising autoencoder<br> -->
</center>

In questo modello, assumiamo di voler iniettare la stessa distribuzione *rumorosa* che osserviamo nella realtà, così che possiamo imparare come poterla recuperare robustamente.
Comparando l'input e l'output, possiamo vedere che i dati già presenti nella varietà non si sono mossi, mentre quelli che ne erano lontani si sono mossi di molto.

<!-- In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it. -->
<!-- By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot. -->

La Fig. 16 ci dà la relazione fra dati d'input e di output.

<!-- Fig.16 gives the relationship between the input data and output data. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: input e output dell'autoencoder per la riduzione del rumore <br>
<!--  Input and output of denoising autoencoder -->
</center>

Possiamo anche utilizzare colori differenti per rappresentare la distanza della quale ogni punto si è mosso; la Fig. 17 ne mostra il diagramma.

<!-- We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: misurare la distanza percorsa da ogni dato d'input<br>
<!-- Measuring the traveling distance of the input data<br> -->
</center>

Più chiaro è il colore, più grande è la distanza percorsa dal punto. Dal diagramma, si può notare che i punti agli angoli hanno percorso una distanza vicina a 1 unità, mentre i punti all'interno dei 2 rami non si sono mossi per nulla, in quanto sono attratti dai rami in alto e in basso durante il processo di addestramento.

<!-- The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process. -->

## *Autoencoder* contrattivi

<!-- ## Contractive autoencoder -->

La Fig. 18 mostra la funzione di perdita e la varietà dell'*autoencoder* contrattivo

<!-- Fig.18 shows the loss function of the contractive autoencoder and the manifold. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: autoencoder contrattivo <br>
<!-- Contractive autoencoder <br> -->
</center>

La funzione di perdita contiene il termine di ricostruzione più la norma al quadrato del gradiente della rapppresentazione nascosta sull'input. Quindi, la perdita complessiva minimizza la variazione dello strato nascosto data una variazione dell'input. Il beneficio è quello di rendere il modello sensibile alle direzioni di ricostruzione e insensibile a tutte le altre direzioni.

<!-- The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions. -->

La Fig. 19 mostra come questi *autoencoder* funzionano in generale.

<!-- Fig.19 shows how these autoencoders work in general. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: autoencoder basilare <br>
<!-- Basic autoencoder -->
</center>

La varietà di addestramento è un oggetto unidimensionale che si muove in tre dimensioni. Dato $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, l'obiettivo dell'*autoencoder* è di distendere lungo una direzione la linea "arricciata", dove $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. Il risultato di ciò è che un punto dell'input sarà trasformato in un punto dello spazio latente. Ora abbiamo la corrispondenza tra punti dell'input e punti nello spazio latente, ma non abbiamo la corrispondenza fra regioni dello spazio d'input e regioni dello spazio latente. Successivamente, utilizzeremo il decodificatore per trasformare un punto dello strato latente per generare uno strato di output che abbia significato.

<!-- The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, The goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$ As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondent between points in the input space and the points on the latent space but do not have the correspondent between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer. -->

## [Implementazione degli *autoencoder* - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

<!-- ## Implement autoencoder - *Notebook* -->


<!-- The Jupyter Notebook can be found --> Il *Jupyter Notebook* può essere reperito [qui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).

In questo *notebook*, implementeremo un *autoencoder* standard ed un *autoencoder* per la riduzione del rumore e ne compareremo gli output.

<!-- In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs. -->


### Definizione dell'architettura dell'*autoencoder* e la perdita di ricostruzione

Abbiamo immagini di dimensione $28 \times 28$ e usiamo uno strato nascosto di dimensione $30$. La *routine* di trasformazione tratta in questo modo le dimensioni: $784\to30\to784$. Applicando la funzione tangente iperbolica alle *routine* di codificazione e decodificazione, siamo in grado di limitare il *range* dell'output nell'intervallo $(-1,1)$. Lo scarto quadratico medio (*mean squared error*, MSE) verrà usato come funzione di perdita del modello.


<!-- *Define autoencoder model architecture and reconstruction loss* -->
<!-- Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model. -->
```
python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```

### Addestramento di un *autoencoder* standard

<!-- **Train standard autoencoder** -->

Per addestrare un *autoencoder* standard usando PyTorch, bisogna inserire questi 5 metodi nel ciclo di addestramento:

#### Passaggio in avanti:

1) Passaggio dell'immagine d'input attraverso il modello chiamando `output = model(img)`. <br>
2) Calcolo della perdita tramite `criterion(output, img.data)`.


#### Passaggio all'indietro:

3) Azzerare il gradiente per assicurarci di non accumularne il valore: `optimizer.zero_grad()`. <br>
4) Retropropagazione: `loss.backward()`<br>
5) Passo all'indietro: `optimizer.step()`

<!-- To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop: -->
<!-- #### Going forward:
1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`.
#### Going backward:
3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()` -->

La Fig. 20 mostra l'output di un *autoencoder* standard.

<!-- Fig.20 shows the output of the standard autoencoder. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: output di un autoencoder standard <br>
<!-- Output of standard autoencoder -->
</center>

<br />

### Addestrare un _autoencoder_ per la riduzione del rumore

<!-- **Train denoising autoencoder** -->

Per l'_autoencoder_ per la riduzione del rumore, bisogna aggiungere i seguenti passaggi:
1) Chiamare `nn.Dropout()` per "spegnere" in maniera casuale alcuni neuroni. <br>
2) Creare la maschera per il rumore: `do(torch.ones(img.shape))`. <br>
3) Creare immagini perturbate ("cattive") moltiplicando le immagini reali ("buone") con la maschera binaria: `img_bad = (img * noise).to(device)`

<!-- For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binoary masks: `img_bad = (img * noise).to(device)`. -->

La Fig. 21 mostra l'output dell'_autoencoder_ per la riduzione del rumore.

<!-- Fig.21 shows the output of the denoising autoencoder. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig.21</b>: output dell'_autoencoder_ per la riduzione del rumore<br>
<!-- Output of denoising autoencoder  -->
</center>


### Comparazione dei filtri

È importante notare che, nonostante il fatto che le dimensioni dello strato di input siano $28 \times 28 = 784$, uno strato nascosto con dimensione pari a $500$ sia comunque ancora uno strato sovracompleto a causa del numero di pixel neri nell'immagine.
Di sotto vi sono esempi di filtri utilizzati in un *autoencoder* standard sottocompleto addestrato.
Chiaramente, i pixel nella regione dove esistono i numeri indicano il riconoscimento di una qualche sorta di *pattern*, mentre i pixel al di fuori di questa regione sono pressoché casuali. Ciò indica che l'*autoencoder* standard non s'interessa dei pixel fuori dalla regione dove si trova il numero.

<!-- It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image. -->
<!-- Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 22:</b> filtri di un AE standard.
<!-- Standard AE kernels. -->
</center>

D'altro canto, quando lo stesso dato viene dato in pasto ad un *autoencoder* per la riduzione del rumore con una maschera di *dropout* applicata ad ogni immagine prima di applicarvi il modello, si verifica qualcosa di diverso. Ogni filtro che impara un *pattern*, impara anche ad assegnare un valore costante ai pixel esterni alla regione dove si trova il numero.

<!-- On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 23:</b> filtri di un AE per la riduzione del rumore
<!-- Denoising AE kernels -->
</center>

Se comparato allo stato dell'arte, il nostro *autoencoder* si comporta persino meglio! Si può notare ciò dai risultati esposti sotto.

<!-- Compared to the state of the art, our autoencoder actually does better!! You can see the results below. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 24:</b> dati di input (cifre da MNIST).
<!-- Input data (MNIST digits). -->
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 25:</b> ricostruzioni dell'autoencoder per la riduzione del rumore
<!-- Denoising AE reconstructions. -->
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 26:</b> output dell'inpainting di Telea.
<!-- Telea inpainting output. -->
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 27:</b> output dell'inpainting di Navier-Stokes.
<!-- Navier-Stokes inpainting output. -->
</center>
