---
lang-ref: ch.07-2
lang: it
lecturer: Yann LeCun
title: SSL, EBM con dettagli ed esempi
authors: Ravi Choudhary，B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 9 Mar 2020
translation-date: 22 Apr 2020
translator: Marco Zullich
---

## [Apprendimento auto-supervisionato](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

L'apprendimento auto-supervisionato (*self-supervised learning*, SSL) abbraccia sia l'apprendimento supervisionato che quello non supervisionato. Il pretesto dell'SSL è quello di imparare una buona rappresentazione dell'input che può conseguentemente essere utilizzata per compiti supervisionati. Nell'SSL, il modello è addestrato a prevedere una parte dei dati condizionatamente al fatto di conoscere un'altra parte degli stessi. Per esempio, BERT è stato addestrato usando tecniche di SSL e l'*autoencoder* per *denoising*, in particolare, ha prodotto risultati allo stato dell'arte per quanto riguarda il processamento del linguaggio naturale (NLP).

<!-- ## Self Supervised Learning

Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning.  The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-encoder has particularly shown state-of-the-art results in Natural Language Processing.

-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: apprendimento auto-supervisionato  (*Self Supervised Learning*)
</center>

I compiti di apprendimento auto-supervisionato possono essere definiti come:
* prevedere il futuro a partire dal passato;
* prevedere ciò che è occluso a partire da ciò che è visibile.
<!-- Nota per il revisore: ho ridotto il numero di elementi della lista in quanto la 2a e la 3a frase hanno, in italiano, una traduzione semanticamente molto simile e quindi non valeva la pena lasciarle entrambe. -->

<!--
Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.
-->

Per esempio, se un sistema è addestrato a prevedere il prossimo *frame* quanto la telecamera si sta muovendo, il sistema imparerà in maniera implicita la profondità e la parallasse. Questo forzerà il sistema ad imparare che gli oggetti occlusi dalla sua visione non spariscono, ma continuano ad esistere; inoltre, imparerà la distinzione fra oggetti animati, inanimati e lo sfondo. Può anche finire per imparare concetti intuitivi di fisica come la gravità.

<!--
For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity.
-->

I sistemi di NLP allo stato dell'arte come BERT pre-addestrano una gigantesca rete neurale sulla base di compiti di SSL. Si rimuovono delle parole da una frase e si richiede al sistema di predire le parole mancanti. Ciò è risultato dare risultati di ampio successo. Idee simili erano anche state provate nel mondo della visione artificiale. Come mostrato nell'immagine sotto, si possono prendere delle immagini e rimuovere una porzione di figura, addestrando il modello a prevedere la porzione mancante.

<!--
State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: risultati analoghi nella visione artificiale <!--Corresponding results in computer vision-->
</center>

Nonostante questi modelli possano completare gli spazi vuoti mancanti, essi non hanno ottenuto lo stesso successo dei sistemi di NLP. Se si dovesse considerare una rappresentazione interna generata da questi modelli come input di un sistema di visione artificiale, sarebbe impossibile battere un modello pre-addestrato in maniera supervisionata su ImageNet. La differenza qui è che l'NLP lavora in un dominio discreto, mentre le immagini sono continue. Il divario per quanto concerne il successo è dovuto al fatto che in un dominio discreto sappiamo come rappresentare l'incertezza: possiamo utilizzare un *softmax* (*esponenziale normalizzata*) sui possibili output, mentre nel continuo non siamo in grado di farlo.


<!--
Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not.

-->

Un sistema intelligente (agente d'intelligenza artificiale) dev'essere in grado di predire i risultati delle sue stesse azioni prese sui suoi dintorni e su se stesso, al fine di prendere decisioni intelligenti. Siccome il mondo non è completamente deterministico e una macchina o un cervello umano non hanno abbastanza potenza di calcolo per considerare tutte le possibilità, dobbiamo insegnare ai sistemi AI (*artificial intelligence*) di effettuare le previsioni in presenza di incertezza in spazi di grandi dimensioni. I modelli basati sull'energia (*energy based models*, EBM) possono essere estremamente utili a riguardo.

<!--

An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models can be extremely useful for this.
-->

Una rete neurale addestrata usando i minimi quadrati per predire il prossimo frame di un video risulterà in immagini sfocate perché il modello non può predire esattamente il futuro, così impara, dai dati di addestramento, a fare la media di tutte le possibilità per il prossimo frame al fine di ridurre la perdita.

<!--
A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss.
-->

### I modelli a variabile latente basati sull'energia come soluzione per predire il prossimo frame

A differenza della regressione lineare, i modelli a variabile latente basati sull'energia considerano ciò che conosciamo del mondo, più una variabile latente che ci dà informazioni riguardo a cosa è accaduto nella realtà. Una combinazione di queste due informazioni può essere usata per effettuare una previsione *vicina* a quanto accadrà.

<!--
### Latent variable energy-based models as a solution to make predictions for next frame:

Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs.
-->

Si può pensare a questi modelli come dei sistemi che valutano la compatibilità fra l'input $x$ e l'output effettivo $y$ in base alla previsione, effettuata utilizzando la variabile latente, minimizzante l'energia del sistema. Si osserva l'input $x$ e si produce una possibile previsione $\bar{y}$ per diverse combinazioni dell'input $x$ e delle variabili latenti $z$ e si sceglie quella che minimizza l'energia, ovvero l'errore di previsione, del sistema.

<!--
These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$  for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system.
-->

Dipendentemente dalla variabile latente che scegliamo, possiamo ottenere tutte le possibili previsioni. La variabile latente può essere pensata come un'informazione importante di $y$ che non è presente nell'input $x$.

<!--
Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$.
-->

Le funzioni di energia a valori scalari possono essere di due tipi:
1. $F(x, y)$ condizionate - misurano la compatibilità fra $x$ e $y$
2. $F(y)$ incondizionate - misurano la compatibilità fra le componenti di $y$

<!--
Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$
-->

## [Addestrare un modello basato sull'energia](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)

Ci sono due classi di modelli di apprendimento per addestrare i modelli basati sull'energia ai fini di parametrizzare $F(x,y)$:
1. **Metodi contrastivi:** far decrescere $F(x[i], y[i])$, far aumentare altri punti $F(x[i], y')$
2. **Metodi architettonici:** costruire $F(x,y)$ così che il volume delle regioni a bassa energia è limitato o minimizzato tramite tecniche di regolarizzazione

<!--
## Training an Energy-Based Model:


There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization
-->

Ci sono sette strategie per dar forma alle funzioni di energia. I metodi contrastivi differiscono nel modo in cui selezionano i punti per causare l'aumento, mentre i metodi architettonici differiscono nelle tecniche tramite le quali limitano la capacità d'informazione del codice.

<!--
There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the
the way they limit the information capacity of the code.
-->

Un esempio di metodo contrastivo è l'apprendimento basato su massima verosimiglianza. L'energia può essere interpretata come una densità di probabilità logaritmica, negativa, non normalizzata. La distribuzione di Gibbs ci fornisce la verosimiglianza di $y$ dato $x$. Può essere formulata come di seguito:

<!--
An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalized negative log density. Gibbs distribution gives us the likelihood of y given x. It can be formulated as follows:
-->

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

La massima verosimiglianza cerca di rendere il numeratore grande e il denominatore piccolo ai fini della massimizzazione. Ciò equivale a minimizzare $-\log(P(Y \mid W))$, ovvero

<!--
Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below
-->

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$

Gradient of the negative log likelihoood loss for one sample Y is as follows:

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

Nel gradiente qui sopra, il primo termine del gradiente al punto $Y$ e il secondo termine del gradiente ci forniscono il valore atteso del gradiente dell'energia su tutti i $Y$.

Quindi, quando operiamo una discesa del gradiente, il primo termine prova a ridurre l'energia fornita dal punto $Y$ e il secondo termine prova ad aumentare l'energia data a tutti gli altri $Y$.

Il gradiente della funzione di energia è usualmente molto complesso e quindi la computazione, la stima o l'approssimazione del suo integrale è un caso molto interessante in quanto è intrattabile nella maggior parte dei casi.

<!--
In the above gradient, the first term of the gradient at the datapoint $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy ove rall $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the datapoint $Y$ and the second term tries to increase the energy given to all other $Y$s.

The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases.
-->

## [Modelli a variabile latente basati sull'energia](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)

Il vantaggio principale dei modelli a variabile latente è che permettono di effettuare previsioni plurime attraverso la variabile latente. Al variare di $z$ in un insieme definito, $y$ muta all'interno della varietà delle possibili previsioni. Alcuni esempi sono:
1. *K-means*
2. Modellazione sparsa
3. Ottimizazione generativa a variabile latente [Generative Latent Optimization (GLO)](https://arxiv.org/abs/1707.05776)

<!--
## Latent Variable Energy-Based Model

The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modeling
3. [GLO](https://arxiv.org/abs/1707.05776)
-->

Questi modelli possono essere di due tipi:

1. Modelli condizionati in cui $y$ dipende da $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$

2. Modelli incondizionati con funzioni di energia a valori scalari, in cui $F(y)$ misura la compatibilità fra le componenti di $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$


<!-- These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, F(y) that measures the compatibility between the components of y
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$ -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: EBM a variabile latente <!--Latent Variable EBM-->
</center>

## Esempio di EBM a variabile latente: K-means

L'algoritmo *K-means* è un metodo di *clustering* partizionale il quale può anche essere considerato un modello basato sull'energia nel quale stiamo cercando di modellare una distribuzione su $y$. La funzione di energia è $E(y,z) = \Vert y-Wz \Vert^2$, dove $z$ è un vettore *one-hot* ($0$ ovunque tranne per un elemento valorizzato a $1$).

<!--
## Latent Variable EBM example: K-means

K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: esempio di K-means <!--K-means example-->
</center>

Dati i valori di $y$ e $k$, possiamo fare inferenza ottenendo quale delle $k$ possibili colonne di $W$ minimizzi l'errore di ricostruzione o la funzione di energia. Per addestrare l'algoritmo, possiamo adottare un approccio dove dobbiamo trovare uno $z$ in modo tale da scegliere le colonne di $W$ più vicine a $y$ e cercare di avvicinarcisi sempre di più prendendo un passo del gradiente e ripetendo il procedimento. Tuttavia, il *coordinate descent* funziona meglio e più velocemente.

<!--
Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster.
-->

Nel grafico sotto possiamo vedere i punti lungo la spirale rosa. Le chiazze nere attorno alla linea corrispondono ad avvallamenti quadratici attorno a ogni prototipo di $W$.

<!-- In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of W. -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: grafico della spirale <!-- Spiral Plot -->
</center>

Una volta che abbiamo imparato la funzione di energia, possiamo chiederci domande come:
1. Dato un punto $y_1$, come possiamo prevedere $y_2$?
2. Dato $y$, possiamo trovarne il punto più vicino nella varietà dei dati?

*K-means* appartiene ai metodi architettonici (opposti ai metodi contrastivi). Di conseguenza, piuttosto che aumentare l'energia, riduciamo l'energia per alcune regioni. Uno svantaggio di ciò è che una volta che il valore di $k$ è stato scelto, ci possono essere solo $k$ punti che hanno energia $0$ e tutti gli altri punti avranno un livello di energia crescente in maniera quadratica come ci allontaniamo da questi punti.

<!--
Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold?

K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them.
-->

## Metodi contrastivi

Secondo il Dr. Yann LeCun, tutti useranno metodi architettonici ad un certo punto nel futuro, ma, in questo momenti, sono i metodi contrastivi a funzionare bene sulle immagini. Si consideri la figura di sotto che ci mostra alcuni punti e curve di livello della superficie dell'energia. Idealmente, desidereremmo che la superficie abbia l'energia più bassa nella varietà dei dati. Di conseguenza, vorremmo abbassare l'energia (ovvero il valore di $F(x,y)$) attorno agli esempi di addestramento, ma ciò potrebbe non bastare. Quindi aumentiamo l'energia per le $y$ nella regione laddove esse avrebbero dovuto avere alta energia, ma ce l'hanno bassa.

<!--
## Contrastive Methods

According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of F(x,y))around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: metodi contrastivi <!--Contrastive methods -->
</center>

Ci sono svariati modi di identificare le candidate $y$ alle quali andremo ad aumentare l'energia. Alcuni esempi sono:
1. *denoising autoencoder* (*autoencoder per la riduzione del rumore*)
2. divergenza contrastiva
3. metodo Monte Carlo
4. catene di Markov Monte Carlo
5. Monte Carlo ibrido <!-- wikipedia (https://it.wikipedia.org/wiki/Catena_di_Markov_Monte_Carlo) riporta il riferimento come monte carlo ibrido, non hamiltoniano -->

Qui tratteremo brevemente gli *autoencoder* per la riduzione del rumore e la divergenza contrastiva.

<!--
There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo

We will briefly discuss Denoising Autoencoders and Contrastive Divergence.
-->

### *Autoencoder* per la riduzione del rumore (*denoising autoencoder*, DAE)

Un modo per rintracciare le $y$ alle quali aumentare l'energia è tramite la perturbazione casuale dell'esempio di addestramento, come esemplificato dalle frecce verdi nel grafico qui sotto:

<!--
### Denoising Autoencoder (DAE)

One way of finding $y$'s to increase energy for it by randomly perturbing the training example as shown by the green arrows in the plot below.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: mappa topografica <!--Topographic map-->
</center>

Una volta perturbato il dato, possiamo incrementarne l'energia in questo punto. Se ripetiamo ciò per un numero sufficiente di volte per tutti i dati, i campioni dell'energia si *raggomitoleranno* attorno agli esempi di addestramento. Il seguente grafico illustra come viene operato l'addestramento:

<!--
Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: l'addestramento <!--Training-->
</center>

Procedura per l'addestramento:
1. Considerare un punto $y$ e perturbarlo
2. Addestrare un *encoder* e un *decoder* per ricostruire il dato originale a partire dal punto perturbato

Se il DAE è addestrato correttamente, l'energia crescerà in maniera quadratica come ci spostiamo dalla varietà dei dati.

Il grafico seguente illustra come si utilizzano i DAE.

<!--
Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point

If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold.

The following plot illustrates how we use the DAE.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: utilizzo di un DAE <!--How DAE is used-->
</center>


### BERT

BERT è addestrato in maniera analoga, con la differenza che lo spazio è discreto in quanto stiamo lavorando sul linguaggio. La tecnica di perturbazione consiste nel mascherare alcune delle parole e la fase di ricostruzione consiste prevedere le parole mancanti, ragione per cui questo metodo è chiamato *autoencoder mascherato* (*masked autoencoder*).

<!--
BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstuction step consists of trying to predict these. Hence, this is also called a masked autoencoder.-->

### Divergenza contrastiva

La divergenza contrastiva ci propone un metodo più intelligente per trovare i punti $y$ per i quali vogliamo aumentare l'energia. Possiamo dare una perturbazione casuale a uno dei nostri punti di addestramento e quindi muoverci giù lungo il paesaggio della funzione di energia usando la discesa del gradiente. Alla fine della traiettoria, aumentiamo l'energia per il punto su cui terminiamo. Ciò è illustrato dalla linea verde nel grafico qui sotto.

<!--
### Contrastive Divergence

Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: divergenza contrastiva <!--Contrastive Divergence-->
</center>
