---
lang: it
lang-ref: ch.07-1
lecturer: Yann LeCun
title: Modelli ad Energia (EBM, Energy-Based Models)
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translation-date: 1 Apr 2020
translator: Michela Paganini
---


## [Panoramica](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

Introduciamo un nuovo quadro per la definizione di modelli, che fornisce un sistema unificato per la creazione di modelli supervisionati, non-supervisionati e auto-supervisionati. I modelli ad energia (EBM, Energy-Based Models) osservano un insieme di variabili di ingresso $x$ e un insieme di variabili di uscita $y$. Per spiegarne l'utilità, pensiamo a due casi problematici principali in cui la formulazione classica di classificatori neurali feed-forward non risulta adeguata:

1. il caso in cui la procedura necessaria per l'inferenza richiede un calcolo più complesso di quello realizzabile attraverso una serie finita di somme ponderate.
2. il caso in cui il problema ammette più di un output per un singolo input. Per esempio, si consideri il problema di predirre fotogrammi successivi in un video. Generalmente, una rete neurale per la classificazione viene allenata in modo tale che emetta un punteggio per ogni classe presente nel problema. Tuttavia, ciò non è possibile in un campo continuo ad alta dimensionalità come quello delle immagini: non possiamo calcolare una funzione softmax che indichi l'immagine corretta tra tutte quelle possibili, come invece facciamo con le classi in un problema di classificazione ordinario. Anche se l'output fosse discreto, potrebbe comunque avere una cardinalità molto elevata. Per esempio, il testo, come formato, ha proprietà compositive, il che porta ad avere un enorme numero di possibili combinazioni valide da considerare. Gli EMB forniscono un struttura migliore per trattare questi tipi di dati.

<!-- ## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s) -->

<!-- We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:

1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities. -->

## L'Approccio EMB
<!-- ## EBM approach -->

Invece di provare a categorizzare le $x$ secondo i valori di $y$, ciò che vogliamo fare è calcolare se una coppia ($x$, $y$) sia opportuna oppure no, data la distribuzione dei dati. In altre parole, vorremmo trovare una $y$ che sia compatibile con l'input $x$. Il problema può anche essere posto come la ricerca di una $y$ per cui il valore di una funzione $F(x,y)$ sia basso. Come esempi pratici:

- $y$ è una fedele versione ad alta risoluzione di $x$?
- Il testo A è una corretta traduzione del testo B?

<!-- Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`? -->

<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
 -->

### Definizione
<!-- ### Definition -->

Definiamo una funzione scalare di energia $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ dove $F(x,y)$ descrive il livello di affinità per la coppia $(x,y)$. Valori elevati di $F$ indicano abbinamenti incompatibili, mentre valori bassi indicano una buona compatibilità tra $x$ e $y$. (**N.B.:** quest'energia è minimizzata durante l'inferenza, **non** durante l'apprendimento.) L'inferenza è eseguita secondo l'equazione seguente:

<!--
We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation: -->

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$



### Soluzione: inferenza basata sul gradiente
<!-- ### Solution: gradient-based inference -->

Richiediamo che la funzione di energia sia liscia e differenziabile, in modo tale da permettere l'inferenza attraverso metodi incentrati sull'uso del gradiente. Per effettuare l'inferenza, minimizziamo questa funzione usando la discesa del gradiente per trovare $y$ compatibili. Esistono anche molti metodi alternativi all'uso del gradiente per ottenere il minimo di una funzione.


**Parentesi**: I modelli grafici sono un caso speciale dei modelli ad energia. La loro funzione di energia è scomponibile in una somma di termini energetici. Ogni addendo prende in considerazione un sottoinsieme delle variabili del sistema. Se organizzati in configurazioni apposite, esistono algoritmi di inferenza efficienti per calcolare il minimo di una somma di termini rispetto alla variabile che siamo interessati ad inferire.

<!-- We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring. -->

<!-- There are a type of Energy Based Models that are quite popular. These are
 -->
## [EBM a Variabili Latenti](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)
<!-- ## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s) -->

In questi tipi di problema, la variabile di uscita $y$ dipende sia da $x$ sia da un'altra variabile $z$ (la variabile latente), di cui non conosciamo il valore in quanto non viene osservata. Queste variabili latenti possono fornire informazioni ausiliarie utili alla risoluzione del problema.

Un esempio di variabile latente può essere la posizione degli estremi di ogni parola in un blocco di testo in un contesto in cui, per esempio, si cerca di interpretare una frase scritta senza spazi, o una frase pronunciata, qualora la separazione tra parole fosse difficile da individuare. Per esempio, lingue come il francese hanno confini spesso quasi impercettibili tra le parole. Per cui, avere a disposizione questa variabile latente (la separazione tra la parole, in questo esempio) nel modello risulterebbe molto efficace per l'interpretazione dei dati in entrata. In quanto latenti, il valore di queste variabili non è però conosciuto, e bisogna ricorrere ad altri metodi per gestirle.

<!-- The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (e.g. French). Hence, having this latent variable in our model will be very useful to interpret such an input.
 -->


### Inferenza
<!-- ### Inference -->

Per eseguire l'inferenza con EBM a variabili latenti, si deve minimizzare la funzione di energia rispetto a $y$ e $z$ in maniera simultanea.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

Ciò è equivalente a una ridefinizione della funzione di energia a favore della forma:

$$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, con $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z)).$$

Quando $\beta \rightarrow \infty$, allora $\check{y} = \text{argmin}_{y}F(x,y)$.

<!-- To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$.


<!--  ## Latent-Variable EBM -->
Un altro vantaggio nell'includere variabili latenti è la possibilità, facendo variare le variabili latenti all'interno di un certo intervallo, di far a sua volta variare la previsione in uscita $y$ nella varietà di possibili previsioni (il nastro è mostrato nella figura sotto).

Questo permette alla macchina di produrre molteplici output, invece di uno solo.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Grafo computazionale di un modello ad energia.
</center>


<!-- Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center>
-->


### Esempi
<!-- ### Examples -->

Un esempio pertinente è la previsione di fotogrammi in un filmato. Esistono svariate applicazioni di questa tecnologia, tra cui la compressione di video, o l'uso di filmati raccolti da auto a guida autonoma per dedurre il comportamento di altre vetture. Invece di produrre una singola previsione, spesso uguale alla media di tutti i fotogrammi plausibili, l'EBM è in grado di produrre varie immagini individualmente realistiche condizionate dalle variabili $z$. Variando $z$ si può attraversare ed esplorare lo spazio delle immagini prodotte dal modello.

Un altro esempio è la traduzione di testo. La traduzione è da sempre un problema difficile per via dell'inesistenza di una singola traduzione corretta di un testo da una lingua a un'altra. Solitamente, esistono diversi modi di esprimere un concetto, ed è difficile trovare ragioni per preferirne uno a un altro. Sarebbe, dunque, vantaggioso poter parametrizzare tutte le possibili traduzioni che un sistema è in grado di produrre a partire da un testo dato in termini di variabili latenti $z$. Per esempio, ipotizziamo di voler tradurre un testo dal tedesco all'inglese: esiste più di una traduzioone corretta, e modificando delle variabili latenti saremmo in grado di modificare la traduzione prodotta dal modello esplorandone lo spazio.

<!-- One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced.
 -->

## [Modelli ad Energia vs. Modelli Probabilistici](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)
<!-- ## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s) -->

Le energie possono essere considerate come probabilità logaritmiche non normalizzate; si può quindi usare la distribuzione di Boltzmann per convertire l'energia in probabilità con l'apposita normalizzazione:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

dove $\beta$ è una costante positiva che può essere calibrata a seconda del modello. Valori elevati di $\beta$ tendono a creare un modello che produce una funzione a frequenze più alte dove la probabilità è fortemente concentrata in alcuni punti e vicina a zero altrove, mentre valori bassi di $\beta$ rendono la funzione più regolare. (In fisica, $\beta$ è il reciproco della temperatura: $\beta \rightarrow \infty$ significa che la temperatura tende a zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Se marginalizziamo $z$: $P(y \mid x) = \int_z P(y,z \mid x)$, otteniamo:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}

$$

Perciò, in presenza di una variabile latente $z$, per eliminarla in maniera corretta a livello probabilistico, si può ridefinire la funzione energetica $E$ a favore di $F_\beta$ (Energia Libera).


<!-- We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy) -->


### Energia Libera
<!-- ### Free Energy -->

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Calcolare questa quantità non è sempre semplice... Infatti, nella maggior parte dei casi, il problema diventa intrattabile. In presenza di una variabile latente rispetto a cui minimizzare il modello o marginalizzare (che è ciò che succede quando definiamo questa funzione di energia $F$), nel qual caso il problema di minimizzazione corrispone al limite per $\beta$ che va a infinito, allora il problema diventa risolvibile.

Nella definizioone di $F_\beta(x, y)$ qui sopra, $P(y \mid x)$ è semplicemente il risultato dell'applicazione della formula di Boltzmann e $z$ è stata marginalizzata in maniera implicita al suo interno. I fisici chiamano questa quantità l'"energia libera" (free energy, in inglese), ed è per questo che la identifichiamo con la lettera $F$. $E$ è l'energia, $F$ è l'energia libera.

***Domanda: quali sono i vantaggi dei modelli ad energia? Nei modelli probabilistici, è comunque possibile avere variabili latenti e marginalizzarle.***

<!-- $$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.

Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy.

***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.*** -->

La differenza è che nei modelli probabilistici non abbiamo modo di scegliere la funzione obiettivo da minimizzare e, per aderire al framework probabilistico, ogni oggetto che manipoliamo deve essere una distribuzione normalizzata (che può essere approssimata tramite metodi variazionali, ecc.). Qui, invece, in concreto, l'obiettivo è prendere decisioni. In un sistema di guida autonoma, per esempio, data una probabilità di 0.8 di girare a sinistra e una probabilità di 0.2 di girare a destra, le decisione sarà di girare a sinistra. Il valore esatto delle probabilità non ha importanza; ciò che importa è la scelta binaria, perchè costretti a prendere una decisione concreta. Le probabilità sono dunque irrilevanti in confronto all'attuazione della decisione. Se invece si vuole combinare l'output di due sistemi separati (per esempio, uno umano e uno artificiale) e questi sistemi non sono stati creati ed allenati assieme, si dovranno calibrare i loro risultati in modo da combinarli prima di prendere una decisione. Per calibrare i risultati, bisogna trasformarli in probabilità.
Se invece si crea un sistema decisionale end-to-end, dove tutte le parti sono al corrente della presenza delle altre parti e sono ottimizzate in unisono, allora qualsiasi funzione di punteggio è consentita, purchè assegni il punteggio più alto alla miglior decisione. I modelli ad energia lasciano, quindi, più scelta nella costruzione, nell'apprendimento, e nell'obiettivo del modello. Se invece insistiamo nella scelta di un modello probabilistico, allora bisogna utilizzare il metodo della massima verosimiglianza; in pratica, il modello deve essere allenato in modo tale che la probabilità dei dati osservati sia massima. Il problema è che è provato che funzioni solo quando il modello è "corretto", e un modello non è mai corretto. Per citare un grande statistico George Box, ***"Tutti i modelli sono sbagliati, ma alcuni sono utili".*** I modelli probabilistici, quindi, specialmente quelli in spazi ad alta dimensionalità o in spazi combinatori come il linguaggio di testo, sono tutti modelli approssimativi. A loro modo, sono tutti sbagliati, e se proviamo a normalizzarli, li rendiamo ancora più sbagliati. Quindi è meglio non normalizzarli ed utilizzare le energie.


<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualizzazione della funzione di energia che mostra la dipendenza tra $x$ e $y$ come funzione implicita
</center>

<!-- The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, may more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them. -->

Questa funzione di energia mostra la relazione tra $x$ e $y$. È simile ad un territorio montuoso, se vogliamo trovare un'analogia. La vallate corrispondono alla presenza dei dati, mentre le montagne si elevano tutto intorno. Per allenare un modello probabilistico, immaginiamo che i punti esistano su una varietà topologica sottile e infinita. La distribuzione di dati per i dati rappresentati dai pallini neri è dunque una semplice linea, senza spessore, nello specifico tre segmenti, in questo esempio. Allenando un modello probabilistico su questi dati, il modello di densità ideale dovrebbe essenzialmente corrispondere a questa varietà. Su questa varietà, la densità dovrebbe essere infinita, mentre anche solo a un'$\epsilon$ di distanza, la densità dovrebbe tendere a zero. Non solo la densità dovrebbe essere infinita in questo spazio, ma l'integrale nelle variabili di integrazione $x$ e $y$ dovrebbe essere uguale a 1. Questo, però, è difficile da ottenere, a livello di implementazione su un computer, ed è praticamente impossibile in generale. Per calcolare questa funzione con una rete neurale, per esempio, questa dovrebbe avere un numero infinito di parametri, calibrati in maniera tale che l'integrale del risultato fornito dal sistema sull'intero dominio sia 1; il che è impossibile, in pratica. Questa è la soluzione richiesta dal metodo della massima verosimiglianza, e nessun computer è in grado di modellarla. Tra l'altro, tale modello non sarebbe nemmeno tanto utile. Se anche avessimo il modello di densità perfetto per questo esempio partico, non potremmo comunque svolgere l'inferenza. Dato un valore di $x$, il valore corretto di $y$ sarebbe comunque impossibile da trovare attraverso un algoritmo, perchè tutti i valori di $y$, al di là di quelli in un insieme di misura nulla, hanno probabilità uguale a zero, e solo un numero discreto di valori è fattibile come soluzione. La funzione, in questo caso, corrisponderebbe a una somma di funzioni delta di Dirac. In questo esempio:

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Esempio di molteplici previsioni valide in un EBM
</center>

<!-- This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example: -->

Ci sono 3 valori di $y$ possibili in questo caso, ma questi sono punti di larghezza finita, quindi impossibili da trovare. Nessun algoritmo di inferenza sarebbe in grado di trovarli. L'unico modo per arrivare a una soluzione è utilizzare una funzione di confronto liscia e differenziabile, per poi procedere con la discesa del gradiente fino a trovare un valore accettabile di $y$ per ogni valore di $x$. Ma, in questo caso, il modello probabilistico non sarebbe un modello corretto per il tipo di distribuzione in questo esempio. Questo esempio dimostra, dunque, come l'insistenza su un modello probabilistico non sia una buona idea in queste circostanze.

<!-- There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]! -->

I bayesiani potrebbero controbattere che il modo di sopperire a questo problema sia di imporre una distribuzione di probabilità a priori che preferisca una funzione di densità liscia. Ma qualsiasi formulazione in termini bayesiani, tralasciando la normalizzazione, è equivalente ad un EBM. Modelli ad energia con regolarizzazione, che si manifesta come un ulteriore addendo nella funzione di energia, sono equivalenti ai modelli bayesiani in cui la verosimiglianza è una funzione esponenziale dell'energia: $\exp(\text{energia}) \times \exp(\text{regolarizzazione}) = \exp(\text{energia} + \text{regolarizzazione})$. Il logaritmo della parte destra corrisponde a un modello ad energia con l'aggiunta della regolarizzazione.

<!-- So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regularizer})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser. -->

C'è quindi una corrispondenza tra modelli probabilistici e metodi bayesiani, ma insistere nell'utilizzo del metodo della massima verosimiglianza può talvolta essere controproducente, specialmente in spazi ad alta dimensionalità o spazi combinatori dove il modello probabilistico è molto impreciso. Nel caso di ditribuzioni discrete, l'errore può essere accettabile, ma nel caso di distribuzioni continue, il modello potrebbe risultare del tutto incorretto.

<!-- So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong. -->
