---
lang-ref: ch.06-3
lang: it
title: Architettura delle RNNs e modelli LSTM
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
translation-date: 10 Aug 2020
translator: Alessio Salman
---

<!--
## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)
-->

## [Panoramica](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)


<!--
RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is just temporal inputs of X. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions.
-->
RNN è un tipo di architettura che possiamo utilizzare per gestire sequenze di dati. Cos'è una sequenza? Dalla lezione sulle CNN, abbiamo appreso che un segnale può essere 1D, 2D o 3D a seconda del dominio. Il dominio è definito dall'insieme di elementi di partenza che vogliamo tradurre all'insieme di elementi di arrivo, cioè da e verso cosa stiamo mappando. La gestione dei dati sequenziali ha a che fare essenzialmente con i dati 1D poiché il dominio consiste solo in input temporali di X. Tuttavia, puoi anche utilizzare RNN per gestire i dati 2D, dove hai due direzioni.


<!--
### Vanilla vs. Recurrent NN
-->

### NN semplici vs. NN ricorrenti

<!--
Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input.
-->
La Figura 1 mostra un diagramma di rete neurali semplici (vanilla) a tre strati. "Vanilla" è un termine americano che significa semplice. La bolla rosa è il vettore di input x, al centro è lo strato nascosto in verde e il livello blu finale è l'output. Utilizzando un esempio dell'elettronica digitale sulla destra, possiamo vederlo come una logica combinatoria in cui l'uscita corrente dipende solo dall'ingresso corrente.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 1:</b> Architettura semplice
</center>

<!--
In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.
-->
Contrariamente a una rete neurale semplice, nelle reti neurali ricorrenti l'uscita corrente dipende non solo dall'ingresso corrente ma anche dallo stato del sistema, mostrato in Figura 2. Quest'ultimo si può interpretare come una logica sequenziale nell'elettronica digitale, dove anche l'uscita dipende da un "flip-flop" (un'unità di memoria di base nell'elettronica digitale). Pertanto la differenza principale qui è che l'output di una rete neurale semplice dipende solo dall'input corrente, mentre quello di RNN dipende anche dallo stato del sistema.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 3:</b> Architettura RNN
</center>


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Basic NN Architecture
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 4:</b> Basic NN Architecture
</center>

<!--
Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.
-->
Il diagramma di Yann aggiunge queste forme tra i neuroni per rappresentare la mappatura tra un tensore e un altro (un vettore all'altro). Ad esempio, nella Figura 3, il vettore di input x eseguirà la mappatura attraverso elemento aggiuntivo alla rappresentazione nascosta h. Questo oggetto è in realtà una trasformazione affine, cioè una rotazione più una distorsione. Quindi attraverso un'altra trasformazione, passiamo dallo strato nascosto all'output finale. Allo stesso modo, nel diagramma RNN, puoi avere gli stessi elementi aggiuntivi tra i neuroni.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Yann's RNN Architecture
</center>
-->

<!--
### Four types of RNN Architectures and Examples
-->

### Quattro tipi di architetture ed esempi di RNNs

<!--
The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.
-->
Il primo caso è da vettore a sequenza. L'input è una bolla e poi ci saranno evoluzioni dello stato interno del sistema annotate come bolle verdi. Man mano che lo stato del sistema si evolve, ci sarà un output specifico ad ogni specifico momento.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Vec to Seq
</center>
-->

<!--
An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.
-->
Un esempio di questo tipo di architettura è avere un'immagine come input mentre l'output sarà una sequenza di parole che rappresentano la descrizione - in inglese - dell'immagine di input. Guardando la Figura 6, ogni bolla blu qui può essere un indice per un dizionario di parole inglesi. Ad esempio, se l'output è la frase "Questo è uno scuolabus giallo". Prima ottieni l'indice della parola "Questo", quindi ottieni l'indice della parola "è" e così via. Alcuni dei risultati di questa rete sono mostrati di seguito. Ad esempio, nella prima colonna la descrizione relativa all'ultima foto è "Una mandria di elefanti che cammina attraverso un campo di erba secca", che è molto ben rifinita. Quindi nella seconda colonna, la prima immagine mostra "Due cani giocano nell'erba", mentre in realtà sono tre cani. Nell'ultima colonna ci sono esempi più sbagliati come "Uno scuolabus giallo parcheggiato in un parcheggio". In generale, questi risultati mostrano che questa rete possa fallire drasticamente e funzionare bene certe volte. Questo esempio rappresenta il caso in cui si parte da un vettore di input, che è la rappresentazione di un'immagine, a una sequenza di simboli, che sono ad esempio caratteri o parole che compongono le frasi inglesi. Questo tipo di architettura è chiamata rete autoregressiva. Una rete autoregressiva è una rete che fornisce un output prodotto dal ricevere in input l'output del passo precedente.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> vec2seq Example: Image to Text
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 6:</b> Esempio da vettore a sequenza: da immagine a testo
</center>

<!--
The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.
-->
Il secondo tipo si ha partendo da una sequenza e arrivando ad un vettore finale. Questa rete continua a ricevere una sequenza di simboli e solo alla fine fornisce un output finale. Un'applicazione di questo può usare la rete per interpretare Python. Ad esempio, in ingresso si possono avere righe di codice Python come queste.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Seq to Vec
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 7:</b> Da sequenza a vettore
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Input lines of Python Codes
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 8:</b> Linee di codice Python in ingresso
</center>

<!--
Then the network will be able to output the correct solution of this program. Another more complicated program like this:
-->
Quindi la rete sarà in grado di generare la soluzione corretta a questo programma. Un altro programma più complicato come questo:

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 9:</b> Linee di codice Python in ingresso in un caso più complicato
</center>

<!--
Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.
-->
Quindi l'output dovrebbe essere 12184. Questi due esempi mostrano che è possibile addestrare una rete neurale per eseguire questo tipo di operazione. Dobbiamo solo alimentare una sequenza di simboli e imporre che l'output finale sia un valore specifico.


<!--
The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).
-->
Il terzo esempio è da una sequenza ad un vettore e poi di nuovo a sequenza, mostrata in Figura 10. Questa architettura era il modo standard di eseguire traduzioni linguistiche. Inizi con una sequenza di simboli qui mostrati in rosa. Quindi tutto viene condensato in questa h finale, la quale rappresenta un concetto. Ad esempio, possiamo avere una frase come input e comprimerla temporaneamente in un vettore, che rappresenta il significato e il messaggio da inviare. Quindi, dopo aver ottenuto questo significato in qualunque rappresentazione, la rete lo srotola in una lingua diversa. Ad esempio "Today I'm very happy" ("Oggi sono molto felice") in una sequenza di parole in inglese che possono essere tradotte in italiano o cinese. In generale, la rete ottiene una sorta di codifica come input e li trasforma in una rappresentazione compressa. Infine, esegue la decodifica data la stessa versione compressa. Negli ultimi tempi abbiamo visto reti come il Transformatore (Transformer), che tratteremo nella prossima lezione, sovraperformare questo metodo nelle attività di traduzione linguistica. Questo tipo di architettura era lo stato dell'arte all'incirca due anni fa (2018).

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Seq to Vec to Seq
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 10:</b> da sequenza a vettore a sequenza
</center>

<!--
If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.
-->
Se eseguiamo un PCA nello spazio latente, otteremo le parole raggruppate per semantica come mostrato in questo grafico.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Words Grouped by Semantics after PCA
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 11:</b> Parole raggruppate secondo la semantica dopo una PCA
</center>

<!--
If we zoom in, we will see that the in the same location there are all the months, like January and November.
-->
Se ingrandiamo, vedremo che nella stessa posizione ci sono tutti i mesi, come gennaio e novembre.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b> Zooming in Word Groups
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 12:</b> Gruppi di parole visti da vicino
</center>

<!--
If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
-->
Se ci concentriamo su una regione diversa, troviamo frasi come "pochi giorni fa", "i prossimi mesi", ecc.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b> Word Groups in another Region
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 13:</b> Gruppe di parole in un'altra regione
</center>

<!--
From these examples, we see that different locations will have some specific common meanings.
-->
Da questi esempi vediamo che posizioni diverse avranno alcuni specifici significati in comune.


<!--
Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transofmation going from one word to another or from country to capital.
-->
La Figura 14 mostra come l'addestramento di questo tipo di rete rileverà alcune features semantiche. Per esempio, in questo caso puoi vedere che esiste un vettore che collega l'uomo alla donna e un altro tra re e regina, il che significa che la donna meno l'uomo sarà uguale alla regina meno il re. Si ottiene la stessa distanza in questo embedding applicato a casi come "maschio-femmina". Un altro esempio sarà "camminare" per "camminato" e "nuotare" per "nuotato". Puoi sempre applicare questo tipo di specifica trasformazione lineare che va da una parola all'altra o da un paese alla sua capitale.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b> Semantics Features Picked during Training
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 14:</b> Caratteristiche semantiche apprese durante l'addestramento
</center>

<!--
The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.
-->
Il quarto e ultimo caso è da sequenza a sequenza. In questa rete, quando si inizia a dare input alla rete, questa inizia subito a generare output. Un esempio di questo tipo di architettura è il celebre T9, se ricordi di aver utilizzato un telefono Nokia, si ricevevano suggerimenti di testo durante la digitazione. Un altro esempio è la traduzione "conversazione a didascalia". Un bell'esempio è la "RNN scrittore". Quando inizi a digitare "gli anelli di Saturno luccicano mentre", suggerisce quanto segue "due uomini si guardarono l'un l'altro". Questa rete è stata formata su alcuni romanzi di fantascienza in modo che tu possa semplicemente scrivere qualcosa e lasciarti dare suggerimenti per aiutarti a scrivere un libro. Un altro esempio è mostrato nella Figura 16. Inserisci il prompt principale e quindi questa rete proverà a completare il resto.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b> Seq to Seq
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 15:</b> Sequenza a Sequenza
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b> Text Auto-Completion Model of Seq to Seq Model
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 16:</b> Modello di completamento automatico del testo di un modello sequenza a sequenza
</center>


<!--
## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)
-->

## [Retropropagazione nel tempo](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)

<!--
### Model architecture
-->

### Architettura del Modello

<!--
In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.
-->
Per addestrare un RNN, è necessario utilizzare la retroprogazione nel tempo (BPTT, BackPropagation Through Time). L'architettura del modello di RNN è riportata nella figura seguente. Il design di sinistra utilizza la rappresentazione del ciclo mentre la figura a destra srotola il ciclo in un riga unica nel tempo.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b> Back Propagation through time
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 17:</b> Retropropagazione nel tempo
</center>

<!--
Hidden representations are stated as
-->
Le rappresentazioni nascoste sono indicate come:


$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

<!--
The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as
-->
La prima equazione indica una funzione non lineare applicata ad una rotazione di una versione dello stack di input in cui viene aggiunta la configurazione precedente del livello nascosto. All'inizio $h[0]$ è impostato a 0. Per semplificare l'equazione, $W_h$ può essere scritto come due matrici separate, $\left[W_{hx}\ W_{hh}\right]$, quindi a volte la trasformazione può essere dichiarata come:

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

<!--
which corresponds to the stack representation of the input.
-->
che corrisponde alla rappresentazione dello stack dell'input.

<!--
$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step.
-->


<!--
### Batch-Ification in Language Modeling
-->

### Batch-ificazione nella modellazione del linguaggio

<!--
When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.
-->
Quando si ha a che fare con una sequenza di simboli, possiamo raggruppare il testo in diverse dimensioni. Ad esempio, quando si ha a che fare con le sequenze mostrate nella figura seguente, è possibile applicare prima la batch-ificazione, in cui il dominio del tempo viene conservato verticalmente. In questo caso, la dimensione del batch è impostata su 4.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Batch-Ification
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 18:</b> Batch-ificazione
</center>

<!--
If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as
-->
Se il periodo BPTT $T$ è impostato su 3, il primo input $x[1:T]$ e output $y[1:T]$ per RNN è determinato come:


$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

<!--
When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.
-->
Quando eseguiamo RNN sul primo batch, in primo luogo, diamo $x[1] = [a\ g\ m\ s]$ in ingresso alla RNN e forziamo l'output a $y[1] = [b\ h\ n\ t]$. La rappresentazione nascosta $h[1]$ verrà inviata nel passaggio successivo per aiutare l'RNN a prevedere $y[2]$ da $x[2]$. Dopo aver inviato $h[T-1]$ al set finale di $x[T]$ e $y[T]$, viene tagliato il processo di propagazione del gradiente sia per $h[T]$ che per $h[0]$ in maniera tale che i gradienti non si propagheranno all'infinito (.detach () in Pytorch). L'intero processo è mostrato nella figura seguente.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Batch-Ification
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 19:</b> Batch-Ificazione
</center>

<!--
## Vanishing and Exploding Gradient
-->

### Scomparsa ed Esplosione del Gradiente

<!--
### Problem
-->

### Problema

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Vanishing Problem
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 20:</b> Scomparsa del gradiente
</center>

<!--
The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.
-->
La figura sopra è una tipica architettura RNN. Per eseguire la rotazione sui passaggi precedenti in una RNN, utilizziamo le matrici, che possono essere indicate con le frecce orizzontali nel modello sopra. Poiché le matrici possono modificare le dimensioni degli output, se il determinante che selezioniamo è maggiore di 1, il gradiente si gonfia nel tempo arrivando a provocare un'esplosione del gradiente. Relativamente parlando, se l'autovalore che selezioniamo è piccolo vicino 0, il processo di propagazione ridurrà i gradienti e porterà alla scomparsa del gradiente.

<!--
In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.
-->
In tipiche RNNs, i gradienti saranno propagati attraverso tutte le possibili frecce, il che fornisce ai gradienti una grande possibilità di scomparire od esplodere. Ad esempio, il gradiente al tempo 1 è grande, indicato dal colore brillante. Quando attraversa una rotazione, il gradiente diminuisce di molto e al passo temporale 3 viene ucciso.


<!--
### Solution
-->

### Soluzione

<!--
An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.
-->
Un metodo ideale per evitare che l'esplosione o la scomparsa del gradiente è quello di saltare le connessioni (dall'inglese "skip connection"). A tale scopo, è possibile utilizzare reti di moltiplicazioni.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Skip Connection
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 21:</b> Connessione diretta (Skip connection)
</center>

<!--
In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.
-->
Nota per il revisore: gated recurrent network non è facile da tradurre.
Nel caso sopra, abbiamo diviso la rete originale in 4 reti. Prendi la prima rete per esempio. Prende un valore dall'input al tempo 1 e invia l'output al primo stato intermedio nel layer nascosto. Lo stato ha altre 3 reti in cui $\circ$s consente il passaggio dei gradienti mentre $-$s blocca la propagazione. Tale tecnica si chiama gated recurrent network (rete ricorrente "con porte logiche")

<!--
LSTM is one prevalent gated RNN and is introduced in detail in the following sections.
-->
La LSTM è la principale RNN gated ed è introdotta in dettaglio nelle sezioni seguenti.

<!--
## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)
-->

## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)

<!--
### Model Architecture
-->

### Architettura del Modello

<!--
Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.
-->
Di seguito sono riportate le equazioni che descrivono una LSTM. La porta di input è evidenziata da caselle gialle, che saranno una trasformazione affine. Questa trasformazione di input moltiplicherà $c [t]$, che è la nostra porta candidato.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 22:</b> LSTM Architecture
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 22:</b> Architectura di una LSTM
</center>

<!--
Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.
-->
nota per il revisore: forget gate and candidate gate possono essere cambiate se non suonano bene come sono tradotte qui.
La porta per "non dimenticare" sta moltiplicando il valore precedente della memoria della cella $c[t-1]$. Il valore totale della cella $c[t]$ è uguale al valore della cella per non dimenticare più la porta di ingresso. La rappresentazione nascosta finale è la moltiplicazione dell'elemento tra la porta di output $o[t]$ e la versione in tangente iperbolica della cella $c[t]$, in modo tale che le cose siano limitate. Infine, la porta candidata $\tilde{c}[t]$ è semplicemente una rete ricorrente. Quindi abbiamo $o[t]$ per modulare l'output, $f[t]$ per modulare la porta per non dimenticare e $i[t]$ per modulare la porta di input. Tutte queste interazioni tra memoria e porte sono interazioni moltiplicative. $i[t]$, $f[t]$ e $o[t]$ sono tutte sigmoidi, che vanno da zero a uno. Quindi, moltiplicando per zero, ottieni una porta chiusa. Quando si moltiplica per uno, al contrario, ottieni una porta aperta.


<!--
How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.
-->
Come disattiviamo l'output? Diciamo che abbiamo una rappresentazione interna viola $th$ e mettiamo uno "zero" nella porta di uscita. Quindi l'output sarà zero moltiplicato per qualcosa e otterremo uno zero. Se ne inseriamo un "uno" nella porta di output, otterremo lo stesso valore della rappresentazione viola.

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> LSTM Architecture - Output On
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 23:</b> Architettura LSTM - Output attivo
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b> LSTM Architecture - Output Off
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 24:</b> Architectura LSTM - Output non attivo
</center>

<!--
Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.
-->
Allo stesso modo, possiamo controllare la memoria. Ad esempio, possiamo resettarlo settando $f[t]$ e $i[t]$ a zero. Dopo la moltiplicazione e la somma, abbiamo uno zero nella memoria. Altrimenti, possiamo conservare la memoria, annullando comunque la rappresentazione interna $th$ ma mantenendone una in $f[t]$. Quindi, la somma ottiene $c[t-1]$ e continua a inviarlo in output. Infine, possiamo scrivere in modo tale da poterne ottenere "uno" nella porta di input, la moltiplicazione diventa viola, quindi impostare uno zero nella porta per non dimenticare in modo che effettivamente dimentichi l'informazione.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b> Visualization of the Memory Cell
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 25:</b> Visualizazione di una cella di memoria
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b> LSTM Architecture - Reset Memory
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 26:</b> Architettura LSTM - ripristino della memoria
</center>

<!--
center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 27:</b> LSTM Architecture - Keep Memory
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 27:</b> Architettura LSTM - conservare la memoria
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Architecture - Write Memory
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 28:</b> Architettura LSTM - Scrittura della memoria
</center>

<!--
## Notebook Examples
-->
## Esempi del notebook

<!--
### Sequence Classification
-->
### Classificazioni di sequenze

<!--
The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.
-->
L'obiettivo è classificare le sequenze. Gli elementi e gli obiettivi sono rappresentati localmente (vettori di input con un solo bit diverso da zero). La sequenza comincia con una `B` e termina con una `E` (il "simbolo di innesco"), e altrimenti consiste in simboli scelti casualmente dall'insieme `{a, b, c , d}`, ad eccezione di due elementi nelle posizioni $t_1$ e $t_2$ che sono` X` o `Y`. Per il caso `DifficultyLevel.HARD`, la lunghezza della sequenza viene scelta casualmente tra 100 e 110, $t_1$ viene scelta casualmente tra 10 e 20 e $t_2$ viene scelta casualmente tra 50 e 60. Ci sono 4 classi di sequenza `Q`,`R`, `S` e `U`, che dipendono dall'ordine temporale di `X` e `Y`. Le regole sono: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

<!--
1). Dataset Exploration
-->
1). Esplorazione del dataset

<!--
The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.
-->
Il tipo restituito da un generatore di dati è una tupla con lunghezza 2. Il primo elemento nella tupla è il batch di sequenze con forma $ (32, 9, 8) $. Questi sono i dati che verranno inseriti nella rete. Ci sono otto simboli diversi in ogni riga (`X`,` Y`, `a`,` b`, `c`,` d`, `B`,` E`). Ogni riga è un vettore a uno caldo. Una sequenza di righe rappresenta una sequenza di simboli. Il primo aLa riga zero-zero è il riempimento. Usiamo il riempimento quando la lunghezza della sequenza è inferiore alla lunghezza massima nel batch. Il secondo elemento nella tupla è il corrispondente batch di etichette di classe con forma $ (32, 4) $, poiché abbiamo 4 classi (`Q`,` R`, `S` e` U`). La prima sequenza è: `BbXcXcbE`. Quindi la sua etichetta di classe decodificata è $ [1, 0, 0, 0] $, corrispondente a `Q`.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 29:</b> Input Vector Example
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figura 29:</b> Esempio di vettore di input
</center>

<!--
2). Defining the Model and Training
-->
2). Definizione del modello e addestramento

<!--
Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:
-->
Creiamo una rete ricorrente semplice, una LSTM e addestriamole per 10 epoche. Nelle iterazioni di addestramento dovremmo sempre cercare cinque passaggi:

<!--
 * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient
-->
 * Eseguire il forward pass del modello
 * Calcolare l'errore
 * Azzerare la cache del gradiente
 * Retropropagare per calcolare la derivata parziale dell'errore rispetto ai parametri
 * Passo nella direzione opposta al gradiente

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 30:</b> Simple RNN vs LSTM - 10 Epochs
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 30:</b> Semplice RNN vs. LSTM - 10 Epoche
</center>

<!--
With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.
-->

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> Simple RNN vs LSTM - 100 Epochs
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 31:</b> Semplice RNN vs LSTM - 100 Epoche
</center>

<!--
If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.
-->

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualization of Hidden State Value
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 32:</b> Visualizzazione del valore dello stato nascosto
</center>

<!--
The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence.
-->
La visualizzazione sopra mostra il valore dello stato nascosto nel tempo in una LSTM. Verrà applicata una tangente iperbolica agli input, in modo tale che se l'input è inferiore a $-2,5$, verrà mappato a $-1$ e se sarà superiore a $2,5$, verrà mappato a $1$. Quindi, in questo caso, possiamo vedere lo specifico livello nascosto scelto su `X` (quinta fila nella foto) che poi diventa rosso fino a quando non otteniamo l'altra `X`. Quindi, la quinta unità nascosta della cellula viene attivata osservando la `X` e diventa silenziosa dopo aver visto l'altra `X`. Questo ci consente di riconoscere la classe di sequenza.

<!--
### Signal Echoing
-->
### Eco del segnale

<!--
Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.
-->
L'eco del segnale ad n step è un esempio di un compito molti-a-molti sincronizzato. Ad esempio, la prima sequenza di input è `" 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ... "`, e la prima sequenza target è `" 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 ... "`. In questo caso, l'output è tre passi dopo. Quindi abbiamo bisogno di una memoria di lavoro di breve durata per conservare le informazioni. Nel modello linguistico invece dice qualcosa che non è già stato detto.

<!--
Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past.
-->
Prima di inviare l'intera sequenza alla rete e forzare l'obiettivo finale ad essere qualcosa, dobbiamo tagliare la lunga sequenza in piccoli pezzi. Quando un nuovo blocco viene dato in ingresso, è necessario tenere traccia dello stato nascosto e inviarlo come input allo stato interno quando si aggiunge il successivo nuovo blocco. Laddove una RNN inizia a dimenticare cosa è successo in passato dopo una certa lunghezza, una LSTM è invece capace di conservare la memoria per lungo tempo, purchè si disponga di capacità sufficiente.
