---
lang-ref: ch.06-2
lang: it
lecturer: Yann LeCun
title: RNNs, GRUs, LSTMs, Attenzione, Seq2Seq, e Reti di Memoria
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 Mar 2020
translation-date: 7 Jul 2020
translator: Alessio Salman
---
<!-- 
## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)
-->
## [Architetture di apprendimento profondo](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

<!-- 
In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.

As with what we saw with convolutional networks, network architecture is important.
-->
Nell'apprendimento profondo, ci sono diversi moduli per realizzare funzioni diverse. La competenza nell'ambito dell'apprendimento profondo implica la progettazione di architetture per risolvere compiti particolari. Simile alla scrittura di programmi con algoritmi per fornire istruzioni a un computer nel passato, l'apprendimento profondo riduce una funzione complessa ad un grafo di moduli funzionali (possibilmente dinamici), le cui funzioni sono finalizzate dall'apprendimento.

Come per quello che abbiamo visto con le reti convoluzionali, l'architettura delle reti è importante.

<!-- 
## Recurrent Networks
-->
## Reti ricorrenti

<!-- 
In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.

As shown in Figure 1, there are loops in Recurrent Neural Networks.
-->

In una rete neurale convoluzionale, il grafico o le interconnessioni tra i moduli non possono avere dei loop. Esiste almeno un ordine parziale tra i moduli in modo tale che gli input alla rete siano disponibili quando calcoliamo le uscite.

Come mostrato in Figura 1, ci sono dei cicli nelle reti neurali ricorrenti. 

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figure 1. Recurrent Neural Network with roll
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figura 1. Reti ricorrenti con loop 
</center>

<!-- 
 - $x(t)$ : input that varies across time
 - $\text{Enc}(x(t))$: encoder that generates a representation of input
 - $h(t)$: a representation of the input
 - $w$: trainable parameters
 - $z(t-1)$: previous hidden state, which is the output of the previous time step
 - $z(t)$: current hidden state
 - $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
 - $\text{Dec}(z(t))$: decoder that generates an output
-->

 - $x(t)$ : input che cambia nel tempo 
 - $\text{Enc}(x(t))$: codificatore che genera una rappresentazione dell'input
 - $h(t)$: rappresentazione dell'input
 - $w$: parametri addestrabili 
 - $z(t-1)$: precedente stato nascosto, il quale è l'output del precedente passo temporale
 - $z(t)$: stato nascosto corrente
 - $g$: funzione che può essere una rete neurale complessa; uno degli input è $z(t-1)$ che è l'output del passo temporale precedente
 - $\text{Dec}(z(t))$: decodificatore che genera l'output

<!-- 
## Recurrent Networks: Unroll the loop
-->
## Reti ricorrenti: srotolare il ciclo

<!-- 
Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$.
-->
Srotolare il ciclo lungo la dimensione temporale. L'input è una sequenza $x_1, x_2, \cdots, x_T$.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figure 2. Recurrent Networks with unrolled loop
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figura 2. Reti ricorrenti con un ciclo srotolato
</center>

<!-- 
In Figure 2, the input is $x_1, x_2, x_3$.
-->
In Figura 2, l'input è $x_1, x_2, x_3$

<!-- 
At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.

As there are no loops in this network, and we can implement backpropagation.
-->
Al tempo t = 0, l'ingresso $x (0)$ viene passato all'encoder che genera la rappresentazione $h(x(0)) = \text{Enc}(x(0))$ e poi lo passa a G per generare lo stato nascosto $z(0) = G(h_0, z', w)$. Per $t = 0$, $z'$ in $G$ può essere inizializzato a $0$ o inizializzato casualmente. $z(0)$ viene passato sia al decodificatore per generare un output sia al passo temporale successivo.

Poiché non ci sono loop in questa rete e possiamo implementare la backpropagation.

<!-- 
Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.
-->
La Figura 2 mostra una rete regolare con una caratteristica particolare: ogni blocco condivide gli stessi pesi. Tre codificatori, decodificatori e funzioni G hanno gli stessi pesi rispettivamente attraverso diversi passi temporali.


<!-- 
BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN.

Problems with RNNs:

1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work.
-->

BPTT: retropropagazione nel tempo (BPTT, Backprop through time). Sfortunatamente, BPTT non funziona così bene nella forma naive delle RNN.

Problemi con RNN:

1. Scomparsa del gradiente
   - In una lunga sequenza, i gradienti vengono moltiplicati per la matrice del peso (trasposizione) ad ogni passo temporale. Se ci sono piccoli valori nella matrice del peso, la norma dei gradienti diventa esponenzialmente sempre più piccola.
2. Esplosione del gradiente
   - Se abbiamo una matrice di peso con valori elevati e la non linearità nello strato ricorrente non satura, i gradienti esploderanno. I pesi divergeranno nella fase di aggiornamento. Potrebbe essere necessario utilizzare un learning rate molto piccolo per riuscire a far funzionare la discesa del gradiente.

<!-- 
One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.
-->
Uno dei motivi per utilizzare gli RNN è il vantaggio di ricordare le informazioni in passato. Tuttavia, potrebbe non riuscire a memorizzare le informazioni molto tempo fa in un semplice RNN senza trucchi.

<!-- 
An example that has vanishing gradient problem:

The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program.
-->

Un esempio che presenta un problema di scomparsa del gradiente:

L'input sono i caratteri di un programma C. Il sistema dirà se si tratta di un programma sintatticamente corretto. Un programma sintatticamente corretto dovrebbe avere un numero valido di parentesi graffe, quadre e tonde. Pertanto, la rete dovrebbe ricordare quante parentesi aperte ci sono da verificare e se le abbiamo chiuse tutte. La rete deve archiviare tali informazioni in stati nascosti come un contatore. Tuttavia, a causa della scomparsa del gradiente, la rete non riuscirà a conservare tali informazioni se il programma è sufficientemente lungo. 

<!-- 
##  RNN Tricks
-->
##  Stratagemmi per RNN

<!-- 
- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix.
-->

- taglio dei gradienti: (evita l'esplosione dei gradienti)
   Schiaccia i gradienti quando diventano troppo grandi.
- Inizializzazione (iniziare nel campo di gioco giusto evita l'esplosione/scomparsa dei gradienti)
   Inizializza le matrici dei pesi per preservare la norma ad una certa misura. Ad esempio, l'inizializzazione ortogonale inizializza la matrice del peso come matrice ortogonale casuale.


<!-- 
## Multiplicative Modules
-->
## Moduli moltiplicativi

<!-- 
In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.

Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor.
-->
Nei moduli moltiplicativi piuttosto che calcolare solo una somma ponderata di input, calcoliamo i prodotti degli input e quindi calcoliamo la somma ponderata di quest'ultimi.

Supponiamo che $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Qui U è un tensore.

<!-- 
$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$
-->
$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

<!-- 
$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$
-->
$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$

<!-- 
where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.
-->
ove, $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$. 

<!-- 
The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.
-->
L'output del sistema è una classica somma ponderata di input e pesi. Questi pesi sono a loro volta una somma ponderate di pesi e input.


<!-- 
Hypernetwork architecture: weights are computed by another network.
-->
Architettura di una Hypernetwork: i pesi sono calcolati da un'altra rete.

<!-- 
## Attention
-->
## Meccanismo di attenzione

<!-- 
$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.

$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.
-->

$x_1$ e $x_2$ sono vettori, $w_1$ e $w_2$ sono scalari dopo softmax dove $w_1 + w_2 = 1$ e $w_1$ e $w_2$ sono compresi tra 0 e 1.

$w_1x_1 + w_2x_2$ è una somma ponderata di $x_1$ e $x_2$ ponderata per coefficienti $w_1$ e $w_2$.

<!-- 
By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.
-->
Modificando la dimensione relativa di $w_1$ e $w_2$, possiamo cambiare l'output di $w_1x_1 + w_2x_2$ in $x_1$ o $x_2$ o alcune combinazioni lineari di $x_1$ e $x_2$.

<!--
The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.

Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.

The weights are data independent because z is data independent. 
-->

Gli input possono avere più vettori $x$ (più di $x_1$ e $x_2$). Il sistema sceglierà una combinazione appropriata, la cui scelta è determinata da un'ulteriore variabile z. Un meccanismo di attenzione consente alla rete neurale di focalizzare la sua attenzione su particolari input ed ignorarne altri.

L'attenzione è sempre più importante nei sistemi elaborazione del linguaggio naturale (NLP, Natural Language Processing) che utilizzano architetture di trasformatori o altri tipi di meccanismi di attenzione.

I pesi sono indipendenti dai dati perché z è indipendente dai dati.

<!-- 
## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)
-->
## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

<!-- 
As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below:
-->

Come accennato in precedenza, le RNNs soffrono del problema della scomparsa/esplosione del gradiente e non riesce a memorizzare gli stati per un periodo temporale molto lungo. GRU, [Cho, 2014] (https://arxiv.org/abs/1406.1078), è un'applicazione di moduli moltiplicativi che tenta di risolvere questi problemi. È un esempio di rete ricorrente con memoria (un altro sono le LSTM). La struttura di un'unità GRU è mostrata di seguito:

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. Gated Recurrent Unit
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figura 3. Gated Recurrent Unit
</center>

<!-- 
$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$
-->
$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

<!-- 
where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.
-->

dove $\odot$ indica la moltiplicazione degli elementi (prodotto di Hadamard), $x_t$ è il vettore di input, $h_t$ è il vettore di output, $z_t$ è il vettore del gate di aggiornamento, $r_t$ è il vettore del gate di ripristino, $\phi_h$ è una tangente iperbolica e $W$, $U$, $b$ sono parametri da apprendere.

<!-- 
To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.
-->

Per essere precisi, $z_t$ è un vettore di gating che determina la quantità di informazioni passate da trasmettere nel futuro. Applica una funzione sigmoide alla somma di due strati lineari e un bias sull'input $x_t$ e lo stato precedente $h_{t-1}$. $z_t$ è un coefficiente tra 0 e 1 come risultato dell'applicazione della sigmoide. Lo stato di output finale $h_t$ è una combinazione convessa di $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. Se il coefficiente è 1, l'output dell'unità corrente è solo una copia dello stato precedente e ignora l'input (che è il comportamento predefinito). Se è inferiore a uno, tiene conto di alcune nuove informazioni dall'input.

<!-- 
The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input.
-->
Il gate di ripristino $r_t$ viene utilizzato per decidere la quantità di informazioni passate da dimenticare. Nel nuovo contenuto di memoria $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, se il coefficiente in $r_t$ è 0, non viene memorizzata nessuna delle informazioni del passato. Se allo stesso tempo $z_t$ è 0, il sistema è completamente ripristinato poiché $h_t$ guarderebbe solo l'input.


<!-- 
## LSTM (Long Short-Term Memory)
-->
## LSTM (Long Short-Term Memory)

<!-- 
GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below:
-->

GRU è in realtà una versione semplificata di una cella LSTM che è uscita molto prima, [Hochreiter, Schmidhuber, 1997] (https://www.bioinf.jku.at/publications/older/2604.pdf). Costruendo celle di memoria per preservare le informazioni passate, le LSTM mirano anche a risolvere i problemi di perdita di memoria a lungo termine che abbiamo visto nelle RNN. La struttura degli LSTM è mostrata di seguito:

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figure 4. LSTM
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figura 4. LSTM
</center>

<!-- 
$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$
-->
$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

<!-- 
where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.
-->
dove $\odot$ indica la moltiplicazione elemento per elemento, $x_t\in\ mathbb{R}^a$ è un vettore di input per la cella LSTM, $f_t\in\mathbb{R}^h$ è il vettore di attivazione del gate per dimenticare (forget gate), $i_t\in\mathbb{R}^h$ è il vettore di attivazione del gate di input/aggiornamento, $o_t\in\mathbb{R}^h$ è il vettore di attivazione del gate di output, $h_t\in\mathbb{R}^h$ è il vettore dello stato nascosto (noto anche come output), $c_t\in\mathbb{R}^h$ è il vettore di stato della cella.

<!-- 
An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.
-->

Un'unità LSTM utilizza una cella $c_t$ per trasmettere le informazioni attraverso l'unità. Essa regola come le informazioni vengono preservate o rimosse dallo stato della cella attraverso strutture chiamate gate. La porta di dimenticanza $f_t$ decide quante informazioni vogliamo conservare dallo stato della cella precedente $c_{t-1}$ osservando l'input corrente e lo stato nascosto precedente e produce un numero compreso tra 0 e 1 come coefficiente di $c_{t-1}$. $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ calcola un nuovo candidato per aggiornare lo stato della cella e, come il gate di dimenticanza, il gate di input $i_t$ decide la quantità di aggiornamento da applicare. Infine, l'output $h_t$ si baserà sullo stato della cella $c_t$, ma verrà sottoposto a $\tanh$, quindi filtrato dal gate di output $o_t$.

<!-- 
Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers.
-->

Sebbene le LSTM siano ampiamente utilizzati nel NLP, la loro popolarità sta diminuendo. Ad esempio, il riconoscimento vocale si sta muovendo verso l'utilizzo della CNN temporale e l'NLP si sta muovendo verso l'utilizzo di trasformatori.

<!-- 
## Sequence to Sequence Model
-->
## Modello Sequenza a Sequenza

<!-- 
The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs.
-->

L'approccio proposto da [Sutskever NIPS 2014] (https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) è il primo sistema di traduzione automatica neurale ad avere comparabili prestazioni agli approcci classici. Utilizza un'architettura encoder-decoder in cui sia l'encoder che il decoder sono LSTM multistrato.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figura 5. Seq2Seq (Sequenza a Sequenza)
</center>

<!-- 
Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.
-->

Ogni cella nella figura è una LSTM. Per l'encoder (la parte a sinistra), il numero di passi temporali è uguale alla lunghezza della frase da tradurre. Ad ogni passo, c'è una pila di LSTM (quattro strati nel paper originale) in cui lo stato nascosto dell'LSTM precedente viene dato in ingresso al successivo. L'ultimo livello dell'ultima fase temporale genera un vettore che rappresenta il significato dell'intera frase, che viene quindi immesso in un'altra LSTM (il decodificatore) multistrato, che produce le parole nella lingua di destinazione. Nel decodificatore il testo viene generato in modo sequenziale; ogni passaggio produce una parola che viene inserita come input per il passaggio temporale successivo.


<!-- 
This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information.
-->

Due punti rendono questa architettura non soddisfacente: in primo luogo, l'intero significato della frase deve essere compresso nello stato nascosto tra l'encoder e il decoder. In secondo luogo, le LSTM in realtà non conservano le informazioni per più di circa 20 parole. La correzione di questi problemi si chiama Bi-LSTM, che esegue due LSTM in direzioni opposte. In un Bi-LSTM il significato è codificato in due vettori, uno generato eseguendo una LSTM da sinistra a destra, e un altro da destra a sinistra. Ciò consente di raddoppiare la lunghezza della frase senza perdere troppe informazioni.


<!-- 
## Seq2seq with Attention
-->
## Seq2seq con meccanismo di Attenzione

<!-- 
The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, i.e. the attention mechanism.
-->
Il successo dell'approccio di cui sopra è stato di breve durata. Un altro articolo di [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473) ha suggerito che invece di avere una rete gigantesca che comprime il significato dell'intera frase in un singolo vettore, avrebbe più senso se ad ogni passo temporale focalizzassimo l'attenzione solo sugli elementi rilevanti della frase in lingua originale con significato equivalente, cioè il meccanismo di attenzione.



<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq with Attention
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figura 6. Seq2Seq con Attenzione
</center>

<!-- 
In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!
-->

Nei modelli con attenzione, per produrre la parola corrente ad ogni passo temporale, dobbiamo prima decidere su quali rappresentazioni nascoste delle parole nella frase di input concentrarci. In sostanza, una rete imparerà a valutare in che misura ciascun ingresso codificato corrisponde all'uscita corrente del decodificatore. Questi punteggi sono normalizzati da un softmax, quindi i coefficienti vengono utilizzati per calcolare una somma ponderata degli stati nascosti nell'encoder in diverse fasi temporali. Regolando i pesi, il sistema può regolare l'area dell'input su cui concentrarsi. La magia di questo meccanismo è che la rete utilizzata per calcolare i coefficienti può essere addestrata attraverso la backpropagation. Non è necessario costruirseli a mano!


<!-- 
Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention.
-->

I meccanismi di attenzione hanno trasformato completamente la traduzione automatica neurale. Successivamente, Google ha pubblicato un documento [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762) e ha presentato il trasformatore, dove ogni strato e gruppo di neuroni utilizza il meccanisdmo di attenzione.


<!-- 
## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)
-->
## [Reti di Memoria](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

<!-- 
Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.
-->
Le reti di memoria derivano dal lavoro a Facebook avviato da [Antoine Bordes](https://arxiv.org/abs/1410.3916) nel 2014 e [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) nel 2015 .


<!-- 
The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.
-->

L'idea di una rete di memoria è che ci sono due parti importanti nel tuo cervello: una è la **corteccia**, dove si trova la memoria a lungo termine. C'è un gruppo separato di neuroni chiamato **ippocampo** che invia dei fili quasi ovunque nella corteccia. Si pensa che l'ippocampo sia usato per la memoria a breve termine, ricordando le cose per un periodo di tempo relativamente breve. La teoria prevalente è che quando uno dorme, ci siano molte informazioni trasferite dall'ippocampo alla corteccia per essere solidificate nella memoria a lungo termine poiché l'ippocampo ha una capacità limitata.


<!-- 
For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result.
-->

In una rete di memoria esiste un input per la rete, $x$ (si può pensare ad un indirizzo della memoria) che viene confrontato con i vettori $k_1, k_2, k_3, \cdots$ ("chiavi") attraverso un prodotto scalare. Dandoli in ingresso ad un softmax si ottiene una matrice di numeri a somma uno. Ci sono poi una serie di altri vettori $v_1, v_2, v_3, \cdots$ ("valori"). Moltiplicando questi vettori per degli scalari ottenuti dai softmax e sommando i vettori così ottenuti (notare la somiglianza con il meccanismo di attenzione) si ottiene il risultato.



<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. Memory Network
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figura 7. Reti di memoria
</center>

<!-- 
If one of the keys (e.g. $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.
-->
Se una delle chiavi (ad esempio $k_i$) corrisponde esattamente a $x$, il coefficiente associato a questa chiave sarà molto vicino a uno. Quindi l'output del sistema sarà essenzialmente $v_i$.

<!-- 
This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.
-->
Questa è **memoria associativa indirizzabile**. Ovvero una memoria in cui ad ogni chiave corrisponde *quello* specifico valore. E questa è solo una versione leggermente differenziabile, che ti consente di fare retropropagazione e quindi cambiare i vettori attraverso la discesa del gradiente.

<!-- 
What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.
-->
Quello che gli autori hanno fatto è stato raccontare una storia a un sistema dandogli una sequenza di frasi. Le frasi vengono codificate in vettori facendole passare attraverso una rete neurale che non è stata preaddestrata. Le frasi vengono riportate in una memoria di questo tipo. Quando si pone una domanda al sistema, si codifica la domanda e la si inserisce come input di una rete neurale, la rete neurale produce un $x$ in memoria e la memoria restituisce un valore.

<!-- 

-->
This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions.

Questo valore, insieme allo stato precedente della rete, viene utilizzato per accedere nuovamente alla memoria. Così viene addestrata l'intera rete per produrre una risposta alla tua domanda. Dopo un lungo addestramento, questo modello impara effettivamente a memorizzare storie e rispondere a domande.

<!-- 
$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$
-->
$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

<!-- 
In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write.
-->
In una rete di memoria, esiste una rete neurale che accetta un input e quindi produce un indirizzo per la memoria, ritorna il valore alla rete, continua ad eseguire e alla fine produce un output. Questo è molto simile ad un computer poiché c'è una CPU e una memoria esterna dove leggere e scrivere.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

Figura 8. Confronto fra reti di memoria e computer (Foto da <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

<!-- 
There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.
-->
Ci sono persone che immaginano che tu possa effettivamente costruire **computer differenziabili** da questo tipo di modelli. Un esempio è la [Neural Turing Machine](https://arxiv.org/abs/1410.5401) di DeepMind, che è stata resa pubblica tre giorni dopo la pubblicazione dell'articolo di Facebook su arXiv.

<!-- 
The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is. A transformer is basically a neural net in which every group of neurons is one of these networks.
-->
L'idea è quella di confrontare gli input con le chiavi, generare coefficienti e produrre valori - che è fondamentalmente ciò che fa un modello trasformatore. Un trasformatore è fondamentalmente una rete neurale in cui ogni gruppo di neuroni è una di queste reti.
