---
lang-ref: ch.06-1
lang: it
lecturer: Yann LeCun
title: Applicazioni di Reti Convoluzionali
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
translation-date: 6 May 2020
translator: Alessio Salman
---

<!--
## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)
-->

## [Riconoscimento di codici ZIP](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)


<!--
In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network.
-->

Nella lezione precedente, abbiamo dimostrato come una rete convoluzionale sia in grado di riconoscere le cifre, tuttavia una questione rimane aperta: come fa il modello a selezionare ciascuna cifra ed evitare perturbazioni sulle cifre vicine? Il passaggio successivo consiste nel rilevare oggetti non sovrapposti e utilizzare l'approccio generale della soppressione dei non-massimi (*non-maximum suppression, NMS*). Supponendo che l'input sia una serie di cifre non sovrapposte, la strategia è quella di addestrare diverse reti convoluzionali ed utilizzare il voto di maggioranza oppure scegliere le cifre corrispondenti al punteggio più alto generato dalla rete convoluzionale.


<!--
### Recognition with CNN
-->

### Riconoscimento mediante CNN

<!--
Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes.
-->

Qui presentiamo il compito di riconoscere 5 codici postali non sovrapposti. Al sistema non sono state fornite istruzioni su come separare ogni cifra ma sa che è necessario predire 5 cifre. Il sistema (Figura 1) è costituito da 4 reti convoluzionali di dimensioni diverse, ciascuna delle quali produce un insieme di output. L'output è rappresentato da matrici. Le quattro matrici di output provengono da modelli con diverse larghezze del *kernel* nell'ultimo livello. In ogni output ci sono 10 righe che rappresentano le 10 categorie, da 0 a 9. Il quadrato bianco più grande rappresenta un punteggio più alto nella corrispondente categoria. In questi quattro blocchi di output, le dimensioni orizzontali del *kernel* degli ultimi layer sono rispettivamente 5, 4, 3 e 2. La dimensione del *kernel* decide la larghezza della finestra di visualizzazione del modello sull'input, pertanto ogni modello predice cifre basate su dimensioni della finestra diverse. Il modello quindi prende il voto di maggioranza e seleziona la categoria che corrisponde al punteggio più alto in quella finestra. Per estrarre informazioni utili, è necessario tenere presente che non tutte le combinazioni di caratteri sono possibili, pertanto correggere gli errori facendo leva sulle restrizioni sull'input è utile per garantire che gli output siano veri codici postali.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 1:</b> Diversi classificatori su riconoscimento di codici zip
</center>



<!--
Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit.
-->
Ora bisogna imporre l'ordine dei caratteri. Il trucco è utilizzare un algoritmo di cammino minimo. Poiché ci vengono forniti intervalli di caratteri possibili e il numero totale di cifre da prevedere, possiamo affrontare questo problema calcolando il costo minimo di generazione delle cifre e le transizioni tra le cifre. Il percorso deve essere continuo dalla cella in basso a sinistra sul grafico alla cella in alto a destra, e può contenere solo i movimenti da sinistra a destra e dal basso verso l'alto. Si noti che se lo stesso numero viene ripetuto, l'algoritmo dovrebbe essere in grado di distinguere che è in presenza di due numeri ripetuti invece di prevedere una singola cifra.


<!--
## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)
-->
## [Riconoscimento facciale](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)


<!--
Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist.
-->

Le reti neurali convoluzionali svolgono bene i compiti di rilevamento ed anche il rilevamento dei volti non fa eccezione. Per eseguire il rilevamento facciale, raccogliamo un set di dati di immagini con e senza volti, su cui addestriamo una rete convoluzionale (con una dimensione della finestra di circa 30 $\times$ 30 pixel) la quale ha il compito di rilevare la presenza di un volto. Una volta addestrata, applichiamo il modello a una nuova immagine e se ci sono facce approssimativamente all'interno di una finestra di 30 $\times$ 30 pixel, la rete convoluzionale illuminerà l'output nelle posizioni corrispondenti. Esistono tuttavia due problemi.


<!--
- **False Positives**: There are many different variations of non-face objects that may appear in a patch of an image. During the training stage, the model may not see all of them (i.e. a fully representative set of non-face patches). Therefore, the model may suffer from a lot of false positives at test time. For example, if the network has not been trained on images containing hands, it may detect faces based on skin tones and incorrectly classify patches of images containing hands as faces, thereby giving rise to false positives.
-->

- **Falsi positivi**: ci sono molti modi in cui un oggetto che non è un volto possa apparire in una parte di immagine. Durante la fase di addestramento, il modello potrebbe non vederne tutte le varianti (ovvero, potrebbe non vedere un set completamente rappresentativo di immagini non contenente un volto). Pertanto, il modello potrebbe soffrire di molti falsi positivi durante la fase di test. Ad esempio, se il modello non è stato addestrato su immagini contenenti una mano, potrebbe rilevare un volto in base alla tonalità di pelle e scambierebbe una mano per un volto, risultando in falsi positivi.     


<!--
- **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost.
-->

- **Diverse dimensioni del viso:** Non tutti i volti sono 30 $\times$ 30 pixel, quindi i volti di dimensioni diverse potrebbero non essere rilevati. Un modo per gestire questo problema è generare più versioni della stessa immagine su diverse scale. Il rilevatore originale rileverà volti di circa 30 $\times$ 30 pixel. Se si riscala l'immagine di un fattore $\sqrt 2$, il modello rileverà volti più piccoli nell'immagine originale poiché ciò che era 30 $\times$ 30 è ora diventato 20 $\times$ 20 pixel all'incirca. Per rilevare volti più grandi, possiamo rimpicciolire l'immagine. Questo processo è economico poiché metà del costo deriva dall'elaborazione dell'immagine originale non in scala. La somma dei costi di tutte le altre reti combinate è quasi uguale all'elaborazione dell'immagine originale non ridimensionata. La dimensione della rete è il quadrato della dimensione dell'immagine su un lato, quindi se riduci l'immagine di $\sqrt 2$, la rete che devi eseguire è più piccola di un fattore di 2. Quindi il costo complessivo è $1+1/2+1/4+1/8+1/16+…$, che è 2. Da cui segue che il costo d'esecuzione di un modello multiscala è solamente il doppio di quello normale.



<!--
### A multi-scale face detection system
-->
### Un sistema di rilevamento facciale multiscala

<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figura 2:</b> Sistema di rilevamento facciale
</center>

<!--

The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face.
-->
Le mappe mostrate in (Figura 3) indicano i punteggi dei rilevatori di volti. Questo rilevatore di volti riconosce volti di dimensioni 20 $\times $ 20 pixel. In scala fine (Scala 3) ci sono molti punteggi alti ma non sono molto definiti. Quando il fattore di ridimensionamento aumenta (Scala 6), vediamo più aree bianche raggruppate. Quelle regioni bianche rappresentano i volti rilevati. Quindi applichiamo la soppressione dei non-massimi per ottenere la posizione finale del viso.

<!--

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 3:</b> Punteggi dei rilevatori di volti per diversi fattori di scala
</center>


<!--
### Non-maximum suppression
-->
### Soppressione dei non-massimi


<!--

For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location.
-->

In ogni regione con punteggio elevato vi è probabilmente sotto una faccia. Se vengono rilevati più volti molto vicini al primo, significa che solo uno dovrebbe essere considerato corretto e il resto sbagliato. Con la soppressione dei non-massimi, prendiamo il punteggio più alto tra le *bounding boxes* sovrapposte e rimuoviamo gli altri. Il risultato sarà una unica *bounding box* nella posizione ottimale.


<!--
### Negative mining
-->

### Estrazione negativa

<!--
In the last section, we discussed how the model may run into a large number of false positives at test time as there are many ways for non-face objects to appear similar to a face. No training set will include all the possible non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches which the model has (erroneously) detected as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives.
-->

Nell'ultima sezione, abbiamo discusso di come il modello si possa imbattere in un numero elevato di falsi positivi al momento del test poiché ci sono molti modi per far apparire un oggetto che non è una faccia. Nessun set di addestramento potrà mai includere tutti gli oggetti che sembrano volti ma non lo sono. Possiamo mitigare questo problema attraverso il mining negativo. Nel mining negativo, creiamo un set di dati negativi formato da pezzi (*patches*) di immagine che non contengono volti che il modello rileva erroneamente come facce. I dati vengono raccolti eseguendo il modello su input noti per non contenere volti. Quindi addestriamo nuovamente il rivelatore utilizzando il set di dati negativi. Possiamo ripetere questo processo per aumentare la solidità del nostro modello contro i falsi positivi.


<!--
## Semantic segmentation
-->
# Segmentazione semantica

<!--
Semantic segmentation is the task of assigning a category to every pixel in an input image.
-->

La segmentazione semantica è il compito di assegnare una categoria a ciascun pixel di un'immagine di input.


<!--
### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)
-->
### [CNN per visione robotica adattiva a lungo raggio](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)


<!--
In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red.
-->

In questo progetto, l'obiettivo era etichettare le regioni delle immagini di input in modo che un robot potesse distinguere tra strade e ostacoli. Nella figura, le regioni verdi sono aree su cui il robot può guidare e le regioni rosse sono ostacoli, come ad esempio l'erba alta. Per addestrare la rete per questa attività, abbiamo preso una patch dall'immagine ed l'abbiamo manualmente etichettata come attraversabile o meno (rispettivamente, verde o rosso). Addestriamo quindi la rete convoluzionale sui pezzi di immagine (*patch*) chiedendole di prevederne il colore. Una volta che il sistema sia stato sufficientemente addestrato, viene applicato all'intera immagine, etichettando tutte le regioni dell'immagine come verdi o rosse.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 4:</b>CNN per visione robotica adattiva a lungo raggio (programma DARPA LAGR 2005-2008)
</center>


<!--
There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle.
-->

Esistono cinque categorie da classificare: 1) verde intenso, 2) verde, 3) viola: linea del piede ostacolo, 4) rosso: ostacolo 5) rosso intenso: sicuramente un ostacolo.


<!--
**Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it.
-->

**Etichette stereo** (Figura 4, Colonna 2)
 Le immagini vengono catturate dalle 4 telecamere sul robot e poi raggruppate in 2 coppie di visione stereo.Utilizzando le distanze note tra le telecamere della coppia stereo possiamo stimare le posizioni di ogni pixel nello spazio 3D; quest'ultime possono infatti essere calcolate misurando le distanze relative tra i pixel che appaiono in entrambe le telecamere in una coppia stereo. Questo è lo stesso processo che i nostri cervelli usano per stimare la distanza degli oggetti che vediamo. Utilizzando le informazioni sulla posizione stimata, si esegue il fitting di una superficie piana al terreno ed i pixel vengono quindi etichettati come verdi se si trovano vicino al suolo e rossi se si trovano sopra di esso.


<!--
* **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly.
-->
* **Motivazione per l'utilizzo delle ConvNet e le loro limitazioni**: la visione stereo funziona solo fino a 10 metri e la guida di un robot richiede una visione a lungo raggio. Una ConvNet, invece, è in grado di rilevare oggetti a distanze molto maggiori se addestrata correttamente.


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figura 5:</b> Piramide invariante per scala di immagini normalizzate sulla distanza</center>


<!--
* **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales.
-->

* **Usata come input del modello**: un'importante pre-elaborazione include la costruzione di una piramide a scala invariante di immagini normalizzate sulla distanza (Figura 5). È simile a quello che abbiamo fatto prima di questa lezione quando abbiamo cercato di rilevare i volti di più dimensioni.


<!--
**Model Outputs** (Figure 4, Column 3)

The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network.
-->

**Output del modello** (Figura 4, colonna 3)

Il modello genera un'etichetta per ogni pixel dell'immagine **fino all'orizzonte**. Queste sono gli output di classificazione di una rete convoluzionale multiscala.


<!--
* **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed.
-->

* **Come il modello diventa adattivo**: i robot hanno accesso continuo alle etichette stereo, permettendo alla rete di riaddestrarsi, adattandosi al nuovo ambiente in cui si trova. Si noti che solo l'ultimo strato della rete verrebbe riaddestrato in base all'ambiente. I livelli precedenti vengono addestrati in laboratorio e mantenuti costanti.

<!--
**System Performance**

When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away.
-->
**Prestazioni del sistema**

Quando cercava di raggiungere una coordinata GPS dall'altra parte di una barriera, il robot "vedeva" la barriera da molto lontano e pianificava un percorso che la evitava. Questo avviene grazie alla CNN che rileva oggetti a 50-100m di distanza.

<!--
**Limitation**

Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly.
-->

**Limitazioni**

Negli anni 2000, le risorse di calcolo erano limitate. Il robot era in grado di elaborare circa 1 fotogramma (*frame*) al secondo, il che significa che non sarebbe stato in grado di rilevare una persona che lo incrociava per un intero secondo prima di essere in grado di reagire. La soluzione per questa limitazione è un modello **di odometria visiva a basso costo**. Non si basa su reti neurali, ha una visione di ~2,5m ma reagisce rapidamente.


<!--
### Scene Parsing and Labelling
-->

### Analisi ed etichettatura delle scene


<!--
In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6).
-->

In questa attività, il modello genera una categoria di oggetti (edifici, automobili, cielo, ecc.) per ogni pixel. L'architettura è anche multi-scala (Figura 6).


<!--
<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figura 6:</b> CNN multi-scala per l'analisi di scene
</center>

<!--
Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.

However, sometimes this context size is not enough to determine the category for larger objects.

-->

Si noti che se si proietta indietro un output della CNN sull'input, questo corrisponde a una finestra di input di dimensioni $46 \times 46$ sull'immagine originale nella parte inferiore della Piramide Laplaciana. Significa che **stiamo usando il contesto di $46 \times 46$ pixel per decidere la categoria del pixel centrale**.

Tuttavia, a volte questa dimensione del contesto non è sufficiente per determinare la categoria di oggetti più grandi.


<!--
**The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.
-->

**L'approccio multiscala consente una visione più ampia fornendo ulteriori immagini ridimensionate come input.** I passaggi sono i seguenti:

1. Prendi la stessa immagine, riducila di un fattore 2 e di un fattore 4, separatamente.
2. Queste due immagini extra che sono state ridimensionate vengono inviate alla stessa **ConvNet** (stessi pesi, stessi *kernel*) e otteniamo altri due set di caratteristiche (*features*) di Livello 2.
3. **Sovracampionamento** di queste caratteristiche in modo che abbiano le stesse dimensioni delle caratteristiche di livello 2 dell'immagine originale.
4. **Impila** le tre serie di caratteristiche (ricampionate) insieme e utilizzarle come input ad un classificatore.


<!--
Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$.
-->

Ora la più grande dimensione effettiva del contenuto, che deriva dall'immagine 1/4 ridimensionata, è $184 \times 184$, ($46 \times 4 = 184$).


<!--
**Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking.
-->

**Prestazioni**: senza post-elaborazione ed eseguendolo fotogramma per fotogramma (*frame-by-frame*), il modello funziona molto velocemente anche su *hardware* standard. Ha una dimensione piuttosto piccola di dati di allenamento (2k~3k), ma i risultati sono ancora da record.
