---
lang: it
lang-ref: ch.03
title: Settimana 3
translation-date: 30 Mar 2020
translator: Marco Zullich
---


## Lezione parte A

Prima di tutto, diamo un'occhiata alla visualizzione di una rete neurale composta da 6 strati. Dopodiché, discutiamo di convoluzioni e reti neurali convoluzionali (CNN). Rivediamo numerose varianti di trasformazione dei parametri nel contesto delle CNN e introduciamo l'idea di filtro (_kernel_), che viene utilizzato per imparare caratteristiche in maniera gerarchica, permettendoci dunque di classificare i nostri dati di input, il che è l'idea di fondo che motiva l'utilizzo delle CNN.

<!-- We first see a visualization of a 6-layer neural network. Next we begin with the topic of Convolutions and Convolution Neural Networks (CNN). We review several types of parameter transformations in the context of CNNs and introduce the idea of a kernel, which is used to learn features in a hierarchical manner. Thereby allowing us to classify our input data which is the basic idea motivating the use of CNNs. -->


## Lezione parte B

Diamo un'introduzione su come le CNN si sono evolute nel tempo. Discutiamo in dettaglio diverse architetture delle CNN, compresa una interpretazione moderna di LeNet5 come esempio della risoluzione del compito di riconoscimento di cifre dal dataset MNIST. Basandoci sui principi di design, approfondiamo i vantaggi delle CNN, permettendoci di utilizzare le caratteristiche di composizionalità, stazionarietà e localizzazione delle immagini naturali.

<!-- We give an introduction on how CNNs have evolved over time. We discuss in detail different CNN architectures, including a modern implementation of LeNet5 to exemplify the task of digit recognition on the MNIST dataset. Based on its design principles, we expand on the advantages of CNNs which allows us to exploit the compositionality, stationarity, and locality features of natural images. -->


## Pratica

Sono discusse nel dettaglio quelle proprietà dei segnali naturali che sono più pertinenti per le CNN, ovvero: localizzazione, stazionarietà e composizionalità. Esploriamo precisamente come un filtro utilizza queste proprietà attraverso la sparsità, la condivisione dei pesi e le pile di strati, motivando anche i concetti di *padding* e *pooling*. Infine, paragoniamo le performance fra FCN e CNN per diverse *data modality*.

<!-- Properties of natural signals that are most relevant to CNNs are discussed in more detail, namely: Locality, Stationarity, and Compositionality. We explore precisely how a kernel exploits these features through sparsity, weight sharing and the stacking of layers, as well as motivate the concepts of padding and pooling. Finally, a performance comparison between FCN and CNN was done for different data modalities. -->
