---
lang: it
lang-ref: ch.03-3
title: Proprietà dei segnali naturali
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
translation-date: 16 Apr 2020
translator: Francesca Guiso
---

## [Proprietà dei segnali naturali](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)
Ogni segnale si può rappresentare con un vettore. Ad esempio, un segnale audio è un vettore unidimensionale, $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$, dove ciascuna componente rappresenta l'ampiezza della forma d'onda al tempo $t$. Prendiamo ad esempio il sistema uditivo umano. Per comprendere una persona mentre parla, la coclea converte la pressione d'aria delle vibrazioni sonore in impulsi nervosi, i quali vengono covertiti in linguaggio dal cervello tramite un modello linguistico in modo da selezionare l'enunciato più probabile dato il segnale. Per i segnali musicali, i segnali sono cosidetti stereofonici e hanno 2 o più canali (_channels_) in modo da creare l'illusione che il suono arrivi da più direzioni. Sebbene abbiano due canali, i segnali musicali sono comunque 1D perché lo stato del segnale è determinata solo da una sola variabile, il tempo.

<!-- ## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language i.e. it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing. -->

Le immagini sono segnali 2D, perché l'informazione è raffigurata nello spazio bidimensionale. Ogni punto in questo spazio può essere a sua volta rappresentato con un vettore. Se abbiamo un'immagine con $d$ canali, ogni punto dell'immagine corrisponde ad un vettore di dimensione $d$. Una immagine a colori ha 3 canali RGB (_RGB: Red, Green, Blue_), quindi $d=3$. Per ciascun punto $x_{i,j}$, le componenti di questo vettore corrispondono all'intensità dei colori rosso, verde e blu.

Seguendo la stessa logica, si può rappresentare anche il linguaggio. Ogni parola corrisponde ad un vettore di componenti binarie (_one-hot_), che hanno valore uguale ad 1 in corrispondenza con la posizione in cui avviene la parola all'interno del nostro vocabolario, e valore uguale a 0 in tutte le altre posizioni. Dunque ogni parola è un vettore di dimensione uguale alla lunghezza del vocabolario.

<!-- An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.

We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.-->

I segnali naturali hanno le seguenti proprietà:
1. **Stazionarietà:** Alcuni motivi sono ripetuti attraverso il segnale. Nei segnali audio, possiamo osservare gli stessi schemi (_pattern_) ripetutamente lungo l'asse temporale. Nelle immagini, possiamo osservare _pattern_ visivi simili in diverse posizioni nello spazio dell'immagine.
<!-- Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.-->
2. **Localizzazione:** I punti adiacenti hanno una maggiore correlazione fra di loro rispetto ai punti distanti l'uno dall'altro. Per un segnale 1D, ciò significa che osservando un picco ad un qualsiasi punto $t_i$, i punti che si trovano entro una piccola finestra da $t_i$ avranno molto probabilmente un valore simile al valore corrispondente a $t_i$, mentre per un punto $t_j$ che è lontano da $t_i$, $x_{t_i}$ sarà meno correlato con $x_{t_j}$. Più formalmente, la convoluzione tra un segnale e la sua versione rovesciata, raggiungono un picco quando il segnale si sovrappone perfettamente con la sua versione rovesciata. Una convoluzione fra due segnali 1D (o la loro correlazione incrociata) non è altro il loro prodotto scalare, che è una misura della similitudine fra due vettori, ovvero quanto sono distanti fra di loro. Quindi, l'informazione è contenuta in zone specifiche del segnale. Per le immagini, ciò vuol dire che la correlazione fra due punti diminuisce con l'aumentare della distanza fra di loro. Se il pixel $x_{0,0}$ è blu, la probabilità che il pixel accanto ($x_{1,0},x_{0,1}$) sia blu è piuttosto alta, ma se ci spostiamo verso il lato opposto dell'immagine, ($x_{-1,-1}$), il valore di questo pixel è indipendente del valore del pixel $x_{0,0}$.

<!-- 2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.-->

3. **Composizionalità:** In natura, tutto è composto da parti, a loro volta composte di sottoinsiemi di parti, etc. Per esempio, i caratteri formano delle sequenze, che formano parole, che a loro volta formano frasi. Un insieme di frasi forma un testo (_document_). La composizionalità è ciò che ci permette di spiegare il mondo.

Se i nostri dati esibiscono queste proprietà di stazionarietà, localizzazione, e composizionalità, possiamo sfruttarle con reti che utilizzano sparsità, condivisione dei pesi e l'accatastamento di strati.
<!--
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.

If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.-->

## [Sfruttare le proprietà dei segnali naturali per ottenere invarianza ed equivarianza](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
<!-- ## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
<!-- ## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)-->

### Localizzazione $\Rightarrow$ sparsità
La Fig. 1 mostra una rete _FC_ a 5 strati. Ogni freccia rappresenta un peso che viene moltiplicato con un input. Come possiamo vedere, questa rete è molto pesante dal punto di vista computazionale.

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Fig. 1:</b> rete FC (_Fully Connected_)</center>

<!--
### Locality  $\Rightarrow$ sparsity

Fig. 1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1:</b> fully Connected Network</center>
-->

Se i nostri dati hanno la proprietà di localizzazione, possiamo connettere ciascun neurone ad un sottoinsieme "locale" di neuroni dello strato precedente. Quindi possiamo ignorare alcune connessioni come raffigurato nella Fig. 2. La Fig. 2(a) rappresenta una rete FC. Sfruttando la localizzazione dei dati, escludiamo le connessioni con i neuroni più distanti, come da Fig. 2(b). Seppure i neuroni dello strato nascosto (in verde) nella  Fig. 2(b) non ricoprono completamente l'input, nell'insieme l'architettura considera ciascun neurone. Il campo recettivo (RF: _receptive field_) di uno strato è il numero di neuroni provenienti da uno strato precedente che vengono considerati dallo strato in questione. Dunque, il RF dell'output rispetto allo strato nascosto è di 3, il RF dello strato nascosto rispetto all'input è di 3, mentre il RF dell'output rispetto all'input è di 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> prima della sparsificazione | <b>Figure 2(b):</b> dopo la sparsificazione |

<!--If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig. 2. Fig. 2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig. 2(b). Although the hidden layer neurons (green) in Fig. 2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> before Applying Sparsity | <b>Figure 2(b):</b> after Applying Sparsity|
-->

### Stazionarietà $\Rightarrow$ condivisione dei pesi
<!-- ### Stationarity $\Rightarrow$ parameters sharing-->

Se i nostri dati hanno stazionarietà, possiamo riutilizzare un sottoinsieme di pesi/parametri più volte attraverso l'architettura della rete. Per esempio, nella rete sparsa di Fig. 3(a), possiamo condividere 3 pesi (giallo, arancione, e rosso). Di conseguenza, il numero di pesi diminuisce da 9 a 3! La nuova architettura può funzionare anche meglio perché i singoli pesi vengono addestrati su un maggior numero di dati. I pesi ottenuti con la sparsità e la condivisione dei pesi formano un filtro convoluzionale.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Fig. 3(a):</b> senza condivisione dei pesi | <b>Fig. 3(b):</b> con condivisione dei pesi |

<!-- If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig. 3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> before Applying Parameter Sharing | <b>Figure 3(b):</b> after Applying Parameter Sharing|
-->

I seguenti sono alcuni vantaggi dell'utilizzo della sparsità e della condivisione dei pesi:
* Condivisione dei pesi
  * convergenza più rapida
  * miglior generalizzazione
  * nessun vincolo sulla dimensione dell'input
  * indipendenza dei filtri $\Rightarrow$ alta capacità di parallelizzazione
* Sparsità delle connessioni
  * riduzione della computazione

<!-- Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation
-->

La Fig. 4 mostra un esempio di filtro su dati 1D, dove la dimensione del filtro è: 2 (numero di filtri) * 7 (spessore dello strato precedente) * 3 (numero di pesi distinti).

La scelta della dimensione del filtro è empirica. I filtri convoluzionali 3 * 3 sembrano essere la dimensione minima per dati 2D. Una convoluzione di dimensione 1 può essere utilizzata per ottenere uno strato finale che può essere applicato ad una immagine input più grande. Se la dimensione del filtro è un numero pari potrebbe diminuire la qualità dei dati, quindi scegliamo sempre un kernel di dimensione dispari, generalmente 3 o 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figura_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figura_4b_zero_padding.png" width="350"/>|
|<b>Fig. 4(a):</b> filtro su dati 1D | <b>Fig. 4(b):</b> dati con _padding_ di zeri |
-->
<!-- Fig. 4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).

The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figura_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figura_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> kernels on 1D Data | <b>Figure 4(b):</b> data with Zero Padding|
-->

### _Padding_
Il _padding_ ("imbottitura") tende a inficiare i risultati finali, ma è conveniente per la programmazione. Generalmente utilizziamo _padding_ di zeri: `size =  (kernel size - 1)/2`.
<!-- ### Padding

Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.-->

### CNN "spaziale" standard
Le CNN spaziali (nel senso che i dati hanno una relazione spaziale fra di loro) hanno le seguenti proprietà:

* Più di uno strato:
  * Convoluzione
  * Funzione nonlineare (ReLU e "_Leaky-ReLU_")
  * Operazione di _pooling_
  * Normalizzazione del _batch_
* _Bypass_ della connessione residua

<!--
### Standard spatial CNN

A standard spatial CNN has the following properties:

* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection
-->

La normalizzazione del batch e il _bypass_ connessione residua sono molto utili per l'addestramento della rete. Se la rete è composta da troppi strati, alcune parti del segnale si possono perdere. Il _bypass_ delle connessioni residue aggiungono ulteriori connessioni e garantiscono che ci sia un percorso attraverso la rete dal basso verso l'alto, nonché un percorso dall'alto verso il basso per i gradienti durante la retropropagazione.

Nella Fig. 5, vediamo che l'immagine di input contiene informazione principalmente nello spazio bidimensionale (a parte l'informazione caratteristica sul colore di ciascun pixel), mentre lo strato di output è spesso. Al centro, avviene uno scambio fra l'informazione spaziale e l'informazione caratteristica e la rappresentazione diventa più densa. Salendo nella gerarchia, otteniamo rappresentazioni sempre più dense e perdiamo l'informazione spaziale.

<!-- Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.

In Fig. 5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5:</b> information Representations Moving up the Hierarchy</center>
-->

### [_Pooling_](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Fig. 6:</b> raffigurazione dell'operazione di _pooling_</center>

La norma $L_p$ viene calcolata su diverse regioni (come da Fig. 6). Questa operazione produce un valore per ciascuna regione (1 valore per 4 pixel nel nostro esempio). Procediamo con l'iterazione di questo processo regione per regione sull'intero dataset, spostando la regione a seconda del passo (_stride_) che abbiamo definito. Se i nostri dati hanno dimensione $m * n$ con $c$ canali, arriveremo ad un output con $\frac{m}{2} * \frac{n}{2}$, sempre con $c$ canali (come da Fig. 7).
Il _pooling_ non è regolato da un parametro nel nostro modello; tuttavia, possiamo scegliere diversi tipi di _pooling_ come _max-pooling_, _pooling_ della media (_average pooling_) etc. L'obiettivo principale del _pooling_ è la riduzione del numero di dati, il che ci permette di compiere operazioni entro un tempo ragionevole.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Fig. 7:</b> risultato dell'operazione di _pooling_ </center>

<!--### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6:</b> illustration of Pooling</center>

A specific operator, $L_p$-norm, is applied to different regions (refer to Fig. 6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig. 7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7:</b> pooling results </center>

-->

## CNN: Jupyter Notebook
Il Jupyter notebook si trova [qui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). Per eseguire il notebook, assicuratevi di aver installato ed attivato l'ambiente `pDL` come descritto nel [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

In questo notebook, addestreremo un percettrone multi-strato FC, ed ua rete neurale convoluzionale (CNN) per la classificazione sul dataset MNIST. Si noti che le reti hanno lo stesso numero di parametri. (Fig. 8)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Fig. 8:</b> istanze del dataset MNIST originale </center>

Prima dell'addestramento, normalizziamo i nostri dati, così che l'inizializzazione della nostra rete corrisponda alla distribuzione dei dati (molto importante!). Inoltre, assicuratevi di aver compiuto le seguenti operazioni/passi nella fase di addestramento:

 1. Introdurre i dati al modello
 2. Calcolare l'errore
 3. Svuotare la _cache_ dei gradienti accumulati, utilizzando `zero_grad()`
 4. Calcolare i gradienti
 5. Operare un passo del metodo di ottimizzazione

<!--## CNN - Jupyter Notebook

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig. 8)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8:</b> instances from the Original MNIST Dataset </center>

Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:

 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method
-->

Prima di tutto, addestreremo entrambe le reti sui dati MNIST normalizzati. L'accuratezza della rete FC è $87\%$, mentre l'accuratezza della CNN è $95\%$. Dato lo stesso numero di parametri, la CNN è riuscita ad addestrare molti più filtri. Nella rete FC tutti quei filtri che provano a rappresentare relazioni fra pixel distanti fra di loro vengono addestrati invano, sono quindi sprecati. Invece, nella rete convoluzionale, tutti questi parametri si concentrano sul rilevare le relazioni fra pixels vicinanti.

<!--First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.
-->

Dopodiché, eseguiamo una permutazione casuale di tutti i pixel nelle immagini del nostro dataset MNIST. Ciò trasforma i dati dalla raffigurazione in Fig. 8 a quella di Fig. 9. Poi addestriamo entrambe le reti su questo dataset modificato.
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Fig. 9:</b> istanze del dataset MNIST permutato </center>

L'accuratezza della rete FC è rimasta più o meno uguale ($85\%$), mentre quella della CNN è scesa a $83\%$. Questo perché la permutazione casuale dei dati ha eliminato le tre proprietà di localizzazione, stazionarietà, e composizionalità, che le CNN possono sfruttare al meglio.

<!--Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig. 8 to Fig. 9. We then train both the networks on this modified dataset.
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9:</b> instances from Permuted MNIST Dataset</center>

The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->
