---
lang: it
lang-ref: ch.03-2
lecturer: Yann LeCun
title: Evoluzione, architetture, implementazione dettagliata e vantaggi delle CNN
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translation-date: 6 Apr 2020
translator: Francesca Guiso
---

## [Evoluzione delle CNN da prototipo alle CNN moderne](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


### Prototipo di reti neurali convoluzionali su piccoli dataset
<!-- ### Proto-convolutional neural nets on small data sets -->

Prendendo ispirazione dal lavoro di Fukushima sui modelli della corteccia visiva, Yann LeCun sviluppò la prima rete neurale convoluzionale (CNN) all'Università di Toronto nel '88-'89, utilizzando una gerarchia di cellule semplici/complesse insieme all'addestramento supervisionato e la retropropagazione. Gli esperimenti utilizzarono un piccolo dataset di 320 cifre. La performance delle seguenti architetture furono messe a confronto:

<!-- Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared: -->

1. Strato unico totalmente connesso (FC: _fully connected_)
2. Due strati FC
3. Strati connessi localmente senza pesi condivisi
4. Rete vincolata con pesi condivisi e connessioni localizzate
5. Rete vincolata con pesi condivisi e connessioni localizzate (con più mappe delle caratteristiche, o _feature maps_)

<!-- 1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps) -->

Le reti con maggiore successo (reti vincolate con pesi condivisi) avevano una maggiore capacità di generalizazione, e formarono la base per le CNN moderne. Il modello con un unico strato FC, invece, tende a sovradattare (_overfitting_).

<!-- The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit. -->


### Le prime "vere" CNN a Bell Labs
<!--### First "real" ConvNets at Bell Labs-->

Dopo essersi spostato a Bell Labs, la ricerca di LeCun passò all'utilizzo di codici postali scritti a mano dal servizio postale statunitense per l'addestramento di una CNN più grande:


+ 257 (16$\times $16) strati di input
+ 12 filtri (5$\times $5) con passo (*stride*) di 2 (avanzamento di 2 pixel): il prossimo strato avrà una risoluzione inferiore
+ **SENZA** operazione di _pooling_

<!-- After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:
+ 256 (16$\times$16) input layer
+ 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
+ **NO** separate pooling
-->


### Architettura di reti convoluzionali con _pooling_
<!-- ### Convolutional network architecture with pooling -->

L'anno successivo, si fecero alcuni cambiamenti: venne introdotto uno strato di _pooling_ separato. Lo strato di _pooling_ calcola la media dei valori dell'input, aggiungendo un termine costante (_bias_), e passandola ad una funzione non lineare (funzione tangente iperbolica). Venne applicato uno strato di _pooling_ di dimensione $2\times2$ e passo di 2, dimezzando cosí le risoluzioni.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1 </b> Architettura di una rete convoluzionale
</center>

<!-- The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half.
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> ConvNet Architecture
</center> -->


Il seguente è un esempio di una rete con un solo strato convoluzionale:
1. Si consideri un input di dimensione *32*$\times$*32*
2. Lo strato convoluzionale passa un filtro di dimensione *5*$\times$*5* con passo di 1 sull'immagine, creando una mappa delle caratteristiche di dimensione *28*$\times$*28*
3. Si passa la mappa delle caratteristiche ad una funzione non lineare: dimensione *28*$\times$*28*
4. Si passa ad uno strato di _pooling_, che calcola la media su una finestra di dimensione *2*$\times$*2* con passo 2: dimensione *14*$\times$*14*
5. Si ripetono 1-4 per ciascuno dei 4 filtri


<!-- An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels
-->

Generalmente il primo strato, fatto di semplici combinazioni di convoluzioni/_pooling_, riconosci caratteristiche semplici, come bordi orientati. Dopo il primo strato di convoluzioni/_pooling_, l'obiettivo è riconoscere combinazioni di caratteristiche dagli strati precedenti. Per ottenere questo si ripetono i punti 2-4, passando diversi filtri sulle mappe delle caratteristiche degli strati precedenti, che vengono poi sommati per formare una nuova mappa delle caratteristiche:
<!-- The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map: -->

1. Si passa un nuovo filtro *5*$\times$*5* su ciascuna mappa delle caratteristiche dagli strati precedenti e si sommano i risultati (nota: nell'esperimento del 1989 del prof. LeCun, si omettono alcuni strati per motivi computazionali. Le configurazioni moderne generalmente impongono che la rete sia completamente connessa): dimensione *10*$\times$*10*
2. Si passa il risultato dello strato convoluzionale ad una funzione non lineare: dimensione *10*$\times$*10*.
3. Si ripetono 1-2 per ciascuno dei 16 filtri.
4. Si passa il risultato ad uno strato di _pooling_, che calcola la media su una finestra di dimensione *2*$\times$*2* con passo 2: dimensione *5*$\times$*5* per ogni mappa delle caratteristiche.


<!-- 1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map -->

Per generare un output, l'ultimo strato convoluzionale somiglia ad una connessione completa (FC):


<!-- To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional.-->

1. L'ultimo strato convoluzionale passa un filtro *5*$\times$*5* sopra l'intera mappa delle caratteristiche, le quali vengono sommate, risultando in una matrice di dimensione *1*$\times$*1*
2. Si passa il risultato ad una funzione non lineare: dimensione *1*$\times$*1*.
3. Si genera un singolo output per la categoria in questione.
4. Si ripetono i passi precedenti per ciascuna delle 10 cateogrie (in parallelo).


<!-- 1. The final convolution layer slides a *5*$\times$*5* kernel over all feature maps, with results summed up: size *1*$\times$*1*
2. Pass through nonlinear function: size *1*$\times$*1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel)-->

Si veda [Questa animiazione](http://cs231n.github.io/convolutional-networks/) sul sito di Anrej Karpathy su come le convoluzioni cambiano la dimensione della mappa delle caratteristiche dello strato successivo. L'articolo completo è disponibile [qui](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).
<!-- See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).-->


### Equivarianza rispetto alla traslazione
<!-- ### Shift equivariance-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2 </b> Equivarianza rispetto alla traslazione
</center>

Come dimostrato dall'animazione sulle slide (questo è un'altro esempio), la translazione dell'input risulta nella stessa traslazione della mappa delle caratteristiche. Tuttavia, le variazioni nella mappa delle caratteristiche vengono dilatate o contratte rispetto alle operazioni di convoluzione/_pooling_. Per esempio, se si ha uno strato di _pooling_ 2$\times$2 e passo 2, una traslazione di 1 pixel dell'input risulta in una traslazione di 0.5 pixel delle mappe delle caratteristiche successive. La risoluzione viene quindi "scambiata" per avere un maggior numero di tipi di caratteristiche, ovvero per rendere la rappresentazione più astratta e meno sensibile a traslazioni e distorsioni.

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Shift Equivariance
</center>
As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. E.g. the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, i.e. making the representation more abstract and less sensitive to shifts and distortions.-->

### Struttura generale dell'architettura
<!--### Overall architecture breakdown-->
La struttura generale dell'architettura delle CNN si può suddividere in vari strati archetipo:
<!--Generic CNN architecture can be broken down into several basic layer archetypes:-->

* **Normalizzazione**
  * Aggiustamento dello _whitening_ (facoltativo)
  * Metodi sottrattivi, ad esempio sottrazione della media, filtro passa-alto
  * Metodi divisivi: normalizzazione del contrasto locale, normalizzazione della varianza

* **Filter Banks**
  * Aumento della dimensione
  * Proiezione su una base completa
  * riconoscizione bordi

* **Funzioni non lineari**
  * Dispersione
  * Tipicamente si utilizza un rettificatore, o unità lineare rettificata (_ReLU: Rectified Linear Unit_): $\text{ReLU}(x) = \max(x, 0)$

* **_Pooling_**
  * Raggruppamento su una mappa delle caratteristiche
  * _Max Pooling_: $\text{MAX}= \text{Max}_i(X_i)$

  * _Pooling_ con norma-LP:  $\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$

  * _Pooling_ con probabilità su scala logaritmica: $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$

<!-- * **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods e.g. average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation
-->

<!--* **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections
-->

<!--* **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$
-->
<!--* **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$
 -->
<!--* LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$
-->

<!--* Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$
-->

## [LeNet5 e il riconoscimento delle cifre](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)
<!-- ## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s) -->

### Implementazione di LeNet5 con PyTorch
<!-- ### Implementation of LeNet5 in PyTorch -->
LeNet5 consiste dei seguenti strati (elecanti dall'alto al basso):

1. _Log-softmax_
2. Strato FC di dimensione 500$\times$10
3. _ReLU_
4. Strato FC di dimensione 4$\times$4$\times$50)$\times$500
5. _Max Pooling_ di dimensione 2$\times$2, passo di 2.
6. _ReLu_
7. Convoluzione con 20 canali output, filtro 5$\times$5 e passo di 1.
8. _Max Pooling_ di dimensione 2$\times$2, stride di 2.
9. _ReLu_
10. Convoluzione con 20 canali output, filtro 5$\times$5, passo di 1.


<!-- LeNet5 consists of the following layers (1 being the top-most layer):
1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
-->

LeNet5 si può implementare con Pytorch con il seguente codice:
<!-- LeNet5 can be implemented in PyTorch with the following code: -->

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
    x = F.relu(self.conv1(x))
    x = F.max_pool2d(x, 2, 2)
    x = F.relu(self.conv2(x))
    x = F.max_pool2d(x, 2, 2)
    x = x.view(-1, 4*4*50)
    x = F.relu(self.fc1)
    x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

Anche se `fc1` e `fc2` sono strati completamente connessi (FC), si possono consdierare come strati convoluzionali con filtri che ricoprono l'intero input. Gli strati FC vengono utilzizati per motivi di efficenza.

Lo stesso codice si può scrivere utilizzando `nn.Sequential`, ma questo metodo è obsoleto.
<!-- Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes.
The same code can be expressed using `nn.Sequential`, but it is outdated. -->

## Vantaggi delle CNN
<!-- ## Advantages of CNN-->

In una rete completamente convoluzionale, non vi è bisogno di specificare le dimensioni dell'input. Tuttavia, cambiare la dimensione dell'input cambia la dimensione dell'output.

Si consideri un sistema di riconoscimento di testo scritto a mano in cosrivo. Non è necessario segmentare l'immagine input. Basta utilizzare una CNN sull'immagine intera: i filtri copriranno ogni posizione sul'immagine intera e produrranno lo stesso output indipendentemente dalla posizione in cui è stato riconoscito lo schema (_pattern_). Applicare la CNN ad un'immagine intera è molto meno costoso che applicarla su diverse posizioni separatamente. Non è necessaria una segmentazione iniziale, il che è un sollievo perché la segmentazione di un'immagine è simile al riconosimento di un immagine.

<!--In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output.
Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image.-->


### Esempio: MNIST

La LeNet5 è stata addestrata su immagini 32$\times$32 di MNIST per classificare cifre individuali al centro di un'immagine. Si utilizzò una technica di aumento dei dati (*data augmentation*), spostando le cifre, cambiando la dimensione delle cifre, ed inserendo altre cifre a fianco. Fu anche addestrato utilizzando un'undicesima categoria, per rappresentare cifre che non corrispondevano alle 10 cifre precedenti. Le immagini etichettate (_labeled_) da questa categorie erano generate producendo immagini vuote, oppure collocando le cifre ai lati invece che al centro dell'immagine.

<!--### Example: MNIST
LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre. -->

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Sliding Window ConvNet
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Finestra Scorrevole di una CNN
</center>

 L'immagine qui sopra dimostra che una rete LeNet5 addestrata su immagini 32$\times$32 può essere utilizzata su un'immagine input 32$\times$64 per riconoscere cifre in diverse posizioni.
<!--The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations.-->


<!--## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)-->
## [Problema della combinazione delle caratteristiche](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

### Che cos'è il problema della combinazione delle caratteristiche?
<!--### What is the feature binding problem?-->

I neuroscienziati visivi e gli esperti di visione artificiale affrontano il problema di definire un oggetto come tale. Un oggetto è una collezione di caratteristiche, ma come si possono combinare tutte le caratteristiche per costruire l'oggetto in questione?
<!--Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object?-->


### Come si risolve?
<!--### How to solve it?-->

Possiamo risolvere il problema della combinazione delle caratteristiche utilizzando una semplice CNN: bastano solo due strati convoluzionali con _pooling_ e altri due strati FC senza meccanismi specifici, ponendo che si abbiamo abbastanza funzioni non lineari e dati per addestrare la rete.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> CNN per risolvere il problema dell'unione delle caratteristiche
</center>

L'animazione qui sopra mostra la capacità delle CNN nel riconoscere le cifre tramite lo spostamento di un unico tratto, dimostrando come risolvono il problema della combinazione delle caratteristiche, riconoscendo le caratteristiche in maniera gerarchica e compositiva.

<!-- We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN.
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet Addressing Feature Binding
</center>
-->

<!-- The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, i.e. recognizing features in a hierarchical, compositional way.
-->


### Esempio: input di lunghezza dinamica
<!-- ### Example: dynamic input length-->

Possiamo costruire una CNN con due strati convoluzionali con passo 1 e due strati _pooling_ con passo 2 in modo che il passo totale sia 4. Cosí, per ottenere un nuovo output bisogna traslare la finestra di input di 4. Si può vedere ciò in maniera più esplicativa dalla figura seguente (unità verdi). Iniziamo con un input di dimensione 10, si realizza una convoluzione di dimensione 3 per ottenere 8 unità. Dopodiché, si realizza il _pooling_ di dimensione 2 per ottenere 4 unità. Come prima, si ripetono le operazioni di convoluzione e  _pooling_ fino ad ottenere 1 unità di output.


<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> Architettura CNN su unione di input con lunghezza variabile
</center>

<!-- We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output.
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding
</center>
-->

Assumiamo di aggiungere 4 unità allo strato input (unità rosa nella figura qui sopra) in modo da ottenere 4 unità in più dopo il primo strato convoluzionale, 2 unità in più dopo la prima operazione di _pooling_, 2 unità in più dopo il secondo strato convoluzionale e 1 unità in più nell'output. Di consequenza, la dimensione della finestra per generare un nuovo output dovrà essere 4 (passo di 2 $\times$2). Inoltre, questo indica che aumentando la dimensione dell'input si aumenta la dimensione di ciascuno strato, mostrando che le CNN riescono a gestire input con lunghezza dinamica.
<!-- Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2). Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs.-->

## A quale tipo di segnali si prestano le CNN?
<!--## What are CNN good for-->

Le CNN si prestano bene a segnali sottoforma di matrici multidimensionali con le seguenti proprietà:
<!--CNN are good for signals that come to you in the form of multidimensional arrays. These signals have three major characters.-->

1. **Localizzazione**: La prima (proprietà) è che esistono forti correlazioni "localizzate" fra i valori. Se prendiamo due pixel di un'immagine naturale, è molto probabile che questi due pixel avranno lo stesso colore. Con l'aumentare della distanza fra due pixel, la somiglianza fra di loro diminuirà. Queste correlazioni localizzate fra pixel ci permettono di riconoscere caratteristiche locali, che è ciò che fanno le CNN. Se diamo dei pixel permutati come input ad una CNN, questa non riconoscerebbe altrettanto bene l'immagine, mentre non ci sarebbero differenze con una rete FC. Le correlazioni localizzate giustificano l'utilizzo di connessioni localizzate.
<!-- 1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections. -->

2. **Stazionarietà**: La seconda proprietà è che le caratteristiche sono essenziali e possono apparire ovunque sull'immagine, giustificando l'utilizzo dei pesi condivisi e del _pooling_. Inoltre, i segnali statistici seguono una distribuzione uniforme, quindi bisogna ripetere il riconoscimento delle caratteristiche per ogni posizione sull'immagine input.
<!-- 2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image. -->
3. **Composizionalità**: La terza proprietà è che le immagini naturali sono compositive, quindi le caratteristiche formano un'immagine in maniera gerarchica. Questo giustifica l'utilizzo di più strati di neuroni, che oltretutto ricalca i risultati della ricerca di Hubel e Weisel sulle cellule semplici e complesse.
<!-- 3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells.-->

Inoltre, le CNN vengono usate su video, immagini, testi e riconoscimento vocale.
<!-- Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition.-->
