---
lang: it
lang-ref: ch.03-1
lecturer: Yann LeCun
title: Visualizzazione delle trasformazioni dei parametri delle reti neurali e concetto fondamentale di convoluzione
date: 10 Feb 2020
translation-date: 2 Apr 2020
translator: Marco Zullich
---

## [Visualizzazione di reti neurali](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

In questa sezione visualizzeremo il funzionamento interno di una rete neurale

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Struttura di una rete neurale</center>

La Fig. 1 mostra la struttura della rete neurale che vorremmo visualizzare. Normalmente, quando disegniamo la struttura di una rete neurale, l'input viene fatto comparire in basso oppure a sinistra e l'output in alto oppure a destra. Nella Fig. 1, i neuroni rosa rappresentano l'input e i blu rappresentano l'output. In questa rete, abbiamo 4 strati nascosti (in verde), il che significa che abbiamo 6 strati in totale (4 strati nascosti + 1 strato di input + 1 strato di output). In questo caso, abbiamo 2 neuroni per strato nascosto, quindi la dimensione della matrice dei pesi ($W$) per ogni strato è 2x2. Ciò perché vogliamo trasformare il nostro piano di input in un altro piano che vogliamo poter visualizzare.

<!-- ## [Visualization of neural networks](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

In this section we will visualise the inner workings of a neural network.

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Network Structure</center>

Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualizzazione del ripiegamento dello spazio</center>

Trasformare uno strato è come ripiegare il nostro piano in qualche specifica regione, come mostrato in Fig. 2. Questo ripiegamento è molto brusco, perché tutte le trasformazioni sono applicate nello strato 2D. In questo esperimento, notiamo che, se abbiamo solo 2 neuroni per strato nascosto, l'ottimizzazione sarà più lenta; l'ottimizzazione è più semplice se abbiamo più neuroni per strato nascosto. Ciò ci lascia con un'importante domanda da considerare: perché è più difficile addestrare la rete con meno neuroni negli strati nascosti? Dovresti ponderare tu stesso su questa domanda e ci ritorneremo sopra dopo la visualizzazione del $\texttt{ReLU}$.

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<!-- <center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualization of folding space</center>

The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|
-->

<center>Fig. 3 Visualizzazione dell'operatore ReLU</center>

Quando navighiamo attraverso la rete, uno strato nascosto alla volta, vediamo che all'interno di ogni strato effettuiamo delle trasformazioni affini seguite dall'applicazione dell'operazione nonlineare ReLU, che elimina ogni valore negativo. Nelle Figure 3(a) e (b), possiamo vedere una visualizzazione dell'operatore ReLU. Quest'ultimo ci aiuta ad effettuare trasformazioni nonlineari. Dopo varie applicazioni di trasformazioni affini seguite dall'operatore ReLU, siamo finalmente in grado di separare linearmente i dati, come possiamo vedere in Fig. 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualizzazione degli output</center>

Ciò ci fornisce delle intuizioni sul perché gli strati nascosti sono più difficili da addestrare. La nostra rete composta da 6 strati ha un neurone di *bias* per ogni strato nascosto; quindi, se uno di questi *bias* muove i punti al di fuori del quadrante in alto a destra, l'applicazione dell'operatore ReLU *appiattirà* questi punti a zero. Dopo di ciò, indipendentemente da come gli strati successivi trasformeranno i dati, i valori rimarranno sempre zero. Possiamo concepire una rete neurale che sia più facilmente addestrabile rendendola più *spessa*, ovvero aggiungendo più neuroni negli strati nascosti, oppure possiamo aggiungere più strati nascosti, o ancora una combinazione dei due. Attraverso questo corso esploreremo come determinare le migliori architetture delle reti per un dato problema, rimanete sul pezzo.

<!-- <center>Fig. 3 Visualization of ReLU operator</center>

When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualization of Outputs</center>

This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.-->

## [Trasformazioni dei parametri](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

Trasformare in maniera generica i parametri significa che il nostro vettore dei parametri $w$ è l'output di una funzione. Per mezzo di questa trasformazione, possiamo mappare lo spazio dei parametri originario in un altro spazio. In Fig. 5, $w$ è l'output di $H$ applicato al parametro $u$. $G(x,w)$ è una rete e $C(y, \bar y)$ è una funzione di costo. La formula della retropropagazione è anch'essa adattata come segue:

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

Queste formule sono applicate in forma matriciale. Si noti che la dimensione dei termini dev'essere coerente. Le dimensioni di $u$, $w$, $\frac{\partial H}{\partial u}^\top$, $\frac{\partial C}{\partial w}^\top$ sono, rispettivamente, $[N_u \times 1]$, $[N_w \times 1]$, $[N_u \times N_w]$, $[N_w \times 1]$; quindi, la dimensione della nostra formula di retropropagazione è coerente.

<!--## [Parameter transformations](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.-->

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 Forma generica delle trasformazioni dei parametri</center>


### Una semplice trasformazione dei parametri: la condivisione dei pesi

Condivisione dei pesi significa semplicemente che $H(u)$ replica un componente di $u$ in più componenti di $w$. $H(u)$ è come un ramo a **Y** per copiare $u_1$ in $w_1$ e $w_2$. Ciò è esprimibile come

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

Forziamo i parametri condivisi ad essere uguali, così che il gradiente nei confronti dei parametri condivisi sarà sommato nella retropropagazione. Per esempio, il gradiente della funzione di costo $C(y, \bar y)$ rispetto a $u_1$ sarà la somma gradiente della funzione di costo $C(y, \bar y)$ rispetto a $w_1$ e il gradiente della funzione di costo $C(y, \bar y)$ rispetto a $w_2$.

<!--
<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 General Form of Parameter Transformations</center>


### A simple parameter transformation: weight sharing

A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->
### *Hypernetwork*

Una *hypernetwork* è una rete nella quale i pesi di una rete sono l'output di un'altra rete. La Fig. 6 mostra il grafo computazionale di una *hypernetwork*. Qui la funzione $H$ è una rete con vettore dei parametri $u$ e input $x$. Il risultato di ciò è che i pesi di $G(x,w)$ sono configurati in maniera dinamica dalla rete $H(x,u)$. Nonostante questa sia un'idea datata, rimane molto potente.

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 *Hypernetwork*</center>

<!--
### Hypernetwork

A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 "Hypernetwork"</center>-->

### *Riconoscimento di pattern* in dati sequenziali

La condivisione dei pesi può essere applicata al *riconoscimento di pattern* (_pattern recognition_), ovvero all'operazione di trovare dei _pattern_ ricorrenti in dati sequenziali, come parole chiave in segnali vocali o spezzoni di testo. Un modo per ottenere ciò, come si può vedere in Fig. 7, è tramite l'utilizzo di una finestra scorrevole sui dati, la quale finestra *muove* la funzione di condivisione pesi per rilevare un particolare pattern (es. un suono particolare in un segnale vocale), e l'output viene passato ad una funzione di massimo.

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 *Riconoscimento di motivi* per dati sequenziali</center>

In questo esempio abbiamo 5 di tali funzioni. Come risultato di questa soluzione, sommiamo cinque gradienti e retropropaghiamo l'errore per aggiornare il parametro $w$. Quando implementiamo ciò in PyTorch, vogliamo prevenire l'implicita accumulazione di questi gradienti, quindi dobbiamo usare `zero_grad()` per inizializzare il gradiente.

<!--### Motif detection in sequential data

Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function.

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 Motif Detection for Sequential Data</center>

In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->

### *Riconoscimento di motivi* in immagini

Un'altra applicazione utile è il *riconoscimento di motivi* nelle immagini. Normalmente, facciamo passare una "sagoma" sopra le immagini per riconoscere delle forme indipendentemente dalla posizione e dalla distorsione delle forme. Un semplice esempio è dato dal distinguere fra le lettere "C" e "D", come da Fig. 8. La differenza fra "C" e "D" è che la "C" ha due estremità, mentre la "D" ha due angoli; in questo modo, possiamo progettare "sagome" per le estremità e sagome per gli angoli. Se la forma è simile a quella delle sagome, darà degli output limitati.  Possiamo quindi distinguere le due lettere da tali output sommando questi ultimi. Nella Fig. 8, la rete riconosce due estremità a zero angoli, di conseguenza attiva "C".

È anche importante che il nostro "rilevatore di sagome" sia invariante rispetto alle traslazioni - quando trasliamo l'input, l'output (es. le lettere rilevate) non dovrebbe cambiare. Ciò può essere risolto con la condivisione dei pesi. Come da Fig. 9, quando cambiamo la posizione della "D", possiamo ancora riconoscere i motivi degli angoli nonostante siano stati traslati. Quando sommiamo i motivi, si attiverà il riconoscimento della "D".
<!--
### Motif detection in images

The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 Motif Detection for Images</center>
-->
<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Invarianza rispetto alle traslazioni</center>

Questo metodo "artigianale" che utilizza rilevatori locali e somme per il riconoscimento delle cifre è stato utilizzato per molti anni. Ma ci pone il seguente problema: come possiamo progettare queste "sagome" automaticamente? Possiamo usare reti neurali per apprenderle? Adesso, presenteremo il concetto di **convoluzione**, cioè, l'operazione che utilizziamo per confrontare immagini con "sagome".

<!--
It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Shift Invariance</center>

This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
-->

## Convoluzione discreta

### Convoluzione

La definizione matematica precisa di convoluzione fra l'input $x$ e $w$ nel caso unidimensionale è:

$$y_i = \sum_j w_j x_{i-j}$$

A parole, l'output $i$-esimo è calcolato come il prodotto vettoriale fra $w$ **rovesciato** e una finestra di $x$ della stessa dimensione di $w$. Per ottenere l'output completo, facciamo partire la finestra dall'inizio di $x$, la trasliamo di 1 unità per ogni componente di $x$ e continuiamo finché non vi sono più termini rimasti.

### Correlazione incrociata

In pratica, la convenzione adottata nelle strutture di apprendimento profondo come PyTorch è leggermente diversa. La convoluzione in PyTorch è implementata così che $w$ **non sia rovesciato**:

$$y_i = \sum_j w_j x_{i+j}$$

I matematici chiamano questa formulazione "correlazione incrociata" (*cross-correlation*). Nel nostro contesto, questa differenza è solamente una divergenza a livello di convenzioni. In pratica, la correlazione incrociata e la convoluzione possono essere intercambiabili se la lettura dei pesi conservati nella memoria avviene in maniera sequenziale in avanti oppure indietro.

Essere al corrente di questa differenza è importante, per esempio, quando si vuole fare uso di certe proprietà matematiche delle convoluzioni/correlazioni da testi matematici.

### Convoluzione in più dimensioni

Per input bidimensionali come le immagini, facciamo uso della versione in due dimensioni della convoluzione:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

Questa definizione può essere estesa senza problemi a tre o quattro dimensioni. Qui $w$ prende il nome di *filtro convoluzionale* (_convolution kernel_).

<!--
## Discrete convolution


### Convolution

The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:

$$y_i = \sum_j w_j x_{i-j}$$

In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.


### Cross-correlation

In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:

$$y_i = \sum_j w_j x_{i+j}$$

Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.

Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.


### Higher dimensional convolution

For two dimensional inputs such as images, we make use of the two dimensional version of convolution:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->

### Modifiche classiche che possono essere effettuate con l'operazione di convoluzione nelle DCNN

1. **Passo** (*stride*): anziché traslare la finestra in $x$ di una componente alla volta, si può traslarla con un passo maggiore (ad esempio, due o tre componenti alla volta).
Esempio: supponiamo che l'input $x$ sia monodimensionale e abbiamo una lunghezza di 100 e che $w$ abbia una lunghezza di 5. La lunghezza di output con un passo di 1 o 2 è mostrata nella tabella qui sotto:

| Passo             | 1                          | 2                          |
| ----------------- | -------------------------- | -------------------------- |
| Lunghezza output: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |

2. **_Padding_** ("imbottitura"): spesso, nel progettare architetture per reti neurali profonde, vogliamo che l'output di una convoluzione sia della stessa dimensione dell'input. Ciò può essere ottenuto "imbottendo" l'input nelle sue estremità con un certo numero di (usualmente) zeri, usualmente in entrambi i lati. Il *padding* è usato principalmente per comodità. A volte può impattare le performance e risultare in strani effetti ai bordi; detto ciò, quando si utilizza una nonlinearità del tipo ReLU, il *padding* con zeri non è una scelta irragionevole.

<!--

### Regular twists that can be made with the convolutional operator in DCNNs

1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:

| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |


2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.


-->

## Reti neurali convoluzionali profonde (DCNN)

Come detto in precedenza, le reti neurali profonde sono normalmente organizzate in ripetizioni alternate di operatori lineari e strati nonlineari a valori puntuali. Nelle reti neurali convoluzionali, l'operatore lineare sarà la convoluzione descritta sopra. C'è anche un terzo tipo di strato, chiamato strato di *pooling*.

Il motivo per far susseguire più strati di questo tipo è che vogliamo costruire una rappresentazione gerarchica dei dati. Le CNN non devono necessariamente essere limitate al processamento d'immagini, sono anche state applicate con successo a segnali vocali e testi. Tecnicamente possono essere applicate a qualsiasi tipo di dato codificato come vettore, anche se vogliamo che questi vettori rispettino determinate proprietà.

Perché vogliamo catturare una rappresentazione gerarchica del mondo? Perché il mondo in cui viviamo è composizionale. Questo punto era già stato introdotto nelle sezioni precedenti. Una natura gerarchica di questo tipo piò essere intuita dal fatto che i pixel locali si assemblano a formare semplici motivi come bordi orientati. Questi bordi sono a loro volta combinati a formare motivi che sono ancora più astratti. Possiamo continuare a costruire al di sopra di queste rappresentazioni gerarchiche finché arriviamo a formare gli oggetti che osserviamo nel mondo reale.

<!--
## Deep Convolution Neural Networks (DCNNs)

As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.

The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.

Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.

-->
<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Fig. 10 Visualizzazione delle caratteristiche di una rete neurale convoluzionale addestrata su ImageNet, da [Zeiler & Fergus 2013]</center>

Questa natura composizionale e gerarchica che osserviamo nel mondo naturale non è quindi solo il risultato della nostra percezione visiva, ma è anche vero in un piano fisico. Al livello più basso della descrizione abbiamo le particelle elementari, che si compongono a formare gli atomi, più atomi formano le molecole, e continuiamo ad accrescere questo processo fino a formare materiali, parti di oggetti e infine oggetti completi nel mondo fisico.

La natura composizionale del mondo potrebbe essere la risposta alla domanda retorica di Einstein riguardo a come gli umani comprendono il mondo in cui vivono:

> La cosa più incomprensibile dell'Universo è che esso sia comprensibile.

Il fatto che gli umani comprendano il mondo grazie a questa natura composizionale sembra ancora una specie di cospirazione per Yann. Invece, è dibattuto il fatto che, senza composizionalità, servirebbe qualcosa di ancora più magico agli umani per comprendere il mondo che li circonda. Citando il grande matematico Stuart Geman:

> Il mondo è composizionale o Dio esiste.

<!--
<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Figure 10. Feature visualization of convolutional net trained on ImageNet from [Zeiler & Fergus 2013]</center>


This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.

The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:

> The most incomprehensible thing about the universe is that it is comprehensible.

The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:

> The world is compositional or God exists.

-->

## [Ispirazioni dalla biologia](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

Allora perché l'apprendimento profondo dovrebbe essere basato sull'idea che il nostro mondo sia comprensibile e abbia una natura composizionale? Una ricerca condotta da Simon Thorpe ha permesso di motivare ciò in maniera più ampia. Egli ha mostrato che il modo in cui riconosciamo gli oggetti con cui abbiamo a che fare ogni giorno è estremamente rapido. I suoi esperimenti riguardavano mostrare in rapida successione un insieme di immagini ogni 100ms, per poi chiedere ai partecipanti d'identificare queste immagini, il che erano in grado di fare con successo. Ciò ha dimostrato che gli umani impiegano circa 100ms per riconoscere gli oggetti. Inoltre, si consideri il diagramma qui sotto, illustrante parti del cervello annotate con il tempo che impiegano i neuroni a propagare un segnale da un'area alla successiva.

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" />
<div align="center">Fig. 11 Il modello di Simon Thorpe del flusso di informazione visiva nel cervello<div></center>

<!--

## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">Figure 11. Simon Thorpe's model of visual information flow in the brain <div>
-->

I segnali passano dalla retina al LGN (che aiuta al miglioramento del contrasto, teoria del cancello, ecc.), quindi alla corteccia visiva primaria V1, poi V2, V4, quindi alla corteccia inferotemporale (PIT), che è la parte del cervello dove vengono definite le categorie. Delle osservazioni basate su operazioni chirurgiche a cervello aperto hanno elicitato che, se si mostra un film ad un umano, i neuroni nel PIT si attivano solo quando riconoscono certe immagini -- come Jennifer Aniston o la nonna del soggetto -- e null'altro. Le attivazioni neurali sono invarianti a concetti come posizione, dimensione, illuminazione, l'orientamento di tua nonna, che cosa sta indossando, ecc.

Inoltre, il rapido tempo di reazione con il quale gli umani erano capaci di categorizzare questi oggetti -- appena sufficiente a far verificare un paio di picchi del segnale -- dimostra che è possibile fare ciò senza dover dedicare tempo ulteriore ad effettuare complessi calcoli ricorrenti; piuttosto, questo è un singolo processo sequenziale.

Queste scoperte suggerirono che fosse possibile sviluppare una rete neurale che fosse completamente sequenziale, ma comunque capace di risolvere problemi di riconoscimento rimanendo invariante a trasformazioni dell'input.

Una ulteriore intuizione sul cervello umano viene da Gallant & Van Essen, il cui modello del cervello umano illustra due correnti distinte:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" />
<div align="center">Fig. 12 Il modello di Gallen & Van Essen sulle correnti cerebrali dorsale e ventrale<div></center>

La figura di destra mostra la corrente ventrale, che distingue che cosa si sta guardando, mentre la figura di sinistra mostra la corrente dorsale, che identifica localizzazioni, geometrie e movimenti. Sembrano essere moderatamente separate (con poche interazioni reciproche) nella corteccia visiva umana (e dei primati).


<!--
Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.

Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.

These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.

One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">Figure 12. Gallen & Van Essen's model of dorsal & ventral pathways in the brain <div>

The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).

-->

## I contributi di Hubel & Weisel (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" />

<div align="center">Fig. 13 Gli esperimenti di Hubel & Weisel sugli stimoli visivi nel cervello di gatti<div></center>

Huber e Weisel, nei loro esperimenti, utilizzavano elettrodi per misurare le attivazioni neuronali nel cervello di gatti in risposta a stimoli visivi. Essi scoprirono che i neuroni della regione V1 sono sensibili a determinate aree del campo visivo (chiamate "campi recettivi") e riconoscono i bordi orientati in tale area. Per esempio, hanno dimostrato che, se mostri ad un gatto una riga verticale ed inizi a ruotarla, il neurone si attiverà ad una determinata angolatura della riga. Analogamente, come la riga si discosta da quella determinata angolatura, l'attivazione del neurone si riduce. Huber e Weisel hanno nominato "cellule semplici" questi neuroni selettivi all'attivazione, a causa della loro abilità di riconoscere caratteristiche locali.

Inoltre, hanno scoperto che, se scosti la riga al di fuori del campo recettivo, quel particolare neurone non si attiva più, ma lo farà un altro neurone. Ci sono rilevatori di caratteristiche locali corrispondenti a tutte le aree del campo visivo, da cui l'idea che il cervello umano processi le informazioni visive come collezione di "convoluzioni".

Un altro tipo di neurone, che Huber e Weisel chiamarono "cellule complesse", aggrega gli output di più "cellule semplici" appartenenti ad una determinata area. Possiamo pensare che queste "cellule complesse" stiano effettuando un'aggregazione delle attivazioni utilizzando a funzioni come il massimo, la somma, la somma di quadrati o qualsiasi altra funzione indipendente dall'ordine dei termini. Esse riconoscono bordi ed orientamenti in una regione, indipendentemente dalla localizzazione specifica degli stimoli all'interno della regione. In altre parole, sono invarianti rispetto a piccole traslazioni della posizione dell'input.
<!--
### Hubel & Weisel's contributions (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">Figure 13. Hubel & Weisel's experiments with visual stimuli in cat brains <div>

Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.

They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".

Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.



-->
## Contributi di Fukushima (1982)


<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" />

<div align="center">Fig. 14 Il modello di CNN di Fukushima <div></center>

Fukushima fu il primo a implementare l'idea di strati multipli di "cellule semplici" e "cellule complesse" in modelli informatici, usando un dataset di cifre scritte a mano. Alcuni di questi rilevatori di caratteristiche erano progettati in maniera artigianale oppure appresi tramite algoritmi di clustering non supervisionato ed addestrati separatamente per ogni strato, in quanto la retropropagazione non era ancora in uso.

Yann LeCun arrivò un paio di anni più tardi (1989, 1998) e implementò la stessa architettura, questa volta addestrata in un setting supervisionato e utilizzando la retropropagazione. Questa è ampiamente considerata la genesi delle reti neurali convoluzionali moderne. (Nota: Riesenhuber all'MIT nel 1999 ri-scoprì pure lui queste architetture, ma non utilizzò la retropropagazione).

<!--
### Fukushima's contributions (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">Figure 14. Fukushima's CNN model <div>

Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.

Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)

-->
