---
lang-ref: ch.01-2
lang: it
lecturer: Yann LeCun
title: Evoluzione ed uso delle CNN e "perché l'apprendimendo profondo?"
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translation-date: 27 Mar 2020
translator: Stefano Pirra
---


## [Evoluzione delle CNN](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

Nel cervello animale i neuroni reagiscono alle linee che hanno un particolare orientamento. Gruppi di neuroni che reagiscono allo stesso orientamento sono replicati su tutto il campo visivo.

<!-- In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field. -->

Fukushima (1982) costruì una rete neurale (NN, *Neural Network*) che funzionava alla stessa maniera del cervello, basata su due concetti.
Primo, i neuroni sono replicati attraverso il campo visivo. Secondo, esistono cellule complesse che raccolgono l'informazione da cellule semplici (unità selettive di orientamento). Come risultato, lo spostamento dell'immagine cambierà l'attivazione di cellule semplici ma non influenzerà l'attivazione integrata della cellula complessa (raggruppamento convoluzionale, *convolutional pooling*).

<!-- Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling). -->

LeCun (1990) utilizzò la retropropagazione (*backprop* o *backpropagation*) per addestrare una CNN nel riconoscere dei numeri scritti a mano. Esiste una *demo* del 1992 in cui l'algoritmo riconosce i caratteri in diversi stili. L'utilizzo di un modello completamente addestrato, dall'inizio alla fine, per fare riconoscimento di *pattern*/caratteri fu una novità per quell'epoca. In passato le persone utilizzavano sistemi di estrazione di caratteristiche con, alla fine, un modello supervisionato.

<!-- LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top. -->

Questi nuovi sistemi CNN potevano riconoscere diversi caratteri contemporaneamente in una singola immagine. Per farlo le persone costruivano una piccola finestra su di cui lavorava una CNN e facevano scorrere detta finestra lungo l'intera immagine. Se la CNN si attivava, allora un particolare carattere era presente.

<!-- These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present. -->

In seguito questa idea fu applicata al riconoscimento di volti/persone e nella segmentazione semantica (classificazione di ogni pixel, *pixel-wise classification*). Esempi includono Hadsell (2009) e Farabet (2012). Questa tecnica divenne infine popolare nell'industria, applicata nei veicoli autonomi, come ad esempio nell'identificazione delle corsie di marcia.

<!-- Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking. -->

Tipologie speciali di *hardware* per addestrare CNN divennero un tema scottante negli anni 1980, poi l'interesse diminuì ed oggi è di nuovo popolare.

<!-- Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again. -->

La rivoluzione dell'apprendimento profondo (*deep learning*, sebbene il termine non venne ancora usato all'epoca) iniziò nel 2010-2013. I ricercatori si focalizzarono nell'inventare algoritmi che potessero addestrare grosse CNN più velocemente. Krizhevsky (2012) fece uscire *AlexNet*, che era una CNN molto più grande di quelle usate fino ad allora e la addestrò sul dataset *Imagenet* (1.3 milioni di istanze), utilizzando le GPU. Dopo un paio di settimane di esecuzione, *AlexNet* fu in grado di battere in performance i migliori concorrenti, con un largo margine -- un errore di accuratezza per i primi 5 output del modello (*Top-5 error rate*) del 25.8% del secondo classificato contro il 16.4 di *AlexNet*.

<!-- The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% vs 16.4% top-5 error rate. -->

Dopo aver testimoniato il successo di AlexNet, la comunità della visione artificiale (CV, *computer vision*) si convinse che le CNN funzionavano. Mentre tutte le pubblicazioni dal 2011-2012 che menzionavano le CNN vennero rifiutate, a partire dal 2016 la maggior parte delle pubblicazioni accettate sulla visione artificiale utilizza le CNN.

<!-- After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs. -->

Nel corso degli anni il numero di strati usati è incrementato: *LeNet* -- 7, *AlexNet* -- 12, *VGG* -- 19, *ResNet* -- 50. Tuttavia c'è un compromesso tra il numero di operazioni necessarie per calcolare l'output, la dimensione del modello e la sua accuratezza. Perciò un argomento popolare oggi è come comprimere le reti per rendere la computazione più veloce.

<!-- Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster. -->


## [Apprendimento Profondo ed Estrazione di Caratteristiche](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

Le reti multi-strato hanno successo perchè sfruttano la struttura compositiva dei dati naturali.
Nella gerarchia compositiva, le combinazioni di oggetti di un livello formano gli oggetti del livello successivo. Se noi mimiamo questa gerarchia con strati multipli e lasciamo alla rete il compito di apprendere un'appropriata combinazione di caratteristiche, otteniamo quello che viene chiamata un'architettura di apprendimento profondo. Perciò le reti di apprendimento profondo sono di natura gerarchica.

<!-- Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy,  combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature. -->

Le architetture di apprendimento profondo hanno portato un progresso incredibile in compiti di visione artificiale, dall'identificare e generare maschere accurate intorno ad oggetti fino all'identificazione di proprietà spaziali di un oggetto. Le architetture *Mask-RCNN* e *RetinaNet* sono quelle maggiormente responsabili di questo miglioramento.

<!-- Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement. -->

Le Mask RCNN hanno trovato il loro utilizzo nella segmentazione di oggetti singoli, ad es. nel creare maschere per ogni oggetto in un'immagine. L'input e l'output sono immagini. L'architettura può anche essere utilizzata per fare segmentazione di istanze, ad es. nell'identificare oggetti differenti dello stesso tipo in un'immagine. *Detectron*, un sistema software del Facebook AI Research (FAIR) implementa tutti questi algoritmi all'avanguardia nell'identificazione di oggetti ed è un *software open-source*.

<!-- Mask RCNNs have found their use in segmenting individual objects, i.e. creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, i.e. identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source. -->

Alcune delle applicazioni pratiche delle CNN sono la guida autonoma di veicoli e l'analisi di immagini mediche.

<!-- Some of the practical applications of CNNs are powering autonomous driving and analysing medical images. -->

Sebbene la scienza e la matematica che si cela dietro all'apprendimento automatico sia abbastanza chiara, ci sono ancora diverse domande interessanti che richiedono ulteriore ricerca. Queste domande includono: perchè le architetture multi-strato funzionano meglio, visto che possiamo approssimare qualsiasi funzione con due strati? Perchè le CNN funzionano bene con dati naturali come il parlato, le immagini ed il testo? Come possiamo ottimizzare funzioni non convesse così bene? Perchè le architetture funzionano anche se troppo sovraparametrizzate?

<!-- Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work? -->

L'estrazione di caratteristiche consiste nell'espansione della dimensione rappresentativa in modo che le caratteristiche così espanse si possano separare linearmente con più alta probabilità; i punti dei dati in uno spazio dimensionalmente maggiore sono più probabilmente separabili a causa dell'incremento dei possibili piani di separazione.

<!-- Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes. -->

I primi professionisti nell'apprendimento automatico si affidarono a caratteristiche di alta qualità, selezionate manualmente e specializzate in un determinato campo per costruire modelli di intelligenza artificiale ma, con l'avvento dell'apprendimento profondo, i modelli sono diventati capaci di estrarre le caratteristiche automaticamente. Sono qui elencati alcuni approcci comuni utilizzati negli algoritmi di estrazione di caratteristiche:

<!-- Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below: -->

- Suddivisione (_tiling_) dello spazio
- Proiezioni casuali
- Classificatori polinomiali (caratteristiche tra prodotti)
- Funzioni a base radiale
- Macchine a *Kernel*

<!-- 
- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines -->

A causa della natura compositiva dei dati, le caratteristiche apprese hanno una gerarchia rappresentativa con livello crescente di astrazione. Ad esempio:

<!-- Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example: -->

-  Immagini - al massimo livello di granularità le immagini possono essere pensate come pixel. La combinazione di pixel costituisce delle linee che, quando combinate, formano  *textons* (forme composte da più linee). I *textons* formano motivi ed i motivi formano le parti di un'immagine. Combinando queste parti insieme otteniamo l'immagine finale.
-  Testo - Allo stesso modo c'è una gerarchia inerente ai dati testuali. I caratteri formano le parole, che combinate assieme ci danno gruppi di parole, quindi periodi che combinati tra loro ci danno frasi. Le frasi infine ci dicono quale storia viene narrata.
-  Parlato - Nel parlato i campioni compongono le bande che compongono i suoni che compongono i foni, quindi i fonemi, quindi parole intere e frasi, mostrando così una chiara gerarchia nella rappresentazione.

<!-- -  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.
-  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.
-  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation. -->


## [Rappresentazioni di apprendimento](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

Ci sono coloro che respingono l'apprendimento profondo: "se possiamo approssimare ogni funzione con 2 strati, perchè averne di più?"

<!-- There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more? -->

Per esempio: gli SVM (*Support Vector Machines*) trovano un iperpiano di separazione "nell'intervallo dei dati", che significa che le predizioni si basano sul confronto con gli esempi di addestramento. Le SVM sono essenzialmente delle reti neurali molto semplicistiche a 2 strati, in cui il primo strato definisce i "template" mentre il secondo è un classificatore lineare. Il problema con l'errore di due strati è che la complessità e la dimensione dello strato intermedio è esponenziale in $N$ (per lavorare bene con un compito difficile, c'è bisogno di una GRANDE quantità di template). Se però si espande il numero di strati nel $log(N)$, ogni strato diventa lineare in $N$. Esiste un compromesso tra il tempo e lo spazio.

<!-- For example: SVMs find a separating hyperplane "in the span of the data," meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in N (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to log(N), the layers become linear in N. There is a trade-off between time and space. -->

Un'analogia è il disegno di un circuito per il calcolo di una funzione booleana con non più di due strati di porte logiche -- possiamo ottenre **ogni funzione booleana** in questo modo! Ma la complessità e le risorse del primo strato (il numero delle porte logiche) diventa velocemente infattibile per funzioni complesse.

<!-- An analogy is designing a circuit to compute a boolean function with no more than two layers of gates - we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions. -->

Cosa è "profondo"?

- Una SVM non è profonda perchè ha solo 2 strati
- Un albero di classificazione non è profondo perchè ogni livello analizza solamente caratteristiche grezze
- Una rete profonda ha molti strati e li usa per costruire una **gerarchia di caratteristiche di complessità incrementale**

<!-- What is "deep"?

- An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity** -->

Come possono i modelli apprendere le rappresentazioni (buone caratteristiche)?

Ipotesi della varietà (_manifold_): i dati naturali vivono in una varietà a poche dimensioni. L'insieme di immagini possibili è essenzialmente infinito, l'insieme di immagini "naturali" ne è un piccolo sottoinsieme.
Per esempio: data l'immagine di una persona, l'insieme delle possibili immagini è nell'ordine di grandezza dei muscoli facciali che egli può muovere (gradi di libertà) di circa 50. Un estrattore di caratteristiche ideale (ed irrealistico) rappresenta tutti i fattori di variazione (ogni muscolo, illuminazione, *ecc*).

<!-- How can models learn representations (good features)?

Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*). -->

Q&A (domande e risposte):

- Nell'esempio del viso qualche altra tecnica di riduzione di dimensionalità (*ad es.* PCA, analisi delle componenti principali) potrebbe estrarre queste caratteristiche?
  - Risposta: potrebbe funzionare solo se la superficie chiusa è un iperpiano, ma non lo è.

<!-- Q&A from the end of lecture:

- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not -->
