---
lang: it
lang-ref: ch.01-1
lecturer: Yann LeCun
title: Motivazione, storia, e ispirazione dietro l'apprendimento profondo
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 1 Apr 2020
translator: Nantas Nardelli
---


<!--
## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)
-->

## [Programma del corso](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!--
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
-->

- Basi di apprendimento supervisionato (Supervised Learning), reti neurali (Neural Networks), apprendimento profondo (Deep Learning)
- Retropropagazione (Backpropagation), e componenti architettoniche
- La rete neurale convoluzionale (CNN, Convolutional Neural Network) e le sue applicazioni
- Altre architetture per l'apprendimento profondo
- Trucchi per la regolarizazione / ottimizazione / comprensione su come funziona l'apprendimento profondo
- Modelli basati sull'energia
- Apprendimento auto-supervisionato e oltre


<!--
## Inspiration of Deep Learning and its history
-->

## L'ispirazione dietro all'apprendimento profondo e la sua storia

<!--
On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.

The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.

In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.

Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.

In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.

Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:

- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.

Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->

A un livello concettuale, l'apprendimento profondo è ispirato dal cervello, ma non tutti i dettagli del cervello sono pertinenti. Nello stesso modo, ad esempio, gli aeroplani furono inspirati dagli uccelli: i principi dietro al volo sono gli stessi, ma i dettagli sono diversi.

La storia dell'apprendimento profondo risale a una materia ora chiamata cibernetica. Tutto è iniziato negli anni '40 con McCulloch e Pitts. Essi arrivarono all'idea che i neuroni sono delle unità con valori di soglia e uno stato, attivato o disattivato. Si potrebbe costruire un circuito booleano connettendo dei neuroni tra di loro e conducendo un processo di inferenza logica con questi neuroni. Il cervello è sostanzialmente un processore d'inferenza logica, poiché i neuroni sono binari. Ogni neurone calcola una somma pesata degli ingressi, paragonando questa somma al valore di soglia. Il neurone si attiva se questo valore è sopra la soglia, e si disattiva se è sotto, il che è una visione semplicizzata di come funzionano le reti neurali.

Nel 1947, Donald Hebb ebbe l'idea che i neuroni nel cervello apprendono attraverso la modifica della forza delle connessioni tra i neuroni. Questo processo si chiama iper-apprendimento, cioè dove due neuroni che si attivano insieme avranno la loro connessione rafforzata, mentre due neuroni che non si attivano insieme l'avranno indebolita.

Nel 1949, Norbert Wiener propose i sistemi cibernetici, cioè sistemi che, avendo sensori e attuatori, creano un ciclo di *feedback* (retroazione) e un sistema auto-regolatore. Le regole dei meccanismi di *feedback* nell'automobile moderano attingono tutte da questo lavoro.

Nel 1957 Frank Rosenblatt propose il percettrone (*Perceptron*), un algoritmo di apprendimento che modifica i pesi di reti neurali semplici.

Complessivamente, quest'idea di provare a costruire macchine intellettive andando a simulare molti neuroni nacque negli anni '40, decollò negli anni '50, e morì nel fine anni '60. Le ragioni principali della morte di questo campo furono:

- Il fatto che i ricercatori avevano usato neuroni che erano binari; tuttavia, per funzionare, la retropropagazione ha bisogno di funzioni di attivazione che sono continue. In quel momento, i ricercatori non ebbero l'idea di usare neuroni continui, e non pensarono che si potesse addestrare i neuroni con i gradienti, poiché i neuroni binari non sono differenziabili.
- Usando neuroni continui, si sarebbe dovuto moltiplicare l'attivazione di un neurone con un peso per contribuire alla somma pesata. Però, prima degli anni '80, la moltiplicazione di due numeri, specialmente se numeri in virgola mobile, era particolarmente lenta. Questo risultò in un altro incentivo per evitare l'uso dei neuroni continui.

L'apprendimento profondo prese piede di nuovo nel 1985 con l'avvento della retropropagazione. Nel 1995, il campo morì di nuovo, e la comunità scientifica dell'apprendimento autonomo abbandonò l'idea delle reti neurali. Nei primi anni del 2010, alcune persone iniziarono a usare reti neurali per il riconoscimento vocale (*Speech Recognition*), con miglioramenti enormi in termini di prestazioni, vedendo presto un uso globale in campi commerciali. Nel 2013, il campo della visione artificiale (*Computer Vision*) iniziò a passare all'utilizzo delle reti neurali. Nel 2016, la stessa cosa accadde nel campo dell'elaborazione del linguaggio naturale (*Natural Language Processing*). Presto, simili rivoluzioni andranno ad accadere in robotica, controllo e molti altri campi.


<!--
### Supervised Learning
-->

### Apprendimento supervisionato

<!--
$90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.

Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->

Il $90\%$ delle applicazioni dell'apprendimento profondo usa l'apprendimento supervisionato. L'apprendimento supervisionato e' un processo attraverso il quale si va ad aggregare un po' di coppie di input (dati d'ingresso) / output (prodotti di uscita), sottoponendo questi input ad una macchina così che impari gli output corretti. Quando gli output sono corretti, non si fa niente. Quando sono sbagliati, si va a sistemare i parametri della macchina, correggendo l'output verso quello desiderato. Il trucco qua è come capire di quanto correggere il valore e quale direzione usare per modificare il parametro. Questo si riduce al calcolo del gradiente e alla retropropagazione.

L'apprendimento supervisionato deriva dal percettrone e dal modello *Adaline*. *Adaline* è basato sulla stessa architettura della somma pesata degli ingressi. Quando questa somma è sopra la soglia, il modello si attiva, mentre sotto la soglia si disattiva. Il percettrone è una rete neurale a due strati dove il secondo strato può essere addestrato, mentre il primo è fisso. Nella maggior parte dei casi, il primo strato è determinato in maniera casuale, motivo per cui viene chiamato strato associativo.

<!--
## [History of *pattern* Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)
-->
## [Storia del riconoscimento di *pattern* e introduzione alla discesa del gradiente](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!--
The foregoing is the conceptual basis of *pattern* recognition before deep learning developed. The standard model of *pattern* recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, *pattern* recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.

After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.

The simplest multi-layer architecture with tunable parameters and nonlinearity could be: input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix which coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.

Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is loss computing distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.

The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.

The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->

Il testo successivo forma la base concettuale del riconoscimento di *pattern* prima della nascita dell'apprendimento profondo. Il modello standard del riconoscimento di *pattern* consiste in modelli classificatori che possono essere addestrati, e nell'estrazione delle caratteristiche dei dati. L'input viene passato attraverso un estrattore di caratteristiche, ricavandone dall'input quelle che sono pertinenti e utili, per esempio a rilevare un occhio quando lo scopo è quello di rilevare un volto. Poi, questo vettore di caratteristiche è sottoposto a un classificatore addestrabile per calcolarne la somma pesata, confrontandola con una soglia. In questo caso, il classificatore addestrabile potrebbe essere un percettrone o una rete neurale singola. Il problema è che l'estrattore delle caratteristiche deve essere ingegnerizzato a mano, il che significa che il riconoscimento di *pattern* e la visione artificiale vanno così a concentrarsi su estrattori di caratteristiche che vengono progettati per risolvere problemi specifici, invece di sviluppare classificatori addestrabili polivalenti.

Dopo la nascita e lo sviluppo dell'apprendimento profondo, questo processo a 2 stadi mutò in una sequenza di moduli. Ogni modulo ha dei parametri che possono essere aggiustati e delle nonlinearità. Questi moduli vengono accatastati a formare un certo numero di strati, ragione per cui la materia si chiama apprendimento "profondo". La ragione per la quale si utilizzarono non-linearità invece che linearità si può individuare riflettendo sul fatto che due strati lineari possono diventare uno strato lineare, visto che la composizione di due funzioni lineari è anch'essa lineare.

L'architettura a strati multipli più semplice con parametri aggiustabili e non-linearità potrebbe essere questa: l'input, ad esempio un'immagine o una traccia audio, è rappresentato da un vettore. L'input è moltiplicato da una matrice di pesi il cui coefficiente è un parametro aggiustabile. Poi ogni componente del vettore risultante viene passata attraverso una funzione non-lineare come la ReLU. Ripetendo questo processo, il tutto diventa una rete neurale semplice. La ragione per la quale viene chiamata rete neurale è che l'architettura calcola la somma pesata dei componenti del vettore di entrata per le corrispondenti righe di una matrice.

Tornando all'apprendimento supervisionato, stiamo confrontando l'output risultante con l'output desiderato, quindi ottimizziamo la funzione obiettivo, che sta calcolando la distanza / penalità / divergenza tra il risultato (l'output del modello) e l'obiettivo (l'output desiderato), facendo la media di questa funzione di costo su tutto il dataset di addestramento. Questo è l'obiettivo che vogliamo minimizzare. In altre parole, vogliamo trovare il valore dei parametri che minimizza questa media.

Il metodo per trovare questo valore è il calcolo dei gradienti. Per esempio, se siamo persi in una montagna regolare (o liscia) in una notte nebbiosa, e vogliamo andare al villaggio che si trova a valle, una maniera potrebbe essere girarsi intorno per trovare la via più ripida per andare giù, e fare il passo più piccolo possibile. Questa direzione è il gradiente (negativo). Assumendo che la valle sia convessa, potremmo raggiungere il villaggio.

La maniera più efficiente per fare questo si chiama discesa stocastica del gradiente (SGD, *Stochastic Gradient Descent*). Visto che vogliamo minimizzare la perdita media su tutto il set di apprendimento, possiamo prendere un campione, o un piccolo gruppo di campioni, e calcolare l'errore, per poi operare la discesa del gradiente. Quindi prendiamo un nuovo campione, calcoliamo un nuovo valore di errore, e arriviamo a un gradiente che normalmente ci dà una direzione diversa. Due delle principali ragioni dietro l'utilizzo di SGD è che aiuta il modello a convergere velocemente dal punto di vista empirico se il set di apprendimento è molto largo, con l'aggiunta che fornisce miglior generalizzazione, il che significa avere prestazioni simili su diversi set di dati.

<!--
### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)
-->
### [Calcolo dei gradienti attraverso la retropropagazione](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!--
Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:
-->

Il calcolo dei gradienti con la retropropagazione è un'applicazione pratica della regola della derivazione delle funzioni composte. L'equazione della retropropagazione per i gradienti dell'input è la seguente:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$


<!--
The backpropagation equation for the weight gradients is as follows:
-->

Mentre l'equazione per i gradienti dei pesi è la seguente:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!--
Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.

It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->

Si noti che invece di usare input di numeri scalari, questi sono input vettoriali o, più generalmente, input multidimensionali. La retropropagazione permette di calcolare la derivata della differenza fra l'output effettivo e l'output prodotto (ovvero il valore della funzione obiettivo) rispetto a qualsiasi valore dentro alla rete. La retropropagazione è essenziale, visto che può essere usata su molteplici strati.

È importante considerare come interpretare gli input. Per esempio, un'immagine di $$256\times256$$ ha bisogno di una matrice con 200.000 valori. Queste sono matrici enormi che la rete neurale dovrà andare a gestire. Non sarebbe pratico utilizzare questo tipo di matrici, quindi è importante fare delle ipotesi riguardo la struttura della matrice.


<!--
## Hierarchical representation of the Visual Cortex
-->
## Rappresentazioni gerachice della corteccia visiva

<!--
Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does *pattern* recognition in a hierarchical manner.

Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (e.g. vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->

Gli esperimenti di Fukushima ci hanno permesso di capire come il nostro cervello interpreta il segnale che viene dai nostri occhi. In sintesi, fu scoperto che i neuroni di fronte alla retina comprimono il segnale (il quale processo si chiama normalizzazione del contrasto), e che questo segnale viaggia dagli occhi al cervello. Dopodiché, l'immagine viene elaborata per fasi e alcuni neuroni vengono attivati in base all'appartenenza dell'input a determinate categorie. Quindi, la corteccia visiva usa il riconoscimento di *pattern* in modo gerarchico.

Alcuni esperimenti nei quali furono inseriti elettrodi in aree specifiche della corteccia visiva, più precisamente l'area V1, fece realizzare ai ricercatori che determinati neuroni reagiscono a *pattern* che appaiono in un area molto piccola all'interno del campo visivo, reagendo similarmente modo con neuroni vicini e ad aree vicine del campo visivo. Inoltre, neuroni che reagiscono nello stesso campo visivo reagiscono a diversi tipi di bordi in maniera organizzata (per esempio per bordi verticali o orizzontali). È anche importante sottolineare come esista un'idea che il processo visivo sia sostanzialmente un processo *feed-forward* ("in avanti"). Quindi, in qualche modo, il processo di riconoscimento rapido può essere compiuto senza connessioni ricorrenti.
