---
lang: fr
lang-ref: ch.15-1
lecturer: Alfredo Canziani
title: Inférence pour les modèles à base d’énergie à variable latente
authors: Yilang Hao, Binfeng Xu, Ebrahim Rasromani, Mars Wei-Lun Huang
date: 18 Oct 2020
translation-date: 6 Dec 2020
translator: Loïck Bourdois
---

<!--
## [Training data and model definition](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=46s)

To understand why and how to use an Energy-Based Model (EBM), as well as relevant data format, let us consider training samples from an ellipse. Given function below

$$
\vect{y} = \begin{bmatrix}
\rho_1(x)\cos(\theta) + \epsilon \\
\rho_2(x)\sin(\theta) + \epsilon
\end{bmatrix},
$$

where $x \sim \mathcal{U}(0,1),\space \theta \sim \mathcal{U}(0,2\pi),\space  \epsilon \sim \mathcal{N}[0, (\frac{1}{20})^2]$
and $\rho : \mathbb{R} \mapsto \mathbb{R}^2$ maps $x$ into $$\begin{bmatrix}\alpha x + \beta (1-x) \\
\beta x + \alpha (1-x)
\end{bmatrix}\exp(2x)$$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure1.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> 3D Visualization of Ellipse Function
</center>

<br>

From Figure 1, it is clear that given a single input $x$, there are multiple possible output $\vect{y}$. In other words, we cannot identify a one-to-one mapping of vectors as we expected for Feed Forward Neural Networks (For example, there are almost always two possible $y_2$ fixing $y_1$ given input $x$). This is where we introduce the Latent Variable Energy-Based Models.

For simplicity, we fix input $x = 0$ and let $\alpha = 1.5, \beta = 2$, inducing $$\vect{y} =
\begin{bmatrix} 2\cos(\theta) + \epsilon \\
1.5\sin(\theta) + \epsilon
\end{bmatrix}$$ , from which we randomly sample 24 data points $Y = [\vect{y}^{(1)},\ldots,\vect{y}^{(24)}]$. Meanwhile, we take latent variable $z = [0:\frac{\pi}{24}:2\pi)$ and feed it into a decoder to produce $\tilde{\vect{y}}$ (Figure 2 and 3). Then, the energy function is computed as the squared Euclidean distance between $\vect{y}$ and $\tilde{\vect{y}}$:

$$
E(\vect{y},z) \equiv E(\vect{y},\tilde{\vect{y}}(z)) = [y_1 - g_1(z)]^2 + [y_2 - g_2(z)]^2, \space  \vect{y} \in Y,
$$

where $\vect{g} = [g_1 \space\space g_2]^{\top} : \mathbb{R} \mapsto \mathbb{R}^2$ and $\vect{g}(z) =  \ [w_1 \cos(z) \space\space w_2 \sin(z)]^{\top}$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure2.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 2:</b> Sample Visualization
</center>

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure3.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 3:</b> Energy Computation Graph
</center>

<br>

For each $\vect{y}^{(i)} \in Y, i \in [1,24]$, we can compute the corresponding energy given each $\tilde{\vect{y}}$ by changing $z$. Therefore, we may visualize 24 energy functions $E_{1},\ldots,E_{24}$, where energy quantity on y-axis is plotted against the choice of latent variable $z$ on the x-axis (Figure 4).

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure4.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 4:</b> Energy Functions over Samples
</center>
-->


## [Données d’entraînement et définition du modèle](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=46s)

Pour comprendre pourquoi et comment utiliser un modèle à base d'énergie (EBM), et quel est le format de données qui est pertinent pour ce type de modèle, considérons des échantillons d'entraînement à partir d'une ellipse. La fonction est donnée ci-dessous :

$$
\vect{y} = \begin{bmatrix}
\rho_1(x)\cos(\theta) + \epsilon \\
\rho_2(x)\sin(\theta) + \epsilon
\end{bmatrix},
$$

où $x \sim \mathcal{U}(0,1),\space \theta \sim \mathcal{U}(0,2\pi),\space  \epsilon \sim \mathcal{N}[0, (\frac{1}{20})^2]$
et  $\rho : \mathbb{R} \mapsto \mathbb{R}^2$ associe $x$ à $$\begin{bmatrix}\alpha x + \beta (1-x) \\
\beta x + \alpha (1-x)
\end{bmatrix}\exp(2x)$$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure1.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 1 :</b> Visualisation 3D de la fonction de l’ellipse
</center>
<br>

La figure 1 montre clairement qu'avec une seule entrée $x$, il y a plusieurs sorties possibles $\vect{y}$. En d'autres termes, nous ne pouvons pas identifier une association un à un des vecteurs comme nous l'avions prévu pour les réseaux neuronaux de type *feed forward* (par exemple, étant donné l'entrée $x$, pour un $y_1$ fixé, il y a presque toujours deux $y_2$ possibles). C'est ici que nous introduisons les modèles à base d’énergie à variable latente.

Pour simplifier, nous fixons l'entrée $x = 0$ et nous laissons $\alpha = 1,5, \beta = 2$, induisant $$\vect{y} =
\begin{bmatrix} 2\cos(\theta) + \epsilon \\
1.5\sin(\theta) + \epsilon
\end{bmatrix}$$, à partir de laquelle nous échantillonnons aléatoirement 24 points de données $Y = [\vect{y}^{(1)},\ldots,\vect{y}^{(24)}]$. 
Entre-temps, nous prenons la variable latente $z = [0:\frac{\pi}{24}:2\pi]$ et l'introduisons dans un décodeur pour produire $\tilde{\vect{y}}$ (figures 2 et 3).
Ensuite, la fonction d'énergie est calculée comme le carré de la distance euclidienne entre $\vect{y}$ et $\tilde{\vect{y}}$ :

$$
E(\vect{y},z) \equiv E(\vect{y},\tilde{\vect{y}}(z)) = [y_1 - g_1(z)]^2 + [y_2 - g_2(z)]^2, \space  \vect{y} \in Y,
$$

où $\vect{g} = [g_1 \space\space g_2]^{\top} : \mathbb{R} \mapsto \mathbb{R}^2$ et $\vect{g}(z) =  \ [w_1 \cos(z) \space\space w_2 \sin(z)]^{\top}$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure2.png" style="zoom: 100%; background-color:#DCDCDC;" />
<br><b>Figure 2 :</b> Exemple de visualisation
</center>
<br>
<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure3.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 3 :</b> Graphe du calcul de l'énergie
</center>
<br>

Pour chaque $\vect{y}^{(i)} \in Y, i \in [1,24]$, nous pouvons calculer l'énergie correspondante donnée à chaque $\tilde{\vect{y}}$ en changeant $z$. 
Par conséquent, nous pouvons visualiser 24 fonctions d’énergie $E_{1},\ldots,E_{24}$, où la quantité d'énergie sur l'axe des y est tracée en fonction du choix de la variable latente $z$ sur l'axe des $x$ (figure 4).

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure4.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 4 :</b> Fonctions d’énergie sur les échantillons
</center>

<!--
## [Energy and free energy for two training samples](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=1088s)

Let's dive deeper into the functional form of the $E(\vect{y}, z)$ for a given $\vect{y}^{(i)}$. Figure 5 shows a plot of $E(\vect{y}^{(23)}, z) = E_{23}$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure5.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 5:</b> Energy Function associated with the 23rd Sample
</center>

<br>

Note that the energy, $E_{23}$, yields a periodic function with a maximum near $z=0$ and $2{\pi}$ and minimum near $z={\pi}$. This symmetric form arises due to the location $\vect{y}^{(23)}$ in the $\vect{y}$ space relative to the decoded $\tilde{\vect{y}}$.

As shown in Figure 6, $\vect{y}^{(23)}$ marked by the green point is closely aligned to the horizontal axis of $\tilde{\vect{y}}$ shown in purple which yields symmetry in $E_{23}$. The latent variable $z$ acts as a reverse polar coordinates angle such that the positive direction is clockwise. At $z=0$ (the leftmost purple point), the Euclidean distance between $\tilde{\vect{y}}$ and $\vect{y}^{(23)}$ is largely resulting in high energy. As $z$ approaches ${\pi}$ (the rightmost purple point), $\tilde{\vect{y}}$ gets closer to $\vect{y}^{(23)}$ which decreases the energy towards a minimum level. Conversely, as z increases beyond ${\pi}$ towards $2{\pi}$, the distance between $\tilde{\vect{y}}$ and $\vect{y}^{(23)}$ increases, and hence the energy also increases towards a maximum.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure6.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Relationship between Latent Variable, Decoder Output, and the 23rd Sample
</center>

<br>

Now that we have an understanding of the energy distribution, let's evaluate the zero-temperature limit of the free energy defined by the following.

$$F_{\infty} \equiv \min_{z} E(\vect{y}, z)$$

We will also express the latent variable which yields the free energy as $\check{z}$ defined by the following.

$$\check{z} = \arg \min_{z} E(\vect{y}, z)$$

As depicted in Figure 5, to find the free energy associated with $\vect{y}^{(23)}$ we'll start with an initial latent variable $\tilde{z}$. $\check{z}$ can be evaluated through optimization algorithms such as exhaustive search, conjugate gradient, line search, or limited-memory BFGS. The free energy is the minimum value of the energy with respect to the latent variable.

Figure 7 below shows the evaluation of the free energy in the $\vect{y}$ space. Note that throughout the optimization, the latent variable is increased such that $\tilde{\vect{y}}$ moves clockwise toward $\vect{y}^{(23)}$. At the free energy, the energy and consequently the distance between $\tilde{\vect{y}}$ and $\vect{y}^{(23)}$ is minimized.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure7.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Free Energy Evaluation Associated with the 23rd Sample
</center>

<br>

In evaluating the free energy $F_\infty$ and its associated latent variable $\check{z}$, we are able to find the decoded $\tilde{\vect{y}}$ which is close to the sample data $\vect{y}^{(i)}$.
-->

## [Energie et énergie libre pour deux exemples d’entraînement](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=1088s)

Plongeons dans la forme fonctionnelle des $E(\vect{y}, z)$ pour un $\vect{y}^{(i)}$ donné. La figure 5 montre un tracé de $E(\vect{y}^{(23)}, z) = E_{23}$.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure5.png" style="zoom: 100%; background-color:#DCDCDC;" /><br> 
<b>Figure 5 :</b> Fonction d’énergie associée au 23ème échantillon
</center>
<br>

L'énergie, $E_{23}$, donne une fonction périodique avec un maximum proche de $z=0$ et $2{\pi}$ et un minimum proche de $z={\pi}$. 
Cette forme symétrique est due à la position $\vect{y}^{(23)}$ dans l'espace $\vect{y}$ par rapport au $\tilde{\vect{y}}$ décodé.

Comme le montre la figure 6, $\vect{y}^{(23)}$ marqué par le point vert, est étroitement aligné sur l'axe horizontal de $\tilde{\vect{y}}$, indiqué en violet.
Cela donne une symétrie en $E_{23}$. La variable latente $z$ agit comme un angle de coordonnées polaires inversées de telle sorte que le sens positif est dans le sens des aiguilles d'une montre. 
À $z=0$ (le point violet le plus à gauche), la distance euclidienne entre $\tilde{\vect{y}}$ et $\vect{y}^{(23)}$ se traduit en grande partie par une énergie élevée. 
Lorsque $z$ s'approche de ${\pi}$ (le point violet le plus à droite), $\tilde{\vect{y}}$ se rapproche de $\vect{y}^{(23)}$, ce qui réduit l'énergie vers un niveau minimum. 
Inversement, lorsque z augmente au-delà de ${\pi}$ vers 2${\pi}$, la distance entre $\tilde{\vect{y}}$ et $\vect{y}^{(23)}$ augmente, et donc l'énergie augmente également vers un maximum.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure6.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
  <b>Figure 6 :</b> Relation entre la variable latente, la sortie du décodeur et le 23ème échantillon
</center>
<br>

Maintenant que nous avons une compréhension de la distribution de l'énergie, évaluons la limite vers zéro de la température de l'énergie libre définie par ce qui suit :

$$F_{\infty} \equiv \min_{z} E(\vect{y}, z)$$

Nous exprimerons également la variable latente qui donne l'énergie libre sous la forme $\check{z}$ définie par ce qui suit :

$$\check{z} = \arg \min_{z} E(\vect{y}, z)$$

Comme le montre la figure 5, pour trouver l'énergie libre associée à $\vect{y}^{(23)}$, nous commençons par une variable initiale latente $\tilde{z}$. 
$\check{z}$ peut être évalué par des algorithmes d'optimisation tels que la recherche exhaustive, le gradient conjugué, la recherche linéaire ou le BFGS à mémoire limitée. 
L'énergie libre est la valeur minimale de l'énergie par rapport à la variable latente.

La figure 7 ci-dessous montre l'évaluation de l'énergie libre dans l'espace $\vect{y}$. 
Notons que tout au long de l'optimisation, la variable latente est augmentée de telle sorte que $\tilde{\vect{y}}$ se déplace dans le sens des aiguilles d'une montre vers $\vect{y}^{(23)}$. 
À l'énergie libre, l'énergie (et donc la distance entre $\tilde{\vect{y}}$ et $\vect{y}^{(23)}$) est minimisée.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure7.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 7 :</b> Évaluation de l'énergie libre associée au 23ème échantillon
</center>
<br>

En évaluant l'énergie libre, $F_\infty$, et sa variable latente associée $\check{z}$, nous sommes capables de trouver le $\tilde{\vect{y}}$ décodé qui est proche des données de l'échantillon $\vect{y}^{(i)}$.


<!--
## [Free energy dense estimation](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=2241s)

To understand the Free Energy Function better, we begin with the following example, shown in Figure 8.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure8.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Free Energy Example in Mesh Grid
</center>

<br>

To compute the free energy, $F_\infty$, at each mesh grid point with respect to the manifold in blue color (which is also the all possible choices of the latent variables $z$), we first recall the definition of Free Energy Function as below:

$$
F_\infty = \min_z E(\vect{y},z) = E(\vect{y},\check{z}).
$$

Given the formula of the energy function, $E(\vect{y},z)$, and a location (sample) $\vect{y}$, our minimization process starts with inference, which is exactly the process to find the latent variable $\check{z}$ that most likely generates our location or sample. Graphically speaking with Figure 8, we start with an arbitrary point $z$ on the blue manifold and then move around the manifold to find the point, $\check{z}$, on the manifold that is closest to our sample location, $\vect{y}$. As a result, the free energy would be the Euclidean distance between our sample point $\vect{y}$ and the picked $\tilde{\vect{y}}(\check{z})$.

Now, we consider 5 specific sample points in the mesh grid, shown in Figure 9 with different colors.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure9.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Five Sample Points on Mesh Grid
</center>

<br>

Utilizing what we learned above and give a guess to the energy function shapes of these five points, with respect to different choices of latent variable $z$ on the manifold. Exactly, the blue point will likely have energy function with the largest magnitude, and thus the largest free energy among the 5, and the orange point will likely have the smallest free energy.

The complete look of five energy functions given as following in Figure10, the cross signs represent the values of $\check{z}$ for each specific energy function.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure10.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Energy Functions for the Five Points
</center>

<br>

Continuing the above example, we should note that our Free Energy Function, $F_\infty$, only takes non-negative scalar values for its range (because we are using Euclidean distance for $E(\vect{y},z)$), and the domain of our Free Energy Function, $F_\infty$, is $\mathbb{R}^2$ (only the $\vect{y}$ space), so generally we have $F_\infty :\mathbb{R}^2 \rightarrow \mathbb{R}^+$. We now use the free energy values as our inference to plot the above mesh grid as the following heat map, shown in Figure 11. To be noted, arrows represent gradient values.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure11.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Free Energy Heat Map
</center>

<br>

To sum up, we only discuss a single example of Free Energy here. In real circumstances, we will have much wider choices of latent variables, $z$, rather than the only choice of ellipse manifold in our example. However, we need to keep in mind that the free energy value, $F_\infty$, is not dependent on the latent variable at all.
-->

## [Estimation de la densité d'énergie libre](https://www.youtube.com/watch?v=sbhr2wjU1-I&t=2241s)

Pour mieux comprendre la fonction d’énergie libre, nous commençons par l'exemple présenté à la figure 8.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure8.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 8 :</b> Exemple d'énergie libre dans une grille de maille
</center>
<br>

Pour calculer l'énergie libre, $F_\infty$, à chaque point de la grille de maille par rapport à la variété en bleue (qui est également l'ensemble des choix possibles des variables latentes $z$), nous rappelons d'abord la définition de la fonction d'énergie libre ci-dessous :

$$
F_\infty = \min_z E(\vect{y},z) = E(\vect{y},\check{z}).
$$

Étant donné la formule de la fonction énergie $E(\vect{y},z)$ et un emplacement (un échantillon) $\vect{y}$, notre processus de minimisation commence par l'inférence qui est exactement le processus pour trouver la variable latente $\check{z}$ générant notre emplacement le plus probable. 
Sur le graphique de la figure 8, nous commençons par un point arbitraire $z$ sur la variété en bleue, puis nous nous déplaçons autour pour trouver sur la variété le point $\check{z}$ qui est le plus proche de notre emplacement $\vect{y}$. 
Par conséquent, l'énergie libre est la distance euclidienne entre notre point d'échantillonnage $\vect{y}$ et le point choisi $\tilde{\vect{y}}(\check{z})$.

Maintenant, nous considérons 5 points échantillons spécifiques dans la grille de maille, illustrés sur la figure 9 avec des couleurs différentes.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure9.png" style="zoom: 100%; background-color:#DCDCDC;" /><br> 
<b>Figure 9 :</b> Cinq points d'échantillonnage sur la grille de maille
</center>
<br>

Utilisons ce que nous avons appris ci-dessus et donnons une estimation des formes de la fonction d’énergie pour ces cinq points, par rapport aux différents choix de la variable latente $z$ sur la variété. 
Le point bleu est probablement la fonction d’énergie avec la plus grande magnitude et donc la plus grande énergie libre parmi les 5. Le point orange a probablement la plus petite énergie libre.

L'aspect complet des cinq fonctions d’énergie est donné comme suit dans la figure 10. Les signes en croix représentent les valeurs de $\check{z}$ pour chaque fonction d’énergie spécifique.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure10.png" style="zoom: 100%; background-color:#DCDCDC;" /><br> 
<b>Figure 10 :</b> Fonctions d’énergie pour les cinq points
</center>
<br>

En poursuivant l'exemple ci-dessus, nous devons noter que notre fonction d'énergie libre, $F_\infty$, ne prend que des valeurs scalaires non négatives pour son domaine (car nous utilisons la distance euclidienne pour $E(\vect{y},z)$). Le domaine de notre fonction d'énergie libre, $F_\infty$, est $\mathbb{R}^2$ (seulement l'espace $\vect{y}$), donc généralement nous avons $F_\infty : \mathbb{R}^2 \rightarrow \mathbb{R}^+$. 
Nous utilisons maintenant les valeurs d'énergie libre comme inférence pour tracer la grille de maille comme la carte thermique illustrée à la figure 11. À noter que les flèches représentent les valeurs de gradient.

<center>
<img src="{{site.baseurl}}/images/week15/15-1/Figure11.png" style="zoom: 100%; background-color:#DCDCDC;" /><br>
<b>Figure 11 :</b> Carte thermique de l’énergie libre
</center>
<br>

Pour résumer, nous ne discutons ici que d'un seul exemple d'énergie libre. Dans des circonstances réelles, nous aurons un choix beaucoup plus large de variables latentes $z$, plutôt que le seul choix de multiples ellipses dans notre exemple. 
Cependant, nous devons garder à l'esprit que la valeur de l'énergie libre, $F_\infty$, ne dépend pas du tout de la variable latente.


<!--
## Comprehension Questions and Answers

#### Question 1: Why is the energy surface scalar-valued?

Energy surface, which takes the value of free energy, $F_\infty$, is exactly the minimum value of our energy function $E(\vect{y},z)$ across all possible latent variables, $z$. Therefore, $F_\infty$ is not dependent on $z$, but only on $\vect{y}$, which outputs a scalar value for each choice of $\vect{y}$.

Considering the mesh grid example above, the mesh grid has $17\times 25 = 425$ points, so we will have 425 free energy values, and each value is the quadratic Euclidean distance from each point to the manifold.

#### Question 2: How do you choose the function to represent the data manifold?

There are numerous researches about choices of the latent variable, and we may have a few layers of Neural Networks to represent the choices of latent variables.

One typical example is language translation. We can translate a sentence in different ways, and we may not use a softmax function for our model training as there will be infinitely many possible resulted sentences after translation. Therefore, we can use EBM here, and the energy function will tell how compatible is between our original sentence and translated sentence.

#### Question 3: Does minimizing energy regarding the trained manifold basically mean denoising?

If the model has learnt from the real manifold, then you can find the denoised version of your input by minimizing energy.
-->

## Réponses aux questions des étudiants
**Question 1 : Pourquoi la surface énergétique est-elle évaluée de manière scalaire ?**
> La surface énergétique, qui prend la valeur de l'énergie libre $F_\infty$, est exactement la valeur minimale de notre fonction d’énergie $E(\vect{y},z)$ parmi toutes les variables latentes $z$ possibles. Par conséquent, $F_\infty$ ne dépend pas de $z$, mais seulement de $\vect{y}$, qui produit une valeur scalaire pour chaque choix de $\vect{y}$. En considérant l'exemple de maillage ci-dessus, celui-ci a $17\times 25 = 425$ points. Nous avons donc 425 valeurs d'énergie libre et chaque valeur est la distance euclidienne quadratique de chaque point de la variété.

**Question 2 : Comment choisir la fonction pour représenter la variété ?**
> Il existe de nombreuses recherches sur les choix de la variable latente et nous pouvons avoir quelques couches de réseaux de neurones pour représenter les choix des variables latentes. Un exemple typique est celui de la traduction linguistique. Nous pouvons traduire une phrase de différentes manières et nous ne pouvons pas utiliser une fonction softmax pour l'entraînement de notre modèle car il y aura une infinité de phrases possibles après la traduction. Par conséquent, nous pouvons utiliser ici l'EBM et la fonction d'énergie nous dit dans quelle mesure la phrase originale et la phrase traduite sont compatibles.

**Question 3 : Est-ce que la minimisation de l'énergie par rapport à la variété entraînée signifie-t-elle débruitage ?**
> Si le modèle a tiré des leçons de la variété réelle, vous pouvez trouver la version débruitée de votre entrée en minimisant l'énergie.
