---
lang: fr
lang-ref: ch.14-3
title: Surentraînement et régularisation
lecturer: Alfredo Canziani
authors: Karl Otness, Xiaoyi Zhang, Shreyas Chandrakaladharan, Chady Raach
date: 5 May 2020
translation-date: 31 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Overfitting](https://www.youtube.com/watch?v=DL7iew823c0&t=101s)

Consider a regression problem. A model could underfit, right-fit, or overfit.

If the model is insufficiently expressive for the data it will underfit. If the model is more expressive than the data (as is the case with deep neural networks), it runs the risk of overfitting.

In this case, the model is powerful enough to fit both the original data *and* the noise, producing a poor solution for the task at hand.

Ideally we would like our model to fit the underlying data and not the noise, producing a good fit for our data. We would especially like to do this without needing to reduce the power of our models. Deep learning models are very powerful, often much more than is strictly necessary in order to learn the data. We would like to keep that power (to make training easier), but still fight overfitting.
-->

## [Surentraînement](https://www.youtube.com/watch?v=DL7iew823c0&t=101s)

Considérez un problème de régression. Un modèle peut être sousentraîné, bien entraîné ou surentraîné.

Si le modèle n'est pas suffisamment expressif pour les données, il sera sousentraîné. Si le modèle est plus expressif que les données (comme c'est le cas pour les réseaux neuronaux profonds), il risque de surentraîner.

Dans ce cas, le modèle est suffisamment puissant pour s'adapter à la fois aux données d'origine *et* au bruit, ce qui produit une mauvaise solution pour la tâche à accomplir.

Dans l'idéal, nous aimerions que notre modèle s'adapte aux données sous-jacentes et non au bruit, ce qui produirait un bon entraînement de nos données. Nous aimerions surtout le faire sans avoir besoin de réduire la puissance de nos modèles. Les modèles d'apprentissage profond sont très puissants, souvent bien plus que ce qui est strictement nécessaire pour apprendre les données. Nous aimerions conserver cette puissance (pour faciliter l'entraînement) mais tout en luttant contre le surentraînenement.

<!--
### Overfitting for debugging

Overfitting can be useful in some cases, such as during debugging. One can test a network on a small subset of training data (even a single batch or a set of random noise tensors) and make sure that the network is able to overfit to this data. If it fails to learn, it is a sign that there may be a bug.
-->

### Surentraînement pour le débogage

Le surentraînement peut être utile dans certains cas, par exemple lors du débogage. On peut tester un réseau sur un petit sous-ensemble de données d'entraînement (même un seul batch ou un ensemble de tenseurs de bruit aléatoire) et s'assurer que le réseau est capable de sur-entraîner sur ces données. S'il ne parvient pas à apprendre, c'est le signe qu'il y a peut-être un bogue.

<!--
## Regularization

We can try to fight overfitting by introducing regularization. The amount of regularization will affect the model's validation performance. Too little regularization will fail to resolve the overfitting problem. Too much regularization will make the model much less effective.

*Regularization* adds prior knowledge to a model; a prior distribution is specified for the parameters. It acts as a restriction on the set of possible learnable functions.

Another definition of regularization from Ian Goodfellow:
> Regularization is any modification we make to a learning algorithm that is intended to reduce its generalization error but not its training error.
-->

## Régularisation

Nous pouvons essayer de lutter contre le surentraînement en introduisant une régularisation. L'ampleur de la régularisation aura une incidence sur les performances de validation du modèle. Une régularisation trop faible ne résoudra pas le problème du surentraînement. Trop de régularisation rendra le modèle beaucoup moins efficace.

La *régularisation* ajoute des connaissances préalables à un modèle, une distribution préalable est spécifiée pour les paramètres. Elle agit comme une restriction sur l'ensemble des fonctions pouvant être apprises.

Une autre définition de la régularisation de Ian Goodfellow : « la régularisation est toute modification que nous apportons à un algorithme d'apprentissage visant à réduire son erreur de généralisation mais pas son erreur d'entraînement ».


<!--
### [Initialization techniques](https://www.youtube.com/watch?v=DL7iew823c0&t=1091s)

We can select a prior for our network parameters by initializing the weights according to a particular distribution. One option: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).
-->

### [Techniques d'initialisation](https://www.youtube.com/watch?v=DL7iew823c0&t=1091s)

Nous pouvons sélectionner un préalable pour les paramètres de notre réseau en initialisant les poids selon une distribution particulière. Une option : l'[initialisation de Xavier](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).

<!--
### Weight decay regularisation

Weight decay is our first regularisation technique. Weight decay is in widespread use in machine learning, but less so with neural networks.  In PyTorch, weight decay is provided as a parameter to the optimizer (see for example the `weight_decay` parameter for [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).

This is also called:

- L2
- Ridge
- Gaussian prior

We can consider an objective which acts on the parameters:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

then we have updates:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

For weight decay we add a penalty term:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

This new term in the update drives the parameters $\theta$ slightly toward zero, adding some "decay" in the weights with each update.
-->

### Régularisation du taux de décroissance des poids

Le taux de décroissance des poids (*weight decay*) est notre première technique de régularisation. Elle est largement utilisée dans l'apprentissage machine, mais moins dans les réseaux de neurones. Dans PyTorch, cela est fourni comme paramètre à l'optimiseur (voir par exemple le paramètre `weight_decay` pour [`SGD`](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).

Ce paramètre est également appelé :
- L2
- *Ridge*
- *Gaussian prior*

On peut envisager un objectif qui agit sur les paramètres :

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

puis nous avons des mises à jour :

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

Pour le taux de décroissance des poids, nous ajoutons un terme de pénalité :

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

qui produit une mise à jour :

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$


Ce nouveau terme dans la mise à jour conduit les paramètres $\theta$ légèrement vers 0, en ajoutant une certaine décroissance dans les poids à chaque mise à jour.


<!--
### L1 regularisation

Available as an option for PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html).

Also called:

- LASSO: Least Absolute Shrinkage Selector Operator
- Laplacian prior
- Sparsity prior

Viewing this as a Laplace distribution prior, this regularization puts more probability mass near zero than does a Gaussian distribution.

Starting with the same update as above we can view this as adding another penalty:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

Unlike $L_2$ weight decay, the $L_1$ regularization will "kill" components that are close to an axis in the parameter space, rather than evenly reducing the length of the parameter vector.
-->

### Régularisation L1

Disponible en option pour PyTorch [optimiseurs](https://pytorch.org/docs/stable/optim.html).

Aussi appelé :

- *LASSO*
- *Laplacian prior*
- *Sparsity prior*

En considérant cela comme une distribution de Laplace antérieure, cette régularisation met plus de masse de probabilité près de $0$ que ne le fait une distribution gaussienne.

En commençant avec la même mise à jour que ci-dessus, nous pouvons considérer que cela ajoute une autre pénalité :

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

qui produit une mise à jour :

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

Contrairement au taux de décroissance $L_2$, la régularisation $L_1$ « tuera » les composantes qui sont proches d'un axe dans l'espace de paramètres, plutôt que de réduire de manière égale la longueur du vecteur de paramètres.

<!--
### Dropout

Dropout involves setting a certain number of neurons to zero randomly during training. This prevents the network from learning a singular path from input to output. Similarly, due to the large parametrisation of neural networks, it is possible for the neural network to effectively memorize the input. However, with dropout, this is a lot more difficult since the input is being put into a different network each time since dropout effectively trains a infinite number of networks that are different each time. Hence, dropout can be a powerful way of controlling overfitting and being more robust against small variations in the input.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 1: Network without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 2: Network with dropout
</center>

In PyTorch, we can set a random dropout rate of neuron.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
Figure 3: Dropout code
</center>

After training, during inference, dropout is not used any more. In order to create the final network for inference, we average over all of the individual networks created during dropout and use that for inference. We can similarly multiply all of the weights by $1/1-p$ where $p$ is the dropout rate.
-->

### *Dropout*

Le *dropout* consiste à mettre à $0$ un certain nombre de neurones de façon aléatoire pendant l'entraînement. Cela empêche le réseau d'apprendre un chemin singulier de l'entrée à la sortie. De même, en raison de la grande paramétrisation des réseaux de neurones, il est possible pour le réseau de neurones de mémoriser efficacement l'entrée. Cependant, avec le *dropout*, cela est beaucoup plus difficile car l'entrée est mise dans un réseau différent à chaque fois, puisque le *dropout* entraîne effectivement un nombre infini de réseaux qui sont différents à chaque fois. Par conséquent, le *dropout* peut être un moyen efficace de contrôler le surentraînement et d'être plus résistant aux petites variations de l'entrée.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC ;" /><br>
  <b> Figure 1 :</b> Réseau sans dropout
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC ;" /><br>
<b> Figure 2 :</b> Réseau avec dropout
</center>

Dans PyTorch, nous pouvons fixer un taux de *dropout* aléatoire des neurones.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDCDC ;" /><br>
<b> Figure 3 :</b> Code pour le dropout
</center>

Après l'entraînement, lors de l'inférence, le *dropout* n'est plus utilisé. Afin de créer le réseau final pour l'inférence, nous faisons la moyenne de tous les réseaux individuels créés pendant le *dropout* et nous l'utilisons pour l'inférence. Nous pouvons également multiplier tous les poids par $1/(1-p)$, où $p$ est le taux de *dropout*.


<!--
### Early-stopping

During training, if the validation loss starts increasing, we can stop training and use the best weights found so far. This prevents the weights from growing too much which will start hurting validation performance at some point. In practise, it is common to calculate the validation performance at certain intervals and stop after a certain number of validation error calculations stop decreasing.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
Figure 4: Early stopping
</center>
-->


### Arrêt anticipé

Pendant l'entraînement, si la perte de validation commence à augmenter, nous pouvons arrêter l'entraînement et utiliser les meilleurs poids trouvés jusqu'à présent. Cela permet d'éviter que les poids n'augmentent trop, ce qui commencerait à nuire aux performances de validation à un moment donné. En pratique, il est courant de calculer la performance de validation à certains intervalles et de s'arrêter après qu'un certain nombre de calculs d'erreurs de validation aient cessé de diminuer.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDCDC ;" /><br>
<b> Figure 4 :</b> Arrêt anticipé
</center>

<!--
# Fighting overfitting indirectly

There are techniques that have the side-effect of regularizing parameters but are not regularisers themselves.
-->

# Lutter indirectement contre le surentraînement

Il existe des techniques qui ont pour effet secondaire de régulariser les paramètres mais qui ne sont pas elles-mêmes des régulariseurs.


<!--
## Batch-norm

Q. How does batch norm make training more efficient?
A. We can use higher learning rate when applying batch norm.

Batch normalization is used to prevent the internal covariate shift of a neural network but there is a lot debate if it actually does this and what the true benefit actually is.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
Figure 5: Batch normalization
</center>

Batch normalisation essentially extends the logic of normalizing the input of the neural network to normalizing the input of each hidden layer in the network. The basic idea is to have a fixed distribution feed each subsequent layer of a neural network since learning occurs best when we have a fixed distribution. To do this, we compute the mean and variance of each batch before each hidden layer and normalize the incoming values by these batch specific statistics, which reduces the amount by which the values will ultimately shift around during training.

Regarding the regularizing effect, due to each batch being different, each sample will be normalized by slightly different statistics based upon the batch it is in.  Hence, the network will see various slightly altered versions of a single input which helps the network learn to be more robust against slight variations in the input and prevent overfitting.

Another benefit of batch normalisation is that training is a lot faster.
-->

## Normalisation par batch

**Comment la normalisation par batch rend-elle l’entraînement plus efficace ?**
> Nous pouvons utiliser un taux d'apprentissage plus élevé lorsque nous appliquons la normalisation par batch. Elle est utilisée pour empêcher le déplacement des covariables internes d'un réseau neuronal, mais la question de savoir si elle permet réellement d'atteindre cet objectif et quel en est le véritable avantage fait l'objet de nombreux débats.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDCDC ;" /><br>
<b> Figure 5 :</b> Batch-normalisation
</center>

> La normalisation par batch étend essentiellement la logique de normalisation de l'entrée du réseau neuronal à la normalisation de l'entrée de chaque couche cachée du réseau. L'idée de base est d'avoir une distribution fixe qui alimente chaque couche suivante d'un réseau neuronal puisque l'apprentissage se fait mieux lorsque nous avons une distribution fixe. Pour ce faire, nous calculons la moyenne et la variance de chaque batch avant chaque couche cachée et nous normalisons les valeurs entrantes par ces statistiques spécifiques aux batchs, ce qui réduit la quantité par laquelle les valeurs vont finalement se déplacer pendant l'entraînement.

> En ce qui concerne l'effet de régularisation, étant donné que chaque batch est différent, chaque échantillon sera normalisé par des statistiques légèrement différentes en fonction du lot dans lequel il se trouve.  Ainsi, le réseau verra différentes versions légèrement modifiées d'une même entrée, ce qui l'aidera à apprendre à être plus robuste contre de légères variations de l'entrée et à éviter le surentraînement.
> Un autre avantage de la *batch normalisation* est que l'entraînement est beaucoup plus rapide.


<!--
### More data

Gathering more data is a easy way to prevent overfitting but can be expensive or not feasible.
-->

### Plus de données

La collecte de données supplémentaires est un moyen facile d'éviter le surentraînement mais peut être coûteuse ou impossible.

<!--
### Data-augmentation

Transformations using Torchvision can have a regularizing effect by teaching the network to learn how to be insensitive to perturbations.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
Figure 6: Data augmentation with Torchvision.
</center>
-->

### L’augmentation de données

Les transformations réalisées à l'aide de Torchvision peuvent avoir un effet régulariseur en apprenant au réseau à être insensible aux perturbations.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
<b> Figure 6 :</b> L’augmentation de données
</center>



<!--
### Transfer leaning (TF) fine-tuning (FT)

Transfer learning (TF) refers to just training a final classifier on top of a pre-trained network (used in cases of little data generally).

Fine tuning (FT) refers to training partial/full portions of the pre-trained netowrk as well (used in cases where we have a lot of data generally).

Q. Generally, when should we freeze the layers of a pre-trained model?
A. If we have little training data.

4 general cases:
1) If we have little data with similar distributions, we can just do transfer learning.
2) If we have a lot of data with similar distributions we can do fine-tuning in order to improve the performance of the feature extractor as well.
3) If we have a little data and a different distribution we should remove a few of the final trained layers in the feature extractor since they are too specialized.
4) If we have a lot of data and they are from different distributions, we can just train all portions.

Note, we can also use different learning rates for different layers in order to improve performance.

To further our discussion about overfitting and regularisation, let us look at the visualisations below. These visualisations were generated with the code from [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb).

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Loss curves without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Loss curves with dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Effect of regularization on weights
</center>

From Figure 7 and Figure 8, we can understand the dramatic effect that dropout has on generalisation error i.e the difference between the training loss and validation loss. In Figure 7, without dropout there is clear overfitting as the training loss is much lower than the validation loss. However, in Figure 8, with dropout the training loss and validation loss almost continuously overlap indicating that the model is generalising well to the validation set, which serves as our proxy for out-of-sample set. Of course, we can measure the actual out-of-sample performance using a separate holdout test set.

In Figure 9, we observe the effect that regularisation (L1 & L2) have on the weights of the network.

- When we apply L1 regularisation, from the red peak at zero, we can understand that most of the weights are zero. Small red dots closer to zero are the non-zero weights of the model.

- Contrastingly, in L2 regularisation, from the blue peak near zero we can see that most of the weights are close to zero but non-zero.

- When there is no regularisation (lavender) the weights are much more flexible and spread out around zero resembling a normal distribution.
-->

### L'apprentissage par transfert et le *finetuning*

L'apprentissage par transfert (TF pour *Transfert learning*) consiste simplement à entraîner un classifieur final en plus d'un réseau pré-entraîné (utilisé généralement dans les cas où les données sont peu nombreuses).

Le *finetuning* (FT) consiste à entraîner également des parties partielles ou complètes du réseau pré-entraîné (utilisé dans les cas où nous disposons de beaucoup de données en général).

**En général, quand devrions-nous geler les couches d'un modèle pré-entraîné ?**
> Si nous avons peu de données d'entraînement.

4 cas généraux :

* 1) Si nous avons peu de données avec des distributions similaires, nous pouvons simplement faire un apprentissage par transfert.
* 2) Si nous avons beaucoup de données avec des distributions similaires, nous pouvons faire un *finetuning* afin d'améliorer également les performances de l'extracteur de caractéristiques.
* 3) Si nous avons peu de données et une distribution différente, nous devrions supprimer quelques couches finales entraînées dans l'extracteur de caractéristiques car elles sont trop spécialisées.
* 4) Si nous avons beaucoup de données et qu'elles proviennent de différentes distributions, nous pouvons simplement entraîner toutes les parties.

A noter que nous pouvons également utiliser des taux d'apprentissage différents pour les différentes couches afin d'améliorer les performances.

Pour approfondir notre discussion sur le surentraînement et la régularisation, examinons les visualisations ci-dessous. Ces visualisations ont été générées avec le code de la version anglaise de ce [*notebook*](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb). Une version en français est disponible [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/12-regularization.ipynb).

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom : 60% ; background-color:#DCDCDC;" /><br>
<b> Figure 7 :</b> Courbes de perte sans dropout
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom : 60% ; background-color:#DCDCDC;" /><br>
<b> Figure 8 :</b> Courbes de perte avec dropout
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png" style="zoom : 60% ; background-color:#DCDCDC;" /><br>
<b> Figure 9 :</b> Effet de la régularisation sur les poids
</center>


Les figures 7 et 8 nous permettent de comprendre l'effet spectaculaire que le *dropout* a sur l'erreur de généralisation, c'est-à-dire la différence entre la perte d'entraînement et la perte de validation. Dans la figure 7 sans *dropout*, il y a un surentraînement évident car la perte d’entraînement est beaucoup plus faible que la perte de validation. Cependant, dans la figure 8 avec le *dropout*, la perte d’entraînement et la perte de validation se chevauchent presque continuellement ce qui indique que le modèle se généralise bien à l'ensemble de validation nous servant de substitut pour l'ensemble hors échantillon. Bien entendu, nous pouvons mesurer la performance réelle hors échantillon en utilisant un ensemble de tests de résistance distinct.

Dans la figure 9, nous observons l'effet que la régularisation (L1 et L2) a sur les poids du réseau.

- Lorsque nous appliquons la régularisation L1 à partir du pic rouge à $0$, nous pouvons comprendre que la plupart des poids sont nuls. Les petits points rouges plus proches de $0$ sont les poids non nuls du modèle.

- Par contraste, dans la régularisation L2, à partir du pic violet proche de $0$, nous pouvons voir que la plupart des poids sont proches de $0$ mais non nuls.

- Lorsqu'il n'y a pas de régularisation (bleu), les poids sont beaucoup plus souples et s'étalent autour de $0$ comme dans une distribution normale.


<!--
## [Bayesian Neural Networks: estimating uncertainty around predictions](https://www.youtube.com/watch?v=DL7iew823c0&t=2970s)

We care about uncertainty in neural networks because a network needs to know how certain/confident on its prediction.

Ex: If you build a neural networks to predict steering control, you need to know how confident the network's predictions.

We can use a neural network with dropout to get a confidence interval around our predictions. Let us train a network with dropout, $r$ being the dropout ratio.

Usually during inference, we set the network to validation mode and use all neurons to get the final prediction. While doing the prediction, we scale the weights $\delta$ by $\dfrac{1}{1-r}$ to account for dropping neurons during training.

This method gives us a single prediction for each input. However, to get a confidence interval around our prediction, we need multiple predictions for the same input. So instead of setting the network to validation mode during inference, we retain it in training mode *i.e.* still drop neurons randomly and get a prediction. When we predict multiple times using this dropout network, for the same input we will get different predictions depending on the neurons being dropped. We use these predictions to estimate the average final prediction and a confidence interval around it.

In the below images, we have estimated confidence intervals around the predictions of networks. These visualisations were generated with the code from [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). The red line represents the predictions. The purple shaded region around the predictions represent the uncertainty *i.e.* variance of predictions.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Uncertainty Estimation using ReLU activation
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Uncertainty Estimation using Tanh activation
</center>

As you can observe in the above images, these uncertainty estimations are not calibrated. They are different for different activation functions. Noticeably in the images, uncertainty around data points is low. Furthermore, the variance that we can observe is a differentiable function. So we can run gradient descent to minimise this variance. Thereby we can get more confident predictions.
-->

## [Réseaux de neurones Bayésiens : estimer l'incertitude autour des prévisions](https://www.youtube.com/watch?v=DL7iew823c0&t=2970s)

Nous nous soucions de l'incertitude dans les réseaux de neurones car un réseau a besoin de savoir à quel point il est certain/confident de ses prédictions.

Par exemple, si nous construisons un réseau de neurones pour prédire le contrôle de la direction, nous devons connaître le degré de confiance des prédictions du réseau.

Nous pouvons utiliser un réseau de neurones avec *dropout* pour obtenir un intervalle de confiance autour de nos prédictions. Entraînons un réseau avec *dropout*, $r$ étant le taux de *dropout*.

Habituellement, lors de l'inférence, nous mettons le réseau en mode de validation et utilisons tous les neurones pour obtenir la prédiction finale. Tout en faisant la prédiction, nous échelonnons les poids $\delta$ par $\dfrac{1}{1-r}$ pour tenir compte des neurones abandonnés pendant l'entraînement.

Cette méthode nous permet d'obtenir une seule prédiction pour chaque entrée. Cependant, pour obtenir un intervalle de confiance autour de notre prédiction, nous avons besoin de plusieurs prédictions pour la même entrée. Ainsi, au lieu de mettre le réseau en mode validation pendant l'inférence, nous le gardons en mode d'entraînement, c'est-à-dire que nous appliquons toujours le *dropout* sur des neurones de manière aléatoire et obtenons une prédiction. En faisant plusieurs prédictions pour la même entrée avec ce réseau avec *dropout*, nous obtenons des prédictions différentes selon les neurones qui sont *dropés*. Nous utilisons ces prédictions pour estimer la prédiction finale moyenne et un intervalle de confiance autour de celle-ci.

Dans les images ci-dessous, nous avons estimé les intervalles de confiance autour des prédictions des réseaux. Ces visualisations ont été générées avec la version anglaise de ce [notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). Une version en français est disponible [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/13-bayesian_nn..ipynb). La ligne rouge représente les prédictions. La région en violet autour des prédictions représente l'incertitude c'est-à-dire la variance des prédictions.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b> Figure 10 :</b> Estimation de l'incertitude en utilisant l'activation ReLU
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b> Figure 11 :</b> Estimation de l'incertitude en utilisant l'activation Tanh
</center>


Comme vous pouvez l'observer sur les images ci-dessus, ces estimations d'incertitude ne sont pas calibrées. Elles sont différentes pour différentes fonctions d'activation. Sur les images, on remarque que l'incertitude autour des points de données est faible. De plus, la variance que nous pouvons observer est une fonction différentiable. Nous pouvons donc effectuer une descente de gradient pour minimiser cette variance. Nous pouvons ainsi obtenir des prévisions plus fiables.


<!--
#### If we have multiple terms contributing to total loss in our EBM model, how do they interact?

In EBM models, we can simply and conveniently sum the different terms to estimate the total loss.

**Digression**: A term that penalises the length of the latent variable can act as one of many loss terms in a model. The length of a vector is roughly proportional to the number  of dimensions it has. So if you decrease the number of dimensions, then the length of the vector decreases and as a result it encodes less information. In an auto-encoder setting, this makes sure that the model is retaining the most important information. So, one way to bottleneck information in latent spaces is to reduce the dimensionality of the latent space.
-->

#### Si notre EBM comporte plusieurs termes contribuant à la perte totale, comment interagissent-ils ?

Dans les EBMs, nous pouvons simplement et commodément additionner les différents termes pour estimer la perte totale.

**Digression** : un terme qui pénalise la longueur de la variable latente peut agir comme l'un des nombreux termes de perte dans un modèle. La longueur d'un vecteur est à peu près proportionnelle au nombre de dimensions qu'il possède. Ainsi, si nous diminuons le nombre de dimensions, la longueur du vecteur diminue et par conséquent il code moins d'informations. Dans un paramétrage d'auto-encodeur, cela permet de s'assurer que le modèle conserve les informations les plus importantes. Ainsi, une façon de bloquer l'information dans les espaces latents est de réduire la dimensionnalité de l'espace latent.


<!--
#### How can we determine the hyper-parameter for regularisation?

In practice, to determine the optimal hyper-parameter for regularisation i.e regularisation strength we can use

- Bayesian hyper-parameter Optimization
- Grid Search
- Random Search

While doing these searches, the first few epochs are usually enough to give us a sense of how the regularization is working. So we need train the model extensively.
-->

#### Comment déterminer l'hyperparamètre pour la régularisation ?
En pratique, pour déterminer l'hyperparamètre optimal pour la régularisation, c'est-à-dire la force de régularisation, nous pouvons utiliser :
- l'optimisation des hyperparamètres bayésiens
- la recherche par grille
- la recherche aléatoire
Lors de ces recherches, les premières époques sont généralement suffisantes pour nous donner une idée du fonctionnement de la régularisation. Nous devons donc entraîner le modèle de façon intensive.
