---
lang: fr
lang-ref: ch.14-2
lecturer: Yann Le Cun
title: Méthodes graphiques à base d'énergie 
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
translation-date: 14 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Comparing Losses](https://www.youtube.com/watch?v=gYayCG6YyO8&t=3622s)

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center>

In the figure above, incorrect paths have -1.

Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.

In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.

Q: How is the segmentor implemented in the model above?

A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition.
-->

## [Comparer les pertes](https://www.youtube.com/watch?v=gYayCG6YyO8&t=3622s)

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDCDC ;" /><br>
  <b>Figure 1 :</b> Architecture de réseau
</center>

Dans la figure ci-dessus, les chemins incorrects ont une valeur de $-1$.

Yann commence par la perte de perceptron, qui est utilisée dans l'exemple du *Graph Transformer Model* dans la figure ci-dessus. L'objectif est de faire en sorte que l'énergie des mauvaises réponses soit grande et celle des bonnes petites.

En termes de mise en œuvre, nous représenterons les arcs dans la visualisation avec un vecteur. Plutôt qu'un arc séparé pour chaque catégorie, un vecteur contient à la fois les catégories et le score de chaque catégorie.

**Comment le segmenteur est-il implémenté dans le modèle ci-dessus ?**
> Le segmenteur est une heuristique artisanale. Le modèle utilise un segment artisanal bien qu'il y ait un moyen de le rendre entraînable de bout en bout. Cette approche artisanale a été remplacée par l'approche de la fenêtre coulissante pour la reconnaissance des caractères.



<!--
## Overview of Losses

<center>
Table 1: Various Loss Equations
</center>

| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.

* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.

Q: How may hinge be better than NLL loss?

A: Hinge is better than NLL becuase hinge will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m). 
-->

## Aperçu des pertes

<center>
Tableau 1 : Diverses équations de perte
</center>

| Équation de perte | Formule | Marge |
| :---- | :---- : | ---:|
| Perte d'énergie | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | Aucune |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


La perte de perceptron observée dans le tableau ci-dessus n'a pas de marge et donc risque de s'effondrer.

La perte de perceptron consiste à calculer la différence d’énergie entre celle de la réponse la plus offensante et celle de la bonne réponse. Intuitivement, avec une marge m, l’*hinge* aura une perte de $0$ que lorsque l'énergie correcte est inférieure à l'énergie la plus offensante *d'au moins* m.  
La perte MCE est utilisée dans la reconnaissance vocale et ressemble à une sigmoïde.  
La perte NLL vise à rendre l'énergie de la bonne réponse petite et la composante logarithmique de l'équation grande.

**Comment la perte *hinge* peut-elle être meilleure que la perte NLL ?**
> La perte *hinge* est meilleure que la perte NLL parce que NLL essaie de pousser la différence entre la bonne réponse et les autres réponses à l'infini, alors que l'*hinge* veut seulement la rendre plus grande qu'une certaine valeur (la marge m). 


<!--
### Definition :

A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.

Q: What are some examples of problems that can use decoders? 
A: Language modelling, machine translation, and sequence tagging. 
-->

### Définition :

Un décodeur entre une séquence de vecteurs qui indiquent les scores ou l'énergie des différents sons ou images, et choisit la meilleure sortie possible.
Il peut être utile pour tout ce qui est modélisation du langage, traduction automatique et marquage des séquences.


<!--
## Forward algorithm in Graph Transformer Networks
-->

## Algorithme *forward dans* les réseaux  *Graph Transformer Networks*


<!--
### Graph Composition

Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center>

The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.

Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?

The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values. 

If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.

In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.

As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.
-->

### Composition de graphes

La composition de graphes nous permet de combiner deux graphes. Dans cet exemple, nous pouvons voir un lexique de modèle de langage représenté par un $trie$ (un graphe) et un graphe de reconnaissance qui est produit par un réseau de neurones.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2 :</b> Composition de graphes
</center>

Le graphe de reconnaissance spécifie avec différentes valeurs d'énergie (associées à chaque arc) la probabilité qu'un personnage se trouve à une étape particulière.

Maintenant, pour cet exemple, la question à laquelle nous répondons par une opération de composition de graphes est la suivante : quel est le meilleur chemin dans ce graphe qui est également d'accord avec notre lexique ?

Le saut commun de l'étape 1 à l'étape 2 entre le graphe de reconnaissance et la grammaire est le caractère $c$, associé à l'énergie $0,4$. Ainsi, notre graphe d'interprétation ne contient qu'un seul arc entre les étapes 1 et 2 correspondant à $c$. De même, les caractères possibles entre les étapes 2 et 3 sont $x$, $u$ et $a$ dans le graphe de reconnaissance. Les branches suivant $c$ dans le graphe de grammaire contiennent $u$ et $a$. Ainsi, l'opération de composition de graphes permet de repérer les arcs $u$ et $a$ qui doivent être présents dans le graphe d'interprétation. Elle associe également l'arc qu'elle copie du graphe de reconnaissance à leurs valeurs énergétiques. 

Si la grammaire contenait également des valeurs énergétiques associées aux arcs, la composition du graphe aurait ajouté les valeurs d'énergie ou les aurait combinées à l'aide d'un autre opérateur.

De la même manière, la composition des graphes nous permet également de combiner deux bases de connaissances représentées par des réseaux de neurones. Dans l'exemple présenté ci-dessus, la grammaire peut être représentée essentiellement comme un réseau de neurones prédisant le prochain caractère. La sortie softmax du réseau neuronal nous fournit les probabilités de transition vers le caractère suivant à partir d'un nœud donné.

Par ailleurs, si le modèle de langage présenté dans cet exemple est un réseau de neurones, nous pouvons faire une rétropropagation à travers toute la structure. Ceci devient un exemple de programme différenciable où nous faisons une rétropropagation à travers un programme contenant des boucles, des conditions if, des récursions, etc.


<!--
### A check reader from mid-90s

The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center>

This recongnition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.

The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.

Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.
-->

### Un lecteur de chèques du milieu des années 90

L'ensemble de l'architecture d'un lecteur de chèques du milieu des années 1990 est assez complexe, mais ce qui nous intéresse avant tout, c'est la partie partant du reconnaisseur de caractères produisant le graphe de reconnaissance.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3 :</b> Lecteur de chèque
</center>

Ce graphe de reconnaissance subit deux opérations de composition distinctes, la première avec l'interprétation correcte (ou la vérité de base) et la seconde avec la grammaire qui crée un graphe de toutes les interprétations possibles.

L'ensemble du système est entraîné par la fonction de perte de log-vraisemblance négative. La log-vraisemblance négative indique que chaque chemin dans le graphe d'interprétation est une interprétation possible et que la somme des énergies le long de ce chemin est l'énergie de cette interprétation.

Maintenant, au lieu d'utiliser l'algorithme de Viterbi, nous utilisons l'algorithme *forward*. Les sous-sections suivantes traitent des différences entre les deux approches.


<!--
#### Viterbi algorithm

Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.

$$F (x, y) = \min_{z} \; E(x, y, z)$$
-->

#### Algorithme de Viterbi

L'algorithme de Viterbi est un algorithme de programmation dynamique qui est utilisé pour trouver le chemin le plus probable (ou le chemin avec le minimum d'énergie) dans un graphe donné. Il minimise l'énergie par rapport à une variable latente z, où z représente le chemin que nous empruntons dans le graphe.

$$F (x, y) = \min_{z} \ ; E(x, y, z)$$


<!--
#### [The forward algorithm](https://www.youtube.com/watch?v=gYayCG6YyO8&t=4518s)

The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.

The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.

The working of the forward algorithm can be shown using the following example defined on an interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center>


The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.

For the red node, the value of energy at the node is given by:

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$
-->

#### [L'algorithme *forward*](https://www.youtube.com/watch?v=gYayCG6YyO8&t=4518s)

L'algorithme *forward*, quant à lui, calcule le logarithme de la somme des exponentielles de la valeur négative des énergies de tous les chemins. On peut facilement voir cela sous la forme d'une formule ci-dessous :

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

Cela marginalise par rapport à la variable latente $z$ qui définit les chemins dans un graphe d'interprétation. Cette approche calcule la valeur exponentielle de cette somme logarithmique sur tous les chemins possibles vers un nœud particulier. C'est comme si l'on combinait le coût de tous les chemins possibles d'une manière douce et minimale.

L'algorithme *forward* est peu coûteux à mettre en œuvre et ne coûte pas plus cher que l'algorithme de Viterbi. De plus, nous pouvons faire une rétropropagation à travers le nœud de l'algorithme *foward* dans le graphe.

Le fonctionnement de l'algorithme *foward* peut être montré à l'aide de l'exemple suivant défini sur un graphe d'interprétation.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4 :</b> Graphe d'interprétation
</center>


Le coût du nœud d'entrée au nœud rouge est calculé en marginalisant sur tous les chemins possibles atteignant le nœud rouge. Les flèches qui entrent dans le nœud rouge définissent ces chemins possibles dans notre exemple.

Pour le nœud rouge, la valeur de l'énergie au nœud est donnée par :

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

<!--
#### Neural network analogy of forward algorithm

The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term. 

For each node in the interpretation graph, we maintain a variable $\alpha$.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

where $e_{ki}$ is the energy of the link from node $k$ to node $i$. 

$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.

We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>

Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.

The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations.
-->

#### Analogie du réseau neuronal avec l'algorithme *forward*

L'algorithme *forward* est un cas particulier de l'algorithme de propagation des croyances lorsque le graphe sous-jacent est un graphe en chaîne. L'ensemble de l'algorithme peut être considéré comme un réseau neuronal *feed-forward* où la fonction à chaque nœud est le logarithmique de la  somme des exponentielles et un terme d'addition. 

Pour chaque nœud du graphe d'interprétation, nous conservons une variable $\alpha$.

$$ \alpha_{i} = - \ ; \log \ ; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \ ; \exp \, (- \, \beta \ ; (\alpha_k \, + \, e_{ki})) \biggl]$$

où $e_{ki}$ est l'énergie du lien entre le nœud $k$ et le nœud $i$. 

$\alpha_i$ forme l'activation d'un nœud $i$ dans ce réseau de neurones et $e_{ki}$ est le poids entre les nœuds $k$ et le nœud $i$. Cette formulation est algébriquement équivalente aux opérations de somme pondérée d'un réseau neuronal dans le domaine logarithmique.

Nous pouvons effectuer une rétropropagation à travers le graphe d'interprétation dynamique (puisqu'il change d'un exemple à l'autre) sur lequel nous appliquons l'algorithme *forward*. Nous pouvons calculer les gradients de $F(x, y)$ calculés au dernier nœud du graphe avec les poids $e_{ki}$ définissant les bords du graphe d'interprétation.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5 :</b> Lecteur de chèque
</center>

Pour revenir à l'exemple du lecteur de chèque, nous appliquons l'algorithme *forward* sur les deux compositions de graphes et obtenons la valeur énergétique au dernier nœud en utilisant la formule du log de la somme d'exponentielles. La différence entre ces valeurs énergétiques est la perte de log-vraisemblance négative.

La valeur obtenue en appliquant l'algorithme *forward* sur la composition des graphes entre la bonne réponse et le graphe de reconnaissance est la valeur du logarithme de la somme des exponentielles de la bonne réponse. En revanche, la valeur du logarithme de la somme des exponentielles au dernier nœud de la composition des graphes entre le graphe de reconnaissance et la grammaire est la valeur marginale de toutes les interprétations valides possibles.

<!--
# [Lagrangian formulation of Backpropagation](https://www.youtube.com/watch?v=gYayCG6YyO8&t=5573s)

For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.

The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).

To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.

- For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.

This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.

In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.
-->

# [Formulation lagrangienne de la rétropropagation](https://www.youtube.com/watch?v=gYayCG6YyO8&t=5573s)

Pour une entrée $x$ et une sortie cible $y$, nous pouvons formuler un réseau comme un ensemble de fonctions $f_k$ et de poids $w_k$ de sorte que les étapes successives du réseau produisent $z_k$ avec $z_{k+1} = f_k(z_k, w_k)$. Dans un environnement supervisé, l'objectif du réseau est de minimiser $C(z_n, y)$, le coût de la sortie $n^\mathrm{th}$ du réseau, par rapport à la vérité de terrain. Ceci est équivalent au problème de la minimisation de $C(z_n, y)$ par rapport aux contraintes $z_{k+1} = f_k(z_k, w_k)$ et $z_0 = x$.

Le Lagrangien peut être écrit comme :

$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$

où les termes $ \lambda $ désignent les multiplicateurs de Lagrange (voir [ce site](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) (en anglais) pour un rafraîchissement si besoin).

Pour minimiser $\mathcal{L}$, nous devons mettre à zéro les dérivées partielles de $\mathcal{L}$ par rapport à chacun de ses arguments et les résoudre.

- Pour $\lambda$, nous récupérons simplement la contrainte : $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- Pour $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, qui est juste la formule standard de rétropropagation.

Cette approche est née avec Lagrange et Hamilton dans le contexte de la mécanique classique, où la minimisation est supérieure à l'énergie du système et où les termes $\lambda$ désignent les contraintes physiques du système. Par exemple deux boules qui sont forcées de rester à une distance fixe l'une de l'autre car sont attachées par une barre métallique.

Dans une situation où nous devons minimiser le coût $C$ à chaque pas de temps, $k$, le Lagrangien devient :
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.


<!--
# Neural Ordinary Differential Equation
Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).
-->

# Equation différentielle ordinaire (ODE) neuronale 

En utilisant cette formulation de la rétropropagation, nous pouvons maintenant parler d'une nouvelle classe de modèles : les ODEs neuronales. Il s'agit essentiellement de réseaux récurrents où l'état, $z$, au moment $t$ est donné par :
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt $, où $ W$ représente un ensemble de paramètres fixes. Cela peut également être exprimé sous la forme d'une équation différentielle ordinaire (sans dérivée partielle) : $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Entraîner un tel réseau en utilisant la formulation lagrangienne est très simple. Si nous voulons que l'état du système atteigne $y$ dans le temps $T$, nous établissons simplement la fonction de coût comme étant la distance entre $z_T$ et $y$. Un autre objectif du réseau pourrait être de trouver un état stable du système, c'est-à-dire un état qui cesse de changer après un certain point. Mathématiquement, cela équivaut à fixer $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. En général, trouver une solution $y$ à cette équation est beaucoup plus facile que la propagation dans le temps car le réseau n'a pas besoin de se souvenir du gradient par rapport à l'ensemble de la séquence. Il doit seulement minimiser $f$ ou $\lvert f \rvert^2$. Pour plus d'informations sur l'entraînement des ODEs neuronales pour atteindre des points fixes, voir [Le Cun (1988)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).

<!--
# [Variational Inference in terms of Energy](https://www.youtube.com/watch?v=gYayCG6YyO8&t=6522s)
-->

# [Inférence variationnelle en termes d'énergie](https://www.youtube.com/watch?v=gYayCG6YyO8&t=6522s)

<!--
## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.

We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
-->

## Introduction

Pour une fonction d'énergie élémentaire $E(x,y,z)$, si nous voulons marginaliser sur une variable $z$ pour obtenir une perte en termes de seulement $x$ et $y$, $L(x,y)$, nous devons calculer :

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

Si nous multiplions ensuite par $\frac{q(z)}{q(z)}$, nous obtenons :
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

Si nous supposons que $q(z)$ est une distribution de probabilité supérieure à $z$, nous pouvons interpréter notre intégrale de la fonction de perte réécrite comme une valeur attendue, par rapport à la distribution de $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.

Nous utilisons cette interprétation, l'inégalité de Jensen et des approximations basées sur l'échantillonnage pour optimiser indirectement notre fonction de perte.


<!--
## Jensen's Inequality

Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.
-->


## L'inégalité de Jensen

L'inégalité de Jensen indique que si nous avons une fonction convexe alors l'espérance de cette fonction sur un intervalle est inférieure à la moyenne de la fonction évaluée au début et à la fin de l'intervalle. Illustrée géométriquement, cette observation est très intuitive :

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6 :</b> L'inégalité de Jensen
</center>

De même, si $F$ est convexe pour une distribution de probabilité fixe $q$, nous pouvons déduire de l'inégalité de Jensen que sur l'intervalle $z$ :

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

Maintenant, rappelons que notre $L(x,y)$ marginalisée après multiplication avec $\frac{q(z)}{q(z)}$ est :  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$


Si nous faisons $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, nous savons grâce à l’inégalité de Jensen $(1)$ que :

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$ :

Avec une fonction de perte convexe concrète $F(x) = -\log(x)$ :

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

Nous avons maintenant une limite supérieure à notre fonction de perte $L(x,y)$ composée de deux termes que nous comprenons. Le premier terme $\int_z q(z)E(x,y,z)$ est l'énergie *moyenne*. Le second terme $\frac{1}{\beta}\int_z\log(q(z))$ est juste un facteur ($-\frac{1}{\beta}$) multiplié par l'*entropie* de la distribution $q$.

<!--
## What's the point?

We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!

To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.

The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.

Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$.
-->

## Quel est l'intérêt ?

Nous avons maintenant formulé une limite supérieure de manière à éviter les intégrations compliquées, et à la place, nous approximons simplement ces valeurs par un échantillonnage à partir d'une distribution de substitution ($q(z)$), de notre choix !

Pour obtenir la valeur du premier terme de notre fonction de limite supérieure, nous échantillonnons simplement à partir de cette distribution et calculons la valeur moyenne de $L$ que nous obtenons en appliquant nos $z$ échantillonnés.

Le second terme (un facteur d'entropie) est juste une propriété de la famille de distribution et peut également être approximé avec un échantillonnage aléatoire de $q$.

Enfin, nous pouvons minimiser $L$ par rapport à ses paramètres (par exemple, les poids d'un réseau $W$), en minimisant cette fonction qui délimite $L$ ci-dessus. Nous effectuons cette minimisation en mettant à jour nos deux variables : (1) l'entropie de $q$ et (2) les paramètres de notre modèle $W$.


<!--
## Summary
This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about.
-->

## Résumé

Ceci est la vue énergétique de l'inférence variationnelle. Si nous devons calculer le logarithme d'une somme d'exponentielles, remplaçons-le par la moyenne de votre fonction plus un terme d'entropie. Cela nous donne une limite supérieure. Nous minimisons ensuite cette limite supérieure et, ce faisant, nous minimisons la fonction qui nous intéresse réellement.
