---
lang: fr
lang-ref: ch.14-1
lecturer: Yann Le Cun
title: Apprentissage profond pour une prédiction utilisant la structure
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
translation-date: 14 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Structured Prediction](https://www.youtube.com/watch?v=gYayCG6YyO8&t=25s)

It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values.
For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain.
-->

## [Prédiction utilisant la structure](https://www.youtube.com/watch?v=gYayCG6YyO8&t=25s)

Nous sommes dans le cas de la prédiction de la variable $y$ pour une entrée $x$ donnée qui est mutuellement dépendante et contrainte plutôt que des valeurs scalaires discrètes ou réelles. Alors la variable de sortie n'appartient pas à une seule catégorie mais peut avoir des valeurs possibles exponentielles ou infinies.
Par exemple, dans le cas de la reconnaissance de la parole/écriture ou de traduction en langage naturel, la sortie doit être grammaticalement correcte et il n'est pas possible de limiter le nombre de possibilités de sortie. La tâche du modèle est de capturer la structure séquentielle, spatiale ou combinatoire dans le domaine du problème.



<!--
### Early works on structured prediction

This vector is fed to a TDNN which gives a feature vector which in case of model systems can be compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used.

The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center>

This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance.

To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every incorrect answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients.
-->

### Premiers travaux sur la prédiction utilisant la structure

Ce vecteur est transmis à un réseau de neurones à retard temporel (TDNN pour *Time Delay Neural Network*) qui donne un vecteur de caractéristiques qui, dans le cas de systèmes de modèles, peut être comparé au softmax représentant une catégorie. Un problème qui se pose dans le cas de la reconnaissance de la parole est que différentes personnes peuvent prononcer le même mot de différentes manières et à des vitesses différentes. Pour résoudre ce problème, on utilise la déformation temporelle dynamique (DTW pour *Dynamic Time Warping*).

L'idée est de fournir au système un ensemble de patrons pré-enregistrés qui correspondent à des vecteurs de séquences ou de caractéristiques qui ont été enregistrés par quelqu'un. Le réseau neuronal est entraîné en même temps que le patron afin que le système apprenne à reconnaître le mot pour différentes prononciations. La variable latente nous permet de modifier le vecteur de caractéristique de manière à ce qu'il corresponde à la longueur des modèles.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDCDC ;" /><br>
  <b>Figure 1 :</b> Schéma du modèle
</center>

Cela peut être visualisé sous forme de matrice en organisant les vecteurs de caractéristiques du TDNN horizontalement et les modèles de mots verticalement. Chaque entrée dans la matrice correspond à la distance entre les vecteurs de caractéristiques. Cela peut être visualisé comme un problème de graphe où le but est de partir du coin inférieur gauche et d'atteindre le coin supérieur droit en parcourant le chemin qui minimise la distance.

Pour entraîner ce modèle à variable latente, nous devons rendre l'énergie pour les bonnes réponses aussi petite que possible et plus grande pour chaque mauvaise réponse. Pour ce faire, nous utilisons une fonction objectif qui prend des patrons pour les mots incorrects, les repousse loin de la séquence actuelle des caractéristiques et rétropropage les gradients.



<!--
## Energy based factor graphs

The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The benefit of these models is that efficient inference algorithms can be employed.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center>
-->

## Graphes factoriels à base d'énergie 

L'idée derrière les graphes factoriels à base d'énergie est de construire un EBM dans lequel l'énergie est la somme de termes énergétiques partiels ou lorsque la probabilité est un produit de facteurs. L'avantage de ces modèles est que des algorithmes d'inférence efficaces peuvent être utilisés.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDCDC ;" /><br>
<b>Figure 2 :</b> Graphes factoriels à base d'énergie 
</center>


<!--
### Sequence Labeling

The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center>

In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels.
-->

### Etiquetage des séquences

Le modèle prend un signal vocal d'entrée $X$ et sort les labels $Y$ de telle sorte qu'ils minimisent le terme d'énergie total.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDCDC ;" /><br>
<b>Figure 3 :</b> Minimisation de l'énergie
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDCDC ;" /><br>
<b>Figure 4 :</b> Minimisation de l'énergie sous la forme d'un graphe
</center>

Dans ce cas, l'énergie est une somme de trois termes représentés par des carrés bleus qui sont des réseaux de neurones qui produisent des vecteurs de caractéristiques pour les variables d'entrée. Dans le cas de la reconnaissance vocale, $X$ peut être considéré comme un signal vocal, les carrés implémentent les contraintes grammaticales et $Y$ représente les labels de sortie générées.


<!--
## [Efficient Inference for Energy-Based Factor Graphs](https://www.youtube.com/watch?v=gYayCG6YyO8&t=1086s)

A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):

Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center>

A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding:

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations).

However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence,
there is no need for more than $2 + 4 + 4 + 6 = 16$ single factor evaluations.

Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom).

The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general.

To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$.


The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure.

However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent algorithm such as simulated annealing could be used.
-->

## [Inférence efficiente pour les graphes factoriels à base d'énergie](https://www.youtube.com/watch?v=gYayCG6YyO8&t=1086s) 

Un tutoriel sur l'apprentissage à base d'énergie est disponible [ici](yann.lecun.com/exdb/publis/pdf/lecun-06.pdf) (Le Cun et al. (2006)).

L'apprentissage et l'inférence avec les modèles à base d'énergie impliquent une minimisation de l'énergie sur l'ensemble des réponses $\mathcal{Y}$ et des variables latentes $\mathcal{Z}$. Lorsque la cardinalité de $\mathcal{Y}\times \mathcal{Z}$ est importante, cette minimisation peut devenir insoluble. Une approche du problème consiste à exploiter la structure de la fonction énergie afin d'effectuer la minimisation de manière efficace. Un cas où la structure peut être exploitée se produit lorsque l'énergie peut être exprimée comme une somme de fonctions individuelles (appelées facteurs) qui dépendent chacune de différents sous-ensembles des variables de $\mathcal{Y}$ et $\mathcal{Z}$. Ces dépendances sont mieux exprimées sous la forme d'un graphe factoriel. Les graphes factoriels sont une forme générale de modèles graphiques ou de réseaux de croyances.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDCDC ;" /><br>
  <b>Figure 5 :</b> Graphes factoriels à base d'énergie
</center>

Un exemple simple de graphe de facteur est présenté à la figure 5 (en haut). La fonction énergie est la somme de quatre facteurs :

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

où $Y = [Y_1, Y_2]$ sont les variables de sortie et $Z = [Z_1, Z_2]$ sont les variables latentes. Chaque facteur peut être considéré comme représentant des contraintes souples entre les valeurs de ses variables d'entrée. Le problème d'inférence consiste à trouver :

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

Supposons que $Z_1$, $Z_2$ et $Y_1$ sont des variables binaires discrètes et que $Y_2$ est une variable ternaire. La cardinalité du domaine de $X$ est sans importance puisque $X$ est toujours observé. Le nombre de configurations possibles de $Z$ et $Y$ étant donné $X$ est de $2 \times 2 \times 2 \times 3 = 24$. Un algorithme de minimisation naïf par recherche exhaustive évaluerait la fonction énergie entière $24$ fois ($96$ évaluations à facteur unique).

Cependant, nous remarquons que pour un $X$ donné, $E_a$ n'a que deux configurations d'entrée possibles : $Z_1 = 0$ et $Z_1 = 1$. De même, $E_b$ et $E_c$ n'ont que 4 configurations d'entrée possibles, et $E_d$ en a $6$, il n'est pas nécessaire d'avoir plus de $2 + 4 + 4 + 6 = 16$ d'évaluations de facteur unique.

Nous pouvons donc précalculer les $16$ valeurs de facteurs et les placer sur les arcs d'un *trellis* comme le montre la figure 5 (en bas).

Les nœuds de chaque colonne représentent les valeurs possibles d'une seule variable. Chaque arc est pondéré par l'énergie de sortie du facteur pour les valeurs correspondantes de ses variables d'entrée. Avec cette représentation, un seul chemin du nœud de départ au nœud d'arrivée représente une configuration possible de toutes les variables. La somme des poids le long d'un chemin est égale à l'énergie totale pour la configuration correspondante. Par conséquent, le problème d'inférence peut être réduit à la recherche du **plus court chemin** dans ce graphe. Ceci peut être réalisé en utilisant une méthode de programmation dynamique telle que l'algorithme de Viterbi ou l'algorithme A*. Le coût est proportionnel au nombre d'arêtes ($16$) qui est exponentiellement plus petit que le nombre de chemins en général.

Pour calculer $E(Y, X) = \min_{z\in Z} E(Y, z, X)$ nous suivons la même procédure mais nous limitons le graphe au sous-ensemble des arcs qui sont compatibles avec la valeur prescrite de $Y$.


La procédure ci-dessus est parfois appelée l'algorithme min-sum et il s'agit de la version logarithmique du domaine du *max-product* traditionnel pour les modèles graphiques. La procédure peut facilement être généralisée aux graphes factoriels où les facteurs prennent plus de deux variables comme entrées et aux graphes factoriels qui ont une structure arborescente au lieu d'une structure de chaîne.

Toutefois, elle ne s'applique qu'aux graphes de facteurs qui sont des arbres bipartites (sans boucles). Lorsque des boucles sont présentes dans le graphe, l'algorithme min-sum peut donner une solution approximative lorsqu'il est répété, ou peut ne pas converger du tout. Dans ce cas, un algorithme de descente tel que l'*annealing* simulé peut être utilisé.


<!--
## Simple Energy-Based Factor Graphs with “Shallow” Factors

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center>

The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about)

Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$

And then we can think about like what type of loss function. Here comes several different models.
-->

## Graphes factoriels simples à base d'énergie avec facteurs peu profonds

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDCDC ;" /><br>
  <b> Figure 6 :</b> Graphe factoriel pour des modèles à structure linéaire
</center>

Chaque facteur dans la figure 6 est une fonction de paramètres entraînables dépendant de $X$ et d'une paire de labels individuels $(Y_m, Y_n)$. En général, chaque facteur peut dépendre de plus de deux labels individuels mais nous limitons la discussion aux facteurs par paires pour simplifier la notation :

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Ici, $\mathcal{F}$ désigne l'ensemble des facteurs (l'ensemble des paires de labels individuels qui ont une interdépendance directe), $W_{m n}$ est le vecteur de paramètre pour le facteur $(m, n),$ et $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ est un vecteur de caractéristique (fixe). Le vecteur paramètre global $W$ est la concaténation de tous les $W_{m n}.$

On peut alors réfléchir au type de la fonction de perte. Voici plusieurs modèles différents.


<!--
### Conditional Random Field

We can use the negative log-likelihood loss function to train a linear structured model.

This is the Conditional Random Field

The intuition is we want the energy of the correct answer to below and want the log of exponential for all the answers, including the good one, to be large.

Below is the formal definition for the negative log-likelihood loss function:

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$
-->

### Champ aléatoire conditionnel

Nous pouvons utiliser la fonction de perte de log-vraisemblance négative pour entraîner un modèle  à structure linéaire.

Il s'agit du champ aléatoire conditionnel.

L'intuition est que nous voulons que l'énergie de la bonne réponse soit basse et que le logarithme de l'exponentielle pour toutes les réponses, y compris la bonne, soit grand.

Voici la définition formelle de la fonction de perte de probabilité logarithmique négative :

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$


<!--
### Max Margin Markov Nets and Latent SVM

We can also using the Hinge loss function for optimization.

The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway.

This is the idea behind Max Margin Markov Nets and Latent SVM.
-->

### Réseaux de Markov à marge maximale et les SVMs latentes

Nous pouvons également utiliser la fonction de perte *Hinge* pour l'optimisation. 

L'intuition est que nous voulons que l'énergie de la bonne réponse soit faible. Puis parmi toutes les configurations possibles de réponses incorrectes, nous allons chercher celle qui a l'énergie la plus faible parmi toutes les mauvaises réponses. Nous allons ensuite augmenter l'énergie de celle-ci. Nous n'avons pas besoin d'augmenter l'énergie pour les autres mauvaises réponses parce qu'elles sont de toute façon plus grandes.

C'est l'idée qui sous-tend les réseaux de Markov à marge maximale et les SVMs latentes.


<!--
### Structured Perceptron model

We can train the linear structured model by using perceptron loss.

Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP:

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

where $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ is the answer produced by the system.
-->

### Modèle avec une strcuture perceptron

Nous pouvons entraîner un modèle linéaire en utilisant la perte de perceptron.

Collins (2000 et 2002) a préconisé son utilisation pour les modèles linéaires structurés dans le contexte du traitement du langage naturel :

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

où $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ est la réponse produite par le système.

<!--
#### Early trails on discriminative training for speech/handwritten recognition.

Minimum Empirical Error Loss (Ljolje, and Rabiner 1990):

By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use nerual networks, and have other ways in turning speech signals into sound categories.
-->

#### Premières pistes sur un entraînement discriminant pour la reconnaissance de la parole et de l'écriture

*Minimum Empirical Error Loss* (Ljolje et Rabiner 1990) :
En entraînant au niveau de la séquence, les auteurs n'indiquent pas au système tel ou tel son ou endroit. Ils donnent au système la phrase d'entrée et sa transcription en termes de mots, et demandent au système de la comprendre en faisant une distorsion temporelle. 
Ils n'ont pas utilisé de réseaux de neurones et disposent d'autres moyens pour transformer les signaux vocaux en catégories de sons.

<!--
## Graph Transformer Net

Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works.

We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center>

We run each through the same charecter recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird form of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center>

Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center>

So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path.

Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, neural net is regular and the Path Selector and Viterbi Transformer are basically swtiches that pick a particular edge or not.

So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set  the gradeint for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and wil come back to this later. Then you can backpropagate gradient through the nerual net. That will make the energy of the correct answer small.

What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of nerual net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the suitation where things like PyTorch are really important.

This phrase of backpropagation make the energy of correct answer small. And there's going to be a second phrase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discriminative training for structure prediction that use perceptual loss.

The first stages of phrase two are exactly the same with the first phrase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether is path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phrase one, since the energy get here is the smallest among all possible paths.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figure 10.
</center>

Putting phrase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perception loss.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figure 11.
</center>
-->

## [*Graph Transformer Network* (GTN)](https://www.youtube.com/watch?v=gYayCG6YyO8&t=2610s)

Ici, le problème est que nous avons une séquence de chiffres en entrée et que nous ne savons pas comment faire la segmentation. Nous pouvons néanmoins construire un graphe dans lequel chaque chemin est un moyen de décomposer la séquence de caractères. Nous allons alors trouver le chemin avec la plus faible énergie. En gros cela revient à trouver le chemin le plus court. Voici un exemple concret de la façon dont cela fonctionne.

Nous avons en entrée l'image du nombre 34. On la passe dans le segmenteur et on obtient plusieurs segmentations alternatives. Ces segmentations sont des moyens de regrouper ces blocs de choses. Chaque chemin dans le graphe de segmentation correspond à une façon particulière de regrouper les taches d'encre.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDCDC ;" /><br>
  <b> Figure 7 :</b> Image d'un 34
</center>

Nous passons chaque segment par le même ConvNet de reconnaissance de caractères et obtenons une liste de $10$ scores ($2$ ici mais généralement on en a $10$ représentant les $10$ catégories/chiffres). Par exemple, *1 [0,1]* signifie que l'énergie est de $0,1$ pour la catégorie $1$. On obtient alors un graphe pouvant être considéré comme une forme étrange de tenseur peu dense). C'est un tenseur qui pour chaque configuration possible de cette variable, demande le coût de la variable. Il s'agit davantage d'une distribution sur les tenseurs, ou une distribution logarithmique car nous parlons d'énergies.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDCDC ;" /><br>
  <b> Figure 8 :</b> Graphe d'ensemble
</center>

Si on prend le graphe de la figure 9 et devons calculer l'énergie de la bonne réponse ($34$), nous devons sélectionner dans ces chemins ceux donnant la bonne réponse.  Il y en a deux, l'une est l'énergie $3,4 + 2,4 = 5,8$ et l'autre $0,1 + 0,6 = 0,7$. Il nous reste alors plus qu'à prendre le chemin qui a l'énergie la plus faible. Ici, nous obtenons le chemin avec l'énergie $0,7$.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDCDC ;" /><br>
  <b> Figure 9 :</b> Graphe avec les valeurs d'énergie
</center>

Trouver le chemin est donc comme minimiser sur une variable latente où la variable latente est le chemin choisi. Conceptuellement, il s'agit d'un modèle d'énergie avec une variable latente comme chemin.

Nous avons donc l'énergie du chemin correct, $0,7$. Ce que nous devons faire maintenant, c'est rétropropager le gradient à travers toute cette structure, afin de pouvoir modifier le poids dans le ConvNet de telle sorte que l'énergie finale diminue. Cela semble intimidant, mais c'est tout à fait possible. Comme tout ce système est construit à partir d'éléments que nous connaissons déjà, le réseau neuronal est classique. Le sélecteur de chemin et le *transformer* de Viterbi sont essentiellement des interrupteurs qui choisissent une arête particulière ou non.

Alors comment rétropropager ? Le point $0,7$ est la somme de $0,1$ et $0,6$. Donc, les points $0,1$ et $0,6$ auront tous deux un gradient de $+1$, indiqué entre parenthèses dans la figure 9. Ensuite, le *transformer* de Viterbi n'a qu'à sélectionner un chemin parmi deux. Il suffit donc de copier le gradient pour l'arête correspondante dans le graphe d'entrée et de définir le gradient des autres trajectoires comme étant nulles car non retenues. C'est exactement ce qui se passe dans le *max-pooling* ou le *mean-pooling*. Le sélecteur de trajectoire est le même, c'est juste un système qui sélectionne la bonne réponse. A noter qu'à ce stade, le *3 [0.1] (0)* dans le graphe de la figure 9, deviendrait *3 [0.1] (1)*. Nous pouvons alors rétroprogager le gradient à travers le réseau rendant l'énergie de la bonne réponse faible.

Ce qui est important ici, c'est que cette structure est dynamique. Car si on nous donne une nouvelle entrée, le nombre d'instances du réseau névralgique changera avec le nombre de segmentations et les graphes dérivés changeront également. Nous devons faire une rétropropagation à travers cette structure dynamique. C'est là que des *frameworks* comme PyTorch sont vraiment importantes.

Cette phase de rétropropagation rend l'énergie de la bonne réponse faible. Et il y aura une deuxième phase où nous allons rendre l'énergie de la mauvaise réponse grande. Dans ce cas, nous laissons le système choisir la réponse qu'il veut. Il s'agira d'une forme simplifiée d'entraînement discriminatoire pour la prédiction des structures qui utilisent la perte de perception.

Les premières étapes de la deuxième phase sont exactement les mêmes que celles de la première. Le *transformer* de Viterbi ici choisi simplement le meilleur chemin avec la plus faible énergie. Nous ne nous soucions pas de savoir si ce chemin est correct ou non. L'énergie obtenue ici sera plus petite ou égale à celle obtenue dans la première phase puisque l'énergie obtenue ici est la plus petite de toutes les voies possibles.


<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
  <b> Figure 10 :</b> Raisonnement de la rétropropagation
</center>

En mettant la phase une et deux ensemble, la fonction de perte devrait être $énergie1 - énergie2$. Avant, nous avons introduit la rétropropagation par la partie gauche et maintenant nous devons en fait rétropropager à travers toute la structure. Quel que soit le chemin sur le côté gauche on obtiendra $+1$ et quel que soit le chemin sur le côté droit on obtiendra $-1$. Donc *3 [0,1]* est apparu dans les deux chemins et nous obtenons un gradient nul. Si nous faisons cela, le système fini par minimiser la différence entre l'énergie de la bonne réponse et l'énergie de la meilleure réponse quelle qu'elle soit. La fonction de perte ici est la perte de perceptron.


<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
<b> Figure 11 :</b> Raisonnement de la rétropropagation sur deux chemins
</center>



<!--
## Comprehension Questions and Answers
-->

## Questions des étudiants

<!--
#### Question1: Why is inference easy in the case of energy-based factor graphs?

Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead.
-->

**Pourquoi l'inférence est-elle facile dans le cas des graphes factoriels à base d'énergie ?**
> L'inférence dans le cas d'un EBM avec variable latente implique l'utilisation de techniques exhaustives telles que la descente de gradient pour minimiser l'énergie. Cependant dans ce cas puisque l'énergie est la somme des facteurs, des techniques telles que la programmation dynamique peuvent être utilisées à la place.

<!--
#### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm?

We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference.
-->

**Que faire si les variables latentes des graphes factoriels sont des variables continues ? Peut-on encore utiliser l'algorithme min-sum ?**
> Nous ne le pouvons pas car nous ne pouvons pas rechercher toutes les combinaisons possibles pour toutes les valeurs des facteurs. Cependant, dans ce cas, les énergies nous donnent aussi un avantage car nous pouvons faire des optimisations indépendantes. Comme la combinaison de $Z_1$ et $Z_2$ n'affecte que $E_b$ dans la figure 5. Nous pouvons faire des optimisations indépendantes et une programmation dynamique pour faire l'inférence.

<!--
#### Question3: Are the NN boxes refering to seperate ConvNets?

They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network.
-->

**Les boîtes font-elles référence à des ConvNets séparés ?**
> Elles sont partagées. Ce sont des copies multiples du même ConvNet. Il s'agit simplement d'un réseau de reconnaissance de caractères.
