---
lang: fr
lang-ref: ch.13-1
title: Réseau convolutif pour graphe I
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
translation-date: 25 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)

ConvNets are powerful architectures to solve high-dimensional learning problems.
-->

## [Réseaux convolutifs traditionnels](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)

Les réseaux convolutifs sont des architectures puissantes permettant de résoudre des problèmes d'apprentissage en grandes dimensions.

<!--
### What is the Curse of Dimensionality?

Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10}^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example.

- dim(image) = **1024 x 1024** = ${10}^{6}$
- For **N = 10** samples/dim => **${10}^{1,000,000}$ points**

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: ConvNets extract representation of high-dimensional image data.
</center>
-->

### Qu'est-ce que la malédiction de la dimensionnalité ?

Considérons une image de $1024 \times 1024$ pixels. Cette image peut être considérée comme un point dans l'espace de $1 000 000$ de dimensions. L'utilisation de 10 échantillons par dimension génère ${10}^{1 000 000}$ images, ce qui est extrêmement élevé. Les réseaux convolutifs sont extrêmement puissants pour extraire la meilleure représentation des données d'images en grandes dimensions, comme celle donnée dans l'exemple.

- dim(image) = $1024 \times 1024$ = ${10}^{6}$
- Pour $N = 10$ échantillons/dim => **${10}^{1 000 000}$ points**

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Figure 1 :</b> Les réseaux convolutifs extraient la représentation des données en grandes dimensions des images
</center>


<!--
### Main assumptions about ConvNets:

 **1. Data (images, videos, speech) is compositional.**

It is formed of patterns that are:

* **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.
* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.
* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: Data is compositional.
</center>

**2. ConvNets leverage the compositionality structure.**

They extract compositional features and feed them to classifier, recommender, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: ConvNets leverage the compositionality structure.
</center>
-->

### Principales hypothèses sur les ConvNets :

 **1. Les données (images, vidéos, discours) sont compositionnelles.**

Elles sont formées de motifs qui sont :

* **Locaux** : un neurone du réseau neuronal n'est connecté qu'aux couches adjacentes, mais pas à toutes les couches du réseau. C'est ce que nous appelons l'hypothèse du champ de réception local.
* **Stationnaires** : nous avons des motifs qui sont similaires et qui sont partagés dans tout notre domaine d'image. Par exemple, le drap de lit jaune dans l'image du milieu de la figure 2.
* **Hiérarchiques** : les caractéristiques de bas niveau seront combinées pour former des caractéristiques de niveau moyen. Par la suite, ces éléments de niveau moyen seront combinés pour former des éléments de niveau supérieur.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Figure 2 :</b> Les données sont compositionnelles
</center>

**2. Les ConvNets tirent parti de la compositionnalité de la structure.**

Ils extraient les caractéristiques de composition et les transmettent au classifieur, au recommandeur, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Figure 3 : </b> Les ConvNets tirent parti de la compositionnalité de la structure
</center>



<!--
## Graph Domain
-->

## Domaine du graphe

<!--
### Data Domain

* Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: Images have multiple dimensions.
</center>


* Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: Sequences have single dimension.
  </center>


* These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: Speech data has 1D grid.
  </center>
-->

### Domaine des données

* Les images, volumes, vidéos se situent sur des domaines euclidiens 2D, 3D, 2D+1 (grilles). Chaque pixel est représenté par un vecteur de valeurs rouge, vert et bleu.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Figure 4 :</b> Les images ont de multiples dimensions
</center>


* Les phrases, les mots, la parole se trouvent sur le domaine euclidien 1D. Par exemple, chaque caractère peut être représenté par un entier.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
<b>Figure 5 :</b> Les séquences ont une seule dimension
</center>


* Ces domaines ont de fortes structures spatiales régulières, ce qui permet à toutes les opérations des réseaux convolutifs d'être rapides et mathématiquement bien définies.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
<b>Figure 6 :</b> Les données vocales ont une grille 1D
</center>

<!--
### Graph Domain
-->

### Domaine du graphe

<!--
#### Motivational Examples of graph domains

Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: Social networks by graph representation.
</center>

The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: Brain connectivity by graph representation.
</center>


Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: Quantum chemistry by graph representation.
</center>
-->

#### Exemples de domaine du graphe

Envisageons un réseau social. Le réseau social est mieux capturé par une représentation sous forme de graphe car la connexion par paire entre deux utilisateurs ne forme pas une grille. Les nœuds du graphe représentent les utilisateurs, tandis que les arêtes entre deux nœuds représentent la connexion entre deux utilisateurs. Chaque utilisateur dispose d'une matrice de caractéristiques tridimensionnelles contenant des messages, des images et des vidéos.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Figure 7 :</b> Représentation d'un réseau social sous la forme d'un graphe
</center>

Le lien entre la structure et la fonction du cerveau pour prédire les maladies génétiques neurales offre un exemple de motivation à prendre en considération. Comme on peut le voir ci-dessous, le cerveau est composé de plusieurs régions d'intérêt (ROIs pour *Regions of Interest*). Ces ROIs ne sont connectées que localement à certaines régions d'intérêt environnantes. La matrice d'adjacence représente le degré de force entre les différentes régions d'intérêt.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Figure 8 :</b> Représentation de la connectivité cérébrale sous la forme d'un graphe
</center>


La chimie quantique offre également une représentation intéressante du domaine graphique. Chaque atome est représenté par un nœud dans le graphe et est relié aux autres atomes par des liaisons utilisant des arêtes. Chacun de ces molécules/atomes présente des caractéristiques différentes, telles que la charge associée, le type de liaison, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Figure 9 :</b> Représentation de la chimie quantique sous la forme d'un graphe
</center>

<!--
### Graph Definition and Characteristics

* Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A**


* Graph features:
    * **Node features:** $h_{i}$, $h_{j}$ (atom type)
    * **Edge features:** $e_{ij}$ (bond type)
    * **Graph features:** g (molecule energy)

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: Graph.
</center>
-->

### Définition et caractéristiques des graphes

* Le graphe G est défini par :
    * des **sommets V** (V pour *vertices* en anglais)
    * des **arêtes E** (E pour *edges* en anglais)
    * une **matrice d'adjacence A**


* Les caractéristiques d'un graphe :
    * caractéristiques au niveau d'un nœud : $h_{i}$, $h_{j}$ (ex : un atome)
    * caractéristiques au niveau d'un arête : $e_{ij}$ (ex : une liaison entre atome)
    * caractéristiques au niveau du graphe : g (ex : une molécule)

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Figure 10 :</b> Graphe
</center>

<!--
## [Convolution of Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)
-->

## [Convolution des ConvNets traditionnels](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)

<!--
### Convolution

We abstractly define convolution as:

$$h^{\ell+l} = w^\ell * h^\ell,$$
where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (*e.g.*, 3 for a colored image).\\
So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\
Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\
Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\

For example, in this image, the kernel may be used to recognize lines.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: Kernel can be used to recognize lines in images.
</center>
-->

### Convolution

Nous définissons abstraitement la convolution comme :

$$h^{\ell+l} = w^\ell * h^\ell,$$
où $h^{\ell+1}$ est $n_1\times n_2\times d$-dimensionnel, $w^\ell$ est $3\times 3\times d$-dimensionnel, et $h^\ell$ est $n_1\times n_2\times d$-dimensionnel.
Par exemple, $n_1$ et $n_2$ pourraient être le nombre de pixels dans les directions $x$ et $y$ d'une image, respectivement, et $d$ la dimensionnalité de chaque pixel (par exemple, $3$ pour une image en couleur).
Ainsi, $h^{\ell+1}$ est une caractéristique au niveau de la $(\ell+1)$-ème couche cachée obtenue en appliquant la convolution $w^\ell$ à une caractéristique au niveau de la $\ell$-ème couche.
Habituellement, le noyau est petit pour représenter un champ de réception local ($3\times 3$ ou $5\times 5$ par exemple).
Note : nous utilisons un rembourrage pour nous assurer que les dimensions de $h^{\ell+1}$ sont les mêmes que celles de $h^\ell$.

Par exemple, dans cette image, le noyau peut être utilisé pour reconnaître les lignes.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Figure 11 :</b> Le noyau peut être utilisé pour reconnaître les lignes dans les images
</center>


<!--
### How do we define convolution?

More exactly, convolution is defined as follows:

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

The above defines convolution as *template matching*.\\
We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching.

However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning.

In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$.

The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line.

This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image.

Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids.

The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: Nodes are ordered in the same way.
</center>

If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.
Therefore, $j_3$ will always be in the top right corner of the pattern.

So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.
For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.
Mathematically speaking:

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

and

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

are always for the top right corner between the template and the image patches.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: Image patches match the templates.
</center>
-->

### Comment définir la convolution ?

Plus précisément, la convolution est définie comme suit :

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

Ce qui précède définit la convolution comme l'appariement de patrons/pochoirs (*template matching*).


Nous utilisons généralement $h_{i+j}$ au lieu de $h_{i-j}$, car la première ligne est en fait une corrélation, qui ressemble davantage à l'appariement de patrons.

Cependant, peu importe que nous utilisions la première ou la deuxième ligne car notre noyau est simplement retourné et cela n'a pas d'incidence sur l'apprentissage.

Dans la troisième ligne, nous écrivons simplement $h_{i+j}^\ell$ comme $h_{ij}^\ell$.

Le noyau est très petit donc au lieu d'additionner sur toute l'image $\Omega$, comme dans la deuxième ligne, nous additionnons juste sur le voisinage de la cellule $i$, $\mathcal{N}_i$, comme indiqué dans la troisième ligne.

Cela fait que la complexité de la convolution est de $O(n)$ où $n$ est le nombre de pixels de l'image d'entrée.

La convolution est pour chacun des pixels $n$, en additionnant sur les produits internes des vecteurs de dimension $d$ sur des grilles $3\times 3$.

La complexité est donc de $n\cdot 3\cdot 3\cdot d$, ce qui correspond à $O(n)$. De plus le calcul peut être effectué en parallèle avec les GPUs pour chacun des $n$ pixels.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Figure 12 :</b> Les nœuds sont ordonnés de la même manière
</center>

Si le graphe sur lequel nous effectuons la convolution est une grille, comme dans la convolution standard sur les images en vision par ordinateur, alors les nœuds sont ordonnés comme dans l'image ci-dessus.
Par conséquent, $j_3$ se trouvera toujours dans le coin supérieur droit du graphe.

Ainsi, pour tous les nœuds $i$ dans l'image ci-dessous, comme $i$ et $i'$, l'ordre des nœuds du noyau est toujours le même.
Par exemple, nous comparons toujours $j_3$ dans le coin supérieur droit du motif avec le coin supérieur droit du patch de l'image (ce sur quoi nous effectuons une convolution pour le pixel $i$), comme indiqué ci-dessous.
Mathématiquement parlant :

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

et

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

sont toujours pour le coin supérieur droit entre le modèle et les patchs d'image.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Figure 13 :</b> Les patchs d'image correspondent aux patrons
</center>

<!--
### Can we extend template matching for graphs?

We have a couple of issues:
1. First, in a graph, there is no ordering of the nodes.

So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.
So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\
This is because there is no notion of the *top right corner* of the graph.\\
There is no notion of up, down, left right.\\
Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: No node ordering in a graph.
</center>

2. The second issue is that neighborhood sizes may be different.

So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.
How can we compare these two?

<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Fig. 15</b>: Different neighborhood sizes in a graph.
</center>
-->

### Pouvons-nous étendre l'appariement de patrons aux graphes ?

Nous avons quelques problèmes :
1. Premièrement, dans un graphe, il n'y a pas d'ordre des nœuds.

Ainsi, dans l'image, le nœud $j_3$ n'a pas de position spécifique, mais juste un index (arbitraire).
Donc lorsque nous essayons de faire correspondre les nœuds $i$ et $i'$ dans le graphe ci-dessous, nous ne savons pas si $j_3$ correspond aux mêmes nœuds dans les deux convolutions.
Ceci est dû au fait qu'il n'y a pas de notion de *coin supérieur droit* dans le graphe.
Il n'y a pas de notion de haut, bas, gauche droite.
Ainsi, l'appariement de patrons n'a en fait aucune signification et nous ne pouvons pas l'utiliser directement comme ci-dessus.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Figure 14 :</b> Pas d'ordre des nœuds dans un graphe
</center>

2. Le deuxième problème est que la taille du voisinage peut être différente.

Le modèle $w^\ell$ présenté ci-dessous a 4 nœuds, mais le nœud $i$ a 7 nœuds dans son voisinage.
Comment pouvons-nous comparer ces deux choses ?

<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Figure 15 :</b> Différentes tailles de voisinage dans un graphe
</center>

<!--
## Graph Convolution

We now use the **Convolution Theorem** to define convolution for graphs.

The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms:

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT.
-->

## Convolution pour un graphe

Nous utilisons maintenant le **théorème des convolutions** pour définir les convolutions des graphes.

Le **théorème des convolutions** indique que la transformée de Fourier (FFT) de la convolution de deux fonctions est le produit élément par élément de leurs transformées de Fourier :

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

En général, la transformée de Fourier a une complexité de $O(n^2)$, mais si le domaine est une grille, alors la complexité peut être réduite à $O(n\log n)$ avec la FFT.

<!--
### Can we extend the Convolution theorem to graphs?

This raises two questions:
1. How to define Fourier transforms for graphs?
2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)?

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

We are going to use these two design for graph neural networks:
Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets.
-->

### Peut-on étendre le théorème de la convolution aux graphes ?

Cela soulève deux questions :
1. Comment définir les transformées de Fourier pour les graphes ?
2. Comment calculer des convolutions spectrales rapides en temps $O(n)$ pour les noyaux compacts (comme dans l'appariement de patrons) ?

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

Nous allons utiliser ces deux modèles pour les réseaux de neurones pour graphes. L'appariement de patrons sera utilisé pour les GCNs (ConvNets pour graphe) spatiaux et le théorème de convolution sera utilisé pour les GCNs spectraux.

<!--
## [Spectral Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)

How to perform spectral convolution?
-->

## [GCNs spectraux](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)

Comment effectuer une convolution spectrale ?

<!--
### Step 1 : Graph Laplacian

This is the core operator in spectral graph theory.

Define

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.


The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$.

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and *vice versa*.
-->

### Étape 1 : Graphe Laplacien

C'est l'opérateur central de la théorie des graphes spectraux.

Définir

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { où } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


$A$ est la matrice d'adjacence et le $\Delta$ est le Laplacien, qui est égal à l'identité moins la matrice d'adjacence normalisée par la matrice $D$. $D$ est une matrice diagonale et chaque élément de la diagonale est le degré du nœud. C'est ce qu'on appelle le Laplacien normalisé ou simplement Laplacien par défaut dans ce contexte.


Le Laplacien est interprété comme la mesure de la finesse du graphe, en d'autres termes, la différence entre la valeur locale $h_i$ et sa valeur moyenne de voisinage de $h_j$'s. $d_i$ sur la formule ci-dessous est le degré du nœud $i$, et $\mathcal{N}_{i}$ est l'ensemble des voisins du nœud $i$.

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

La formule ci-dessus consiste à appliquer le Laplacien à une fonction $h$ sur le nœud $i$, qui est la valeur de $h_i$ moins la valeur moyenne sur ses nœuds voisins $h_j$. Fondamentalement, si le signal est très lisse, la valeur de Laplacien est faible et *vice versa*.

<!--
### Step 2 : Fourier Functions

The following is the eigen-decomposition of graph Laplacian,

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$


The Laplacian is factorized into three matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis.

$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$




$\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$


Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$.


$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

The image below is the visualization of eigenvectors of 1D Euclidean Laplacian.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: Grid/Euclidean Domain: eigenvectors of 1D Euclidean Laplacian.
</center>

For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: Graph Domain: Fourier functions of a graph.
</center>
-->

### Étape 2 : Fonctions de Fourier

Voici la décomposition en valeur propre du graphe Laplacien :

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$


Le Laplacien est factorisé en trois matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ est défini ci-dessous, il contient des vecteurs colonnes, ou vecteurs propres de Lap $\phi_1$ à $\phi_n$, chacun de taille $n \times 1$, et ceux-ci sont aussi appelés fonctions de Fourier. Et les fonctions de Fourier forment une base orthonormée.

$$
\begin{array}{l}\text { où } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { et } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$



$\Lambda$ est une matrice diagonale avec des valeurs propres Laplaciennes, et sur la diagonale se trouvent $\lambda_1$ à $\lambda_n$. Et d'après les applications normalisées, ces valeurs sont généralement comprises entre $0$ et $2$. Ces valeurs sont également connues sous le nom de « spectre du graphe ». Voir la formule ci-dessous.

$$
\begin{array}{c}\text { où } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { et } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$


Ci-dessous un exemple de vérification de la décomposition de la valeur propre. La matrice Laplacienne $\Lambda$ est multipliée par un vecteur propre $\phi_k$, la forme du résultat est $n \times 1$ et le résultat est $\lambda_k \phi_k$.


$$
\begin{array}{ll}\text { et } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$


L'image ci-dessous est la visualisation des vecteurs propres du Laplacien euclidien 1D.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Figure 16 :</b> Grille/domaine euclidien : vecteurs propres du Laplacien euclidien 1D.
</center>

Pour le domaine des graphes, de gauche à droite, se trouvent les première, deuxième, troisième, ..., fonctions de Fourier d'un graphe. Par exemple, $\phi_1$ a des oscillations de valeurs positives (rouge) et négatives (bleu), de même pour $\phi2$, $\phi3$. Ces oscillations dépendent de la topologie d'un graphe, qui est liée à la géométrie des graphes tels que les communautés, les hubs, etc, et c'est utile pour le regroupement des graphes. Voir ci-dessous.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Figure 17 :</b> Domaine du graphe : fonctions de Fourier d'un graphe
</center>

<!--
### Step 3 : Fourier Transform

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

**Fourier series: Decompose function $h$ with Fourier functions.**

Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$.

The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series.

**Fourier Transform/ coefficients of Fourier Series**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$


**Inverse Fourier Transform**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$.
-->


### Étape 3 : Transformée de Fourier

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\\N - &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\\N - &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

**Séries de Fourrier : décomposer la fonction $h$ avec les fonctions de Fourier.**

Prendre la fonction $h$ et la projeter sur chaque fonction de Fourier $\phi_k$, ce qui donne le coefficient de la série de Fourier de $k$, une échelle, puis le multiplier par la fonction $\phi_k$.

La transformée de Fourier consiste essentiellement à projeter une fonction $h$ sur les fonctions de Fourier. Les résultats sont les coefficients des séries de Fourier.

**Transformation de Fourier/ coefficients des séries de Fourier**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$


**Transformée de Fourier inverse**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\\\Phi \Phi^{T} h=h \quad \text { car } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


Les transformées de Fourier sont des opérations linéaires, qui multiplient une matrice $\Phi^{T}$ par un vecteur $h$.

<!--
### Step 4 : Convolution Theorem


Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.

The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph.
-->

### Étape 4 : Théorème des convolutions


La transformée de Fourier de la convolution de deux fonctions est le produit élément par élément de leurs transformées de Fourier.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

L'exemple ci-dessus est la convolution de $w$ et $h$, tous deux de forme $n \times 1$, elle est égale à l'inverse de la transformée de Fourier du produit élément par élément entre la transformée de Fourier de $w$ et de $h$. La formule ci-dessus montre qu'elle est également égale à la multiplication matricielle de $\hat{w}(\Delta)$ et de $h$.

La convolution de deux fonctions sur les graphes $h$ et $w$ consiste à prendre la fonction de spectre de $w$, à l'appliquer au Laplacien et à la multiplier par $h$. C'est la définition de la convolution du spectre. Cependant, la complexité du calcul est de $\mathrm{O}\left(n^{2}\right)$, alors que $n$ est le nombre de nœuds du graphe.

<!--
## Limitation

The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.
-->

## Limitation

La convolution spectrale par rapport au domaine du graphe n'est pas une invariance au décalage, ce qui signifie que si elle est décalée, la forme de la fonction peut également être modifiée. Alors que dans le domaine de la grille/euclidienne, elle ne l'est pas.

<!--
## Recommended book

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
-->

## Livre recommandé
*Spectral graph theory* de Fan Chung, (analyse harmonique, théorie des graphes, problèmes combinatoires, optimisation)
