---
lang: fr
lang-ref: ch.12-2
title: Décoder les modèles de langue
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
translation-date: 12 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.

The algorithm selects the best scoring hypothesis.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center>

How deep does the beam tree branch out ?

The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished.

Why (in NMT) do very large beam sizes often results in empty translations?

At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.

Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached.
-->

## [Recherche en faisceau](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

La recherche en faisceau est une autre technique pour décoder un modèle de langue et produire du texte. À chaque étape, l'algorithme garde une trace des $k$ plus probables (meilleures) traductions partielles (hypothèses). Le score de chaque hypothèse est égal à son logarithme de probabilité.

L'algorithme sélectionne la meilleure hypothèse basée sur un score.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Figure 1 : </b> Décodage en faisceau
</center>


**A quelle profondeur l'arbre des faisceaux se ramifie-t-il ?**

L'arbre des faisceaux continue jusqu'à ce qu'il atteigne le *token* de fin de phrase. Une fois le *token* de fin de phrase émis, l'hypothèse est terminée.

**Pourquoi les très grandes tailles de faisceau entraînent-elles souvent des traductions vides ?**

Au moment de l'entraînement, l'algorithme n'utilise souvent pas de faisceau, car c’est très coûteux. Il utilise plutôt la factorisation auto-régressive (en fonction des sorties correctes précédentes, prédire les premiers mots $n+1$). Le modèle n'est pas exposé à ses propres erreurs pendant l'entraînement, il est donc possible que des absurdités apparaissent dans le faisceau.

Résumé : continuer la recherche de faisceau jusqu'à ce que toutes les hypothèses $k$ produisent un *token* de fin ou jusqu'à ce que la limite maximale de décodage $T$ soit atteinte.


<!--
### Sampling

We may not want the most likely sequence. Instead we can sample from the model distribution.

However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops.
-->

### Échantillonnage

Nous ne voulons peut-être pas la séquence la plus probable. Nous pouvons plutôt prélever un échantillon à partir de la distribution du modèle.

Cependant, l'échantillonnage à partir de la distribution du modèle pose son propre problème. Une fois qu'un mauvais choix est échantillonné, le modèle se trouve dans un état auquel il n'a jamais été confronté pendant l’entraînement, ce qui augmente la probabilité qu'une mauvaise évaluation continue. L'algorithme peut donc se retrouver coincé dans d'horribles boucles de rétroaction.


<!--
### Top-K Sampling

A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center>
-->



### Echantillonnage top-k

Une technique d'échantillonnage où l'on tronque la distribution au meilleur $k$, puis on la renormalise et on prélève un échantillon de la distribution.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Figure 2 :</b> Echantillonnage top-k
</center>



<!--
#### Question: Why does Top-K sampling work so well?

This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail.
-->

#### Question : Pourquoi l'échantillonnage top-k fonctionne-t-il si bien ?

Cette technique fonctionne bien parce qu'en utilisant seulement la tête de la distribution et en coupant la queue, elle essaie essentiellement d'éviter de tomber dans la multitude des bonnes langues lorsque nous échantillonnons quelque chose de mauvais.

<!--
## Evaluating Text Generation

Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues.
-->

## Évaluation de la génération de texte

Pour évaluer le modèle linguistique, il suffit d'enregistrer la probabilité des données retenues. Cependant, il est difficile d'évaluer le texte. On utilise généralement des mesures de chevauchement des mots avec une référence (BLEU, ROUGE, etc.), mais elles ont leurs propres problèmes.


<!--
## Sequence-To-Sequence Models
-->
## Modèles de séquence à séquence

<!--
### Conditional Language Models

Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.

Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer
-->

### Modèles de langue conditionnels

Les modèles linguistiques conditionnels ne sont pas utiles pour générer des échantillons d'anglais aléatoires, mais ils sont utiles pour générer un texte à partir d'une entrée.

Exemples :
- A partir d'une phrase française, générer la traduction anglaise
- A partir d'un document, générer un résumé
- Après un dialogue, générer la réponse suivante
- Face à une question, générer la réponse



<!--
### Sequence-To-Sequence Models

Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center>
-->

### Modèles de séquence à séquence

En général, le texte d'entrée est encodé. L’enchâssement résultant est connu sous le nom de « vecteur de pensée », qui est ensuite transmis au décodeur pour générer des *tokens* mot par mot.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Figure 3 :</b> Vecteur de pensée
</center>

<!--
### Sequence-To-Sequence Transformer

The sequence-to-sequence variation of transformers has 2 stacks:

1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input

2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center>

Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models.
-->

### Transformer séquence à séquence

La variation séquence à séquence des *transformers* a 2 piles :

1. Pile d'encodeurs : l'auto-attention n'est pas masquée, de sorte que chaque jeton de l'entrée peut regarder tous les autres jetons de l'entrée

2. Pile de décodeurs : en plus d'utiliser l'auto-attention, l’attention est également appliquée sur toutes les entrées 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Figure 4 :</b> Transformer séquence à séquence
</center>

Chaque jeton de la sortie a un lien direct avec chaque jeton précédent de la sortie, ainsi qu'avec chaque mot de l'entrée. Ces connexions rendent les modèles très expressifs et puissants. Les *transformers* ont permis d'améliorer le score de traduction par rapport aux modèles convolutifs et récurrents précédents.


<!--
## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model.
-->

## [Rétro-traduction](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

Lorsque nous entraînons ces modèles, nous nous appuyons généralement sur de grandes quantités de texte labellisé. Une bonne source de données provient des procédures du Parlement européen où le texte est traduit manuellement dans différentes langues que nous pouvons ensuite utiliser comme entrées et sorties du modèle.

<!--
### Issues

- Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, *i.e.* no input / output pairs?

Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German

- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.

Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:

- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English
-->

### Problèmes

- Toutes les langues ne sont pas représentées au Parlement européen, ce qui signifie que nous n’avons pas de paire de traduction pour toutes les langues qui pourraient nous intéresser. Comment trouver un texte à entraîner dans une langue pour laquelle nous ne pouvons pas nécessairement obtenir les données ?

- Puisque des modèles comme les *transformers* fonctionnent beaucoup mieux avec plus de données, comment utiliser efficacement un texte monolingue, c'est-à-dire sans paires d'entrée/sortie ?

Supposons que nous voulions entraîner un modèle à traduire de l'allemand en anglais. L'idée de la rétro-traduction est d'entraîner d'abord un modèle inverse de l'anglais vers l'allemand.

En utilisant quelques bi-textes limités, nous pouvons acquérir les mêmes phrases dans 2 langues différentes. Une fois que nous aurons un modèle anglais-allemand, on peut traduire beaucoup de mots monolingues de l'anglais vers l'allemand. Enfin, on peut entraîner le modèle anglais-allemand en utilisant les mots allemands qui ont été « retro-traduits » lors de l'étape précédente.

A noter que :
- Peu importe la qualité du modèle inverse nous pouvons avoir des traductions allemandes bruyantes mais nous finissons par traduire en anglais propre.
- Nous devons apprendre à comprendre l'anglais bien au-delà des données des paires anglais/allemand (déjà traduites) / utiliser de grandes quantités d'anglais monolingue.


<!--
### Iterated Back-translation

- We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data
-->

### Retro-traduction itérative

- Nous pouvons itérer la procédure de rétro-traduction afin de générer encore plus de données bi-texte et d'atteindre de bien meilleures performances : il suffit de continuer à s'entraîner en utilisant des données monolingues.
- Cela aide beaucoup quand il n'y a pas beaucoup de données parallèles.

<!--
## Massive multilingual MT

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center>

- Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center>

Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language).
-->

## Traducteur multilingue 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Figure 5 :</b> Traducteur multilingue
</center>

- Au lieu d'essayer d'apprendre une traduction d'une langue à une autre, essayons de construire un réseau neuronal pour apprendre des traductions en plusieurs langues.
- Le modèle permet d'apprendre des informations générales indépendantes de la langue.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Figure 6 :</b> Résultats réseaux de neurones multilingues
</center>

De bons résultats, surtout si nous voulons entraîner un modèle à traduire dans une langue qui n'a pas beaucoup de données disponibles pour nous (langue à faible ressource).

<!--
## Unsupervised Learning for NLP

There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text?
-->
## Apprentissage non supervisé en traitement du langage naturel

Il y a d'énormes quantités de texte sans aucun label et peu de données contrôlées. Que pouvons-nous apprendre sur la langue en lisant simplement un texte non étiqueté ?

<!--
### `word2vec`

Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.

- Goal is to learn vector space representations for words (learn embeddings)

Pretraining task - mask some word and use neighbouring words to fill in the blanks.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center>

For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal.

Take the words and apply a linear projection

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center>

Want to know

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Word embeddings hold some structure

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center>

- The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors
-->

### *Word2vec*

L'intuition est que si des mots apparaissent proches les uns des autres dans le texte, ils sont probablement liés. Nous espérons donc qu'en regardant simplement un texte anglais non labellisé, nous pouvons apprendre ce qu'ils signifient.

- L'objectif est d'apprendre les représentations spatiales vectorielles des mots (apprendre les enchâssements).

Tâche de pré-entraînement : masquer un mot et utiliser les mots voisins pour remplir les blancs.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Figure 7 :</b> Word2vec masquant le visuel
</center>

Par exemple, ici, l'idée est que les « cornes » et les « cheveux argentés » sont plus susceptibles d'apparaître dans le contexte de la « licorne » que d'autres animaux.


En appliquant une projection linéaire sur les mots :

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Figure 8 : </b> Enchâssements de Word2vec
</center>

On veut savoir

$$
p(\texttt{licorne} \mid \texttt{Ces cheveux argentés étaient auparavant inconnus})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n}))
$$

Les enchâssements de mots contiennent une certaine structure :

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Figure 9 : </b> Exemple de structure d’enchâssements
</center>

- L'idée est que si nous prenons la représentation vectorielle de « roi » après l'entraînement et que nous ajoutons celle pour « femelle », nous obtiendrons une représentation très proche de celle de « reine ».



<!--
#### Question: Are the word representation dependent or independent of context?

Independent and have no idea how they relate to other words

#### Question: What would be an example of a situation that this model would struggle in?

Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word.
-->

#### Questions d'étudiants

**Le mot « représentation » dépend-il ou non du contexte ?**
> Indépendant et n'a aucune idée des relations avec d'autres mots.


**Quel serait un exemple de situation dans laquelle ce modèle aurait du mal ?**
> Les enchâssements de mots dépendent fortement du contexte. Ainsi, dans le cas de mots ambigus, des mots qui peuvent avoir des significations multiples, le modèle aura du mal car les vecteurs ne captureront pas le contexte nécessaire pour comprendre correctement le mot.


<!--
### GPT

To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.

- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review

This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks.
-->


### GPT

Pour ajouter du contexte, nous pouvons entraîner un modèle de langue conditionnel. Ensuite, étant donné ce modèle qui prédit un mot à chaque pas de temps, on remplace chaque sortie du modèle par une autre caractéristique.

- Pré-entraînement : prédire le mot suivant
- *Finetuning* : modification d'une tâche spécifique comme par exemple
  - Prédire si un mot est un nom ou un adjectif
  - Prédire le score de sentiment pour une critique de film

Cette approche est bonne car nous pouvons réutiliser le modèle. Nous pré-entraînons un grand modèle et pouvons l'adapter à d'autres tâches.


<!--
### ELMo

GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.

Here the approach is to train _two_ language models

- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context.

This is still a "shallow" combination, and we want some more complex interaction between the left and right context.
-->

### ELMo

Le GPT ne tient compte que du contexte à gauche (du mot qu'il est en train de traiter), ce qui signifie que le modèle ne peut pas dépendre de mots futurs, ce qui limite beaucoup ce que le modèle peut faire.

L'approche consiste ici à entraîner _deux_ modèles de langue :
- un sur le texte de gauche à droite
- un sur le texte de droite à gauche
On peut alors concaténer les résultats des deux modèles afin d'obtenir la représentation des mots. On peut maintenant conditionner le contexte à droite et à gauche.

Il s'agit toujours d'une combinaison superficielle et nous voulons une interaction plus complexe entre les contextes gauche et droit.


<!--
### BERT

BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.

Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now.
-->

### BERT

BERT est similaire à Word2vec dans le sens où nous avons également une tâche de remplissage. Cependant, dans Word2vec, nous avions des projections linéaires, alors que dans BERT, il y a un grand transformer qui est capable de regarder plus de contexte. Pour entraîner, nous masquons 15 % des jetons et nous essayons de prédire ce qui a été masqué.

Il est possible de passer à l'échelle BERT (RoBERTa) en :
- simplifiant l'objectif de pré-entraînement de BERT
- augmentant la taille des batchs
- entraînant sur de grandes quantités de GPU
- entraînant sur encore plus de texte

On obtient alors par exemple une performance supérieure à l'humaine sur la tâche de réponse aux questions.

<!--
## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.

- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order

- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens

- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.

- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.

- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.

The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet


Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training.
-->

## [Pré-entraînement en traitement du langage naturel](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Examinons rapidement les différentes approches de pré-entraînement autosupervisé qui ont été étudiées en en traitement du langage naturel :

- XLNet :
  Au lieu de prédire tous les tokens masqués de façon conditionnelle et indépendante, XLNet prédit les tokens masqués de façon auto-régressive et dans un ordre aléatoire

- SpanBERT
   Les masques s'étendent (séquence de mots consécutifs) au lieu des jetons

- ELECTRA :
  Plutôt que de masquer les mots, nous remplaçons les jetons par des mots similaires. Ensuite, nous résolvons un problème de classification binaire en essayant de prédire si les jetons ont été substitués ou non.

- ALBERT (*A Lite Bert*) :
  Nous modifions BERT et le rendons plus léger en liant les poids entre les couches. Cela réduit les paramètres du modèle et les calculs impliqués. Il est intéressant de noter que les auteurs d'ALBERT n'ont pas eu à faire beaucoup de compromis sur la précision.

- XLM :
  Il s'agit d'un BERT multilingue. Au lieu d'alimenter un texte en anglais, nous alimentons un texte en plusieurs langues. Comme prévu, il a mieux appris les connexions interlinguistiques.


Les principaux enseignements tirés des différents modèles mentionnés ci-dessus sont les suivants :
- De nombreux objectifs de pré-entraînement différents fonctionnent bien !
- Il est essentiel de modéliser les interactions profondes et bidirectionnelles entre les mots
- Des gains importants grâce à l'intensification du pré-entraînement, sans encore de limites claires

La plupart des modèles évoqués ci-dessus sont conçus pour résoudre le problème de la classification de textes. Cependant, pour résoudre le problème de la génération de texte, où nous générons les résultats de manière séquentielle comme le modèle `seq2seq`, nous avons besoin d'une approche légèrement différente du pré-entraînement.


<!--
#### Pre-training for Conditional Generation: BART and T5

BART: pre-training `seq2seq` models by de-noising text

In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.

This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.

BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa.
-->

#### Pré-entraînement pour la génération conditionnelle : BART et T5

BART : pré-entraînement des modèles `seq2seq` par le débruitage de texte.  
Dans BART, pour le pré-entraînement, nous prenons une phrase et la corrompons en masquant des jetons au hasard. Au lieu de prédire les jetons masqués (comme dans l'objectif de BERT), nous donnons toute la séquence corrompue et essayons de prédire toute la séquence correcte.

Cette approche de pré-entraînement `seq2seq` nous donne une certaine flexibilité dans la conception de nos schémas de corruption. Nous pouvons mélanger les phrases, supprimer des expressions, en introduire de nouvelles, etc.

BART a pu faire aussi bien que RoBERTa sur les tâches SQUAD et GLUE. Il établit le nouvel état de l’art sur les jeux de données de résumé, de dialogue et les questions/réponses. BART est meilleur que BERT/RoBERTa dans les tâches de génération de texte.


<!--
### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language?
-->

### Quelques questions ouvertes en traitement du langage naturel

- Comment intégrer la connaissance du monde ?
- Comment modéliser de longs documents étant donné que les modèles basés sur BERT utilisent généralement seulement 512 jetons ?
- Quelle est la meilleure façon de procéder pour l'apprentissage multitâches ?
- Pouvons-nous procéder à du *finetuning* avec moins de données ?
- Ces modèles comprennent-ils vraiment le langage ?

<!--
### Summary

- Training models on lots of data beats explicitly modelling linguistic structure.

From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks

- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy

- Bidirectional context is crucial
-->

### Résumé

- Entraîner des modèles sur de nombreuses données bat explicitement la modélisation de la structure linguistique.

Du point de vue de la variance de biais, les *transformers* sont des modèles à faible biais (très expressifs). Il est préférable de nourrir ces modèles avec beaucoup de texte plutôt que de modéliser explicitement la structure linguistique (biais élevé). Les architectures doivent comprimer les séquences à travers les goulots d'étranglement.

- Les modèles peuvent apprendre beaucoup sur le langage en prédisant des mots dans un texte non étiqueté. Cela s'avère être un excellent objectif d'apprentissage non supervisé. Il est alors facile de *finetuner* des tâches spécifiques.

- Le contexte bidirectionnel est crucial.


<!--
### Additional Insights from questions after class:

What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?

"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.

Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way.
-->

### Questions posées après le cours par des étudiants

**Quels sont les moyens de quantifier la compréhension du langage ? Comment savons-nous que ces modèles sont réellement des modèles de compréhension du langage ?**

> La phrase « mon trophée ne rentre pas dans mon bagage car il est trop grand » est difficile pour les modèles car ont des problèmes pour résoudre le problème de la référence à « il » dans cette phrase. L'homme est doué pour cette tâche. Il existe un jeu de données constitué d'exemples aussi difficiles et les humains atteignent 95% de performance sur ce jeu de données. Les programmes informatiques n'atteignaient que 60% environ avant la révolution provoquée par les *transformers*. Les modèles modernes de *transformers* sont capables d'atteindre plus de 90%. Cela suggère que ces modèles ne se contentent pas de mémoriser/exploiter les données, mais qu'ils apprennent des concepts et des objets grâce aux modèles statistiques des données.
> En outre, BERT et RoBERTa atteignent des performances supérieures à celle humaine sur les jeux de données SQUAD et GLUE. Les résumés textuels générés par BART semblent très réels pour les humains (scores BLEU élevés). Ces faits sont la preuve que les modèles comprennent le langage d'une certaine manière.


<!--
#### Can we evaluate whether the model already has world knowledge?

‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’.
-->

**Peut-on évaluer si le modèle a déjà une connaissance du monde ?**
> La connaissance du monde est un concept abstrait. Nous pouvons tester les modèles, au niveau le plus élémentaire en leur posant des questions simples sur les concepts qui nous intéressent. Des modèles comme BERT, RoBERTa et T5 ont des milliards de paramètres. Si l'on considère que ces modèles sont entraînés sur un énorme corpus de textes informationnels comme Wikipédia, ils mémorisent des faits en utilisant leurs paramètres et sont capables de répondre à nos questions. En outre, nous pouvons également envisager de réaliser le même test de connaissances avant et après le *finetuning* d'un modèle sur une tâche donnée. Cela nous donnerait une idée de la quantité d'informations que le modèle a « oubliées ».

<!--
#### Grounded Language

Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization.
-->

**Qu'est que le langage fondé sur la réalité (*grounded Language*) ?**
> L'objectif de ce domaine de recherche est de créer des agents conversationnels capables de bavarder ou de négocier. Le bavardage et la négociation sont des tâches abstraites dont les objectifs ne sont pas clairs par rapport à la classification ou au résumé de texte.
