---
lang: fr
lang-ref: ch.12-1
title: Apprentissage profond pour le traitement du langage naturel
lecturer: Mike Lewis
authors: Jiayu Qiu, Yuhong Zhu, Lyuang Fu, Ian Leefmans
date: 20 Apr 2020
translation-date: 24 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Overview](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)

* Amazing progress in recent years:
  - Humans prefer machine translation to human translators for some languages
  - Super-human performance on many question answering datasets
  - Language models generate fluent paragraphs (e.g Radford et al. 2019)
*  Minimal specialist techniques needed per task, can achieve these things with fairly generic models
-->

## [Vue d'ensemble](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)

* Progrès impressionnants au cours des dernières années :
  - Les humains préfèrent la traduction automatique aux traducteurs humains pour certaines langues
  - Des performances supérieures à l’humaine pour de nombreux jeux de données de réponse aux questions
  - Les modèles linguistiques génèrent des paragraphes fluides (par exemple [Radford et al. (2019)](https://openai.com/blog/better-language-models/))
* Un minimum de techniques spécialisées nécessaires par tâche, peut être réalisé avec des modèles assez génériques


<!--
## Language Models

* Language models assign a probability to a text:
  $p(x_0, \cdots, x_n)$
* Many possible sentences so we can’t just train a classifier
* Most popular method is to factorize distribution using chain rule:

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$
-->

## Modèles de langue

* Les modèles linguistiques attribuent une probabilité à un texte : $p(x_0, \cdots, x_n)$
* Beaucoup de phrases possibles donc on ne peut pas juste entraîner un classifieur
* La méthode la plus populaire consiste à factoriser la distribution en utilisant la règle de la chaîne :

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$

<!--
## Neural Language Models

Basically we input the text into a neural network, the neural network will map all this context onto a vector. This vector represents the next word and we have some big word embedding matrix. The word embedding matrix contains a vector for every possible word the model can output. We then compute similarity by dot product of the context vector and each of the word vectors. We'll get a likelihood of predicting the next word, then train this model by maximum likelihood. The key detail here is that we don't deal with words directly, but we deal with things called sub-words or characters.

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  Fig.1: Neural language model</center>
</figure>
-->

## Modèles de langue neuronaux

Grossièrement, nous entrons le texte dans un réseau de neurones qui va associer tout le contexte à un vecteur. Ce vecteur représente le mot suivant et nous disposons d'une matrice d'enchâssement de mots importants. Cette matrice contient un vecteur pour chaque mot possible que le modèle peut produire. Nous calculons la similarité par le produit scalaire du vecteur de contexte et de chacun des vecteurs de mots. Nous obtenons une probabilité de prédire le mot suivant, puis nous entraînons ce modèle par maximum de vraisemblance. Le détail clé ici est que nous ne traitons pas directement les mots mais des sous-mots ou des caractères.

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center> <b>Figure 1 :</b> Modèle de langue neuronal</center>
</figure>

<!--
### Convolutional Language Models

* The first neural language model
* Embed each word as a vector, which is a lookup table to the embedding matrix, so the word will get the same vector no matter what context it appears in
* Apply same feed forward network at each time step
* Unfortunately, fixed length history means it can only condition on bounded context
* These models do have the upside of being very fast

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center>  Fig.2: Convolutional language model</center>
</figure>
-->


### Modèles de langue convolutifs

* Il s'agit du premier type de modèle linguistique neuronal.
* Il consiste à enchâsser chaque mot comme un vecteur, qui est une table de recherche de la matrice d'enchâssement, de sorte que le mot a le même vecteur quel que soit le contexte dans lequel il apparaît. On applique ensuite le même réseau *feed forward* à chaque pas de temps.
* Malheureusement, la longueur fixe signifie qu'il ne peut être conditionné qu'à un contexte délimité.
* Ces types de modèles ont l'avantage d'être très rapides.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center> <b>Figure 2 :</b> Modèle de langue convolutif</center>
</figure>


<!--
### Recurrent Language Models

* The most popular approach until a couple years ago.
* Conceptually straightforward: every time step we maintain some state (received from the previous time step, which represents what we've read so far. This is combined with current word being read and used at later state. Then we repeat this process for as many time steps as we need.
* Uses unbounded context: in principle the title of a book would affect the hidden states of last word of the book.
* Disadvantages:
  - The whole history of the document reading is compressed into fixed-size vector at each time step, which is the bottleneck of this model
  - Gradients tend to vanish with long contexts
  - Not possible to parallelize over time-steps, so slow training

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  Fig.3: Recurrent language model</center>
</figure>
-->

### Modèles de langue récurrents

* L'approche la plus populaire jusqu'à il y a quelques années.
* Conceptuellement simple : à chaque pas de temps, nous maintenons un certain état (reçu du pas de temps précédent, qui représente ce que nous avons lu jusqu'à présent). Ceci est combiné avec le mot courant qui est lu et utilisé à l'état ultérieur. Ensuite, nous répétons ce processus pour autant de pas de temps que nécessaire.
* Utilise un contexte sans limite : en principe, le titre d'un livre affecterait les états cachés du dernier mot du livre.
* Inconvénients :
  - Toute l'histoire de la lecture du document est compressée en un vecteur de taille fixe à chaque étape temporelle, ce qui constitue le goulot d'étranglement de ce modèle.
  - Les gradients ont tendance à disparaître avec des contextes longs.
  - Impossible de paralléliser les étapes temporelles donc l'entraînement est lent.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center> <b>Figure 3 :</b> Modèle de langue récurrent</center>
</figure>

<!--
### [Transformer Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)

* Most recent model used in NLP
* Revolutionized penalty
* Three main stages
    * Input stage
    * $n$ times transformer blocks (encoding layers) with different parameters
    * Output stage
* Example with 6 transformer modules (encoding layers) in the original transformer paper:

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  Fig.4:Transformer language model </center>
</figure>

Sub-layers are connected by the boxes labelled "Add&Norm". The "Add" part means it is a residual connection, which helps in stopping the gradient from vanishing. The norm here denotes layer normalization.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  Fig.5: Encoder Layer </center>
</figure>

It should be noted that transformers share weights across time-steps.
-->

### [Modèles de langue basé sur un *transformer*](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)

* Modèle le plus récent en traitement du langage naturel.
* Pénalité révolutionnaire.
* Trois grandes étapes :
    * Étape d'entrée
    * $n$ fois les blocs de *transformer* (couches d'encodage) avec différents paramètres
    * Etape de sortie
* Exemple avec 6 modules de *transformer* (couches d'encodage) dans le papier introduisant le *transformer* :

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center> <b> Figure 4 :</b> Modèle de langue de type transformer </center>
</figure>

Les sous-couches sont reliées par les cases intitulées *Add&Norm*. La partie *Add* signifie qu'il s'agit d'une connexion résiduelle, qui contribue à empêcher la disparition du gradient. La partie *Norm* désigne ici la normalisation des couches.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center> <b> Figure 5 :</b> Couche encodeur </center>
</figure>

Il convient de noter que les *transformers* partagent les poids entre les étapes du temps.


<!--
# Multi-headed attention

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  Fig.6: Multi-headed Attention </center>
</figure>


For the words we are trying to predict, we compute values called **query(q)**. For all the previous words use to predict we call them **keys(k)**. Query is something that tells about the context, such as previous adjectives. Key is like a label containing information about the current word such as whether it's an adjective or not. Once q is computed, we can derive the distribution of previous words ($p_i$):

$$p_i = \text{softmax}(q,k_i)$$

Then we also compute quantities called **values(v)** for the previous words. Values represent the content of the words.

Once we have the values, we compute the hidden states by maximizing the attention distribution:

 $$h_i = \sum_{i}{p_i v_i}$$

We compute the same thing with different queries, values, and keys multiple times in parallel. The reason for this is that we want to predict the next word using different things. For example, when we predict the word "unicorns" using three previous words "These" "horned" and "silver-white". We know it is a unicorn by "horned" "silver-white". However, we can know it is plural "unicorns" by "These". Therefore, we probably want to use all these three words to know what the next word should be. Multi-headed attention is a way of letting each word look at multiple previous words.

One big advantage about the multi-headed attention is that it is very parallelisable. Unlike RNNs, it computes all heads of the multi-head attention modules and all the time-steps at once. One problem of computing all time-steps at once is that it could look at futures words too, while we only want to condition on previous words. One solution to that is what is called **self-attention masking**. The mask is an upper triangular matrix that have zeros in the lower triangle and negative infinity in the upper triangle. The effect of adding this mask to the output of the attention module is that every word  to the left has a much higher attention score than words to the right, so the model in practice only focuses on previous words. The application of the mask is crucial in language model because it makes it mathematically correct, however, in text encoders, bidirectional context can be helpful.

One detail to make the transformer language model work is to add the positional embedding to the input. In language, some properties like the order are important to interpret. The technique used here is learning separate embeddings at different time-steps and adding these to the input, so the input now is the summation of word vector and the positional vector. This gives the order information.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  Fig.7: Transformer Architecture </center>
</figure>

**Why the model is so good:**

1. It gives direct connections between each pair of words. Each word can directly access the hidden states of the previous words, mitigating vanishing gradients. It learns very expensive function very easily
2. All time-steps are computed in parallel
3. Self-attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length
-->


# Attention multi-têtes

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center> <b> Figure 6 :</b> Attention multi-têtes </center>
</figure>


Pour les mots que nous essayons de prédire, nous calculons des valeurs appelées **query(q)**. Nous appelons **keys(k)** tous les mots précédents utilisés pour prédire. La requête (q) nous renseigne sur le contexte, par exemple les adjectifs précédents. La clé (k) est comme un label contenant des informations sur le mot courant, par exemple si c'est un adjectif ou non. Une fois que q est calculée, nous pouvons dériver la distribution des mots précédents ($p_i$) :

$$p_i = \text{softmax}(q,k_i)$$

Ensuite, nous calculons des quantités appelées **values(v)** pour les mots précédents. Les valeurs représentent le contenu des mots.

Une fois que nous avons les valeurs (v), nous calculons les états cachés en maximisant la distribution de l'attention :

 $$h_i = \sum_{i}{p_i v_i}$$

Nous calculons la même chose avec différentes requêtes, valeurs et clés plusieurs fois en parallèle. La raison en est que nous voulons prédire le mot suivant en utilisant différentes choses. Par exemple, lorsque nous prédisons le mot « licornes » en utilisant les trois mots précédents « Ces », « cornues » et « blanc argenté ». Nous savons que c'est une licorne par « cornue » et « blanc argenté ». Nous pouvons savoir qu'il s'agit du pluriel « licornes » par « Ces ». Par conséquent, nous voulons utiliser ces trois mots pour savoir quel sera le prochain mot. L'attention à plusieurs têtes est une façon de laisser chaque mot regarder plusieurs mots précédents.

Un grand avantage de l'attention multi-têtes est qu'elle est très parallélisable. Contrairement aux RNNs, le calcul de toutes les têtes des modules d'attention multi-têtes et toutes les étapes de temps peut se faire en même temps. Un des problèmes du calcul de tous les pas de temps en une fois est qu'il pourrait également examiner les mots futurs, alors que nous ne voulons que conditionner les mots précédents. Une solution à ce problème est ce que l'on appelle le **masquage de l'auto-attention**. Le masque est une matrice triangulaire supérieure qui comporte des zéros dans le triangle inférieur et une infinité négative dans le triangle supérieur. L'effet de l'ajout de ce masque à la sortie du module d'attention est que chaque mot à gauche a un score d'attention beaucoup plus élevé que les mots à droite, de sorte que le modèle en pratique se concentre uniquement sur les mots précédents. L'application du masque est cruciale dans le modèle linguistique car elle le rend mathématiquement correct. Cependant, dans les modules encodeurs, le contexte bidirectionnel peut être utile.

Un détail pour faire fonctionner le *transformer* est d'ajouter l'enchâssement positionnel à l'entrée (l’ordre des mots dans un texte). Dans le langage, certaines propriétés comme l'ordre sont importantes à interpréter. La technique utilisée ici est l'apprentissage d’enchâssements séparés à différents moments et les ajouter à l'entrée de sorte que l'entrée est maintenant la somme du vecteur mot et du vecteur positionnel. Cela donne des informations sur l'ordre.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
  <center> <b>Figure 7 :</b> Architecture du transformer </center>
</figure>

**Pourquoi le modèle est si bon :**

1. Il donne des liens directs entre chaque paire de mots. Chaque mot peut accéder directement aux états cachés des mots précédents, ce qui atténue la disparition des gradients. Il apprend très facilement une fonction très coûteuse.
2. Toutes les étapes temporelles sont calculées en parallèle.
3. L'auto-attention est quadratique (tous les pas de temps peuvent s'occuper de tous les autres), ce qui limite la longueur maximale des séquences.


<!--
## [Some tricks (especially for multi-head attention and positional encoding) and decoding Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)
-->

## [Quelques astuces (notamment pour l'attention multi-tête et le codage positionnel) et le décodage des modèles de langue](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)

<!--
### Trick 1: Extensive use of layer normalization to stabilize training is really helpful

- Really important for transformers
-->

### Astuce 1 : l'utilisation de la normalisation par couches pour stabiliser l'entraînement

-	Astuce très importante pour les *transformers*

<!--
### Trick 2: Warm-up + Inverse-square root training schedule

- Make use of learning rate schedule: in order to make the transformers work well, you have to make your learning rate decay linearly from zero to thousandth steps.
-->
### Astuce 2 : échauffement (*warm-up*) et grille d'entraînement utilisant la racine carrée inverse

- Utiliser une grille de taux d'apprentissage fonctionne bien pour que les *transformers*. Il faut faire décroître le taux d'apprentissage de façon linéaire de zéro à des millièmes de pas.

<!--
### Trick 3: Careful initialization

- Really helpful for a task like machine translation
-->

### Truc 3 : soigner l’initialisation 

- Vraiment utile pour une tâche comme la traduction automatique

<!--
### Trick 4: Label smoothing

- Really helpful for a task like machine translation

The following are the results from some methods mentioned above. In these tests, the metric on the right called `ppl` was perplexity (the lower the `ppl` the better).

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  Fig.8: Model Performance Comparison </center>
</figure>

You could see that when transformers were introduced, the performance was greatly improved.
-->

### Astuce 4 : lissage 

- Vraiment utile pour une tâche comme la traduction automatique

Voici les résultats de certaines méthodes mentionnées ci-dessus. Dans ces tests, la métrique de droite appelée `ppl` était la perplexité (plus la `ppl` est basse, mieux c'est).

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
  <center> <b>Figure 8 :</b> Comparaison des performances des modèles </center>
</figure>

La performance a été grandement améliorée avec l’introduction des *transformers*.

<!--
## Some important facts of Transformer Language Models

 - Minimal inductive bias
 - All words directly connected, which will mitigate vanishing gradients.
 - All time-steps computed in parallel.


Self attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length.

- As self attention is quadratic, its expense grows linearly in practice, which could cause a problem.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  Fig.9: Transformers *vs.* RNNs </center>
</figure>
-->

## Quelques faits importants sur les *transformers*

 - Biais inductif minime
 - Tous les mots sont directement liés, ce qui atténue la disparition des gradients
 - Tous les pas de temps sont calculés en parallèle


L'auto-attention est quadratique (tous les pas de temps peuvent s'occuper de tous les autres), ce qui limite la longueur maximale de la séquence. La nature quadratique entraîne aussi que la dépense augmente linéairement ce qui pourrait poser un problème en pratique.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center> <b>Figure 9 :</b> Transformers vs RNNs </center>
</figure>

<!--
### Transformers scale up very well

1. Unlimited training data, even far more than you need
2. GPT 2 used 2 billion parameters in 2019
3. Recent models use up to 17B parameters and in 2020
-->

### Les *transformers* passent à l'échelle très bien

1. Des données illimitées pour l'entraînement (n'importe quel texte sur internet), bien plus que ce dont vous avez besoin.
2. Le GPT-2 a utilisé 2 milliards de paramètres en 2019.
3. Les modèles récents (lors de ce cours en 2020) utilisent plusieurs milliards de paramètres : 17Mds pour le T5, 175Mds pour le GPT3.

<!--
## Decoding Language Models

We can now train a probability distribution over text - now essentially we could get exponentially many possible outputs, so we can’t compute the maximum. Whatever choice you make for your first word could affect all the other decisions.
Thus, given that, the greedy decoding was introduced as follows.
-->

## Décodage des modèles de langue

Cette section est davantage détaillée dans la partie 2 de la semaine 12 disponible [ici](https://atcold.github.io/pytorch-Deep-Learning/fr/week12/12-2/).  


Nous pouvons maintenant entraîner une distribution de probabilité sur le texte. Grossièrement, nous pouvons obtenir un nombre exponentiel de sorties possibles donc nous ne pouvons pas calculer le maximum. Le choix effectué pour votre premier mot peut avoir une incidence sur toutes les autres décisions.
Ainsi, étant donné cela, le décodage gourmand (*greedy decoding*) a été introduit comme suit.

<!--
### Greedy Decoding does not work

We take most likely word at each time step. However, no guarantee this gives most likely sequence because if you have to make that step at some point, then you get no way of back-tracking your search to undo any previous sessions.
-->

### Le décodage gourmand ne fonctionne pas

Nous prenons les mots les plus vraisemblables à chaque pas de temps. Cependant, rien ne garantit que cela donne la séquence la plus probable car si nous devons franchir cette étape à un moment donné, il n’y a aucun moyen de revenir en arrière pour annuler les sessions précédentes.

<!--
### Exhaustive search also not possible

It requires computing all possible sequences and because of the complexity of $O(V^T)$, it will be too expensive
-->

### Une recherche exhaustive n'est pas non plus possible

Il faut calculer toutes les séquences possibles et en raison de la complexité en $O(V^T)$, c’est trop cher computationnellement.


<!--
## Comprehension Questions and Answers

1. What is the benefit of multi-headed attention as opposed to a single-headed attention model?

    * To predict the next word you need to observe multiple separate things, in other words attention can be placed on multiple previous words in trying to understand the context necessary to predict the next word.

2. How do transformers solve the informational bottlenecks of CNNs and RNNs?

    * Attention models allow for direct connection between all words allowing for each word to be conditioned on all previous words, effectively removing this bottleneck.

3. How do transformers differ from RNNs in the way they exploit GPU parallelization?

    * The multi-headed attention modules in transformers are highly parallelisable whereas RNNs are not and therefore cannot take advantage of GPU technology. In fact transformers compute all time steps at once in single forward pass.
-->

## Questions des étudiants
**Quel est l'avantage d'un modèle d'attention à plusieurs têtes par rapport à un modèle d'attention à une seule tête ?**
> Pour prédire le mot suivant, vous devez observer plusieurs choses séparées, en d'autres termes, l'attention peut être portée sur plusieurs mots précédents en essayant de comprendre le contexte nécessaire pour prédire le mot suivant.

**Comment les *transformers* résolvent-ils les goulots d'étranglement informationnels des ConvNets et des RNNs ?**
> Les modèles d'attention permettent une connexion directe entre tous les mots, ce qui permet de conditionner chaque mot à tous les mots précédents, éliminant ainsi efficacement ce goulot d'étranglement.

**En quoi les *transformers* diffèrent-ils des RNNs dans la manière dont ils exploitent la parallélisation des GPUs ?**
> Les modules d'attention multi-têtes des *transformers* sont hautement parallélisables alors que les RNNs ne le sont pas et ne peuvent donc pas tirer profit de la technologie GPU. En fait, les *transformers* calculent tous les pas de temps en une seule passe vers l'avant.
