---
lang: fr
lang-ref: ch.11-3
title: Prediction et apprentissage d'une politique sous incertitude
lecturer: Alfredo Canziani
authors: Anuj Menta, Dipika Rajesh, Vikas Patidar, Mohith Damarapati
date: 14 Apr 2020
translation-date: 11 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Introduction and problem setup](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

Let us say we want to learn how to drive in a model-free Reinforcement learning way. We train models in RL by letting the model make mistakes and learn from them. But this is not the best way since mistakes might take us to heaven/hell where there is no point in learning.

So, let us talk about a more 'human' way to learn how to drive a car. Consider an example of lane switching. Assuming the car is moving at 100 km/h, which roughly translates to 30 m/s, if we look 30 m in front of us, we are roughly looking 1 s into the future.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Looking into future while driving
</center>

If we were turning, we need to make a decision based on the near future. To take a turn in a few meters, we take an action now, which in this context is turning the steering wheel. Making a decision not only depends on your driving but also the surrounding vehicles in the traffic. Since everyone around us is not so deterministic, it is very hard to take every possibility into account.

Let us now break down what is happening in this scenario. We have an agent(represented here by a brain) that takes the input $s_t$ (position, velocity and context images) and produces an action $a_t$(steering control, acceleration and braking).  The environment takes us to a new state and returns a cost $c_t$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 2:</b> Illustration of an agent in the real world
</center>

This is like a simple network where you take actions given a specific state and the world gives us the next state and the next consequence. This is model-free because with every action we are interacting with the real world. But can we train an agent without actually interacting with the real world?

Yes, we can! Let us find out in the "Learning world model" section.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 3:</b> Illustration of an agent in the world model
</center>
-->

## [Introduction et configuration du problème](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

Disons que nous voulons apprendre à conduire dans un modèle d'apprentissage par renforcement (RL pour *Reinforcement learning*). Nous entraînons des modèles en RL en laissant le modèle faire des erreurs et en apprenant de celles-ci. Mais ce n'est pas la meilleure façon de procéder car les erreurs peuvent nous conduire au paradis ou en enfer où il est inutile d'apprendre.

Parlons donc d'une méthode plus « humaine » pour apprendre à conduire une voiture. Prenons un exemple de changement de voie. En supposant que la voiture roule à 100 km/h, ce qui correspond à peu près à 30 m/s, si nous regardons à 30 m devant nous, nous regardons en gros 1 s dans le futur.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom : 20% ; background-color:#DCDCDC ;" /><br>
<b>Figure 1 :</b> Regarder vers l'avenir en conduisant
</center>

Si nous devons tourner, nous devons prendre une décision en fonction de l'avenir proche. Pour prendre un virage dans quelques mètres, nous prenons une mesure maintenant, qui dans ce contexte est de tourner le volant. Prendre une décision ne dépend pas seulement de notre conduite, mais aussi des véhicules environnants dans la circulation. Comme tout le monde autour de nous n'est pas aussi déterministe, il est très difficile de prendre en compte toutes les possibilités.

Décomposons maintenant ce qui se passe dans ce scénario. Nous avons un agent (représenté ici par un cerveau) qui prend l'entrée $s_t$ (images de la position, de la vitesse et du contexte) et produit une action $a_t$ (contrôle de la direction, accélération et freinage). L'environnement nous amène à un nouvel état et nous renvoie un coût $c_t$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom : 30% ; background-color:#DCDCDC;" /><br>
<b>Figure 2 :</b> Illustration d'un agent dans le monde réel
</center>

C'est comme un réseau où nous prenons des actions étant donné un état spécifique et où le monde nous donne l'état suivant et la conséquence suivante. C’est un modèle libre, car chaque action nous fait interagir avec le monde réel. Mais pouvons-nous entraîner un agent sans interagir avec le monde réel ?


<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom : 30% ; background-color:#DCDCDC;" /><br>
<b>Figure 3 :</b> Illustration d'un agent dans le modèle du monde
</center>


<!--
## Data set

Before discussing how to learn the world model, let us explore the dataset we have. We have 7 cameras mounted on top of a 30 story building facing the interstate. We adjust the cameras to get the top-down view and then extract bounding boxes for each vehicle. At a time $t$, we can determine $p_t$ representing the position, $v_t$
representing the velocity and $i_t$ representing the current traffic state around the vehicle.

Since we know the kinematics of the driving, we can invert them to figure out what are the actions that the driver is taking. For example, if the car is moving in a rectilinear uniform motion, we know that the acceleration is zero(meaning there is no action)

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 4:</b> Machine representation of a single frame
</center>

The illustration in blue is the feed and the illustration in green is what we can call the machine representation. To understand this better, we have isolated a few vehicles(marked in the illustration). The views we see below are the bounding boxes of the field-of-view of these vehicles.
-->

## Jeu de données

Avant de discuter de la manière d'apprendre le modèle du monde, explorons le jeu de données dont nous disposons. Nous avons 7 caméras montées sur le toit d'un bâtiment de 30 étages qui fait face à une autoroute. Nous ajustons les caméras pour obtenir une vue de haut en bas et extrayons ensuite des boîtes de délimitation pour chaque véhicule. Au temps $t$, nous pouvons déterminer $p_t$ représentant la position, $v_t$ représentant la vitesse et $i_t$ représentant l'état actuel de la circulation autour du véhicule.

Comme nous connaissons les cinématiques de la conduite, nous pouvons les inverser pour déterminer quelles sont les actions que le conducteur effectue. Par exemple, si la voiture se déplace dans un mouvement rectiligne uniforme, nous savons que l'accélération est nulle (ce qui signifie qu'il n'y a pas d'action).

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 4 :</b> Représentation mécanique d'une seule image
</center>

L'illustration en bleu est le flux et l'illustration en vert est ce que l'on peut appeler la représentation de la machine. Pour mieux comprendre cela, nous avons isolé quelques véhicules (marqués dans l'illustration). Les vues que nous voyons ci-dessus sont les boites délimitant le champ de vision de ces véhicules.

<!--
## Cost

There are two different types of costs here: lane cost and proximity cost. Lane cost tells us how well we are within a lane and proximity cost tells us how close we are to the other cars.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 5:</b> Lane cost
</center>

In the above figure, dotted lines represent actual lanes and red lines help us figure out the lane cost given the current position of our car.  Red lines move as our car moves. The height of the intersection of the red lines with the potential curve (in cyan) gives us the cost. If the car is in the centre of the lane, both the red lines overlap with the actual lanes resulting in zero cost. On the other hand, as the car moves away from the centre, the red lines also move to result in a non-zero cost.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Proximity cost
</center>

Proximity cost has two components ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ is similar to the lane cost and $\mathcal{L}_x$ depends on the speed of our car. The Orange curve in Figure 6 tells us about the safety distance. As the speed of the car increases, the orange curve widens. So faster the car is travelling, the more you will need to look ahead and behind. The height of the intersection of a car with the orange curve determines $\mathcal{L}_x$.

The product of these two components gives us the proximity cost.
-->

## Coût

Il y a deux types de coûts différents ici : le coût de la voie et le coût de proximité. Le coût de la voie nous indique dans quelle mesure nous sommes à l'intérieur d'une voie et le coût de proximité nous indique dans quelle mesure nous sommes proches des autres voitures.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 5 :</b> Coût des voies
</center>

Dans la figure ci-dessus, les lignes pointillées représentent les voies réelles et les lignes rouges nous aident à calculer le coût de la voie compte tenu de la position actuelle de notre voiture. Les lignes rouges se déplacent en fonction de la position de notre voiture. La hauteur de l'intersection des lignes rouges avec la courbe potentielle (en cyan) nous donne le coût. Si la voiture est au centre de la voie, les deux lignes rouges se chevauchent avec les voies réelles, ce qui donne un coût nul. D'autre part, lorsque la voiture s'éloigne du centre, les lignes rouges se déplacent également, ce qui entraîne un coût non nul.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 6 :</b> Coût de proximité
</center>

Le coût de proximité a deux composantes ($\mathcal{L}_x$ et $\mathcal{L}_y$). $\mathcal{L}_y$ est similaire au coût de la voie et $\mathcal{L}_x$ dépend de la vitesse de notre voiture. La courbe orange de la figure 6 nous renseigne sur la distance de sécurité. Plus la vitesse de la voiture augmente, plus la courbe orange s'élargit. Plus la voiture roule vite, plus il faut regarder devant et derrière. La hauteur de l'intersection d'une voiture avec la courbe orange détermine $\mathcal{L}_x$.

Le produit de ces deux éléments nous donne le coût de la proximité.

<!--
## Learning world model

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Illustration of the world model
</center>

The world model is fed with an action $a_t$ (steering, brake, and acceleration) and $s_{1:t}$ (sequence of states where each state is represented by position, velocity and context images at that time) and it predicts the next state $\hat s_{t+1}$.  On the other hand, we have the real world which tells us what actually happened ($s_{t+1}$). We optimize MSE (Mean Squared Error) between prediction ($\hat s_{t+1}$) and target ($s_{t+1}$) to train our model.
-->

## Apprentissage d’un modèle du monde

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom : 30% ; background-color:#DCDCDC;" /><br>
<b>Figure 7 :</b> Illustration d’un modèle du monde
</center>

Le modèle du monde est alimenté par une action $a_t$ (direction, freinage et accélération) et $s_{1:t}$ (séquence d'états où chaque état est représenté par des images de position, de vitesse et de contexte à ce temps) et il prédit l'état suivant $\hat s_{t+1}$.  D'autre part, nous avons le monde réel qui nous dit ce qui s'est réellement passé ($s_{t+1}$). Nous optimisons la MSE entre la prédiction ($\hat s_{t+1}$) et la cible ($s_{t+1}$) pour entraîner notre modèle.

<!--
## Deterministic predictor-decoder

One way to train our world model is by using a predictor-decoder model explained below.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Deterministic predictor-decoder to learn the world model
</center>

As depicted in Figure 8, we have a sequence of states($s_{1:t}$) and action ($a_t$) which are provided to the predictor module. The predictor outputs a hidden representation of the future which is passed on to the decoder. The decoder is decoding the hidden representation of the future and outputs a prediction($\hat s_{t+1}$). We then train our model by minimising MSE between prediction $\hat s_{t+1}$ and target $s_{t+1}$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Actual future *vs.* Deterministic future
</center>

Unfortunately, this does not work!

We see that the deterministic output becomes very hazy. This is because our model is averaging over all the future possibilities. This can be compared to the future's multimodality discussed a couple of classes earlier, where a pen placed at origin is dropped randomly. If we take the average across all locations, it gives us a belief that pen never moved which is incorrect.

We can address this problem by introducing latent variables in our model.
-->

## Prédicteur-décodeur déterministe

L'une des façons d'entraîner notre modèle du monde est d'utiliser un modèle prédicteur-décodeur expliqué ci-dessous.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom : 10% ; background-color:#DCDCDC ;" /><br>
<b>Figure 8 :</b> Prédicteur-décodeur déterministe pour apprendre le modèle du monde
</center>

Comme le montre la figure 8, nous avons une séquence d'états ($s_{1:t}$) et d'actions ($a_t$) qui sont fournies au module prédicteur. Le prédicteur produit une représentation cachée de l'avenir qui est transmise au décodeur. Le décodeur décode la représentation cachée du futur et émet une prédiction ($\hat s_{t+1}$). Nous entraînons ensuite notre modèle en minimisant la MSE entre la prédiction $\hat s_{t+1}$ et la cible $s_{t+1}$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom : 20% ; background-color:#DCDCDC ;" /><br>
<b>Figure 9 :</b> Avenir réel vs Avenir déterministe
</center>

Malheureusement, cela ne fonctionne pas !

Nous constatons que le résultat déterministe devient très flou. C'est parce que notre modèle fait la moyenne de toutes les possibilités futures. Cela peut être comparé à la multimodalité du futur dont nous avons déjà évoqué dans un cours précédent où un stylo placé à l'origine est laché au hasard. Si nous prenons la moyenne de tous les endroits, cela nous donne l'impression que le stylo n'a jamais bougé, ce qui est incorrect.

Nous pouvons résoudre ce problème en introduisant des variables latentes dans notre modèle.

<!--
## [Variational predictive network](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

To solve the problem stated in the previous section, we add a low dimensional latent variable $z_t$ to the original network which goes through an expansion module $f_{exp}$ to match the dimensionality.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Variational predictive network - train
</center>

The $z_t$ is chosen such that the MSE is minimized for a specific prediction. By tuning the latent variable, you can still get MSE to zero by doing gradient descent into latent space. But this is very expensive. So, we can actually predict that latent variable using an encoder. Encoder takes the future state to give us a distribution with a mean and variance from which we can sample $z_t$.

During training, we can find out what is happening by looking into the future and getting information from it and use that information to predict the latent variable. However, we don't have access to the future during testing time. We fix this by enforcing the encoder to give us a posterior distribution as close as possible to the prior by optimizing KL divergence.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Variational predictive network - train (with prior distribution)
</center>

Now, let us look at the inference - How do we drive?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Figure 12:</b> Variational predictive network - inference
</center>

We sample the low-dimensional latent variable $z_t$ from the prior by enforcing the encoder to shoot it towards this distribution. After getting the prediction $\hat s_{t+1}$, we put it back (in an auto-regressive step) and get the next prediction $\hat s_{t+2}$ and keep feeding the network this way.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Figure 13:</b> Actual future *vs.* Deterministic
</center>

On the right hand side in the above figure, we can see four different draws from the normal distribution. We start with same initial state and provide different 200 values to the latent variable.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 14:</b> Actual future *vs.* Deterministic - after movement
</center>

We can notice that providing different latent variables generates different sequences of states with different behaviours. Which means we have a network that generates the future. Quite fascinating!

What's next?

We can now use this huge amount of data to train our policy by optimizing the lane and proximity costs described above.

These multiple futures come from the sequence of latent variables that you feed to the network. If you perform gradient ascent - in the latent space, you try to increase the proximity cost so you get the sequence of latent variables such that the other cars are going to be driving into you.
-->

## [Réseau prédictif variationnel](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

Pour résoudre le problème énoncé dans la section précédente, nous ajoutons une variable latente de faible dimension $z_t$ au réseau d'origine qui passe par un module d'expansion $f_{exp}$ pour correspondre à la dimensionnalité.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 10 :</b> Réseau prédictif variationnel - entraînement
</center>

Le $z_t$ est choisi de telle sorte que la MSE soit minimisée pour une prévision spécifique. En réglant la variable latente, vous pouvez toujours ramener la MSE à zéro en effectuant une descente de gradient dans l'espace latent. Mais c'est très coûteux. Nous pouvons donc réellement prédire cette variable latente en utilisant un encodeur. L'encodeur prend l'état futur pour nous donner une distribution avec une moyenne et une variance à partir de laquelle nous pouvons échantillonner $z_t$.

Pendant l'entraînement, nous pouvons découvrir ce qui se passe en regardant dans le futur et en en tirant des informations et utiliser ces informations pour prédire la variable latente. Cependant, nous n'avons pas accès à l'avenir pendant la durée des tests. Nous réglons ce problème en appliquant l’encodeur pour obtenir une distribution postérieure aussi proche que possible de la distribution antérieure en optimisant la divergence KL.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 11 :</b> Réseau prédictif variationnel - entraînement (avec distribution préalable)
</center>

Maintenant, examinons l’inférence. Comment conduisons-nous ?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom : 32% ; background-color:#DCDCDC;" /><br>
<b>Figure 12 :</b> Réseau prédictif variationnel - inférence
</center>

Nous échantillonnons la variable latente de faible dimension $z_t$ de la précédente en forçant l'encodeur à la tirer vers cette distribution. Après avoir obtenu la prédiction $\hat s_{t+1}$, nous la remettons (dans une étape autorégressive) et obtenons la prédiction suivante $\hat s_{t+2}$ et continuons à alimenter le réseau de cette façon.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom : 22% ; background-color:#DCDCDC ;" /><br>
<b>Figure 13 :</b> Avenir réel vs Déterministe
</center>

Dans la partie droite de la figure ci-dessus, on peut voir quatre tirages différents de la distribution normale. Nous partons du même état initial et fournissons 200 valeurs différentes à la variable latente.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom : 30% ; background-color:#DCDCDC;" /><br>
<b>Figure 14 :</b> Avenir réel vs Déterministe - après mouvement
</center>

Nous pouvons remarquer que le fait de fournir différentes variables latentes génère différentes séquences d'états avec différents comportements. Ce qui signifie que nous disposons d'un réseau qui génère le futur.

Quelle est la prochaine étape ?

Nous pouvons maintenant utiliser cette énorme quantité de données pour entraîner notre politique en optimisant les coûts de voies et de proximité décrits ci-dessus.

Ces futurs multiples proviennent de la séquence de variables latentes que l’on donne au réseau. Si nous effectuons une montée de gradient dans l'espace latent, nous essayons d'augmenter le coût de proximité afin d'obtenir la séquence de variables latentes de sorte que les autres voitures vont nous foncer dessus.

<!--
## Action insensitivity & latent dropout

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 15:</b> Issues - Action Insensitivity
</center>

Given that you actually have access to the future, if you turn to the left even slightly, everything is going to be turning to the right and that will contribute in a huge way to the MSE. The MSE loss can be minimized if the latent variable can inform the bottom part of the network that everything is going to turn to the right - which is not what we want! We can tell when everything turns to the right since that is a deterministic task.

The big arrow in Figure 15 signifies a leak of information and therefore it was not any more sensitive to the current action being provided to the predictor.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 16:</b> Issue - Action Insensitivity
</center>

In figure 16, in the rightmost diagram we have the real sequence of latent variables (the latent variables that allow us to get the most precise future) and we have the real sequence of actions taken by the expert. The two figures to the left of this one have randomly sampled latent variables but the real sequence of actions so we expect to see the steering. The last one on the left-hand side has the real sequence of latent variable but arbitrary actions and we can clearly see that the turning came mostly from the latent rather than the action, which encodes the rotation and the action (which are sampled from other episodes).

How to fix this problem?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 17:</b> Fix - Latent Dropout
</center>

The problem is not a memory leak but an information leak. We fix this problem by simply dropping out this latent and sampling it from the prior distribution at random. We don't always rely on the output of the encoder ($f_{enc}$) but pick from the prior. In this way, you cannot encode the rotation in the latent variable any more. In this way, information gets encoded in the action rather than the latent variable.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 18:</b> Performance with latent dropout
</center>

In the last two images on the right-hand side, we see two different sets of latent variables having a real sequence of actions and these networks have been trained with the latent dropout trick. We can now see that the rotation is now encoded by the action and no longer by the latent variables.
-->

## Insensibilité à l'action et dropout latent

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 15 :</b> Problèmes - Insensibilité à l'action
</center>

Étant donné que nous avons réellement accès à l'avenir, si nous tournons à gauche, même légèrement, tout va tourner à droite et cela va contribuer de façon énorme à la MSE. La perte MSE peut être minimisée si la variable latente peut informer la partie inférieure du réseau que tout va tourner à droite, ce qui n'est pas ce que nous voulons ! Nous pouvons dire quand tout tourne à droite puisque c'est une tâche déterministe.

La grande flèche de la figure 15 signifie une fuite d'informations et donc n'est pas plus sensible à l'action en cours fournie au prédicteur.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 16 :</b> Problème - Insensibilité à l'action
</center>

Dans la figure 16, dans le diagramme le plus à droite, nous avons la séquence réelle des variables latentes (les variables latentes qui nous permettent d'obtenir le futur le plus précis) et nous avons la séquence réelle des actions prises par l'expert. Les deux figures à gauche de celle-ci ont un échantillon aléatoire de variables latentes mais la séquence réelle d'actions, donc nous nous attendons à voir le pilotage. La dernière à gauche a la séquence réelle des variables latentes, mais des actions arbitraires, et nous pouvons clairement voir que la rotation provient principalement de la variable latente plutôt que de l'action, ce qui encode la rotation et l'action (qui sont échantillonnées à partir d'autres épisodes).


Comment résoudre ce problème ?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 17 :</b> Correction - Dropout latent
</center>

Le problème n'est pas une fuite de mémoire mais une fuite d'informations. Nous réglons ce problème en éliminant simplement cette latente et en la prélevant au hasard dans la distribution antérieure. Nous ne nous appuyons pas toujours sur la sortie de l'encodeur ($f_{enc}$) mais nous prélevons dans la distribution antérieure. De cette façon, nous ne pouvons plus encoder la rotation dans la variable latente. Ainsi l'information est encodée dans l'action plutôt que dans la variable latente.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 18 :</b> Performance avec dropout latent
</center>

Sur les deux dernières images de droite, on voit deux ensembles différents de variables latentes ayant une séquence réelle d'actions et ces réseaux ont été entraînés avec l'astuce du *dropout* latent. Nous pouvons maintenant voir que la rotation est maintenant codée par l'action et non plus par les variables latentes.



<!--
## [Training the agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

In the previous sections, we saw how we can obtain a world model by simulating real world experiences.  In this section, we will use this world model to train our agent.  Our goal is to learn the policy to take an action given the history of previous states.  Given a state $s_t$ (velocity, position & context images), the agent takes an action $a_t$ (acceleration, brake & steering), the world model outputs a next state and cost associated with that $(s_t, a_t)$ pair which is a combination of proximity cost and lane cost.

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

As discussed in the previous section, to avoid hazy predictions, we need to sample latent variable $z_t$ from the encoder module of the future state $s_{t+1}$ or from prior distribution $P(z)$.  The world model gets previous states $s_{1:t}$, action taken by our agent and latent variable $z_t$ to predict the next state $\hat s_{t+1}$ and the cost.  This constitutes one module that is replicated multiple times (Figure 19) to give us final prediction and loss to optimize.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 19:</b> Task specific model architecture
</center>

So, we have our model ready.  Let’s see how it looks !!

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 20:</b> Learned policy: Agent either collides or moves away from the road
</center>

Unfortunately, this does not work.  Policy trained this way is not useful as it learns to predict all black since it results in zero cost.

How can we address this issue? Can we try imitating other vehicles to improve our predictions?
-->

## [Entraînement de l'agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

Dans les sections précédentes, nous avons vu comment nous pouvons obtenir un modèle du monde en simulant des expériences réelles. Dans cette section, nous utilisons ce modèle du monde pour l'entraînement de notre agent.  Notre objectif est d'apprendre la politique à suivre pour agir, compte tenu de l'histoire des états précédents.  Étant donné un état $s_t$ (vitesse, position et images de contexte), l'agent entreprend une action $a_t$ (accélération, freinage et direction), le modèle du monde produit un état suivant et le coût associé à cette paire $(s_t, a_t)$ qui est une combinaison du coût de proximité et du coût de la voie.

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

Comme nous l'avons vu dans la section précédente, pour éviter des prédictions floues, nous devons échantillonner la variable latente $z_t$ du module encodeur de l'état futur $s_{t+1}$ ou de la distribution antérieure $P(z)$.  Le modèle du monde obtient les états précédents $s_{1:t}$, les mesures prises par notre agent et la variable latente $z_t$ pour prédire l'état suivant $\hat s_{t+1}$ et le coût.  Cela constitue un module qui est reproduit plusieurs fois (figure 19) pour nous donner la prédiction finale et la perte à optimiser.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 19 :</b> Architecture du modèle spécifique à la tâche
</center>

Notre modèle est prêt, voyons de quoi il a l'air.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 20 :</b> Politique apprise : l'agent entre en collision ou s'éloigne de la route
</center>

Malheureusement, cela ne fonctionne pas. La politique entraînée de cette façon n'est pas utile car elle apprend à prédire tout le noir puisqu'il en résulte un coût nul.

Comment pouvons-nous résoudre ce problème ? Pouvons-nous essayer d'imiter d'autres véhicules pour améliorer nos prévisions ?


<!--
## Imitating the expert

How do we imitate the experts here? We want the prediction of our model after taking a particular action from a state to be as close as possible to the actual future. This acts as an expert regulariser for our training. Our cost function now includes both the task specific cost(proximity cost and lane cost) and this expert regulariser term. Now as we are also calculating the loss with respect to the actual future, we have to remove the latent variable from the model because the latent variable gives us a specific prediction, but this setting works better if we just work with the average prediction.

$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 21:</b>  Expert regularization based model architecture
</center>

So how does this model perform?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Learned policy by imitating the experts
</center>

As we can see in the above figure, the model actually does incredibly well and learns to make very good predictions. This was model based imitation learning, we tried to model our agent to try to imitate others.

But can we do better?
Did we just train the Variational Autoencoder to remove it in the end?

It turns out we can still improve if we look to minimize the uncertainty of the forward model predictions.
-->

## Imiter l'expert

Comment imiter les experts ici ? Nous voulons que la prédiction de notre modèle après une action particulière d'un état soit aussi proche que possible de l'avenir réel. Cela agit comme un régulariseur expert pour notre entraînement. Notre fonction de coût comprend maintenant à la fois le coût spécifique de la tâche (coût de proximité et coût de la voie) et ce terme de régulariseur expert. Maintenant que nous calculons également la perte par rapport à l'avenir réel, nous devons supprimer la variable latente du modèle parce qu'elle nous donne une prédiction spécifique, mais ce paramètre fonctionne mieux si nous travaillons uniquement avec la prédiction moyenne.

$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 21 :</b> Architecture de modèle basée sur la régularisation expert
</center>

Comment ce modèle fonctionne-t-il ?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 22 :</b> Politique apprise en imitant les experts
</center>

Comme nous pouvons le voir dans la figure ci-dessus, le modèle fonctionne en fait incroyablement bien et apprend à faire de très bonnes prédictions. C'était un apprentissage par imitation basé sur le modèle, nous avons essayé de modeler notre agent pour essayer d'imiter les autres.

Mais pouvons-nous faire mieux ?
Avons-nous simplement entraîné l'auto-encodeur variationnel pour le supprimer à la fin ?

Il s'avère que nous pouvons encore améliorer les résultats si nous cherchons à minimiser l'incertitude des prédictions du modèle prédictif.

<!--
## Minimizing the Forward Model Uncertainty

What do we mean by minimizing forward model uncertainty and how would we do it? Before we answer that, let’s recap something we saw in the third week’s practicum.

If we train multiple models on the same data, all those models agree on the points in the training region (shown in red) resulting in zero variance in the training region. But as we move further away from the training region, the trajectories of loss functions of these models start diverging and variance increases. This is depicted in the figure 23.  But as the variance is differentiable, we can run gradient descent over the variance in order to minimize it.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Cost visualization across the entire input space
</center>

Coming back to our discussion, we observe that learning a policy using only observational data is challenging because the distribution of states it produces at execution time may differ from what was  observed during the training phase. The world model may make arbitrary predictions outside the domain it was trained on, which may wrongly result in low cost. The policy network may then exploit these errors in the dynamics model and produce actions which lead to wrongly optimistic states.

To address this, we propose an additional cost which measures the uncertainty of the dynamics model about its own predictions. This can be calculated by passing the same input and action through several different dropout masks, and computing the variance across the different outputs.  This encourages the policy network to only produce actions for which the forward model is confident.

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Uncertainty regulariser based model architecture
</center>

So, does uncertainty regulariser help us in learning better policy?

Yes, it does. The policy learned this way is better than the previous models.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Learned policy based on uncertainty regulariser
</center>
-->

## Minimiser l'incertitude du modèle prédictif

Qu'entendons-nous par réduire au minimum l'incertitude des modèles de prédiction et comment le faire ? Avant de répondre à cette question, récapitulons ce que nous avons vu au cours de la troisième semaine.

Si nous entraînons plusieurs modèles sur les mêmes données, tous ces modèles s'accordent sur les points de la région d'entraînement (indiquée en rouge), ce qui donne une variance nulle dans la région d'entraînement. Mais plus nous nous éloignons de la région d'entraînement, plus les trajectoires des fonctions de perte de ces modèles commencent à diverger et plus la variance augmente. Ceci est illustré par la figure 23.  Mais comme la variance est différentiable, nous pouvons effectuer une descente de gradient sur la variance afin de la minimiser.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom : 50% ; background-color:#DCDCDC;" /><br>
<b>Figure 23 :</b> Visualisation des coûts sur l'ensemble de l'espace d'entrée
</center>

Pour en revenir à notre discussion, nous constatons que l'apprentissage d'une politique uniquement à l'aide de données d'observation est difficile car la distribution des états qu'elle produit au moment de l'exécution peut différer de ce qui a été observé pendant la phase d'entraînement. Le modèle du monde peut faire des prédictions arbitraires en dehors du domaine sur lequel il a été entraîné, ce qui peut entraîner des coûts peu élevés. Le réseau politique peut alors exploiter ces erreurs dans le modèle dynamique et produire des actions qui conduisent à des états faussement optimistes.

Pour y remédier, nous proposons un coût supplémentaire qui mesure l'incertitude du modèle dynamique sur ses propres prédictions. Ce coût peut être calculé en faisant passer la même entrée et la même action par plusieurs masques de *dropout* différents, et en calculant la variance entre les différentes sorties. Cela encourage le réseau politique à ne produire que des actions pour lesquelles le modèle de prospective est confiant.

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 24 :</b> Architecture de modèle basée sur la régularisation de l'incertitude
</center>

Alors, la régularisation de l'incertitude nous aide-t-elle à apprendre une meilleure politique ?
Oui. La politique ainsi apprise est meilleure que les modèles précédents.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
<b>Figure 25 :</b> Politique apprise basée sur la régularisation de l'incertitude
</center>

<!--
## Evaluation

Figure 26 shows how well our agent learned to drive in dense traffic.  Yellow car is the original driver, blue car is our learned agent and all green cars are blind to us (cannot be controlled).

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Performance of model with uncertainty regulariser
</center>
-->

## Évaluation

La figure 26 montre à quel point notre agent a appris à conduire dans un trafic dense. La voiture jaune est le conducteur d'origine, la voiture bleue est notre agent entraîné et toutes autres, les voitures vertes, sont celles qui ne peuvent pas être contrôlées.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom : 60% ; background-color:#DCDCDC;" /><br>
<b>Figure 26 :</b> Performance du modèle avec régularisation de l'incertitude
</center>
