---
lang: fr
lang-ref: ch.11-2
lecturer: Yann Le Cun
title: Fonctions de perte (continues) et fonctions de perte pour les EBMs
authors: Charles Brillo-Sonnino, Shizhan Gong, Natalie Frank, Yunan Hu
date: 13 Apr 2020
translation-date: 11 Aug 2020
translator: Loïck Bourdois
---

<!--
### [Binary Cross Entropy (BCE) Loss - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

This loss is a special case of cross entropy for when you have only two classes so it can be reduced to a simpler function. This is used for measuring the error of a reconstruction in, for example, an auto-encoder. This formula assume $x$ and $y$ are probabilities, so they are strictly between 0 and 1.
-->

### [Perte d'entropie croisée binaire (Binary Cross Entropy : BCE) - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

Cette perte est un cas particulier de l'entropie croisée car lorsque nous n'avons que deux classes, elle peut être réduite à une fonction plus simple. Elle est utilisée pour mesurer l'erreur d'une reconstruction dans, par exemple un auto-encodeur. Cette formule suppose que $x$ et $y$ sont des probabilités, elles sont donc strictement comprises entre $0$ et $1$.

<!--
### Kullback-Leibler Divergence Loss - `nn.KLDivLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

This is simple loss function for when your target is a one-hot distribution (*i.e.* $y$ is a category). Again it assumes $x$ and $y$ are probabilities. It has the disadvantage that it is not merged with a softmax or log-softmax so it may have numerical stability issues.
-->

### Perte de divergence de Kullback-Leibler - `nn.KLDivLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

Il s'agit d'une fonction de perte simple pour les cas où la cible est une distribution *one-hot* (c'est-à-dire que $y$ est une catégorie). Là encore, elle suppose que $x$ et $y$ sont des probabilités. Elle présente l'inconvénient de ne pas être fusionnée avec une softmax ou une log-softmax, ce qui peut poser des problèmes de stabilité numérique.

<!--
### BCE Loss with Logits - `nn.BCEWithLogitsLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

This version of binary cross entropy loss takes scores that haven't gone though softmax so it does not assume x is between 0 and 1. It is then passed though a sigmoid to ensure it is in that range. The loss function is more likely to be numerically stable when combined like this.
-->

### *BCE Loss with Logits* - `nn.BCEWithLogitsLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

Cette version de la perte d'entropie croisée binaire prend les scores qui ne sont pas passés par la softmax, donc elle ne suppose pas que $x$ est compris entre $0$ et $1$. Elle passe ensuite par une sigmoïde pour s'assurer qu'elle est dans cette fourchette. La fonction de perte a plus de chances d'être numériquement stable lorsqu'elle est combinée de cette manière.

<!--
### Margin Ranking Loss - `nn.MarginRankingLoss()`

$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margin})
$$

Margin losses are an important category of losses. If you have two inputs, this loss function says you want one input to be larger than the other one by at least a margin. In this case $y$ is a binary variable $\in \{ -1, 1\}$. Imagine the two inputs are scores of two categories. You want the score for the correct category larger than the score for the incorrect categories by at least some margin.  Like hinge loss, if $y*(x_1-x_2)$ is larger than margin, the cost is 0. If it is smaller, the cost increases linearly. If you were to use this for classification, you would have $x_1$ be the score of the correct answer and $x_2$ be the score of the highest scoring incorrect answer in the mini-batch. If used in energy based models (discussed later), this loss function pushes down on the correct answer $x_1$ and up on the incorrect answer $x_2$.
-->


### Perte *Margin Ranking* - `nn.MarginRankingLoss()`

$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margin})
$$

Les pertes avec marge constituent une catégorie importante de pertes. Si nous avons deux entrées, cette fonction de perte indique que l'une d'elles doit être plus importante que l'autre d'au moins une marge. Dans ce cas, $y$ est une variable binaire $\in \{ -1, 1\}$. 
Imaginons que les deux entrées sont des scores de deux catégories. Nous voulons que le score de la catégorie correcte soit plus grand que le score de la catégorie incorrecte d'au moins une certaine marge. Comme pour la perte *Hinge*, si $y*(x_1-x_2)$ est supérieur à la marge, le coût est de $0$. S'il est inférieur, le coût augmente de façon linéaire. Si nous devons l'utiliser pour la classification, nous aurions $x_1$ comme score de la bonne réponse et $x_2$ comme score de la réponse incorrecte la plus élevée du mini-batch. Si elle est utilisée dans des modèles à base d'énergie (voir plus loin), cette fonction de perte pousse vers le bas la bonne réponse $x_1$ et vers le haut la mauvaise réponse $x_2$.


<!--
### Triplet Margin Loss - `nn.TripletMarginLoss()`

$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margin}, 0\}
$$

This loss is used for measuring a relative similarity between samples.  For example, you put two images with the same category through a CNN and get two vectors. You want the distance between those two vectors to be as small as possible. If you put two images with different categories through a CNN, you want the distance between those vectors to be as large as possible. This loss function tries to send the first distance toward 0 and the second distance larger than some margin.  However, the only thing that matter is that the distance between the good pair is smaller than the distance between the bad pair.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Triplet Margin Loss
</center>

This was originally used to train an image search system for Google. At that time, you would type a query into Google and it would encode that query into a vector. It would then compare that vector to a bunch of vectors from images that were previously indexed. Google would then retrieve the images that were the closest to your vector.
-->

### Perte *Triplet Margin* - `nn.TripletMarginLoss()`

$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margin}, 0\}
$$

Cette perte est utilisée pour mesurer une similarité relative entre les échantillons. Par exemple, nous faisons passer deux images de même catégorie dans un ConvNet et nous obtenons deux vecteurs. Nous voulons que la distance entre ces deux vecteurs soit la plus petite possible. Cette fonction de perte essaie d'envoyer la première distance vers $0$ et la seconde distance plus grande qu'une certaine marge. Cependant, la seule chose qui importe est que la distance entre la bonne paire soit plus petite que la distance entre la mauvaise paire.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Figure 1 :</b> Perte <i>Triplet Margin</i>
</center>

Elle a été utilisée à l'origine pour l'entraînement d'un système de recherche d'images pour Google. À l'époque, il fallait taper une requête dans Google et celui-ci l'encodait dans un vecteur. Il comparait ensuite ce vecteur à un ensemble de vecteurs provenant d'images qui avaient été précédemment indexées. Google récupère alors les images qui sont les plus proches de votre vecteur.

<!--
### Soft Margin Loss - `nn.SoftMarginLoss()`

$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelement()}}
$$

Creates a criterion that optimizes a two-class classification logistic loss between input tensor $x$  and target tensor $y$  (containing 1 or -1).

* This softmax version of a margin loss. You have a bunch of positives and a bunch of negatives you want to pass through a softmax. This loss function then tries to make $\text{exp}(-y[i]*x[i])$ for the correct $x[i]$ smaller than for any other.
* This loss function wants to pull the positive values of $y[i]*x[i]$ closer together and push the negative values far apart but, as opposed to a hard margin, with some continuous, exponentially decaying effect on the loss .
-->

### Perte *SoftMargin* - `nn.SoftMarginLoss()`

$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelement()}}
$$

Crée un critère qui optimise une perte logistique de classification à deux classes entre le tenseur d'entrée $x$ et le tenseur cible $y$ (contenant $1$ ou $-1$).

* C’est la version softmax de la perte avec marge. Nous avons un tas de positifs et un tas de négatifs que nous voulons faire passer par une softmax. Cette fonction de perte tente alors de rendre $\text{exp}(-y[i]*x[i])$ plus petit que les autres pour le bon $x[i]$.
* Cette fonction de perte veut rapprocher les valeurs positives de $y[i]*x[i]$ et éloigner les valeurs négatives, mais par opposition à une marge fixe, avec un effet continu de décroissance exponentielle sur la perte.


<!--
### Multi-Class Hinge Loss - `nn.MultiLabelMarginLoss()`

$$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{size}(0)}
$$

This margin-base loss allows for different inputs to have variable amounts of targets. In this case you have several categories for which you want high scores and it sums the  hinge loss over all categories. For EBMs, this loss function pushes down on desired categories and pushes up on non-desired categories.
-->

### Perte *Multi-Class Hinge* - `nn.MultiLabelMarginLoss()`

Cette perte permet à différentes entrées d'avoir des quantités variables d'objectifs. Dans ce cas, nous avons plusieurs catégories pour lesquelles nous souhaitons obtenir des scores élevés et elle additionne la perte sur toutes les catégories. Pour les EBMs, cette fonction de perte pousse vers le bas les catégories souhaitées et vers le haut les catégories non souhaitées.

<!--
### Hinge Embedding Loss - `nn.HingeEmbeddingLoss()`

$$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             x_n, &\quad y_n=1,  \\
             \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
             \end{array}
\right.
\end{equation}
$$

Hinge embedding loss used for semi-supervised learning by measuring whether two inputs are similar or dissimilar. It pulls together things that are similar and pushes away things are dissimilar. The $y$ variable indicates whether the pair of scores need to go in a certain direction. Using a hinge loss, the score is positive if $y$ is 1 and some margin $\Delta$ if $y$ is -1.
-->


### Perte *Hinge Embedding* - `nn.HingeEmbeddingLoss()`


$$
l_n =
\left\{
     \begin{array}{lr}
     x_n, &\quad y_n=1,  \\
     \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
     \end{array}
\right.
$$

Cette perte est utilisée pour l'apprentissage semisupervisé en mesurant si deux entrées sont similaires ou dissemblables. Elle rassemble les choses qui sont similaires et repousse celles qui sont dissemblables. La variable $y$ indique si la paire de notes doit aller dans une certaine direction. En utilisant une telle perte, le score est positif si $y$ est égal à $1$ et une certaine marge $\Delta$ si $y$ est égal à $-1$.

<!--
### Cosine Embedding Loss - `nn.CosineEmbeddingLoss()`

$$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             1-\cos(x_1,x_2), & \quad y=1,  \\
             \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
             \end{array}
\right.
\end{equation}
$$

This loss is used for measuring whether two inputs are similar or dissimilar, using the cosine distance, and is typically used for learning nonlinear embeddings or semi-supervised learning.

* Thought of another way, 1 minus the cosine of the angle between the two vectors is basically the normalised Euclidean distance.
* The advantage of this is that whenever you have two vectors and you want to make their distance as large as possible, it is very easy to make the network achieve this by make the vectors very long. Of course this is not optimal. You don't want the system to make the vectors big but rotate vectors in the right direction so you normalise the vectors and calculate the normalised Euclidean distance.
* For positive cases, this loss tries to make the vectors as aligned as possible. For negative pairs, this loss tries to make the cosine smaller than a particular margin. The margin here should be some small positive value.
* In a high dimensional space, there is a lot of area near the equator of the sphere. After normalisation, all your points are now normalised on the sphere. What you want is samples that are semantically similar to you to be close. The samples that are dissimilar should be orthogonal. You don't want them to be opposite each other because there is only one point at the opposite pole. Rather, on the equator, there is a very large amount of space so you want to make the margin some small positive value so you can take advantage of all this area.
-->

### Perte *Cosine Embedding* - `nn.CosineEmbeddingLoss()`

$$
l_n =
\left\{
     \begin{array}{lr}
     1-\cos(x_1,x_2), & \quad y=1,  \\
     \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
     \end{array}
\right.
$$


Cette perte est utilisée pour mesurer si deux entrées sont similaires ou dissemblables, en utilisant la distance cosinusoïdale et est généralement utilisée pour l'apprentissage d’enchâssements non linéaires ou pour l'apprentissage semisupervisé.

* Pensée d'une autre manière, $1$ moins le cosinus de l'angle entre les deux vecteurs est fondamentalement la distance euclidienne normalisée.
* L'avantage de cette méthode est que lorsque nous avons deux vecteurs et que voulons rendre leur distance aussi grande que possible, il est très facile de faire en sorte que le réseau y parvienne en rendant les vecteurs très longs. Bien sûr, ce n'est pas optimal. 
Nous ne voulons pas que le système fabrique des vecteurs de grande taille, mais qu'il fasse tourner les vecteurs dans la bonne direction, de sorte que nous normalisons les vecteurs et calculons la distance euclidienne normalisée.
* Pour les cas positifs, cette perte essaie de rendre les vecteurs aussi alignés que possible. Pour les paires négatives, cette perte essaie de rendre le cosinus plus petit qu'une marge particulière. La marge doit ici être une petite valeur positive.
* Dans un espace de grande dimension, il y a beaucoup de régions près de l'équateur de la sphère. Après la normalisation, tous nos points sont maintenant normalisés sur la sphère. Ce que nous voulons, c'est que les échantillons qui nous ressemblent sémantiquement soient proches. Les échantillons qui sont dissemblables doivent être orthogonaux. Nous ne voulons pas qu'ils soient opposés entre eux car il n'y a qu'un seul point au pôle opposé. Au contraire, sur l'équateur, il y a une très grande quantité d'espace, donc nous voulons que la marge ait une petite valeur positive afin de pouvoir profiter de toute cette zone.


<!--
### [Connectionist Temporal Classification (CTC) Loss - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

Calculates loss between a continuous (unsegmented) time series and a target sequence.
*  CTC loss sums over the probability of possible alignments of input to target, producing a loss value which is differentiable with respect to each input node.
* The alignment of input to target is assumed to be "many-to-one", which limits the length of the target sequence such that it must less than or equal to the input length.
* Useful when your output is a sequence of vectors, which is correspond to scores of categories.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: CTC Loss for speech recognition
</center>

Application Example: Speech recognition system
* Goal: Predict what word is being pronounced every 10 milliseconds.
* Each word is represented by a sequence of sounds.
* Depends on the person's speaking speed, different length of the sounds might be mapped to the same word.
* Find the best mapping from the input sequence to the output sequence. A good method for this is using dynamic programming to find the minimum cost path.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Many-to-one mapping setup
</center>
-->

### [La perte Connectionist Temporal Classification (CTC) - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

Calcule la perte entre une série chronologique continue (non segmentée) et une séquence cible.
* Les sommes des pertes CTC sur la probabilité des alignements possibles de l'entrée vers la cible, produisent une valeur de perte qui est différenciable par rapport à chaque nœud d'entrée.
* L'alignement de l'entrée sur la cible est supposé être « plusieurs vers un », ce qui limite la longueur de la séquence cible de sorte qu'elle doit être inférieure ou égale à la longueur d'entrée.
* Utile lorsque votre sortie est une séquence de vecteurs, qui correspond à un grand nombre de catégories.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Figure 2 :</b> Perte CTC pour la reconnaissance vocale
</center>

Exemple d'un système de reconnaissance vocale :
* Objectif : prédire quel mot est prononcé toutes les 10 millisecondes.
* Chaque mot est représenté par une séquence de sons.
* En fonction de la vitesse de la personne qui parle, des sons de différentes longueurs peuvent être associés au même mot.
* Trouver la meilleure correspondance entre la séquence d'entrée et la séquence de sortie. Une bonne méthode pour cela consiste à utiliser la programmation dynamique pour trouver le chemin le moins coûteux.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white ;"/><br>
<b>Figure 3 :</b> Configuration « plusieurs vers un »
</center>

<!--
# Energy-Based Models (Part IV) - Loss Function
-->

# Modèles à base d'énergie (EBMs) - Fonction de perte

<!--
## Architecture and Loss Functional

Family of energy functions: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

Training set: $S = \{(X^i, Y^i): i = 1 \cdots P\}$

Loss functional: $\mathcal{L} (E, S)$
* Functional means a function of another function. In our case, the functional $\mathcal{L} (E, S)$ is a function of the energy function $E$.
* Because $E$ is parametrised by $W$, we can turn the functional to a loss function of $W$: $\mathcal{L} (W, S)$
* Measures the quality of an energy function on training set
* Invariant under permutations and repetitions of the samples.

Training: $W^* = \arg\min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

Form of the loss functional:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ is per-sample loss
* $Y^i$ is desired answer, can be category or a whole image, etc.
* $E(W, \mathcal{Y}, X^i)$ is energy surface for a given $X_i$ as $Y$ varies
* $R(W)$ is regulariser

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$
-->

## Architecture et perte fonctionnelle

Famille de fonction d'énergie : $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

Jeu d'entraînement : $S = \{(X^i, Y^i) : i = 1 \cdots P\}$.

Perte fonctionnelle : $\mathcal{L} (E, S)$
* Fonctionnelle signifie une fonction d'une autre fonction. Dans notre cas, la fonction $\mathcal{L} (E, S)$ est une fonction de la fonction d’énergie $E$.
* Comme $E$ est paramétré par $W$, nous pouvons transformer la fonction en une fonction de perte de $W$ : $\mathcal{L} (W, S)$
* Mesure la qualité d'une fonction énergie sur un jeu d'entraînement
* Invariable sous les permutations et les répétitions des échantillons.

Entraînement : $W^* = \arg\min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

Forme de la perte fonctionnelle :
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ est la perte par échantillon
* $Y^i$ est la réponse souhaitée, peut être une catégorie ou une image entière, etc.
* $E(W, \mathcal{Y}, X^i)$ est la surface d'énergie pour un $X_i$ donné car $Y$ varie
* $R(W)$ est un régulariseur

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, X^i)) + R(W)
$$

<!--
## Designing a Good Loss Function

**Push down** on the energy of the correct answer.

**Push up** on the energies of the incorrect answers, particularly if they are smaller than the correct one.
-->

## Concevoir une bonne fonction de perte

**Poussez vers le bas** sur l'énergie de la bonne réponse.

**Poussez vers le haut** sur l'énergie des mauvaises réponses, surtout si elles sont plus petites que la bonne réponse.

<!--
## Examples of Loss Functions
-->

## Exemples de fonctions de perte

<!--
### Energy Loss

$$
L_{energy} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$

This loss function simply pushes down on the energy of the correct answer. If the network is not designed properly, it might end up with a mostly flat energy function as you only trying to make the energy of the correct answer small but not pushing up the energy elsewhere. Thus, the system might collapses.
-->

### Perte d'énergie

$$
L_{énergie} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$

Cette fonction de perte pousse simplement vers le bas l'énergie de la bonne réponse. Si le réseau n'est pas conçu correctement, il peut se retrouver avec une fonction de perte d'énergie pratiquement nulle car nous essayons seulement de rendre l'énergie de la bonne réponse faible mais nous ne poussons pas l'énergie vers le haut ailleurs. Ainsi, le système peut s'effondrer.


<!--
### Negative Log-Likelihood Loss

$$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

This loss function pushes down on the energy of the correct answer while pushing up on the energies of all answers in proportion to their probabilities. This reduces to the perceptron loss when $\beta \rightarrow \infty$. It has been used for a long time in many communities for discriminative training with structured outputs.

A probabilistic model is an EBM in which:

* The energy can be integrated over Y (the variable to be predicted)
* The loss function is the negative log-likelihood
-->

### Perte *Negative Log-Likelihood*

$$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

Cette fonction de perte pousse vers le bas l'énergie de la bonne réponse tout en poussant vers le haut les énergies de toutes les réponses en proportion de leurs probabilités. Cela se réduit à la perte de perceptron lorsque $\beta \rightarrow droite \infty$. Elle est utilisée depuis longtemps pour un entraînement discriminant avec des sorties structurés.

Un modèle probabiliste est un EBM dans lequel :

* L'énergie peut être intégrée sur $Y$ (la variable à prédire)
* La fonction de perte est la log-vraisemblance négative

<!--
### [Perceptron Loss](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)

$$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$

Very similar to the perceptron loss from 60+ years ago, and it's always positive because the minimum is also taken over $Y^i$, so $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. The same computation shows that it give exactly zero only when $Y^i$ is the correct answer.

This loss makes the energy of the correct answer small, and at the same time, makes the energy for all other answers as large as possible. However, this loss does not prevent the function from giving the same value to every incorrect answer $Y^i$, so in this sense, it is a bad loss function for non-linear systems. To improve this loss, we define the *most offending incorrect answer*.
-->

### [Perte de perceptron](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)

$$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$

Très similaire à la perte de perceptron d'il y a plus de 60 ans. Toujours positive car le minimum est également pris en charge $Y^i$, donc $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. Le même calcul montre qu'il ne donne exactement $0$ que lorsque $Y^i$ est la bonne réponse.

Cette perte rend l'énergie de la bonne réponse faible et en même temps rend aussi grande que possible l'énergie pour toutes les autres réponses. Cependant, cette perte n'empêche pas la fonction de donner la même valeur à chaque réponse incorrecte $Y^i$, donc dans ce sens, c'est une mauvaise fonction de perte pour les systèmes non linéaires. Pour améliorer cette perte, nous définissons la *réponse incorrecte la plus offensante*.

<!--
## Generalized Margin Loss

**Most offending incorrect answer**: discrete case
Let $Y$ be a discrete variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all possible answers that are incorrect:

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ and }Y\neq Y^i} E(W, Y,X^i)
$$

**Most offending incorrect answer**: continuous case
Let $Y$ be a continuous variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all answers that are at least $\epsilon$ away from the correct answer:

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ and }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

In the discrete case, the *most offending incorrect answer* is the one with smallest energy that isn't the correct answer. In the continuous case, the energy for $Y$ extremely close to $Y^i$ should be close to $E(W,Y^i,X^i)$. Furthermore, the $\text{argmin}$ evaluated over $Y$ not equal to $Y^i$ would be 0. As a result, we pick a distance $\epsilon$ and decide that only $Y$'s at least $\epsilon$ from $Y_i$ should be considered the "incorrect answer". This is why the optimization is only over $Y$'s of distance at least $\epsilon$ from $Y^i$.

If the energy function is able to ensure that the energy of the *most offending incorrect answer* is higher than the energy of the correct answer by some margin, then this energy function should work well.
-->

## Perte de marge généralisée

**Réponse incorrecte la plus offensante** : cas discret  
Soit $Y$ une variable discrète. Ensuite, pour un jeu d'entraînement $(X^i,Y^i)$, la *réponse incorrecte la plus offensante* $\bar Y^i$ est la réponse qui a la plus faible énergie parmi toutes les réponses possibles qui sont incorrectes :

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ and }Y\neq Y^i} E(W, Y, X^i)
$$

**Réponse incorrecte la plus offensante** : cas continu  
Soit $Y$ une variable continue. Ensuite, pour un échantillon d'entraînement $(X^i,Y^i)$, la *réponse incorrecte la plus offensante* $\bar Y^i$ est la réponse qui a la plus faible énergie parmi toutes les réponses qui sont au moins à $\epsilon$ de la bonne réponse :

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ and }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

Dans le cas discret, la *réponse incorrecte la plus offensante* est celle dont l'énergie est la plus faible et qui n'est pas la bonne réponse. Dans le cas continu, l'énergie pour $Y$ extrêmement proche de $Y^i$ devrait être proche de $E(W,Y^i,X^i)$. De plus, le $\text{argmin}$ évalué sur $Y$ non égal à $Y^i$ serait $0$. En conséquence, nous choisissons une distance $\epsilon$ et décidons que seul $Y$ est au moins $\epsilon$ de $Y_i$ doit être considéré comme la mauvaise réponse. C'est pourquoi l'optimisation ne porte que sur les $Y$ de distance au moins égale à $\epsilon$ de $Y^i$.

Si la fonction d'énergie est capable de garantir que l'énergie de la *réponse incorrecte la plus offensante* est supérieure à l'énergie de la bonne réponse d'une certaine marge, alors cette fonction d'énergie devrait bien fonctionner.

<!--
## Examples of Generalized Margin Loss Functions
-->

## Exemples de fonctions de perte de marge généralisée

<!--
### Hinge Loss

$$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$

Where $\bar Y^i$ is the *most offending incorrect answer*. This loss enforces that the difference between the correct answer and the most offending incorrect answer be at least $m$.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Hinge Loss
</center>

Q: How do you pick $m$?

A: It's arbitrary, but it affects the weights of the last layer.
-->

### Perte *Hinge*

$$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$

où $\bar Y^i$ est la *réponse incorrecte la plus offensante*. Cette perte impose que la différence entre la bonne réponse et la réponse incorrecte la plus offensante soit d'au moins $m$.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Figure 4 :</b> Perte Hinge</center>

**Comment choisir $m$ ?**
> C'est arbitraire, mais cela affecte les poids de la dernière couche.

<!--
### Log Loss

$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

This can be thought of as a "soft" hinge loss. Instead of composing the difference of the correct answer and the most offending incorrect answer with a hinge, it's now composed with a soft hinge. This loss tries to enforce an "infinite margin", but because of the exponential decay of the slope it doesn't happen.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Fig. 5</b>: Log Loss
</center>
-->

### *Log Loss*

$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

On peut considérer cela comme une *Hinge Loss* douce. Cette perte tente d'imposer une marge infinie, mais en raison de la décroissance exponentielle de la pente, cela ne se produit pas.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Figure 5 :</b> Log Loss
</center>


<!--
### Square-Square Loss

$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

This loss combines the square of the energy with a square hinge. The combination tries to minimize the energy and but enforce margin at least $m$ on the most offending incorrect answer. This is very similar to the loss used in Siamese nets.
-->

### *Square-Square Loss*

$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

Cette perte combine le carré de l'énergie avec une *hinge* au carrée. La combinaison tente de minimiser l'énergie et d'appliquer une marge d'au moins $m$ à la mauvaise réponse la plus offensante. Cette méthode est très similaire à la perte utilisée dans les réseaux siamois.

<!--
## Other Losses

There are a whole bunch. Here is a summary of good and bad loss functions.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selection of EBM loss functions
</center>

The right-hand column indicates if the energy function enforces a margin. The plain old energy loss does not push up anywhere, so it doesn't have a margin. The energy loss doesn't work for every problem. The perceptron loss works if you have a linear parametrisation of your energy but not in general. Some of them have a finite margin like the hinge loss, and some have an infinite margin like the soft hinge.

Q: How is the most offending incorrect answer found $\bar Y_i$ found in the continuous case?

A: You want to push up on a point that is sufficiently far from $Y^i$, because if it's too close, the parameters may not move much since the function defined by a neural net is "stiff". But in general, this is hard and this is the problem that methods selecting contrastive samples try to solve. There's no single correct way to do it.

A slightly more general form for hinge type contrastive losses is:

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

We assume that $Y$ is discrete, but if it were continuous, the sum would be replaced by an integral. Here, $E(W, Y^i,X^i)-E(W,y,X^i)$ is the difference of $E$ evaluated at the correct answer and some other answer. $C(Y^i,y)$ is the margin, and is generally a distance measure between $Y^i$ and $y$. The motivation is that the amount we want to push up on a incorrect sample $y$ should depend on the distance between $y$ and the correct sample $Y_i$. This can be a more difficult loss to optimize.
-->

## Autres pertes

Il y en a tout un tas. Voici un résumé de bonnes et mauvaises fonctions de perte.
<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white ;"/><br>
<b>Figure 6 :</b> Sélection des fonctions de perte d’EBM
</center>

La colonne de droite indique si la fonction d'énergie impose une marge. La simple perte d'énergie ne pousse nulle part donc elle n'a pas de marge. La perte d'énergie ne fonctionne pas pour tous les problèmes. La perte de perceptron fonctionne si nous avons une paramétrisation linéaire de notre énergie mais pas en général. Certaines ont une marge finie comme la perte *hinge* et d'autres une marge infinie comme la charnière souple.

**Comment la réponse incorrecte la plus offensante trouve-t-elle $\bar Y_i$ dans le cas continu ?**
> Vous voulez pousser sur un point qui est suffisamment éloigné de $Y^i$ car s'il est trop proche, les paramètres peuvent ne pas bouger beaucoup puisque la fonction définie par un réseau neuronal est « raide ». Mais en général, c'est difficile et c'est le problème que les méthodes de sélection d'échantillons contrastifs tentent de résoudre. Il n'y a pas une seule façon correcte de le faire.

Une forme un peu plus générale pour les pertes contrastives de type *hinge* est :

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

Nous supposons que $Y$ est discret, mais s'il était continu, la somme serait remplacée par une intégrale. Ici, $E(W, Y^i,X^i)-E(W,y,X^i)$ est la différence entre $E$ évaluée à la bonne réponse et une autre réponse. $C(Y^i,y)$ est la marge et est généralement une mesure de distance entre $Y^i$ et $y$. La motivation est que le montant que nous voulons pousser vers le haut sur un échantillon incorrect $y$ devrait dépendre de la distance entre $y$ et l'échantillon correct $Y_i$. Il peut s'agir d'une perte plus difficile à optimiser.
