---
lang: fr
lang-ref: ch.11-1
lecturer: Yann Le Cun
title: Fonction de perte et d’activation 
authors: Haochen Wang, Eunkyung An, Ying Jin, Ningyuan Huang
date: 13 April 2020
translation-date: 11 Aug 2020
translator: Loïck Bourdois
---



<!--
## [Activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

In today's lecture, we will review some important activation functions and their implementations in PyTorch. They came from various papers claiming these functions work better for specific problems.
-->

## [Fonctions d'activation](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

Passons en revue certaines fonctions d'activation importantes et leurs implémentations dans PyTorch. Elles sont issues de diverses publications affirmant que ces fonctions fonctionnent mieux pour des problèmes spécifiques.

<!--
### ReLU - `nn.ReLU()`

$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center>
-->

### ReLU - `nn.ReLU()`

La fonction ReLU (*Rectified Linear Unit*) est définie par :

$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Figure 1 :</b> ReLU
</center>


<!--
### RReLU - `nn.RReLU()`

There are variations in ReLU. The Random ReLU (RReLU) is defined as follows.

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center>

Note that for RReLU, $a$ is a random variable that keeps samplings in a given range during training, and remains fixed during testing. For PReLU , $a$ is also learned. For Leaky ReLU, $a$ is fixed.
--> 


### RReLU - `nn.RReLU()`

Il y a des variations de la ReLU. La ReLU aléatoire (RReLU pour *Random ReLU*) est définie comme suit :

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{si } x \geq 0\\
      ax, & \text{sinon}
    \end{cases}
$$


<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Figure 2 :</b> ReLU, Leaky ReLU/PReLU, RReLU
</center>

Notez que pour la RReLU, $a$ est une variable aléatoire qui maintient les échantillonages dans une fourchette donnée pendant l’entraînement, et reste fixe pendant le test. Pour la PReLU, $a$ est également appris. Pour la LeakyReLU, $a$ est fixe.



<!--
### LeakyReLU - `nn.LeakyReLU()`

$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      a_\text{negative slope}x, & \text{otherwise}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: LeakyReLU
</center>

Here $a$ is a fixed parameter. The bottom part of the equation prevents the problem of dying ReLU which refers to the problem when ReLU neurons become inactive and only output 0 for any input. Therefore, its gradient is 0. By using a negative slope, it allows the network to propagate back and learn something useful.

LeakyReLU is necessary for skinny network, which is almost impossible to get gradients flowing back with vanilla ReLU. With LeakyReLU, the network can still have gradients even we are in the region where everything is zero out.
-->

### LeakyReLU - `nn.LeakyReLU()`

$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{si } x \geq 0\\
      a_\text{negative slope}x, & \text{sinon}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Figure 3 :</b> LeakyReLU
</center>

Ici, $a$ est un paramètre fixe. La partie inférieure de l'équation évite que les neurones ReLU deviennent inactifs et ne renvoient à chaque fois 0 pour toute entrée donnée. Par conséquent, sa pente est nulle. En utilisant une pente négative, la fonction permet au réseau de se rétropropager et d'apprendre quelque chose d'utile.

Avec la LeakyReLU, le réseau peut toujours avoir des gradients même si nous sommes dans une région où tout est à zéro.

<!--
### PReLU - `nn.PReLU()`

$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$

Here $a$ is a learnable parameter.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center>

The above activation functions (*i.e.* ReLU, LeakyReLU, PReLU) are scale-invariant.
-->

### PReLU - `nn.PReLU()`

$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{si } x \geq 0\\
      ax, & \text{sinon}
    \end{cases}
$$

Ici, $a$ est un paramètre qui peut être appris.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Figure 4 :</b> PReLU
</center>

Les fonctions d'activation ci-dessus (ReLU, LeakyReLU, PReLU) sont invariantes au changement d'échelle.

<!--
### Softplus - `Softplus()`

$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center>

Softplus is a smooth approximation to the ReLU function and can be used to constrain the output of a machine to always be positive.

The function will become more like ReLU, if the $\beta$ gets larger and larger.
--> 

### Softplus - `Softplus()`

$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Figure 5 :</b> Softplus
</center>

La softplus est une approximation lisse de la fonction ReLU et peut être utilisée pour contraindre la sortie d'une machine à toujours être positive.

La fonction ressemble davantage à la fonction ReLU quand le $\beta$ augmente.


<!--
### ELU - `nn.ELU()`

$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center>

Unlike ReLU, it can go below 0 which allows the system to have average output to be zero. Therefore, the model may converge faster. And its variations (CELU, SELU) are just different parametrizations.
--> 

### ELU - `nn.ELU()`

$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Figure 6 :</b> ELU
</center>

Contrairement à la ReLU, cette fonction peut descendre en dessous de 0, ce qui permet au système d'avoir une sortie moyenne de $0$. Par conséquent, le modèle peut converger plus rapidement. Ses variations (CELU, SELU) ne sont que des paramétrages différents.


<!--
### CELU - `nn.CELU()`

$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Fig. 7</b>: CELU
</center>
-->

### CELU - `nn.CELU()`

$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Figure 7 :</b> CELU
</center>


<!--
### SELU - `nn.SELU()`

$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center>
-->

### SELU - `nn.SELU()`

$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Figure 8 :</b> SELU
</center>


<!--
### GELU - `nn.GELU()`

$$
\text{GELU(x)} = x * \Phi(x)
$$

where $\Phi(x)$ is the Cumulative Distribution Function for Gaussian Distribution.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center>
-->

### GELU - `nn.GELU()`

$$
\text{GELU(x)} = x * \Phi(x)
$$

où $\Phi(x)$ est la fonction de distribution cumulative pour la distribution gaussienne.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Figure 9 :</b> GELU
</center>

<!--
### ReLU6 - `nn.ReLU6()`

$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center>

This is ReLU saturating at 6. But there is no particular reason why picking 6 as saturation, so we can do better by using Sigmoid function below.
-->


### ReLU6 - `nn.ReLU6()`

$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Figure 10 :</b> ReLU6
</center>

C'est la saturation de la ReLU à 6. Mais il n'y a pas de raison particulière de choisir 6 comme saturation, nous pouvons donc faire mieux en utilisant la fonction Sigmoïde ci-dessous.

<!--
### Sigmoid - `nn.Sigmoid()`

$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Sigmoid
</center>

If we stack sigmoids in many layers, it may be inefficient for the system to learn and requires careful initialization. This is because if the input is very large or small, the gradient of the sigmoid function is close to 0. In this case, there is no gradient flowing back to update the parameters, known as saturating gradient problem. Therefore, for deep neural networks, a single kink function (such as ReLU) is preferred.
-->

### Sigmoïde - `nn.Sigmoid()`

$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Figure 11 :</b> Sigmoïde
</center>

Si nous empilons des sigmoïdes sur plusieurs couches, cela peut être inefficace pour l’apprentissage et nécessite une initialisation soigneuse. En effet, si l'entrée est très grande ou très petite, le gradient de la fonction sigmoïde est proche de 0. Dans ce cas, il n'y a pas de retour de gradient pour mettre à jour les paramètres. C’est ce qu'on appelle le problème de la saturation du gradient. C'est pourquoi, pour les réseaux neuronaux profonds, une seule fonction (comme la ReLU) est préférable.

<!--
### Tanh - `nn.Tanh()`

$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center>

Tanh is basically identical to Sigmoid except it is centred, ranging from -1 to 1. The output of the function will have roughly zero mean. Therefore, the model will converge faster.  Note that convergence is usually faster if the average of each input variable is close to zero. One example is Batch Normalization.
--> 

### Tanh - `nn.Tanh()`

$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Figure 12 :</b> Tanh
</center>

Tanh est fondamentalement identique à la Sigmoïde sauf qu'elle est centrée et va de $-1$ à $1$. La sortie de la fonction a une moyenne à peu près nulle. Par conséquent, le modèle converge plus rapidement. A noter que la convergence est généralement plus rapide si la moyenne de chaque variable d'entrée est proche de $0$. Un exemple est la normalisation par batch.

<!--
### Softsign - `nn.Softsign()`

$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center>

It is similar to the Sigmoid function but gets to the asymptote slowly and alleviate the gradient vanishing problem (to some extent).
-->

### Softsign - `nn.Softsign()`

$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Figure 13 :</b> Softsign
</center>

Elle est similaire à la fonction Sigmoïde mais arrive lentement à l'asymptote et atténue le problème de la disparition du gradient (dans une certaine mesure).

<!--
### Hardtanh - `nn.Hardtanh()`

$$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{if} x > 1\\
      -1, & \text{if} x < -1\\
      x, & \text{otherwise}
\end{cases}
$$

The range of the linear region [-1, 1] can be adjusted using `min_val` and `max_val`.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center>

It works surprisingly well especially when weights are kept within the small value range.
--> 

### Hardtanh - `nn.Hardtanh()`

$$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{si } x > 1\\
      -1, & \text{si } x < -1\\
      x, & \text{sinon}
\end{cases}
$$


L'étendue de la région linéaire [$-1$, $1$] peut être ajustée en utilisant `min_val` et `max_val`.

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Figure 14 :</b> Hardtanh
</center>

Elle fonctionne étonnamment bien, surtout lorsque les poids sont maintenus dans une fourchette de petites valeurs.


<!--
### Threshold - `nn.Threshold()`

$$
  y = \begin{cases}
      x, & \text{if} x > \text{threshold}\\
      v, & \text{otherwise}
    \end{cases}
$$

It is rarely used because we cannot propagate the gradient back. And it is also the reason preventing people from using back-propagation in 60s and 70s when they were using binary neurons.
--> 


### Threshold - `nn.Threshold()`

$$
  y = \begin{cases}
      x, & \text{si} x > \text{threshold}\\
      v, & \text{sinon}
    \end{cases}
$$

Rarement utilisée car nous ne pouvons pas rétropropager le gradient. C'est aussi la raison pour laquelle les gens ne pouvaient pas utiliser la rétropropagation dans les années 60 et 70 lorsqu'ils utilisaient des neurones binaires.


<!--
### Tanhshrink - `nn.Tanhshrink()`

$$
\text{Tanhshrink}(x) = x - \tanh(x)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanhshrink
</center>

It is rarely used except for sparse coding to compute the value of the latent variable.
--> 

### Tanhshrink - `nn.Tanhshrink()`

$$
\text{Tanhshrink}(x) = x - \tanh(x)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Figure 15 :</b> Tanhshrink
</center>

Elle est rarement utilisée sauf pour les codages épars afin de calculer la valeur de la variable latente.


<!--
### Softshrink - `nn.Softshrink()`

$$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{si } x > \lambda\\
      x + \lambda, & \text{si } x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 16</b>: Softshrink
</center>

This basically shrinks the variable by a constant towards 0, and forces to 0 if the variable is close to 0. You can think of it as a step of gradient for the $\ell_1$ criteria. It is also one of the step of the Iterative Shrinkage-Thresholding Algorithm (ISTA). But it is not commonly used in standard neural network as activations.
--> 

### Softshrink - `nn.Softshrink()`

$$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{si } x > \lambda\\
      x + \lambda, & \text{si } x < -\lambda\\
      0, & \text{sinon}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Figure 16 :</b> Softshrink
</center>

Grossièrement, cela réduit la variable d'une constante vers $0$ et la force à $0$ si la variable est proche de $0$. Elle peut être considérée comme une étape de gradient pour le critère $\ell_1$. C'est également l'une des étapes de l'algorithme ISTA (*Iterative Shrinkage-Thresholding Algorithm*). Mais elle n'est pas couramment utilisée comme activation dans les réseaux de neurones standard.


<!--
### Hardshrink - `nn.Hardshrink()`

$$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{if} x > \lambda\\
      x, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Hardshrink
</center>

It is rarely used except for sparse coding.
--> 

### Hardshrink - `nn.Hardshrink()`

$$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{si } x > \lambda\\
      x, & \text{si } x < -\lambda\\
      0, & \text{sinon}
    \end{cases}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Figure 17 :</b> Hardshrink
</center>

Rarement utilisée sauf pour des codages épars.

<!--
### LogSigmoid - `nn.LogSigmoid()`

$$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoid
</center>

It is mostly used in the loss function but not common for activations.
-->

### LogSigmoid - `nn.LogSigmoid()`

$$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Figure 18 :</b> LogSigmoid
</center>

Principalement utilisée comme fonction de perte mais n'est pas couramment comme fonction d’activation.


<!--
### Softmin - `nn.Softmin()`

$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$

It turns numbers into a probability distribution.
-->

### Softmin - `nn.Softmin()`

$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$

Transforme les chiffres en une distribution de probabilité.

<!--
### Soft(arg)max - `nn.Softmax()`

$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$
-->

### Soft(arg)max - `nn.Softmax()`

$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$


<!--
### LogSoft(arg)max - `nn.LogSoftmax()`

$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$

It is mostly used in the loss function but not common for activations.
-->

### LogSoft(arg)max - `nn.LogSoftmax()`

$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$

Principalement utilisée comme fonction de perte mais n'est pas couramment comme fonction d’activation.


<!--
## [Q&A activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)
--> 


## [Questions des étudiants sur les fonctions d'activation](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)


<!--
### `nn.PReLU()` related questions

- Why would we want the same value of $a$ for all channels?

  > Different channels could have different $a$. You could use $a$ as a parameter of every unit. It could be shared as a feature map as well.

- Do we learn $a$? Is learning $a$ advantageous?

  > You can learn $a$ or fix it.
  > The reason for fixing is to ensure that nonlinearity gives you a non-zero gradient even if it's in a negative region.
  > Making $a$ learnable allows the system to turn nonlinearity into either linear mapping or full rectification. It could be useful for some applications like implementing an edge detector regardless of the edge polarity.

- How complex do you want your non-linearity to be?

  > Theoretically, we can parametrise an entire nonlinear function in very complicated way, such as with spring parameters, Chebyshev polynomial, etc. Parametrising could be a part of learning process.

- What is an advantage of parametrising over having more units in your system?

  > It really depends on what you want to do. For example, when doing regression in a low dimensional space, parametrisation might help. However, if your task is in under a high dimensional space such as image recognition, just "a" nonlinearity is necessary and monotonic nonlinearity will work better.
  > In short, you can parametrize any functions you want but it doesn't bring a huge advantage.
--> 

### Questions relatives à `nn.PRELU()` 

**Pourquoi voudrait-on la même valeur de $a$ pour toutes les canaux ?**
> Différents canaux pourraient avoir des $a$ différents. Vous pourriez utiliser $a$ comme paramètre de chaque unité. Il pourrait également être partagé sous forme de carte de caractéristiques.

**Est-ce qu'on apprend $a$ ? Est-il avantageux d'apprendre $a$ ?**
> Vous pouvez apprendre $a$ ou le corriger. La raison de la correction est de s'assurer que la non-linéarité vous donne un gradient non nul même s'il est dans une région négative. Rendre $a$ apprenable permet au système de transformer la non-linéarité en une association linéaire ou une rectification complète. Cela peut être utile pour certaines applications comme la mise en œuvre d'un détecteur de bord, quelle que soit la polarité du bord.

**Quelle complexité souhaitez-vous donner à la non-linéarité ?**
> Théoriquement, nous pouvons paramétrer une fonction non linéaire entière de manière très compliquée, comme avec des paramètres de ressort, le polynôme de Tchebyshev, etc. Le paramétrage pourrait faire partie du processus d'apprentissage.

**Quel est l'avantage du paramétrage par rapport au fait d'avoir plus d'unités dans le système ?**
> Cela dépend vraiment de ce que vous voulez faire. Par exemple, lorsque vous faites une régression dans un espace de faible dimension, le paramétrage peut vous aider. Cependant, si votre tâche se situe dans un espace à haute dimension comme la reconnaissance d'images, une simple non-linéarité « a » est nécessaire et une non-linéarité monotone fonctionnera mieux. En bref, vous pouvez paramétrer toutes les fonctions que vous voulez, mais cela n'apporte pas un énorme avantage.


<!--
### Kink related questions

- One kink versus double kink

  > Double kink is a built-in scale in it. This means that if the input layer is multiplied by two (or the signal amplitude is multiplied by two), then outputs will be completely different. The signal will be more in nonlinearity, thus you will get a completely different behaviour of the output. Whereas, if you have a function with only one kink, if you multiply the input by two, then your output will be also multiplied by two.

- Differences between a nonlinear activation having kinks and a smooth nonlinear activation. Why/when one of them is preferred?

  > It is a matter of scale equivariance. If kink is hard, you multiply the input by two and the output is multiplied by two. If you have a smooth transition, for example, if you multiply the input by 100, the output looks like you have a hard kink because the smooth part is shrunk by a factor of 100. If you divide the input by 100, the kink becomes a very smooth convex function. Thus, by changing the scale of the input, you change the behaviour of the activation unit.

  > Sometimes this could be a problem. For example, when you train a multi-layer neural net and you have two layers that are one after the other. You do not have a good control for how big the weights of one layer is relative to the other layer's weights. If you have nonlinearity that cares about scales, your network doesn't have a choice of what size of weight matrix can be used in the first layer because this will completely change the behaviour.

  > One way to fix this problem is setting a hard scale on the weights of every layer so you can normalise the weights of layers, such as batch normalisation. Thus, the variance that goes into a unit becomes always constant. If you fix the scale, then the system doesn't have any way of choosing which part of the nonlinearity will be using in two kink function systems. This could be a problem if this 'fixed' part becomes too 'linear'. For example, Sigmoid becomes almost linear near zero, and thus batch normalisation outputs (close to 0) could not be activated 'non-linearly'.
  >
  > It is not entirely clear why deep networks work better with single kink functions. It's probably due to the scale equivariance property.
--> 

### Questions relatives aux coudes

**Un coude contre un double coude**
> Le double coude a une échelle intégrée. Cela signifie que si la couche d'entrée est multipliée par deux (ou si l'amplitude du signal est multipliée par deux), les sorties seront complètement différentes. Le signal sera plus en non-linéarité, donc vous obtiendrez un comportement complètement différent de la sortie. Alors que si vous avez une fonction avec un seul coude, si vous multipliez l'entrée par deux, alors votre sortie sera également multipliée par deux.

**Différences entre une activation non linéaire ayant des coudes et une activation non linéaire lisse. Pourquoi/quand l'une d'entre elles est préférée ?**
> C'est une question d'équivariance d'échelle. Si le coude est difficile, vous multipliez l'entrée par deux et la sortie est multipliée par deux. Si vous avez une transition en douceur, par exemple si vous multipliez l'entrée par $100$, la sortie semble avoir un coude dur parce que la partie lisse est réduite d'un facteur $100$. Si vous divisez l'entrée par $100$, le coude devient une fonction convexe très lisse. Ainsi, en changeant l'échelle de l'entrée, vous modifiez le comportement de l'unité d'activation.
> Parfois, cela peut poser un problème. Par exemple, lorsque vous entraînez un réseau neuronal multicouche et que vous avez deux couches qui se suivent l'une l'autre. Vous n'avez pas un bon contrôle sur la taille des poids d'une couche par rapport aux poids de l'autre couche. Si vous avez une non-linéarité qui se soucie des échelles, votre réseau n'a pas le choix de la taille de la matrice de poids qui peut être utilisée dans la première couche car cela changera complètement le comportement.
> Une façon de résoudre ce problème est de fixer une échelle dure sur les poids de chaque couche afin de pouvoir normaliser les poids des couches, comme la *batch normalisation*. Ainsi, la variance qui va dans une unité devient toujours constante. Si vous fixez l'échelle, alors le système n'a aucun moyen de choisir quelle partie de la non-linéarité sera utilisée dans deux systèmes de fonction de coude. Cela peut poser un problème si cette partie *fixe* devient trop *linéaire*. Par exemple, Sigmoïde devient presque linéaire près de $0$ et donc les sorties de la *batch normalisation* (proches de $0$) ne pourraient pas être activées *non linéairement*.
> Il n'est pas tout à fait clair pourquoi les réseaux profonds fonctionnent mieux avec des fonctions de coude unique. C'est probablement dû à la propriété d'équivariance d'échelle.


<!--
### Temperature coefficient in a soft(arg)max function

- When do we use the temperature coefficient and why do we use it?

  > To some extent, the temperature is redundant with incoming weights. If you have weighted sums coming into your softmax, the $\beta$ parameter is redundant with the size of weights.

  > Temperature controls how hard the distribution of output will be. When $\beta$ is very large, it becomes very close to either one or zero. When $\beta$ is small, it is softer. When the limit of $\beta$ equals to zero, it is like an average. When $\beta$ goes infinity, it behaves like argmax. It's no longer its soft version. Thus, if you have some sort of normalisation before the softmax then, tuning this parameter allows you to control the hardness.
  > Sometimes, you can start with a small $\beta$ so that you can have well-behaved gradient descents and then, as running proceeds, if you want a harder decision in your attention mechanism, you increase $\beta$. Thus, you can sharpen the decisions. This trick is called as annealing. It can be useful for a mixture of experts like a self attention mechanism.
-->

### Coefficient de température dans une fonction soft(arg)max

**Quand utilisons-nous le coefficient de température et pourquoi l'utilisons-nous ?**
> Dans une certaine mesure, la température est redondante avec les poids entrants. Si vous avez des sommes pondérées qui arrivent dans votre softmax, le paramètre $\beta$ est redondant avec la taille des poids.
 > La température contrôle le degré de difficulté de la distribution des sorties. Lorsque $\beta$ est très grand, il devient très proche de $1$ ou de $0$. Lorsque $\beta$ est petit, il est plus doux. Lorsque la limite de $\beta$ est égale à $0$, c'est comme une moyenne. Lorsque $\beta$ va à l'infini, il se comporte comme argmax. Ce n'est plus sa version douce. Ainsi, si vous avez une sorte de normalisation avant le softmax, alors, le réglage de ce paramètre vous permet de contrôler la dureté.
> Parfois, vous pouvez commencer avec un petit $\beta$ afin d'avoir des descentes de gradient bien conduites et ensuite, au fur et à mesure que la course avance, si vous voulez une décision plus difficile dans votre mécanisme d'attention, vous augmentez $\beta$. Ainsi, vous pouvez affiner les décisions. Il peut être utile pour un mélange d'experts comme un mécanisme d'auto-attention.


<!--
## [Loss functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s)

PyTorch also has a lot of loss functions implemented. Here we will go through some of them.
--> 

## [Fonctions de perte](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s)

PyTorch a également mis en place de nombreuses fonctions de perte. Nous allons en passer quelques-unes en revue ici.

<!--
### `nn.MSELoss()`

This function gives the mean squared error (squared L2 norm) between each element in the input $x$ and target $y$. It is also called L2 loss.

If we are using a minibatch of $n$ samples, then there are $n$ losses, one for each sample in the batch. We can tell the loss function to keep that loss as a vector or to reduce it.

If unreduced (*i.e.* set `reduction='none'`), the loss is

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.

The reduction options are below (note that the default value is `reduction='mean'`).

$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{if reduction='mean'}\\
\text{sum}(L), \quad &\text{if reduction='sum'}
\end{cases}$$

The sum operation still operates over all the elements, and divides by $n$.

The division by $n$ can be avoided if one sets ``reduction = 'sum'``.
--> 

### `nn.MSELoss()`

Cette fonction donne l'erreur quadratique moyenne (norme L2 au carré) entre chaque élément de l'entrée $x$ et la cible $y$. Elle est également appelée perte L2.

Si nous utilisons un mini-lot d'échantillons $n$, alors il y a des pertes $n$, une pour chaque échantillon du lot. Nous pouvons dire à la fonction de perte de conserver cette perte comme vecteur ou de la réduire.

Si elle n'est pas réduite (`reduction='none'`), la perte est :

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

où $N$ est la taille du lot, $x$ et $y$ sont des tenseurs de formes arbitraires avec un total de n éléments chacun.

Les options de réduction sont ci-dessous (notez que la valeur par défaut est `reduction='mean'`).

$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{si reduction='mean'}\\
\text{sum}(L), \quad &\text{si reduction='sum'}
\end{cases}$$

L'opération de la somme fonctionne toujours sur tous les éléments et se divise par $n$.

La division par $n$ peut être évitée si l'on définit ``reduction = 'sum'``.

<!--
### `nn.L1Loss()`

This measures the mean absolute error (MAE) between each element in the input $x$ and target $y$ (or the actual output and desired output).

If unreduced (*i.e.* set `reduction='none'`), the loss is

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

, where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.

It also has `reduction` option of `'mean'` and `'sum'` similar to what `nn.MSELoss()` have.

**Use Case:** L1 loss is more robust against outliers and noise compared to L2 loss. In L2, the errors of those outlier/noisy points are squared, so the cost function gets very sensitive to outliers.

**Problem:** The L1 loss is not differentiable at the bottom (0). We need to be careful when handling its gradients (namely Softshrink). This motivates the following SmoothL1Loss.
--> 

### `nn.L1Loss()`

Elle mesure l'erreur moyenne absolue entre chaque élément de l'entrée $x$ et de la cible $y$ (ou entre la sortie réelle et la sortie souhaitée).

Si elle n'est pas réduite (`reduction='none'`), la perte est

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

où $N$ est la taille du lot, $x$ et $y$ sont des tenseurs de formes arbitraires avec un total de $n$ éléments chacun.

Il dispose également d'une option `reduction` de `'mean'` et `'sum'`, similaire à celle de `nn.MSELoss()`.

**Cas d'utilisation :** la perte L1 est plus robuste contre les valeurs aberrantes et le bruit que la perte L2. En L2, les erreurs de ces points aberrants/bruits sont élevées au carré, de sorte que la fonction de coût devient très sensible aux aberrants.

**Problème :** la perte en L1 n'est pas différentiable dans la partie inférieure (0). Nous devons être prudents lorsque nous traitons ses gradients (à savoir la Softshrink). C'est ce qui motive la perte L1 lisse suivante.


<!--
### `nn.SmoothL1Loss()`

This function uses L2 loss if the absolute element-wise error falls below 1 and L1 loss otherwise.

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
, where $z_i$ is given by

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$

It also has `reduction` options.

This is advertised by Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). The Smooth L1 Loss is also known as the Huber Loss or  the Elastic Network when used as an objective function,.

**Use Case:** It is less sensitive to outliers than the `MSELoss` and is smooth at the bottom. This function is often used in computer vision for protecting against outliers.

**Problem:** This function has a scale ($0.5$ in the function above).
--> 

### `nn.SmoothL1Loss()`

Cette fonction utilise la perte de L2 si l'erreur absolue au niveau de l'élément tombe en dessous de $1$ et la perte de L1 dans le cas contraire.

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
où $z_i$ est donné par

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{si } |x_i - y_i| < 1\\\\
|x_i - y_i| - 0,5, \quad &\text{sinon}
\end{cases}$$

Elle dispose également d'options de `reduction`.

Elle est utilisée par Ross Girshick dans [Fast R-CNN](https://arxiv.org/abs/1504.08083). La perte L1 lisse est également connue sous le nom de perte de Huber ou d’ElasticNet lorsqu'elle est utilisée comme fonction objective.

**Cas d'utilisation :** elle est moins sensible aux valeurs aberrantes que la `MSELoss` et est lisse dans le bas. Cette fonction est souvent utilisée en vision par ordinateur pour se protéger contre les valeurs aberrantes.

**Problème :** cette fonction a une échelle ($0,5$ dans la fonction ci-dessus).


<!--
### L1 *vs.* L2 for Computer Vision

In making predictions when we have a lot of different $y$'s:

* If we use MSE (L2 Loss), it results in an average of all $y$, which in CV it means we will have a blurry image.
* If we use L1 loss, the value $y$ that minimize the L1 distance is the medium, which is not blurry, but note that medium is difficult to define in multiple dimensions.

Using L1 results in sharper image for prediction.
--> 

### L1 vs L2 pour la vision par ordinateur

En faisant des prédictions quand nous avons beaucoup de $y$ différents :

* Si nous utilisons la MSE (perte L2), nous obtenons une moyenne de tous les $y$, ce qui signifie que nous aurons une image floue.
* Si nous utilisons la perte L1, la valeur $y$ qui minimise la distance L1 est le milieu, qui n'est pas flou, mais notons que le milieu est difficile à définir en plusieurs dimensions.

L'utilisation de la distance L1 donne une image plus nette pour la prédiction.

<!--
### `nn.NLLLoss()`

It is the negative log likelihood loss used when training a classification problem with C classes.

Note that, mathematically, the input of `NLLLoss` should be (log) likelihoods, but PyTorch doesn't enforce that. So the effect is to make the desired component as large as possible.

The unreduced (*i.e.* with :attr:`reduction` set to ``'none'``) loss can be described as:

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$

,where $N$ is the batch size.

If `reduction` is not ``'none'`` (default ``'mean'``), then

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{if reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{if reduction} = \text{'sum'.}
        \end{cases}$$

This loss function has an optional argument `weight` that can be passed in using a 1D Tensor assigning weight to each of the classes. This is useful when dealing with imbalanced training set.
-->


### `nn.NLLLoss()`

Il s'agit de la perte de probabilité logarithmique négative utilisée lors de l'entraînement d'un problème de classification à $C$ classes.

Mmathématiquement, l'entrée de `NLLLoss` devrait être la probabilité (log), mais PyTorch ne l'impose pas. L'effet est donc de rendre la composante désirée aussi grande que possible.

La perte non réduite (avec :attr:`reduction` réglé sur `'none'`) peut être décrite comme :

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$

où $N$ est la taille du lot.

Si `reduction` n'est pas à `'none'` (par défaut `'mean'`), alors :

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{si reduction} = \text{"mean";}\\\\
            \sum_{n=1}^N l_n, &
            \text{si reduction} = \text{"sum".}
        \end{cases}$$

Cette fonction de perte a un argument optionnel `weight` qui peut être transmis en utilisant un tenseur 1D qui assigne un poids à chacune des classes. Ceci est utile lorsqu'il s'agit d'un jeu d'entraînement déséquilibré.


<!--
#### Weights & Imbalanced Classes:

Weight vector is useful if the frequency is different for each category/class. For example, the frequency of the common flu is much higher than the lung cancer. We can simply increase the weight for categories that has small number of samples.

However, instead of setting the weight, it's better to equalize the frequency in training so that we can exploits stochastic gradients better.

To equalize the classes in training, we put samples of each class in a different buffer. Then generate each minibatch by picking the same number samples from each buffer. When the smaller buffer runs out of samples to use, we iterate through the smaller buffer from the beginning again until every sample of the larger class is used. This way gives us equal frequency for all categories by going through those circular buffers. We should never go the easy way to equalize frequency by **not** using all samples in the majority class. Don't leave data on the floor!

An obvious problem of the above method is that our NN model wouldn't know the relative frequency of the actual samples. To solve that, we fine-tune the system by running a few epochs at the end with the actual class frequency, so that the system adapts to the biases at the output layer to favour things that are more frequent.

To get an intuition of this scheme, let's go back to the medical school example: students spend just as much time on rare disease as they do on frequent diseases (or maybe even more time, since the rare diseases are often the more complex ones). They learn to adapt to the features of all of them, then correct it to know which are rare.
--> 

#### Poids et classes déséquilibrées :

Le vecteur de poids est utile si la fréquence est différente pour chaque catégorie/classe. Par exemple, la fréquence de la grippe commune est beaucoup plus élevée que celle du cancer du poumon. Nous pouvons simplement augmenter le poids pour les catégories qui ont un petit nombre d'échantillons.

Cependant, au lieu de fixer le poids, il est préférable d'égaliser la fréquence à l'entraînement afin de mieux exploiter les gradients stochastiques.

Pour égaliser les classes à l'entraînement, nous plaçons des échantillons de chaque classe dans une mémoire tampon différente. Ensuite, nous générons chaque mini-batch en prélevant le même nombre d'échantillons dans chaque tampon. Lorsque le petit tampon est à court d'échantillons à utiliser, nous itérons à nouveau à travers le petit tampon depuis le début jusqu'à ce que chaque échantillon de la grande classe soit utilisé. De cette façon, nous obtenons une fréquence égale pour toutes les catégories en passant par ces tampons. Nous ne devrions jamais utiliser la méthode facile pour égaliser la fréquence en **n’** utilisant **pas** tous les échantillons de la classe majoritaire. Ne laissez pas de données de côté !

Un problème évident de la méthode ci-dessus est que notre modèle ne connaîtrait pas la fréquence relative des échantillons réels. Pour résoudre ce problème, nous affinons le système en exécutant quelques époques à la fin avec la fréquence réelle de la classe, de sorte que le système s'adapte aux biais de la couche de sortie pour favoriser les choses qui sont plus fréquentes.

Pour avoir une intuition de ce schéma, revenons à l'exemple de la faculté de médecine : les étudiants passent autant de temps sur les maladies rares que sur les maladies fréquentes (ou peut-être même plus de temps, puisque les maladies rares sont souvent les plus complexes). Ils apprennent à s'adapter aux caractéristiques de chacune d'entre elles, puis à les corriger pour savoir lesquelles sont rares.


<!--
### `nn.CrossEntropyLoss()`

This function combines `nn.LogSoftmax` and `nn.NLLLoss` in one single class. The combination of the two makes the score of the correct class as large as possible.

The reason why the two functions are merged here is for numerical stability of gradient computation. When the value after softmax is close to 1 or 0, the log of that can get close to 0 or $-\infty$. Slope of log close to 0 is close to $\infty$, causing the intermediate step in backpropagation to have numerical issues. When the two functions are combined, the gradients is saturated so we get a reasonable number at the end.

The input is expected to be unnormalised score for each class.

The loss can be described as:

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$

or in the case of the `weight` argument being specified:

$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

The losses are averaged across observations for each minibatch.

A physical interpretation of the Cross Entropy Loss is related to the Kullback–Leibler divergence (KL divergence), where we are measuring the divergence between two distributions. Here, the (quasi) distributions are represented by the x vector (predictions) and the target distribution (a one-hot vector with 0 on the wrong classes and 1 on the right class).

Mathematically,

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

where $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ is the cross-entropy (between two distributions), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ is the entropy, and $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ is the KL divergence.
--> 

### `nn.CrossEntropyLoss()`

Cette fonction combine `nn.LogSoftmax` et `nn.NLLLoss` dans une seule classe. La combinaison des deux rend le score de la classe correcte aussi grand que possible.

La raison pour laquelle les deux fonctions sont fusionnées ici est la stabilité numérique du calcul du gradient. Lorsque la valeur après softmax est proche de $1$ ou $0$, le log de cette fonction peut se rapprocher de $0$ ou $-\infty$. La pente du log proche de $0$ est proche de $-\infty$, ce qui entraîne des problèmes numériques à l'étape intermédiaire de la rétropropagation. Lorsque les deux fonctions sont combinées, le gradient est saturé, de sorte que nous obtenons un nombre raisonnable à la fin.

On s'attend à ce que l'entrée soit un score non normalisé pour chaque classe.

La perte peut être décrite comme suit :

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$


ou dans le cas où l'argument `weight` est spécifié :

$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

La moyenne des pertes est calculée à partir des observations de chaque mini-batch.

Une interprétation physique de la perte d'entropie croisée est liée à la divergence de Kullback-Leibler (divergence KL), où nous mesurons la divergence entre deux distributions. Ici, les (quasi) distributions sont représentées par le vecteur $x$ (prédictions) et la distribution cible (un vecteur *one-hot* avec $0$ sur les mauvaises classes et $1$ sur la bonne classe).

Mathématiquement :

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

où $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ est l'entropie croisée (entre deux distributions), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ est l'entropie, et $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ est la divergence KL.

<!--
### `nn.AdaptiveLogSoftmaxWithLoss()`

This is an efficient softmax approximation of softmax for large number of classes (for example, millions of classes). It implements tricks to improve the speed of the computation.

Details of the method is described in [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) by Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou.
-->

### `nn.AdaptiveLogSoftmaxWithLoss()`

Il s'agit d'une approximation efficace de la softmax pour un grand nombre de classes (par exemple, des millions de classes). Elle met en œuvre des astuces pour améliorer la rapidité du calcul.
Les détails de la méthode sont décrits dans [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) de Grave et al.
