---
lang: fr
lang-ref: ch.10-3
title: Le Truck Backer-Upper
lecturer: Alfredo Canziani
authors: Muyang Jin, Jianzhi Li, Jing Qian, Zeming Lin
date: 7 Apr 2020
translation-date: 22 Aug 2020
translator: Loïck Bourdois
---

<div hidden>
    $$\gdef \tcab {\Theta_{\mathrm{cab}}}$$
    $$\gdef \xcab {x_{\mathrm{cab}}}$$
    $$\gdef \ycab {y_{\mathrm{cab}}}$$
    $$\gdef \ttrailer {\Theta_{\mathrm{trailer}}}$$
    $$\gdef \xtrailer {x_{\mathrm{trailer}}}$$
    $$\gdef \ytrailer {y_{\mathrm{trailer}}}$$
</div>


<!--
## [Setup](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s)

The goal of this task is to build a **self-learning controller** which controls the steering of the truck while it backs up to the loading dock from any arbitrary initial position.

Note that **only backing up is allowed,** as shown below in Figure 1.

|![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>Fig. 1</b>: The Truck, Trailer and Loading Dock</center>|

The **state** of the truck is represented by six parameters:

 - $\tcab$: Angle of the truck
 - $\xcab, \ycab$: The cartesian of the yoke (or front of the trailer).
 - $\ttrailer$: Angle of the trailer
 - $\xtrailer, \ytrailer$: The cartesian of the (back of the) trailer.

The **goal** of the controller is to select an appropriate angle $\phi$ at each time $k$, where after the truck will back up in a fixed small distance. Success depends on two criteria:
1. The back of the trailer is parallel to the wall loading dock, *e.g.* $\ttrailer = 0$.
2. The back of the trailer ($\xtrailer, \ytrailer$) is as close as possible to the point ($x_{dock}, y_{dock}$) as shown above.
-->

## [Configuration](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s)

Le but est de construire un contrôleur autosupervisé qui contrôle la direction du camion pendant qu'il recule vers le quai de chargement à partir de n'importe quelle position initiale arbitraire.

A noter que **seul le recul est autorisé**, comme le montre la figure 1 ci-dessous.

| ![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>Figure 1 : </b> Le camion, la remorque et le quai de chargement</center>|

L'état du camion est représenté par six paramètres :

 - $\tcab$ : angle du camion
 -  $\xcab, \ycab$ : le cartésien de l'avant de la remorque.
 - $\ttrailer$ : angle de la remorque
 - $\xtrailer, \ytrailer$ : le cartésien de l'arrière de la remorque.

Le but du contrôleur est de sélectionner un angle approprié $\phi$ à chaque temps $k$, où après le camion reculera sur une petite distance fixe. Le succès dépend de deux critères :
1. L'arrière de la remorque est parallèle au quai de chargement mural, par exemple $\ttrailer = 0$.
2. L'arrière de la remorque ($\xtrailer, \ytrailer$) est aussi proche que possible du point ($x_{dock}, y_{dock}$) indiqué ci-dessus.



<!--
## More Parameters and Visualization

|![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>Fig. 2</b>: Parameters for visualization</center>|

In this section, we also consider a few more parameters shown in Figure 2.
Given car length $L$, $d_1$ the distance between car and trailer and $d_2$ the length of the trailer, etc, we can calculate the change of angle and positions:

$$
\begin{aligned}
\dot{\theta_0} &= \frac{s}{L}\tan(\phi)\\
\dot{\theta_1} &= \frac{s}{d_1}\sin(\theta_1 - \theta_0)\\
\dot{x}        &= s\cos(\theta_0)\\
\dot{y}        &= s\sin(\theta_0)
\end{aligned}
$$

Here, $s$ denotes the signed speed and $\phi$ the negative steering angle.
Now we can represent the state by only four parameters: $\xcab$, $\ycab$, $\theta_0$ and $\theta_1$.
This is because Length parameters are known and $\xtrailer, \ytrailer$ is determined by $\xcab, \ycab, d_1, \theta_1$.

In the Jupyter Notebook from the Deep Learning repository, we have some sample environments shown in Figures 3.(1-4):

| <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **Fig. 3.1**: Sample plot of the environment | **Fig. 3.2**: Driving into itself (jackknifing) |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
| **Fig. 3.3**: Going out of boundary |**Fig. 3.4**: Reaching the dock|

At each time step $k$, a steering signal which ranges from $-\frac{\pi}{4}$ to $\frac{\pi}{4}$ will be fed in and the truck will take back up using the corresponding angle.

There are several situations where the sequence can end:
 - If the truck drives into itself (jackknifes, as in Figure 3.2)
 - If the truck goes out of boundary (shown in Figure 3.3)
 - If the truck reaches the dock (shown in Figure 3.4)
-->


## Plus de paramètres et de visualisation

| ![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>Figure 2 :</b> Paramètres de visualisation</center>|

Dans cette section, nous examinons quelques autres paramètres illustrés dans la figure 2.
Étant donné la longueur de la voiture $L$, $d_1$ la distance entre la voiture et la remorque et $d_2$ la longueur de la remorque, nous pouvons calculer le changement d'angle et de positions :

$$
\begin{aligned}
\dot{\theta_0} &= \frac{s}{L}\tan(\phi)\\
\dot{\theta_1} &= \frac{s}{d_1}\sin(\theta_1 - \theta_0)\\
\dot{x}        &= s\cos(\theta_0)\\
\dot{y}        &= s\sin(\theta_0)
\end{aligned}
$$

Ici, $s$ indique la vitesse signée et $\phi$ l'angle de braquage négatif.
Maintenant, nous pouvons représenter l'état par seulement quatre paramètres : $\xcab$, $\ycab$, $\theta_0$ et $\theta_1$.
Cela s'explique par le fait que les paramètres de longueur sont connus et que $\xtrailer, \ytrailer$ est déterminé par $\xcab, \ycab, d_1, \theta_1$.

Les exemples d'environnements illustrés dans les figures 3 (1-4) peuvent être obtenus en exécutant le *notebook* Jupyter dont la version anglaise est disponible [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/14-truck_backer-upper.ipynb) et la française [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/14-truck_backer-upper.ipynb) :

| <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **Figure 3.1** : Représentation<br> de l'environnement | **Figure 3.2** : Mise en portefeuille |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
| **Figure 3.3** : Sortie du cadre |**Figure 3.4** : Atteindre le quai |

À chaque pas de temps $k$, un signal de direction allant de $-\frac{\pi}{4}$ à $\frac{\pi}{4}$ est introduit et le camion reprend la route en utilisant l'angle correspondant.

Il existe plusieurs situations dans lesquelles la séquence peut se terminer :
 - Si le camion se rentre dedans (mise en portefeuille, comme dans la figure 3.2)
 - Si le camion sort de la limite (comme dans la figure 3.3)
 - Si le camion atteint le quai (comme sur la figure 3.4)



<!--
## [Training](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s)

The training process involves two stages: (1)  training of a neural network to be an emulator of the truck and trailer kinematics and (2) training of a neural network controller to control the truck.


| ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>Fig. 4</b>: Overview Diagram </center> |

As shown above, in the abstract diagram, the two blocks are the two networks that will be trained. At each time step $k$, the "Trailer Truck Kinematics", or what we have been calling the emulator, takes in the 6-dimension state vector and the steering signal generated from the controller and generate a new 6-dimension state at time $k + 1$.
-->

## [Entraînement](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s)

Le processus d’entraînement comporte deux étapes :
- entraînement d'un réseau de neurones pour devenir un émulateur de la cinématique du camion et de la remorque 
- entraînement d'un réseau de neurones pour contrôler le camion


| ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>Figure 4 :</b> Diagramme général </center> |

Comme indiqué ci-dessus, dans le diagramme abstrait, les deux blocs sont les deux réseaux qui seront formés. À chaque pas de temps $k$, la cinématique du camion-remorque (ce que nous avons appelé émulateur), prend en compte le vecteur d'état en 6 dimensions et le signal de direction généré par le contrôleur et génère un nouvel état en 6 dimensions au temps $k + 1$.


<!--
### Emulator

The emulator takes the current location ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) plus the steering direction $\phi^t$ as input and outputs the state at next timestep ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). It consists of a linear hidden layer, with ReLu activation function, and an linear output layer. We use MSE as the loss function and train the emulator via stochastic gradient descent.

|![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
|  <center><b>Fig. 5</b>: Training the Neural-net Emulator</center>|

In this setup, the the simulator can tell us the location of next step given the current location and steering angle. Therefore, we don’t really need a neural-net that emulates the simulator. However, in a more complex system, we may not have access to the underlying equations of the system, *i.e.* we do not have the laws of the universe in a nice computable form. We may only observe data that records sequences of steering signals and their corresponding paths. In this case, we want to train a neural-net to emulate the dynamic of this complex system.

In order to train enumlator, there are two important function in `Class truck` we need to look into when we train the emulator.

First is the `step` function which gives the output state of the truck after computation.

```python
def step(self, ϕ=0, dt=1):

    # Check for illegal conditions
    if self.is_jackknifed():
        print('The truck is jackknifed!')
        return

    if self.is_offscreen():
        print('The car or trailer is off screen')
        return

    self.ϕ = ϕ
    x, y, W, L, d, s, θ0, θ1, ϕ = self._get_atributes()

    # Perform state update
    self.x += s * cos(θ0) * dt
    self.y += s * sin(θ0) * dt
    self.θ0 += s / L * tan(ϕ) * dt
    self.θ1 += s / d * sin(θ0 - θ1) * dt
```

Second is the `state` function which gives the current state of the truck.

```python
def state(self):
        return (self.x, self.y, self.θ0, *self._traler_xy(), self.θ1)
```

We generate two lists first. We generate an input list by appending the randomly generated steering angle `ϕ` and the initial state which coming from the truck by running `truck.state()`. And we generate an output list that is appended by the output state of the truck which can be computed by `truck.step(ϕ)`.

We now can train the emulator:

```python
cnt = 0
for i in torch.randperm(len(train_inputs)):
    ϕ_state = train_inputs[i]
    next_state_prediction = emulator(ϕ_state)

    next_state = train_outputs[i]
    loss = criterion(next_state_prediction, next_state)

    optimiser_e.zero_grad()
    loss.backward()
    optimiser_e.step()

    if cnt == 0 or (cnt + 1) % 1000 == 0:
        print(f'{cnt + 1:4d} / {len(train_inputs)}, {loss.item():.10f}')
    cnt += 1
```

Notice that `torch.randperm(len(train_inputs))` gives us a random permutation of the indices within the range $0$ to length of training inputs minus $1$. After the permutation of indices, each time `ϕ_state` is chosen from the input list at the index `i`. We input `ϕ_state` through the emulator function that has a linear output layer and we get `next_state_prediction`. Notice that the emulator is a neural netork defined as below:

```python
emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)
```

Here we use MSE to calculate the loss between the true next state and the next state prediction, where the true next state is coming from the output list with index `i` that corresponding to the index of the `ϕ_state` from input list.
-->


### Emulateur

L'émulateur prend l'emplacement actuel ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) plus le sens de direction $\phi^t$ comme entrée et sort l'état au pas de temps suivant ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). Il se compose d'une couche cachée linéaire, avec fonction d'activation *ReLU*, et d'une couche de sortie linéaire. Nous utilisons la MSE comme fonction de perte et entraînons l'émulateur via une descente de gradient stochastique.

| ![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
| <center><b>Figure 5 :</b> Entraînement de l'émulateur du réseau neuronal</center>|

Dans cette configuration, le simulateur peut nous indiquer l'emplacement de l'étape suivante, compte tenu de la position actuelle et de l'angle de braquage. Par conséquent, nous n'avons pas vraiment besoin d'un réseau neuronal qui émule le simulateur. Cependant, dans un système plus complexe, nous pouvons ne pas avoir accès aux équations sous-jacentes du système, c'est-à-dire que nous n'avons pas les lois de l'univers sous une forme calculable agréable. Nous ne pouvons observer que des données qui enregistrent des séquences de signaux de direction et leurs trajectoires correspondantes. Dans ce cas, nous voulons entraîner un réseau de neurones pour émuler la dynamique de ce système complexe.

Afin d’entraîner l'énumérateur, il y a deux fonctions importantes dans le `Class truck` que nous devons examiner lorsque nous formons l'émulateur.

La première est la fonction `step` qui donne l'état de sortie du camion après le calcul.


```python
def step(self, ϕ=0, dt=1):

    # Vérifictions des conditions
    if self.is_jackknifed():
        print("Le camion s'est mis en portefeuille !")
        return

    if self.is_offscreen():
        print("Véhicule hors de l'écran")
        return

    self.ϕ = ϕ
    x, y, W, L, d, s, θ0, θ1, ϕ = self._get_atributes()

    # Effectuer une mise à jour de l'état
    self.x += s * cos(θ0) * dt
    self.y += s * sin(θ0) * dt
    self.θ0 += s / L * tan(ϕ) * dt
    self.θ1 += s / d * sin(θ0 - θ1) * dt
```

La seconde est la fonction `state` qui donne l'état actuel du camion.

```python
def state(self):
        return (self.x, self.y, self.θ0, *self._traler_xy(), self.θ1)
```

Nous générons d'abord deux listes
-	une liste d'entrée en ajoutant l'angle de braquage généré aléatoirement `ϕ` et l'état initial qui provient du camion en exécutant `truck.state()`
-	une liste de sortie à laquelle est ajouté l'état de sortie du camion qui peut être calculé par `truck.step(ϕ)`.

Nous pouvons maintenant entraîner l'émulateur :

```python
cnt = 0
for i in torch.randperm(len(train_inputs)):
    ϕ_state = train_inputs[i]
    next_state_prediction = emulator(ϕ_state)

    next_state = train_outputs[i]
    loss = criterion(next_state_prediction, next_state)

    optimiser_e.zero_grad()
    loss.backward()
    optimiser_e.step()

    if cnt == 0 or (cnt + 1) % 1000 == 0:
        print(f'{cnt + 1:4d} / {len(train_inputs)}, {loss.item():.10f}')
    cnt += 1
```

Remarquons que `torch.randperm(len(train_inputs))` nous donne une permutation aléatoire des indices dans la fourchette $0$ à la longueur des entrées d’entrainement moins $1$. Après la permutation des indices, chaque fois que `ϕ_state` est choisi dans la liste des entrées à l'index `i`. Nous entrons `ϕ_state` par la fonction de l'émulateur qui a une couche de sortie linéaire et nous obtenons `next_state_prediction`.  
L'émulateur est un réseau de neurones défini comme ci-dessous :

```python
emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)
```

Ici, nous utilisons la MSE pour calculer la perte entre le véritable état suivant et la prédiction de l'état suivant, où le véritable état suivant provient de la liste de sortie avec l'indice `i` qui correspond à l'indice de l'état `ϕ_state` de la liste d'entrée.


<!--
### Controller

Refer to Figure 5. Block $\matr{C}$ represents the controller. It takes in the current state and ouputs a steering angle. Then block $\matr{T}$ (emulator) takes both the state and angle to produce the next state.

|![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
| <center><b>Fig. 5</b>: State Transition flow diagram</center>|

To train the controller, we start from a random initial state and repeat the procedure($\matr{C}$ and $\matr{T}$) until the trailer is parallel to the dock. The error is calculated by comparing the trailer location and dock location.
We then find the gradients using backpropagation and update parameters of the controller via SGD.
-->

### Contrôleur

Le bloc $\matr{C}$ représente le contrôleur. Il prend en compte l'état actuel et fournit un angle de braquage. Ensuite, le bloc $\matr{T}$ (émulateur) prend à la fois l'état et l'angle pour produire l'état suivant.

| ![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
| <center><b>Figure 6 :</b> Diagramme de transition d'état</center>|

Pour entraîner le contrôleur, nous partons d'un état initial aléatoire et répétons la procédure ($\matr{C}$ et $\matr{T}$) jusqu'à ce que la remorque soit parallèle au quai. L'erreur est calculée en comparant l'emplacement de la remorque et l'emplacement du quai.
Nous trouvons ensuite les gradients en utilisant la rétropropagation et mettons à jour les paramètres du contrôleur via SGD.

<!--
### [Detailed Model Structure](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s)

This is a detailed graph of ($\matr{C}$, $\matr{T}$) process. We start with a state (6 dimension vector), multiply it with a tunable weights matrix and get 25 hidden units. Then we pass it through another tunable weights vector to get the output (steering signal). Similarly, we input the state and angle $\phi$ (7 dimension vector) through two layers to produce the state of next step.

![]({{site.baseurl}}/images/week10/10-3/fig14.png)

To see this more clearly, we show the exact implementation of the emulator:

```python
state_size = 6
steering_size = 1
hidden_units_e = 45

emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)

optimiser_e = SGD(emulator.parameters(), lr=0.005)
criterion = nn.MSELoss()
```
-->

### [Structure détaillée du modèle](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s)

Voici un graphique détaillé du processus ($\matr{C}$, $\matr{T}$). Nous commençons par un état (vecteur à $6$ dimensions), le multiplions par une matrice de poids accordables et obtenons $25$ unités cachées. Ensuite, nous le faisons passer par un autre vecteur de poids accordables pour obtenir la sortie (signal de direction). De même, nous introduisons l'état et l'angle $\phi$ (vecteur à $7$ dimensions) à travers deux couches pour produire l'état de l'étape suivante.


| ![]({{site.baseurl}}/images/week10/10-3/fig14.png)|
| <center><b>Figure 7 :</b> Détails de l'émulateur et du contrôleur</center>|

Pour y voir plus clair, nous montrons l’implémentation exacte de l'émulateur :


```python
state_size = 6
steering_size = 1
hidden_units_e = 45

emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)

optimiser_e = SGD(emulator.parameters(), lr=0.005)
criterion = nn.MSELoss()
```


<!--
### Examples of Movement

Following are four examples of movement for different initial state. Notice that the number of time steps in each episode varies.

|![]({{site.baseurl}}/images/week10/10-3/fig16.png) | ![]({{site.baseurl}}/images/week10/10-3/fig17.png) |
|![]({{site.baseurl}}/images/week10/10-3/fig18.png) | ![]({{site.baseurl}}/images/week10/10-3/fig19.png) |
-->
### Exemples de mouvements

Voici quatre exemples de mouvements pour différents états initiaux. A noter que le nombre de pas de temps dans chaque épisode varie.

| ![]({{site.baseurl}}/images/week10/10-3/fig16.png) | ![]({{site.baseurl}}/images/week10/10-3/fig17.png) |
| ![]({{site.baseurl}}/images/week10/10-3/fig18.png) | ![]({{site.baseurl}}/images/week10/10-3/fig19.png) |
| <center><b>Figure 8 :</b> Exemples de mouvements pour quatre états initiaux différents</center>|


<!--
### Additional Resources:

A full working demo can be found at: [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Please check out the code as well, which can be found at [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper).
-->

### Ressources supplémentaires :
Une démonstration complète est disponible à l'adresse suivante [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Il est aussi possible de consulter le code qui se trouve à l'adresse suivante : [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper).
