---
lang: fr
lang-ref: ch.10-2
title: Apprentissage autosupervisé, ClusterFit et PIRL
lecturer: Ishan Misra
authors: Zhonghui Hu, Yuqing Wang, Alfred Ajay Aureate Rajakumar, Param Shah
date: 6 Apr 2020
translation-date: 10 Aug 2020
translator: Loïck Bourdois
---


<!--
### [What is missing from "pretext" tasks? The hope of generalization](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)

Pretext task generally comprises of pretraining steps which is self-supervised and then we have our transfer tasks which are often classification or detection. We *hope* that the pretraining task and the transfer tasks are "aligned", meaning, solving the pretext task will help solve the transfer tasks very well. So, a lot of research goes into designing a pretext task and implementing them really well.

However, it is very unclear why performing a non-semantic task should produce good features?. For example, why should we expect to learn about “semantics” while solving something like Jigsaw puzzle? Or why should “predicting hashtags” from images be expected to help in learning a classifier on transfer tasks? Therefore, the question remains. How should we design good pre-training tasks which are well aligned with the transfer tasks?

One way to evaluate this problem is by looking at representations at each layer (refer Fig. 1). If the representations from the last layer are not well aligned with the transfer task, then the pretraining task may not be the right task to solve.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>Fig. 1</b>: Feature representations at each layer
</center>

Fig. 2 plots the Mean Average Precision at each layer for Linear Classifiers on VOC07 using Jigsaw Pretraining. It is clear that the last layer is very specialized for the Jigsaw problem.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>Fig. 2</b>: Performance of Jigsaw based on each layer
</center>
-->

### [Que manque-t-il aux tâches de prétexte ? L'espoir de la généralisation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)

La tâche de prétexte comprend généralement des étapes de pré-entraînement qui sont autosupervisées. Puis nous avons nos tâches de transfert qui sont souvent de classification ou de détection. Nous espérons que la tâche de pré-entraînement et les tâches de transfert sont « alignées », c’est-à-dire que la résolution de la tâche de prétexte aide à résoudre notre tâche de transfert. Ainsi, beaucoup de recherches sont nécessaires afin de concevoir une tâche de prétexte et la mettre en œuvre de façon optimale.

Cependant, il est très difficile de savoir pourquoi l'exécution d'une tâche non sémantique produit de bonnes caractéristiques. Par exemple, pourquoi devrions-nous nous attendre à apprendre la « sémantique » tout en résolvant quelque chose comme un puzzle ? Ou pourquoi prédire les mots-dièse à partir d'images aide à apprendre un classifieur sur des tâches de transfert ? Comment concevoir de bonnes tâches de pré-entraînement qui soient bien alignées avec les tâches de transfert ?

Une façon d'évaluer ce problème est d'examiner les représentations à chaque couche (voir figure 1). Si les représentations de la dernière couche ne sont pas bien alignées avec la tâche de transfert, alors la tâche de pré-entraînement peut ne pas être la bonne tâche à résoudre.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>Figure 1</b> : Représentation des éléments à chaque couche
</center>

La figure 2 représente la précision moyenne à chaque couche pour des classifieurs linéaires sur le jeu de données VOC07 avec un pré-entraînement Jigsaw. Il est clair que la dernière couche est très spécialisée pour le problème Jigsaw.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>Figure 2 :</b> Performance de Jigsaw en fonction de chaque couche
</center>


<!--
### What we want from pre-trained features?

* Represent how images relate to one another

  * ClusterFit: Improving Generalization of Visual Representations

* Be robust to "nuisance factors" -- Invariance

  *E.g.* exact location of objects, lighting, exact colour

  * PIRL: Self-supervised learning of Pre-text Invariant Representations

Two ways to achieve the above properties are **Clustering** and **Contrastive Learning**. They have started performing much better than whatever pretext tasks that were designed so far.  One method that belongs to clustering is **ClusterFit** and another falling into invariance is **PIRL**.
-->

### Qu'attendons-nous des caractéristiques pré-entraînées ?

* Représenter la façon dont les images sont liées les unes aux autres => *ClusterFit* : améliorer la généralisation des représentations visuelles

* Être robuste aux facteurs de nuisance, c'est à dire être invariant, par exemple à l'éclairage, l'emplacement exact des objets, la couleur => *PIRL* : apprentissage autosupervisé des représentations invariantes du prétexte

Deux moyens d'atteindre les propriétés ci-dessus sont le *clustering* et l'*apprentissage contrastif*. Ils ont commencé à fonctionner bien mieux que les tâches de prétexte conçues jusqu'à présent. Une méthode qui appartient au clustering est **ClusterFit** et une autre qui tombe dans l'invariance est **PIRL**.


<!--
## ClusterFit: Improving Generalization of Visual Representations

Clustering the feature space is a way to see what images relate to one another.
-->

## ClusterFit : améliorer la généralisation des représentations visuelles

Le clustering de l'espace des caractéristiques est un moyen de voir quelles images sont liées les unes aux autres.

<!--
### Method

ClusterFit follows two steps.  One is the cluster step, and the other is the predict step.
-->

### Méthode

ClusterFit suit deux étapes.  L'une est l'étape du cluster, l'autre est l'étape de la prédiction.

<!--
#### Cluster: Feature Clustering

We take a pretrained network and use it to extract a bunch of features from a set of images. The network can be any kind of pretrained network. K-means clustering is then performed on these features, so each image belongs to a cluster, which becomes its label.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>Fig. 3</b>: Cluster step
</center>
-->

#### Cluster : regroupement des caractéristiques

Nous prenons un réseau pré-entraîné et l'utilisons pour extraire un ensemble de caractéristiques d'un ensemble d'images. Le réseau peut être n'importe quel type de réseau pré-entraîné. Les $K$-means sont alors effectués sur ces caractéristiques, de sorte que chaque image appartient à un cluster qui devient son label.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>Figure 3 :</b> Etape du cluster
</center>


<!--
#### Fit: Predict Cluster Assignment

For this step, we train a network from scratch to predict the pseudo labels of images. These pseudo labels are what we obtained in the first step through clustering.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>Fig. 4</b>: Predict step
</center>

A standard pretrain and transfer task first pretrains a network and then evaluates it in downstream tasks, as it is shown in the first row of Fig. 5. ClusterFit performs the pretraining on a dataset $D_{cf}$ to get the pretrained network $N_{pre}$. The pretrained network $N_{pre}$ are performed on dataset $D_{cf}$ to generate clusters. We then learn a new network $N_{cf}$from scratch on this data. Finally, use $N_{cf}$ for all downstream tasks.
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>Fig. 5</b>: "Standard" pretrain + transfer *vs.* "Standard" pretrain + ClusterFit
</center>
-->

#### Entraînement : prévoir l'affectation des clusters

Pour cette étape, nous entraînons un réseau à partir de zéro afin de prédire les pseudo labels des images. Ces pseudo labels sont ceux que nous avons obtenus lors de la première étape par le clustering.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>Figure 4 :</b> Etape de prédiction
</center>

Une tâche standard de pré-entraînement et de transfert pré-entraîne d'abord un réseau et l'évalue ensuite sur des tâches en aval, comme le montre la première ligne de la figure 5. ClusterFit effectue le pré-entraînement sur un jeu de données $D_{cf}$ pour obtenir le réseau pré-entraîné $N_{pre}$. Le pré-entraînement $N_{pre}$ est effectué sur un jeu de données $D_{cf}$ pour générer des clusters. Nous apprenons ensuite un nouveau réseau $N_{cf}$ à partir de zéro sur ces données. Enfin, on utilise $N_{cf}$ pour toutes les tâches en aval.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>Figure 5</b> Pré-entraînement standard + transfert vs Pré-entraînement standard + ClusterFit
</center>

<!--
### Why ClusterFit Works

The reason why ClusterFit works is that in the clustering step only the essential information is captured, and artefacts are thrown away making the second network learn something slightly more generic.

To understand this point, a fairly simple experiment is performed.  We add label noise to ImageNet-1K, and train a network based on this dataset. Then, we evaluate the feature representation from this network on a downstream task on ImageNet-9K. As it is shown in Fig. 6, we add different amounts of label noise to the ImageNet-1K, and evaluate the transfer performance of different methods on ImageNet-9K.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>Fig. 6</b>: Control Experiment
</center>

The pink line shows the performance of pretrained network, which decreases as the amount of label noise increases. The blue line represents model distillation where we take the initial network and use it to generate labels. Distillation generally performs better than pretrained network.  The green line, ClusterFit, is consistently better than either of these methods. This result validates our hypothesis.

* Question: Why use distillation method to compare. What's the difference between distillation and ClusterFit?

In model distillation we take the pre-trained network and use the labels the network predicted in a softer fashion to generate labels for our images. For example, we get a distribution over all the classes and use this distribution to train the second network. The softer distribution helps enhance the initial classes that we have. In ClusterFit we don't care about the label space.
-->

### Pourquoi ClusterFit fonctionne ?

La raison pour laquelle ClusterFit fonctionne est que lors de l'étape de clustering, seules les informations essentielles sont saisies et les artefacts sont jetés, ce qui permet au second réseau d'apprendre quelque chose de légèrement plus générique.

Pour comprendre ce point, une expérience assez simple est réalisée. Nous ajoutons un bruit de label à ImageNet-1K et entraînons un réseau basé sur ce jeu de données. Ensuite, nous évaluons la représentation des caractéristiques de ce réseau sur une tâche en aval sur ImageNet-9K. Comme le montre la figure 6, nous ajoutons différentes quantités de bruit de label au réseau ImageNet-1K et nous évaluons les performances de transfert de différentes méthodes sur ImageNet-9K.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>Figure 6 :</b> Expérience de contrôle
</center>

La ligne rose indique les performances du réseau pré-entraîné, qui diminuent à mesure que le bruit du label augmente. La ligne bleue représente la distillation du modèle où nous prenons le réseau initial et l'utilisons pour générer des labels. La distillation est généralement plus performante que le réseau pré-entraîné.  La ligne verte, ClusterFit, est toujours meilleure que l'une ou l'autre de ces méthodes. Ce résultat valide notre hypothèse.

**Pourquoi utiliser la méthode de distillation pour comparer ? Quelle est la différence entre la distillation et ClusterFit ?**

> Dans la distillation de modèle, nous prenons le réseau pré-entraîné et utilisons les labels que le réseau a prédits de manière plus douce pour générer des labels pour nos images. Par exemple, nous obtenons une répartition sur toutes les classes et utilisons cette répartition pour entraîner le second réseau. La distribution plus douce permet d'améliorer les classes initiales que nous avons. Dans ClusterFit, nous ne nous soucions pas de l'espace du label.

<!--
### Performance

We apply this method to self-supervised learning. Here Jigsaw is applied to obtain the pretrained network $N_{pre}$ in ClusterFit. From Fig. 7 we see that the transfer performance on different datasets shows a surprising amount of gains, compared to other self-supervised methods.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>Fig. 7</b>: Transfer performance on different datasets
</center>

ClusterFit works for any pre-trained network. Gains without extra data, labels or changes in architecture can be seen in Fig. 8. So in some way, we can think of the ClusterFit as a self-supervised fine-tuning step, which improves the quality of representation.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>Fig. 8</b>: Gains without extra data, labels or changes in architecture
</center>
-->

### Performance

Nous appliquons cette méthode à l'apprentissage autosupervisé. Ici, Jigsaw est appliqué pour obtenir le réseau pré-entraîné $N_{pre}$ dans ClusterFit. La figure 7 montre que les performances de transfert sur différents jeux de données montrent des gains surprenants par rapport à d'autres méthodes autosupervisées.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>Figure 7 :</b> Performances de transfert sur différents jeux de données
</center>

ClusterFit fonctionne pour tout réseau pré-entraîné. Les gains sans données supplémentaires, labels ou changements d'architecture sont visibles dans la figure 8. D'une certaine manière, on peut donc considérer ClusterFit comme une étape de *finetuning* autosupervisée améliorant la qualité de la représentation.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>Figure 8 :</b> Gains sans données supplémentaires, sans labels ni changements d'architecture
</center>

<!--
## [Self-supervised Learning of Pretext Invariant Representations (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)
-->

## [PIRL : apprentissage autosupervisé des représentations invariantes de prétexte](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)

<!--
### Contrastive Learning

Contrastive learning is basically a general framework that tries to learn a feature space that can combine together or put together points that are related and push apart points that are not related.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>Fig. 9</b>: Groups of Related and Unrelated Images
</center>

In this case, imagine like the blue boxes are the related points, the greens are related, and the purples are related points.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>Fig. 10</b>: Contrastive Learning and Loss Function
</center>

Features for each of these data points would be extracted through a shared network, which is called Siamese Network to get a bunch of image features for each of these data points. Then a contrastive loss function is applied to try to minimize the distance between the blue points as opposed to, say, the distance between the blue point and the green point. Or the distance basically between the blue points should be less than the distance between the blue point and green point or the blue point and the purple point. So, embedding space from the related samples should be much closer than embedding space from the unrelated samples. So that's the general idea of what contrastive learning is and of course Yann was one of the first teachers to propose this method. So contrastive learning is now making a resurgence in self-supervised learning pretty much a lot of the self-supervised state of the art methods are really based on contrastive learning.
-->

### Apprentissage contrastif

L'apprentissage contrastif est un cadre général qui tente d'apprendre un espace de caractéristiques afin de combiner/rassembler des points qui sont liés et écarter des points qui ne sont pas liés.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>Figure 9 :</b> Groupes d'images liées et non liées
</center>

Dans ce cas, imaginons que les cases bleues sont liées, les vertes sont liées et les violettes sont liés.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>Figure 10 :</b> Fonction de perte et apprentissage contrastif
</center>

Les caractéristiques de chacun de ces points de données sont extraites par le biais d'un réseau partagé, appelé réseau siamois. Ensuite, une fonction de perte contrastive est appliquée pour essayer de minimiser la distance entre les points bleus par opposition, par exemple, à la distance entre le point bleu et le point vert. Ou du moins la distance entre les points bleus devrait être inférieure à la distance entre le point bleu et le point vert ou bien entre le point bleu et le point violet. Ainsi, l'espace d'enchâssement des échantillons apparentés doit être beaucoup plus proche que l'espace d'enchâssement des échantillons non apparentés. C'est l'idée générale de ce qu'est l'apprentissage contrastif dont Yann a été l'un des premiers à proposer le principe. L'apprentissage contrastif fait donc un retour en force dans l'apprentissage autosupervisé puisqu'une grande partie des méthodes de pointe dans le domaine sont basées sur l'apprentissage contrastif.

<!--
### How to define related or unrelated?

And the main question is how to define what is related and unrelated. In the case of supervised learning that's fairly clear all of the dog images are related images, and any image that is not a dog is basically an unrelated image. But it's not so clear how to define the relatedness and unrelatedness in this case of self-supervised learning. The other main difference from something like a pretext task is that contrastive learning really reasons a lot of data at once.  If you look at the loss function, it always involves multiple images. In the first row it involves basically the blue images and the green images and in the second row it involves the blue images and the purple images. But as if you look at a task like say Jigsaw or a task like rotation, you're always reasoning about a single image independently. So that's another difference with contrastive learning: contrastive learning reasons about multiple data points at once.

Similar techniques to what was discussed earlier could be used: frames of video or sequential nature of data. Frames that are nearby in a video are related and frames, say, from a different video or which are further away in time are unrelated. And that has formed the basis of a lot of self- supervised learning methods in this area. This method is called CPC, which is contrastive predictive coding, which relies on the sequential nature of a signal and it basically says that samples that are close by, like in the time-space, are related and samples that are further apart in the time-space are unrelated. A fairly large amount of work basically exploiting this: it can either be in the speech domain, video, text, or particular images. And recently, we've also been working on video and audio so basically saying a video and its corresponding audio are related samples and video and audio from a different video are basically unrelated samples.
-->

### Comment définir ce qui est lié ou non lié ?

La question principale est de savoir comment définir ce qui est lié et ce qui ne l'est pas. Dans le cas de l'apprentissage supervisé, il est assez clair que toutes les images de chiens sont des images liées et toute image qui n'est pas un chien est fondamentalement une image non liée. Mais il n'est pas aussi clair de définir ce qui est lié et ce qui ne l'est pas dans le cas d'apprentissage autosupervisé. L'autre grande différence avec une tâche de prétexte est que l'apprentissage contrastif raisonne avec vraiment beaucoup de données à la fois. La fonction de perte implique toujours plusieurs images. Dans la première ligne, il s'agit essentiellement d'images bleues et d'images vertes, et dans la deuxième ligne, d'images bleues et d'images violettes. Mais pour une tâche de prétexte comme par exemple Jigsaw ou la rotation, nous raisonnons toujours sur une seule image de manière indépendante. C'est donc une autre différence : l'apprentissage contrastif raisonne sur plusieurs points de données à la fois.

On pourrait utiliser des techniques similaires à celles qui ont été évoquées précédemment : des images vidéo ou la nature séquentielle des données. Les images qui sont proches dans une vidéo sont liées et les images d'une autre vidéo ou qui sont plus éloignées dans le temps ne sont pas liées. Ces techniques ont constitué la base de nombreuses méthodes d'apprentissage autosupervisées dans ce domaine. Cette méthode est appelée CPC (codage prédictif contrastif) et repose sur la nature séquentielle d'un signal. Les échantillons qui sont proches, comme dans l'espace-temps, sont liés et les échantillons qui sont plus éloignés dans l'espace-temps ne sont pas liés. Une quantité assez importante de travaux exploite ce principe : il peut s'agir de la parole, de la vidéo, du texte ou d'images. Récemment, des travaux ont porté sur la vidéo et l'audio, ce qui signifie qu'une vidéo et son audio correspondant sont des échantillons liés et que la vidéo et l'audio d'une autre vidéo sont des échantillons non liés.

<!--
### Tracking Objects

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>Fig. 11</b>: Tracking the Objects
</center>

Some of the early work, like self-supervised learning, also uses this contrastive learning method and they really defined related examples fairly interestingly. You run a tracked object tracker over a video and that gives you a moving patch and what you say is that any patch that was tracked by the tracker is related to the original patch. Whereas, any patch from a different video is not a related patch. So that basically gives out these bunch of related and unrelated samples. In figure 11(c), you have this like distance notation. What this network tries to learn is basically that patches that are coming from the same video are related and patches that are coming from different videos are not related. In some way, it automatically learns about different poses of an object. It tries to group together a cycle, viewed from different viewing angles or different poses of a dog.
-->

### Suivi des objets (*tracking*)

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>Figure 11 :</b> Suivi des objets
</center>

En passant un *tracker* d'objets sur une vidéo cela nous donne un patch mobile. Tout patch qui a été suivi par le *tracker* est lié au patch original. En revanche, tout patch provenant d'une autre vidéo n'est pas un patch apparenté. Cela donne donc un ensemble d'échantillons liés et non liés. Cette notation de distance est visible dans la figure 11(c). Le réseau essaie d'apprendre que les patchs provenant d'une même vidéo sont liés et que les patchs provenant de vidéos différentes ne sont pas liés. D'une certaine manière, il apprend automatiquement les différentes poses d'un objet. Il essaie de regrouper ensemble les images de vélo vu sous différents angles de même pour les images de chien.

<!--
### Nearby patches *vs.* distant patches of an Image

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>Fig. 12</b>: Nearby patches *vs.* distant patches of an Image
</center>

In general, talking about images, a lot of work is done on looking at nearby image patches versus distant patches, so most of the CPC v1 and CPC v2 methods are really exploiting this property of images. So image patches that are close are called as positives and image patches that are further apart are translated as negatives, and the goal is to minimize the contrastive loss using this definition of positives and negatives.
-->

### Patchs proches *vs* patchs lointains dans une image

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>Figure 12 :</b> Patchs proches vs patchs éloignés
</center>

Les méthodes CPCv1 et CPCv2 exploitent la distance entre deux patchs dans une image donnée. Ainsi, les patchs d'images proches sont appelés positifs et les patchs d'images plus éloignés sont appelées négatifs. Le but est de minimiser la perte contrastive en utilisant cette définition de positifs et de négatifs.

<!--
### Patches of an image *vs.* patches of other images

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig13.png"
height="60%" width="60%"/><br><b>Fig. 13</b>: Patches of an Image *vs.* Patches of Other Images
</center>

The more popular or performant way of doing this is to look at patches coming from an image and contrast them with patches coming from a different image. This forms the basis of a lot of popular methods like instance discrimination, MoCo, PIRL, SimCLR. The idea is basically what's shown in the image. To go into more details, what these methods do is to extract completely random patches from an image. These patches can be overlapping, they can actually become contained within one another or they can be completely falling apart and then apply some data augmentation. In this case, say, a colour chattering or removing the colour or so on. And then these two patches are defined to be positive examples. Another patch is extracted from a different image. And this is again a random patch and that basically becomes your negatives. And a lot of these methods will extract a lot of negative patches and then they will basically perform contrastive learning. So there are relating two positive samples, but there are a lot of negative samples to do contrastive learning against.
-->

### Patchs d'une image *vs* patchs d'autres images

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig13.png"
height="60%" width="60%"/><br><b>Figure 13 :</b> Patchs d'une image vs Patchs d'autres images
</center>

La façon la plus populaire ou la plus performante de procéder consiste à regarder les patchs provenant d'une image et à les mettre en contraste avec les patchs provenant d'une autre image. Ceci constitue la base de nombreuses méthodes populaires comme la discrimination d'instance, MoCo, PIRL, SimCLR. L'idée est essentiellement ce qui est montré dans la figure 13. Pour aller plus dans les détails, ces méthodes consistent à extraire d'une image des taches complètement aléatoires. Ces patchs peuvent se chevaucher, être contenus les uns dans les autres ou s'effondrer complètement, puis appliquer une augmentation des données. Dans ce cas, par exemple, flouter une couleur ou en enlever une. 
Ces deux taches sont alors définies comme des exemples positifs. Un autre patch est extrait d'une image différente. Il s'agit là encore d'une tache aléatoire qui sert à créer nos négatifs.  
Beaucoup de ces méthodes extraient énormément d’exemples négatifs et puis effectuent un apprentissage contrastif.

<!--
### Underlying Principle for Pretext Tasks

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>Fig. 14</b>: Pretext Image Transform and Standard Pretext Learning
</center>

Now moving to PIRL a little bit, and that's trying to understand what the main difference of pretext tasks is and how contrastive learning is very different from the pretext tasks. Again, pretext tasks always reason about a single image at once.  So the idea is that given an image your and prior transform to that image, in this case a Jigsaw transform, and then inputting this transformed image into a ConvNet and trying to predict the property of the transform that you applied to, the permutation that you applied or the rotation that you applied or the kind of colour that you removed and so on. So the pretext tasks always reason about a single image. And the second thing is that the task that you're performing in this case really has to capture some property of the transform. So it really needs to capture the exact permutation that are applied or the kind of rotation that are applied, which means that the last layer representations are actually going to go PIRL very a lot as the transform the changes and that is by design, because you're really trying to solve that pretext tasks. But unfortunately, what this means is that the last layer representations capture a very low-level property of the signal. They capture things like rotation or so on. Whereas what is designed or what is expected of these representations is that they are invariant to these things that it should be able to recognize a cat, no matter whether the cat is upright or that the cat is say,  bent towards like by 90 degrees. Whereas when you're solving that particular pretext task you're imposing the exact opposite thing. We're saying that we should be able to recognize whether this picture is upright or whether this picture is basically turning it sideways. There are many exceptions in which you really want these low-level representations to be covariant and a lot of it really has to do with the tasks that you're performing and quite a few tasks in 3D really want to be predictive. So you want to predict what camera transforms you have: you're looking at two views of the same object or so on. But unless you have that kind of a specific application for a lot of semantic tasks, you really want to be invariant to the transforms that are used to use that input.
-->

### Principe sous-jacent pour les tâches de prétexte

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>Figure 14 :</b> Transformation des images du prétexte et apprentissage du prétexte standard
</center>

Passons maintenant à PIRL et essayons de comprendre quelle est la principale différence entre les tâches de prétexte et comment l'apprentissage contrastif est très différent des tâches de prétexte.   

L'idée des tâches de prétexte est de donner à une image une transformation préalable (une transformation Jigsaw pour PIRL), puis de passer cette image transformée dans un ConvNet pour essayer de prédire la propriété de la transformation qui a été appliquée (permutation, rotation, changement de couleur, etc.). Ainsi, les tâches de prétexte raisonnent toujours à propos d'une seule image à la fois. Le deuxième point est que la tâche que nous effectuons doit capturer une certaine propriété de la transformation. Mais malheureusement, cela signifie que les représentations de la dernière couche capturent une propriété de très bas niveau du signal comme la rotation par exemple. Alors que ce qui est conçu ou ce que l'on attend de ces représentations, est qu'elles soient invariantes. Par exemple être capable de reconnaître un chat, peu importe si le chat est debout ou que le chat est tourné à 90 degrés. 
Alors que lorsque nous résolvons cette tâche de prétexte, nous imposons la chose exactement inverse. Nous disons que nous devrions être capables de reconnaître si l’image a été tourné sur un côté. Il y a de nombreuses exceptions où l'on veut vraiment que ces représentations de bas niveau soient covariantes mais ces exceptions sont liées aux tâches (en aval) que nous effectuons.

<!--
### How important has invariance been?

Invariance has been the word course for feature learning. Something like SIFT, which is a fairly popular handcrafted feature where we inserted here is transferred invariant. And supervise networks, for example, supervised Alex nets, they're trained to be invariant data augmentation. You want this network to classify different crops or different rotations of this image as a tree, rather than ask it to predict what exactly was the transformation applied for the input.
-->

### Quelle est l'importance de l'invariance ?

L'invariance a été le mot d'ordre pour l'apprentissage des caractéristiques. Les réseaux supervisés, comme par exemple AlexNet, sont entraînés à être invariants à l'augmentation des données. Vous voulez que le réseau classifie différentes générations ou différentes rotations d’une image plutôt que de lui demander de prédire quelle a été la transformation appliquée à l'entrée.


<!--
### PIRL

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>Fig. 15</b>: PIRL
</center>

This is what inspired PIRL. So PIRL stands for pretext invariant representation learning, where the idea is that you want the representation to be invariant or capture as little information as possible of the input transform. So you have the image, you have the transformed version of the image, you feed-forward both of these images through a ConvNet, you get a representation and then you basically encourage these representations to be similar. In terms of the notation referred earlier, the image $I$ and any pretext transformed version of this image $I^t$ are related samples and any other image is underrated samples. So in this way when you frame this network, representation hopefully contains very little information about this transform $t$. And assume you are using contrastive learning. So the contrastive learning part is basically you have the saved feature $v_I$ coming from the original image $I$ and you have the feature $v_{I^t}$ coming from the transform version and you want both of these representations to be the same. And the book paper we looked at is two different states of the art of the pretext transforms, which is the jigsaw and the rotation method discussed earlier. In some way, this is like multitask learning, but just not really trying to predict both designed rotation. You're trying to be invariant of Jigsaw rotation.
-->

### PIRL

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>Figure 15 :</b> PIRL
</center>

PIRL est l'acronyme de « *Pretext Invariant Representation Learning* », où nous souhaitons que la représentation soit invariante ou capture le moins d'informations possible de la transformation d'entrée. Ainsi, nous avons l'image, la version transformée de cette image et donnons ces deux images à un ConvNet. Nous obtenons des représentations et les encourageons à être similaires. En ce qui concerne la notation mentionnée plus haut, l'image $I$ et toute version transformée de cette image $I^t$ sont des échantillons apparentés et toute autre image est un échantillon non lié. Nous espérons alors que la représentation contient très peu d'informations sur la transformée $t$. 
La partie liée à l’apprentissage contrastif consiste donc à avoir la caractéristique sauvegardée $v_I$ provenant de l'image originale $I$ et la caractéristique $v_{I^t}$ provenant de la version transformée et à vouloir que ces deux représentations soient identiques. D'une certaine manière, c'est comme un apprentissage multitâche, mais sans vraiment essayer de prédire les deux rotations conçues.   
Ici nous essayons d'être invariant à la tâche de Jigsaw.

<!--
###  Using a Large Number of Negatives

The key thing that has made contrastive learning work well in the past, taking successful attempts is using a large number of negatives. [One of the good paper](https://arxiv.org/abs/1805.01978) taking successful attempts, is instance discrimination paper from 2018, which introduced this concept of a memory bank. This is powered, most of the research methods which are state of the art techniques hinge on this idea for a memory bank. The memory bank is a nice way to get a large number of negatives without really increasing the sort of computing requirement. What you do is you store a feature vector per image in memory, and then you use that feature vector in your contrastive learning.
-->

### Utilisation d'un grand nombre de négatifs

L'élément clé qui a fait que l'apprentissage contrastif a bien fonctionné dans le passé est l'utilisation d'un grand nombre de négatifs. Le papier de [Wu et al. (2018)](https://arxiv.org/abs/1805.01978) a introduit le concept de banque de mémoire. C'est un outil puissant et la plupart des méthodes de pointes actuelles s'articulent autour de cette idée. La banque de mémoire est un bon moyen d'obtenir un grand nombre de négatifs sans vraiment augmenter les besoins informatiques. Ce qui est fait, est que nous stockons un vecteur de caractéristiques par image dans la mémoire, puis utilisons ce vecteur de caractéristiques dans votre apprentissage contrastif.

<!--
### How it works

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>Fig. 16</b>: How does the Memory Bank Work
</center>

Let's first talk about how you would do this entire PIRL setup without using a memory bank. So you have an image $I$ and you have an image $I^t$, and you feed-forward both of these images, you get a feature vector $f(v_I)$ from the original image $I$, you get a feature $g(v_{I^t})$ from the transform versions, the patches, in this case. What you want is the features $f$ and $g$ to be similar. And you want features from any other unrelated image to basically be dissimilar. In this case, what we can do now is if you want a lot of negatives, we would really want a lot of these negative images to be feed-forward at the same time, which really means that you need a very large batch size to be able to do this. Of course, a large batch size is not really good, if not possible, on a limited amount of GPU memory. The way to do that is to use something called a memory bank. So what this memory bank does is that it stores a feature vector for each of the images in your data set, and when you're doing contrastive learning rather than using feature vectors, say, from a different from a negative image or a different image in your batch, you can just retrieve these features from memory. You can just retrieve features of any other unrelated image from the memory and you can just substitute that to perform contrastive learning. Simply dividing the objective into two parts, there was a contrasting term to bring the feature vector from the transformed image $g(v_I)$, similar to the representation that we have in the memory so $m_I$. And similarly, we have a second contrastive term that tries to bring the feature $f(v_I)$ close to the feature representation that we have in memory. Essentially $g$ is being pulled close to $m_I$ and $f$ is being pulled close to $m_I$. By transitivity, $f$ and $g$ are being pulled close to one another. And the reason for separating this out was that it stabilized training and we were not able to train without doing this. Basically, the training would not really converge. By separating this out into two forms, rather than doing direct contrastive learning between $f$ and $g$, we were able to stabilize training and actually get it working.
-->

### Comment cela focntionne

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>Figure 16 :</b> Fonctionnement de la banque de mémoire
</center>

Parlons d'abord de la façon d’appliquer PIRL sans utiliser une banque de mémoire. Nous avons donc une image $I$ et une image $I^t$, et les donnons à un ConvNet. Nous obtenons un vecteur de caractéristique $f(v_I)$ de l'image originale $I$ et une caractéristique $g(v_{I^t})$ des versions transformés (les patches Jigsaw dans ce cas). Ce que nous voulons c'est que les caractéristiques $f$ et $g$ soient similaires, et que les caractéristiques de toute autre image sans rapport soient fondamentalement différentes. 
Ce que nous voudrions maintenant c’est que beaucoup d’images négatives soient données en même temps, ce qui signifie qu’il nous faut une très grande taille de batch pour pouvoir faire cela.  
Une grande taille de batch n'est pas vraiment bonne pour la mémoire. Le moyen d'y parvenir est d'utiliser ce qu'on appelle une banque de mémoire. Ainsi, cette banque de mémoire stocke un vecteur de caractéristiques pour chacune des images de notre jeu de données, et lorsque nous faisons l’apprentissage contrastif, plutôt que d'utiliser des vecteurs de caractéristiques, nous pouvons simplement récupérer ces caractéristiques en mémoire. En divisant l'objectif en deux parties, il y a un terme contrastif est utilisé pour amener le vecteur de caractéristiques de l'image transformée $g(v_I)$, similaire à la représentation que nous avons en mémoire, donc $m_I$. Et de même, nous avons un second terme contrastif qui tente de rapprocher la caractéristique $f(v_I)$ de la représentation de la caractéristique que nous avons en mémoire. Essentiellement, $g$ est rapproché de $m_I$ et $f$ est rapproché de $m_I$. Par transitivité, $f$ et $g$ sont rapprochés l'un de l'autre.  
La raison de cette séparation est que cela stabilise l'entraînement et que nous ne n’arrivons pas à le réaliser sans cela car il ne convergeait pas vraiment.

<!--
### PIRL Pre-training

The way to evaluate this is basically by standard pre-training evaluation set-up. For transfer learning, we can pretrain on images without labels. The standard way of doing this is to take an image net, throw away the labels and pretend as unsupervised.
-->

### Pré-entraînement de PIRL

Pour l'apprentissage par transfert, nous pouvons faire un pré-entraînement sur des images sans label. La méthode standard consiste à prendre un réseau d'images, à jeter les labels et à faire semblant de ne pas être supervisé.

<!--
### [Evaluation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)

Evaluation can be performed by full fine-tuning (initialisation evaluation) or training a linear classifier (feature evaluation). PIRL robustness has been tested by using images in-distribution by training it on in-the-wild images. So we just took 1 million images randomly from Flickr, which is the YFCC data set. And then we basically performed pre-training on these images and then performed transplanting on different data sets.
-->

### [Evaluation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)

L'évaluation peut être effectuée par un *finetuning* complet (évaluation de l'initialisation) ou par l'entraînement d'un classifieur linéaire (évaluation des caractéristiques). La robustesse de PIRL a été testée en l'entraînant sur des images en milieu naturel, à savoir un million d’images prises au hasard sur Flickr (jeu de données YFCC). Puis il a été appliqué sur différents jeux de données.

<!--
#### Evaluating on Object Detection task

PIRL was first evaluated on object detection task (a standard task in vision) and it was able to outperform ImageNet supervised pre-trained networks on both **VOC07+12** and **VOC07** data sets. In fact, PIRL outperformed even in the stricter evaluation criteria, $AP^{all}$ and that's a good positive sign.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>Fig. 17</b>: Object detection performance on different datasets
</center>
-->

#### Evaluation sur la tâche de détection d'objets

PIRL a d'abord été évalué sur la tâche de détection d'objets. Il a surpassé les réseaux pré-entraînés de manière supervisée sur ImageNet sur les jeux de données **VOC07+12** et **VOC07**. En fait, PIRL a même surpassé les critères d'évaluation les plus stricts, $AP^{all}$.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>Figure 17 :</b> Performances pour la tâche de détection d'objets sur deux jeux de données
</center>

<!--
#### Evaluating on Semi-supervised Learning

PIRL was then evaluated on semi-supervised learning task. Again, PIRL performed fairly well. In fact, PIRL was better than even the pre-text task of Jigsaw. The only difference between the first row and the last row is that, PIRL is an invariant version, whereas Jigsaw is a covariant version.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>Fig. 18</b>: Semi-supervised learning on ImageNet
</center>
-->

#### Évaluation sur l'apprentissage semisupervisé

PIRL a ensuite été évalué sur une tâche d'apprentissage semisupervisée. Là encore, il a obtenu d'assez bons résultats. En fait, il a même été meilleur que la tâche de prétexte Jigsaw. La seule différence entre la première et la dernière rangée est que PIRL est une version invariante, alors que Jigsaw est une version covariante.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>Figure 18 :</b> Apprentissage semisupervisé sur ImageNet
</center>

<!--
#### Evaluating on Linear Classification

Now when evaluating on Linear Classifiers, PIRL was actually on par with the CPCv2, when it came out. It also worked well on a bunch of parameter settings and a bunch of different architectures. And of course, now you can have fairly good performance by methods like SimCLR or so. In fact, the Top-1 Accuracy for SimCLR would be around 69-70, whereas for PIRL, that'd be around 63.


<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>Fig. 19</b>: ImageNet classification with linear models
</center>
-->

#### Évaluation sur la classification linéaire

Sur l'évaluation sur de la classification, PIRL est au même niveau que CPCv2. Il a également bien fonctionné sur un certain nombre de paramètres et d'architectures différentes.  
Depuis, la méthode SimCLR fait mieux avec une précision top-1 d'environ 69-70 contre environ 63 pour PIRL.


<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>Figure 19 :</b> Classification ImageNet avec modèles linéaires
</center>

<!--
#### Evaluating on YFCC images

PIRL was evaluated on *"In-the-wild" Flickr* images from the YFCC data set. It was able to perform better than Jigsaw, even with $100$ times smaller data set. This shows the power of taking invariance into consideration for the representation in the pre-text tasks, rather than just predicting pre-text tasks.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>Fig. 20</b>: Pre-training on uncurated YFCC images
</center>
-->

#### Evaluation sur les images YFCC

PIRL a été évalué sur les images du jeu de données YFCC. Il a été plus performant que Jigsaw, même avec un jeu de données $100$ fois plus petit. Cela montre la puissance de la prise en compte de l'invariance pour la représentation dans les tâches de prétexte, plutôt que de simplement prédire les tâches de prétexte.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>Figure 20 :</b> Pré-entraînement sur les images non traitées de YFCC
</center>

<!--
### Semantic Features

Now, going back to verifying the semantic features, we look at the Top-1 accuracy for PIRL and Jigsaw for different layers of representation from `conv1` to `res5`. It's interesting to note that the accuracy keeps increasing for different layers for both PIRL and Jigsaw, but drops in the 5th layer for Jigsaw. Whereas, the accuracy keeps improving for PIRL, *i.e.* more and more semantic.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>Fig. 21</b>: Quality of PIRL representations per layer
</center>
-->


### Caractéristiques sémantiques

Maintenant, pour en revenir à la vérification des caractéristiques sémantiques, nous examinons la précision Top-1 pour PIRL et Jigsaw pour différentes couches de représentation, de *conv1* à *res5*. Il est intéressant de noter que la précision augmente pour les différentes couches pour PIRL et Jigsaw, mais qu'elle diminue dans la 5e couche pour Jigsaw. En revanche, la précision continue à s'améliorer pour PIRL, c'est-à-dire de plus en plus sémantique.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>Figure 21 :</b> Qualité des représentations de PIRL par couche
</center>

<!--
### Scalability

PIRL is very good at handling problem complexity because you're never predicting the number of permutations, you're just using them as input. So, PIRL can easily scale to all 362,880 possible permutations in the 9 patches. Whereas in Jigsaw, since you're predicting that, you're limited by the size of your output space.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>Fig. 22</b>: Effect of varying the number of patch permutations
</center>

The paper "*Misra & van der Maaten, 2019, PIRL*" also shows how PIRL could be easily extended to other pretext tasks like Jigsaw, Rotations  and so on. Further, it could even be extended to combinations of those tasks like Jigsaw+Rotation.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>Fig. 23</b>: Using PIRL with (combinations of) different pretext tasks
</center>
-->

### Passage à l’échelle

PIRL est très efficace pour gérer la complexité des problèmes car on ne prédit jamais le nombre de permutations, on les utilise simplement comme données d'entrée. Ainsi, PIRL peut facilement s'adapter aux $362 880$ permutations possibles dans les 9 patchs. Alors que dans Jigsaw, nous sommes limités par la taille de l’espace de sortie.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>Figure 22 :</b> Effet de la variation du nombre de permutations de patchs
</center>

Le papier de PIRL montre également comment il peut être facilement étendu à d'autres tâches de prétexte comme Jigsaw, les rotations, etc. En outre, il peut même être étendu à des combinaisons de ces tâches comme Jigsaw+Rotation.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>Figure 23 :</b> Utilisation de PIRL avec (combinaisons de) différentes tâches de prétexte
</center>

<!--
### Invariance *vs.* performance

In terms of invariance property, one could, in general, assert that the invariance of PIRL is more than that of the Clustering, which in turn has more invariance than that of the pretext tasks. And similarly, the performance to is higher for PIRL than Clustering, which in turn has higher performance than pretext tasks. This suggests that taking more invariance in your method could improve performance.
-->

### Invariance *vs* performance

En termes de propriété d'invariance, on pourrait, en général, affirmer que l'invariance de PIRL est plus que celle du Clustering, qui à son tour a plus d'invariance que celle des tâches de prétexte. De même, la performance est plus élevée pour PIRL que pour le Clustering, qui à son tour a une performance plus élevée que les tâches de prétexte. Cela suggère que le fait d’ajouter de l'invariance dans une méthode pourrait améliorer les performances.

<!--
### Shortcomings

1. It's not very clear as to which set of data transforms matter. Although Jigsaw works, it's not very clear why it works.
2. Saturation with model size and data size.
3. What invariances matter? (One could think about what invariances work for a particular supervised task in general as future work.)

So in general, we should try to predict more and more information and try to be as invariant as possible.
-->

### Lacunes

1. Il n'est pas très clair de savoir quel ensemble de données transforme la matière. Bien que Jigsaw fonctionne, on ne sait pas très bien pourquoi.
2. Saturation avec la taille du modèle et la taille des données.
3. Quelles sont les invariances importantes ? On pourrait penser à celles qui fonctionnent pour une tâche supervisée particulière en général comme un travail futur.

Donc, en général, nous devrions essayer de prévoir de plus en plus d'informations et essayer d'être aussi invariants que possible.

<!--
## Some important questions asked as doubts
-->

## Questions des étudiants sur plusieurs sujets

<!--
### Contrastive learning and batch norms

1. Wouldn't the network learn only a very trivial way of separating the negatives from the positives if the contrasting network uses the batch norm layer (as the information would then pass from one sample to the other)?

**Ans**: *In PIRL, no such phenomenon was observed, so just the usual batch norm was used*

2. So is it fine to use batch norms for any contrasting networks?

**Ans**: *In general, yeah. In SimCLR, a variant of the usual batch norm is used to emulate a large batch size. So, batch norm with maybe some tweaking could be used to make the training easier*

3. Does the batch norm work in the PIRL paper only because it's implemented as a memory bank - as all the representations aren't taken at the same time? (As batch norms aren't specifically used in the MoCo paper for instance)

**Ans**: *Yeah. In PIRL, the same batch doesn't have all the representations and possibly why batch norm works here, which might not be the case for other tasks where the representations are all correlated within the batch*

4. So, other than memory bank, are there any other suggestions how to go about for n-pair loss? Should we use AlexNet or others that don't use batch norm? Or is there a way to turn off the batch norm layer? (This is for a video learning task)

**Ans**: *Generally frames are correlated in videos, and the performance of the batch norm degrades when there are correlations. Also, even the simplest implementation of AlexNet actually uses batch norm. Because, it's much more stable when trained with a batch norm. You could even use a higher learning rate and you could also use for other downstream tasks. You could use a variant of batch norm for example, group norm for video learning task, as it doesn't depend on the batch size*
-->

### L'apprentissage contrastif et la *batch normalisation*

**Le réseau n'apprendrait-il pas une façon très triviale de séparer les négatifs des positifs si le réseau utilise la couche de *batch normalisation* (car l'information passerait alors d'un échantillon à l'autre) ?**

> Dans PIRL, aucun phénomène de ce type n'a été observé, donc seule la *batch normalisation* habituelle a été utilisée.

**Est-il donc acceptable d'utiliser une normalisation par batch pour des réseaux contrastifs ?**

> En général, oui. Dans SimCLR, une variante de la normalisation par batch est utilisée pour émuler une grande taille de batch. Ainsi, la normalisation par batch avec peut-être quelques modifications pourrait être utilisée pour faciliter l'entraînement.

**La normalisation par batch fonctionne-t-elle dans le papier PIRL uniquement parce qu'elle est mise en œuvre en tant que banque de mémoire ? Etant donné que toutes les représentations ne sont pas prises en même temps**

> Oui. Dans PIRL, le même batch n'a pas toutes les représentations et est peut-être la raison de pourquoi la normalisation par batch fonctionne ici. Cela pourrait ne pas être le cas pour d'autres tâches où les représentations sont toutes corrélées dans le batch.

**Outre la banque de mémoire, existe-t-il d'autres suggestions sur la manière de procéder en cas de perte n-paires ? Devrions-nous utiliser AlexNet qui n'utilise pas la noramlisation par batch ou existe-t-il un moyen de désactiver la couche de normalisation par batch ? Notamment dans le cadre d'une tâche d'apprentissage vidéo**

> Généralement, les images sont corrélées dans les vidéos et la performance de la normalisation par batch se dégrade lorsqu'il y a des corrélations. De plus, même la plus simple des implémentations d'AlexNet utilise en fait la normalisation par batch. En effet, il est beaucoup plus stable lorsqu'il est entraîné avec. Vous pourriez même utiliser un taux d'apprentissage plus élevé et vous pourriez également l'utiliser pour d'autres tâches en aval. Vous pouvez utiliser une variante de la normalisation par batch, par exemple la normalisation par groupe pour les tâches d'apprentissage vidéo, car elle ne dépend pas de la taille du batch.


<!--
### Loss functions in PIRL

1. In PIRL, why is NCE (Noise Contrastive Estimator) used for minimizing loss and not just the negative probability of the data distribution: $h(v_{I},v_{I^{t}})$?

**Ans**: *Actually, both could be used. The reason for using NCE has more to do with how the memory bank paper was set up. So, with $k+1$ negatives, it's equivalent to solving $k+1$ binary problem. Another way of doing it is using a softmax, where you apply a softmax and minimize the negative log-likelihood*
-->

### Fonctions de perte dans PIRL

**Dans PIRL, pourquoi utilise-t-on le NCE (*Noise Contrastive Estimator*) pour minimiser les pertes et pas seulement la probabilité négative de la distribution des données : $h(v_{I},v_{I^{t}})$ ?**

> En fait, les deux pourraient être utilisés. La raison de l'utilisation du NCE a plus à voir avec la façon dont le papier de la banque de données a été mis en place. Ainsi, avec $k+1$ négatifs, cela équivaut à résoudre $k+1$ problème binaire. Une autre façon de procéder est d'utiliser une fonction softmax et minimiser la log-vraisemblance négative.

<!--
### Self-supervised learning project related tips

How do we get a simple self-supervised model working? How do we begin the implementation?

**Ans**: *There are a certain class of techniques that are useful for the initial stages. For instance, you could look at the pretext tasks. Rotation is a very easy task to implement. The number of moving pieces are in general good indicator. If you're planning to implement an existing method, then you might have to take a closer look at the details mentioned by the authors, like - the exact learning rate used, the way batch norms were used, etc. The more number of these things, the harder the implementation. Next very critical thing to consider is data augmentation. If you get something working, then add more data augmentation to it.* 
-->

### Conseils relatifs aux projets d'apprentissage autosupervisés

**Comment faire fonctionner un modèle simple et autosupervisé ? Comment en amorcer la mise en œuvre ?**

> Il existe une certaine classe de techniques qui sont utiles pour les étapes initiales. Par exemple, vous pouvez examiner les tâches de prétexte. La rotation est une tâche très facile à mettre en œuvre. Le nombre de pièces en mouvement est en général un bon indicateur. Si vous envisagez de mettre en œuvre une méthode existante, vous devrez peut-être examiner de plus près les détails mentionnés par les auteurs, comme le taux d'apprentissage exact utilisé, la manière dont les normes de lot ont été utilisées, etc. Plus ces éléments sont nombreux, plus la mise en œuvre est difficile. Le prochain point très important à prendre en compte est l'augmentation des données. Si quelque chose fonctionne, il faut y ajouter une augmentation des données.

<!--
### Generative models

Have you thought of combining generative models with contrasting networks?

**Ans**: *Generally, it's good idea. But, it hasn't been implemented partly because it is tricky and non-trivial to train such models. Integrative approaches are harder to implement, but perhaps the way to go in the future.*
-->

### Modèles génératifs

**Avez-vous pensé à combiner des modèles génératifs avec des réseaux contrastifs ?**

> Généralement, c'est une bonne idée. Mais, elle n'a pas été mise en œuvre en partie parce qu'il est délicat et non trivial d'entraîner de tels modèles. Les approches intégratives sont plus difficiles à implémenter mais c'est peut-être la voie à suivre à l'avenir.

<!--
### Distillation

Wouldn't the uncertainty of the model increase when richer targets are given by softer distributions? Also, why is it called distillation?

**Ans**: *If you train on one hot labels, your models tend to be very overconfident. Tricks like label smoothing are being used in some methods. Label smoothing is just a simple version of distillation where you are trying to predict a one hot vector. Now, rather than trying to predict the entire one-hot vector, you take some probability mass out of that, where instead of predicting a one and a bunch of zeros, you predict say $0.97$ and then you add $0.01$, $0.01$ and $0.01$ to the remaining vector (uniformly). Distillation is just a more informed way of doing this. Instead of randomly increasing the probability of an unrelated task, you have a pre-trained network to do that. In general softer distributions are very useful in pre-training methods. Models tend to be over-confident and so softer distributions are easier to train. They converge faster too. These benefits are present in distillation*
-->

### Distillation

**L'incertitude du modèle n'augmenterait-elle pas lorsque des cibles plus riches sont données par des distributions plus douces ? Aussi, pourquoi l'appelle-t-on distillation ?**

> Si vous entraînez sur un seul label, vos modèles ont tendance à être trop confiants. Des astuces comme le lissage des labels sont utilisées dans certaines méthodes. Le lissage de label est une simple version de la distillation où vous essayez de prédire un vecteur *one-hot*. Maintenant, plutôt que d'essayer de prédire le vecteur *one-hot* entier, vous en retirez une certaine masse de probabilité, où au lieu de prédire un $1$ et un tas de $0$, vous prédisez par exemple $0,97$ et vous ajoutez ensuite $0,01$, $0,01$ et $0,01$ au vecteur restant (uniformément). La distillation est simplement une façon plus éclairée de procéder. Au lieu d'augmenter de manière aléatoire la probabilité d'une tâche sans rapport, vous disposez d'un réseau pré-entraîné pour le faire. En général, les distributions plus douces sont très utiles dans les méthodes d'entraînement préalable. Les modèles ont tendance à être trop confiants et les distributions plus douces sont plus faciles à entraîner. Elles convergent aussi plus rapidement. Ces avantages sont présents dans la distillation.
