---
lang: fr
lang-ref: ch.10-1
title: Apprentissage autosupervisé et tâches de prétexte
lecturer: Ishan Misra
authors: Aniket Bhatnagar, Dhruv Goyal, Cole Smith, Nikhil Supekar
date: 6 Apr 2020
translation-date: 10 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Success story of supervision: Pre-training](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

In the past decade, one of the major success recipes for many different Computer Vision problems has been learning visual representations by performing supervised learning for ImageNet classification. And, using these learned representations, or learned model weights as initialization for other computer vision tasks, where a large quantum of labelled data might not be available.

However, getting annotations for a dataset of the magnitude of ImageNet is immensely time-consuming and expensive. Example: ImageNet labelling with 14M images took roughly 22 human years.

Because of this, the community started to look for alternate labelling processes, such as hashtags for social media images, GPS locations, or self-supervised approaches where the label is a property of the data sample itself.

But an important question that arises before looking for alternate labelling processes is:

**How much labelled data can we get after all?**

- If we search for all images with object-level category and bounding box annotations then there are roughly 1 million images.
- Now, if the constraint for bounding box coordinates is relaxed, the number of images available jumps to 14 million (approximately).
- However, if we consider all images available on the internet, there is a jump of 5 orders in the quantity of data available.
- And, then there is data apart from images, which requires other sensory input to capture or understand.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Figure 1:</b> Variation in available data quantum basis complexity of annotation
</center>

Hence, drawing from the fact that ImageNet specific annotation alone took 22 human years worth of time, scaling labelling to all internet photos or beyond is completely infeasible.

**Problem of Rare Concepts** (*Long Tail Problem*)

Generally, the plot presenting distribution of the labels for internet images looks like a long tail. That is, most of the images correspond to very few labels, while there exist a large number of labels for which not many images are present. Thus, getting annotated samples for categories towards the end of the tail requires huge quantities of data to be labelled because of the nature of the distribution of categories.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Figure 2:</b> Variation in distribution of available images with labels
</center>

**Problem of Different Domains**

This method of ImageNet pre-training and fine-tuning on downstream task gets even murkier when the downstream task images belong to a completely different domain, such as medical imaging. And, obtaining a dataset of the quantum of ImageNet for pre-training for different domains is not possible.
-->

## [Succès de la supervision : le pré-entraînement](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

Au cours de la dernière décennie, l'une des principales approches ayant eu du succès pour de nombreux problèmes de vision par ordinateur a été l'apprentissage des représentations visuelles en effectuant un apprentissage supervisé sur ImageNet. Les représentations et les poids alors appris ont pu être réutilisé comme initialisation pour d'autres tâches de vision par ordinateur où un grand nombre de données étiquetées pouvaient ne pas être disponibles.

Cependant, annoter un jeu de données de l'ampleur d'ImageNet est extrêmement long et coûteux. Par exemple l'étiquetage d'ImageNet avec 14 millions d'images a pris environ 22 années humaines.

C'est pourquoi la communauté a commencé à chercher d'autres procédés d'étiquetage, comme les mots-dièse pour les images des médias sociaux, les localisations GPS ou les approches autosupervisées où le label est une propriété de l'échantillon de données lui-même.

Mais une question importante se pose avant de chercher d'autres procédés d'étiquetage :

**Combien de données étiquetées pouvons-nous obtenir ?**

- Si nous recherchons toutes les images avec une catégorie au niveau de l'objet et des annotations pour les boîtes de délimitation, nous obtenons environ un million d'images.
- Maintenant, si la contrainte pour les coordonnées des boîtes de délimitation est assouplie, le nombre d'images disponibles passe à environ 14 millions.
- Cependant, si nous considérons toutes les images disponibles sur Internet, il y a un saut d’un facteur 5 dans la quantité de données disponibles.
- Et puis, il y a les données autres que les images, qui nécessitent d'autres entrées sensorielles pour être saisies ou comprises.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Figure 1 :</b> Variation des données disponibles selon la complexité de l'annotation
</center>

Par conséquent, si l'on considère que l'annotation d’ImageNet a pris à elle seule 22 années humaines, il est totalement impossible de mettre à l'échelle l’étiquetage de toutes les photos sur Internet ou au-delà.

**Problème des concepts rares** (*problème de la longue queue*)

En général, la distribution des labels pour les images disponibles sur internet ressemble à une longue queue. C'est-à-dire que la plupart des images correspondent à très peu de labels, alors qu'il existe un grand nombre de labels pour lesquelles peu d'images sont présentes. Ainsi, pour obtenir des échantillons annotés pour les catégories vers la fin de la queue, il faut étiqueter d'énormes quantités de données en raison de la nature de la distribution des catégories.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Figure 2 :</b> Variation de la distribution des images disponibles avec labels
</center>

**Problème de la différence de domaine**

Cette méthode de pré-entraînement et de *finetuning* d'ImageNet sur les tâches en aval devient encore plus obscure lorsque les images des tâches en aval appartiennent à un domaine complètement différent, comme l'imagerie médicale.


<!--
## What is self-supervised Learning?

**Two ways to define self-supervised learning**

- **Basis supervised learning definition**, *i.e.* the network follows supervised learning where labels are obtained in a semi-automated manner, without human input.
- **Prediction problem**, where a part of the data is hidden, and rest visible. Hence, the aim is to either predict the hidden data or to predict some property of the hidden data.

**How self-supervised learning differs from supervised learning and unsupervised learning?**

- Supervised learning tasks have pre-defined (and generally human-provided) labels,
- Unsupervised learning has just the data samples without any supervision, label or correct output.
- Self-supervised learning derives its labels from a co-occurring modality for the given data sample or from a co-occurring part of the data sample itself.
-->

## Qu'est-ce que l'apprentissage autosupervisé ?

**Deux façons de définir l'apprentissage autosupervisé** :

- **En se basant sur la définition de l'apprentissage supervisé** c'est-à-dire que le réseau suit un apprentissage supervisé où les labels sont obtenus de manière semi-automatique, sans intervention humaine.
- **En voyant la tâche comme un problème de prédiction** où une partie des données est cachée et le reste visible. L'objectif est soit de prédire les données cachées, soit de prédire certaines propriétés des données cachées.


**Comment l'apprentissage autosupervisé diffère-t-il de l'apprentissage supervisé et de l'apprentissage non supervisé ?**

- Les tâches d'apprentissage supervisé ont des labels prédéfinis (et généralement fournis par l'homme),
- L'apprentissage non supervisé ne dispose que des échantillons de données sans aucune supervision, label ou sortie correcte.
- L'apprentissage autosupervisé tire ses labels d'une modalité concomitante pour l'échantillon de données donné ou d'une partie concomitante de l'échantillon de données lui-même.

<!--
### Self-Supervised Learning in Natural Language Processing
-->

### L'apprentissage autosupervisé dans le traitement du langage naturel

<!--
#### Word2Vec

- Given an input sentence, the task involves predicting a missing word from that sentence, which is specifically omitted for the purpose of building a pretext task.
- Hence, the set of labels becomes all possible words in the vocabulary, and, the correct label is the word that was omitted from the sentence.
- Thus, the network can then be trained using regular gradient-based methods to learn word-level representations.
-->

#### Word2Vec

- À partir d'une phrase d'entrée, la tâche consiste à prédire un mot manquant dans cette phrase, qui est spécifiquement omis dans le but de construire une tâche de prétexte.
- Ainsi, l'ensemble des labels devient tous les mots possibles du vocabulaire et le label correct est le mot qui a été omis de la phrase.
- Ainsi, le réseau peut ensuite être entraîné à l'aide de méthodes régulières basées sur des gradients pour apprendre les représentations au niveau des mots.

<!--
### Why self-supervised learning?

- Self-supervised learning enables learning representations of data by just observations of how different parts of the data interact.
- Thereby drops the requirement of huge amount of annotated data.
- Additionally, enables to leverage multiple modalities that might be associated with a single data sample.
-->

### Pourquoi un apprentissage autosupervisé ?

- L'apprentissage autosupervisé permet d'apprendre des représentations de données en observant simplement comment différentes parties des données interagissent.
- Cela permet de réduire le nombre de données annotées.
- De plus, il permet de tirer parti des multiples modalités qui peuvent être associées à un seul échantillon de données.


<!--
### Self-Supervised Learning in Computer Vision

Generally, computer vision pipelines that employ self-supervised learning involve performing two tasks, a pretext task and a real (downstream) task.

- The real (downstream) task can be anything like classification or detection task, with insufficient annotated data samples.
- The pretext task is the self-supervised learning task solved to learn visual representations, with the aim of using the learned representations or model weights obtained in the process, for the downstream task.
-->

### Apprentissage autosupervisé en vision par ordinateur

En général, les pipelines de vision par ordinateur qui font appel à l'apprentissage autosupervisé impliquent l'exécution de deux tâches, une tâche prétexte et une tâche réelle (en aval).

- La tâche réelle (en aval) peut être par exemple une tâche de classification ou de détection, avec des échantillons de données annotés insuffisants.
- La tâche prétexte est la tâche d'apprentissage autosupervisée résolue pour apprendre des représentations visuelles, dans le but d'utiliser les représentations apprises ou les poids de modèle obtenus dans le processus, pour la tâche en aval.

<!--
#### Developing pretext tasks

- Pretext tasks for computer vision problems can be developed using either images, video, or video and sound.
- In each pretext task, there is part visible and part hidden data, while the task is to predict either the hidden data or some property of the hidden data.
-->

#### Développer des tâches de prétexte

- Les tâches de prétexte pour les problèmes de vision par ordinateur peuvent être développées en utilisant soit des images, soit de la vidéo, soit de la vidéo et du son.
- Dans chaque tâche de prétexte, il y a une partie de données visibles et une partie de données cachées, tandis que la tâche consiste à prédire soit les données cachées, soit une certaine propriété des données cachées.

<!--
#### [Example pretext tasks: Predicting relative position of image patches](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

- Input: 2 image patches, one is the anchor image patch while the other is the query image patch.
- Given the 2 image patches, the network needs to predict the relative position of the query image patch with respect to the anchor image patch.
- Thus, this problem can be modelled as an 8-way classification problem, since there are 8 possible locations for a query image, given an anchor.
- And, the label for this task can be automatically generated by feeding the relative position of query patch with respect to the anchor.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Figure 3:</b> Relative Position task
</center>
-->

#### [Exemple de tâches de prétexte : prédire la position relative des patchs d'image](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

- Entrée : 2 patchs d'image, l'un est le patch d'image d'ancrage et l'autre est le patch d'image requête.
- Compte tenu des deux correctifs d'image, le réseau doit prévoir la position relative du correctif d'image requête par rapport au correctif d'image d'ancrage.
- Ainsi, ce problème peut être modélisé comme un problème de classification à 8 classes, puisqu'il y a 8 emplacements possibles pour une image requête, avec une ancre.
- Et le label pour cette tâche peut être généré automatiquement en indiquant la position relative de la zone de recherche par rapport à l'ancre.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Figure 3 :</b> Tâche de position relative
</center>

<!--
#### Visual representations learned by relative position prediction task

We can evaluate the effectiveness of the learned visual representations by checking nearest neighbours for a given image patch basis feature representations provided by the network. For computing nearest neighbours of a given image patch,

- Compute the CNN features for all images in the dataset, that will act as the sample pool for retrieval.
- Compute CNN features for the required image patch.
- Identify nearest neighbours for the feature vector of the required image, from the pool of feature vectors of images available.

Relative position task finds out image patches that are very similar to the input image patch, while maintains invariance to factors such as object colour. Thus, the relative position task is able to learn visual representations, where representations for image patches with similar visual appearance are closer in the representation space as well.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Figure 4:</b> Relative Position: Nearest Neighbours
</center>
-->

#### Représentations visuelles apprises par la tâche de prédiction de la position relative

Nous pouvons évaluer l'efficacité des représentations visuelles apprises en vérifiant chez les voisins les plus proches les représentations des caractéristiques de base d'un patch d'image donné fournies par le réseau. Pour calculer les voisins les plus proches d'une image donnée :

- Calculer les caractéristiques du ConvNet pour toutes les images du jeu de données, qui serviront d'échantillon *pool* pour la recherche.
- Calculer les caractéristiques du ConvNet pour le correctif d'image requis.
- Identifier les voisins les plus proches pour le vecteur de caractéristique de l'image requise, à partir de la mise en commun de vecteurs de caractéristiques des images disponibles.

La tâche de position relative permet de trouver des zones d'image très similaires à la zone d'image d'entrée, tout en maintenant l'invariance de facteurs tels que la couleur de l'objet. Ainsi, la tâche de position relative est capable d'apprendre des représentations visuelles, où les représentations pour des taches d'image avec un aspect visuel similaire sont également plus proches dans l'espace de représentation.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Figure 4 :</b> Position relative : voisins les plus proches
</center>

<!--
#### Predicting Rotation of Images

- Predicting rotations is one of the most popular pretext task which has a simple and straightforward architecture and requires minimal sampling.
- We apply rotations of 0, 90, 180, 270 degrees to the image and send these rotated images to the network to predict what sort of rotation was applied to the image and the network simply performs a 4-way classification to predict the rotation.
- Predicting rotations does not make any semantic sense, we are just using this pretext task as a proxy to learn some features and representations to be used in a downstream task.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Figure 5:</b> Rotations of Image
</center>
-->

#### Prédire la rotation des images

- La prévision des rotations est l'une des tâches de prétexte les plus populaires ayant une architecture simple et directe, et nécessitant un échantillonnage minimal.
- Nous appliquons des rotations de 0, 90, 180, 270 degrés à l'image et nous envoyons ces images au réseau pour prédire quel type de rotation a été appliqué à l'image. Le réseau effectue simplement une classification à 4 classes pour prédire la rotation.
- La prédiction des rotations n'a aucun sens sémantique, nous utilisons simplement cette tâche prétexte comme un proxy pour apprendre certaines caractéristiques et représentations à utiliser dans une tâche en aval.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Figure 5 :</b> Rotations de l'image
</center>

<!--
#### Why rotation helps or why it works?

It has been proven that it works empirically. The intuition behind it is that in order to predict the rotations, model needs to understand the rough boundaries and representation of an image. For example, it will have to segregate the sky from water or sand from the water or will understand that trees grow upwards and so on.
-->

#### Pourquoi la rotation est-elle utile ou pourquoi fonctionne-t-elle ?

Il a été prouvé qu'elle fonctionne de manière empirique. L'intuition qui sous-tend cette méthode est que pour prédire les rotations, le modèle doit comprendre les limites approximatives et la représentation d'une image. Par exemple, il devra séparer le ciel de l'eau ou le sable de l'eau ou comprendre que les arbres poussent vers le haut, etc.

<!--
#### Colourisation

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Figure 6:</b> Colourisation
</center>

In this pretext task, we predict the colours of a grey image. It can be formulated for any image, we just remove the colour and feed this greyscale image to the network to predict its colour. This task is useful in some respects like for colourising the old greyscale films [//]: <> (we can apply this pretext task). The intuition behind this task is that the network needs to understand some meaningful information like that the trees are green, the sky is blue and so on.

It is important to note that colour mapping is not deterministic, and several possible true solutions exist. So, for an object if there are several possible colours then the network will colour it as grey which is the mean of all possible solutions. There have been recent works using Variational Auto Encoders and latent variables for diverse colourisation.
-->

#### Colorisation

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Figure 6 :</b> Colorisation
</center>

Dans cette tâche de prétexte, on prédit les couleurs d'une image grise. Elle peut être formulée pour n'importe quelle image, il suffit d'enlever la couleur et de donner cette image en niveaux de gris au réseau pour prédire sa couleur. Cette tâche est utile à certains égards, comme pour coloriser les vieux films en niveaux de gris. L'intuition derrière cette tâche est que le réseau doit comprendre certaines informations significatives comme le fait que les arbres sont verts, le ciel est bleu, etc.

Il est important de noter que l’association des couleurs n'est pas déterministe, et que plusieurs vraies solutions existent. Ainsi, pour un objet, s'il y a plusieurs couleurs possibles, le réseau le colorera en gris, ce qui est la moyenne de toutes les solutions possibles. Des travaux récents ont utilisé des auto-encodeurs variationnels et des variables latentes pour diverses colorisations.

<!--
#### Fill in the blanks

We hide a part of an image and predict the hidden part from the remaining surrounding part of the image. This works because the network will learn the implicit structure of the data like to represent that cars run on roads, buildings are composed of windows & doors and so on.
-->

#### Remplir les blancs

Nous cachons une partie d'une image et nous prédisons la partie cachée de la partie restante de l'image qui l'entoure. Cela fonctionne parce que le réseau apprend la structure implicite des données, par exemple pour représenter le fait que les voitures roulent sur les routes, que les bâtiments sont composés de fenêtres et de portes, etc.

<!--
### Pretext Tasks for videos

Videos are composed of sequences of frames and this notion is the idea behind self-supervision, which can be leveraged for some pretext tasks like predicting the order of frames, fill in the blanks and object tracking.
-->

### Tâches de prétexte pour les vidéos

Les vidéos sont composées de séquences d'images et cette notion est l'idée qui sous-tend l'autosupervision, qui peut être mise à profit pour certaines tâches de prétexte comme la prédiction de l'ordre des images, le remplissage des blancs et le suivi des objets.

<!--
#### Shuffle & Learn

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Figure 7:</b> Interpolation
</center>

Given a bunch of frames, we extract three frames and if they are extracted in the right order we label it as positive, else if they are shuffled, label it as negative. This now becomes a binary classification problem to predict if the frames are in the right order or not. So, given a start and end point, we check if the middle is a valid interpolation of the two.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Figure 8:</b> Shuffle & Learn architecture
</center>

We can use a triplet Siamese network, where the three frames are independently fed forward and then we concatenate the generated features and perform the binary classification to predict if the frames are shuffled or not.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Figure 9:</b> Nearest Neighbours Representation
</center>

Again, we can use the Nearest Neighbours algorithm to visualize what our networks are learning. In fig. 9 above, first we have a query frame which we feed-forward to get a feature representation and then look at the nearest neighbours in the representation space. While comparing, we can observe a stark difference between neighbours obtained from ImageNet, Shuffle & Learn and Random.

ImageNet is good at collapsing the entire semantic as it could figure out that it is a gym scene for the first input. Similarly, it could figure out that it is an outdoor scene with grass etc. for the second query. Whereas, when we observe Random we can see that it gives high importance to the background colour.

On observing Shuffle & Learn, it is not immediately clear whether it is focusing on the colour or on the semantic concept. After further inspection and observing various examples, it was observed that it is looking at the pose of the person. For example, in the first image the person is upside down and in second the feet are in a particular position similar to query frame, ignoring the scene or background colour. The reasoning behind this is that our pretext task was predicting whether the frames are in the right order or not, and to do this the network needs to focus on what is moving in the scene, in this case, the person.

It was verified quantitatively by fine-tuning this representation to the task of human key-point estimation, where given a human image we predict where certain key points like nose, left shoulder, right shoulder, left elbow, right elbow, etc. are. This method is useful for tracking and pose estimation.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Figure 10:</b> Key point Estimation comparison
</center>

In figure 10, we compare the results for supervised ImageNet and Self-Supervised Shuffle & Learn on FLIC and MPII datasets and we can see that Shuffle and Learn gives good results for key point estimation.
-->

#### Mélanger et apprendre (*Shuffle & Learn*)

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Figure 7 :</b> Interpolation
</center>

Lorsque nous avons plusieurs images, nous en extrayons trois et si elles sont extraites dans le bon ordre, nous les qualifions de positives. Dans le cas où elles sont mélangées, nous les qualifions de négatives. Cela devient alors un problème de classification binaire pour prédire si les images sont dans le bon ordre ou non. Ainsi, en donnant un point de départ et un point d'arrivée, nous vérifions si le milieu est une interpolation valide des deux.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Figure 8 :</b> Architecture Shuffle & Learn
</center>

Nous pouvons utiliser un réseau siamois en triplet, où les trois images sont transmises indépendamment, puis nous concaténons les caractéristiques générées et effectuons la classification binaire pour prédire si les images sont mélangées ou non.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Figure 9 :</b> Représentation des voisins les plus proches
</center>

Là encore, nous pouvons utiliser l'algorithme des plus proches voisins pour visualiser ce que nos réseaux apprennent. Dans la figure 9 ci-dessus, nous avons d'abord une image requête que nous donnons au réseau pour obtenir une représentation des caractéristiques, puis nous regardons les voisins les plus proches dans l'espace de représentation. En comparant, nous pouvons observer une différence marquée entre les voisins obtenus à partir d'ImageNet, de *Shuffle & Learn* et de *Random*.

ImageNet est capable de réduire l'ensemble de la sémantique, car il comprend qu'il s'agit d'une scène de gymnastique pour la première entrée. De même, il peut comprendre qu'il s'agit d'une scène de plein air avec de l'herbe, etc. pour la deuxième requête. En revanche, lorsque nous observons *Random*, nous pouvons voir qu'il accorde une grande importance à la couleur de l'arrière-plan.

En observant *Shuffle & Learn*, il n'est pas immédiatement possible de savoir s'il se concentre sur la couleur ou sur le concept sémantique. Après une inspection plus poussée et l'observation de divers exemples, on a constaté qu'il s'agit de la pose de la personne. Par exemple, dans la première image, la personne est à l'envers et dans la seconde, les pieds sont dans une position particulière similaire à celle du cadre de la requête, ignorant la couleur de la scène ou de l'arrière-plan. Le raisonnement est de notre tâche de prétexte était de prédire si les images sont dans le bon ordre ou non, et pour ce faire, le réseau doit se concentrer sur ce qui bouge dans la scène, dans ce cas, la personne.

Cela a été vérifié quantitativement en ajustant cette représentation à la tâche d'estimation des points clés humains, où, étant donné une image humaine, nous prédisons où se trouvent certains points clés comme le nez, l'épaule gauche, l'épaule droite, le coude gauche, le coude droit, etc. Cette méthode est utile pour le suivi et l'estimation de la pose.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Figure 10 :</b> Comparaison des estimations des points clés
</center>

Dans la figure 10, nous comparons les résultats d'ImageNet supervisé et de *Shuffle & Learn* autosupervisé sur les jeux de données FLIC et MPII. Nous pouvons voir que *Shuffle & Learn* donne de bons résultats pour l'estimation des points clés.

<!--
### Pretext Tasks for videos and sound

Video and Sound are multi-modal where we have two modalities or sensory inputs one for video and one for sound. Where we try to predict whether the given video clip corresponds to the audio clip or not.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Figure 11:</b> Video and sound sampling
</center>

Given a video with audio of a drum, sample the video frame with corresponding audio and call it a positive set. Next, take the audio of a drum and the video frame of a guitar and tag it as a negative set. Now we can train a network to solve this as a binary classification problem.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Figure 12:</b> Architecture
</center>

**Architecture:** Pass the video frames to the vision subnetwork and pass the audio to the audio subnetwork, which gives 128-dimensional features and embeddings, we then fuse them together and solve it as a binary classification problem predicting if they correspond with each other or not.

It can be used to predict what in the frame might be making a sound. The intuition is if it is the sound of a guitar, the network roughly needs to understand how the guitar looks and same should be true for drums.
-->

### Tâches de prétexte pour les vidéos et le son

La vidéo et le son sont multimodaux, c'est-à-dire que nous avons deux modalités ou entrées sensorielles, une pour la vidéo et une pour le son. Nous essayons de prédire si le clip vidéo donné correspond ou non au clip audio.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Figure 11 :</b> Echantillonnage vidéo et sonore
</center>

Dans le cas d'une vidéo avec le son d'un tambour, nous échantillons la vidéo en images avec le son correspondant et nous appelons ça un ensemble positif. Ensuite, nous prenons l'audio d'une batterie et l’image d'une guitare et les marquons comme un ensemble négatif. Nous pouvons maintenant entraîner un réseau à résoudre ce problème de classification binaire.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Figure 12 :</b> Architecture
</center>

**Architecture :** nous passons les images vidéo au sous-réseau de vision et l'audio au sous-réseau audio, ce qui donne des caractéristiques et des enchâssements en 128 dimensions. Nous les fusionnons et résolvons comme un problème de classification binaire prédisant si elles correspondent ou non entre elles.

Cela peut être utilisé pour prédire ce qui, dans l'image, pourrait produire un son. L'intuition est que s'il s'agit du son d'une guitare, le réseau doit comprendre l'aspect de la guitare. Même logique pour la batterie.

<!--
## [Understanding what the "pretext" task learns](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

* Pretext tasks should be **complementary**

  * Let's take for example the pretext tasks *Relative Position* and *Colourisation*. We can boost performance by training a model to learn both pretext tasks as shown below:

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Figure 13:</b> Comparison of disjoint *vs.* combined training of Relative Position and Colourisation pretext tasks. ResNet101. (Misra)
</center>

  * A single pretext task may not be the right answer to learn SS representations

* Pretext tasks vary greatly in what they try to predict (difficultly)

  * Relative position is easy since it's a simple classification
  * Masking and fill-in is far harder => **better representation**
  * **Contrastive methods** generate even more info than pretext tasks

* **Question:** How do we train multiple pre-training tasks?

  * The pretext output will depend on the input. The final fully-connected layer of the network can be **swapped** depending on the batch type.
  * For example: A batch of black-and-white images is fed to the network in which the model is to produce a coloured image. Then, the final layer is switched, and given a batch of patches to predict relative position.

*  **Question:** How much should we train on a pretext task?

  * Rule of thumb: Have a very difficult pretext task such that it improves the downstream task.
  * In practice, the pretext task is trained, and may not be re-trained. In development, it is trained as part of the entire pipeline.
-->

## [Comprendre ce que la tâche prétexte apprend](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

* Les tâches de prétexte doivent être **complémentaires**

  * Prenons par exemple les tâches de prétexte *Position relative* et *Colorisation*. Nous pouvons améliorer les performances en entraînant un modèle pour apprendre les deux tâches de prétexte comme indiqué ci-dessous :

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Figure 13 :</b> Comparaison entraînement disjoint vs entraînement combiné des tâches de prétexte de Position Relative et de la Colorisation
</center>

  * Une seule tâche de prétexte peut ne pas être la bonne réponse pour apprendre les représentations autosupervisées

* Les tâches de prétexte varient beaucoup dans ce qu'elles essaient de prédire (difficilement)

  * La position relative est facile puisqu'il s'agit d'une simple classification
  * Le masquage et le remplissage sont beaucoup plus difficiles => **meilleure représentation**
  * **Les méthodes contrastives** génèrent encore plus d'informations que les tâches prétexte

* **Comment entraîner de multiples tâches de pré-entraînement ?**

>  * La sortie de la prétexte dépend de l'entrée. La dernière couche entièrement connectée du réseau peut être **intervertie** en fonction du type de lot.
>  * Par exemple : un batch d'images en noir et blanc est envoyé au réseau dans lequel le modèle doit produire une image en couleur. Ensuite, la couche finale est permutée et reçoit un batch de patchs pour prédire la position relative.

* **En quelle quantité devons-nous entraîner une tâche de prétexte ?**

>  * Règle empirique : avoir une tâche de prétexte très difficile telle qu'elle améliore la tâche en aval.
>  * En pratique, la tâche de prétexte est entraînée et ne peut pas être ré-entraînée. En développement, elle est entraînée dans le cadre de l'ensemble du pipeline.


<!--
## Scaling Self-Supervised Learning
-->
## Mise à l'échelle de l'apprentissage autosupervisé

<!--
### Jigsaw Puzzles

* Partition an image into multiple tiles and then shuffle these tiles. The model is then tasked with un-shuffling the tiles back to the original configuration. (Noorozi & Favaro, 2016)

  * Predict which permutation was applied to the input
  * This is done by creating batches of tiles such that **each tile of an image is evaluated independently**. The convolution output are then concatenated and the permutation is predicted as in figure below

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Figure 14:</b> Siamese network architecture for a Jigsaw pretext task. Each tile is passed through independently, with encodings concatenated to predict a permutation. (Misra)
</center>

  * Considerations:
    1. Use a subset of permutations *i.e.* From 9!, use 100)
    2. The n-way ConvNet uses shared parameters
    3. The problem complexity is the size of the subset. The *amount of information you are predicting.*

* Sometimes, this method can perform better on downstream tasks than supervised methods, since the network is able to learn some concepts about the geometry of its input.

* Shortcomings: Few Shot Learning: Limited number of training examples

  * **Self-supervised representations are not as sample efficient**
-->

### Puzzles Jigsaw

* Partitionner une image en plusieurs tuiles et mélanger ces tuiles. Le modèle est ensuite chargé de rétablir la configuration d'origine des tuiles (Noorozi & Favaro, 2016).

  * Prédire quelle permutation a été appliquée à l'entrée
  * Cela se fait en créant des lots de tuiles de telle sorte que **chaque tuile d'une image soit évaluée indépendamment**. Les sorties de convolution sont ensuite concaténées et la permutation est prédite comme dans la figure ci-dessous :

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Figure 14 :</b> Architecture d’un réseau siamois pour une tâche de prétexte Jigsaw. Chaque tuile est traversée indépendamment, avec des codages concaténés pour prédire une permutation
</center>

  * Considérations :
    1. Utiliser un sous-ensemble de permutations (c'est-à-dire de 9!, utiliser 100)
    2. Le ConvNet à *n* classes utilise des paramètres partagés
    3. La complexité du problème réside dans la taille du sous-ensemble, la quantité d'informations que nous prédisons

* Parfois, cette méthode peut être plus performante sur les tâches en aval que les méthodes supervisées car le réseau est capable d'apprendre certains concepts sur la géométrie de son entrée.

* Les lacunes : le *few-shot learning* (apprentissage avec un nombre limité d'exemples d'entraînement)

 * **Les représentations autosupervisées ne sont pas aussi efficaces sur l'échantillon**

<!--
### Evaluation: Fine-tuning *vs.* Linear Classifier

  This form of evaluation is a kind of **Transfer Learning**.

* **Fine Tuning**: When applying to our downstream task, we use our entire network as an **initialization** for which to train a new one, updating all the weights.

* **Linear Classifier**: On top of our pretext network, we train a small linear classifier to perform our downstream task, leaving the rest of the network intact.

> A good representation should transfer with a **little training**.

* It is helpful to evaluate the pretext learning on a **multitude of different tasks**. We can do so by extracting the representation created by different layers in the network as **fixed features** and evaluating their usefulness across these different tasks.
  * Measurement: Mean Average Precision (mAP) --The precision averaged across all the different tasks we are considering.
  * Some examples of these tasks include: Object Detection (using fine-tuning), Surface Normal Estimation (see NYU-v2 dataset)
* What does each layer learn?
  * Generally, as the layers become deeper, the mean average precision on downstream tasks using their representations will increase.
  * However, the **final layer** will see a sharp drop in the mAP due to the layer becoming overly **specialized**.
    * This contrasts with supervised networks, in that the mAP generally always increases with depth of layer.
    * This shows that the pretext task is **not well-aligned** to the downstream task.
-->

### Évaluation : *Finetuning* *vs* Classifieur linéaire
Cette forme d'évaluation est une sorte de **d'apprentissage par transfert**.
* ***Finetuning*** : lorsque nous appliquons à notre tâche en aval, nous utilisons notre réseau entier comme une **initialisation** pour entraîner notre nouveau réseau, en mettant à jour tous les poids.
* **Classifieur linéaire** : en plus de notre réseau de prétexte, nous entraînons un petit classifieur linéaire pour effectuer notre tâche en aval, en laissant le reste du réseau intact.

Une bonne représentation doit être transférée avec un **petit entraînement**.

* Il est utile d'évaluer l'apprentissage prétexte sur une **multitude de tâches différentes**. Nous pouvons le faire en extrayant la représentation créée par les différentes couches du réseau en tant que **caractéristiques fixes** et en évaluant leur utilité à travers ces différentes tâches.
  * Mesure : la précision moyenne (*Mean Average Precision* en anglais souvent siglée en mAP) de l'ensemble des différentes tâches que nous envisageons.
  * Quelques exemples de ces tâches : détection d'objets (en utilisant du *finetuning*), estimation de la surface (voir le jeu de données NYU-v2)
* Qu'apprend chaque couche ?
  * En général, plus les couches sont profondes, plus la précision moyenne sur les tâches en aval utilisant leurs représentations augmente.
  * Cependant, la **couche finale** verra une forte baisse de la mAP en raison de la sur-spécialisation de la couche.
    * Cela contraste avec les réseaux supervisés, dans la mesure où la mAP augmente généralement toujours avec la profondeur de la couche.
    * Cela montre que la tâche de prétexte n'est **pas bien alignée** sur la tâche en aval.
