---
lang: fr
lang-ref: ch.09-2
lecturer: Yann Le Cun
title: Modèles du monde et réseaux génératifs antagonistes
authors: Bofei Zhang, Andrew Hopen, Maxwell Goldstein, Zeping Zhan
date: 30 Mar 2020
translation-date: 09 Aug 2020
translator: Loïck Bourdois
---

<!--
## [World models for autonomous control](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)

One of the most important uses of self-supervised learning is to learn world models for control. When humans perform a task, we have an internal model for how the world works. For example, we gain an intuition for physics when we're about 9 months old, mostly through observation. In some sense, this is similar to self-supervised learning; in learning to predict what will happen, we learn abstract principles, just like self-supervised models learn latent features. But taking this one step further, the internal models let us act on the world. For example, we can use our learned physics intuition and our learned understanding of how our muscles work to predict --- and execute --- how to catch a falling pen.
-->

## [Modèles du monde pour le contrôle autonome](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)

L'une des utilisations les plus importantes de l'apprentissage autosupervisé est l'apprentissage de modèles du monde pour le contrôle. Lorsque les humains effectuent une tâche, ils disposent d'un modèle interne pour le fonctionnement du monde. Par exemple, nous acquérons une intuition pour la physique à l'âge de 9 mois environ, principalement par l'observation. Dans un certain sens, cela ressemble à l'apprentissage autosupervisé. En apprenant à prédire ce qui va se passer, nous apprenons des principes abstraits, tout comme les modèles autosupervisés apprennent des caractéristiques latentes. Mais en allant plus loin, les modèles internes nous permettent d'agir sur le monde. Par exemple, nous pouvons utiliser notre intuition en physique et notre compréhension du fonctionnement de nos muscles pour prédire (et exécuter) comment attraper un stylo qui tombe.

<!--
### What is a "world model"?

An autonomous intelligence system comprises four major modules (Figure 1.). First, the perception module observes the world and computes a representation of the state of the world. This representation is incomplete because 1) the agent doesn't observe the whole universe, and 2) the accuracy of the observations is limited. It is also worth noting that in the feed-forward model, the perception module is only present for the initial time step. Second, the actor module (also called a policy module) imagines taking some action based on the (represented) state of the world. Third, the model module predicts the outcome of the action given the (represented) state of the world, and also possibly given some latent features. This prediction gets passed forward to the next time step as the guess for the next state of the world, taking on the role of the perception module from the initial time step. Fig 2 gives an in-detail demonstration of this feed-forward process. Finally, the critic module turns that same prediction into a cost of performing the proposed action, *e.g.* given the speed with which I believe the pen is falling, if I move muscles in this particular way, how badly will I miss the catch?

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models_arch.png" height="400px" /><br>
<b>Fig. 1</b>: The World Models architecture of an autonomous intelligence system demonstration.
</center>

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models.png" height="400px" /><br>
<b>Fig. 2</b>: Model architecture.
</center>
-->

### Qu'est-ce qu'un modèle du monde (*world model*) ?

Un système intelligent autonome comprend quatre grands modules (figure 1). Tout d'abord, le module de perception observe le monde et calcule une représentation de l'état du monde. Cette représentation est incomplète parce que : \\
 1) l'agent n'observe pas l'univers en entier \\
 2) la précision des observations est limitée. \\
Il est également intéressant de noter que dans le modèle *feed-forward*, le module de perception n'est présent que pour le pas de temps initial.   Deuxièmement, le module acteur (également appelé module politique) imagine une action basée sur l'état (représenté) du monde.  
Troisièmement, le module modèle prédit le résultat de l'action en fonction de l'état (représenté) du monde, et peut-être aussi en fonction de certaines caractéristiques latentes. Cette prédiction est transmise au pas de temps suivant en tant que supposition de l'état suivant du monde, en prenant le rôle du module de perception à partir du pas de temps initial. La figure 2 présente une démonstration détaillée de ce processus d'anticipation.  
Enfin, le module critique transforme cette même prédiction en un coût de réalisation de l'action proposée. Par exemple étant donné la vitesse à laquelle je crois que le stylo tombe, si je bouge les muscles de cette manière particulière, à quel point vais-je rater la prise ?

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models_arch.png" height="400px" /><br>
<b>Figure 1 :</b> Architecture d’un modèle du monde d’un système intelligent autonome
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models.png" height="400px" /><br>
<b>Figure 2 :</b> Architecture du modèle
</center>


<!--
## The classical setting

In classical optimal control, there is no actor/policy module, but rather just an action variable. This formulation is optimized by a classical method called Model Predictive Control, which was used by NASA in the 1960s to compute rocket trajectories when they switched from human computers (mostly Black women mathematicians) to electronic computers. We can think of this system as an unrolled RNN, and the actions as latent variables, and use backpropagation and gradient methods (or possibly other methods, such as dynamic programming for a discrete action set) to infer the sequence of actions that minimizes the sum of the time step costs.

Aside: We use the word "inference" for latent variables, and "learning" for parameters, though the process of optimizing them is generally similar. One important difference is that a latent variable takes a specific value for each sample, whereas, parameters are shared between samples.
-->


## Le cadre classique

Dans le cadre classique du contrôle, il n'y a pas de module acteur/politique, mais plutôt une variable d'action. Cette formulation est optimisée par une méthode classique appelée « *Model Predictive Control* » qui a été utilisée par la NASA dans les années 1960 pour calculer les trajectoires des fusées lorsqu'elles sont passées des ordinateurs humains (principalement des mathématiciennes noires) aux ordinateurs électroniques. Nous pouvons considérer ce système comme un RNN déroulé et les actions comme des variables latentes. On peut utiliser des méthodes de rétropropagation et de gradient (ou éventuellement d'autres méthodes, comme la programmation dynamique pour un ensemble d'actions discrètes) pour inférer la séquence d'actions qui minimise la somme des coûts des pas de temps.

Note : nous utilisons le mot « inférence » pour les variables latentes et « apprentissage » pour les paramètres, bien que le processus d'optimisation de ceux-ci soit généralement similaire. Une différence importante est qu'une variable latente prend une valeur spécifique pour chaque échantillon, alors que les paramètres sont partagés entre les échantillons.

<!--
## An improvement

Now, we'd prefer not to go through the complicated process of backpropagating every time we want to make a plan. To address this, we use the same trick we used for variational autoencoder to improve sparse coding: we train an encoder to directly predict the optimal action sequence from the world representations. In this regime, the encoder is called a policy network.

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_policy_network.png" height="400px" /><br>
<b>Fig. 3</b>: Policy Network.
</center>

Once trained, we can use the policy networks to predict the optimal action sequence immediately after perception.
-->

## Une amélioration

Nous préférons ne pas passer par le processus compliqué de la rétropropagation chaque fois que nous voulons faire un plan. Pour y remédier, nous utilisons la même astuce que pour l'auto-encodeur variationnel pour améliorer le codage épars : nous entraînons un encodeur à prédire directement la séquence d'action optimale à partir des représentations du monde. Dans ce régime, l'encodeur est appelé un réseau politique.

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_policy_network.png" height="400px" /><br>
<b>Figure 3 :</b> Réseau politique
</center>

Une fois entraînés, nous pouvons utiliser les réseaux politiques pour prédire la séquence d'action optimale immédiatement après la perception.

<!--
## [Reinforcement learning (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)

The main differences between RL and what we have studied up to this point are two-fold:
1. In Reinforcement learning environments, the cost function is a black box. In other words, the agent does not understand the reward dynamics.
2. In the setting of RL, we don't use a forward model of the world to step the environment. Instead we interact with the real world and learn the result by observing what happens. In the real world our measure of the state of the world is imperfect so it is not always possible to predict what will happen next.

The main problem of Reinforcement learning is that the cost function is not differentiable. This means that the only way to learn is through trial and error. Then the problem becomes how to explore the state space efficiently. Once you come up with a solution to this the next issue is the fundamental question of exploration *vs.* exploitation: would you rather take actions to maximally learn about the environment or instead exploit what you have already learned to get as high a reward as possible?

Actor-Critic methods are a popular family of RL algorithms which train both an actor and a critic. Many RL methods work similarly, by training a model of the cost function (the critic). In Actor-Critic methods the role of the critic is to learn the expected value of the value function. This enables back-propagation through the module, since the critic is just a neural network. The actor's responsibility is to propose actions to take in the environment, and the critic's job is to learn a model of the cost function. The actor and the critic work in tandem that leads to more efficient learning than if no critic is used.  If you don't have a good model of the world it is much more difficult to learn: *e.g.* the car next to the cliff will not know that falling off a cliff is a bad idea. This enables humans and animals to learn much more quickly than RL agents: we have really good world models in our head.

We cannot always predict the future of the world due to inherent uncertainty: aleatory and epistemic uncertainty. Aleatoric uncertainty is due to things you cannot control or observe in the environment. Epistemic uncertainty is when you cannot predict the future of the world because your model does not have enough training data.

The forward model would like to be able to predict

$$\hat s_{t+1} = g(s_t, a_t, z_t)$$

where $z$ is a latent variable of which we don't know the value. $z$ represents what you cannot know about the world but which still influences the prediction (*i.e.* aleatoric uncertainty). We can regularize $z$ with sparsity, noise, or with an encoder. We can use forward models to learn to plan. The system works by having a decoder decode a concatenation of the state representation and the uncertainty $z$. The best $z$ is defined as the $z$ that minimizes the difference between $\hat s_{t+1}$ and the actual observed $s_{t+1}$.
-->

## [Apprentissage par renforcement](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)

Les principales différences entre l’apprentissage par renforcement (nous le noterons RL dans la suite, d’après le terme anglais *Reinforcement learning*) et ce que nous avons étudié jusqu'à présent sont de deux ordres :
1) Dans les environnements d'apprentissage par renforcement, la fonction de coût est une boîte noire. En d'autres termes, l'agent ne comprend pas la dynamique de la récompense.
2) Dans le cadre du RL, nous n'utilisons pas un modèle de prédiction du monde. Au lieu de cela, nous interagissons avec le monde réel et apprenons le résultat en observant ce qui se passe. Dans le monde réel, notre mesure de l'état du monde est imparfaite et il n'est donc pas toujours possible de prédire ce qui se passera ensuite.

Le principal problème du RL est que la fonction de coût n'est pas différenciable. Cela signifie que la seule façon d'apprendre est de procéder par essais et erreurs. Le problème devient alors de savoir comment explorer efficacement l'espace des états. Une fois que vous avez trouvé une solution à ce problème, la question qui suit est celle fondamentale de l'exploration *vs* l’exploitation : préférez-vous prendre des actions pour apprendre le plus possible sur l'environnement ou plutôt exploiter ce que vous avez déjà appris pour obtenir une récompense aussi élevée que possible ?

Les méthodes Acteur-Critique sont une famille populaire d'algorithmes de RL qui entraînent à la fois un acteur et un critique. De nombreuses méthodes de RL fonctionnent de manière similaire, en entraînant un modèle de la fonction de coût (le critique). Dans les méthodes Acteur-Critique, le rôle du critique est d'apprendre la valeur attendue de la fonction de valeur. Cela permet de faire une rétropropagation dans le module, puisque le critique n'est qu'un réseau neuronal. La responsabilité de l'acteur est de proposer des actions à entreprendre dans l'environnement. Le rôle du critique est d'apprendre un modèle de la fonction de coût. L'acteur et le critique travaillent en tandem, ce qui permet un apprentissage plus efficace que si aucun critique n'est utilisé.  Sans un bon modèle du monde, il est beaucoup plus difficile d'apprendre. Par exemple, la voiture à côté de la falaise ne saura pas que tomber d'une falaise est une mauvaise idée.  

Un modèle du monde permet aux humains et plus généralement aux animaux d'apprendre beaucoup plus rapidement que les agents du RL. Nous avons de très bons modèles du monde dans notre tête.

Nous ne pouvons pas toujours prédire l'avenir du monde en raison de l'incertitude inhérente : l'incertitude aléatoire et épistémique. L'incertitude aléatoire est due à des choses ne pouvant pas être contrôlé ou observé dans l'environnement. L'incertitude épistémique, est quand il n’est pas possible de prédire l'avenir du monde car le modèle ne contient pas assez de données d'entraînement.

Le modèle de prédiction aimerait pouvoir prédire

$$\hat s_{t+1} = g(s_t, a_t, z_t)$$

où $z$ est une variable latente dont nous ne connaissons pas la valeur. $z$ représente ce que nous ne pouvons pas savoir sur le monde mais qui influence quand même la prédiction (c'est-à-dire l'incertitude aléatoire). On peut régulariser $z$ avec parcimonie, du bruit ou avec un encodeur. Nous pouvons utiliser des modèles de prédiction pour apprendre à planifier. Le système fonctionne en ayant un décodeur décodant une concaténation de la représentation d'état et de l'incertitude $z$. Le meilleur $z$ est défini comme celui qui minimise la différence entre $\hat s_{t+1}$ et le $s_{t+1}$ effectivement observé.

<!--
## [Generative Adversarial Network](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)

There are many variations of GAN and here we think of GAN as a form of energy-based model using contrastive methods. It pushes up the energy of contrastive samples and pushes down the energy of training samples. A basic GAN consists of two parts: a generator which produces contrastive samples intelligently and a discriminator (sometimes called critic) which is essentially a cost function and acts as an energy model. Both the generator and the discriminator are neural nets.

The two kinds of input to GAN are respectively training samples and contrastive samples. For training samples, GAN passes these samples through the discriminator and makes their energy go down. For contrastive samples, GAN samples latent variables from some distribution, runs them through the generator to produce something similar to training samples, and passes them through the discriminator to make their energy go up. The loss function for discriminator is as follows:

$$\sum_i L_d(F(y), F(\bar{y}))$$

where $L_d$ can be a margin-based loss function like $F(y) + [m - F(\bar{y})]^+$ or $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ as long as it makes $F(y)$ decrease and $F(\bar{y})$ increase. In this context, $y$ is the label,  and  $\bar{y}$ is the response variable gives lowest energy except $y$ itself.
There is going to be a different loss function for the generator:

$$L_g(F(\bar{y}))  = L_g(F(G(z)))$$

where $z$ is the latent variable and $G$ is the generator neural net. We want to make the generator adapt its weight and produce $\bar{y}$ with low energy that can fool the discriminator.

The reason why this type of model is called generative adversarial network is because we have two objective functions that are incompatible with each other and we need to minimize them simultaneously. It’s not a gradient descent problem because the goal is to find a Nash equilibrium between these two functions and gradient descent is not capable of this by default.

There will be problems when we have samples that are close to the true manifold. Assume that we have an infinitely thin manifold. The discriminator needs to produce $0$ probability outside the manifold and infinite probability on the manifold. Since this is very difficult to achieve, GAN uses sigmoid and produces $0$ outside the manifold and produces $1$ on the manifold. The problem with this is that if we train the system successfully where we get the discriminator to produce $0$ outside the manifold, the energy function is completely useless. This is because the energy function is not smooth where all energy outside the data manifold will be infinity and all energy on the data manifold will be $0$. We don’t want the energy value to go from $0$ to infinity in a very small step. Researchers have proposed many ways to fix this problem by regularizing the energy function. A good example of improved GAN is Wasserstein GAN which limits the size of discriminator weight.
-->

## [Réseaux génératifs antagonistes](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)
Il existe de nombreuses variantes des réseaux génératifs antagonistes (GANs pour *Generative Adversarial Networks*). Nous considérons ici le GAN comme une forme de modèle à base d'énergie utilisant des méthodes contrastives. Il augmente l'énergie des échantillons contrastifs et diminue l'énergie des échantillons d'entraînement. Un GAN de base se compose de deux parties : un générateur qui produit des échantillons contrastifs de manière intelligente et un discriminateur (parfois appelé critique) qui est essentiellement une fonction de coût agissant comme un modèle énergétique. Le générateur et le discriminateur sont tous deux des réseaux neuronaux.  

Les deux types d'entrée dans le GAN sont respectivement des échantillons d'entraînement et des échantillons contrastifs. Pour les échantillons d'entraînement, le GAN les fait passer à travers le discriminateur et baisse leur énergie. Pour les échantillons contrastifs, le GAN échantillonne les variables latentes d'une certaine distribution, les fait passer par le générateur pour produire quelque chose de similaire aux échantillons d'entraînement et les fait passer par le discriminateur pour faire monter leur énergie. La fonction de perte pour le discriminateur est la suivante :

$$\sum_i L_d(F(y), F(\bar{y}))$$

où $L_d$ peut être une fonction de perte avec marge comme $F(y) + [m - F(\bar{y})]^+$ ou $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ tant que cela fait diminuer $F(y)$ et augmenter $F(\bar{y})$. Dans ce contexte, $y$ est le label et $\bar{y}$ est la variable réponse qui donne l'énergie la plus faible sauf $y$ lui-même.  

La fonction de perte est différente pour le générateur :

$$L_g(F(\bar{y})) = L_g(F(G(z)))$$

où $z$ est la variable latente et $G$ est le réseau générateur. Nous voulons faire en sorte que le générateur adapte son poids et produise $\bar{y}$ avec une faible énergie pouvant tromper le discriminateur.  

La raison pour laquelle ce type de modèle est appelé réseaux génératifs antagonistes est que nous avons deux fonctions objectives qui sont incompatibles l'une avec l'autre et que nous devons les minimiser simultanément. Ce n'est pas un problème de descente de gradient car le but est de trouver un équilibre de Nash entre ces deux fonctions or la descente de gradient n'en est pas capable par défaut.  

Il y aura des problèmes lorsque nous aurons des échantillons qui seront proches de la vraie variété. Supposons que nous ayons une surface infiniment fine. Le discriminateur doit produire une probabilité de $0$ à l'extérieur de la variété et une probabilité infinie sur la variété. Comme cela est très difficile à réaliser, le GAN utilise une sigmoïde pour produire $0$ en dehors de la variété et $1$ sur la variété. Le problème est que si nous entraînons le système avec succès en faisant en sorte que le discriminateur produise $0$ en dehors de la variété, la fonction d’énergie est complètement inutile. En effet, la fonction d’énergie n'est pas homogène car toute l'énergie en dehors de la variété de données sera infinie et toute l'énergie sur la variété de données sera nulle. Nous ne voulons pas que la valeur de l'énergie passe de $0 $ à l'infini en un tout petit pas. Les chercheurs ont proposé de nombreux moyens pour résoudre ce problème en régularisant la fonction d’énergie. Un bon exemple de GAN amélioré est le GAN de Wasserstein qui limite la taille du poids du discriminateur.
