---
lang: fr
lang-ref: ch.09-1
lecturer: Yann Le Cun
title: Auto-encodeurs discriminants récurrents épars et l’éparsité de groupe
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 30 Mar 2020
translation-date: 09 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Discriminative recurrent sparse autoencoder (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)

The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training.
 <center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/></center>

**Fig 1:** Discriminative Recurrent Sparse Auto-Encoder Network

The encoder, $W_e$, is similar to the encoder in the LISTA method. The $X$ variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, $S$, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer.

We train this neural network with 3 different criteria:
1. $L_1$: Apply $L_1$ criterion on the feature vector $Z$ to make it sparse.
2. Reconstruct $X$: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.
3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category.

The system is trained to minimize all 3 of these criteria at the same time.

The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features.
-->

## [Auto-encodeurs discriminants récurrents épars (Discriminative recurrent sparse autoencoder : DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)

L'idée des DrSAEs consiste à combiner un codage épars ou l'auto-encodeur épars avec un entraînement discriminant.
<center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/><br>
<b>Figure 1 :</b> Réseau DrSAE</center>


L'encodeur $W_e$ est similaire à celui de la méthode LISTA. La variable $X$ est passée par $W_e$, puis par une non-linéarité. Ce résultat est ensuite multiplié par une autre matrice apprise, $S$, et ajouté à $W_e$. Il est ensuite envoyé à travers une autre non-linéarité. Ce processus peut être répété un certain nombre de fois, chaque répétition constituant une couche.

Nous entraînons ce réseau de neurones avec 3 critères différents :
1. $L_1$ : appliquer le critère $L_1$ sur le vecteur d'entités $Z$ pour le rendre épars.
2. Reconstruire $X$ : ceci est fait en utilisant une matrice de décodage qui reproduit l'entrée sur la sortie. Ceci est fait en minimisant l'erreur quadratique, indiquée par $W_d$ dans la figure 1.
3. Ajouter un troisième terme : ce troisième terme, indiqué par $W_c$, est un simple classifieur linéaire qui tente de prédire une catégorie.

Le système est entraîné à minimiser ces trois critères en même temps.

L'avantage de cette méthode est de forcer le système à trouver des représentations qui peuvent reconstruire l'entrée, puis nous biaisons le système vers l'extraction de caractéristiques qui contiennent autant d'informations sur l'entrée que possible. En d'autres termes, cela enrichit les caractéristiques.


<!--
### Group Sparsity

The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling.
 <center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/></center>

**Fig 2:** Auto-Encoder with Group Sparsity

Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable $Z$ going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of $Z$, and take the sum of those norms. So now that is what is used as the regulariser, so we can have sparsity on groups of $Z$. These groups, or pools of features, tend to group together features that are similar to one another.
-->

### Eparsité de groupe

L'idée ici est de générer des caractéristiques éparses, c’est-à-dire pas seulement des caractéristiques normales qui sont extraites par des convolutions mais de produire essentiellement des caractéristiques qui sont éparses après le *pooling*.

 <center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/><br>
<b>Figure 2 :</b> Auto-encodeur avec éparsité de groupe</center>


La figure 2 montre un exemple d'auto-encodeur avec éparsité de groupe. Ici, au lieu de la variable latente $Z$ passant par une $L_1$, elle passe par une $L_2$ sur les groupes. Nous prenons donc la norme $L_2$ pour chaque composant dans un groupe de $Z$ et effectuons la somme de ces normes. C'est donc ce qui est utilisé comme régulariseur afin que nous puissions avoir une certaine éparsité dans les groupes de $Z$. Ces groupes de caractéristiques ont tendance à regrouper des caractéristiques qui sont similaires les unes aux autres.


<!--
## [AE with group sparsity: questions and clarification](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)

Q: Can a similar strategy used in the first slide with classifier and regulariser be applied for VAE?

A: Adding noise and forcing sparsity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function.

Q: In slide "AE with Group Sparsity", what is $P_j$?

A: $p$ is a pool of features. For a vector $z$, it would be a subset of the values in $z$.

Q: *Clarification on feature pooling.*

A: (Yann draws representation of AE with group sparsity) Encoder produces latent variable $z$, which is regularized using the $L_2$ norm of pooled features. This $z$ is used by the decoder for image reconstruction.

Q: Does group regularization help with grouping similar features?

A: The answer is unclear, work done here was done before computational power/ data was readily available. Techniques have not been brought back to the forefront.
-->

## [Auto-encodeur avec éparsité de groupe : questions des étudiants](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)

**Une stratégie similaire à celle utilisée dans la première diapositive avec le classifieur et le régulariseur peut-elle être appliquée pour les VAEs ?**
> Ajouter du bruit et forcer l’éparsité dans un VAE sont deux moyens de réduire l'information de la variable latente. Cela empêche l'apprentissage d'une fonction d'identité.

**Dans la diapositive « *AE with Group Sparsity* », qu'est-ce que $P_j$ ?**
> $p$ est un *pool* de caractéristiques. Pour un vecteur $z$, ce serait un sous-ensemble des valeurs de $z$.

**Clarification sur le *pooling* des caractéristiques.**
> L’encodeur produit une variable latente $z$ qui est régularisée en utilisant la norme $L_2$ des caractéristiques mises en commun. Cette variable $z$ est utilisée par le décodeur pour la reconstruction de l'image.

**La régularisation des groupes aide-t-elle à regrouper des caractéristiques similaires ?**
> La réponse n'est pas claire, le travail effectué ici a été fait avant que la puissance de calcul/les données ne soient facilement disponibles. Les techniques n'ont pas été remises au premier plan.

<!--
## [Image level training, local filters but no weight sharing](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)

The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it.

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/></center>
**Fig 3:** Structure of Convolutional RELU with Group Sparsity

As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regulariser. This is like L2 pooling with an architecture similar to group sparsity.

You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity.

Q : Should we use all possible sub-trees as groups?

A : It’s up to you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used.

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/></center>
**Fig 4:** Image Level Training, local filters but no weight sharing

These are called pin-wheel patterns. This is a kind of organisation of the features. The orientation varies continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain.

Q : Is the group sparsity term trained to have a small value?

It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criterion, it determines what the encoder and decoder will do and what sort of features will be extracted.

<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/></center>
**Fig 5:** Invariant Features through Lateral Inhibition

Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix $S$ is either determined by hand or learned so as to maximise this term. If the terms in $S$ are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuroscience). Thus, you try to find a value for $S$ that is as large as possible.

<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
**Fig 6:** Invariant Features through Lateral Inhibition (Tree Form)

If you organise S in terms of a tree, the lines represent the zero terms in the $S$ matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features except those which are up the tree or down the tree from it. This is something like the converse of group sparsity.

You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition.

To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger.
-->


## [Entraînement au niveau de l'image, filtres locaux mais pas de partage de poids](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)

La réponse à la question de savoir si cela aide n'est pas claire. Les personnes travaillant sur le sujet s'intéressent soit à la restauration d'images, soit à une sorte d'apprentissage autosupervisé. Cela fonctionnerait plutôt bien lorsque le jeu de données est très réduit. Lorsque nous avons un encodeur et un décodeur convolutifs et entraînons avec l'éparsité de groupe sur des cellules complexes, après avoir terminé l’entraînement, le système nous débarrasse du décodeur et n'utilise l'encodeur que comme un extracteur de caractéristiques. Nous pouvons alors coller une deuxième couche par-dessus.

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/><br>
<b>Figure 3 :</b> Structure d’un ConvNet avec ReLU et éparsité de groupe </center>

Comme on peut le voir ci-dessus, nous commençons avec une image, nous avons un encodeur qui est en fait une convolution puis une ReLU et une sorte de couche de mise à l'échelle. Nous entrainons avec une éparsité de groupe. Nous avons un décodeur linéaire et un critère qui est le groupe par 1. Nous prenons l’éparsité de groupe comme régularisation. C'est comme le *pooling* L2 avec une architecture similaire à l’éparsité de groupe.  
Nous pouvons aussi entraîner une autre instance de ce réseau. Cette fois, en ajoutant d'autres couches et en ayant un décodeur avec le *polling* L2 et le critère d’éparsité. On entraîne alors à reconstruire l’entrée avec le *pooling* au-dessus. Cela crée un ConvNet à deux couches pré-entraîné. Cette procédure est également appelée ***stacked autoencoder***. La principale caractéristique de cette procédure est qu'elle est entraînée à produire des caractéristiques invariantes avec une éparsité de groupe.

**Devrions-nous utiliser tous les sous-arbres possibles comme groupes ?**
> C'est à vous de décider, vous pouvez utiliser plusieurs arbres si vous le souhaitez. Nous pouvons entraîner l'arbre avec un arbre plus grand que nécessaire et ensuite retirer les branches rarement utilisées.

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/><br>
<b>Figure 4 :</b> Entraînement au niveau de l'image, filtres locaux mais pas de partage du poids </center>

> C'est ce qu'on appelle les *pinwheel patterns* (motifs en forme de pales de turbines). C'est une sorte d'organisation des caractéristiques. L'orientation varie continuellement lorsque vous contournez ces points rouges. Si nous prenons un de ces points rouges et si nous faisons un petit cercle autour des points rouges, nous remarquons que l'orientation de l'extracteur varie en quelque sorte continuellement lorsque nous nous déplaçons. Des tendances similaires sont observées dans le cerveau.

**Le terme d'éparsité de groupe est-il entraîné à avoir une petite valeur ?** 
> Il s'agit d'un régulariseur. Le terme lui-même n'est pas entraîné, il est fixe. C'est juste la norme L2 des groupes et les groupes sont prédéterminés. Mais, comme c'est un critère, il détermine ce que l’encodeur et le décodeur vont faire et quel type de caractéristiques seront extraites.

<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/><br>
<b>Figure 5 :</b> Caractéristiques invariantes par inhibition latérale </center>

> Ici, il y a un décodeur linéaire avec une erreur de reconstruction quadratique. Il y a un critère dans l'énergie. La matrice $S$ est soit déterminée à la main, soit apprise de façon à maximiser ce terme. Si les termes dans $S$ sont positifs et grands, cela implique que le système ne veut pas que $z_i$ et $z_j$ soient allumés en même temps. Il s'agit donc d'une sorte d'inhibition mutuelle (appelée inhibition naturelle en neurosciences). Nous essayons donc de trouver une valeur pour $S$ qui soit la plus grande possible.

<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/><br>
<b>Figure 6 :</b> Caractéristiques invariantes par inhibition latérale (forme d'arbre) </center>

> En organisant $S$ en termes d'arbre, les lignes représentent les termes nuls dans la matrice $S$. Chaque fois qu’il n’y a pas de ligne, il y a un terme non nul. Ainsi, chaque caractéristique inhibe toutes les autres caractéristiques, sauf celles qui sont en haut de l'arbre ou en bas de l'arbre. C'est un peu l'inverse de l’éparsité de groupe.  
> Nous voyons encore une fois que les systèmes organisent les caractéristiques de manière plus ou moins continue. Les caractéristiques le long de la branche d'un arbre représentent la même caractéristique avec différents niveaux de sélectivité. Les caractéristiques en périphérie varient plus ou moins.  
> Pour entraîner ce système, à chaque itération, nous donnons un $x$ et trouvons $z$ qui minimise cette fonction énergétique. Ensuite, nous faisons une étape de descente de gradient pour mettre à jour le $W$. Nous pouvons également faire une étape de montée de gradient pour augmenter les termes en $S$.
