---
lang: fr
lang-ref: ch.08-3
title: Modèles Génératifs et Auto-encodeurs variationnels
lecturer: Alfredo Canziani
authors: Richard Pang, Aja Klevs, Hsin-Rung Chou, Mrinal Jain
date: 24 March 2020
translation-date: 08 Aug 2020
translator: Loïck Bourdois
---


<!--
### [Recap: Auto-encoder (AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)

To summarize at a high level, a very simple form of AE is as follows:

- First, the autoencoder takes in an input and maps it to a hidden state through an affine transformation $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, where $f$ is an (element-wise) activation function. This is the **encoder** stage. Note that $\boldsymbol{h}$ is also called the **code**.
- Next, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, where $g$ is an activation function. This is the **decoder** stage.

*For a detailed explaination, refer to the notes of [Week 7]({{site.baseurl}}/en/week07/07-3/).*
-->

### [Récapitulatif : Auto-encodeur (AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)

Pour résumer l'auto-encodeur de manière très simple :

- Tout d'abord, l'auto-encodeur prend une entrée et l'associe à un état caché par une transformation affine $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, où $f$ est une fonction d'activation (par élément). C'est l'étape de **l'encodeur**. Notons que $\boldsymbol{h}$ est également appelé le **code**.
- Ensuite, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, où $g$ est une fonction d'activation. C'est l'étape du **décodeur**.

Pour une explication détaillée, voir les notes de la [semaine 7]({{site.baseurl}}/fr/semaine07/07-3/).


<!--
### Intuition behind VAE and a comparison with classic autoencoders

Next, we introduce Variational Autoencoders (or VAE), a type of generative models. But why do we even care about generative models? To answer the question, discriminative models learn to make predictions given some observations, but generative models aim to simulate the data generation process. One effect is that generative models can better understand the underlying causal relations which leads to better generalization.

Note that although VAE has "Autoencoders" (AE) in its name (because of structural or architectural similarity to auto-encoders), the formulations between VAEs and AEs are very different. See *Figure 1* below.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Fig. 1</b>: VAE vs. Classic AE
</center>

**What's the difference between variational auto-encoder (VAE) and classic auto-encoder (AE)?**

For VAE:
- First, the encoder stage: we pass the input $\boldsymbol{x}$ to the encoder. Instead of generating a hidden representation $\boldsymbol{h}$ (the code) in AE, the code in VAE comprises two things: $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ where $\boldsymbol{z}$ is the latent random variable following a Gaussian distribution with mean $\mathbb{E}(\boldsymbol{z})$ and variance $\mathbb{V}(\boldsymbol{z})$. Note that people use Gaussian distributions as the encoded distribution in practice, but other distributions can be used as well.
    - The encoder will be a function from $\mathcal{X}$ to $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (here we use $\boldsymbol{h}$ to represent the concatenation of $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$).
- Next, we will sample $\boldsymbol{z}$ from the above distribution parametrized by the encoder; specifically, $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ are passed into a **sampler** to generate the latent variable $\boldsymbol{z}$.
- Next, $\boldsymbol{z}$ is passed into the decoder to generate $\hat{\boldsymbol{x}}$.
    - The decoder will be a function from $\mathcal{Z}$ to $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.

In fact, for classic autoencoder, we can think of $\boldsymbol{h}$ as just the vector $\E(\boldsymbol{z})$ in the VAE formulation. In short, the main difference between VAEs and AEs is that VAEs have a good latent space that enables generative process.
-->

### Intuition derrière les VAEs et comparaison avec les auto-encodeurs classiques

Ensuite, nous présentons les auto-encodeurs variationnels (VAEs), un type de modèles génératifs. Mais pourquoi s'intéresser aux modèles génératifs ? Pour répondre à la question, les modèles discriminants apprennent à faire des prédictions à partir de certaines observations, mais les modèles génératifs visent à simuler le processus de génération de données. Un des effets est que les modèles génératifs peuvent mieux comprendre les relations causales sous-jacentes, ce qui conduit à une meilleure généralisation.

Il est à noter que bien que le nom VAE contienne le terme « auto-encodeurs » (AE) en raison de la similarité structurelle ou architecturale avec les auto-encodeurs, les formulations entre VAE et AE sont très différentes.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Figure 1 :</b> VAE vs AE classique
</center>

**Quelle est la différence entre l'auto-encodeur variationnel (VAE) et l'auto-encodeur classique (AE) ?**

Pour le VAE :
- D'abord, l'étape de l'encodeur : nous passons l'entrée $\boldsymbol{x}$ à l'encodeur. Au lieu de générer une représentation cachée $\boldsymbol{h}$ (le code) dans AE, le code dans VAE comprend deux choses : 
$\mathbb{E}(\boldsymbol{z})$ et $\mathbb{V}(\boldsymbol{z})$ où $\boldsymbol{z}$ est la variable aléatoire latente suivant une distribution gaussienne avec la moyenne $\mathbb{E}(\boldsymbol{z})$ et la variance $\mathbb{V}(\boldsymbol{z})$. A noter qu'en pratique, les gens utilisent les distributions gaussiennes comme distribution encodée, mais d'autres distributions peuvent également être utilisées.
L'encodeur sera une fonction de $\mathcal{X}$ à $\mathbb{R}^{2d}$ : $\boldsymbol{x} \mapsto \boldsymbol{h}$ (ici nous utilisons $\boldsymbol{h}$ pour représenter la concaténation de $\mathbb{E}(\boldsymbol{z})$ et $\mathbb{V}(\boldsymbol{z})$).
- Ensuite, nous allons échantillonner $\boldsymbol{z}$ à partir de la distribution ci-dessus paramétrée par l'encodeur. Plus précisément, $\mathbb{E}(\boldsymbol{z})$ et $\mathbb{V}(\boldsymbol{z})$ sont passés dans un **échantillonneur** pour générer la variable latente $\boldsymbol{z}$.
- Ensuite, $\boldsymbol{z}$ est passé dans le décodeur pour générer $\hat{\boldsymbol{x}}$.
- Le décodeur sera une fonction de $\mathcal{Z}$ vers $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.

En fait, pour l'auto-encodeur classique, on peut considérer $\boldsymbol{h}$ comme le vecteur $\E(\boldsymbol{z})$ de la formulation VAE. En bref, la principale différence entre les VAEs et les AEs est que les VAEs ont un bon espace latent qui permet le processus de génération.



<!--
### The VAE objective (loss) function

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Fig. 2</b>: Mapping from input space to latent space
</center>

*See Figure 2 above. For now, ignore the top-right corner (which is the reparameterisation trick explained in the next section).*

First, we encode from input space (left) to latent space (right), through encoder and noise. Next, we decode from latent space (right) to output space (left). To go from the latent to input space (the generative process) we will need to either learn the distribution (of the latent code) or enforce some structure. In our case, VAE enforces some structure to the latent space.

As usual, to train VAE, we minimize a loss function. The loss function is therefore composed of a reconstruction term as well as a regularization term.
- The reconstruction term is on the final layer (left side of the figure). This corresponds to $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ in the figure.
- The regularization term is on the latent layer, to enforce some specific Gaussian structure on the latent space (right side of the figure). We do so by using a penalty term $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. Without this term, VAE will act like a classic autoencoder, which may lead to overfitting, and we won't have the generative properties that we desire.
-->


### La fonction de perte des VAEs

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Figure 2 :</b> De l'espace d'entrée vers l'espace latent
</center>

Décrivons cette figure 2 ci-dessus. Commençons par ignorer le coin supérieur droit (qui est l'astuce de reparamétrage expliquée dans la section suivante).

D'abord nous encodons, de l'espace d'entrée (à gauche) à l'espace latent (à droite), en passant par l'encodeur et le bruit. Ensuite, nous décodons de l'espace latent (à droite) à l'espace de sortie (à gauche). Pour passer de l'espace latent à l'espace d'entrée (le processus de génération), nous devrons soit apprendre la distribution (du code latent), soit appliquer une certaine structure. Dans notre cas, le VAE applique une certaine structure à l'espace latent.

Comme d'habitude, pour entraîner le VAE, nous minimisons une fonction de perte. La fonction de perte est donc composée d'un terme de reconstruction ainsi que d'un terme de régularisation.
- Le terme de reconstruction se trouve sur la dernière couche (côté gauche de la figure). Cela correspond à $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ dans la figure.
- Le terme de régularisation se trouve sur la couche latente, pour renforcer une structure gaussienne spécifique sur l'espace latent (côté droit de la figure). Pour ce faire, nous utilisons un terme de pénalité $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. Sans ce terme, le VAE agira comme un auto-encodeur classique, ce qui peut conduire à du surentraînement et nous n'aurons pas les propriétés génératrices que nous souhaitons.


<!--
### Discussion on sampling $\boldsymbol{z}$ (**reparameterisation trick**)

How do we sample from the distribution returned by the encoder in VAE? According to above, we sample from the Gaussian distribution, in order to obtain $\boldsymbol{z}$. However, this is problematic, because when we do gradient descent to train the VAE model, we don't know how to do backpropagation through the sampling module.

Instead, we use the **reparameterization trick** to "sample" $\boldsymbol{z}$. We use $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ where $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. In this case, backpropagation in training is possible. Specifically, the gradients will go through the (element-wise) multiplication and addition in the above equation.
-->

### Discussion sur l'échantillonnage $\boldsymbol{z}$ (**astuce de paramétrage**)

Comment prélever un échantillon de la distribution renvoyée par l'encodeur dans la VAE ? Selon ce qui précède, nous effectuons un échantillonnage à partir de la distribution gaussienne, afin d'obtenir $\boldsymbol{z}$. Cependant, cela est problématique, car lorsque nous effectuons une descente de gradient pour entraîner le modèle VAE, nous ne savons pas comment effectuer la rétropropagation par le module d'échantillonnage.

Nous utilisons plutôt l'astuce du **reparamétrage** pour échantillonner $\boldsymbol{z}$. Nous utilisons $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ où $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. Dans ce cas, la rétropropagation lors de l'entraînement est possible. Plus précisément, les gradients passeront par la multiplication (par élément) et l'addition dans l'équation ci-dessus.


<!--
## [Breaking apart the VAE Loss Function](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)
-->

## [Rompre la fonction de perte des VAEs](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)


<!--
### Visualizing Latent Variable Estimates and Reconstruction Loss

As stated above, the loss function for the VAE contains two parts: a reconstruction term and a regularization term.  We can write this as

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = l_{reconstruction} + \beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d))
$$

To visualize the purpose of each term in the loss function, we can think of each estimated $\boldsymbol{z}$ value as a circle in $2d$ space, where the centre of the circle is $\mathbb{E}(\boldsymbol{z})$ and the surrounding area are the possible values of $\boldsymbol{z}$ determined by $\mathbb{V}(\boldsymbol{z}).$

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Fig. 3</b>: Visualizing vector $z$ as bubbles in the latent space
</center>

*In Figure 3 above, each bubble represents an estimated region of $\boldsymbol{z}$, and the arrows represent how the reconstruction term pushes each estimated value away from the others, which is explained more below.*

If there is overlap between any two estimates of $z$, (visually, if two bubbles overlap) this creates ambiguity for reconstruction because the points in the overlap can be mapped to both original inputs. Therefore the reconstruction loss will push the points away from one another.

However, if we use just the reconstruction loss, the estimates will continue to be pushed away from each other and the system could blow up.  This is where the penalty term comes in.

**Note:** for binary inputs the reconstruction loss is

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = - \sum\limits_{i=1}^n [x_i \log{(\hat{x_i})} + (1 - x_i)\log{(1-\hat{x_i})}]
$$

and for real valued inputs the reconstruction loss is

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = \frac{1}{2} \Vert\boldsymbol{x} - \hat{\boldsymbol{x}} \Vert^2
$$
-->

### Visualisation des estimations de variables latentes et de la perte de reconstruction

Comme indiqué ci-dessus, la fonction de perte pour le VAE comporte deux parties : un terme de reconstruction et un terme de régularisation. On peut écrire cela comme :

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = l_{reconstruction} + \beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d))
$$

Pour visualiser l'objectif de chaque terme dans la fonction de perte, nous pouvons penser à chaque valeur estimée de $\boldsymbol{z}$ comme un cercle dans un espace de $2d$, où le centre du cercle est $\mathbb{E}(\boldsymbol{z})$ et la zone environnante sont les valeurs possibles de $\boldsymbol{z}$ déterminées par $\mathbb{V}(\boldsymbol{z})$.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Figure 3 :</b> Visualisation du vecteur $z$ sous forme de bulles dans l'espace latent
</center>

Dans la figure 3 ci-dessus, chaque bulle représente une région estimée à $\boldsymbol{z}$ et les flèches représentent comment le terme de reconstruction éloigne chaque valeur estimée des autres, ce qui est expliqué plus en détail ci-dessous.

S'il y a un chevauchement entre deux estimations de $z$, (visuellement si deux bulles se chevauchent), cela crée une ambiguïté pour la reconstruction car les points de chevauchement peuvent être mis en correspondance avec les deux entrées originales. Par conséquent, la perte de reconstruction éloignera les points l'un de l'autre.

Cependant, si nous n'utilisons que la perte de reconstruction, les estimations continueront à être éloignées l'une de l'autre et le système pourrait exploser. C'est là qu'intervient le terme de pénalité.  

Note : pour les entrées binaires, la perte de reconstruction est :

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = - \sum\limits_{i=1}^n [x_i \log{(\hat{x_i})} + (1 - x_i)\log{(1-\hat{x_i})}]].
$$

et pour les entrées ayant une valeur réelle, la perte de reconstruction est :

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = \frac{1}{2} \Vert\boldsymbol{x} - \hat{\boldsymbol{x}} \Vert^2
$$



<!--
### The penalty term

The second term is the relative entropy (a measure of the distance between two distributions) between $\boldsymbol{z}$ which comes from a Gaussian with mean $\mathbb{E}(\boldsymbol{z})$, variance $\mathbb{V}(\boldsymbol{z})$ and the standard normal distribution. If we expand this second term in the VAE loss function we get:

$$
\beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d)) = \frac{\beta}{2} \sum\limits_{i=1}^d(\mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1 + \mathbb{E}(z_i)^2)
$$

Where each expression in the summation has four terms. Below we write out and graph the first three terms in *Figure 4*.

$$
v_i = \mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1
$$

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Fig. 4</b>: Plot showing how relative entropy forces the bubbles to have variance = 1
</center>

So we can see that this expression is minimized when $z_i$ has variance 1.  Therefore our penalty loss will keep the variance of our estimated latent variables at around 1.  Visually, this means our "bubbles" from above will have a radius of around 1.

The last term, $\mathbb{E}(z_i)^2$, minimizes the distance between the $z_i$ and therefore prevents the "exploding" encouraged by the reconstruction term.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Fig. 5</b>: The "bubble-of-bubble" interpretation of VAE
</center>

*Figure 5 above shows how VAE loss pushed the estimated latent variables as close together as possible without any overlap while keeping the estimated variance of each point around one.*

**Note:** The $\beta$ in the VAE loss function is a hyperparameter that dictates how to weight the reconstruction and penalty terms.
-->

### Le terme de pénalité

Le deuxième terme est l'entropie relative (une mesure de la distance entre deux distributions) entre $\boldsymbol{z}$ qui provient d'une gaussienne avec la moyenne $\mathbb{E}(\boldsymbol{z})$, la variance $\mathbb{V}(\boldsymbol{z})$ et la distribution normale standard. Si nous élargissons ce deuxième terme dans la fonction de perte du VAE, nous obtenons

$$
\beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d)) = \frac{\beta}{2} \sum\limits_{i=1}^d(\mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1 + \mathbb{E}(z_i)^2)
$$

Chaque expression de la somme comporte quatre termes. Ci-dessous, nous écrivons les trois premiers termes dans la figure 4 et nous les reportons sur un graphique.

$$
v_i = \mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1
$$

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Figue 4 :</b> Graphique montrant comment l'entropie relative force les bulles à avoir une variance de 1
</center>

On peut donc voir que cette expression est minimisée lorsque $z_i$ a la variance à 1. Par conséquent, notre perte de pénalité maintiendra la variance de nos variables latentes estimées à environ 1. Visuellement, cela signifie que nos « bulles » du haut auront un rayon d'environ 1.

Le dernier terme, $\mathbb{E}(z_i)^2$, minimise la distance entre les $z_i$ et empêche donc l'explosion favorisée par le terme de reconstruction.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Figure 5 :</b> L'interprétation « bulle-de-bulle » du VAE
</center>

La figure 5 ci-dessus montre comment la perte du VAE a poussé les variables latentes estimées aussi près que possible l'une de l'autre sans aucun chevauchement tout en maintenant la variance estimée de chaque point autour de 1.

Note : le $\beta$ dans la fonction de perte du VAE est un hyperparamètre qui dicte comment pondérer les termes de reconstruction et de pénalité.


<!--
## [Implementation of Variational Autoencoder (VAE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb).

In this notebook, we implement a VAE and train it on the MNIST dataset. Then we sample $\boldsymbol{z}$ from a normal distribution and feed to the decoder and compare the result. Finally, we look at how $\boldsymbol{z}$ changes in 2D projection.

**Note:** In the MNIST dataset used, the pixel values have been normalized to be in range $[0, 1]$.
-->

## [Implémentation de l'auto-encodeur variationnel (VAE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)

La version anglaise du *notebook* Jupyter se trouve [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb) et celle en français [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/11-VAE.ipynb).  

Dans ce *notebook*, nous implémentons un VAE et nous l'entraînons sur le jeu de données MNIST. Ensuite, nous échantillonnons $\boldsymbol{z}$ à partir d'une distribution normale et l'envoyons au décodeur pour comparer le résultat. Enfin, nous examinons comment $\boldsymbol{z}$ change dans la projection 2D.

Note : dans le jeu de données MNIST utilisé, les valeurs des pixels ont été normalisées pour se situer dans la plage $[0, 1]$.


<!--
### The Encoder and the Decoder

1. We define the encoder and decoder in our `VAE` module.
2. For the last linear layer of encoder, we define the output to be of size $2d$, of which the first $d$ values are the means and the remaining $d$ values are the variances. We sample $\boldsymbol{z} \in R^d$ using these means and variances as explained in the reparameterisation trick before.
3. For the last linear layer in the decoder, we use the sigmoid activation so that we can have output in range $[0, 1]$, similar to the input data.

```python
class VAE(nn.Module):
    def __init__(self):
        super().__init__()

        self.encoder = nn.Sequential(
            nn.Linear(784, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, d * 2)
        )

        self.decoder = nn.Sequential(
            nn.Linear(d, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, 784),
            nn.Sigmoid(),
        )
```
-->

### L'encodeur et le décodeur

1. Nous définissons l'encodeur et le décodeur dans notre module VAE.
2. Pour la dernière couche linéaire de l'encodeur, nous définissons la sortie comme étant de taille $2d$, dont les premières valeurs $d$ sont les moyennes et les autres valeurs $d$ sont les variances. Nous échantillonnons $\boldsymbol{z} \in R^d$ en utilisant ces moyennes et variances comme expliqué dans l'astuce de reparamétrage précédente.
3. Pour la dernière couche linéaire dans le décodeur, nous utilisons l'activation sigmoïde afin de pouvoir avoir une sortie dans la plage $[0, 1]$, similaire aux données d'entrée.


```python
class VAE(nn.Module):
    def __init__(self):
        super().__init__()

        self.encoder = nn.Sequential(
            nn.Linear(784, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, d * 2)
        )

        self.decoder = nn.Sequential(
            nn.Linear(d, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, 784),
            nn.Sigmoid(),
        )
```



<!--
### Reparameterisation and the `forward` function

For the `reparameterise` function, if the model is in training mode, we compute the standard deviation (`std`) from log variance (`logvar`). We use log variance instead of variance because we want to make sure the variance is non-negative, and taking the log of it ensures that we have the full range of the variance, which makes the training more stable.

During training, the `reparameterise` function will do the reparameterisation trick so that we can do backpropagation in training. To connect to the concept of a yellow bubble, as explained in the lecture, every time this function is called, we draw a point `eps = std.data.new(std.size()).normal_()`, so if we do 100 times, we will get 100 points which roughly forms a sphere because it's normal distribution, and the line `eps.mul(std).add_(mu)` will make this sphere centred in `mu` with radius equal to `std`.

For the `forward` function, we first compute the `mu` (first half) and `logvar` (second half) from the encoder, then we compute the $\boldsymbol{z}$ via the `reparamterise` function. Finally, we return the output of the decoder.

```python
def reparameterise(self, mu, logvar):
    if self.training:
        std = logvar.mul(0.5).exp_()
        eps = std.data.new(std.size()).normal_()
        return eps.mul(std).add_(mu)
    else:
        return mu

def forward(self, x):
    mu_logvar = self.encoder(x.view(-1, 784)).view(-1, 2, d)
    mu = mu_logvar[:, 0, :]
    logvar = mu_logvar[:, 1, :]
    z = self.reparameterise(mu, logvar)
    return self.decoder(z), mu, logvar
```
-->

### Reparamétrage et fonction `forward`

Pour la fonction `reparameterise`, si le modèle est en mode entraînement, nous calculons l'écart-type (`std`) de la variance logarithmique (`logvar`). Nous utilisons la variance logarithmique au lieu de la variance parce que nous voulons nous assurer que la variance n'est pas négative, et le fait de prendre le logarithme de celle-ci nous assure d'avoir la gamme complète de la variance, ce qui entraîne une plus grande stabilité de l'apprentissage.

Pendant l'entraînement, la fonction `reparameterise` permet de faire l'astuce permettant la rétropropagation. Pour faire le lien avec le concept de la bulle jaune, chaque fois que cette fonction est appelée, nous dessinons un point `eps = std.data.new(std.size()).normal_()`. Donc si nous le faisons 100 fois, nous obtenons 100 points qui forment approximativement une sphère parce que c'est une distribution normale et la ligne `eps.mul(std).add_(mu)` fait que cette sphère est centrée en `mu` avec un rayon égal à `std`.

Pour la fonction `forward`, nous calculons d'abord `mu` (première moitié) et le `logvar` (seconde moitié) à partir de l'encodeur, puis nous calculons le symbole $\boldsymbol{z}$ via la fonction `reparamterise`. Enfin, nous renvoyons la sortie du décodeur.


```python
def reparameterise(self, mu, logvar):
    if self.training:
        std = logvar.mul(0.5).exp_()
        eps = std.data.new(std.size()).normal_()
        return eps.mul(std).add_(mu)
    else:
        return mu

def forward(self, x):
    mu_logvar = self.encoder(x.view(-1, 784)).view(-1, 2, d)
    mu = mu_logvar[:, 0, :]
    logvar = mu_logvar[:, 1, :]
    z = self.reparameterise(mu, logvar)
    return self.decoder(z), mu, logvar
```


<!--
### Loss function for the VAE

Here we define the reconstruction loss (binary cross entropy) and the relative entropy (KL divergence penalty).

```python
def loss_function(x_hat, x, mu, logvar):
    BCE = nn.functional.binary_cross_entropy(
        x_hat, x.view(-1, 784), reduction='sum'
    )
    KLD = 0.5 * torch.sum(logvar.exp() - logvar - 1 + mu.pow(2))

    return BCE + KLD
```
-->

### Fonction de perte pour le VAE

Nous définissons ici la perte de reconstruction (entropie binaire croisée) et l'entropie relative (pénalité de divergence KL).

```python
def loss_function(x_hat, x, mu, logvar):
    BCE = nn.functional.binary_cross_entropy(
        x_hat, x.view(-1, 784), reduction='sum'
    )
    KLD = 0.5 * torch.sum(logvar.exp() - logvar - 1 + mu.pow(2))

    return BCE + KLD
```


<!--
### Generating new samples

After we train our model, we can sample a random $z$ from the normal distribution and feed it to our decoder. We can observe in *Figure 6* that some of the results are not good because our decoder has not "covered" the whole latent space. This can be improved if we train the model for more epochs.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Fig. 6</b>: Randomly moving in the latent space
</center>

We can look at how one digit morphs into another, which would not have been possible if we used an autoencoder. We can see that when we walk in the latent space, the output of the decoder still looks legit. *Figure 7* below shows how we morph the digit $3$ to $8$.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: Morphing the digit 3 into 8
</center>
-->


### Générer de nouveaux échantillons

Après avoir entraîné notre modèle, nous pouvons échantillonner un $z$ aléatoire de la distribution normale et l'envoyer à notre décodeur. Nous pouvons observer sur la figure 6 que certains des résultats ne sont pas bons parce que notre décodeur n'a pas couvert tout l'espace latent. Cela peut être amélioré si nous entraînons le modèle pour d'autres époques.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Figure 6 :</b> Déplacement aléatoire dans l'espace latent
</center>

Nous pouvons voir comment un chiffre se transforme en un autre, ce qui n'aurait pas été possible si nous avions utilisé un auto-encodeur. Nous pouvons voir que lorsque nous marchons dans l'espace latent, la sortie du décodeur semble toujours légitime. La figure 7 ci-dessous montre comment nous transformons le chiffre $3$ en $8$.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Figure 7 :</b> Transformation du chiffre 3 en 8
</center>


<!--
### Projection of means

Finally, let's take a look at how the latent space changes during/after training. The following charts in *Figure 8* are the means from the output of the encoder, projected on 2D space, where each colour represents a digit. We can see that from epoch 0, the classes are spreading everywhere, with only little concentration. As the model is trained, the latent space becomes more well-defined and the classes (digits) starts to form clusters.

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Fig. 8</b>: 2D projection of the means $\E(\vect{z})$ in latent space
</center>
-->

### Projection des moyennes
Enfin, examinons comment l'espace latent change pendant ou après l'entraînement. Les graphiques de la figure 8 sont les moyennes issues de la sortie de l'encodeur, projetées sur l'espace 2D, où chaque couleur représente un chiffre. Nous pouvons voir qu'à partir de l'époque 0, les classes se répandent partout, avec une faible concentration. Au fur et à mesure que le modèle est entraîné, l'espace latent devient plus défini et les classes (chiffres) commencent à former des groupes.
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Figure 8 :</b> Projection 2D des moyennes $\E(\vect{z})$ dans l'espace latent
</center>
