---
lang: fr
lang-ref: ch.08-2
lecturer: Yann Le Cun
title: EBMs à variables latentes régularisées
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 23 Mar 2020
translation-date: 08 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Regularized latent variable EBMs](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables:

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Fig. 1</b>: Example of an EBM with a latent variable
</center>

See the previous lecture's notes for more details.

Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference.

A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable:

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

This method will limit the volume of space of $z$ which takes a small value and the value which will, in turn, controls the space of $y$ that has low energy. The value of $\lambda$ controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE).
-->

## [EBMs à variables latentes régularisées](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

Les modèles avec des variables latentes sont capables de faire une distribution de prédictions $\overline{y}$ conditionnée par une entrée observée $x$ et une variable latente supplémentaire $z$. Les modèles à base d’énergie peuvent également contenir des variables latentes :

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Figure 1 :</b> Exemple d'un EBM à variable latente
</center>

Malheureusement, si la variable latente $z$ a une trop grande puissance expressive dans la production de la prédiction finale $\overline{y}$, chaque sortie réelle $y$ sera parfaitement reconstruite à partir de l'entrée $x$ avec un $z$ choisi de manière appropriée. Cela signifie que la fonction d'énergie sera partout égale à 0, puisque l'énergie est optimisée à la fois sur $y$ et $z$ pendant l'inférence.

Une solution naturelle consiste à limiter la capacité d'information de la variable latente $z$. Un moyen d'y parvenir est de régulariser la variable latente :

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

Cette méthode limite le volume de l'espace de $z$ qui prend une petite valeur et la valeur qui, à son tour, contrôle l'espace de $y$ ayant une faible énergie. La valeur de $\lambda$ contrôle ce compromis. Un exemple utile de $R$ est la norme $L_1$, qui peut être considérée comme une approximation différenciable de la dimension effective presque partout. Ajouter du bruit à $z$ tout en limitant sa norme $L_2$ peut également limiter son contenu en information (VAE).

<!--
### Sparse Coding

Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function.

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

The $n$-dimensional vector $z$ will tend to have a maximum number of non-zero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$.

After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero.
-->

### Codage épars

Le codage épars est un exemple d'EBM à variables latentes régularisées inconditionnelles qui tente essentiellement d'approcher les données avec une fonction linéaire par morceaux :

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

Le vecteur $z$ de dimension $n$ a tendance à avoir un nombre maximum de composantes non nulles $m << n$. Chaque $Wz$ est donc constitué d'éléments dans l'intervalle des $m$ colonnes de $W$.

Après chaque étape d'optimisation, la matrice $W$ et la variable latente $z$ sont normalisées par la somme des normes $L_2$ des colonnes de $W$. Cela garantit que $W$ et $z$ ne divergent pas à l'infini et à zéro.

<!--
### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Fig. 2</b>: FISTA computation graph
</center>

FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule:

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term.
-->

### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Figure 2 :</b> Graphe de calcul de FISTA
</center>

FISTA (*fast ISTA*) est un algorithme qui optimise la fonction d'énergie de codage épars $E(y,z)$ par rapport à $z$ en optimisant alternativement les deux termes $\Vert y - Wz\Vert^2$ et $\lambda \Vert z\Vert_{L^1}$. Nous initialisons $Z(0)$ et mettons à jour itérativement $Z$ selon la règle suivante :

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

L'expression interne $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ est un pas de gradient pour le terme $\Vert y - Wz\Vert^2$. La fonction $\text{Shrinkage}$ décale ensuite les valeurs vers 0, ce qui optimise le terme $\lambda \Vert z\Vert_{L_1}$.

<!--
### LISTA

FISTA is too expensive to apply to large sets of high-dimensional data (e.g. images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$:

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Fig. 3</b>: EBM with latent variable encoder
</center>

The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$:

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

We can further define

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

and then write

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Fig. 4</b>: LISTA as a recurrent net unfolded through time.
</center>
-->

### LISTA

FISTA est trop coûteux pour être appliqué à des jeux de données de grandes dimensions (par exemple les images). Un moyen de le rendre plus efficace est d'entraîner un réseau à prédire la variable latente optimale $z$ :

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Figure 3 :</b> Encodeur d'un EBM à variables latentes
</center>

L'énergie de cette architecture comprend alors un terme supplémentaire qui mesure la différence entre la variable latente prédite $\overline z$ et la variable latente optimale $z$ :

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

Nous pouvons définir plus précisément

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

et ensuite écrire

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

Cette règle de mise à jour peut être interprétée comme un réseau récurrent, ce qui suggère que nous pouvons apprendre les paramètres $W_e$ qui déterminent itérativement la variable latente $z$. Le réseau est exécuté pour un nombre de pas de temps $K$ fixe et les gradients de $W_e$ sont calculés en utilisant la rétropropagation standard à travers le temps. Le réseau entraîné produit alors un bon $z$ en moins d'itérations que l'algorithme FISTA.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Figure 4 :</b> LISTA comme un réseau récurrent déployé à travers le temps
</center>


<!--
### Sparse coding examples

When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Fig. 5</b>: Sparse coding on MNIST. Each image is a learned column of $W$.
</center>

When a sparse coding system is trained on natural image patches, the learned features are Gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems.
-->

### Exemples de codage épars

Lorsqu'un système de codage épars avec un vecteur latent à 256 dimensions est appliqué aux chiffres manuscrits de MNIST, le système apprend un ensemble de 256 traits qui peuvent être combinés linéairement pour reproduire presque tout l'ensemble d'entraînement. Le régularisateur épars garantit qu'ils peuvent être reproduits à partir d'un petit nombre de traits.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Figure 5 :</b> Codage épars sur MNIST. Chaque image est une colonne apprise de $W$
</center>

Lorsqu'un système de codage épars est entraîné sur des images naturelles, les caractéristiques apprises sont les filtres de Gabor, qui sont des bords orientés. Ces caractéristiques ressemblent aux caractéristiques apprises dans les premières parties des systèmes visuels des animaux.


<!--
### [Convolutional sparse coding](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

Suppose, we have an image and the feature maps ($z_1, z_2, \cdots, z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as:

$$Y=\sum_{i}K_i*Z_i$$

This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results.
-->

### [Codage convolutif épars](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

Supposons que nous ayons une image et les cartes de caractéristiques ($z_1, z_2, \cdots, z_n$) de l'image. Nous pouvons faire une convolution ($*$) de chacune des cartes de caractéristiques avec le noyau $K_i$. La reconstruction peut être alors simplement calculée comme :

$$Y=\sum_{i}K_i*Z_i$$

Cela est différent du codage épars original où la reconstruction est faite sous la forme $Y=\sum_{i}W_iZ_i$. Dans le codage épars de base, nous avons une somme pondérée de colonnes où les poids sont des coefficients de $Z_i$. Dans le codage convolutif épars, il s'agit toujours d'une opération linéaire, mais la matrice du dictionnaire est maintenant un ensemble de cartes de caractéristiques et nous effectuons une convolution de chacune d’elles avec chaque noyau et nous additionnons les résultats.

<!--
#### Convolutional sparse auto-encoder on natural images

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Fig.6</b> Filters and Basis Functions obtained. Linear convolutional decoder
</center>

The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error.

So, if we impose that there is only one filter then it is just a centre surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centres around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centres around, etc.

This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way.

As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Fig. 7 </b> Convolutional sparse encoding on colour image
</center>

The figure above is another example on colour images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-grey).
-->

#### Auto-encodeur convolutif épars sur des images naturelles

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Figure 6 :</b> Filtres et fonctions de base obtenus. Décodeur convolutionnel linéaire
</center>

Les filtres de l'encodeur et du décodeur se ressemblent beaucoup. L'encodeur est simplement une convolution suivie d'une non-linéarité, puis une couche diagonale pour changer l'échelle. Ensuite, il y a de l’éparsité sur la contrainte du code. Le décodeur n'est qu'un décodeur linéaire convolutif et la reconstruction est ici l'erreur quadratique.

Donc, si nous imposons qu'il n'y ait qu'un seul filtre, alors il s'agit juste d'un filtre de type *center surround*. Avec deux filtres, nous pouvons obtenir des filtres de forme étrange. Avec quatre filtres, nous obtenons des bords orientés (horizontaux et verticaux) et 2 polarités pour chacun des filtres. Avec huit filtres, nous pouvons obtenir des bords orientés à 8 orientations différentes. Avec 16 filtres, nous obtenons plus d'orientation ainsi que les *center surround*. En augmentant les filtres, on obtient des filtres plus variés, c'est-à-dire en plus des détecteurs de bords, on obtient également des détecteurs de réseaux de différentes orientations, des *center surround*, etc.

Ce phénomène semble intéressant car il est similaire à ce que nous observons dans le cortex visuel. C'est donc une indication que nous pouvons apprendre de très bonnes caractéristiques d'une manière totalement non supervisée.

Par ailleurs, si nous prenons ces caractéristiques et les connectons à un réseau convolutif, puis que nous les entraînons à une tâche quelconque, nous n'obtenons pas nécessairement de meilleurs résultats qu’un réseau d'images entraîner à partir de zéro. Cependant, dans certains cas, cela peut contribuer à améliorer les performances. Par exemple, dans les cas où le nombre d'échantillons n'est pas assez important ou s'il y a peu de catégories, en entraînant de manière purement supervisée, nous obtenons des caractéristiques dégénérées.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Figure 7 : </b> Codage convolutif épars sur une image en couleur
</center>

La figure ci-dessus est un autre exemple sur les images en couleur. Le noyau de décodage (sur le côté droit) est de taille 9 par 9. Ce noyau est appliqué par convolution sur l'ensemble de l'image. L'image de gauche est constituée des codes épars de l’encodeur. Le vecteur $Z$ est un espace très épars où il n'y a que peu de composantes blanches ou noires (non grises).


<!--
### [Variational autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)

Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Fig. 8</b>: Architecture of Variational Autoencoder
</center>

The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$.

The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 9(a).

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) Original set of fuzzy balls </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) Movement of fuzzy balls due to energy minimization without regularization</center>  |

<center><b>Fig. 9:</b> Effect of energy minimization on fuzzy balls</center>

The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 9(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction.

But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 10.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Fig. 10</b>: Effects of regularization visualized with springs
</center>

The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar.

It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses.
-->

### [Auto-encodeurs variationnels](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)
Les auto-encodeurs variationnels ont une architecture similaire à celle des EBMs à variable latente régularisée, à l'exception de l’éparsité. Au contraire, le contenu informationnel du code est limité en le rendant bruyant.
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Figure 8 :</b> Architecture de l'auto-encodeur variationnel
</center>
La variable latente $z$ n'est pas calculée en minimisant la fonction énergie par rapport à $z$. Au lieu de cela, la fonction énergie est considérée comme un échantillonnage aléatoire de $z$ selon une distribution dont le logarithme est le coût qui la relie à ${\overline z}$. La distribution est une gaussienne avec une moyenne de ${\overline z}$ et cela se traduit par l'ajout d'un bruit gaussien à ${\overline z}$.

Les vecteurs de code avec ajout de bruit gaussien peuvent être visualisés sous forme de boules floues, comme le montre la figure 9(a).

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) Ensemble original de « boules floues » </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) Mouvement de « boules floues » dû à la minimisation de l'énergie sans régularisation |

<center><b>Figure 9 :</b> Effet de la minimisation de l'énergie sur les « boules floues »</center>

Le système essaie de rendre les vecteurs de code ${\overline z}$ aussi grands que possible afin que l'effet de $z$ (bruit) soit aussi petit que possible. Cela a pour résultat que les « boules floues » s'éloignent de l'origine comme le montre la figure 9(b). Une autre raison pour laquelle le système tente de rendre les vecteurs de code plus grands est d'éviter le chevauchement des « boules floues », qui entraîne une confusion du décodeur entre les différents échantillons lors de la reconstruction.  
Mais nous voulons que les boules floues se regroupent autour d'une variété de données, s'il y en a une. Ainsi, les vecteurs de code sont régularisés pour avoir une moyenne et une variance proches de 0. Pour ce faire, nous les relions à l'origine par un ressort comme le montre la figure 10.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Figure 10 :</b> Effets de la régularisation visualisés avec des ressorts
</center>
La force du ressort détermine la proximité des « boules floues » par rapport à l'origine. Si le ressort est trop faible, les boules s’éloignent de l'origine. Et si le ressort est trop fort, alors elles s'effondrent à l'origine, ce qui entraîne une valeur d'énergie élevée. Pour éviter cela, le système ne laisse les sphères se chevaucher que si les échantillons correspondants sont similaires.
Il est également possible d'adapter la taille des boules floues. Ceci est limité par une fonction de pénalité (*KL Divergence*) qui tente de rendre la variance proche de 1 afin que la taille de la boule ne soit ni trop grande ni trop petite pour qu'elle s'effondre.
