---
lang: fr
lang-ref: ch.08-1
lecturer: Yann Le Cun
title: Méthodes Contrastives pour les modèles à base d’énergie
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
translation-date: 08 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Recap](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods.

As we have learned from the last lecture, there are two main classes of learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function $F$ which has minimized/limited low energy regions by applying regularization.

To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else.

Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn't “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values.
-->

## [Recapitulatif](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

Comme nous l'avons vu lors du dernier cours, il existe deux grandes catégories de méthodes d'apprentissage :
1. Les méthodes contrastives qui poussent vers le bas l'énergie des points des données d’entraînement, $F(x_i, y_i)$, tout en poussant vers le haut l'énergie sur tous les autres points, $F(x_i, y')$.
2. Les méthodes architecturales qui construisent une fonction d'énergie $F$ qui minimise/limite les régions à faible énergie en appliquant une régularisation.

Pour distinguer les caractéristiques des différentes méthodes d'entraînement, Yann a listé lors du [cours précédent]( https://atcold.github.io/pytorch-Deep-Learning/fr/week07) sept stratégies d'entraînement des deux classes mentionnées à l’instant. L'une d'entre elles est une méthode similaire à la méthode du maximum de vraisemblance, qui pousse l'énergie des points de données vers le bas et vers le haut partout ailleurs.

La méthode du maximum de vraisemblance pousse de façon probabiliste les énergies vers le bas des points des données d'entraînement et vers le haut partout ailleurs pour chaque autre valeur de $y'\neq y_i$. La méthode du maximum de vraisemblance ne se soucie pas des valeurs absolues des énergies, mais seulement de la différence entre les énergies. Comme la distribution des probabilités est toujours normalisée à 1, la comparaison du rapport entre deux points donnés est plus utile que la simple comparaison des valeurs absolues.


<!--
## [Contrastive methods in self-supervised learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold.

In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks.

Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below.
-->

## [Méthodes contrastives en apprentissage autosupervisé](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

Dans les méthodes contrastives, nous poussons vers le bas l'énergie des points des données d'entraînement observés ($x_i$, $y_i$), tout en poussant vers le haut l'énergie des points en dehors de la variété des données d'entraînement.

Dans l'apprentissage autosupervisé, nous utilisons une partie des données d'entrée pour prédire les autres parties. Nous espérons que notre modèle peut produire de bonnes caractéristiques pour la vision par ordinateur qui rivalisent avec celles des tâches supervisées.

Les chercheurs ont constaté empiriquement que l'application de méthodes d’enchâssement contrastives (*contrastive embedding methods*) à des modèles d'apprentissage autosupervisé peut donner de bonnes performances rivalisant avec celles des modèles supervisés. Nous allons explorer certaines de ces méthodes et leurs résultats.


<!--
### Contrastive embedding

Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, *etc.*). We call this a **positive** pair.

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Positive Pair
</center>

Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (*i.e.* a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold.

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Negative Pair
</center>

However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them.

This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs.

Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods.
-->

### Méthodes d’enchâssement contrastives

Considérons une paire ($x$, $y$), telle que $x$ est une image et $y$ est une transformation de $x$ qui préserve son contenu (rotation, grossissement, recadrage, etc.). Nous appelons cette paire, une paire **positive**.

<center><img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Figure 1 :</b> Paire positive
</center>

Conceptuellement, les méthodes d’enchâssement contrastives prennent un réseau convolutif et passent $x$ et $y$ à travers ce réseau pour obtenir deux vecteurs de caractéristiques : $h$ et $h'$. Comme $x$ et $y$ ont le même contenu (une paire positive), nous voulons que leurs vecteurs de caractéristiques soient aussi similaires que possible. Par conséquent, nous choisissons une métrique de similarité (telle que la similarité cosinus) et une fonction de perte qui maximise la similarité entre $h$ et $h'$. Ce faisant, nous réduisons l'énergie des images sur la variété des données d'entraînement.

<center><img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Figure 2 :</b> Paire négative
</center>

Cependant, nous devons également pousser l'énergie des points situés en dehors de cette variété. Ainsi, nous générons également des échantillons **négatifs** ($x_{\text{neg}}$, $y_{\text{neg}}$), des images au contenu différent (labels de classe différents par exemple). Nous les transmettons à notre réseau, obtenons les vecteurs de caractéristiques $h$ et $h'$, et essayons de minimiser la similarité entre eux.

Cette méthode nous permet de pousser vers le bas l'énergie des paires similaires tout en poussant vers le haut l'énergie des paires dissemblables.

Des résultats récents (sur ImageNet) ont montré que cette méthode peut produire des caractéristiques qui sont bonnes pour la reconnaissance d'objets et qui peuvent rivaliser avec les caractéristiques apprises par des méthodes supervisées.


<!--
### Self-Supervised Results (MoCo, PIRL, SimCLR)

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL and MoCo on ImageNet
</center>

As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRL is starting to approach the top-1 linear accuracy of supervised baselines (~75%).

We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows.

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

Here we define the similarity metric between two feature maps/vectors as the cosine similarity.

What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor.

Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs.

Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank.

**Question**: Why do we use cosine similarity instead of L2 Norm?
Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to centre) or make two vectors dissimilar by making them very "long" (away from the centre). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long.
-->


### Résultats des méthodes autosupervisées (MoCo, PIRL, SimCLR)

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Figure 3 :</b> PIRL et MoCo sur ImageNet
</center>

Comme le montre la figure ci-dessus, les méthodes MoCo et PIRL obtiennent les résultats de l’état de l’art (en particulier pour les modèles de faible capacité, avec un petit nombre de paramètres). PIRL commence à se rapprocher du top 1 de la précision linéaire des *baselines* supervisées (environ 75%).

Nous pouvons mieux comprendre PIRL en examinant sa fonction objectif, la NCE (*Noise Contrastive Estimator*) :

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

Nous définissons ici la métrique de similarité entre deux cartes/vecteurs de caractéristiques comme étant la similarité cosinus.

PIRL n'utilise pas la sortie directe de l'extracteur de caractéristiques du ConvNet. Il définit plutôt différentes _têtes_ $f$ et $g$, qui peuvent être considérées comme des couches indépendantes au-dessus de l'extracteur de caractéristiques.

En rassemblant tous ces éléments, la fonction objectif NCE de PIRL fonctionne comme suit.  
Dans un mini-batch, nous avons une paire positive (similaire) et de nombreuses paires négatives (dissemblables). Nous calculons ensuite la similarité entre le vecteur caractéristique de l'image transformée ($I^t$) et le reste des vecteurs caractéristiques du mini-batch (un positif, le reste négatif). Nous calculons ensuite le score d'une fonction de type softmax sur la paire positive. Maximiser un score softmax signifie minimiser le reste des scores, ce qui est exactement ce que nous voulons pour un modèle à base d'énergie. La fonction de perte finale nous permet donc de construire un modèle qui pousse l'énergie vers le bas sur des paires similaires tout en la poussant vers le haut sur des paires dissemblables.

Yann mentionne que pour que cela fonctionne, il faut un grand nombre d'échantillons négatifs. Dans la SGD, il peut être difficile de maintenir de façon constante un grand nombre de ces échantillons négatifs à partir de mini-batchs. C'est pourquoi PIRL utilise également une banque mémoire en cache.  


**Pourquoi utilisons-nous la similarité cosinus au lieu de la norme L2 ?**
> Avec une norme L2, il est très facile de rendre deux vecteurs similaires en les rendant « courts » (proches du centre) ou de rendre deux vecteurs dissemblables en les rendant très « longs » (éloignés du centre). En effet, la norme L2 n'est qu'une somme des carrés des différences partielles entre les vecteurs. Ainsi, l'utilisation de la similarité cosinus oblige le système à trouver une bonne solution sans « tricher » en rendant les vecteurs courts ou longs.


<!--
### SimCLR

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR Results on ImageNet
</center>

SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold.
-->

### SimCLR

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Figure 4 :</b> Résultats de SimCLR sur ImageNet</center>

SimCLR donne de meilleurs résultats que les méthodes précédentes. En fait, avec un nombre de paramètres suffisants, elle atteint les performances des méthodes supervisées de la « *top-1 linear accuracy* » sur ImageNet. La technique utilise une méthode sophistiquée d'augmentation de données pour générer des paires similaires et l’entraînement est réalisé pendant un temps considérable (avec des batchs très très importants) sur des TPUs. Yann pense que SimCLR, dans une certaine mesure, montre la limite des méthodes contrastives. Il y a beaucoup beaucoup de régions dans un espace en grande dimension où il faut pousser l'énergie vers le haut pour s'assurer qu'elle est effectivement plus élevée que sur la surface de données. Au fur et à mesure que vous augmentez la dimension de la représentation, vous avez besoin de plus en plus d'échantillons négatifs pour vous assurer que l'énergie est plus élevée dans les endroits qui ne sont pas sur la surface.

<!--
## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold.

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Architecture of denoising autoencoder
</center>
-->

## [Auto-encodeur débruiteur](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

Dans [les travaux dirigés de la semaine 7](https://atcold.github.io/pytorch-Deep-Learning/fr/week07/07-3/), nous avons discuté de l’auto-encodeur débruiteur. Le modèle tend à apprendre la représentation des données en reconstruisant l'entrée corrompue à l'entrée originale. Plus précisément, nous entraînons le système à produire une fonction d'énergie qui croît quadratiquement à mesure que les données corrompues s'éloignent de la variétés des données.

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Figure 5 :</b> Architecture de l’auto-encodeur débruiteur
</center>


<!--
### Issues

However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance.
-->

### Problèmes

Cependant, l’auto-encodeur débruiteur pose plusieurs problèmes. L'un des problèmes est que dans un espace continu de grande dimension, il existe d'innombrables façons de corrompre une donnée. Il n'y a donc aucune garantie que nous puissions modeler la fonction d'énergie en poussant simplement sur un grand nombre d'endroits différents.  
Un autre problème avec le modèle est qu'il est peu performant lorsqu'il s'agit d'images en raison de l'absence de variables latentes. Comme il existe de nombreuses façons de reconstruire les images, le système produit diverses prédictions et n'apprend pas de bonnes caractéristiques. En outre, les points corrompus au milieu de la variété pourraient être reconstruits des deux côtés. Cela créera des points plats dans la fonction d'énergie et affectera la performance globale.

<!--
## Other Contrastive Methods

There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence.
-->

## Autres méthodes contrastives

Il existe d'autres méthodes contrastives telles que la divergence contrastive, le *Ratio Matching*, le *Noise Contrastive Estimation* ou encore le *Minimum Probability Flow*. Nous abordons brièvement l'idée de base de la divergence contrastive.


<!--
### Contrastive Divergence

Contrastive divergence (CD) is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function.
-->

### Divergence contrastive

La divergence contrastive est un autre modèle qui apprend la représentation en corrompant intelligemment l'échantillon d'entrée. Dans un espace continu, nous choisissons d'abord un échantillon d'entraînement $y$ et nous en diminuons l'énergie. Pour cet échantillon, nous utilisons une sorte de processus basé sur des gradients pour descendre sur la surface de l'énergie avec du bruit. Si l'espace d'entrée est discret, nous pouvons à la place perturber l'échantillon d'entraînement de manière aléatoire pour modifier l'énergie. Si l'énergie que nous obtenons est plus faible, nous la gardons. Sinon, nous la rejetons avec une certaine probabilité. Si nous continuons ainsi, nous finissons par diminuer l'énergie de $y$. Nous pouvons alors mettre à jour le paramètre de notre fonction d'énergie en comparant $y$ et l'échantillon contrasté $\bar y$ avec une certaine fonction de perte.


<!--
### Persistent Contrastive Divergence

One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases.
-->

### Divergence contrastive persistante

L'un des raffinements de la divergence contrastive est la divergence contrastive persistante. Le système utilise un groupe de « particules » et se souvient de leurs positions. Ces particules sont déplacées vers le bas sur la surface d'énergie, tout comme nous l'avons fait dans la divergence contrastive ordinaire. Finalement, elles trouvent des endroits à faible énergie dans notre surface énergétique et les font monter. Cependant, le système ne s'adapte pas bien à l'échelle car la dimensionnalité augmente.
