---
lang: fr
lang-ref: ch.07-3
title: Introduction aux auto-encodeurs
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 07 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)
-->

## [Application des auto-encodeurs](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)


<!--
### Image generation

Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center>
-->

### Génération d'images

Pouvez-vous dire quel visage est faux dans la figure 1 ? En fait, les deux sont produits par le générateur StyleGan2. Bien que les détails du visage soient très réalistes, l'arrière-plan semble bizarre (à gauche : flou, à droite : objets déformés). Cela s'explique par le fait que le réseau neuronal est entraîné sur des échantillons de visages. L'arrière-plan présente alors une variabilité beaucoup plus importante. Ici, la variété des données a environ 50 dimensions, ce qui équivaut aux degrés de liberté d'une image de visage.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Figure 1</b> : Visages générés à partir de StyleGan2
</center>

<!--
### Difference of Interpolation in Pixel Space and Latent Space

<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center>

If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center>

If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center>

Obviously, latent space is better at capturing the structure of an image.
-->

### Différence d'interpolation dans l'espace des pixels et l'espace latent

<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Figure 2 :</b> Un chien et un oiseau
</center>

Si nous interpolons linéairement entre l'image du chien et celle de l'oiseau (figure 2) dans l'espace des pixels, nous obtenons une superposition de deux images en fondu dans la figure 3. Du haut à gauche au bas à droite, le poids de l'image du chien diminue et celui de l'image de l'oiseau augmente.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Figure 3 :</b> Résultats après interpolation
</center>

Si nous interpolons sur deux représentations de l'espace latent et les transmettons au décodeur, nous obtenons la transformation du chien en l’oiseau visible sur la figure 4.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Figure 4 :</b> Résultats après passage dans le décodeur
</center>

De toute évidence, l'espace latent est plus efficace pour saisir la structure d'une image.

<!--
### Transformation Examples

<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center>
-->

### Exemples de transformation

<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Figure 5 :</b> Zoom
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Figure 6 :</b> Décalage
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Figure 7 :</b> Luminosité
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Figure 8 :</b> Rotation (la rotation peut être en 3D)
</center>


<!--
### Image Super-resolution

This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez)

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center>

From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data.
-->

### Image en super-résolution

Ce modèle vise à améliorer les images et à reconstruire les visages originaux. De gauche à droite sur la figure 9, la première colonne est l'image d'entrée 16x16, la deuxième est ce que nous obtenons avec une interpolation bicubique standard, la troisième est la sortie générée par le réseau neuronal, et à droite est la véritable image.

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Figure 9 :</b> Reconstitution des visages originaux </center> 

D'après les images de sortie, il est clair qu'il existe des biais dans les données d’entraînement, ce qui rend les visages reconstruits inexacts. Par exemple, l'homme asiatique en haut à gauche a l'air européen dans les images de sortie en raison du déséquilibre des images d'entraînement. Le visage reconstruit en bas à gauche est bizarre en raison de l'absence d'images sous cet angle dans les données d’entraînement.


<!--
### Image Inpainting

<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center>

Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center>
-->

### Images non complètes

<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Figure 10 :</b> Placement d'une tache grise sur les visages
</center>

En plaçant une tache grise sur le visage, comme sur la figure 10, on éloigne l'image de la variété d'entraînement. La reconstruction du visage de la figure 11 est réalisée en trouvant l'échantillon d'image le plus proche sur la variété d'entraînement via la minimisation de la fonction énergie.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Figure 11 :</b> Image reconstruite à partir de la figure 10
</center>


<!--
### Caption to Image

<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center>

The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images.
-->

### Génération d’images d’après une légende

<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Figure 12 :</b> Exemple de génération d’images d’après une légende
</center>

La traduction en image de la description textuelle de la figure 12 est réalisée en extrayant les représentations des caractéristiques textuelles associées à des informations visuelles importantes, puis en les décodant en images.


<!--
## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center>

Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network.

We can represent the above network mathematically by using the following equations:

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

We also specify the following dimensionalities:

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$
-->


## [Qu'est-ce qu’un auto-encodeur ?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

Les auto-encodeurs sont des réseaux de neurones artificiels, entraînés de manière non supervisée, qui visent à apprendre d'abord les représentations codées de nos données et ensuite à générer les données d'entrée (aussi proches que possible) à partir des représentations codées apprises. Ainsi, la sortie d'un auto-encodeur est sa prédiction pour l'entrée.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Figure 13 :</b> Architecture d'un auto-encodeur de base <br>
</center>

La figure 13 montre l'architecture d'un auto-encodeur de base. Comme précédemment, nous partons du bas avec l'entrée $\boldsymbol{x}$ qui est soumise à un encodeur (transformation affine définie par $\boldsymbol{W_h}$, suivie d'un écrasement). Il en résulte la couche cachée intermédiaire $\boldsymbol{h}$. Celle-ci est soumise au décodeur (une autre transformation affine définie par $\boldsymbol{W_x}$, suivie d'un autre écrasement). Cela produit la sortie $\boldsymbol{\hat{x}}$, qui est la prédiction/reconstruction de l'entrée par notre modèle.

Nous pouvons représenter mathématiquement le réseau ci-dessus en utilisant les équations suivantes :

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

Nous précisons également les dimensions suivantes :

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Note :</b> Pour représenter l'ACP, nous pouvons avoir des poids serrés (ou des poids liés) définis par le symbole $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$

<!--
## Why are we using autoencoders?

At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders.

The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold i.e. given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations.

Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space.
-->

## Pourquoi utilisons-nous des auto-encodeurs ?

<!--
À ce stade, vous vous demandez peut-être à quoi sert la prédiction de l'entrée et quelles sont les applications des auto-encodeurs.
-->

Les principales applications d'un auto-encodeur sont la détection d'anomalies ou le débruitage d'images. Nous savons que la tâche d'un auto- encodeur est de reconstruire des données qui vivent sur la variété, c'est-à-dire que si nous avons une variété de données, nous voudrions que notre auto-encodeur ne puisse reconstruire que l'entrée qui existe dans cette variété. Ainsi, nous contraignons le modèle à reconstruire les choses qui ont été observées pendant l'entraînement et donc toute variation présente dans les nouvelles entrées sera supprimée car le modèle est insensible à ce genre de perturbations.

Une autre application de l'auto-encodeur est la compression d'images. Si nous avons une dimension intermédiaire $d$ inférieure à la dimension d'entrée $n$, alors l’encodeur peut être utilisé comme un compresseur et les représentations cachées (représentations codées) traitent toutes (ou la plupart) des informations de l'entrée spécifique en prenant moins de place.

<!--
## Reconstruction loss

Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e.

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

And when the input is real-valued, we may want to use the Mean Squared Error Loss given by

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$
-->

## Perte de reconstruction

Examinons maintenant les pertes liées à la reconstruction que nous utilisons généralement avec les auto-encodeurs. La perte globale pour le jeu de données est donnée comme la perte moyenne par échantillon, c'est-à-dire :

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

Lorsque l'entrée est catégorielle, nous pouvons utiliser la perte d’entropie-croisée pour calculer la perte par échantillon qui est donnée par :

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

Et lorsque l'entrée est évaluée en valeur réelle, nous pouvons utiliser la perte d'erreur moyenne au carré donnée par :

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$

<!--
## Under-/over-complete hidden layer

When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete vs an over-complete hidden layer<br>
</center>

As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier.

Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold.

It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc.
-->

## Couche cachée sous/sur-complète

Lorsque la dimensionnalité de la couche cachée $d$ est inférieure à la dimensionnalité de l'entrée $n$, on dit que la couche cachée est sous-complète. Et de même, lorsque $d>n$, nous disons qu'il s'agit d'une couche cachée sur-complète. La figure 14 montre une couche cachée sous-complète à gauche et une couche cachée sur-complète à droite.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Figure 14 :</b> Une couche cachée sous-complète vs une couche cachée sur-complète <br>
</center>

Comme nous l'avons vu plus haut, une couche cachée sous-complète peut être utilisée pour la compression car nous encodons les informations provenant de l'entrée en moins de dimensions. En revanche, dans une couche sur-complète, nous utilisons un codage de dimension plus élevée que l'entrée. Cela facilite l'optimisation.

Comme nous essayons de reconstruire l'entrée, le modèle est enclin à copier toutes les caractéristiques d'entrée dans la couche cachée et à la faire passer comme sortie, se comportant ainsi essentiellement comme une fonction identité. Cela doit être évité car cela impliquerait que notre modèle n'apprend rien. Nous devons donc appliquer des contraintes supplémentaires en créant un goulot d'étranglement au niveau de l'information. Nous le faisons en limitant les configurations possibles que la couche cachée peut prendre aux seules configurations vues pendant l’entraînement. Cela permet une reconstruction sélective (limitée à un sous-ensemble de l'espace d'entrée) et rend le modèle insensible à tout ce qui ne se trouve pas dans la variété.

Il est à noter qu'une couche sous-complète ne peut pas se comporter comme une fonction d'identité simplement parce que la couche cachée n'a pas assez de dimensions pour copier l'entrée. Ainsi, une couche cachée sous-complète a moins de chances de faire du surentraînement qu'une couche cachée sur-complète. Néanmoins elle peut quand même en faire. Par exemple, avec un encodeur et un décodeur puissants, le modèle pourrait simplement associer un numéro à chaque point de données et apprendre l’association. Il existe plusieurs méthodes pour éviter le surentraînement, telles que les méthodes de régularisation, les méthodes architecturales, etc.


<!--
## Denoising autoencoder

Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center>

In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot.

Fig.16 gives the relationship between the input data and output data.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center>

We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center>

The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process.
-->

## Auto-encodeur débruiteur

La figure 15 montre les multiples possibilités de l'auto-encodeur débruiteur et l'intuition de son fonctionnement.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Figure 15 :</b> Auto-encodeur débruiteur<br>
</center>

Dans ce modèle, nous supposons que nous injectons la même distribution bruitée que celle que nous allons observer dans la réalité, afin que nous puissions apprendre à nous en remettre de manière robuste.
En comparant l'entrée et la sortie, nous pouvons dire que les points qui se trouvaient déjà sur la variété des données n'ont pas bougé et que les points qui étaient éloignés sur la variété ont beaucoup bougé.

La figure 16 présente la relation entre les données d'entrée et les données de sortie.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Figure 16 :</b> Entrée et sortie de l'auto-encodeur débruiteur<br>
</center>


Nous pouvons utiliser différentes couleurs pour représenter la distance de chaque mouvement de point d'entrée, la figure 17 montre le diagramme.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Figure 17 :</b> Mesure de la distance parcourue par les données d'entrée <br>
</center>

Plus la couleur est claire, plus la distance parcourue par un point est longue. D'après le diagramme, nous pouvons dire que les points aux coins ont parcouru une distance proche d’une unité, alors que les points à l'intérieur des deux branches n'ont pas bougé du tout puisqu'ils sont attirés par les branches supérieures et inférieures pendant le processus d’entraînement.



<!--
## Contractive autoencoder

Fig.18 shows the loss function of the contractive autoencoder and the manifold.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center>

The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions.

Fig.19 shows how these autoencoders work in general.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center>

The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer.
-->


## Auto-encoder contractif

La figure 18 montre la fonction de perte de l'auto-encodeur contractif et de la variété.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Figure 18 :</b> Auto-encodeur contractif <br>
</center>

La fonction de perte contient le terme de reconstruction plus la norme au carré du gradient de la représentation cachée par rapport à l'entrée. Par conséquent, la perte globale minimise la variation de la couche cachée compte tenu de la variation de l'entrée. L'avantage est de rendre le modèle sensible aux directions de reconstruction tout en étant insensible aux autres directions possibles.

La figure 19 montre comment ces auto-encodeurs fonctionnent en général.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Figure 19 :</b> Auto-encodeur standard<br>
</center>

La variété d'entraînement est un objet unidimensionnel allant à trois dimensions. Où $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, le but de l'auto-encodeur est d'étirer la ligne bouclée dans une direction, où $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. En conséquence, un point de la couche d'entrée est transformé en un point de la couche latente. Nous avons maintenant la correspondance entre les points de l'espace d'entrée et les points de l'espace latent, mais pas la correspondance entre les régions de l'espace d'entrée et les régions de l'espace latent. Ensuite, nous utilisons le décodeur pour transformer un point de la couche latente afin de générer une couche de sortie significative.


<!--
## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).

In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs.
-->
## [Notebook : Implémenter l'auto-encodeur](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

La version anglaise du *notebook* Jupyter se trouve [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb) et la version française [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/10-autoencoder.ipynb).

Dans ce *notebook*, nous allons implémenter un auto-encodeur standard et un auto-encodeur débruiteur, puis comparer les résultats.

<!--
### Define autoencoder model architecture and reconstruction loss

Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model.


```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```
-->

### Définir l'architecture du modèle d'auto-encodeur et la perte de reconstruction

On utilise une image $28 \times 28$ et une couche cachée en $30$ dimensions. La routine de transformation passe de $784\to30\to784$. En appliquant la fonction tangente hyperbolique à la routine d'encodage et de décodage, nous sommes en mesure de limiter la plage de sortie à $(-1, 1)$. La perte d'erreur quadratique moyenne (MSE) est utilisée comme fonction de perte de ce modèle.

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```

<!--
### Train standard autoencodeur

To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop:
-->

### Entraîner un auto-encodeur standard

Pour entraîner un auto-encodeur standard en utilisant PyTorch, nous devons mettre les 5 méthodes suivantes dans la boucle d’entraînement :

<!--
#### Going forward:

1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`.
-->

#### Passe avant :

1) Envoyer l'image d'entrée à travers le modèle en appelant `output = model(img)`. <br>
2) Calculer la perte en utilisant : `criterion(output, img.data)`.

<!--
#### Going backward:

3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()`

Fig. 20 shows the output of the standard autoencoder.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/>
-->

#### Passe arrière :

3) Effacer le gradient pour s'assurer que nous n'accumulons pas la valeur : `optimizer.zero_grad()`. <br>
4) Rétropropagation : `loss.backward()`<br>
5) étape arrière : `optimizer.step()`

La figure 20 montre la sortie de l'auto-encodeur standard.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Figure 20 :</b> Sortie de l’auto-encodeur standard <br>
</center>
<br/>

<!--
### Train denoising autoencoder

For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`.

Fig. 21 shows the output of the denoising autoencoder.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center>
-->

### Entraîner un auto-encodeur débruiteur

Pour l’auto-encodeur débruiteur, nous devons ajouter les étapes suivantes :<br>
1) Appeler `do = nn.Dropout()` crée une fonction qui éteint les neurones de façon aléatoire. <br>
2) Créer un masque de bruit : `do(torch.ones(img.shape))`.<br>
3) Créez de mauvaises images en multipliant les bonnes images aux masques binaires : `img_bad = (img * noise).to(device)`.

La figure 21 montre la sortie de l'auto-encodeur débruiteur.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Figure 21 :</b> Sortie de l'auto-encodeur débruiteur<br>
</center>


<!--
### Kernels comparison

It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center>

On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center>

Compared to the state of the art, our autoencoder actually does better!! You can see the results below.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes inpainting output.
</center>
-->

### Comparaison des noyaux
Il est important de noter que malgré le fait que la dimension de la couche d'entrée est de $28 \times 28 = 784$ une couche cachée d'une dimension de 500 est toujours une couche sur-complète en raison du nombre de pixels noirs dans l'image.
Nous pouvons voir ci-dessous des exemples de noyaux utilisés dans un auto-encodeur standard sous-complet entraîné. Il est clair que les pixels dans la région où le nombre existe indiquent la détection d'une sorte de motif, tandis que les pixels en dehors de cette région sont essentiellement aléatoires. Cela indique que l'auto-encodeur standard ne se soucie pas des pixels situés en dehors de la région où se trouve le nombre.
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22 :</b> Noyaux d’auto-encodeurs standards
</center>

D'autre part, lorsque les mêmes données sont transmises à un auto-encodeur débruiteur où un masque de *dropout* est appliqué à chaque image avant l’application du modèle, quelque chose de différent se produit. Chaque noyau qui apprend un modèle fixe les pixels en dehors de la région où le nombre existe à une certaine valeur constante. Comme un masque de *dropout* est appliqué aux images, le modèle se préoccupe maintenant des pixels situés en dehors de la région où le nombre existe.
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23 :</b> Noyaux d’auto-encodeurs débruiteur
</center>

Par rapport à l'état de l'art, notre auto-encodeur fait en fait mieux ! Regardons les résultats ci-dessous :
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24 :</b> Données d’entrées (MNIST)
</center>
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25 :</b> Reconstructions de l'auto-encodeur débruiteur
</center>
<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26 :</b> Sortie obtenue via Telea
</center>
<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27 :</b> Sortie obtenue via Navier-Stokes
</center>
