---
lang: fr
lang-ref: ch.07-2
lecturer: Yann Le Cun
title: Apprentissage autosupervisé, détails des EBMs et exemples
authors: Ravi Choudhary， B V Nithish Addepalli, Syed Rahman，Jiayi Du
translation-date: 07 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Self supervised learning](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning. The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-Encoder (DAE) has particularly shown state-of-the-art results in Natural Language Processing (NLP).

<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center>

Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.

For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity.

State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center>

Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continuous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not.

An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models (EBMs) can be extremely useful for this.

A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss.
-->


## [Apprentissage autosupervisé](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

L'apprentissage autosupervisé (SSL pour *Self-Supervised Learning*) englobe à la fois l'apprentissage supervisé et non supervisé. L'objectif du SSL est d'apprendre une bonne représentation de l'entrée afin qu'elle puisse ensuite être utilisée pour des tâches supervisées. En SSL, le modèle est entraîné pour prédire une partie des données en fonction d'autres parties des données. Par exemple, BERT a été entraîné en combinant le SSL et l'auto-encodeur débruiteur. Ce modèle a montré des résultats de pointe en traitement du langage naturel (NLP pour *Natural Language Processing*).

<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Figure 1 :</b> Apprentissage autosupervisé
</center>

La tâche d'apprentissage autosupervisé peut être définie comme suit :
* prévoir l'avenir à partir du passé
* prédire le masqué à partir du visible
* prévoir les parties occultées à partir de toutes les parties disponibles

Par exemple, si un système est entraîné à prédire l'image suivante d’une vidéo, lorsque la caméra est déplacée, le système apprend implicitement la profondeur et la parallaxe. Cela oblige le système à apprendre que les objets occultés de sa vision ne disparaissent pas mais continuent d'exister. De même pour la distinction entre les objets animés, inanimés et l'arrière-plan. Le système peut également finir par apprendre la physique intuitive comme la gravité.

Les systèmes de NLP de pointe sont pré-entraînés via des réseaux neuronaux géants et du SSL. Nous supprimons certains mots d'une phrase et faisons en sorte que le système prédise les mots manquants. Cette méthode (BERT) a été couronnée de succès. Des idées similaires ont également été expérimentées dans le domaine de la vision par ordinateur. Comme le montre l'image ci-dessous, il est possible de prendre une image et en supprimer une partie, puis entraîner le modèle à prédire la partie manquante.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Figure 2 :</b> Résultats en vision par ordinateur
</center>

Bien que les modèles puissent combler l'espace manquant, ils n'ont pas connu le même succès que les applications en NLP. Si nous prenons les représentations internes générées par ces modèles et les donnons en entrée d'un système de vision par ordinateur, celui-ci est incapable de battre un modèle qui a été pré-entraîné de manière supervisée sur ImageNet. La différence de succès est qu’en NLP les mots sont discrets alors qu’en vision les images sont continues. Dans le domaine discret, nous savons comment représenter l'incertitude, nous pouvons utiliser un grand softmax sur les sorties possibles alors que ce n’est pas le cas dans le domaine continu.

Un système intelligent doit être capable de prédire les résultats de sa propre action sur l'environnement et de prendre lui-même des décisions intelligentes. Comme le monde n'est pas complètement déterministe et qu'il n'y a pas assez de puissance de calcul dans une machine/un cerveau humain pour prendre en compte toutes les possibilités, nous devons apprendre aux systèmes d'IA à prédire en présence d'incertitude dans les espaces en grandes dimensions. Les EBMs peuvent être extrêmement utiles à cet effet.

Un réseau neuronal entraîné à l'utilisation des moindres carrés pour prédire la prochaine image d'une vidéo produira des images floues parce que le modèle ne peut pas prédire exactement l'avenir. Pour réduire la perte, il apprend donc à faire la moyenne de toutes les possibilités de la prochaine image à partir des données d’entraînement.

<!--
### Latent variable energy-based models as a solution to make predictions for next frame:

Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs.

These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$ for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system.

Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$.

Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$
-->

### Les EMBs à variable latente comme solution pour faire des prédictions d'une image suivante

Contrairement à la régression linéaire, les EMBs à variable latente prennent ce que nous savons du monde ainsi qu'une variable latente qui nous donne des informations sur ce qui s'est passé dans la réalité. Une combinaison de ces deux éléments d'information peut être utilisée pour faire une prédiction qui sera proche de ce qui se passe réellement.

Ces modèles peuvent être considérés comme des systèmes qui évaluent la compatibilité entre l'entrée $x$ et la sortie réelle $y$ en fonction de la prédiction utilisant la variable latente qui minimise l'énergie du système. Nous observons l'entrée $x$, produisons des prédictions possibles $\bar{y}$ pour différentes combinaisons ($x$,$z$) et choisissons celle qui minimise l'énergie, l'erreur de prédiction, du système.

En fonction de la variable latente que nous tirons, nous pouvons nous retrouver avec toutes les prédictions possibles. La variable latente peut être considérée comme une information importante sur la sortie $y$ qui n'est pas présente dans l'entrée $x$.

La fonction d'énergie à valeur scalaire peut prendre deux versions :
1. conditionnelle : $F(x, y)$ mesure la compatibilité entre $x$ et $y$
2. inconditionnel : $F(y)$ mesure la compatibilité entre les composantes de $y$


<!--
## [Training an Energy-Based Model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)

There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization

There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the way they limit the information capacity of the code.

An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalised negative log density. Gibbs distribution gives us the likelihood of $y$ given $x$. It can be formulated as follows:

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\int_{y}e^{-\beta E(y,W)}
$$

Gradient of the negative log likelihood loss for one sample Y is as follows:

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

In the above gradient, the first term of the gradient at the data point $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy over all $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the data point $Y$ and the second term tries to increase the energy given to all other $Y$s.

The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases.
-->

## [Entraîner un EBM](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)

Il existe deux classes de modèles d'apprentissage pour entraîner un EMB à paramétrer $F(x, y)$.
1. Les **méthodes contrastives :** on pousse vers le bas sur $F(x[i], y[i])$ et on pousse vers le haut sur d'autres points $F(x[i], y')$
2. Les **méthodes architecturales :** on construit $F(x, y)$ de manière à limiter ou à minimiser le volume des régions à faible énergie par la régularisation

Il existe sept stratégies pour façonner la fonction d'énergie. Les méthodes contrastives diffèrent dans la manière de choisir les points à pousser vers le haut. Les méthodes architecturales diffèrent dans la façon dont elles limitent la capacité d'information du code.

Un exemple de la méthode contrastive est l'apprentissage par maximum de vraisemblance. L'énergie peut être interprétée comme une densité logarithmique négative non normalisée. La distribution de Gibbs nous donne la vraisemblance de $y$ pour $x$. Elle peut être formulée comme suit :

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

Le maximum de vraisemblance essaie de rendre le numérateur grand et le dénominateur petit pour maximiser la probabilité. Cela équivaut à minimiser $-\log(P(Y \mid W))$ qui est donné ci-dessous :

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$

Le gradient de la perte de la vraisemblance logarithmique négative pour un échantillon Y est le suivant :

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

Dans le gradient ci-dessus, le premier terme du gradient au point de données $Y$ et le second terme du gradient nous donne la valeur attendue du gradient de l'énergie sur l'ensemble des $Y$. Ainsi, lorsque nous effectuons la descente de gradient, le premier terme tente de réduire l'énergie donnée au point de données $Y$ et le second terme tente d'augmenter l'énergie donnée à tous les autres $Y$.

Le gradient de la fonction d'énergie est généralement très complexe et par conséquent le calcul, l'estimation ou l'approximation de l'intégrale est un cas très intéressant car il est insoluble dans la plupart des cas.


<!--
## [Latent variable energy-based model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)

The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ varies over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modelling
3. [GLO](https://arxiv.org/abs/1707.05776)

These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, $F(y)$ that measures the compatibility between the components of $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center>
-->

## [EMB à variable latente](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)

Le principal avantage des modèles à variables latentes est qu'ils permettent des prévisions multiples grâce à la variable latente. Comme $z$ varie sur un ensemble, $y$ varie sur la multiplicité des prédictions possibles. En voici quelques exemples :
1. K-means
2. Modélisation
3. [GLO](https://arxiv.org/abs/1707.05776)

Il peut y en avoir de deux types :
1. Modèles conditionnels où $y$ dépend de $x$ :
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Modèles inconditionnels qui ont une fonction d'énergie à valeur scalaire, $F(y)$ qui mesure la compatibilité entre les composantes de $y$ :
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Figure 3 :</b> EBM à variable latente
</center>

<!--
## Latent variable EBM example: $K$-means

K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center>

Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster.

In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of $W$.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral plot
</center>

Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold?

K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them.
-->

## Exemple d’EMB à variable latente : les $K$-means

Les $K$-means sont un algorithme de *clustering* simple qui peut également être considéré comme un modèle à base d’énergie dont nous essayons de modéliser la distribution sur $y$. La fonction d'énergie est $E(y,z) = \Vert y-Wz \Vert^2$ où $z$ est un vecteur *one-hot*.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Figure 4 :</b> Exemple des K-means
</center>

Avec une valeur de $y$ et $k$, nous pouvons faire une inférence en déterminant laquelle des colonnes possibles de $k$ de $W$ minimise l'erreur de reconstruction ou la fonction d'énergie. Pour entraîner l'algorithme, nous pouvons adopter une approche où nous pouvons trouver $z$ pour choisir la colonne de $W$ la plus proche de $y$ et ensuite essayer de nous rapprocher encore plus en prenant un pas de gradient et en répétant le processus. Cependant, la descente de gradient coordonné fonctionne en fait mieux et plus rapidement.

Dans le graphique ci-dessous, nous pouvons voir les points de données le long de la spirale rose. Les taches noires entourant cette ligne correspondent à des puits quadratiques autour de chacun des prototypes de $W$.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Figure 5 :</b> Graphique de la spirale
</center>

Une fois que nous avons appris la fonction d'énergie, nous pouvons commencer à aborder des questions comme :
1. Étant donné un point $y_1$, pouvons-nous prédire $y_2$ ?
2. Étant donné $y$, pouvons-nous trouver le point le plus proche sur la variété des données ?

Les $K$-means appartiennent aux méthodes architecturales (par opposition aux méthodes contrastives). Par conséquent, nous n'augmentons l'énergie nulle part. Tout ce que nous faisons, c'est de la faire baisser dans certaines régions. Un inconvénient est qu'une fois que la valeur de $k$ a été décidée, il ne peut y avoir que des points $k$ qui ont une énergie de $0$. Tous les autres points auront une énergie plus élevée qui croîtra de façon quadratique à mesure que nous nous en éloignerons.


<!--
## Contrastive methods

According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of $F(x,y)$) around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center>

There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo

We will briefly discuss denoising autoencoders and contrastive divergence.
-->

## Les méthodes contrastives

Selon Yann, tout le monde utilisera un jour des méthodes architecturales, mais pour l'instant, ce sont les méthodes contrastives qui fonctionnent pour les images. Considérons la figure ci-dessous qui nous montre quelques points de données et les contours de la surface énergétique. Idéalement, nous voulons que la surface énergétique ait l’énergie la plus faible sur la variété des données. Par conséquent, nous aimerions réduire l'énergie (c'est-à-dire la valeur de $F(x,y)$) autour de l'exemple d’entraînement, mais cela peut ne pas suffire. C'est pourquoi nous l'augmentons également pour les $y$ dans la région qui devrait avoir une énergie élevée mais qui a une énergie faible.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Figure 6 :</b> Méthodes contrastives
</center>

Il y a plusieurs façons de trouver les candidats pour lesquels nous voulons collecter de l'énergie. En voici quelques exemples :
1. L’auto-encodeur débruiteur (DAE)
2. La divergence contrastive
3. Monte Carlo
4. Les chaînes de Markov par Monte Carlo
5. Monte Carlo Hamiltonien

Aborderons brièvement la question des DAEs et de la divergence contrastive.


<!--
### Denoising autoencoder (DAE)

One way of finding $y$'s to increase energy for it is by randomly perturbing the training example as shown by the green arrows in the plot below.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center>

Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center>

Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point

If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold.

The following plot illustrates how we use the DAE.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center>
-->

### Auto-encodeur débruiteur (DAE)

Une façon de trouver des $y$ pour augmenter l'énergie nécessaire est de perturber aléatoirement l'exemple d’entraînement comme le montrent les flèches vertes dans le graphique ci-dessous :

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Figure 7 :</b> Carte topographique
</center>

Une fois que nous avons un point de données corrompu, nous pouvons pousser l'énergie jusqu'ici. Si nous le faisons suffisamment de fois pour tous les points de données, l'échantillon d'énergie se recroquevillera autour des exemples d’entraînement. Le graphique suivant illustre la façon dont l’entraînement est effectué :

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Figure 8 :</b> Entraînement
</center>
<br>

Étapes de l’entraînement :
1. Prendre un point $y$ et le corrompre
2. Entraîner l’encodeur et le décodeur à reconstruire le point de données original à partir de ce point de données corrompu

Si le DAE est correctement entraîné, l'énergie croît de façon quadratique à mesure que nous nous éloignons de la surface de données.

Le graphique suivant illustre la façon dont nous utilisons le DAE.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Figure 9 :</b> Utilisation du DAE
</center>

<!--
### BERT

BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstruction step consists of trying to predict these. Hence, this is also called a masked autoencoder.
-->

### BERT

BERT est entraîné de la même manière, sauf que l'espace est discret car nous avons affaire à du texte. La technique de corruption consiste à masquer certains mots et l'étape de reconstruction consiste à essayer de les prédire. C'est pourquoi on appelle aussi cela un auto-encodeur masqué.

<!--
### Contrastive divergence

Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center>
-->

### Divergence contrastive
La divergence contrastive nous offre une façon plus intelligente de trouver le point $y$ pour lequel nous voulons faire monter l'énergie. Nous pouvons donner un « coup de pied » aléatoire à notre point d'entraînement et ensuite descendre la fonction d'énergie en utilisant la descente de gradient. A la fin de la trajectoire, nous poussons l'énergie vers le haut pour le point où nous atterrissons. Ceci est illustré dans le graphique ci-dessous par la ligne verte.
<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Figure 10 :</b> Divergence contrastive
</center>
