---
lang: fr
lang-ref: ch.07-1
lecturer: Yann Le Cun
title: Modèles à base d’énergie (EBMs)
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translation-date: 07 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:

1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities.
-->

## [Vue d'ensemble](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

Nous allons introduire un nouveau cadre pour la définition des modèles. Il fournit un parapluie unificateur qui aide à définir des modèles supervisés, non supervisés et autosupervisé. Les modèles à base d’énergie (EBMs) observent un ensemble de variables $x$ et produisent un ensemble de variables $y$. Les réseaux *feed-forward* posent deux problèmes majeurs :

1. Que faire si la procédure d'inférence est un calcul plus complexe que des couches empilées de sommes pondérées ?
2. Que faire s'il y a plusieurs résultats possibles pour une seule entrée comme par exemple la prédiction des images futures dans une vidéo ?  
Dans un réseau de classification, nous entraînons ce réseau à émettre un score pour chaque classe. Toutefois, cela n'est pas possible dans un domaine continu à haute dimension comme les images : nous ne pouvons pas avoir de softmax sur les images ! Même si la sortie est discrète, elle pourrait avoir un grand espace d'échantillonnage. Le texte est compositionnel, ce qui conduit à un grand nombre de combinaisons possibles. Les modèles basés sur l'énergie fournissent un meilleur cadre pour modéliser ces modalités.


<!--
## EBM approach

Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`?

-->


## L’approche des EBMs

Au lieu d'essayer de classer les $x$ en $y$, nous aimerions prédire si une certaine paire de ($x$, $y$) s'assemble ou non. Ou, en d'autres termes, trouver un $y$ compatible avec $x$. Nous pouvons également poser le problème de trouver un $y$ pour lequel certains $F(x,y)$ sont faibles. Par exemple :
- est-ce que $y$ est une image haute résolution précise de $x$ ?  
- le texte $A$ est-il une bonne traduction du texte $B$ ?  



<!--
### Definition

We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$
-->

### Définition

Nous définissons une fonction énergie $F : \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ où $F(x,y)$ décrit le niveau de dépendance entre les paires $(x,y)$.  
A noter que cette énergie est utilisée en inférence et non **pas** pour l'apprentissage. L'inférence est donnée par l'équation suivante :

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


<!--
### Solution: gradient-based inference

We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring.
-->

### Solution : l'inférence basée sur les gradients

Nous aimerions que la fonction d'énergie soit lisse et différenciable afin d'effectuer l'inférence. Nous recherchons cette fonction en utilisant la descente de gradient pour trouver des $y$ compatibles.
Il existe de nombreuses méthodes alternatives aux méthodes de gradient pour obtenir le minimum.

**Note** : les modèles graphiques sont un cas particulier des modèles à base d’énergie. La fonction d'énergie se décompose en une somme de termes d'énergie. Chaque terme énergétique prend en compte un sous-ensemble de variables que nous avons à traiter. S'ils s'organisent sous une forme particulière, il existe des algorithmes d'inférence efficaces pour trouver le minimum de la somme des termes par rapport à la variable que nous souhaitons inférer.


<!--
## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (e.g. French). Hence, having this latent variable in our model will be very useful to interpret such an input.
-->

## [EBMs à variables latentes](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

La sortie $y$ dépend de $x$ ainsi que d'une variable supplémentaire $z$ (la variable latente) dont nous ne connaissons pas la valeur. Ces variables latentes peuvent fournir des informations auxiliaires. Par exemple, elle peut vous indiquer la position des limites des mots dans un morceau de texte. C'est utile quand nous voulons interpréter une écriture sans espaces. C'est aussi particulièrement utile pour les discours qui peuvent présenter des lacunes difficiles à déchiffrer. De plus, certaines langues ont des limites de mots très faibles comme par exemple le français. Ainsi, la présence de cette variable latente dans notre modèle est très utile pour interpréter de telles entrées.


<!--
### Inference

To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$.

Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center>
-->

### Inférence

Pour réaliser l'inférence d’un EBM à variable latente, nous voulons minimiser simultanément la fonction d'énergie par rapport à $y$ et $z$ :

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

Et cela équivaut à redéfinir la fonction énergie comme : $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, ce qui équivaut à : $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.  
Lorsque $\beta \rightarrow \infty$, alors $\check{y} = \text{argmin}_{y}F(x,y)$.


Un autre grand avantage d’autoriser des variables latentes est qu'en faisant varier la variable latente sur un ensemble, nous pouvons aussi faire varier la prédiction $y$ sur la multitude de prédictions possibles (le ruban est montré dans le graphique ci-dessous) : $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

Cela permet à une machine de produire plusieurs sorties.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Figure 1 :</b> Graphe de calcul pour les modèles à base d’énergie
</center>



<!--
### Examples

One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced.
-->

### Exemples

Un exemple est la prédiction vidéo. Il existe de nombreuses bonnes applications pour l'utilisation de la prédiction vidéo, par exemple pour la réalisation d'un système de compression vidéo. Une autre est d'utiliser la vidéo d'une voiture autonome et de prédire ce que les autres voitures vont faire.  

Un autre exemple est la traduction. La traduction a toujours été un problème difficile car il n'existe pas de traduction unique et correcte d'un texte d'une langue à l'autre. En général, il existe de nombreuses façons différentes d'exprimer une même idée et les gens ont du mal à comprendre pourquoi ils en choisissent une plutôt qu'une autre. Il serait donc bon que nous ayons un moyen de paramétrer toutes les traductions possibles qu'un système pourrait produire pour un texte donné. Disons que si nous voulons traduire de l'allemand en anglais, il pourrait y avoir plusieurs traductions en anglais qui sont toutes correctes, et en faisant varier certaines variables latentes, vous pourriez alors faire varier la traduction produite.


<!--
## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy)
-->

## [Les EBMs *vs* les modèles probabilistes](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

Nous pouvons considérer les énergies comme des probabilités logarithmiques négatives non normalisées et utiliser la distribution de Gibbs-Boltzmann pour convertir l'énergie en probabilité après normalisation qui est :

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

où $\beta$ est une constante positive et doit être calibrée pour s'adapter à votre modèle.  
Un plus grand $\beta$ donne un modèle plus fluctuant tandis qu’un plus petit $\beta$ donne un modèle plus lisse. En physique, $\beta$ est la température inverse : $\beta \rightarrow \infty$ signifie que la température va à 0.

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Maintenant, si on marginalise sur $y$ : $P(y \mid x) = \int_z P(y,z \mid x)$, on a :

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Ainsi, si nous disposons d'un modèle à variable latente et que nous voulons éliminer la variable latente $z$ de manière probabiliste, il suffit de redéfinir la fonction d'énergie $F_\beta$ : l'énergie libre.


<!--
### Free Energy

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.

Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy.

***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.***

The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, may more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use  -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualization of the energy function that captures dependency between x and y
</center>

This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what  will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example:

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Example for multiple prediction of EBM as an implicit function
</center>

There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.   sucks [in this case]!

So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regulariser})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser.

So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong.
-->


### L'énergie libre

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Calculer ceci peut être très difficile. En fait, dans la plupart des cas, c'est probablement insoluble.  Donc si vous avez une variable latente que vous voulez minimiser à l'intérieur de votre modèle ou si vous avez une variable latente que vous voulez marginaliser (ce que vous faites en définissant cette fonction d'énergie $F$) et que la minimisation correspond à la limite infinie $\beta$ de cette formule, alors c'est possible.

Selon la définition de $F_\beta(x, y)$ ci-dessus, $P(y \mid x)$ n'est qu'une application de la formule de Gibbs-Boltzmann et $z$ a été implicitement marginalisé à l'intérieur de celle-ci. Les physiciens appellent cela l'**énergie libre**, c'est pourquoi nous l'appelons $F$ (*free energy* en anglais).
Donc $e$ est l'énergie et $F$ est l'énergie libre.


### Quels sont les avantages qu'offrent les modèles à base d’énergie ? 
En effet, dans les modèles basés sur les probabilités, il est aussi possible d'avoir des variables latentes qui peuvent être marginalisées.  

La différence est que dans les modèles probabilistes, nous n’avons pas le choix de la fonction objectif que nous allons minimiser. Il faut rester fidèle au cadre probabiliste au sens que chaque objet qui est manipulé doit avoir une distribution normalisée (qu’il est possible d’approximer en utilisant des méthodes variationnelles, etc.).  
Ce que nous voulons faire en fin de compte avec ces modèles, c'est prendre des décisions. Par exemple avec un système qui conduit une voiture et qui indique « Tourner à gauche avec une probabilité de 0,8 ou tourner à droite avec une probabilité de 0,2 », on va tourner à gauche. Le fait que les probabilités soient de 0,2 et 0,8 n'a pas d'importance. Ce que nous voulons, c'est prendre la meilleure décision, parce que nous sommes obligés de prendre une décision. Les probabilités sont donc inutiles quand nous voulons prendre des décisions.   
Si nous voulons combiner la sortie d'un système automatisé avec un autre (par exemple, un système humain ou autre) et que ces systèmes n'ont pas été entraînés ensemble, mais plutôt séparément, alors ce que nous voulons, ce sont des scores calibrés pour pouvoir combiner les scores des deux systèmes afin de prendre une bonne décision. Il n'y a qu'une seule façon de calibrer les scores et c'est de les transformer en probabilités. Tous les autres moyens sont soit inférieurs, soit équivalents. Mais si on souhaite entraîner un système de bout en bout à la prise de décision, alors n'importe quelle fonction de notation utilisée est bonne, à condition qu'elle donne le meilleur score à la meilleure décision.  
<br> 
Les EBMs offrent beaucoup plus de choix quant à la façon de manipuler le modèle, peut-être même plus de choix sur la manière de l'entraîner ainsi que pour la fonction objectif pouvant être utilisée. Si nous insistons pour que votre modèle soit probabiliste, nous devons utiliser le maximum de vraisemblance. Il nous faut entraîner le modèle de telle manière que la probabilité qu'il donne aux données observées soit maximale. Le problème est que l'on ne peut prouver que cela fonctionne que si votre modèle est « correct » mais un modèle n'est jamais « correct ».  Le statisticien Goerge Box a dit : ***« Tous les modèles sont faux mais certains sont utiles »***. Les modèles probabilistes, en particulier ceux dans les espaces en grandes dimensions et dans les espaces combinatoires comme le texte, sont donc tous des modèles approximatifs. Ils sont tous erronés d'une certaine manière et si nous essayons de les normaliser, nous les rendons encore plus erronés. Il est donc préférable de ne pas les normaliser.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Figure 2 :</b> Visualisation de la fonction d'énergie qui saisit la dépendance entre x et y
</center>

Il s'agit d'une fonction d'énergie qui vise à capturer la dépendance entre $x$ et $y$. C'est comme une chaîne de montagnes. Les vallées sont là où se trouvent les points noirs (ce sont des points de données) et il y a des montagnes tout autour. Considérons que les points sont sur une variété infiniment mince, la distribution des données pour les points noirs n'est donc en fait qu'une ligne, et il y en a trois. Ils n'ont aucune largeur. Donc si nous entraînons un modèle probabiliste sur cela, le modèle de densité devrait vous dire quand nous sommes sur cette surface. Sur cette variété, la densité est infinie et toutes $\varepsilon$ en dehors d'elle devrait être zéro. Ce serait le modèle correct de cette distribution. Ainsi non seulement la densité doit être infinie, mais l'intégrale sur [x et y] doit être égale à 1. C'est très difficile à mettre en œuvre sur ordinateur car c'est fondamentalement impossible. 
Si nous voulions calculer cette fonction par une sorte de réseau neuronal, celui-ci devra avoir des poids infinis et ils devront être calibrés de telle sorte que l'intégrale de la sortie de ce système sur l'ensemble du domaine soit de 1. C'est pratiquement impossible. Le modèle probabiliste précis et correct pour cet exemple particulier de données est impossible. C'est ce que le maximum de vraisemblance voudra que nous produisions mais aucun ordinateur au monde peut calculer ça. Donc, en fait, ce n'est même pas intéressant.   
Et si nous imaginons avoir le modèle de densité parfait pour cet exemple, qui est une fine plaque dans cet espace ($x$, $y$), nous ne pourrions pas faire d'inférence ! Si on nous donne une valeur de $x$ et qu'on nous demande quelle est la meilleure valeur pour $y$, nous ne pourrions pas la trouver car toutes les valeurs de $y$, à l’exception d’un ensemble de probabilité 0, ont une probabilité de zéro et il n'y a que quelques valeurs possibles.
<br>
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Figure 3 :</b> Exemple de prédiction multiple de l'EBM en tant que fonction implicite
</center>

Dans la figure ci-dessous, il y a 3 valeurs de $y$ qui sont possibles pour le $x$ donné et elles sont infiniment étroites. Il n'y a pas d'algorithme d'inférence permettant de les trouver. La seule façon de faire ça est de rendre votre fonction de contraste lisse et différentiable. Alors il est possible de partir de n'importe quel point et par descente de gradient trouver une bonne valeur pour $y$ pour n'importe quelle valeur de $x$. Mais ce ne sera pas un bon modèle probabiliste de la distribution si la distribution est comme celle mentionnée. Voici donc un cas où insister pour avoir un bon modèle probabiliste est en fait mauvais. Le maximum de vraisemblance est néfaste dans ce cas !

Si vous êtes un Bayésien, vous dites « oh mais on peut corriger ça en ayant un a priori fort indiquant que la fonction de densité doit être lisse ».
Mais, tout ce qui est fait en termes bayésiens (mathématiquement parlant), mène aux modèles à base d'énergie. Les EBMs qui ont un régulariseur, qui est additif à la fonction d'énergie, sont complètement équivalents aux modèles bayésiens où la vraisemblance de l'énergie est exponentielle : nous avons $\exp(\text{énergie}) \exp(\text{ régulariseur })$ et c'est égal à $\exp(\text{énergie} + \text{régulariseur})$.  Supprimer l'exponentielle, donne un modèle à base d'énergie avec un régulariseur additif.
Il y a donc là une correspondance entre les méthodes probabilistes et bayésiennes. 

<!--
Il faut avoir en tête que faire le maximum de vraisemblance est parfois néfaste, en particulier dans les espaces en grandes dimensions ou les espaces combinatoires où le modèle probabiliste est très erroné. Cela n'est pas très erroné dans les distributions discrètes (c'est correct) mais dans les cas continus cela peut être vraiment erroné. Enfin tous les modèles sont erronés.
-->
