---
lang: fr
lang-ref: ch.06-3
title: Architectures des RNNs et des LSTMs
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
translation-date: 06 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is the temporal axis. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions.
-->

## [Vue d'ensemble](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

Le RNN est un type d'architecture que nous pouvons utiliser pour traiter des séquences de données. Qu'est-ce qu'une séquence ? Le cours sur le RNN nous a appris qu'un signal peut être soit 1D, 2D ou 3D selon le domaine. Le domaine est défini par le point de départ et le point d'arrivée. Le traitement des données séquentielles concerne essentiellement les données 1D puisque le domaine est l'axe temporel. Néanmoins, il est possible d’utiliser le RNN pour traiter des données 2D où il y a deux directions.


<!--
### Vanilla vs. RNN

Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center>

In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Basic NN Architecture
</center>

Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Yann's RNN Architecture
</center>
-->


### Architecture standard vs le RNN

La figure 1 est un diagramme de réseau de neurones *vanilla* avec trois couches. « Vanilla » est un terme américain signifiant « standard / de base ». La bulle rose est le vecteur d'entrée $x$, au centre se trouve la couche cachée en vert et la dernière couche bleue est la sortie. En utilisant un exemple d'électronique numérique sur la droite de la figure, c'est comme une logique combinatoire où le courant de sortie ne dépend que du courant d'entrée.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1 :</b> Architecture standard
</center>


Contrairement à un réseau de neurones standard, dans les RNNs la sortie du courant dépend non seulement de l'entrée mais aussi de l'état du système, comme le montre la figure 2. C'est comme une logique séquentielle en électronique numérique, où la sortie dépend également d'un interrupteur (une unité de mémoire de base dans l'électronique numérique). La principale différence ici est donc que la sortie d'un réseau neuronal standard ne dépend que de l'entrée, tandis que celle d'un RNN dépend également de l'état du système.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br> <b>Figure 2 :</b> Architecture RNN
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br> 
<b>Figure 3 :</b> Architecture d’un réseau de neurones de base
</center>

Le diagramme utilisé par Yann ajoute des formes entre les neurones pour représenter l'association entre un tenseur et un autre (un vecteur à un autre). Par exemple, dans la figure 3, le vecteur d'entrée $x$ va correspondre à travers cet élément supplémentaire aux représentations cachées $h$. Cet élément est en fait une transformation affine, c'est-à-dire une rotation plus une distorsion. Ensuite, par une autre transformation, nous passons de la couche cachée à la sortie finale. De même, dans le diagramme RNN, il est possible d’avoir les mêmes éléments supplémentaires entre les neurones.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br> <b>Figure 4 :</b> L'architecture RNN de Yann
</center>




<!--
### Four types of RNN Architectures and Examples

The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Vec to Seq
</center>

An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> vec2seq Example: Image to Text
</center>

The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Seq to Vec
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Input lines of Python Codes
</center>

Then the network will be able to output the correct solution of this program. Another more complicated program like this:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center>

Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.

The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Seq to Vec to Seq
</center>

If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Words Grouped by Semantics after PCA
</center>

If we zoom in, we will see that the in the same location there are all the months, like January and November.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b> Zooming in Word Groups
</center>

If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b> Word Groups in another Region
</center>

From these examples, we see that different locations will have some specific common meanings.

Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transformation going from one word to another or from country to capital.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b> Semantics Features Picked during Training
</center>

The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b> Seq to Seq
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b> Text Auto-Completion Model of Seq to Seq Model
</center>
-->

### Quatre types d'architectures RNN et des exemples

Le premier cas est celui du « vector to sequence » (un vecteur en entrée du réseau et on obtient une sequence en sortie). L'entrée est la bulle rose.  La succession des états internes du système est représentée par les bulles vertes. À mesure que l'état du système évolue, il y a une sortie spécifique à chaque étape, représentée par une bulle bleue.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5 :</b> Vec to Seq
</center>

Un exemple de ce type d'architecture est d'avoir comme entrée une image et comme sortie une séquence de mots représentant les descriptions de l'image d'entrée. Pour expliquer l'utilisation de la figure 6, chaque bulle bleue peut être un index dans un dictionnaire de mots. Par exemple, si la sortie est la phrase « *This is a yellow school bus* » (« C’est un bus scolaire jaune »). Vous obtenez d'abord l'index du mot « *This* », puis l'index du mot « *is* », et ainsi de suite. Certains des résultats de ce réseau sont présentés ci-dessous. Par exemple, dans la première colonne, la description concernant la dernière image est « *A herd of elephants walking across a dry grass field* » (« Un troupeau d'éléphants marchant à travers un champ d'herbe sèche »), ce qui est très bien précisé. Ensuite, dans la deuxième colonne, la première image donne « *Two dogs play in the grass* » (« Deux chiens jouent dans l'herbe »), alors qu'il s'agit en fait de trois chiens. Dans la dernière colonne, on trouve les exemples les plus erronés comme « *A yellow school bus parked in a parking lot* » (« Un bus scolaire jaune garé dans un parking »). En général, ces résultats montrent que ce réseau peut échouer de manière assez radicale et être parfois performant. C'est le cas d'un vecteur d'entrée, qui est la représentation d'une image, à une séquence de symboles, qui sont par exemple des caractères ou des mots composant les phrases. Ce type d'architecture est appelé un réseau autorégressif. Un réseau autorégressif est un réseau qui donne une sortie lorsque vous alimentez comme entrée la sortie précédente.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br><b>Figure 6 :</b> Exemple de vec2seq où on génère un texte à partir d’une image
</center>


Le second type est le « sequence to vector ». Ce réseau continue de donner une séquence de symboles et renvoie à la fin qu’une sortie finale. Une application de ce type peut être l'utilisation d’un réseau pour interpréter Python. Par exemple, les entrées sont ces lignes du programme Python.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7 :</b> Seq to Vec
</center>
<br>

<center><img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 8 :</b> Lignes d'entrée des codes Python
</center>

Le réseau est alors en mesure de produire la solution correcte de ce programme. Un autre programme plus compliqué :

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br><b>Figure 9 :</b> Lignes d'entrée des codes Python dans un cas plus compliqué
</center>

La sortie devrait être 12184. Ces deux exemples montrent que l'on peut entraîner un réseau de neurones à effectuer ce genre d'opération. Il suffit de donner une séquence de symboles et de faire en sorte que la sortie finale soit une valeur spécifique.



Le troisième cas est « sequence to vector to sequence », comme le montre la figure 10. Cette architecture était autrefois la méthode standard pour effectuer les traductions linguistiques. On commence par une séquence de symboles illustrée ici en rose. Ensuite, tout est condensé dans ce $h$ final qui représente un concept. Par exemple, nous pouvons avoir une phrase comme entrée et la comprimer temporairement dans un vecteur, qui représente le sens et le message à transmettre. Ensuite, après avoir obtenu ce sens dans n'importe quelle représentation, le réseau le déroule dans une autre langue. Par exemple, « *Today I'm very happy* » dans une séquence de mots en anglais peut être traduit en italien ou en chinois. En général, le réseau reçoit une sorte d'encodage en entrée et le transforme en une représentation compressée. Enfin, il effectue le décodage en donnant la même version compressée. Les *transformers* surpassent cette méthode dans les tâches de traduction. Ce type d'architecture était encore à la pointe de la technologie il y a environ deux ans (2018).

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10 :</b> Seq to Vec to Seq
</center>

Si l’on effectue une ACP sur l'espace latent, on obtient les mots regroupés par sémantique comme indiqué dans ce graphique :

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 11 :</b> Mots groupés par sémantique après une ACP
</center>

Si nous faisons un zoom sur la figure 11, nous pouvons voir par exemple que les mois de l’année sont regroupés au même endroit :

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 12 :</b> Zoom sur les groupes de mots
</center>

En se concentrant sur une autre région, on obtient des regroupements de phrases comme « il y a quelques jours », « les prochains mois », etc.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 13 :</b> Groupes de mots dans une autre région
</center>

Ces exemples montrent que les différents lieux ont des significations communes spécifiques.

La figure 14 montre comment l’entraînement de ce type de réseau permet de saisir certaines caractéristiques sémantiques. Par exemple, dans ce cas, il y a un vecteur reliant « *man* » à « *woman* » et un autre entre « *king* » et « *queen* ». Cela signifie que « *woman* »  - « *man* » = « *queen* » et « *king* ». On obtient la même distance dans cet espace d’enchâssement pour des cas comme homme-femme. 
Il est possible d’appliquer ce type de transformation linéaire pour passer d’une conjugaison à une autre ou d'un pays à une capitale.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 14 :</b> Caractéristiques sémantiques choisies pendant l’entraînement
</center>

Le quatrième et dernier cas est celui du « sequence to sequence ». Dans ce type de réseau, lorsque on commence à donner les entrées, le réseau commence à générer des sorties. Un exemple est le T9, qui était présent sur les téléphones Nokia. Il fournissait des suggestions de texte pendant que l’on écrivait. Un autre exemple est la génération de sous-titre depuis la voix.  

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 15 :</b> Séquence à Séquence
</center>

Un exemple intéressant est ce « RNN écrivain ». En commençant notre phrase par « Les anneaux de Saturne scintillent pendant que », le réseau suggère « deux hommes se regardent ». Ce réseau a été entraîné sur certains romans de science-fiction. Un autre exemple est présenté à la figure 16. La phrase saisie est celle en haut. Le réseau (GPT-2) complète le reste.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 16 :</b> Modèle d'autogénération de texte
</center>


<!--
## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)
-->

## [Rétropropagation à travers le temps](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)

<!--
### Model architecture

In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b> Back Propagation through time
</center>

Hidden representations are stated as

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

which corresponds to the stack representation of the input.

$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step.
-->

### Architecture

Pour entraîner un RNN, il faut utiliser la rétropropagation à travers le temps. L'architecture du RNN est donnée dans la figure ci-dessous. Le modèle de gauche utilise la représentation pliée tandis que le modèle de droite déplie la boucle en une ligne au fil du temps.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 17 :</b> Rétropropagation à travers le temps
</center>
<br>

Les représentations cachées sont indiquées comme suit :

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

La première équation indique une fonction non linéaire appliquée à une rotation d'une version empilée de l’entrée où la configuration précédente de la couche cachée est ajoutée. Au début, $h[0]$ est mis à 0. Pour simplifier l'équation, $W_h$ peut être écrit sous forme de deux matrices séparées, $\left[ W_{hx}\ W_{hh}\right]$, ainsi parfois la transformation peut être énoncée comme

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

qui correspond à la représentation empilée de l'entrée.

$y[t]$ est calculée à la rotation finale et nous pouvons alors utiliser la règle de la chaîne pour rétropropager l'erreur au pas de temps précédent.


<!--
### Batch-Ification in Language Modeling

When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Batch-Ification
</center>

If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Batch-Ification
</center>
-->

### Batch-ification en modélisation du langage

Lorsqu'il s'agit d'une séquence de symboles, nous pouvons regrouper le texte en différentes tailles. Par exemple, lorsqu'il s'agit des séquences illustrées dans la figure suivante, la batch-ification peut être appliquée lorsque le domaine temporel est préservé verticalement. Dans ce cas, la taille du batch est fixée à 4.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18 :</b> Batch-ification
</center>

Si la période $T$ de la rétropropagation à travers le temps est fixée à 3, la première entrée $x[1:T]$ et la sortie $y[1:T]$ pour RNN est déterminée comme

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

Lors de l'exécution du RNN sur le premier batch, nous introduisons d'abord $x[1] = [a [g [m] s]$ dans le réseau et forçons la sortie à être $y[1] = [b [h [n] t]$. La représentation cachée $h[1]$ est envoyée au prochain pas de temps pour aider le RNN à prédire $y[2]$ à partir de $x[2]$. Après avoir envoyé $h[T-1]$ à l'ensemble final de $x[T]$ et $y[T]$, nous coupons le processus de propagation des gradients pour $h[T]$ et $h[0]$ afin que les gradients ne se propagent pas à l'infini (`.detach()` en Pytorch). L'ensemble du processus est illustré dans la figure ci-dessous.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19 :</b> Batch-ification
</center>
<!--
## Vanishing and Exploding Gradient
-->

## Disparition et explosion du gradient

<!--
### Problem

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Vanishing Problem
</center>

The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.

In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.
-->

### Problème

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20 :</b> Problème de la disparition du gradient
</center>

La figure ci-dessus est une architecture RNN standard. Afin d'effectuer une rotation sur les étapes précédentes du RNN, nous utilisons des matrices qui peuvent être considérées comme des flèches horizontales dans la figure ci-dessus. Comme les matrices peuvent modifier la taille des sorties, si le déterminant que nous sélectionnons est supérieur à 1, le gradient gonflera au fil du temps et provoquera une explosion du gradient. Mathématiquement parlant, si la valeur propre que nous sélectionnons est petite par rapport à 0, le processus de propagation réduira les gradients et entraînera la disparition du gradient.

Dans les RNNs standards, les gradients se propagent à travers toutes les flèches possibles, ce qui leur donne une grande chance de disparaître ou d'exploser. Par exemple, le gradient au temps 1 est grand, ce qui est indiqué par la couleur vive. Lorsqu'il effectue une rotation, le gradient rétrécit beaucoup et au temps 3, il a disparu.

<!--
### Solution

An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Skip Connection
</center>

In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.

LSTM is one prevalent gated RNN and is introduced in detail in the following sections.
-->

### Solution

L'idéal pour éviter que les gradients n'explosent ou ne disparaissent est de sauter des connexions. Pour y parvenir, on peut utiliser des réseaux de multiplication.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 21 :</b> Sauter des connexions
</center>

Dans le cas ci-dessus, nous avons divisé le réseau initial en 4 réseaux. Prenons le premier réseau par exemple. Il prend une valeur de l'entrée au temps 1 et envoie la sortie au premier état intermédiaire de la couche cachée. L'état a 3 autres réseaux où le $\circ$ permet aux gradients de passer tandis que le $-$ bloque la propagation. Une telle technique est appelée réseau récurrent à portes.

Une LSTM est un RNN à portes et est présentée en détail dans les sections suivantes.


<!--
## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)
-->
## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)


<!--
### Model Architecture

Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b> LSTM Architecture
</center>

Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.

How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> LSTM Architecture - Output On
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b> LSTM Architecture - Output Off
</center>

Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b> Visualization of the Memory Cell
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b> LSTM Architecture - Reset Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 27:</b> LSTM Architecture - Keep Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Architecture - Write Memory
</center>
-->
### Architecture des LSTMs

Les équations expliquant une LSTM sont visibles dans la figure 22. La porte d'entrée est représentée par des cases jaunes, et sont une transformation affine. Cette transformation d'entrée multiplie $c[t]$, qui est notre porte candidate.


<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22 :</b> Architecture d’un réseau LSTM 
</center>


La « *Don't forget gate* » sur le graphique multiplie la valeur précédente de la cellule mémoire $c[t-1]$. La valeur totale de la cellule $c[t]$ est égale à la somme de la « *Don't forget gate*» et de l’« *Input gate* ». La représentation cachée finale est une multiplication par élément entre la porte de sortie $o[t]$ et la version tangente hyperbolique de la cellule $c[t]$, de sorte que les valeurs soient limitées. Enfin, la porte candidate $\tilde{c}[t]$ est simplement un réseau récurrent. Nous avons donc un $o[t]$ pour moduler la sortie, un $f[t]$ pour moduler la porte « *don't forget* », et un $i[t]$ pour moduler la porte d'entrée. Toutes ces interactions entre la mémoire et les portes sont des interactions multiplicatives. $i[t]$, $f[t]$ et $o[t]$ sont tous des sigmoïdes, allant de 0 à 1. Par conséquent, en multipliant par 0, vous obtenez une porte fermée. En multipliant par 1, vous avez une porte ouverte.

Comment éteindre la sortie ? Supposons que nous ayons une représentation interne violette $th$ et que nous mettions un 0 dans la porte de sortie. La sortie sera alors 0 multiplié par quelque chose ce qui donne 0. Si nous mettons un 1 dans la porte de sortie, nous obtenons la même valeur que la représentation en violet.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 23 :</b> Architecture LSTM - Sortie activée
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 24 :</b> Architecture LSTM - Sortie désactivée
</center>


De même, nous pouvons contrôler la mémoire. Par exemple, nous pouvons la réinitialiser en faisant en sorte que $f[t]$ et $i[t]$ soient des 0. Après multiplication et sommation, nous avons un 0 dans la mémoire. Sinon, nous pouvons conserver la mémoire, en mettant toujours à 0 la représentation interne $th$ mais en gardant un 1 dans $f[t]$. Ainsi, la somme obtient $c[t-1]$ et continue à l'envoyer. Enfin, nous pouvons écrire de manière à obtenir un 1 dans la porte d'entrée, la multiplication devient violette, puis mettre un 0 dans la porte « *don't forget* » pour qu'elle oublie réellement.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 25 :</b> Visualisation de la cellule mémoire
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 26 :</b> Architecture LSTM - Réinitialisation de la mémoire
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 27 :</b> Architecture STM - Conserver la mémoire
</center>
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 28 :</b> Architecture LSTM - Mémoire d'écriture
</center>

<!--
## Notebook Examples
-->

## Exemples


<!--
### Sequence Classification

The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

1). Dataset Exploration

The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 29:</b> Input Vector Example
</center>


2). Defining the Model and Training

Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:

 * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 30:</b> Simple RNN vs LSTM - 10 Epochs
</center>

With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> Simple RNN vs LSTM - 100 Epochs
</center>

If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualization of Hidden State Value
</center>

The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence.
-->

### Classification des séquences

Cette section se réfère au code du *notebook* Jupyter trouvable [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/08-seq_classification.ipynb) pour la version en anglais et [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/08-seq_classification.ipynb) pour la version en français.
L'objectif est de classer les séquences. Les éléments et les cibles sont représentés localement (vecteurs d'entrée avec un seul bit non nul). La séquence commence par un `B` (pour ***b**egins* en anglais), se termine par un `E` (pour ***e**nds* en anglais) qui le symbole déclencheur. Sinon la séquence est constituée de symboles choisis au hasard dans l'ensemble `{a, b, c, d}`, à l'exception de deux éléments aux positions $t_1$ et $t_2$ qui sont soit `X` soit `Y`. Dans le cas du `DifficultyLevel.HARD`, la longueur de la séquence est choisie au hasard entre 100 et 110, $t_1$ est choisi au hasard entre 10 et 20, et $t_2$ est choisi au hasard entre 50 et 60. Il y a 4 classes de séquence `Q`, `R`, `S`, et `U`, qui dépendent de l'ordre temporel de `X` et `Y`. Les règles sont les suivantes : `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.
<br>

**1) Exploration du jeu de données**

Le type retourné par un générateur de données est un *tuple* de longueur 2. Le premier élément du *tuple* est le batch de séquences de forme $(32, 9, 8)$. Ce sont les données qui vont être introduites dans le réseau. Il y a huit symboles différents dans chaque ligne (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Chaque ligne est un vecteur *one-hot*. Une séquence de lignes représente une séquence de symboles. La première ligne entièrement nulle est un rembourrage. Nous utilisons le rembourrage lorsque la longueur de la séquence est plus courte que la longueur maximale du batch.  Le deuxième élément du *tuple* est le batch correspondant aux labels des classes de forme $(32, 4)$, puisque nous avons 4 classes (`Q`, `R`, `S`, et `U`). La première séquence est : `BbXcXcbE`. Ensuite, son label décodé est $[1, 0, 0, 0]$, ce qui correspond à `Q`.


<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom : 15% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 29 :</b> Exemple de vecteur d'entrée
</center>
<br>


**2) Définition du modèle et entraînement**

Créons un simple réseau récurrent, une LSTM, et entraînons-les sur 10 époques. Dans la boucle d’entraînement, nous devons toujours regarder cinq étapes :

 * Effectuer la passe en avant du modèle
 * Calculer la perte
 * Remettre à zéro le cache des gradients
 * Rétropropager pour calculer la dérivée partielle de la perte en fonction des paramètres
 * Aller dans le sens inverse du gradient

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 30 :</b> RNN simple (en haut) vs LSTM (en bas)- 10 époques
</center>

Avec un niveau de difficulté facile, RNN obtient une précision de 50% tandis que LSTM obtient 100% après 10 époques. Mais la LSTM a quatre fois plus de poids que le RNN et possède deux couches cachées, ce qui ne permet pas une comparaison équitable. Après 100 époques, le RNN obtient également une précision de 100 %, ce qui prend plus de temps que la LSTM pour s'entraîner.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 31 :</b> RNN simple (en haut) vs LSTM (en bas) - 100 époques
</center>

Si nous augmentons la difficulté de l’entraînement (en utilisant des séquences plus longues), le RNN échouera alors que la LSTM continuera de fonctionner.
<br>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 32 :</b> Visualisation de la valeur cachée de l'État
</center>

La visualisation ci-dessus donne la valeur de l'état caché au fil du temps dans la LSTM. Nous passons les entrées dans une tangente hyperbolique, de sorte que si l'entrée est inférieure à $-2,5$, elle sera mise en correspondance avec $-1$ et si elle est supérieure à $2,5$, elle sera mise en correspondance avec $1$. Dans ce cas, nous pouvons donc voir la couche cachée spécifique choisie sur `X` (cinquième ligne de l'image), qui devient rouge jusqu'à ce que nous obtenions l'autre `X`. Ainsi, la cinquième unité cachée de la cellule est déclenchée par l'observation du `X` et se calme après avoir vu l'autre `X`. Cela nous permet de reconnaître la classe de la séquence.


<!--
### Signal Echoing

Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.

Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past.
-->

### L'écho du signal

Cette section se réfère au code du *notebook* Jupyter trouvable [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/09-echo_data.ipynb) pour la version en anglais et [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/09-echo_data.ipynb) pour la version en français.
L'écho du signal n étapes est un exemple de tâche synchronisée de plusieurs à plusieurs. Par exemple, la 1ère séquence d'entrée est `1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 ...`, et la 1ère séquence cible est `0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 1 ...`. Dans ce cas, la sortie se fait trois étapes plus tard. Nous avons donc besoin d'une mémoire de travail de courte durée pour conserver les informations. Alors que dans le modèle linguistique, cela revient à dire quelque chose qui n'a pas encore été dit.

Avant d'envoyer la séquence complète au réseau et de forcer la cible finale à être quelque chose, nous devons couper la longue séquence en petits morceaux. Tout en alimentant un nouveau morceau, nous devons garder une trace de l'état caché et l'envoyer comme entrée à l'état interne lors de l'ajout du nouveau morceau suivant. Dans les LSTMs, vous pouvez conserver la mémoire pendant une longue période tant que vous avez une capacité suffisante. Dans les RNNs, une fois que vous avez atteint une certaine longueur, la mémoire commence à oublier ce qui s'est passé dans le passé.
