---
lang: fr
lang-ref: ch.06-2
lecturer: Yann Le Cun
title: RNNs, GRUs, LSTMs, Attention, Seq2Seq, et Réseaux mémoire
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 Mar 2020
translation-date: 06 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.

As with what we saw with convolutional networks, network architecture is important.
-->

## [Architectures de l'apprentissage profond](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

En apprentissage profond, il existe différents modules pour réaliser différentes fonctions. L'expertise dans ce domaine implique la conception d'architectures pour réaliser des tâches particulières. L'apprentissage profond réduit une fonction complexe en un graphe de modules fonctionnels (éventuellement dynamiques), dont les fonctions sont finalisées par l'apprentissage.

Comme pour ce que nous avons vu avec les réseaux convolutifs, l'architecture de réseau est importante.


<!--
## Recurrent Networks

In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.

As shown in Figure 1, there are loops in Recurrent Neural Networks.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figure 1. Recurrent Neural Network with roll
</center>

 - $x(t)$ : input that varies across time
 - $\text{Enc}(x(t))$: encoder that generates a representation of input
 - $h(t)$: a representation of the input
 - $w$: trainable parameters
 - $z(t-1)$: previous hidden state, which is the output of the previous time step
 - $z(t)$: current hidden state
 - $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
 - $\text{Dec}(z(t))$: decoder that generates an output
-->

## Réseaux récurrents (RNNs)

Dans un ConvNet, le graphe ou les interconnexions entre les modules ne peuvent pas avoir de boucles. Il existe au moins un ordre partiel entre les modules, de sorte que les entrées sont disponibles lorsque nous calculons les sorties.

Comme le montre la figure 1, il existe des boucles dans les réseaux neuronaux récurrents.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
<b>Figure 1 :</b> Réseau de neurones récurrent enroulé
</center>

 - $x(t)$ : entrée qui varie dans le temps
 - $\text{Enc}(x(t))$ : encodeur qui génère une représentation de l'entrée
 - $h(t)$ : une représentation de l'entrée
 - $w$ : paramètres pouvant être entraînés
 - $z(t-1)$ : état caché précédent, qui est la sortie du pas de temps précédent
 - $z(t)$ : état caché actuel
 - $g$ : fonction qui peut être un réseau de neurones compliqué. L'une des entrées est $z(t-1)$ qui est la sortie du pas de temps précédent
 - $\text{Dec}(z(t))$ : décodeur qui génère une sortie


<!--
## Recurrent Networks: Unroll the loop

Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figure 2. Recurrent Networks with unrolled loop
</center>

In Figure 2, the input is $x_1, x_2, x_3$.

At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.

As there are no loops in this network, and we can implement backpropagation.

Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.

BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN.

Problems with RNNs:

1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work.

One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.

An example that has vanishing gradient problem:

The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program.
-->

## Réseaux récurrents dépliés

L'entrée est une séquence $x_1, x_2, \cdots, x_T$.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
<b>Figure 2 :</b> Réseaux récurrents dépliés
</center>

Dans la figure 2, l'entrée est $x_1, x_2, x_3$.

Au temps $t = 0$, l'entrée $x(0)$ est passée à l’encodeur qui génère la représentation $h(x(0)) = \text{Enc}(x(0))$. Puis il la passe à G pour générer l'état caché $z(0) = G(h_0, z', w)$. À $t = 0$, $z'$ dans $G$ peut être initialisé comme valant $0$ ou de manière aléatoire. $z(0)$ est passé au décodeur pour générer une sortie mais aussi au pas de temps suivant.

Comme il n'y a pas de boucles dans ce réseau nous pouvons mettre en œuvre la rétropropagation.

La figure 2 montre un réseau avec une caractéristique particulière : chaque bloc partage les mêmes poids. Trois encodeurs, décodeurs et fonctions G ont respectivement les mêmes poids sur différents pas de temps.

Malheureusement, la rétropropagation à travers le temps (BPTT pour *Backpropagation through time*) ne fonctionne pas aussi bien dans la forme naïve du RNN.

Il existe des problèmes avec les RNNs :
1. La disparition du gradient
   - Dans une longue séquence, les gradients sont multipliés par la matrice de poids (transposée) à chaque pas de temps. S'il y a de petites valeurs dans la matrice de poids, la norme des gradients devient de plus en plus petite de manière exponentielle.
2. L’explosion du gradient
   - Si nous avons une grande matrice de poids et que la non-linéarité dans la couche récurrente n'est pas saturée, les gradients vont exploser. Les poids divergeront à l'étape de mise à jour. Il se peut que nous devions utiliser un taux d'apprentissage minuscule pour que la descente des gradients fonctionne.

L'une des raisons d'utiliser les RNNs est l'avantage de pouvoir se souvenir des informations du passé. Cependant, cette mémoire peut être limitée.


Un exemple étant le problème de la disparition des gradients. Considérons une entrée constituée des caractères d'un programme en langage C. Le système doit indiquer s'il s'agit d'un programme syntaxiquement correct. Un programme syntaxiquement correct doit avoir un nombre valide d'accolades et de parenthèses. Ainsi, le réseau doit se souvenir du nombre de parenthèses et d'accolades ouvertes à vérifier et si elles sont bien toutes fermées. Le réseau doit stocker ces informations dans des états cachés comme un compteur.  Cependant, en raison de la disparition des gradients, il ne parviendra pas à conserver ces informations dans un long programme.


<!--
##  RNN Tricks

- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix.
-->

## Astuces pour les RNNs

- On peut couper les gradients pour éviter l’explosion, les écraser lorsqu'ils deviennent trop importants.
- On peut jouer sur l'initialisation (commencer à droite évite l'explosion/la disparition). Initialiser les matrices de poids pour préserver la norme dans une certaine mesure. Par exemple, l'initialisation orthogonale initialise la matrice de poids comme une matrice orthogonale aléatoire.

<!--
## Multiplicative Modules

In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.

Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor.

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$

where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.

Hypernetwork architecture: weights are computed by another network.
-->


## Modules multiplicatifs

Dans les modules multiplicatifs, plutôt que de calculer uniquement une somme pondérée d'entrées, nous calculons les produits des entrées et nous calculons ensuite la somme pondérée de celles-ci.

Supposons $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ et $z \in {R}^{d\times1}$. Ici, U est un tenseur.

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$


où $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.


La sortie du système est une somme pondérée classique d'entrées et de poids. Les poids eux-mêmes sont également des sommes pondérées de poids et d'entrées.

Architecture d'hyper-réseau : les poids sont calculés par un autre réseau.

<!--
## Attention

$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.

$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.

By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.

The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.

Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.

The weights are data independent because z is data independent.
-->

## L’attention

$x_1$ et $x_2$ sont des vecteurs, $w_1$ et $w_2$ sont des scalaires après softmax où $w_1 + w_2 = 1$, et $w_1$ et $w_2$ sont compris entre 0 et 1.

$w_1x_1 + w_2x_2$ est une somme pondérée de $x_1$ et $x_2$ pondérée par les coefficients $w_1$ et $w_2$.

En modifiant la taille relative de $w_1$ et $w_2$, nous pouvons faire passer la sortie de $w_1x_1 + w_2x_2$ à $x_1$ ou $x_2$ ou à certaines combinaisons linéaires de $x_1$ et $x_2$.

Les entrées peuvent avoir plusieurs vecteurs $x$ (plus de $x_1$ et $x_2$). Le système choisira une combinaison appropriée, dont le choix est déterminé par une autre variable $z$. Un mécanisme d'attention permet au réseau neuronal de concentrer son attention sur une ou plusieurs entrées particulières et d'ignorer les autres.

L'attention est de plus en plus importante dans les systèmes de traitement du langage naturel qui utilisent des architectures de type *transformers* ou d'autres types d'attention (point abordé à la [semaine 12]( https://atcold.github.io/pytorch-Deep-Learning/fr/week12)).

Les poids sont indépendants des données car $z$ est indépendant des données.

<!--
## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. Gated Recurrent Unit
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.

To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.

The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input.
-->

## [Les Gated Recurrent Units (GRUs)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

Comme mentionné ci-dessus, le RNN souffre de la disparition/explosion des gradients et ne se souvient pas des états pendant très longtemps. Les GRUS de [Cho et al. (2014)](https://arxiv.org/abs/1406.1078), sont une application de modules multiplicatifs qui tente de résoudre ces problèmes. C'est un exemple de réseau récurrent avec mémoire. La structure d'une unité GRU est présentée ci-dessous :

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226 ;"/><br>
<b>Figure 3 :</b> Gated Recurrent Unit
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

où $\odot$ indique une multiplication élément par élément (produit Hadamard), $x_t$ est le vecteur d'entrée, $h_t$ est le vecteur de sortie, $z_t$ est le vecteur de mise à jour, $r_t$ est le vecteur de réinitialisation, $\phi_h$ est une tanh, et $W$,$U$,$b$ sont des paramètres pouvant être appris.

Pour être précis, $z_t$ est un vecteur de porte qui détermine quelle part des informations passées doit être transmise dans la suite. Il applique une fonction sigmoïde à la somme de deux couches linéaires et un biais sur l'entrée $x_t$ et l'état précédent $h_{t-1}$.   
$z_t$ contient des coefficients entre 0 et 1 résultant de l'application de la fonction sigmoïde. L'état final de sortie $h_t$ est une combinaison convexe de $h_{t-1}$ et de $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. Si le coefficient est égal à 1, la sortie de l'unité actuelle n'est qu'une copie de l'état précédent et ignore l'entrée (ce qui est le comportement par défaut). S'il est inférieur à 1, il prend en compte de nouvelles informations provenant de l'entrée.

La porte de réinitialisation $r_t$ est utilisée pour décider quelle quantité d'informations passées doit être oubliée. Dans le nouveau contenu de la mémoire $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, si le coefficient dans $r_t$ est 0, alors il ne stocke aucune des informations du passé. Si en plus $z_t$ vaut 0, alors le système est complètement réinitialisé puisque $h_t$ ne regarderait que l'entrée.



<!--
## LSTM (Long Short-Term Memory)

GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figure 4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.

An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.

Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers.
-->


## Les LSTMs (*Long Short-Term Memory*)

Les GRUs sont en fait une version simplifiée des LSTMs qui ont été conçues beaucoup plus tôt par [Hochreiter et Schmidhuber (1997)](https://www.bioinf.jku.at/publications/older/2604.pdf). En constituant des cellules de mémoire pour préserver les informations passées, les LSTMs visent également à résoudre les problèmes de perte de mémoire à long terme des RNNs. La structure des LSTMs est présentée ci-dessous :

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
<b>Figure 4 :</b> Long Short-Term Memory
</center>


$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

où $\odot$ indique une multiplication élément par élément, $x_t\in\mathbb{R}^a$ est un vecteur d'entrée de l'unité LSTM, $f_t\in\mathbb{R}^h$ est le vecteur d'activation de la porte d'oubli, $i_t\in\mathbb{R}^h$ est le vecteur d'activation de la porte d'entrée/mise à jour, $o_t\in\mathbb{R}^h$ est le vecteur d'activation de la porte de sortie, $h_t\in\mathbb{R}^h$ est le vecteur d'état caché (également appelé sortie), $c_t\in\mathbb{R}^h$ est le vecteur d'état de la cellule.

Une unité LSTM utilise un état de cellule $c_t$ pour transmettre l'information. Elle régule la manière dont l'information est préservée ou retirée de l'état de la cellule par des structures appelées *gates* (portes). La porte d'oubli $f_t$ décide de la quantité d'informations que nous voulons conserver de l'état de cellule précédent $c_{t-1}$ en regardant l'entrée actuelle et l'état caché précédent. Elle produit un nombre entre 0 et 1 comme coefficient de $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ calcule un nouveau candidat pour mettre à jour l'état de la cellule. Comme la porte d'oubli, la porte d'entrée $i_t$ décide de la part de mise à jour à appliquer. Enfin, la sortie $h_t$ est basée sur l'état de la cellule $c_t$, mais passe par une $\tanh$ puis est filtrée par la porte de sortie $o_t$.

Bien que les LSTMs soient largement utilisés en traitement du langage naturel, leur popularité est en baisse. Par exemple, la reconnaissance vocale se dirige vers l'utilisation de ConvNets temporels et les autres utilisations se dirigent vers l'utilisation de *transformers*.


<!--
## Sequence to Sequence Model

The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center>

Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.

This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information.
-->

## Modèle de séquence à séquence

L'approche proposée par [Sutskever (2014)](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) est le premier système de traduction automatique neuronale à avoir des performances comparables aux approches classiques. Elle utilise une architecture d'encodeur-décodeur où l'encodeur et le décodeur sont tous deux des LSTMs multicouches.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
<b>Figure 5 :</b> Seq2Seq
</center>

Chaque cellule de la figure est une LSTM. Pour l’encodeur (la partie de gauche), le nombre de pas de temps est égal à la longueur de la phrase à traduire. À chaque pas, il y a une pile de LSTMs (quatre couches dans la publication) où l'état caché de la LSTM précédente est introduit dans le suivante. La dernière couche du dernier pas de temps produit un vecteur qui représente le sens de la phrase entière et est ensuite introduit dans une autre LSTM multicouche (le décodeur) produisant des mots dans la langue cible. Dans le décodeur, le texte est généré de manière séquentielle. Chaque étape produit un mot, qui est introduit dans l'étape de temps suivante.

Cette architecture n'est pas satisfaisante à deux égards. Premièrement, le sens entier de la phrase doit être comprimé dans l'état caché entre l’encodeur et le décodeur. Deuxièmement, les LSTMs ne préservent en fait pas l'information sur plus de 20 mots environ. La solution à ces problèmes est appelée un Bi-LSTM, qui fait fonctionner deux LSTMs dans des directions opposées. Dans un Bi-LSTM, la signification est encodée dans deux vecteurs, l'un généré par l'exécution de la LSTM de gauche à droite, et l'autre de droite à gauche.  Cela permet de doubler la longueur de la phrase sans perdre trop d'informations.

<!--
## Seq2seq with Attention

The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, i.e. the attention mechanism.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq with Attention
</center>

In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!

Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention.
-->

## Seq2seq avec attention

Le succès de l'approche ci-dessus a été de courte durée. Un autre document de [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473) a suggéré qu'au lieu d'avoir un gigantesque réseau qui réduit le sens de la phrase entière en un seul vecteur, il serait plus logique qu'à chaque étape, nous concentrions l'attention uniquement sur les endroits pertinents dans la langue originale ayant un sens équivalent. C’est ce qu’on appelle le mécanisme d'attention.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
<b>Figure 6 :</b> Seq2Seq avec attention
</center>

Avec l’attention, pour produire le mot courant à chaque pas de temps, nous devons d'abord décider sur quelles représentations cachées des mots de la phrase d'entrée nous devons nous concentrer. Essentiellement, un réseau apprendra à évaluer dans quelle mesure chaque entrée codée correspond à la sortie actuelle du décodeur. Ces scores sont normalisés par une fonction softmax, puis les coefficients sont utilisés pour calculer une somme pondérée des états cachés dans l’encodeur à différents pas de temps. En ajustant les pondérations, le système peut ajuster la zone des entrées sur laquelle se concentrer. La magie de ce mécanisme est que le réseau utilisé pour calculer les coefficients peut être entraîné par rétropropagation. Il n'est pas nécessaire de les construire à la main !

Les mécanismes d'attention ont complètement transformé la traduction automatique des neurones. Plus tard en 2017, [une équipe de Google](https://arxiv.org/abs/1706.03762) a proposé le *transformer*, où chaque couche et groupe de neurones met en œuvre l'attention.

<!--
## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.

The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.

For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. Memory Network
</center>

If one of the keys (e.g. $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.

This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.

What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.

This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.

The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks.
-->


## [Réseaux mémoire](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)
Les réseaux mémoire sont issus du travail de Facebook, lancé par [Antoine Bordes](https://arxiv.org/abs/1410.3916) en 2014 et [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) en 2015.
L'idée d'un réseau mémoire est qu'il y a deux parties importantes dans le cerveau. La première est le **cortex**, qui est l'endroit où est la mémoire à long terme. L’autre est l’**hippocampe** qui envoie des « fils » presque partout dans le cortex. On pense que l'hippocampe est utilisé pour la mémoire à court terme, se souvenant de choses pendant une période relativement courte. La théorie dominante est que lorsque l’on dort, il y a beaucoup d'informations transférées de l'hippocampe au cortex pour être consolidées dans la mémoire à long terme puisque l'hippocampe a une capacité limitée.
Pour un réseau mémoire, il y a une entrée au réseau, $x$, qui est comparé à des vecteurs $k_1, k_2, k_3, \cdots$ (« clés ») via un produit scalaire. En les faisant passer par une fonction softmax, on obtient un tableau de nombres dont la somme est égale à un. Il y a un ensemble d'autres vecteurs $v_1, v_2, v_3, \cdots$ (« valeurs »). On multiplie ces vecteurs par les scalaires provenant de la softmax et l’addition de ces vecteurs donne le résultat (mécanisme ressemblant fortement à l’attention).

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
<b>Figure 7 :</b> Réseau mémoire
</center>

Si l'une des clés (par exemple $k_i$) correspond exactement à $x$, alors le coefficient associé à cette clé sera très proche de $1$. La sortie du système sera donc grossièrement $v_i$.
Il s'agit de la **mémoire associative adressable**. La mémoire associative est que si l’entrée correspond à une clé, nous obtenons *cette* valeur. Et ce n'est qu'une version différentiable douce, ce qui permet de faire une rétropropagation et de changer les vecteurs par descente de gradient.

Les auteurs ont donné une histoire au système en lui donnant une séquence de phrases. Les phrases sont encodées en vecteurs en les faisant passer à travers un réseau neuronal qui n'a pas été pré-entraîné. Les phrases sont renvoyées à la mémoire. Lorsqu’on pose une question au système, elle est encodée puis est passée dans le réseau mémoire qui produit un $x$ et la mémoire renvoie une valeur.
Cette valeur (ainsi que l'état précédent du réseau) est utilisée pour accéder à nouveau à la mémoire. Après un apprentissage intensif, ce modèle apprend en fait à stocker des histoires et à répondre à des questions.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

Dans un réseau mémoire, il y a un réseau neuronal qui prend une entrée et produit ensuite une adresse pour la mémoire, renvoie la valeur au réseau, continue et produit finalement une sortie. Cela ressemble beaucoup à un ordinateur puisqu'il y a une unité centrale et une mémoire externe pour lire et écrire.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

<b>Figure 8 :</b> Comparaison entre le réseau mémoire et l'ordinateur
</center>
Des gens pensent qu'on peut en fait construire des **ordinateurs différentiables** à partir de cela. Un exemple est la [Neural Turing Machine](https://arxiv.org/abs/1410.5401) de DeepMind, qui a été rendue publique sur arXiv trois jours après la publication de l'article de Facebook.

L'idée est de comparer des entrées à des clés, de générer des coefficients et de produire des valeurs. C’est ce que fait basiquement un *transformer*.  Un *transformer* est essentiellement un réseau de neurones dans lequel chaque groupe de neurones est l'un de ces réseaux.
