---
lang: fr
lang-ref: ch.06-1
lecturer: Yann Le Cun
title: Applications des ConvNets
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
translation-date: 06 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network.
-->

## [Reconnaissance des codes postaux](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

Dans les cours des semaines précédentes, nous avons démontré qu'un réseau convolutif peut reconnaître des chiffres. Cependant, la question demeure de savoir comment le modèle choisit chaque chiffre et évite les perturbations avec les chiffres voisins. L'étape suivante consiste à détecter les objets qui ne se chevauchent pas et à utiliser l'approche générale de la suppression non maximale (NMS en anglais pour *Non-Maximum Suppression*). Etant donné l'hypothèse que l'entrée est une série de chiffres ne se chevauchants pas, la stratégie consiste à entraîner plusieurs réseaux convolutifs et à utiliser soit un vote majoritaire, soit à choisir les chiffres correspondant au score le plus élevé généré par le réseau convolutif.


<!--
### Recognition with CNN

Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center>

Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit.
-->

### Reconnaissance avec les ConvNets

Nous présentons ici la tâche consistant à reconnaître un code postal constitué de 5 chiffres ne se chevauchant pas. Le système n'a reçu aucune instruction sur la façon de séparer chaque chiffre, mais il sait qu'il doit prévoir 5 chiffres. Le système (figure 1) se compose de 4 ConvNets de taille différente, chacun produisant un ensemble de sorties. La sortie est représentée par des matrices. Les quatre matrices de sortie proviennent de modèles dont la dernière couche présente une largeur de noyau différente. Dans chaque sortie, il y a 10 lignes représentant les 10 chiffres de 0 à 9. Le plus grand carré blanc représente un score plus élevé dans cette catégorie. Dans ces quatre blocs de sortie, les tailles horizontales des dernières couches de noyaux sont respectivement de 5, 4, 3 et 2. La taille du noyau détermine la largeur de la fenêtre de visualisation du modèle en entrée, c'est pourquoi chaque modèle prédit des chiffres en fonction de différentes tailles de fenêtre. Le modèle effectue alors un vote majoritaire et sélectionne la catégorie qui correspond au score le plus élevé dans cette fenêtre. Pour extraire des informations utiles, il faut garder à l'esprit que toutes les combinaisons de caractères ne sont pas possibles. Ainsi une correction d'erreurs utilisant les restrictions d'entrée est utile afin de s'assurer que les sorties sont de véritables codes postaux.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 1 :</b> Multiples classifieurs pour la reconnaissance des codes postaux
</center>

Maintenant, il faut imposer l'ordre des caractères. L'astuce consiste à utiliser un algorithme de chemin le plus court. Comme on nous donne des plages de caractères possibles et le nombre total de chiffres à prévoir, nous pouvons aborder ce problème en calculant le coût minimum de production des chiffres et des transitions entre les chiffres. Le chemin doit être continu de la cellule inférieure gauche à la cellule supérieure droite du graphique. Il doit aussi contenir que des mouvements de gauche à droite et de bas en haut. De plus, si le même nombre est répété l'un à côté de l'autre, l'algorithme doit être capable de distinguer les nombres répétés au lieu de prédire un seul chiffre.

<!--
## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist.


- **False Positives**: There are many ways that a patch of an image is not a face. During the training stage, the model may not see all of them (i.e. a fully representative set.). Therefore, the model may suffer from a lot of false positives at test time.

- **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost.
-->


## [Détection des visages](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

Les ConvNets sont très performants dans les tâches de détection. La détection des visages ne fait pas exception. Pour effectuer la détection des visages, nous collectons un jeu de données d'images avec et sans visages sur lesquelles nous entraînons un ConvNet avec une taille de fenêtre de 30 $\times$ 30 pixels. Nous demandons alors au réseau de dire s'il y a un visage ou non. Une fois entraîné, nous appliquons le modèle à une nouvelle image et s'il y a des visages à peu près dans une fenêtre de 30 $\times$ 30 pixels, le ConvNet éclairera la sortie aux endroits correspondants. Cependant, deux problèmes se posent :


- les **faux positifs** : il y a de nombreuses façons pour qu'un morceau d'image ne soit pas un visage. Pendant la phase d’entraînement, le modèle peut ne pas toutes les voir (c'est-à-dire que notre jeu de données n’est pas pleinement représentatif). Par conséquent, le modèle peut souffrir d'un grand nombre de faux positifs au moment du test.

- la **taille de visage différente** : tous les visages ne sont pas de taille 30 $\times$ 30 pixels. Ainsi, les visages de tailles différentes peuvent ne pas être détectés. Une façon de traiter ce problème est de générer des versions multi-échelles de la même image. Le détecteur original détectera des visages d'environ 30 $\times$ 30 pixels. En appliquant une échelle sur l'image de facteur $\sqrt 2$, le modèle détectera les visages plus petits dans l'image originale puisque ce qui était de taille 30 $\times$ 30 est maintenant d’environ 20 $\times$ 20 pixels. Pour détecter des visages plus grands, nous pouvons réduire la taille de l'image. Ce procédé est peu coûteux car la moitié des dépenses provient du traitement de l'image originale non réduite. La somme des dépenses de tous les autres réseaux combinés est à peu près la même que le traitement de l'image originale non mise à l'échelle. La taille du réseau est le carré de la taille de l'image d'un côté, donc si vous réduisez l'image par $2$, le réseau que vous devez faire fonctionner est plus petit d'un facteur $2$. Le coût global est donc de $1+1/2+1/4+1/8+1/16+...$, ce qui donne 2. La réalisation d'un modèle multi-échelle ne fait donc que doubler le coût de calcul.

<!--
### A multi-scale face detection system

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center>

The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center>
-->

### Un système de détection des visages à plusieurs échelles

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom : 30% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 2 :</b> Système de détection des visages
</center>

Les cartes présentées (figure 3) indiquent les scores des détecteurs de visages. Ce détecteur de visage reconnaît les visages qui ont une taille de 20 $\times$ 20 pixels. En échelle fine (*Scale 3* dans la figure 3), il y a beaucoup de scores élevés mais pas définitifs. Lorsque le facteur d'échelle augmente (*Scale 6*), nous voyons davantage de régions blanches groupées. Ces régions blanches représentent les visages détectés. Nous appliquons alors une suppression non maximale pour obtenir l'emplacement final du visage.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom : 40% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 3 :</b> Scores du détecteur de visage pour différents facteurs d'échelle
</center>



<!--
### Non-maximum suppression

For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location.
-->

### Suppression non maximale

Pour chaque région ayant un score élevé, il y a probablement un visage en dessous. Si plusieurs visages sont détectés très près du premier, cela signifie qu'un seul doit être considéré comme correct et que les autres sont faux. Dans le cas d'une suppression non maximale, nous prenons la zone la plus importante des cases de délimitation qui se chevauchent et nous supprimons les autres. Le résultat est alors une seule boîte englobante à l'emplacement optimal.

<!--
### Negative mining

In the last section, we discussed how the model will run into a large number of false positives at test time as there are many ways for objects to appear similar to a face. No training set will include all the non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches that the model detects as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives.
-->

### *Negative mining*

Nous avons vu comment un modèle peut se heurter à un grand nombre de faux positifs au moment de la phase de test car plusieurs objets peuvent ressembler à un visage de diverses façons. Aucun jeu d’entraînement ne peut contenir tous les objets qui ne sont pas des visages et ceux qui ressemblent à des visages. Nous pouvons atténuer ce problème grâce au *negative mining* (pêche à l’exemple négatif). Avec cette technique, nous exécutons notre modèle sur des entrées dont on sait qu'elles ne contiennent pas de visages. Tous les patchs sans visages mais que le modèle a détecté comme étant des visages sont alors ajoutés dans notre jeu de données d’exemples négatifs. Ensuite, nous recyclons le détecteur en utilisant le jeu de données négatives. Nous pouvons répéter ce processus pour augmenter la robustesse de notre modèle contre les faux positifs.


<!--
## Semantic segmentation

Semantic segmentation is the task of assigning a category to every pixel in an input image.
-->

## Segmentation sémantique

La segmentation sémantique est la tâche qui consiste à attribuer une catégorie à chaque pixel d'une image d'entrée.


<!--
### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center>

There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle.


**Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it.

* **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center>

* **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales.

**Model Outputs** (Figure 4, Column 3)

The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network.

* **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed.

**System Performance**

When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away.

**Limitation**

Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly.
-->

### [ConvNets pour la vision adaptative à longue portée des robots](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

Dans ce projet, l'objectif était d'étiqueter des régions à partir d'images d'entrée afin qu'un robot puisse distinguer les routes des obstacles. Dans la figure, les régions vertes sont les zones sur lesquelles le robot peut rouler et les régions rouges sont les obstacles comme les herbes hautes. Pour entraîner le réseau à cette tâche, nous avons pris un patch de l'image et l'avons étiqueté manuellement comme étant traversable ou non (vert ou rouge). Nous entraînons ensuite le réseau convolutif sur les patchs en lui demandant de prédire la couleur du patch. Une fois que le système est suffisamment entraîné, il est appliqué à l'ensemble de l'image, en étiquetant toutes les régions de l'image en vert ou en rouge.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4 :</b> ConvNets pour la vision adaptative à longue portée des robots (programme LAGR de la DARPA 2005-2008)
</center>

Il y avait cinq catégories pour la prédiction : 1) super vert, 2) vert, 3) violet, 4) obstacle rouge, 5) super rouge : un obstacle certain.


**Étiquettes stéréo** (Figure 4, colonne 2) :    
Les images sont captées par les 4 caméras du robot, qui sont regroupées en 2 paires de vision stéréo. En utilisant les distances connues entre les caméras des paires stéréoscopiques, les positions de chaque pixel dans l'espace 3D sont ensuite estimées en mesurant les distances relatives entre les pixels qui apparaissent dans les deux caméras d'une paire stéréoscopique. C'est le même processus que notre cerveau utilise pour estimer la distance des objets que nous voyons. En utilisant les informations de position estimées, un plan est ajusté au sol et les pixels sont alors étiquetés en vert s'ils sont proches du sol et en rouge s'ils sont au-dessus.

**Limitations et motivation pour les ConvNets** :    
La vision stéréo ne fonctionne que jusqu'à 10 mètres et la conduite d'un robot nécessite une vision à longue distance. Un ConvNet est cependant capable de détecter des objets à des distances beaucoup plus grandes, s'il est correctement entraîné.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom : 100% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 5 :</b> Pyramide invariante au changement d’échelle d’images avec des distances normalisées
</center>

**Servie comme entrée modèle** :  
Un prétraitement important comprend la construction invariante au changement d’échelle d’images avec des distances normalisées (figure 5). Elle est similaire à ce que nous avons fait plus tôt dans ce cours lorsque nous avons essayé de détecter des visages de différentes tailles.

**Sorties du modèle** (figure 4, colonne 3) :  
Le modèle produit une étiquette pour chaque pixel de l'image **jusqu'à l'horizon**. Ce sont les sorties du classifieur d'un ConvNet multi-échelles.

**Comment le modèle devient adaptatif** :  
Les robots ont un accès continu aux étiquettes stéréo, ce qui permet au réseau de se réentraîner et de s'adapter au nouvel environnement dans lequel il se trouve. A noter que seule la dernière couche du réseau est entraînée à nouveau. Les couches précédentes sont entraînées en laboratoire et fixées.

**Performances du système** :  
En essayant d'obtenir une coordonnée GPS de l'autre côté d'une barrière, le robot a perçu cette barrière et a planifié un itinéraire qui l'a évitée. Ceci grâce à la détection d'objets situés à une distance de 50 à 100 m.

**Limitation** :
Dans les années 2000, les ressources de calcul étaient limitées. Le robot était capable de traiter environ une image par seconde, ce qui signifie qu'il ne pouvait pas détecter une personne qui se trouvait sur son chemin pendant une seconde entière avant de pouvoir réagir. La solution à cette limitation est un modèle d'odométrie visuelle à faible coût. Il n'est pas basé sur les réseaux de neurones, a une vision d’environ 2,5m mais réagit rapidement.




<!--
### Scene Parsing and Labelling

In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6).

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center>

Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.

However, sometimes this context size is not enough to determine the category for larger objects.

**The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.


Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$.

**Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking.
-->

### Analyse et étiquetage des scènes
Dans cette tâche, le modèle produit une catégorie d'objets (bâtiments, voitures, ciel, etc.) pour chaque pixel. L'architecture est également multi-échelle (figure 6).

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom : 30% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 6 :</b> ConvNet multi-échelles pour l'analyse des scènes
</center>

Si nous rétropropageons une sortie du ConvNet sur l'entrée, cela correspond à une fenêtre d'entrée de taille $46 \times 46$ sur l'image originale au bas de la pyramide de Laplace. Cela signifie que nous **utilisons le contexte des pixels $46 \times 46$ pour décider de la catégorie du pixel central**.
Cependant, parfois, la taille de ce contexte n'est pas suffisante pour déterminer la catégorie des objets plus grands.
**L'approche multi-échelles permet une vision plus large en fournissant des images supplémentaires redimensionnées comme entrées** :
1. Prendre la même image, la réduire séparément d'un facteur 2 et d'un facteur 4.
2. Ces deux images supplémentaires redimensionnées sont envoyées au **même ConvNet** (mêmes poids, mêmes noyaux) et nous obtenons deux autres ensembles de caractéristiques de niveau 2.
3. **Échantillonner** ces caractéristiques de façon à ce qu'elles aient la même taille que les caractéristiques de niveau 2 de l'image originale.
4. **Empiler** les trois ensembles de caractéristiques (suréchantillonnées) et envoyer-les à un classifieur.  

Maintenant, la plus grande taille effective du contenu, qui provient de l'image redimensionnée à 1/4, est de $184\times 184  \(46\times 4=184)$.

**Performance** : sans post-traitement et en fonctionnant image par image, le modèle fonctionne très rapidement, même sur du matériel standard. Il a une taille assez réduite de données d'entraînement (2 000 à 3 000), mais les résultats sont toujours très performants.
