---
lang: fr
lang-ref: ch.05-2
title: Techniques d’optimisation II
lecturer: Aaron Defazio
authors: Guido Petri, Haoyue Ping, Chinmay Singhal, Divya Juneja
date: 24 Feb 2020
translation-date: 05 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Adaptive methods](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

SGD with momentum is currently the state of the art optimization method for a lot of ML problems. But there are other methods, generally called Adaptive Methods, innovated over the years that are particularly useful for poorly conditioned problems (if SGD does not work).

In the SGD formulation, every single weight in network is updated using an equation with the same learning rate (global $\gamma$). Here, for adaptive methods, we *adapt a learning rate for each weight individually*. For this purpose, the information we get from gradients for each weight is used.

Networks that are often used in practice have different structure in different parts of them. For instance, early parts of CNN may be very shallow convolution layers on large images and later in the network we might have convolutions of large number of channels on small images. Both of these operations are very different so a learning rate which works well for the beginning of the network may not work well for the latter sections of the network. This means adaptive learning rates by layer could be useful.

Weights in the latter part of the network (4096 in figure 1 below) directly dictate the output and have a very strong effect on it. Hence, we need smaller learning rates for those. In contrast, earlier weights will have smaller individual effects on the output, especially when initialized randomly.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>Figure 1: </b>VGG16
</center>
-->

## [Méthodes adaptatives](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

La SGD avec *momentum* est actuellement la méthode d'optimisation de pointe pour de nombreux problèmes d’apprentissage machine. Mais il existe d'autres méthodes, généralement appelées méthodes adaptatives qui sont particulièrement utiles pour les problèmes mal conditionnés (si la SGD ne fonctionne pas).

Dans la formule de la SGD, chaque poids dans le réseau est mis à jour en utilisant une équation avec le même taux d'apprentissage global ($\gamma$). Ici, pour les méthodes adaptatives, nous adaptons un taux d'apprentissage pour chaque poids individuellement. À cette fin, nous utilisons les informations que nous obtenons des gradients pour chaque poids.

Les réseaux souvent utilisés en pratique ont une structure différente dans plusieurs parties d’eux. Par exemple, les premières parties d’un ConvNet peuvent être des couches de convolution très peu profondes sur de grandes images et plus loin dans le réseau, nous pouvons avoir des convolutions d'un grand nombre de canaux sur de petites images. Ces deux opérations sont très différentes, de sorte qu'un taux d'apprentissage qui fonctionne bien pour le début du réseau peut ne pas fonctionner correctement pour les dernières parties du réseau. Cela signifie qu'un taux d'apprentissage adaptatif par couche pourrait être utile.

Les poids dans la dernière partie du réseau (4096 dans la figure 1 ci-dessous) dictent directement la sortie et ont un effet très fort sur celle-ci. C'est pourquoi nous avons besoin de taux d'apprentissage plus faibles pour ces derniers. En revanche, les pondérations antérieures auront des effets individuels plus faibles sur la sortie, en particulier lorsqu'elles sont initialisées de manière aléatoire.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>Figure 1 : </b>VGG16
</center>


<!--
### RMSprop

The key idea of *Root Mean Square Propagation* is that the gradient is normalized by its root-mean-square.

In the equation below, squaring the gradient denotes that each element of the vector is squared individually.

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

where $\gamma$ is the global learning rate, $\epsilon$ is a value close to machine $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) -- in order to avoid division by zero errors, and $v_{t+1}$ is the 2nd moment estimate.

We update $v$ to estimate this noisy quantity via an *exponential moving average* (which is a standard way of maintaining an average of a quantity that may change over time). We need to put larger weights on the newer values as they provide more information. One way to do that is down-weight old values exponentially. The values in the $v$ calculation that are very old are down-weighted at each step by an $\alpha$ constant, which varies between 0 and 1. This dampens the old values until they are no longer an important part of the exponential moving average.

The original method keeps an exponential moving average of a non-central second moment, so we don't subtract the mean here. The *second moment* is used to normalize the gradient element-wise, which means that every element of the gradient is divided by the square root of the second moment estimate. If the expected value of gradient is small, this process is similar to dividing the gradient by the standard deviation.

Using a small $\epsilon$ in the denominator doesn't diverge because when $v$ is very small, the momentum is also very small.
-->


### RMSprop

L'idée clé de la *Root Mean Square Propagation* (propagation quadratique moyenne) est que le gradient est normalisé par sa racine carrée moyenne.

Dans l'équation ci-dessous, l'élévation au carré du gradient indique que chaque élément du vecteur est élevé au carré individuellement.

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &= w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

où $\gamma$ est le taux d'apprentissage global, $\epsilon$ est une valeur de l'ordre de $10^{-7}$ ou $10^{-8}$) afin d'éviter les erreurs dû à la division par zéro, et $v_{t+1}$ est l'estimation du 2ème moment.

Nous mettons à jour $v$ pour estimer cette quantité bruyante via une moyenne mobile exponentielle qui est une façon standard de maintenir une moyenne d'une quantité pouvant changer dans le temps. Nous devons accorder un poids plus important aux nouvelles valeurs car elles fournissent davantage d'informations. Une façon d'y parvenir est de pondérer les anciennes valeurs de manière exponentielle. Les valeurs très anciennes dans le calcul de $v$ sont pondérées à chaque étape par une constante $\alpha$, qui varie entre 0 et 1. Cela atténue les anciennes valeurs jusqu'à ce qu'elles ne soient plus une partie importante de la moyenne mobile exponentielle.

La méthode originale conserve une moyenne mobile exponentielle d'un second moment non central, donc nous ne soustrayons pas la moyenne ici. Le deuxième moment est utilisé pour normaliser par élément le gradient, ce qui signifie que chaque élément du gradient est divisé par la racine carrée de l'estimation du deuxième moment. Si la valeur attendue du gradient est faible, ce processus est similaire à la division du gradient par l'écart-type.

L'utilisation d'un petit $\epsilon$ au dénominateur ne diverge pas car lorsque $v$ est très petit, le *momentum* est également très petit.


<!--
### ADAM

ADAM, or *Adaptive Moment Estimation*, which is RMSprop plus momentum, is a more commonly used method. The momentum update is converted to an exponential moving average and we don't need to change the learning rate when we deal with $\beta$. Just as in RMSprop, we take an exponential moving average of the squared gradient here.

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

where $m_{t+1}$ is the momentum's exponential moving average.

Bias correction that is used to keep the moving average unbiased during early iterations is not shown here.
-->

### ADAM

ADAM ou *Adaptive Moment Estimation* est une méthode couramment utilisée consistant en un RMSprop avec *momentum*. La mise à jour du *momentum* est convertie en une moyenne mobile exponentielle et nous n'avons pas besoin de changer le taux d'apprentissage lorsque nous traitons avec $\beta$. Tout comme pour RMSprop, nous prenons ici une moyenne mobile exponentielle du gradient au carré.

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\\\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &= w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

où $m_{t+1}$ est la moyenne mobile exponentielle du *momentum*.

La correction de biais qui est utilisée pour maintenir la moyenne mobile non biaisée pendant les premières itérations n'est pas présentée ici.


<!--
### Practical side

When training neural networks, SGD often goes in the wrong direction in the beginning of the training process, whereas RMSprop hones in on the right direction. However, RMSprop suffers from noise just as regular SGD, so it bounces around the optimum significantly once it's close to a local minimizer. Just like when we add momentum to SGD, we get the same kind of improvement with ADAM. It is a good, not-noisy estimate of the solution, so **ADAM is generally recommended over RMSprop**.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figure 2: </b> SGD vs RMSprop vs ADAM
</center><br>

ADAM is necessary for training some of the networks for using language models. For optimizing neural networks, SGD with momentum or ADAM is generally preferred. However, ADAM's theory in papers is poorly understood and it also has several disadvantages:

* It can be shown on very simple test problems that the method does not converge.
* It is known to give generalization errors. If the neural network is trained to give zero loss on the data you trained it on, it will not give zero loss on other data points that it has never seen before. It is quite common, particularly on image problems, that we get worse generalization errors than when SGD is used. Factors could include that it finds the closest local minimum, or less noise in ADAM, or its structure, for instance.
* With ADAM we need to maintain 3 buffers, whereas SGD needs 2 buffers. This doesn't really matter unless we train a model on the order of several gigabytes in size, in which case it might not fit in memory.
* 2 momentum parameters need to be tuned instead of 1.
-->

### Côté pratique

Lors de l’entraînement des réseaux neuronaux, la SGD va souvent dans la mauvaise direction au début du processus, alors que RMSprop va dans la bonne direction. Cependant, RMSprop souffre du même bruit que la SGD normale, donc il rebondit autour de l'optimum de manière significative. Tout comme lorsque nous ajoutons un *momentum* à la SGD, nous obtenons le même type d'amélioration avec ADAM. C'est une bonne estimation, non bruyante, de la solution. Ainsi ADAM est généralement recommandé par rapport à RMSprop.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figure 2 : </b> SGD vs RMSprop vs ADAM
</center><br>

ADAM est nécessaire pour entraîner certains des modèles linguistiques. Pour optimiser les réseaux de neurones, il est généralement préférable d'utiliser la SGD avec *momentum* ou ADAM. Cependant, la théorie derrière ADAM est mal comprise et elle présente également plusieurs inconvénients :

* On peut montrer sur des problèmes de test très simples que la méthode ne converge pas.
* Elle est connue pour donner des erreurs de généralisation. Si le réseau est entraîné à donner une perte nulle sur les données sur lesquelles on l'a entraîné, il ne donnera pas une perte nulle sur d'autres données que le réseau n'aura jamais vus auparavant. Il est assez courant, en particulier pour les problèmes d'image, que nous obtenions des erreurs de généralisation pires que lorsque la SGD est utilisée. Cela peut venir du fait qu'il trouve le minimum local le plus proche, qu’il y ait moins de bruit dans ADAM, ou encore sa structure.
* Avec ADAM, nous devons garder en mémoire 3 paramètres, alors que la SGD en a besoin que de 2. Cela n'a pas vraiment d'importance, à moins que nous n’entrainions un modèle de l'ordre de plusieurs giga-octets, auquel cas il pourrait ne pas tenir en mémoire.
* 2 paramètres de *momentum* doivent être réglés au lieu d'un seul.


<!--
## [Normalization layers](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

Rather than improving the optimization algorithms, *normalization layers* improve the network structure itself. They are additional layers in between existing layers. The goal is to improve the optimization and generalization performance.

In neural networks, we typically alternate linear operations with non-linear operations. The non-linear operations are also known as activation functions, such as ReLU. We can place normalization layers before the linear layers, or after the activation functions. The most common practice is to put them between the linear layers and activation functions, as in the figure below.

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Before adding normalization                              |                (b) After adding normalization                |                    (c) An example in CNNs                    |

<center><b>Figure 3:</b> Typical positions of normalization layers.</center>

In figure 3(c), the convolution is the linear layer, followed by batch normalization, followed by ReLU.

Note that the normalization layers affect the data that flows through, but they don't change the power of the network in the sense that, with proper configuration of the weights, the unnormalized network can still give the same output as a normalized network.
-->

## [Couches de normalisation](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

Plutôt que d'améliorer les algorithmes d'optimisation, les couches de normalisation améliorent la structure même du réseau. Il s'agit de couches supplémentaires entre les couches existantes. L'objectif est d'améliorer les performances d'optimisation et de généralisation.

Dans les réseaux de neurones, nous alternons généralement des opérations linéaires et des opérations non linéaires. Les opérations non linéaires sont également connues sous le nom de fonctions d'activation, telles que la *ReLU*. Nous pouvons placer des couches de normalisation avant les couches linéaires ou après les fonctions d'activation. La pratique la plus courante consiste à les placer entre les couches linéaires et les fonctions d'activation comme dans la figure ci-dessous.

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Avant d'ajouter la normalisation | (b) Après avoir ajouté la normalisation | (c) Un exemple dans les ConvNets |

<center><b>Figure 3 :</b> Positions typiques des couches de normalisation</center>

Dans la figure 3(c), la convolution est la couche linéaire, suivie de la normalisation par batchs, puis d’une *ReLU*.

Notons que les couches de normalisation affectent les données qui passent, mais elles ne modifient pas la puissance du réseau dans le sens où, avec une configuration appropriée des poids, le réseau non normalisé peut toujours donner le même résultat qu'un réseau normalisé.

<!--
### Normalization operations

This is the generic notation for normalization:

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

where $x$ is the input vector, $y$ is the output vector, $\mu$ is the estimate of the mean of $x$, $\sigma$ is the estimate of the standard deviation (std) of $x$, $a$ is the learnable scaling factor, and $b$ is the learnable bias term.

Without the learnable parameters $a$ and $b$, the distribution of output vector $y$ will have fixed mean 0 and std 1. The scaling factor $a$ and bias term $b$ maintain the representation power of the network, i.e., the output values can still be over any particular range. Note that $a$ and $b$ do not reverse the normalization, because they are learnable parameters and are much more stable than $\mu$ and $\sigma$.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Normalization operations.
</center>

There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels:

- *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information.
- *Layer norm*: the normalization is applied within one image across all channels.
- *Instance norm*: the normalization is applied only over one image and one channel.
- *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD.

In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems.
-->

### Opérations de normalisation

Il s'agit de la notation générique pour la normalisation :

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

où $x$ est le vecteur d'entrée, $y$ est le vecteur de sortie, $\mu$ est l'estimation de la moyenne de $x$, $\sigma$ est l'estimation de l'écart-type de $x$, $a$ est le coefficient d’apprentissage et $b$ est le terme de biais apprenant.

Sans les paramètres d'apprentissage $a$ et $b$, la distribution du vecteur de sortie $y$ a une moyenne fixe de 0 et un écart-type de 1. Le coefficient $a$ et le terme de biais $b$ maintiennent le pouvoir de représentation du réseau, c'est-à-dire que les valeurs de sortie peuvent toujours être sur une plage particulière. A noter que $a$ et $b$ n'inversent pas la normalisation car ce sont des paramètres qui peuvent être appris et qui sont beaucoup plus stables que $\mu$ et $\sigma$.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4 :</b> Opérations de normalisation
</center>

Il existe plusieurs façons de normaliser le vecteur d'entrée, en fonction de la façon de sélectionner les échantillons à normaliser. La figure 4 énumère 4 approches de normalisation différentes, pour un mini-batch d'images $N$ de hauteur $H$ et de largeur $W$, avec des canaux $C$ :

- *Batch Normalisation* : la normalisation n'est appliquée que sur un canal de l'entrée. C'est la première approche proposée et la plus connue. Nous vous invitons à consulter [How to Train Your ResNet 7 : Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) (en anglais) pour plus d'informations.
- *Layer norm* : la normalisation est appliquée dans une image à travers tous les canaux.
- *Instance norm* : la normalisation est appliquée sur une seule image et un seul canal.
- *Group norm* : la normalisation est appliquée sur une seule image mais sur un certain nombre de canaux. Par exemple, le canal 0 à 9 est un groupe, puis le canal 10 à 19 est un autre groupe, et ainsi de suite. En pratique, la taille du groupe est presque toujours de 32. C'est l'approche recommandée par Aaron Defazio, puisqu'elle donne de bons résultats dans la pratique et qu'elle n'est pas en conflit avec la SGD.

Dans la pratique, la normalisation par batch et la normalisation par groupes fonctionnent bien pour les problèmes de vision par ordinateur. La normalisation par couches et la normalisation par instances sont quant à elles fortement utilisées pour les problèmes de langage.


<!--
### Why does normalization help?

Although normalization works well in practice, the reasons behind its effectiveness are still disputed. Originally, normalization is proposed to reduce "internal covariate shift", but some scholars proved it wrong in experiments. Nevertheless, normalization clearly has a combination of the following factors:

- Networks with normalization layers are easier to optimize, allowing for the use of larger learning rates. Normalization has an optimization effect that speeds up the training of neural networks.
- The mean/std estimates are noisy due to the randomness of the samples in batch. This extra "noise" results in better generalization in some cases. Normalization has a regularization effect.
- Normalization reduces sensitivity to weight initialization.

As a result, normalization lets you be more "careless" -- you can combine almost any neural network building blocks together and have a good chance of training it without having to consider how poorly conditioned it might be.
-->

### Pourquoi la normalisation est-elle utile ?

Bien que la normalisation fonctionne bien dans la pratique, les raisons de son efficacité sont encore contestées. À l'origine, la normalisation est proposée pour réduire le déplacement interne des covariables, mais certains chercheurs ont prouvé qu'elle était erronée lors d'expériences. Néanmoins, la normalisation présente clairement une combinaison des facteurs suivants :

- Les réseaux comportant des couches de normalisation sont plus faciles à optimiser, ce qui permet d'utiliser des taux d'apprentissage plus importants. La normalisation a un effet d'optimisation qui accélère l’entraînement des réseaux neuronaux.
- Les estimations de la moyenne/écart-type sont bruyantes en raison du caractère aléatoire des échantillons en batch. Ce « bruit » supplémentaire entraîne une meilleure généralisation dans certains cas. La normalisation a un effet de régularisation.
- La normalisation réduit la sensibilité à l'initialisation du poids.

Par conséquent, la normalisation permet d'être plus négligent au sens qu’il est possible de combiner presque tous les blocs constitutifs d'un réseau de neurones et avoir de bonnes chances de l'entraîner sans avoir à considérer son mauvais conditionnement.


<!--
### Practical considerations

It’s important that back-propagation is done through the calculation of the mean and std, as well as the application of the normalization: the network training will diverge otherwise. The back-propagation calculation is fairly difficult and error-prone, but PyTorch is able to automatically calculate it for us, which is very helpful. Two normalization layer classes in PyTorch are listed below:

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

Batch norm was the first method developed and is the most widely known. However, **Aaron Defazio recommends using group norm** instead. It’s more stable, theoretically simpler, and usually works better. Group size 32 is a good default.

Note that for batch norm and instance norm, the mean/std used are fixed after training, rather than re-computed every time the network is evaluated, because multiple training samples are needed to perform normalization. This is not necessary for group norm and layer norm, since their normalization is over only one training sample.
-->




### Considérations pratiques

Il est important que la rétropropagation se fasse par le calcul de la moyenne et des écarts-types ainsi que par l'application de la normalisation. Sinon l’entraînement du réseau diverge. Le calcul de la rétropropagation est assez difficile et sujet à erreur mais PyTorch est capable de le calculer automatiquement pour nous, ce qui est très utile. Deux classes de couches de normalisation dans PyTorch sont énumérées ci-dessous :

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

La normalisation par batchs a été la première méthode développée et est la plus connue. Cependant, **Aaron Defazio recommande d'utiliser plutôt la normalisation par groupes**. Elle est plus stable, théoriquement plus simple, et fonctionne généralement mieux. La taille de groupe 32 est une bonne valeur par défaut.

Notez que pour la normalisation par batchs et la normalisation par instances, la moyenne/l’écart-type utilisé est fixé après l’entraînement plutôt que recalculé à chaque fois que le réseau est évalué. En effet de multiples échantillons d’entraînement sont nécessaires pour effectuer la normalisation. Cela n'est pas nécessaire pour la normalisation par groupes et la normalisation par couches, puisque leur normalisation ne porte que sur un seul échantillon d'entraînement.


<!--
## [The Death of Optimization](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

Sometimes we can barge into a field we know nothing about and improve how they are currently implementing things. One such example is the use of deep neural networks in the field of Magnetic Resonance Imaging (MRI) to accelerate MRI image reconstruction.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5:</b> Sometimes it actually works!
</center>
-->

## [La mort de l'optimisation](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

Parfois, nous pouvons faire irruption dans un domaine que nous ne connaissons pas et améliorer la façon dont les choses sont mises en œuvre. L'utilisation de réseaux neuronaux profonds dans le domaine de l'imagerie par résonance magnétique (IRM) pour accélérer la reconstruction des images IRM en est un exemple.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5 :</b> Parfois, ça marche vraiment !
</center>



<!--
### MRI Reconstruction

In the traditional MRI reconstruction problem, raw data is taken from an MRI machine and an image is reconstructed from it using a simple pipeline/algorithm. MRI machines capture data in a 2-dimensional Fourier domain, one row or one column at a time (every few milliseconds). This raw input is composed of a frequency and a phase channel and the value represents the magnitude of a sine wave with that particular frequency and phase. Simply speaking, it can be thought of as a complex valued image, having a real and an imaginary channel. If we apply an inverse Fourier transform on this input, i.e add together all these sine waves weighted by their values, we can get the original anatomical image.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Fig. 6:</b> MRI reconstruction
</center><br>

A linear mapping currently exists to go from the Fourier domain to the image domain and it's very efficient, literally taking milliseconds, no matter how big the image is. But the question is, can we do it even faster?
-->


### Reconstruction d’une IRM

Dans le problème traditionnel de la reconstruction d’une IRM, les données brutes sont extraites d'un appareil IRM et une image est reconstruite à partir de celles-ci à l'aide d'un simple algorithme. Les machines d'IRM capturent les données dans un domaine de Fourier en deux dimensions, une ligne ou une colonne à la fois (toutes les quelques millisecondes). Cette entrée brute est composée d'un canal de fréquence et d'un canal de phase et la valeur représente l'amplitude d'une onde sinusoïdale avec cette fréquence et cette phase particulières. En termes simples, on peut considérer qu'il s'agit d'une image de valeur complexe, ayant un canal réel et un canal imaginaire. Si nous appliquons une transformée de Fourier inverse sur cette entrée, c'est-à-dire si nous additionnons toutes ces ondes sinusoïdales pondérées par leurs valeurs, nous pouvons obtenir l'image anatomique originale.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Figure 6 :</b> Reconstruction d’une IRM
</center><br>

Une association linéaire existe pour passer du domaine de Fourier au domaine de l'image. Elle est très efficace, prenant littéralement des millisecondes, quelle que soit la taille de l'image. Mais la question est de savoir si nous pouvons le faire encore plus rapidement.



<!--
### Accelerated MRI

The new problem that needs to be solved is accelerated MRI, where by acceleration we mean making the MRI reconstruction process much faster. We want to run the machines quicker and still be able to produce identical quality images. One way we can do this and the most successful way so far has been to not capture all the columns from the MRI scan. We can skip some columns randomly, though it's useful in practice to capture the middle columns, as they contain a lot of information across the image, but outside them we just capture randomly. The problem is that we can't use our linear mapping anymore to reconstruct the image. The rightmost image in Figure 7 shows the output of a linear mapping applied to the subsampled Fourier space. It's clear that this method doesn't give us very useful outputs, and that there's room to do something a little bit more intelligent.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Fig.:</b> Linear mapping on subsampled Fourier-space
</center><br>
-->

### IRM accélérée

Le nouveau problème qui doit être résolu est l’accélération de l'IRM, où nous entendons rendre le processus de reconstruction de l'IRM beaucoup plus rapide. Nous voulons faire fonctionner les machines plus rapidement tout en étant capables de produire des images de qualité identique. Une façon d'y parvenir, et la plus efficace jusqu'à présent, est de ne pas capturer toutes les colonnes de l'IRM. Nous pouvons sauter certaines colonnes de manière aléatoire, bien qu'il soit utile en pratique de capturer les colonnes du milieu car elles contiennent beaucoup d'informations sur l'ensemble de l'image. Le problème est que nous ne pouvons plus utiliser notre association linéaire pour reconstruire l'image. L'image la plus à droite de la figure 7 montre le résultat d'une association linéaire appliquée à l'espace de Fourier sous-échantillonné. Il est clair que cette méthode ne nous donne pas de résultats très utiles, et qu'il est possible de faire quelque chose d'un peu plus intelligent.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Figure 7 :</b> Association linéaire sur un espace de Fourier sous-échantillonné
</center><br>


<!--
### Compressed sensing

One of the biggest breakthroughs in theoretical mathematics for a long time was compressed sensing. A paper by <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> showed that theoretically, we can get a perfect reconstruction from the subsampled Fourier-domain image. In other words, when the signal we are trying to reconstruct is sparse or sparsely structured, then it is possible to perfectly reconstruct it from fewer measurements. But there are some practical requirements for this to work -- we don't need to sample randomly, rather we need to sample incoherently -- though in practice, people just end up sampling randomly. Additionally, it takes the same time to sample a full column or half a column, so in practice we also sample entire columns.

Another condition is that we need to have *sparsity* in our image, where by sparsity we mean a lot of zeros or black pixels in the image. The raw input can be represented sparsely if we do a wavelength decomposition, but even this decomposition gives us an approximately sparse and not an exactly sparse image. So, this approach gives us a pretty good but not perfect reconstruction, as we can see in Figure 8. However, if the input were very sparse in the wavelength domain, then we would definitely get a perfect image.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8: </b>Compressed sensing
</center><br>

Compressed sensing is based on the theory of optimization. The way we can get this reconstruction is by solving a mini-optimization problem which has an additional regularization term:

$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

where $M$ is the mask function that zeros out non-sampled entries, $\mathcal{F}$ is the Fourier transform, $y$ is the observed Fourier-domain data, $\lambda$ is the regularization penalty strength, and $V$ is the regularization function.

The optimization problem must be solved for each time step or each "slice" in an MRI scan, which often takes much longer than the scan itself. This gives us another reason to find something better.
-->


### Détection comprimée

L'une des plus grandes percées en mathématiques théoriques est la détection comprimée. Un article de <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> a montré que théoriquement, nous pouvons obtenir une reconstruction parfaite à partir de l'image du domaine de Fourier sous-échantillonnée. En d'autres termes, lorsque le signal que nous essayons de reconstruire est épars ou peu structuré, il est alors possible de le reconstruire parfaitement à partir de moins de mesures. Mais pour que cela fonctionne, il y a certaines conditions pratiques à remplir : nous n'avons pas besoin d'échantillonner au hasard mais plutôt d'échantillonner de manière incohérente, bien qu'en pratique, les gens finissent par échantillonner au hasard. En outre, il faut le même temps pour échantillonner une colonne entière ou une demi-colonne, donc en pratique nous échantillonnons aussi des colonnes entières.

Une autre condition est que nous devons avoir une éparsité dans notre image, où par éparsité nous voulons dire beaucoup de zéros ou de pixels noirs dans l'image. L'entrée brute peut être représentée de façon éparse si nous effectuons une décomposition en longueur d'onde. Cependant même cette décomposition nous donne une image approximativement éparse et pas exactement éparse. Ainsi, cette approche nous donne une reconstruction assez bonne mais pas parfaite, comme nous pouvons le voir sur la figure 8. Si l'entrée était très éparse dans le domaine des longueurs d'onde, alors nous obtiendrions certainement une image parfaite.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8 : </b> Détection comprimée
</center><br>

La détection comprimée est basée sur la théorie de l'optimisation. La façon dont nous pouvons obtenir cette reconstruction est de résoudre un mini-problème d’optimisation qui a un terme de régularisation supplémentaire :

$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

où $M$ est la fonction de masque qui met à zéro les entrées non échantillonnées, $\mathcal{F}$ est la transformée de Fourier, $y$ est la donnée observée du domaine de Fourier, $\lambda$ est la force de la pénalité de régularisation et $V$ est la fonction de régularisation.

Le problème d'optimisation doit être résolu pour chaque pas de temps ou chaque « tranche » d'un examen IRM, qui prend souvent beaucoup plus de temps que l'examen lui-même. Cela nous donne une raison supplémentaire de trouver quelque chose de mieux.


<!--
### Who needs optimization?

Instead of solving the little optimization problem at every time step, why not use a big neural network to produce the required solution directly? Our hope is that we can train a neural network with sufficient complexity that it essentially solves the optimization problem in one step and produces an output that is as good as the solution obtained from solving the optimization problem at each time step.

$$
\hat{x} = B(y)
$$

where $B$ is our deep learning model and $y$ is the observed Fourier-domain data.

15 years ago, this approach was difficult -- but nowadays this is a lot easier to implement. Figure 9 shows the result of a deep learning approach to this problem and we can see that the output is much better than the compressed sensing approach and looks very similar to the actual scan.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Deep Learning approach
</center><br>

The model used to generate this reconstruction uses an ADAM optimizer, group-norm normalization layers, and a U-Net based convolutional neural network. Such an approach is very close to practical applications and we will hopefully be seeing these accelerated MRI scans happening in clinical practice in a few years' time.
-->

### Qui a besoin d'une optimisation ?
Au lieu de résoudre le petit problème d'optimisation à chaque étape, pourquoi ne pas utiliser un grand réseau de neurones pour produire directement la solution requise ? Nous espérons pouvoir entraîner un réseau de neurones suffisamment complexe pour qu'il résolve le problème d'optimisation en une seule étape et produise un résultat aussi bon que la solution obtenue en résolvant le problème d'optimisation à chaque étape temporelle.

$$
\hat{x} = B(y)
$$

où $B$ est notre modèle d'apprentissage profond et $y$ est la donnée observée dans le domaine de Fourier.

Il y a 15 ans, cette approche était difficile mais est aujourd'hui beaucoup plus facile à mettre en œuvre. La figure 9 montre le résultat d'une approche d'apprentissage profond au problème. Nous pouvons voir qu’il est bien meilleur que l'approche de détection comprimée et ressemble beaucoup au scanner réel.
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9 : </b>Apprentissage profond
</center><br>
Le modèle utilisé pour générer cette reconstruction fait appel à un optimiseur ADAM, à des couches de normalisation par groupes et à un ConvNet basé sur U-Net.
