---
lang: fr
lang-ref: ch.05-1
title: Techniques d’optimisation I
lecturer: Aaron Defazio
authors: Vaibhav Gupta, Himani Shah, Gowri Addepalli, Lakshmi Addepalli
date: 24 Feb 2020
translation-date: 05 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

We start our study of Optimization Methods with the most basic and the worst (reasoning to follow) method of the lot, Gradient Descent.

**Problem:**

$$
\min_w f(w)
$$

**Iterative Solution:**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

where,
 - $w_{k+1}$ is the updated value after the $k$-th iteration,
 - $w_k$ is the initial value before the $k$-th iteration,
 - $\gamma_k$ is the step size,
 - $\nabla f(w_k)$ is the gradient of $f$.

The assumption here is that the function $f$ is continuous and differentiable. Our aim is to find the lowest point (valley) of the optimization function. However, the actual direction to this valley is not known. We can only look locally, and therefore the direction of the negative gradient is the best information that we have. Taking a small step in that direction can only take us closer to the minimum. Once we have taken the small step, we again compute the new gradient and again move a small amount in that direction, till we reach the valley. Therefore, essentially all that the gradient descent is doing is following the direction of steepest descent (negative gradient).

The $\gamma$ parameter in the iterative update equation is called the **step size**. Generally we don't know the value of the optimal step-size; so we have to try different values. Standard practice is to try a bunch of values on a log-scale and then use the best one. There are a few different scenarios that can occur. The image above depicts these scenarios for a 1D quadratic. If the learning rate is too low, then we would make steady progress towards the minimum. However, this might take more time than what is ideal. It is generally very difficult (or impossible) to get a step-size that would directly take us to the minimum. What we would ideally want is to have a step-size a little larger than the optimal. In practice, this gives the quickest convergence. However, if we use too large a learning rate, then the iterates get further and further away from the minima and we get divergence. In practice, we would want to use a learning rate that is just a little less than diverging.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Step sizes for 1D Quadratic
</center>
-->


## [Descente de gradient](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

Nous commençons notre étude des méthodes d'optimisation par la méthode la plus élémentaire et la pire du lot (raisonnement à suivre) : la méthode de la descente de gradient.

**Problème :**

$$
\min_w f(w)
$$

**Solution itérative :**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

où :
 - $w_{k+1}$ est la valeur mise à jour après la $k$-ème itération,
 - $w_k$ est la valeur initiale avant la $k$-ème itération,
 - $\gamma_k$ est la taille du pas,
 - $\nabla f(w_k)$ est le gradient de $f$.


On suppose ici que la fonction $f$ est continue et différenciable. Notre objectif est de trouver le point le plus bas (vallée) de la fonction d'optimisation. Cependant, la direction réelle de cette vallée n'est pas connue. Nous ne pouvons regarder que localement et de ce fait la direction du gradient négatif est la meilleure information dont nous disposons. Faire un petit pas dans cette direction ne peut que nous rapprocher du minimum. Une fois que nous avons fait ce petit pas, nous calculons à nouveau le gradient et nous nous déplaçons un peu dans cette direction. Nous répétons le processus jusqu'à ce que nous atteignions la vallée. Par conséquent, la descente de de gradient ne fait essentiellement que suivre la direction de la descente la plus raide (pente négative).

Le paramètre $\gamma$ dans l'équation de mise à jour itérative est appelé la **taille du pas**. En général, nous ne connaissons pas la valeur optimale de la taille de pas. Nous devons donc essayer différentes valeurs. La pratique courante consiste à essayer un ensemble de valeurs sur une échelle logarithmique et à sélectionner la meilleure. Quelques scénarios différents peuvent se produire. L'image ci-desosus représente ces scénarios pour une fonction quadratique 1D. Si le taux d'apprentissage est trop faible, alors nous progresserons régulièrement vers le minimum. Cependant, cela prend plus de temps que ce qui est idéal. Il est généralement très difficile (ou impossible) d'obtenir une échelle qui nous mène directement au minimum. L'idéal serait d'avoir une taille de pas un peu plus grande que l'optimale. En pratique, cela permet d'obtenir la convergence la plus rapide. Cependant, si nous utilisons un taux d'apprentissage trop élevé, les itérations s'éloignent de plus en plus des minima et nous obtenons une divergence. Dans la pratique, nous voudrions utiliser un taux d'apprentissage qui est juste un peu plus petit que celui qui va diverger.


<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figure 1 :</b> Différentes valeurs de pas appliquées à une fonction quadratique 1D
</center>


<!--
## [Stochastic gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)

In Stochastic Gradient Descent, we replace the actual gradient vector with a stochastic estimation of the gradient vector. Specifically for a neural network, the stochastic estimation means the gradient of the loss for a single data point (single instance).

Let $f_i$ denote the loss of the network for the $i$-th instance.

$$
f_i = l(x_i, y_i, w)
$$

The function that we eventually want to minimize is $f$, the total loss over all instances.

$$
f = \frac{1}{n}\sum_i^n f_i
$$

In SGD, we update the weights according to the gradient over $f_i$ (as opposed to the gradient over the total loss $f$).

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i chosen uniformly at random)}
\end{aligned}
$$

If $i$ is chosen randomly, then $f_i$ is a noisy but unbiased estimator of $f$, which is mathematically written as:

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

As a result of this, the expected $k$-th step of SGD is the same as the $k$-th step of full gradient descent:

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

Thus, any SGD update is the same as full-batch update in expectation. However, SGD is not just faster gradient descent with noise. Along with being faster, SGD can also get us better results than full-batch gradient descent. The noise in SGD can help us avoid the shallow local minima and find a better (deeper) minima. This phenomenon is called **annealing**.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figure 2:</b> Annealing with SGD
</center>

In summary, the advantages of Stochastic Gradient Descent are as follows:

 1. There is a lot of redundant information across instances. SGD prevents a lot of these redundant computations.
 2. At early stages, the noise is small as compared to the information in the gradient. Therefore a SGD step is *virtually as good as* a GD step.
 3. *Annealing* - The noise in SGD update can prevent convergence to a bad(shallow) local minima.
 4. Stochastic Gradient Descent is drastically cheaper to compute (as you don't go over all data points).
-->

## [Descente de gradient stochastique](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)


Dans le cas de la descente de gradient stochastique (SGD en anglais pour *Stochastic Gradient Descent*), nous remplaçons le vecteur de gradient réel par une estimation stochastique du vecteur de gradient. Pour un réseau de neurones, l'estimation stochastique signifie le gradient de la perte pour un seul point de données (une seule instance).

Soit $f_i$ qui désigne la perte du réseau pour la $i$-ième instance :

$$
f_i = l(x_i, y_i, w)
$$

La fonction que nous voulons minimiser est $f$, la perte totale dans tous les cas :

$$
f = \frac{1}{n}\sum_i^n f_i
$$

Dans la SGD, nous mettons à jour les poids en fonction du gradient sur $f_i$ (par opposition au gradient sur la perte totale $f$) avec :

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i choisi uniformément au hasard)}
\end{aligned}
$$

Si $i$ est choisi au hasard, alors $f_i$ est un estimateur bruyant mais non biaisé de $f$, qui s'écrit mathématiquement comme :

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

Par conséquent, le $k$-ème pas prévu de la SGD est le même que le $k$-ème pas de la descente de gradient complète :

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

Ainsi, toute mise à jour de la SGD est la même que la mise à jour attendue pour la GD à *batch* complet. Cependant, la SGD n'est pas seulement une descente plus rapide avec du bruit. En plus d'être plus rapide, la SGD peut également nous donner de meilleurs résultats que la descente de gradient avec *batch* complet. Le bruit dans la SGD peut nous aider à éviter les minima locaux peu profonds et à trouver de meilleurs minima (plus profonds). Ce phénomène est appelé ***annealing***.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figure 2 :</b> Annealing avec la SGD
</center>

En résumé, les avantages de la descente de gradient stochastique sont les suivants :

 1. Il y a beaucoup d'informations redondantes d'une instance à l'autre. La SGD empêche beaucoup de ces calculs redondants.
 2. Aux premiers stades, le bruit est faible par rapport aux informations dans le gradient. Par conséquent, une étape de SGD est *virtuellement aussi bonne* qu'une étape de GD.
 3. Le bruit dans la mise à jour de la SGD peut empêcher la convergence vers un mauvais minimum local (peu profond).
 4. La descente stochastique de gradient est considérablement moins coûteuse à calculer (car on ne passe pas en revue tous les points des données).


<!--
### Mini-batching

In mini-batching, we consider the loss over multiple randomly selected instances instead of calculating it over just one instance. This reduces the noise in the step update.

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

Often we are able to make better use of our hardware by using mini batches instead of a single instance. For example, GPUs are poorly utilized when we use single instance training. Distributed network training techniques split a large mini-batch between the machines of a cluster and then aggregate the resulting gradients. Facebook recently trained a network on ImageNet data within an hour, using distributed training.

It is important to note that Gradient Descent should never be used with full sized batches. In case you want to train on the full batch-size, use an optimization technique called LBFGS. PyTorch and SciPy both provide implementations of this technique.
-->

### Les mini-batchs

Avec les mini-batchs, nous considérons la perte sur plusieurs instances choisies au hasard au lieu de la calculer sur une seule instance. Cela permet de réduire le bruit lors de la mise à jour des étapes :

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

Souvent, nous pouvons faire un meilleur usage de nos capacités de calcul en utilisant des mini-batchs au lieu d'une seule instance. Par exemple, les GPUs sont mal utilisés lorsque nous effectuons un entraînement avec une seule instance. Les techniques d’entraînement en réseau distribué répartissent les mini-batchs entre les différentes machines et agrègent ensuite les gradients résultants. En utilisant une telle distribution, Facebook a récemment entraîné un réseau sur les données d'ImageNet en moins d'une heure ([Goyal et al. (2018)](https://arxiv.org/abs/1706.02677v2)).
Il est important de noter que la descente de gradient ne doit jamais être utilisée avec des batchs de taille entière. Si vous souhaitez faire cela utilisez plutôt une technique d'optimisation appelée LBFGS. PyTorch et SciPy fournissent tous deux des implémentations de cette technique.


<!--
## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

In Momentum, we have two iterates ($p$ and $w$) instead of just one. The updates are as follows:

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

$p$ is called the SGD momentum. At each update step we add the stochastic gradient to the old value of the momentum, after dampening it by a factor $\beta$ (value between 0 and 1). $p$ can be thought of as a running average of the gradients. Finally we move $w$ in the direction of the new momentum $p$.

Alternate Form: Stochastic Heavy Ball Method

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

This form is mathematically equivalent to the previous form. Here, the next step is a combination of previous step's direction ($w_k - w_{k-1}$) and the new negative gradient.
-->

## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

Avec *momentum*, nous avons deux itérations ($p$ et $w$) au lieu d'une seule. Les mises à jour sont les suivantes :

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

$p$ est appelé le *momentum* da la SGD. À chaque étape de la mise à jour, nous ajoutons le gradient stochastique à l'ancienne valeur du *momentum*, après l'avoir amorti d'un facteur $\beta$ (valeur comprise entre 0 et 1). On peut considérer $p$ comme une moyenne mobile des gradients. Enfin, nous déplaçons $w$ dans la direction du nouvel élan $p$.

Forme alternative : la « méthode stochastique de la boule lourde »

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

Cette formule est mathématiquement équivalent à la précédente. Ici, l'étape suivante est une combinaison de la direction de l'étape précédente ($w_k - w_{k-1}$) et du nouveau gradient négatif.


<!--
### Intuition

SGD Momentum is similar to the concept of momentum in physics. The optimization process resembles a heavy ball rolling down the hill. Momentum keeps the ball moving in the same direction that it is already moving in. Gradient can be thought of as a force pushing the ball in some other direction.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figure 3:</b> Effect of Momentum<br>
<b>Source:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

Rather than making dramatic changes in the direction of travel (as in the figure on the left), momentum makes modest changes. Momentum dampens the oscillations which are common when we use only SGD.

The $\beta$ parameter is called the Dampening Factor. $\beta$ has to be greater than zero, because if it is equal to zero, you are just doing gradient descent. It also has to be less than 1, otherwise everything will blow up. Smaller values of $\beta$ result in change in direction quicker. For larger values, it takes longer to make turns.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Effect of Beta on Convergence
</center>
-->

### Intuition

La SGD *momentum* est similaire au concept d'élan en physique. Le processus d'optimisation ressemble à une balle lourde qui dévale la colline. *Momentum* maintient la balle dans la même direction que celle dans laquelle elle se déplace déjà. Le gradient peut être considéré comme une force poussant la balle dans une autre direction.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figure 3 :</b> Effet du momentum -
<b>Source :</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

Plutôt que de changer radicalement la direction du déplacement (comme dans la figure de gauche), *momentum* apporte des changements modestes. Il amortit les oscillations qui sont courantes lorsque nous n'utilisons que la SGD.

Le paramètre $\beta$ est appelé le facteur d'amortissement. $\beta$ doit être supérieur à zéro, car s'il est égal à zéro, on ne fait qu’une descente de gradient. Il doit également être inférieur à 1, sinon tout explose. Des valeurs plus petites de $\beta$ entraînent un changement de direction plus rapide. Pour des valeurs plus élevées, il faut plus de temps pour « tourner ».

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom : 40% ; couleur de fond:#DCDCDC;"/><br>
<b>Figure 4 :</b> Effet du bêta sur la convergence
</center>


<!--
### Practical guidelines

Momentum must pretty much be always be used with stochastic gradient descent.
$\beta$ = 0.9 or 0.99 almost always works well.

The step size parameter usually needs to be decreased when the momentum parameter is increased to maintain convergence. If $\beta$ changes from 0.9 to 0.99, learning rate must be decreased by a factor of 10.
-->

### Informations pratiques

Le *momentum* doit presque toujours être utilisé avec une descente de gradient stochastique.
$\beta$ = 0,9 ou 0,99 fonctionne presque toujours bien.

La valeur du pas doit généralement être diminuée lorsque le paramètre de *momentum* est augmenté pour maintenir la convergence. Si $\beta$ passe de 0,9 à 0,99, le taux d'apprentissage doit être diminué d'un facteur 10.


<!--
### Why does momentum works?
-->

### Comment fonctionne le *momentum* ?
<!--
#### Acceleration

The following are the update rules for Nesterov's momentum.

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

With Nesterov's Momentum, you can get accelerated convergence if you choose the constants very carefully. But this applies only to convex problems and not to Neural Networks.

Many people say that normal momentum is also an accelerated method. But in reality, it is accelerated only for quadratics. Also, acceleration does not work well with SGD, as SGD has noise and acceleration does not work well with noise. Therefore, though some bit of acceleration is present with Momentum SGD, it alone is not a good explanation for the high performance of the technique.
-->

#### Accélération

Voici les règles de mise à jour pour le *momentum* de Nesterov :

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

Avec le *momentum* de Nesterov, il est possible d’obtenir une convergence accélérée en choisissant les constantes très soigneusement. Cependant cela ne s'applique qu'aux problèmes convexes et non aux réseaux de neurones.

Beaucoup de gens disent que le *momentum* normal est une méthode accélérée. Mais en réalité, elle n'est accélérée que pour les fonctions quadratiques. De plus, l'accélération ne fonctionne pas bien avec la SGD, car la SGD a du bruit or l'accélération ne fonctionne pas bien avec le bruit. Par conséquent, bien qu'une certaine accélération soit présente avec la SGD *momentum*, elle ne suffit pas à expliquer les performances élevées de la technique.



<!--
#### Noise smoothing

Probably a more practical and probable reason to why momentum works is Noise Smoothing.

Momentum averages gradients. It is a running average of gradients that we use for each step update.

Theoretically, for SGD to work we should take average over all step updates.

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

The great thing about SGD with momentum is that this averaging is no longer necessary. Momentum adds smoothing to the optimization process, which makes each update a good approximation to the solution. With SGD you would want to average a whole bunch of updates and then take a step in that direction.

Both Acceleration and Noise smoothing contribute to high performance of momentum.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> SGD vs Momentum
</center>

With SGD, we make good progress towards solution initially but when we reach bowl (bottom of the valley) we bounce around in this floor. If we adjust learning rate we will bounce around slower. With momentum we smooth out the steps, so that there is no bouncing around.
-->

#### Lissage du bruit
Une raison plus pratique et plus probable pour laquelle le *momentum* fonctionne est probablement le lissage du bruit.
Le *momentum* est une moyenne mobile des gradients que nous utilisons pour chaque étape de mise à jour.
Théoriquement, pour que la SGD fonctionne, nous devrions prendre la moyenne de toutes les mises à jour par étapes :
$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

L'avantage avec la SGD avec *momentum* est que cette moyenne n'est plus nécessaire. Le *momentum* ajoute un lissage au processus d'optimisation, ce qui fait de chaque mise à jour une bonne approximation de la solution. Avec la SGD, on voudrait faire la moyenne de tout un tas de mises à jour et ensuite faire un pas dans cette direction.
L'accélération et le lissage du bruit contribuent tous deux à la performance élevée du *momentum*.
<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom : 35% ; couleur de fond:#DCDCDC ;"/><br>
<b>Figure 5 :</b> SGD <i>vs</i> Momentum
</center>

Avec la SGD, nous progressons bien vers une solution au départ, mais lorsque nous atteignons le fond de la vallée, nous rebondissons. Si nous ajustons le taux d'apprentissage, nous rebondissons plus lentement. Avec le *momentum*, nous lissons les étapes, de sorte qu'il n'y a pas de rebondissement.
