---
lang: fr
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: Algebre linéaire et convolutions
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
translation-date: 04 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$:

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

For simplicity biases are ignored. The linear equation can be expanded as:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$.

To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$.

$\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as:

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$


The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can be understood by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.

Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.
-->





## [Rappel d'algèbre linéaire](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

Cette partie est une récapitulation de l'algèbre linéaire de base dans le contexte des réseaux de neurones. Nous commençons par une simple couche cachée $\boldsymbol{h}$ :

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

La sortie est une fonction non linéaire $f$ appliquée à un vecteur $z$. Ici, $z$ est la sortie d'une transformation affine $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ au vecteur d'entrée $\boldsymbol{x} \in\mathbb{R^n}$ :

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

Par souci de simplicité, les biais sont ignorés. L'équation linéaire peut être développée comme suit :

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

où $\boldsymbol{a}^{(i)}$ est la $i$-ième ligne de la matrice $\boldsymbol{A}$.

Pour comprendre la signification de cette transformation, analysons une composante de $\boldsymbol{z}$ telle que $a^{(1)}\boldsymbol{x}$.
Soit $n=2$, alors $\boldsymbol{a} = (a_1,a_2)$ et $\boldsymbol{x} = (x_1,x_2)$.

$\boldsymbol{a}$ et $\boldsymbol{x}$ peuvent être dessinés comme des vecteurs dans l'axe des coordonnées 2D. Maintenant, si l'angle entre $\boldsymbol{a}$ et $\hat{\boldsymbol{\imath}}$ est $\alpha$ et l'angle entre $\boldsymbol{x}$ et $\hat{\boldsymbol{\imath}}$ est $\xi$, alors avec les formules trigonométriques $a^\top\boldsymbol{x}$ (la traduction impose d'utiliser la notation anglo-saxonne de la transposée) peut être étendu comme :

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$


La sortie mesure l'alignement de l'entrée sur une ligne spécifique de la matrice $\boldsymbol{A}$. Cela peut être compris en observant l'angle entre les deux vecteurs, $\xi-\alpha$. Lorsque $\xi = \alpha$, les deux vecteurs sont parfaitement alignés et le maximum est atteint. Si $\xi - \alpha = \pi$, alors $\boldsymbol{a}^\top\boldsymbol{x}$ atteint son minimum et les deux vecteurs sont orientés dans des directions opposées. En substance, la transformation linéaire permet de voir la projection d'une entrée vers différentes orientations définies par $A$. Cette intuition est également extensible à des dimensions plus élevées.

Une autre façon de comprendre la transformation linéaire est de comprendre que $\boldsymbol{z}$ peut aussi être étendu comme :

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

La sortie est la somme pondérée des colonnes de la matrice $\boldsymbol{A}$. Par conséquent, le signal n'est rien d'autre qu'une composition de l'entrée.



<!--
## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: -

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$.

However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (e.g. 3 seconds) times the sampling rate (e.g. 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat".

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

The above formulation will be difficult to train. Fortunately there are ways to simplify the same.
-->

## [Extension de l'algèbre linéaire aux convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

Nous étendons maintenant l'algèbre linéaire aux convolutions en utilisant l'exemple de l'analyse des données audio. Nous commençons par représenter une couche entièrement connectée comme une forme de multiplication matricielle :

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

Dans cet exemple, la matrice de poids a une taille de $4 \times 3$, le vecteur d'entrée a une taille de $3 \times 1$ et le vecteur de sortie a une taille de $4 \times 1$.

Cependant, pour les données audio, les données sont beaucoup plus longues (pas de $3$ échantillons). Le nombre d'échantillons dans les données audio est égal à la durée de l'audio (par exemple 3 secondes) multipliée par le taux d'échantillonnage (par exemple $22,05$ kHz). Comme indiqué ci-dessous, le vecteur d'entrée $\boldsymbol{x}$ est assez long. En conséquence, la matrice de poids devient « grosse ».


$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

La formulation ci-dessus sera difficile à entraîner. Heureusement, il existe des moyens de la simplifier.




<!--
### Property: locality

Due to locality (i.e. we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$
-->

### Propriété : localité

En raison de la localité (c'est-à-dire que nous ne nous soucions pas des points de données qui sont éloignés) des données, $w_{1k}$ de la matrice de pondération ci-dessus, peut être rempli par des $0$ lorsque $k$ est relativement important. Par conséquent, la première ligne de la matrice devient un noyau de taille $3$. Désignons ce noyau de taille $3$ comme $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)} & a_2^{(1)} & a_3^{(1)} \end{bmatrix}$.

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


<!--
### Property: stationarity

Natural data signals have the property of stationarity (i.e. certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (i.e. stride is 1), resulting in the following:

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing.
-->

### Propriété : stationnarité

Les signaux de données naturelles ont la propriété d'être stationnaires (c'est-à-dire que certains modèles/motifs se répètent). Cela nous permet de réutiliser le noyau $\mathbf{a}^{(1)}$ que nous avons défini précédemment. Nous utilisons ce noyau en le plaçant chaque fois un pas plus loin (c'est-à-dire que le pas est de $1$), ce qui donne le résultat suivant :

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

La partie supérieure droite et la partie inférieure gauche de la matrice sont toutes deux remplies de $0$ grâce à la localité, ce qui entraîne une certaine éparsité. La réutilisation d'un certain noyau encore et encore est appelée partage du poids.


<!--
### Multiple layers of Toeplitz matrix

After these changes, the number of parameters we are left with is 3 (i.e. $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (i.e. $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same.

The previous matrix can be considered to be a layer (i.e. a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters.

Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well.

Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector looks like the following: -

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

The same matrix multiplication method can be applied on following convolutional layers with other kernels (e.g. $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results.
-->

### Plusieurs couches de la matrice de Toeplitz

Après ces changements, le nombre de paramètres qui nous reste est de $3$ (c'est-à-dire $a_1,a_2,a_3$). Par rapport à la matrice de pondération précédente, qui comportait $12$ paramètres (c'est-à-dire $w_{11},w_{12},\cdots,w_{43}$), le nombre actuel de paramètres est trop restrictif et nous souhaitons le développer.

La matrice précédente peut être considérée comme une couche (c'est-à-dire une couche convolutive) avec le noyau $\boldsymbol{a}^{(1)}$. Nous pouvons alors construire plusieurs couches avec différents noyaux $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc.

Chaque couche a une matrice contenant un seul noyau qui est répliqué plusieurs fois. Ce type de matrice est appelé matrice de Toeplitz. Dans chaque matrice de Toeplitz, chaque diagonale descendante de gauche à droite est constante. Les matrices de Toeplitz que nous utilisons ici sont également des matrices sparses.

Étant donné le premier noyau $\boldsymbol{a}^{(1)}$ et le vecteur d'entrée $\boldsymbol{x}$, la première entrée dans la sortie donnée par cette couche est, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Par conséquent, le vecteur de sortie entier ressemble à ce qui suit :

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

La même méthode de multiplication matricielle peut être appliquée sur les couches convolutionnelles suivantes avec d'autres noyaux (par exemple $\boldsymbol{a}^{(2)}$ et $\boldsymbol{a}^{(3)}$) pour obtenir des résultats similaires.


<!--
## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).

In this notebook, we are going to explore Convolution as a 'running scalar product'.

The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and its sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2).

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: A visualization of the audio signal. <br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Notes for the above audio signal.<br>
</center>


We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (e.g. first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Audio signal and its spectrogram.<br>
</center>

Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes in the input piece (i.e. the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolutions of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the convolutions prove the effectiveness of the convolutions in extracting the notes.


<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: First note of the melody.<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolution of four kernels.<br>
</center>
-->

## [Écouter les convolutions - Notebook Jupyter](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

La version anglaise du *notebook* Jupyter se trouve [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb), la version française est disponible [là](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/07-listening_to_kernels.ipynb).

Dans ce *notebook*, nous allons explorer la convolution en tant que produit scalaire courant.

La bibliothèque `librosa` nous permet de charger le clip audio $\boldsymbol{x}$ et son taux d'échantillonnage. Dans ce cas, il y a $70 641$ échantillons, le taux d'échantillonnage est de $22,05$kHz et la durée totale du clip est de $3.2$s. Le signal audio importé est ondulé (voir la figure 1) et nous pouvons deviner à quoi il ressemble d'après l'amplitude de l'axe $y$. Le signal audio $x(t)$ est en fait le son joué lorsque le système Windows s'éteint (voir la figure 2).

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Figure 1</b> : Une visualisation du signal audio. <br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Figure 2</b> : Notes pour le signal audio ci-dessus<br>
</center>


Nous devons séparer les notes de la forme de l'onde. Pour y parvenir, si nous utilisons la transformée de Fourier (FT), toutes les notes sortiront ensemble et il sera difficile de déterminer le moment et l'emplacement exacts de chaque hauteur. C'est pourquoi il est nécessaire d'utiliser une transformée de Fourier localisée (également appelée spectrogramme). Comme on peut l'observer dans le spectrogramme (voir la figure 3), les différentes hauteurs de son culminent à des fréquences différentes (par exemple, la première hauteur de son culmine à $1600$). En concaténant les quatre hauteurs à leurs fréquences, on obtient une version à hauteur du signal original.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Figure 3</b> : Signal audio et son spectrogramme<br>
</center>

La convolution du signal d'entrée avec toutes les hauteurs (toutes les touches du piano par exemple) peut aider à extraire toutes les notes du morceau d'entrée (c'est-à-dire les coups lorsque l'audio correspond aux noyaux spécifiques). Les spectrogrammes du signal original et du signal des hauteurs concaténées sont illustrés à la figure 4, tandis que les fréquences du signal original et des quatre hauteurs sont illustrées à la figure 5. Le tracé des convolutions des quatre noyaux avec le signal d'entrée (signal original) est illustré à la figure 6. La figure 6 ainsi que les clips audios des convolutions prouvent l'efficacité des convolutions dans l'extraction des notes.


<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Figure 4</b> : Spectrogramme du signal original (à gauche) et Spectrogramme de la concaténation des hauteurs (à droite)
</center><br><br>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Figure 5</b> : Première note de la mélodie<br>
</center><br><br>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Figure 6</b> : Convolution de quatre noyaux<br>
</center>

<!--
## Dimensionality of different datasets

The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$.
-->

## Dimensionnalité des différents jeux de données

La dernière partie est une courte digression sur les différentes représentations de la dimensionnalité et des exemples pour celle-ci. Nous considérons ici que l'ensemble d'entrée $X$ est constitué de fonctions de cartographie des domaines $\Omega$ aux canaux $c$.

<!--
### Examples

* Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), *etc.*
* Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*
* Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it is called Hamiltonian.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Fig. 7</b>: Different dimensions of different types of signals.<br>
</center>
-->

### Exemples
* Données audios : le domaine est 1D, signal discret indexé par le temps. Le nombre de canaux $c$ peut varier entre différentes possibilités : 1 (mono), 2 (stéréo), 5+1 (Dolby 5.1), etc.
* Données d'image : le domaine est 2D (pixels) et le $c$ peut varier entre 1 (niveaux de gris), 3 (couleur), 20 (hyperspectral), etc.
* Relativité spéciale : le domaine est $\mathbb{R^4} \times \mathbb{R^4}$ (espace-temps $\times$ quatre-momentum). Quand $c = 1$ on dit Hamiltonien.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Figure 7 :</b> Différentes dimensions de différents types de signaux<br>
</center>
