---
lang: fr
lang-ref: ch.03-3
title: Propriétés des signaux naturels
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
translation-date: 02 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language i.e. it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.

An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.

We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.

Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.

If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.
-->

## [Propriétés des signaux naturels](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

Tous les signaux peuvent être considérés comme des vecteurs. Par exemple, un signal audio est un signal 1D $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ où chaque valeur $x_t$ représente l'amplitude de la forme d'onde au moment $t$. Pour comprendre ce que dit une personne, votre cochlée convertit d'abord les vibrations de la pression atmosphérique en signaux, puis votre cerveau utilise un modèle linguistique pour convertir ce signal en une langue, c'est-à-dire qu'il doit choisir l'énoncé le plus probable compte tenu du signal. Pour la musique, le signal est stéréophonique et possède 2 canaux ou plus pour vous donner l'illusion que le son provient de plusieurs directions. Même s'il a 2 canaux, c'est toujours un signal 1D car le temps est la seule variable le long de laquelle le signal change.

Une image est un signal 2D parce que l'information est représentée dans l'espace. Notez que chaque point peut être un vecteur en soi. Cela signifie que si nous avons des canaux $d$ dans une image, chaque point spatial dans l'image est un vecteur de dimension $d$. Une image couleur a des plans RVB, ce qui signifie $d = 3$. Pour tout point $x_{i,j}$, cela correspond à l'intensité des couleurs rouge, verte et bleue respectivement.

Nous pouvons même représenter le langage avec la logique ci-dessus. Chaque mot correspond à un vecteur *one-hot* avec un à la position où il se trouve dans notre vocabulaire et des zéros partout ailleurs. Cela signifie que chaque mot est un vecteur de la taille du vocabulaire.

Les signaux de données naturels suivent ces propriétés :
1. **Stationnarité** : certains motifs se répètent tout au long d'un signal. Dans les signaux audio, nous observons le même type de motifs encore et encore dans le domaine temporel. Dans les images, cela signifie que nous pouvons nous attendre à ce que des motifs visuels similaires se répètent dans toute la dimensionnalité.
2. **Localité** : les points proches sont plus corrélés que les points éloignés. Pour un signal 1D, cela signifie que si nous observons un pic à un certain point $t_i$, nous nous attendons à ce que les points dans une petite fenêtre autour de $t_i$ aient des valeurs similaires à $t_i$ mais pour un point $t_j$ éloigné de $t_i$, $x_{t_i}$ a très peu d'influence sur $x_{t_j}$. Plus formellement, la convolution entre un signal et son homologue inversé a un pic lorsque le signal chevauche parfaitement sa version inversée. Une convolution entre deux signaux 1D (corrélation croisée) n'est rien d'autre que leur produit scalaire, qui est une mesure de la similarité ou de la proximité des deux vecteurs. Ainsi, l'information est contenue dans des portions et des parties spécifiques du signal. Pour les images, cela signifie que la corrélation entre deux points dans une image diminue à mesure que l'on s'éloigne des points. Si le pixel $x_{0,0}$ est bleu, la probabilité que le pixel suivant ($x_{1,0},x_{0,1}$) soit également bleu est assez élevée, mais lorsque l'on se déplace vers l'extrémité opposée de l'image ($x_{-1,-1}$), la valeur de ce pixel est indépendante de la valeur du pixel à $x_{0,0}$.
3. **Compositionnalité** : tout dans la nature est composé de parties qui sont composées de sous-parties et ainsi de suite. Par exemple, les caractères forment des chaînes de caractères qui forment des mots, qui forment ensuite des phrases. Les phrases peuvent être combinées pour former des documents. La compositionnalité permet d'expliquer le monde.

Si nos données sont stationnaires, locales et composées, nous pouvons les exploiter grâce à des réseaux qui utilisent l’ éparsité, le partage des poids et l'empilement des couches.



<!--
## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
-->

## [Exploitation des propriétés des signaux naturels pour construire l'invariance et l'équivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)

<!--
### Locality  $\Rightarrow$ sparsity

Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1:</b> Fully Connected Network</center>

If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> Before Applying Sparsity | <b>Figure 2(b):</b> After Applying Sparsity|
-->

### Localité $\Rightarrow$ éparsité

La figure 1 montre un réseau à 5 couches entièrement connecté. Chaque flèche représente un poids à multiplier par les entrées. Comme on peut le voir, ce réseau est très coûteux en termes de calcul.

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1 :</b> Réseau entièrement connecté</center>

Si nos données montrent une localité, chaque neurone doit être connecté à seulement quelques neurones locaux de la couche précédente. Ainsi, certaines connexions peuvent être supprimées comme le montre la figure 2. La figure 2(a) représente un réseau entièrement connecté. En profitant de la propriété de localisation de nos données, nous supprimons les connexions entre les neurones éloignés dans la figure 2(b). Bien que les neurones de la couche cachée (vert) de la figure 2(b) ne couvrent pas la totalité de l'entrée, l'architecture globale pourra prendre en compte tous les neurones d'entrée. Le champ réceptif (abrégé RF pour *receptive field* en anglais) est le nombre de neurones des couches précédentes, que chaque neurone d'une couche particulière peut voir ou a pris en compte. Par conséquent, le RF de la couche de sortie est de 3 pour la couche cachée, le RF de la couche cachée est de 3 pour la couche d'entrée, mais le RF de la couche de sortie est de 5 pour la couche d'entrée.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a) :</b> Avant l'application de l'éparsité | <b>Figure 2(b) :</b> Après l'application de l'éparsité| 


<!--
### Stationarity $\Rightarrow$ parameters sharing

If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> Before Applying Parameter Sharing | <b>Figure 3(b):</b> After Applying Parameter Sharing|

Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation

Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).

The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> Kernels on 1D Data | <b>Figure 4(b):</b> Data with Zero Padding|
-->


### Stationnarité $\Rightarrow$ partage des paramètres

Si nos données sont stationnaires, nous pourrions utiliser un petit ensemble de paramètres plusieurs fois dans l'architecture du réseau. Par exemple, dans notre réseau épars, figure 3(a), nous pouvons utiliser un ensemble de 3 paramètres partagés (jaune, orange et rouge). Le nombre de paramètres passera alors de 9 à 3 ! La nouvelle architecture pourrait même fonctionner mieux car nous disposons de plus de données pour l'entraînement de ces poids spécifiques.
Les poids après avoir appliqué l’éparsité et le partage des paramètres sont appelés noyau de convolution.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a) :</b> Avant l'application du partage des paramètres | <b>Figure 3(b) :</b> Après l'application du partage des paramètres

Voici quelques avantages de l'utilisation du partage des paramètres et de l’éparsité :

* Partage des paramètres :
  * une convergence plus rapide
  * une meilleure généralisation
  * ne concerne pas la taille de l'entrée
  * Indépendance du noyau $\Rightarrow$ forte parallélisation
* L'éparsité de connexion :
  * montant de calcul nécessaire réduit

La figure 4 montre un exemple de noyaux sur des données 1D, où la taille du noyau est : 2 (nombre de noyaux) $\times$ 7 (épaisseur de la couche précédente) $\times$ 3 (nombre de connexions/poids uniques).

Le choix de la taille du noyau est empirique. Une convolution 3 $\times$ 3 semble être la taille minimale pour les données spatiales. La convolution de taille 1 peut être utilisée pour obtenir une couche finale qui peut être appliquée à une image d'entrée plus grande. Une taille de noyau de nombre pair peut réduire la qualité des données, c'est pourquoi nous avons toujours une taille de noyau de nombre impair, généralement 3 ou 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a) :</b> Noyaux sur données 1D | <b>Figure 4(b) :</b> Données avec un rembourrage de 0|



<!--
### Padding

Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.
-->

### Rembourrage (*padding*)

Le rembourrage nuit généralement aux résultats finaux, mais il est pratique du point de vue programmatique. Nous utilisons généralement le zero-*padding* : `size = (taille du noyau - 1)/2`.


<!--
### Standard spatial CNN

A standard spatial CNN has the following properties:

* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection

Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.

In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5:</b> Information Representations Moving up the Hierarchy</center>
-->

### ConvNet spatial standard

Un ConvNet spatial standard a les propriétés suivantes :

* Couches multiples
  * Convolution
  * Non-linéarité (*ReLU* et *Leaky*)
  * *Pooling*
  * Normalisation par batch
* Connexion résiduelle

La normalisation par batch et les connexions résiduelles sont très utiles pour que le réseau s'entraîne bien.
Des parties d'un signal peuvent être perdues si trop de couches ont été empilées, de sorte que des connexions résiduelles garantissent un chemin de bas en haut et aussi un chemin pour les gradients venant de haut en bas.

Dans la figure 5, alors que l'image d'entrée contient principalement des informations spatiales en deux dimensions (à part les informations caractéristiques, qui sont la couleur de chaque pixel), la couche de sortie est épaisse. À mi-chemin, il y a un compromis entre les informations spatiales et les informations caractéristiques, et la représentation devient plus dense. Par conséquent, à mesure que nous montons dans la hiérarchie, nous obtenons une représentation plus dense car nous perdons les informations spatiales.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5 :</b> Représentations de l'information remontant la hiérarchie</center>


<!--
### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6:</b> Illustration of Pooling</center>

A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7:</b> Pooling results </center>
-->

### [*Pooling*](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6 :</b> Illustration du pooling</center>

Un opérateur spécifique, $L_p$-norm, est appliqué aux différentes régions (voir figure 6). Un tel opérateur ne donne qu'une seule valeur par région (1 valeur pour 4 pixels dans notre exemple). Nous itérons ensuite sur l'ensemble des données région par région, en prenant des mesures basées sur le pas. Si nous commençons avec $m \times n$ données avec $c$ canaux, nous finirons avec $\frac{m}{2} \times \frac{n}{2}$ données toujours avec des canaux $c$ (voir figure 7).
Le *pooling* n'est pas paramétré néanmoins, nous pouvons choisir différents types comme le *max-pooling*, l'*average-pooling*, etc. Le but principal du *pooling* est de réduire la quantité de données afin que nous puissions faire les calculs dans un délai raisonnable.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7 :</b> Résultats du pooling</center>




<!--
## CNN - Jupyter Notebook

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8:</b> Instances from the Original MNIST Dataset </center>

Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:

 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method

First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.

Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9:</b> Instances from Permuted MNIST Dataset</center>

The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->

## ConvNet - Notebook Jupyter
La version anglaise du *notebook* Jupyter se trouve [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). La version en français est disponible [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/06-convnet.ipynb). Pour faire fonctionner le *notebook*, assurez-vous d'avoir installé l'environnement `pDL` comme indiqué dans le fichier [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/docs/fr/README-FR.md).

Dans ce *notebook* Jupyter, nous entraînons un perceptron multicouche (réseau entièrement connecté) et un ConvNet pour la tâche de classification sur le jeu de données MNIST. Notez que les deux réseaux ont un nombre égal de paramètres (figure 8).
<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8 :</b> Instances provenant du jeu de données MNIST</center>

Avant l’entraînement, nous normalisons nos données afin que l'initialisation du réseau corresponde à notre distribution de données (**très important !**). De plus, on s'assure que les cinq opérations / étapes suivantes sont présentes dans notre entraînement :
 1. Alimentation du modèle en données
 2. Calcul de la perte
 3. Nettoyage le cache des gradients accumulés avec `zero_grad()`
 4. Calcul des gradients
 5. Exécution d'une étape dans l'optimiseur

Tout d'abord, nous entraînons les deux réseaux aux données normalisées du MNIST. La précision du réseau entièrement connecté s'est avérée être de 87 %, tandis que celle du réseau ConvNet s'est révélée être de 95 %. Avec le même nombre de paramètres, le ConvNet a réussi à entraîner beaucoup plus de filtres. Dans le réseau entièrement connecté, les filtres qui essaient d'obtenir des dépendances entre des choses qui sont plus éloignées et des choses qui sont proches, sont entraînés et sont complètement gaspillés. Au lieu de cela, dans le ConvNet, tous ces paramètres se concentrent sur la relation entre les pixels voisins.

Ensuite, nous effectuons une permutation aléatoire de tous les pixels dans toutes les images de notre jeu de données MNIST. Cela transforme notre figure 8 en figure 9. Nous entraînons ensuite les deux réseaux sur ce jeu de données modifié.
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9 :</b> Instances provenant du jeu de données MNIST permuté</center>

Les performances du réseau entièrement connecté sont restées pratiquement inchangées à 85 %, mais la précision du ConvNet est tombée à 83 %. En effet, après une permutation aléatoire, les images ne possèdent plus les trois propriétés de localité, de stationnarité et de composition, exploitables par un ConvNet.
