---
lang: fr
lang-ref: ch.03-2
lecturer: Yann Le Cun
title: Evolutions des ConvNets, Architectures, Details et Avantages de l’implementation  
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translation-date: 03 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)
-->
## [Proto-ConvNets et evolution vers les ConvNets modernes](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


<!--
### Proto-convolutional neural nets on small data sets

Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:

1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps)

The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit.
-->

### Proto-ConvNets sur de petits jeux de données

Inspiré par les travaux de Fukushima sur la modélisation du cortex visuel, l'utilisation de la hiérarchie cellulaire simple/complexe combinée à l’entraînement supervisé et à la rétropropagation a conduit à la création du premier ConvNet à l'université de Toronto en 1988-89 par Yann. Les expériences reposaient sur un petit jeux de données de 320 chiffres écrits à la souris d'ordinateur. Les performances des architectures suivantes ont été comparées :

1. Une seule couche entièrement connectée (FC pour *Fully connected* en anglais)
2. Deux couches FC
3. Couches connectées localement sans partage de poids
4. Réseau contraint avec poids partagés et connexions locales
5. Réseau contraint avec poids partagés et connexions locales 2  : c'est-à-dire davantage de cartes de caractéristiques (*feature maps* en anglais)

Les réseaux les plus performants (réseau contraint avec poids partagés) ont la plus forte généralisabilité et constituent la base des ConvNets modernes. La couche FC unique a quant à elle tendance à faire du surentraînement (*overfitting*).


<!--
### First "real" ConvNets at Bell Labs

After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:

* 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling
-->

### Les premiers « vrais» réseaux convolutifs au Bell Labs

Après avoir intégrés Bell Labs, Yann a orienté ses recherches vers l'utilisation de codes postaux manuscrits de la poste américaine pour entraîner un ConvNet plus important :

* 256 (16$\times$16) couche d'entrée
* 12 5$\times$5 noyaux avec un pas de 2 (pas de 2 pixels) : la couche suivante a une résolution plus faible
* **PAS** de *pooling* séparé


<!--
### Convolutional network architecture with pooling

The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> ConvNet Architecture
</center>

An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels

The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map:

1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map

To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional.

1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel)

See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).
-->


### ConvNets avec *pooling*

L'année suivante, certains changements ont été apportés : un *pooling* séparé a été introduit. Le *pooling* séparé est réalisé en faisant la moyenne des valeurs en entrée, en ajoutant un biais et en passant à une fonction non linéaire (fonction tangente hyperbolique). Le *pooling* de taille 2$\times$2 a été effectuée avec un pas de 2, réduisant ainsi les résolutions de moitié.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Figure 1 :</b> Architecture ConvNet
</center>

Voici un exemple de couche convolutionnelle unique :
1. On prend une entrée de taille *32$\times$32*
2. La couche de convolution passe un noyau de taille 5$\times$5 avec un pas de 1 sur l'image, ce qui donne une carte de caractéristiques de taille *28$\times$28*.
3. On passe la carte de caractéristiques à travers une fonction non linéaire : taille *28$\times$28*
4. On passe à la couche de *pooling* qui fait une moyenne sur une fenêtre de 2$\times$2 avec un pas de 2 : taille *14$\times$14*
5. On répète des étapes 1 à 4 pour 4 noyaux

Les combinaisons simples convolution/*pooling* de la première couche détectent généralement des caractéristiques simples, telles que des bords orientés. Après la première couche de convolution/*pooling*, l'objectif est de détecter des combinaisons d'éléments des couches précédentes. Pour ce faire, les étapes 2 à 4 sont répétées avec plusieurs noyaux sur les cartes de caractéristiques des couches précédentes et sont additionnées dans une nouvelle carte de caractéristiques :


1. Un nouveau noyau de 5$\times$5 est glissé sur toutes les cartes de caractéristiques des couches précédentes, et les résultats sont additionnés. Note : dans l'expérience de Yann en 1989, la connexion n'est pas complète pour les calculs. Les paramètres modernes imposent généralement des connexions complètes : taille *10$\times$10*
2. On passe la sortie de la convolution à une fonction non linéaire : taille *10$\times$10*
3. On répète les étapes 1 et 2 pour 16 noyaux
4. On passe le résultat à la couche de *pooling* qui moyenne sur une fenêtre de taille 2$\times$2 avec un pas de 2 : taille *5$\times$5* de chaque cartes de caractéristiques

Pour générer une sortie, on effectue la dernière couche de convolution, qui semble être une connexion complète mais qui est en fait convolutive.

1. La dernière couche de convolution fait glisser un noyau de 5$\times$5 sur toutes les cartes de caractéristiques, avec des résultats résumés : taille *1$\times$1*
2. On passe par une fonction non linéaire : taille *1$\times$1*
3. On génère la sortie unique pour une catégorie
4. On répète toutes les étapes précédentes pour chacune des 10 catégories (en parallèle)

Voir [cette animation](http://cs231n.github.io/convolutional-networks/) sur le site d'Andrej Karpathy sur la façon dont les convolutions modifient la forme des cartes de caractéristiques de la couche suivante. L'article complet est disponible [ici](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).



<!--
### Shift equivariance

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Shift Equivariance
</center>

As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. E.g. the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, i.e. making the representation more abstract and less sensitive to shifts and distortions.
-->

### Équivariance des changements

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Figure 2 :</b> Équivariance des changements
</center>

Comme le montre l'animation, la translation de l'image d'entrée entraîne la même translation des cartes de caractéristiques. Cependant, les changements dans les cartes de caractéristiques sont mis à l'échelle par des opérations de convolution/*pooling*. Par exemple, le *pooling* 2$\times$2 de pas 2 réduira le décalage de 1 pixel de la couche d'entrée à 0,5 pixel dans les cartes de caractéristiques suivantes. La résolution spatiale est alors échangée contre un plus grand nombre de types d'éléments, ce qui rend la représentation plus abstraite et moins sensible aux décalages et aux distorsions.

<!--
### Overall architecture breakdown

Generic CNN architecture can be broken down into several basic layer archetypes:

* **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods e.g. average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation

* **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections

* **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$

* **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$
-->

### Décomposition de l'architecture globale

L'architecture générique des ConvNets peut être décomposée en plusieurs archétypes de couches de base :

* **Normalisation**
  * Ajustement du blanchiment (facultatif)
  * Méthodes soustractives, par exemple : suppression moyenne, filtre passe-haut
  * Divise : normalisation des contrastes locaux, normalisation de la variance

* **Banques de filtres**
  * Augmenter la dimensionnalité
  * Projection sur une base surcomplète
  * Détections d'arêtes

* **Non-linéarités**
  * éparsification
  * *Rectified Linear Unit* (ReLU) : $\text{ReLU}(x) = \max(x, 0)$.

* ***Pooling***
  * Agrégation sur une carte de caractéristique
  * Max-*pooling* : $\text{MAX}= \text{Max}_i(X_i)$

  * Lp-Norm-*pooling*:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob-*pooling*:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$


<!--
## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)
-->
## [LeNet5 et reconnaissance des chiffres](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)


<!--
### Implementation of LeNet5 in PyTorch

LeNet5 consists of the following layers (1 being the top-most layer):

1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.

The input is a 32$\times$32 grey scale image (1 input channel).

LeNet5 can be implemented in PyTorch with the following code:

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes.

The same code can be expressed using `nn.Sequential`, but it is outdated.
-->

### Implémentation de LeNet5 dans PyTorch

LeNet5 se compose des couches suivantes (1 étant la couche la plus élevée) :

1. Log-softmax
2. Couche entièrement connectée de dimensions 500$\times$10
3. ReLu
4. Couche entièrement connectée de dimensions (4$\times$4$\times$50)$\times$500
5. Max-*pooling* de dimensions 2$\times$2, pas de 2.
6. ReLu
7. Convolution avec 20 canaux de sortie, noyau 5$\times$5, pas de 1.
8. Max-*pooling* de dimensions 2$\times$2, pas de 2.
9. ReLu
10. Convolution avec 20 canaux de sortie, noyau 5$\times$5, pas de 1.

L'entrée est une image en échelle de gris de 32$\times$32 (1 canal d'entrée).

LeNet5 peut être implémenté dans PyTorch avec le code suivant :

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

Bien que `fc1` et `fc2` soient des couches entièrement connectées, elles peuvent être considérées comme des couches convolutionnelles dont les noyaux couvrent l'ensemble de l'entrée. Les couches entièrement connectées sont utilisées à des fins d'efficacité.

Le même code peut être exprimé en utilisant `n.séquentiel` mais il est dépassé.

<!--
## Advantages of CNN

In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output.

Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image.
-->

## Avantages des ConvNets

Dans un réseau entièrement convolutif, il n'est pas nécessaire de préciser la taille de l'entrée. Cependant, la modification de la taille de l'entrée modifie la taille de la sortie.

Prenons l'exemple d'un système de reconnaissance de l'écriture cursive. Il n'est pas nécessaire de diviser l'image d'entrée en segments. Nous pouvons appliquer le ConvNet sur toute l'image : les noyaux couvriront tous les emplacements de l'image entière et enregistreront la même sortie, quel que soit l'emplacement du motif. Appliquer le ConvNet sur une image entière est beaucoup moins coûteux que de l'appliquer à plusieurs endroits séparément. Aucune segmentation préalable n'est nécessaire, ce qui est un soulagement car la tâche de segmenter une image est similaire à la reconnaissance d'une image.

<!--
### Example: MNIST

LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the center of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the center.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Sliding Window ConvNet
</center>


The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations.
-->

### Exemple : MNIST


LeNet5 est entraîné sur les images du jeu de données MNIST de taille 32$\times$32 pour classer les chiffres individuels au center de l'image. L'augmentation des données a été appliquée en déplaçant le chiffre autour, en changeant la taille du chiffre, en insérant des chiffres sur le côté. Il a également été entraîné avec une 11ème catégorie qui ne représentait rien de ce qui précède. Les images étiquetées par cette catégorie ont été générées soit en produisant des images vierges, soit en plaçant des chiffres sur le côté mais pas au center.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Figure 3 :</b> ConvNet à fenêtre coulissante
</center>


L'image ci-dessus montre qu'un réseau LeNet5 entraîné sur $32\times32$ peut être appliqué sur une image d'entrée $32\times64$ pour reconnaître le chiffre à plusieurs endroits.


<!--
## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)
-->

## [Problème de liaison des caractéristiques](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

<!--
### What is the feature binding problem?

Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object?
-->

### Quel est le problème de la liaison des caractéristiques ?

Les spécialistes des neurones visuels et de la vision par ordinateur ont le problème de définir l'objet comme un objet. Un objet est une collection de caractéristiques, mais comment lier toutes les caractéristiques pour former cet objet ?


<!--
### How to solve it?

We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet Addressing Feature Binding
</center>

The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, i.e. recognizing features in a hierarchical, compositional way.
-->

### Comment le résoudre ?

Nous pouvons résoudre ce problème de liaison de caractéristiques en utilisant un ConvNet très simple : seulement deux couches de convolutions avec des *poolings* plus deux autres couches entièrement connectées sans mécanisme spécifique pour cela, étant donné que nous avons suffisamment de non-linéarités et de données pour entraîner notre ConvNet.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Figure 4 :</b> Liaison des caractéristiques
</center>

L'animation ci-dessus montre la capacité du ConvNet à reconnaître différents chiffres en déplaçant un seul trait, ce qui démontre sa capacité à résoudre les problèmes de liaison des caractéristiques, c'est-à-dire à reconnaître les caractéristiques de manière hiérarchique et compositionnelle.

<!--
### Example: dynamic input length

We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding
</center>

Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2) <!--the overall subsampling we have shown from input to output is 4 (2x2). Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs.
-->

### Exemple : longueur d'entrée dynamique

Nous pouvons construire un ConvNet avec 2 couches de convolution avec un pas de 1 et deux couches de *pooling* avec un pas de 2 de telle sorte que le pas global soit de 4. Ainsi, si nous voulons obtenir une nouvelle sortie, nous devons décaler notre fenêtre d'entrée de 4. Pour être plus explicite, nous pouvons voir la figure ci-dessous (unités vertes). Tout d'abord, nous avons une entrée de taille 10, et nous effectuons une convolution de taille 3 pour obtenir 8 unités. Ensuite, nous effectuons un *pooling* de taille 2 pour obtenir 4 unités. De même, nous répétons la convolution et le *pooling* et nous obtenons finalement une sortie de taille 1.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Figure 5 :</b> Architecture ConvNet sur la liaison de la taille d'entrée des variantes
</center>

Supposons que nous ajoutions 4 unités à la couche d'entrée (unités roses au-dessus), de sorte que nous puissions obtenir 4 unités supplémentaires après la première couche de convolution, 2 unités supplémentaires après la première couche de *pooling*, 2 unités supplémentaires après la deuxième couche de convolution et 1 unité supplémentaire en sortie. Par conséquent, la taille de la fenêtre pour générer une nouvelle sortie est de 4 (deux fois 2 pas) <!-- le sous-échantillonnage global que nous avons montré de l'entrée à la sortie est de 4 (2x2)-->. De plus, cela démontre que si nous augmentons la taille de l'entrée, nous augmenterons la taille de chaque couche, ce qui prouve la capacité des ConvNets à gérer les entrées de longueur dynamique.


<!--
## What are CNN good for

CNNs are good for natural signals that come in the form of multidimensional arrays and have three major properties:
1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections.
2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image.
3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells.

Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition.
-->


## Pour quelles taches les ConvNets sont performants ?
Les ConvNets sont performants pour les signaux naturels qui se présentent sous la forme de réseaux multidimensionnels et ont trois propriétés principales :
1. **La localisation** : la première est qu'il existe une forte corrélation locale entre les valeurs. Si nous prenons deux pixels proches d'une image naturelle, il est très probable que ces pixels aient la même couleur. Plus deux pixels sont éloignés l'un de l'autre, plus la similitude entre eux diminue. Les corrélations locales peuvent nous aider à détecter des caractéristiques locales, ce que font les ConvNets. Si nous alimentons le ConvNet avec des pixels permutés, il ne sera pas performant dans la reconnaissance des images d'entrée, tandis que le FC ne sera pas affecté. La corrélation locale justifie les connexions locales.
2. **La stationnarité** : le deuxième caractère est que les caractéristiques sont essentielles et peuvent apparaître n'importe où sur l'image, justifiant les partages des poids et le *pooling*. De plus, les signaux statistiques sont uniformément distribués, ce qui signifie que nous devons répéter la détection des caractéristiques pour chaque emplacement sur l'image d'entrée.
3. **La compostionnalité** : le troisième caractère est que les images naturelles sont compositionnelles, ce qui signifie que les caractéristiques composent une image de manière hiératique. Cela justifie l'utilisation de plusieurs couches de neurones, ce qui correspond aussi étroitement aux recherches de Hubel et Weisel sur les cellules simples et complexes.

En outre, les ConvNets sont utilisés sur les vidéos, les images, les textes et la reconnaissance vocale.
