---
lang: fr
lang-ref: ch.03-1
lecturer: Yann Le Cun
title: Visualisation de la transformation des paramètres des réseaux neuronaux et concepts fondamentaux de la convolution
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
translation-date: 03 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Visualization of neural networks](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

In this section we will visualise the inner workings of a neural network.

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Network Structure</center>

Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualization of folding space</center>

The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<center>Fig. 3 Visualization of ReLU operator</center>

When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualization of Outputs</center>

This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.
-->

## [Visualisation des réseaux de neurones](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

Dans cette section, nous allons visualiser le fonctionnement interne d'un réseau de neurones.

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35% ;" /><br>
<b>Figure 1 :</b> Structure du réseau</center>

La figure 1 illustre la structure du réseau de neurones que nous souhaitons visualiser. En général, lorsque nous dessinons la structure d'un réseau de neurones, l'entrée apparaît en bas ou à gauche et la sortie apparaît en haut ou à droite. Dans la figure 1, les neurones roses représentent les entrées et les neurones bleus les sorties. Dans ce réseau, nous avons 4 couches cachées (en vert), ce qui signifie que nous avons 6 couches au total (4 couches cachées + 1 couche d'entrée + 1 couche de sortie). Dans ce cas, nous avons 2 neurones par couche cachée et donc la dimension de la matrice de poids ($W$) pour chaque couche est de 2 par 2. Cela s'explique par le fait que nous voulons transformer notre plan d'entrée en un autre plan que nous pouvons visualiser.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35% ;" /><br>
<b>Figure 2 :</b> Visualisation de l'espace de pliage</center>

La transformation de chaque couche est comme le pliage de notre plan dans certaines régions spécifiques, comme le montre la figure 2. Ce pliage est très abrupt, car toutes les transformations sont effectuées dans la couche 2D. Expérimentalement, nous constatons que si nous n'avons que 2 neurones dans chaque couche cachée, l'optimisation prend plus de temps. L'optimisation est plus facile si nous avons davantage de neurones dans les couches cachées. Cela nous laisse avec une question importante à considérer : pourquoi est-il plus difficile d’entraîner le réseau avec moins de neurones dans les couches cachées ?

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt= "Réseau" style= "zoom:45% ;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt= "Réseau" style= "zoom:45% ;" /> |
|(a)|(b)|

<center><b>Figure 3 :</b> Visualisation de l'opérateur ReLU</center>

Lorsque nous parcourons le réseau une couche cachée à la fois, nous constatons qu'avec chaque couche, nous effectuons une certaine transformation affine suivie de l'application de l'opération non linéaire *ReLU*, qui élimine toute valeur négative. Dans les figures 3(a) et (b), nous pouvons voir la visualisation de l'opérateur *ReLU*. L'opérateur *ReLU* nous aide à effectuer des transformations non linéaires. Après avoir effectué plusieurs étapes de transformation affine suivies par l'opérateur *ReLU*, nous sommes finalement en mesure de séparer les données de manière linéaire, comme le montre la figure 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30% ;" /><br>
<b>Figure 4 :</b> Visualisation des résultats</center>

Elle nous permet de comprendre pourquoi les couches cachées à deux neurones sont plus difficiles à entraîner. Notre réseau à 6 couches a un biais dans chaque couche cachée. Par conséquent, si l'un de ces biais déplace des points hors du quadrant supérieur droit, l'application de l'opérateur *ReLU* éliminera ces points. Ensuite, quelle que soit la façon dont les couches ultérieures transforment les données, les valeurs resteront nulles. Nous pouvons rendre un réseau de neurones plus facile à entraîner en rendant le réseau plus « gros » (c'est-à-dire en ajoutant plus de neurones dans les couches cachées) ou nous pouvons ajouter d'autres couches cachées, ou une combinaison des deux méthodes.


<!--
## [Parameter transformations](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 General Form of Parameter Transformations</center>
-->

## [Transformations des paramètres](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

La transformation générale des paramètres signifie que notre vecteur de paramètres $w$ est la sortie d'une fonction. Par cette transformation, nous pouvons faire correspondre l'espace de paramètres d'origine à un autre espace. Dans la figure 5, $w$ est en fait la sortie de $H$ avec le paramètre $u$. $G(x,w)$ est un réseau et $C(y,\bar y)$ est une fonction de coût. La formule de rétropropagation est également adaptée comme suit :

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

Ces formules sont appliquées sous forme de matrice. Les dimensions de $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ sont respectivement $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$ et $[N_w \times 1]$. Par conséquent, la dimension de notre formule de rétropropagation est cohérente.

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35% ;" /><br>
<b> Figure 5 :</b> Forme générale des transformations de paramètres</center>



<!--
### A simple parameter transformation: weight sharing

A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->


### Une transformation des paramètres simple : le partage des poids

Le partage des poids signifie que $H(u)$ reproduit simplement une composante de $u$ en plusieurs composantes de $w$. $H(u)$ est comme une branche **Y** pour copier $u_1$ en $w_1$, $w_2$. Cela peut être exprimé sous la forme :

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

Nous forçons les paramètres partagés à être égaux, de sorte que le gradient par rapport aux paramètres partagés sera additionné dans la rétropropagation. Par exemple, le gradient de la fonction de coût $C(y, \bar y)$ par rapport à $u_1$ sera la somme du gradient de la fonction de coût $C(y, \bar y)$ par rapport à $w_1$ et du gradient de la fonction de coût $C(y, \bar y)$ par rapport à $w_2$.


<!--
### Hypernetwork

A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 "Hypernetwork"</center>
-->

### Hyper-réseau

Un hyper-réseau est un réseau où les poids d'un réseau sont la sortie d'un autre réseau. La figure 6 montre le graphique de calcul d'un hyper-réseau. Ici, la fonction $H$ est un réseau avec le vecteur paramètre $u$ et l'entrée $x$. En conséquence, les poids de $G(x,w)$ sont configurés dynamiquement par le réseau $H(x,u)$. Bien que cette idée soit ancienne, elle reste très puissante.
<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35% ;" /><br>
  <b> Figure 6 :</b> Hyper-réseau</center>


<!--
### Motif detection in sequential data

Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function.

<center><img src="{{site.baseurl}}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35% ;" /><br>
Fig. 7 Motif Detection for Sequential Data</center>

In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->
### Détection de motifs dans les données séquentielles

La partage de poids peut être appliqué à la détection de motifs. La détection de motifs consiste à trouver certains motifs dans des données séquentielles comme des mots-clés dans la parole ou le texte. Une façon d'y parvenir, comme le montre la figure 7, consiste à utiliser une fenêtre coulissante sur les données, qui déplace la fonction de partage de poids pour détecter un motif particulier (c'est-à-dire un son particulier dans le signal vocal) et les sorties (c'est-à-dire une partition) passent dans une fonction maximale.

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30% ;" /><br>
  <b>Figure 7 :</b> Détection des motifs pour les données séquentielles</center>

Dans cet exemple, nous avons cinq de ces fonctions. Cette solution nous permet d'additionner cinq gradients et de rétropropager l'erreur pour mettre à jour le paramètre $w$. En implémentant cela dans PyTorch, nous voulons empêcher l'accumulation implicite de ces gradients, donc nous devons utiliser `zero_grad()` pour initialiser le gradient.

<!--
### Motif detection in images

The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 Motif Detection for Images</center>

It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Shift Invariance</center>

This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
-->

### Détection de motifs dans les images

L'autre application utile est la détection de motifs dans les images. Nous faisons généralement glisser nos patrons sur les images pour détecter les formes indépendamment de leur position et de leur distorsion. Un exemple simple consiste à distinguer un « C » d'un « D », comme le montre la figure 8. La différence entre « C » et « D » est que « C » a deux extrémités et « D » a deux coins. Nous pouvons donc concevoir des patrons d'extrémité et des patrons d'angle. Si la forme est similaire aux patrons, les sorties seront limitées. Nous pouvons alors distinguer les lettres de ces sorties en les additionnant. Dans la figure 8, le réseau détecte deux points d'extrémité et zéro coin, donc il active « C ».

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35% ;" /><br>
<b>Figure 8 :</b> Détection de motifs pour les images</center>

Il est également important que notre appariement de pochoirs (*template matching* en anglais) soit invariable par décalage : lorsque nous décalons l'entrée, la sortie (c'est-à-dire la lettre détectée) ne doit pas changer. Ce problème peut être résolu par une transformation de type partage de poids. Comme le montre la figure 9, lorsque nous changeons l'emplacement de « D », nous pouvons toujours détecter les motifs de coin même s'ils sont décalés. Lorsque nous additionnons les motifs, cela active la détection de « D ».

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35% ;" /><br>
<b>Figure 9 :</b> Invariance aux décalages</center>

Cette méthode artisanale d'utilisation de détecteurs locaux et de sommation pour la reconnaissance des chiffres a été utilisée pendant de nombreuses années. Mais elle nous pose le problème suivant : comment pouvons-nous concevoir ces pochoirs automatiquement ?  
Pouvons-nous utiliser des réseaux de neurones pour apprendre ces pochoirs ? Pour cela nous allons introduire le concept de **convolutions**, c'est-à-dire l'opération que nous utilisons pour faire correspondre les images avec les pochoirs.

<!--
## Discrete convolution
-->
## Convolution discrète


<!--
### Convolution

The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:

$$y_i = \sum_j w_j x_{i-j}$$

In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.
-->

### Convolution

La définition mathématique précise d'une convolution dans le cas unidimensionnel entre l'entrée $x$ et $w$ est :

$$y_i = \sum_j w_j x_{i-j}$$

En d'autres termes, la $i$-ème sortie est calculée comme le produit scalaire entre les $w$ **inversés** et une fenêtre de même taille en $x$. Pour calculer la sortie complète, on commence avec la fenêtre au début puis on décale cette fenêtre d'une entrée à chaque fois. On répète le procédé jusqu'à ce que $x$ soit épuisé.



<!--
### Cross-correlation

In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:

$$y_i = \sum_j w_j x_{i+j}$$

Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.

Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.
-->


### Corrélation croisée

En pratique, la convention adoptée dans les *frameworks* d'apprentissage profond comme PyTorch est légèrement différente. La convolution dans PyTorch est mise en œuvre lorsque $w$ est **non inversé** :

$$y_i = \sum_j w_j x_{i+j}$$

Les mathématiciens appellent cette formulation « corrélation croisée ». Dans notre contexte, cette différence n'est qu'une différence de convention. En pratique, la corrélation croisée et la convolution peuvent être interchangeables si l'on lit les poids stockés en mémoire en avant ou en arrière.

Il est important d'être conscient de cette différence, par exemple, lorsqu'on veut utiliser certaines propriétés mathématiques de la convolution/corrélation à partir de textes mathématiques.


<!--
### Higher dimensional convolution

For two dimensional inputs such as images, we make use of the two dimensional version of convolution:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->

### Convolution de dimensions supérieures

Pour les entrées bidimensionnelles telles que les images, nous utilisons la version bidimensionnelle de la convolution :

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

Cette définition peut facilement être étendue au-delà de deux dimensions à trois ou quatre dimensions. Ici, $w$ est appelé le **noyau de convolution**.

<!--
### Regular twists that can be made with the convolutional operator in DCNNs

1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:

| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |


2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.
-->

### Les torsions de base qui peuvent être réalisées avec l'opérateur convolutif dans les ConvNets profonds

- **Décalage** (*striding*) : au lieu de décaler la fenêtre en $x$ une entrée à la fois, on peut le faire avec un pas plus grand (par exemple deux ou trois entrées à la fois).
Exemple : supposons que l'entrée $x$ soit unidimensionnelle et ait une taille de $100$ et que $w$ ait une taille de $5$. La taille de la sortie avec un pas de $1$ ou $2$ est indiquée dans le tableau ci-dessous :

| Pas          | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Taille de la sortie: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |



- **Remplissage** (*padding*) : très souvent, dans la conception des architectures de réseaux neuronaux profonds, nous voulons que la sortie de la convolution soit de la même taille que l'entrée. Cela peut être réalisé en ajoutant aux extrémités de l'entrée un certain nombre d'entrées (généralement) nulles, généralement des deux côtés. Le remplissage se fait surtout par commodité. Il peut parfois avoir un impact sur les performances et entraîner d'étranges effets de bord, cela dit, lorsqu'on utilise une non-linéarité *ReLU*, le remplissage avec des zéros n'est pas déraisonnable.

<!--
## Deep Convolution Neural Networks (DCNNs)

As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.

The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.

Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Figure 10. Feature visualization of convolutional net trained on ImageNet from [Zeiler & Fergus 2013]</center>


This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.

The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:

> The most incomprehensible thing about the universe is that it is comprehensible.

The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:

> The world is compositional or God exists.
-->


## ConvNets profonds

Comme décrit précédemment, les réseaux neuronaux profonds sont généralement organisés sous forme d'alternance répétée entre des opérateurs linéaires et des couches de non-linéarité ponctuelles. Dans les réseaux neuronaux convolutifs, l'opérateur linéaire sera l'opérateur de convolution décrit ci-dessus. Il existe également un troisième type de couche optionnelle appelée couche d’agrégation (*pooling layer*).

La raison de l'empilement de plusieurs couches de ce type est que nous voulons construire une représentation hiérarchique des données. Les ConvNets ne doivent pas être limités au traitement des images, ils ont également été appliqués avec succès à la parole et au langage. Techniquement, ils peuvent être appliqués à tout type de données qui se présentent sous la forme de tableaux, bien que nous ayons également ces tableaux pour satisfaire certaines propriétés.

Pourquoi voudrions-nous saisir la représentation hiérarchique du monde ? Parce que le monde dans lequel nous vivons est compositionnel. Ce point est évoqué dans les sections précédentes. Cette nature hiérarchique peut être observée à partir du fait que les pixels locaux s'assemblent pour former des motifs simples tels que des bords orientés. Ces bords sont à leur tour assemblés pour former des caractéristiques locales telles que des coins, des jonctions en T, etc. Ces bords sont assemblés pour former des motifs encore plus abstraits. Ces bords sont assemblés pour former des motifs encore plus abstraits. Nous pouvons continuer à nous appuyer sur ces représentations hiérarchiques pour finalement former les objets que nous observons dans le monde réel.

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35% ;" /><br>
  <b>Figure 10 :</b> Visualisation des caractéristiques d'un réseau convolutif entraîné sur ImageNet d'après Zeiler & Fergus (2013)</center>


Cette nature compositionnelle et hiérarchique que nous observons dans le monde naturel n'est donc pas seulement le résultat de notre perception visuelle, mais est aussi vraie au niveau physique. Au niveau le plus bas de la description, nous avons des particules élémentaires, qui s'assemblent pour former des atomes, les atomes forment ensemble des molécules, nous continuons à nous appuyer sur ce processus pour former des matériaux, des parties d'objets et finalement des objets complets dans le monde physique.

La nature compositionnelle du monde pourrait être la réponse à la question rhétorique d'Einstein sur la façon dont les humains comprennent le monde dans lequel ils vivent : ***« La chose la plus incompréhensible à propos de l'univers est qu'il est compréhensible »***.

Le fait que les humains comprennent le monde grâce à cette nature compositionnelle semble être une conspiration pour Yann. Il avance que sans cette compositionnalité, il faudrait encore plus de magie pour que les humains comprennent le monde dans lequel ils vivent. Il cite le mathématicien Stuart Geman : ***« Le monde est composé ou Dieu existe »***.


<!--
## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">Figure 11. Simon Thorpe's model of visual information flow in the brain <div>

Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.

Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.

These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.

One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">Figure 12. Gallen & Van Essen's model of dorsal & ventral pathways in the brain <div>

The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).
-->

## [Inspirations de la biologie](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

Alors pourquoi l'apprentissage profond devrait-il être ancré dans l'idée que notre monde est compréhensible et a une nature compositionnelle ? Les recherches menées par Simon Thorpe ont contribué à motiver cette idée. Il a montré que la façon dont nous reconnaissons les objets quotidiens est extrêmement rapide. Ses expériences ont consisté à faire clignoter un ensemble d'images toutes les 100 ms, puis à demander aux utilisateurs d'identifier ces images, ce qu'ils ont réussi à faire. Cela a montré qu'il faut environ 100 ms aux humains pour détecter des objets. En outre, le diagramme ci-dessous illustre des parties du cerveau annotées du temps que mettent les neurones à se propager d'une zone à l'autre :

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center"><b>Figure 11 :</b> Modèle du flux d'informations visuelles dans le cerveau de Simon Thorpe </div>
  

Les signaux passent de la rétine au corps géniculé latéral (LGN sur la figure 11) qui aide à l'amélioration du contraste, au contrôle des portes, etc., puis au cortex visuel primaire V1, V2, V4, puis au cortex inférotemporel (PIT), qui est la partie du cerveau où les catégories sont définies. Les observations en chirurgie à cerveau ouvert ont montré que si vous montrez un film à un humain, les neurones du PIT ne se déclenchent que lorsqu'ils détectent certaines images (comme Jennifer Aniston ou la grand-mère d'une personne par exemple) et rien d'autre. Les déclenchements neuronaux sont invariables en fonction de la position, de la taille, de l'éclairage, de l'orientation de votre grand-mère, de ce qu'elle porte, etc.

De plus, le temps de réaction extrêmement rapide avec lequel les humains ont pu classer ces éléments (à peine assez de temps pour que quelques décharges passent) démontre qu'il est possible de le faire sans passer de temps supplémentaire sur des calculs complexes et récurrents. Il s'agit plutôt d'un processus *feed-forward* unique.

Ces idées ont suggéré que nous pourrions développer une architecture de réseau neuronal qui soit complètement *feed-forward*, tout en étant capable de résoudre le problème de la reconnaissance, d'une manière qui soit invariante aux transformations non pertinentes de l'entrée.

Gallant & Van Essen, dont le modèle du cerveau humain illustre deux voies distinctes, nous donnent un autre aperçu de ce dernier :

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55% ;" /></center>

<div align="center"><b>Figure 12 :</b> Modèle de Gallen & Van Essen des voies dorsales et ventrales dans le cerveau </div>

Le côté droit montre la voie ventrale, qui vous indique ce que vous regardez, tandis que le côté gauche montre la voie dorsale, qui identifie les emplacements, la géométrie et le mouvement. Ils semblent assez séparés dans le cortex visuel de l'homme et des primates (avec quelques interactions entre eux bien sûr).


<!--
### Hubel & Weisel's contributions (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">Figure 13. Hubel & Weisel's experiments with visual stimuli in cat brains </div>

Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.

They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".

Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.
-->

### Les contributions de Hubel & Weisel (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55% ;" /></center>

<div align="center"><b>Figure 13 :</b> Expériences de Hubel & Weisel sur les stimuli visuels dans le cerveau des chats </div>

Dans leurs expériences, Hubel et Weisel ont utilisé des électrodes pour mesurer les tirs neuronaux dans le cerveau des chats en réponse à des stimuli visuels. Ils ont découvert que les excitations neuronales de la région V1 ne sont sensibles qu'à certaines zones d'un champ visuel (appelées *champs réceptifs*) et détectent des bords orientés dans cette zone. Par exemple, ils ont démontré que si on montre au chat une barre verticale et commençons à la faire tourner, le neurone se déclenchera à un angle particulier. De même, à mesure que la barre s'éloigne de cet angle, l'activation du neurone diminue. Ces neurones à activation sélective, Hubel & Weisel les ont nommés « cellules simples » pour leur capacité à détecter des caractéristiques locales.

Ils ont également découvert que si on déplace la barre hors du champ de réception, ce neurone particulier ne s'active plus, mais un autre neurone le fera. Il existe des détecteurs de caractéristiques locales correspondant à toutes les zones du champ visuel, d'où l'idée que le cerveau humain traite les informations visuelles comme un ensemble de convolutions.

Un autre type de neurone, qu'ils ont appelé « cellules complexes », regroupe la sortie de plusieurs cellules simples dans une certaine zone. On peut considérer qu'elles calculent un agrégat des activations en utilisant une fonction telle que maximum, somme, somme des carrés, ou toute autre fonction ne dépendant pas de l'ordre. Ces cellules complexes détectent les bords et les orientations dans une région, indépendamment de l'endroit où ces stimuli se trouvent spécifiquement dans la région. En d'autres termes, elles sont invariantes par rapport aux petites variations de positions de l'entrée.

<!--
### Fukushima's contributions (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">Figure 14. Fukushima's CNN model </div>

Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.

Yann Le Cun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)
-->

### Les contributions de Fukushima (1982)
<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55% ;" /></center>
<div align="center"><b>Figure 14 :</b> Le modèle de Fukushima </div>

Fukushima a été le premier à mettre en œuvre, avec des modèles informatiques, l'idée de couches multiples de cellules simples et de cellules complexes. Certains de ces détecteurs de caractéristiques ont été fabriqués à la main ou appris, bien que l'apprentissage ait utilisé des algorithmes de clustering non supervisés, entraînés séparément pour chaque couche, car la rétropropagation n'était pas encore utilisée.
Yann Le Cun est arrivé quelques années plus tard (1989 et 1998) et a mis en place la même architecture, mais cette fois-ci, avec un entraînement supervisé utilisant la rétropropagation. Cette méthode est largement considérée comme la genèse des réseaux neuronaux convolutifs modernes. A noter que Riesenhuber du MIT a également redécouvert cette architecture en 1999, bien qu'il n'ait pas utilisé la rétropropagation.
